#!/usr/bin/python
from weblive import WebLive

wl=WebLive('https://weblive.stgraber.org/weblive/json',True)

all_packages={}

for server in wl.list_everything():
    for package in server.packages:
        if not package.pkgname in all_packages:
            all_packages[package.pkgname]={}
        if not package.version in all_packages[package.pkgname]:
            all_packages[package.pkgname][package.version]=[]
        all_packages[package.pkgname][package.version].append(server.name)

print """
<html>
    <head>
        <title>Packages available on WebLive</title>
    </head>
    <body>
        <ul>
"""
for package in sorted(all_packages):
    print "<li>%s<ul>" % package
    for version in all_packages[package]:
        print "<li>%s (%s)</li>" % (version, ", ".join(all_packages[package][version]))
    print "</ul></li>"
print """
        </ul>
    </body>
</html>
"""
