// RUN: %clang_cc1 -triple x86_64-apple-darwin -fblocks -emit-llvm -o - %s | FileCheck %s

@interface NSObject
+ (id) new;
- (id) init;
@end

@interface Base : NSObject @end

// @implementation Base
// {
//     int dummy;
// }
// @end

@interface Derived : Base
{
    @public int member;
}
@end

@implementation Derived
- (id) init
{
    self = [super init];
    member = 42;
    return self;
}
@end

// CHECK: define internal i8* @"\01-[Derived init]"
// CHECK: [[IVAR:%.*]] = load i64, i64* @"OBJC_IVAR_$_Derived.member", !invariant.load

void * variant_load_1(int i) {
    void *ptr;
    while (i--) {
        Derived *d = [Derived new];
        ptr = &d->member;
    }
    return ptr;
}

// CHECK-LABEL: define i8* @variant_load_1(i32 %i)
// CHECK: [[IVAR:%.*]] = load i64, i64* @"OBJC_IVAR_$_Derived.member"{{$}}

@interface Container : Derived @end
@implementation Container
- (void *) invariant_load_1
{
    return &self->member;
}
@end

// CHECK: define internal i8* @"\01-[Container invariant_load_1]"
// CHECK: [[IVAR:%.*]] = load i64, i64* @"OBJC_IVAR_$_Derived.member", !invariant.load

@interface ForBlock
{ 
@public
  id foo; 
}
@end

// CHECK-LABEL: define internal i8* @block_block_invoke
// CHECK: load i64, i64* @"OBJC_IVAR_$_ForBlock.foo"
id (^block)(ForBlock*) = ^(ForBlock* a) {
  return a->foo;
};
