; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -passes=openmp-opt < %s | FileCheck %s
target triple = "nvptx64"

%struct.ident_t = type { i32, i32, i32, i32, ptr }

@is_spmd_exec_mode = weak constant i8 0
@will_be_spmd_exec_mode = weak constant i8 1
@non_spmd_exec_mode = weak constant i8 1
@will_not_be_spmd_exec_mode = weak constant i8 1
@G = external global i8
@llvm.compiler.used = appending global [4 x ptr] [ptr @is_spmd_exec_mode, ptr @will_be_spmd_exec_mode, ptr @non_spmd_exec_mode, ptr @will_not_be_spmd_exec_mode ], section "llvm.metadata"

;.
; CHECK: @[[IS_SPMD_EXEC_MODE:[a-zA-Z0-9_$"\\.-]+]] = weak constant i8 0
; CHECK: @[[WILL_BE_SPMD_EXEC_MODE:[a-zA-Z0-9_$"\\.-]+]] = weak constant i8 3
; CHECK: @[[NON_SPMD_EXEC_MODE:[a-zA-Z0-9_$"\\.-]+]] = weak constant i8 1
; CHECK: @[[WILL_NOT_BE_SPMD_EXEC_MODE:[a-zA-Z0-9_$"\\.-]+]] = weak constant i8 1
; CHECK: @[[G:[a-zA-Z0-9_$"\\.-]+]] = external global i8
; CHECK: @[[LLVM_COMPILER_USED:[a-zA-Z0-9_$"\\.-]+]] = appending global [4 x ptr] [ptr @is_spmd_exec_mode, ptr @will_be_spmd_exec_mode, ptr @non_spmd_exec_mode, ptr @will_not_be_spmd_exec_mode], section "llvm.metadata"
;.
define weak void @is_spmd() {
; CHECK-LABEL: define {{[^@]+}}@is_spmd() {
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr null, i8 2, i1 false)
; CHECK-NEXT:    call void @is_spmd_helper1()
; CHECK-NEXT:    call void @is_spmd_helper2()
; CHECK-NEXT:    call void @is_mixed_helper()
; CHECK-NEXT:    call void @__kmpc_target_deinit(ptr null, i8 2)
; CHECK-NEXT:    ret void
;
  %i = call i32 @__kmpc_target_init(ptr null, i8 2, i1 false)
  call void @is_spmd_helper1()
  call void @is_spmd_helper2()
  call void @is_mixed_helper()
  call void @__kmpc_target_deinit(ptr null, i8 2)
  ret void
}

define weak void @will_be_spmd() {
; CHECK-LABEL: define {{[^@]+}}@will_be_spmd() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 8
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr null, i8 2, i1 false)
; CHECK-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[I]], -1
; CHECK-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; CHECK:       common.ret:
; CHECK-NEXT:    ret void
; CHECK:       user_code.entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr null) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    call void @is_spmd_helper2()
; CHECK-NEXT:    call void @__kmpc_parallel_51(ptr null, i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__, ptr @__omp_outlined___wrapper, ptr [[CAPTURED_VARS_ADDRS]], i64 0)
; CHECK-NEXT:    call void @__kmpc_target_deinit(ptr null, i8 2)
; CHECK-NEXT:    ret void
;
entry:
  %captured_vars_addrs = alloca [0 x ptr], align 8
  %i = call i32 @__kmpc_target_init(ptr null, i8 1, i1 true)
  %exec_user_code = icmp eq i32 %i, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:
  ret void

user_code.entry:
  %0 = call i32 @__kmpc_global_thread_num(ptr null)
  call void @is_spmd_helper2()
  call void @__kmpc_parallel_51(ptr null, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__, ptr @__omp_outlined___wrapper, ptr %captured_vars_addrs, i64 0)
  call void @__kmpc_target_deinit(ptr null, i8 1)
  ret void
}

define weak void @non_spmd() {
; CHECK-LABEL: define {{[^@]+}}@non_spmd() {
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr null, i8 1, i1 false)
; CHECK-NEXT:    call void @is_generic_helper1()
; CHECK-NEXT:    call void @is_generic_helper2()
; CHECK-NEXT:    call void @is_mixed_helper()
; CHECK-NEXT:    call void @__kmpc_target_deinit(ptr null, i8 1)
; CHECK-NEXT:    ret void
;
  %i = call i32 @__kmpc_target_init(ptr null, i8 1, i1 false)
  call void @is_generic_helper1()
  call void @is_generic_helper2()
  call void @is_mixed_helper()
  call void @__kmpc_target_deinit(ptr null, i8 1)
  ret void
}

define weak void @will_not_be_spmd() {
; CHECK-LABEL: define {{[^@]+}}@will_not_be_spmd() {
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr null, i8 1, i1 false)
; CHECK-NEXT:    call void @is_generic_helper1()
; CHECK-NEXT:    call void @is_generic_helper2()
; CHECK-NEXT:    call void @is_mixed_helper()
; CHECK-NEXT:    call void @__kmpc_target_deinit(ptr null, i8 1)
; CHECK-NEXT:    ret void
;
  %i = call i32 @__kmpc_target_init(ptr null, i8 1, i1 false)
  call void @is_generic_helper1()
  call void @is_generic_helper2()
  call void @is_mixed_helper()
  call void @__kmpc_target_deinit(ptr null, i8 1)
  ret void
}

define internal void @is_spmd_helper1() {
; CHECK-LABEL: define {{[^@]+}}@is_spmd_helper1() {
; CHECK-NEXT:    store i8 1, ptr @G, align 1
; CHECK-NEXT:    ret void
;
  %isSPMD = call i8 @__kmpc_is_spmd_exec_mode()
  store i8 %isSPMD, ptr @G
  ret void
}

define internal void @is_spmd_helper2() {
; CHECK-LABEL: define {{[^@]+}}@is_spmd_helper2() {
; CHECK-NEXT:    br label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    unreachable
; CHECK:       f:
; CHECK-NEXT:    ret void
;
  %isSPMD = call i8 @__kmpc_is_spmd_exec_mode()
  %c = icmp eq i8 %isSPMD, 0
  br i1 %c, label %t, label %f
t:
  call void @spmd_compatible()
  ret void
f:
  ret void
}

define internal void @is_generic_helper1() {
; CHECK-LABEL: define {{[^@]+}}@is_generic_helper1() {
; CHECK-NEXT:    store i8 0, ptr @G, align 1
; CHECK-NEXT:    ret void
;
  %isSPMD = call i8 @__kmpc_is_spmd_exec_mode()
  store i8 %isSPMD, ptr @G
  ret void
}

define internal void @is_generic_helper2() {
; CHECK-LABEL: define {{[^@]+}}@is_generic_helper2() {
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 0, 0
; CHECK-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    call void @foo()
; CHECK-NEXT:    ret void
; CHECK:       f:
; CHECK-NEXT:    call void @bar()
; CHECK-NEXT:    ret void
;
  %isSPMD = call i8 @__kmpc_is_spmd_exec_mode()
  %c = icmp eq i8 %isSPMD, 0
  br i1 %c, label %t, label %f
t:
  call void @foo()
  ret void
f:
  call void @bar()
  ret void
}

define internal void @is_mixed_helper() {
; CHECK-LABEL: define {{[^@]+}}@is_mixed_helper() {
; CHECK-NEXT:    [[ISSPMD:%.*]] = call i8 @__kmpc_is_spmd_exec_mode()
; CHECK-NEXT:    store i8 [[ISSPMD]], ptr @G, align 1
; CHECK-NEXT:    ret void
;
  %isSPMD = call i8 @__kmpc_is_spmd_exec_mode()
  store i8 %isSPMD, ptr @G
  ret void
}

define internal void @__omp_outlined__(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; CHECK-LABEL: define {{[^@]+}}@__omp_outlined__
; CHECK-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  ret void
}

define internal void @__omp_outlined___wrapper(i16 zeroext %0, i32 %1) {
; CHECK-LABEL: define {{[^@]+}}@__omp_outlined___wrapper
; CHECK-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  ret void
}

declare void @spmd_compatible() "llvm.assume"="ompx_spmd_amenable"
declare i8 @__kmpc_is_spmd_exec_mode()
declare i32 @__kmpc_target_init(ptr, i8, i1 zeroext)
declare void @__kmpc_target_deinit(ptr nocapture readnone, i8)
declare void @__kmpc_parallel_51(ptr, i32, i32, i32, i32, ptr, ptr, ptr, i64)
declare i32 @__kmpc_global_thread_num(ptr)
declare void @foo()
declare void @bar()

!llvm.module.flags = !{!0, !1}
!nvvm.annotations = !{!2, !3, !4, !5}

!0 = !{i32 7, !"openmp", i32 50}
!1 = !{i32 7, !"openmp-device", i32 50}
!2 = !{ptr @is_spmd, !"kernel", i32 1}
!3 = !{ptr @will_be_spmd, !"kernel", i32 1}
!4 = !{ptr @non_spmd, !"kernel", i32 1}
!5 = !{ptr @will_not_be_spmd, !"kernel", i32 1}
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { "llvm.assume"="ompx_spmd_amenable" }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { alwaysinline }
; CHECK: attributes #[[ATTR2]] = { nounwind }
;.
; CHECK: [[META0:![0-9]+]] = !{i32 7, !"openmp", i32 50}
; CHECK: [[META1:![0-9]+]] = !{i32 7, !"openmp-device", i32 50}
; CHECK: [[META2:![0-9]+]] = !{ptr @is_spmd, !"kernel", i32 1}
; CHECK: [[META3:![0-9]+]] = !{ptr @will_be_spmd, !"kernel", i32 1}
; CHECK: [[META4:![0-9]+]] = !{ptr @non_spmd, !"kernel", i32 1}
; CHECK: [[META5:![0-9]+]] = !{ptr @will_not_be_spmd, !"kernel", i32 1}
;.
