#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>

#ifdef GSM
#	include <gsm.h>
#endif
#include "wav_lib.h"
#include "version.h"
#include "tellhow.h"
#include "timer.h"

wav_sig *file_info;
int count;
int have_len;

//SignalHandler *old_sigint;

/* GSM stuff */

#ifdef GSM

struct{
	gsm handle;
	gsm_frame buf;
	gsm_signal sample[160];
} gsm_info;

#endif

void tellhow(char *argv[]){
	printf(BRAG, MAJ, MIN);
	printf(WAVR,argv[0]);
}

void report(){
	printf(BRAG,MAJ,MIN);
	printf(RECORDING,
	file_info->name, 
	file_info->len,
	file_info->srate, 
	file_info->bps,
	file_info->depth,
	file_info->chans);
}

int set_source(char source){
	int i, p, mix_fd;
	
	if (source == 'c')
		p = 1 << SOUND_MIXER_CD;
	if (source == 'l')
		p = 1 << SOUND_MIXER_LINE;
	if (source == 'm')
		p = 1 << SOUND_MIXER_MIC;
	
	mix_fd = open("/dev/mixer", O_WRONLY, 0);
	i = ioctl(mix_fd, SOUND_MIXER_WRITE_RECSRC, &p);
	close(mix_fd);
	return(i);
}

void init_default(wav_sig *file_info){
	file_info->depth = 8;
	file_info->chans = 1;
	file_info->srate = 8000;
	strcpy(file_info->name, "untitled.wav");
}


int init_dsp(wav_sig *file_info){
	int i, p;
	
	dsp_fd = open("/dev/dsp", O_RDONLY, 0);
	if (dsp_fd == -1){
		fprintf(stderr,"Cannot open /dev/dsp.  Do you have permision?\n");
		return(dsp_fd);
	} else { 
		ioctl(dsp_fd, SNDCTL_DSP_RESET, 0);

		p =  file_info->depth;
		i =  ioctl(dsp_fd, SNDCTL_DSP_SAMPLESIZE, &p);
	
		p =  file_info->chans;
		i += ioctl(dsp_fd, SNDCTL_DSP_CHANNELS, &p);
	
		p =  file_info->srate;
		i += ioctl(dsp_fd, SNDCTL_DSP_SPEED, &p);
		
		i += ioctl(dsp_fd, SNDCTL_DSP_GETBLKSIZE, &bsize);
		
		
		ioctl(dsp_fd, SNDCTL_DSP_SYNC, 0);
		
		return(i);
	}		
}

int init_parm(int argc, char *argv[], wav_sig *file_info){
	int i;
	for (i = 1; i < argc; i++){

		if (strcmp(argv[i], "-d") == 0)
			file_info->depth = atoi(argv[i + 1]);
		if (strcmp(argv[i], "-c") == 0)
	 		file_info->chans = atoi(argv[i + 1]);
	 	if (strcmp(argv[i], "-r") == 0)
	 		file_info->srate = atoi(argv[i + 1]);
		if (strcmp(argv[i], "-f") == 0)
			strcpy(file_info->name, argv[i + 1]);
		if (strcmp(argv[i], "-l") == 0){
			file_info->len   = atoi(argv[i + 1]);
			have_len = TRUE;
		}
		if (strcmp(argv[i], "-s") == 0){
			if (set_source((char)*argv[i + 1]) == -1)
			fprintf(stderr,"Error initializing MIXER\n");
		}
	}
	return(0);
}

void write_data(){

#ifndef GSM

	if ((have_len && file_info->len > bsize) || !have_len) count = read(dsp_fd, buffer, bsize);
	else count = read(dsp_fd, buffer, file_info->len);

	write(file_info->handle, buffer, count);
	file_info->len -= count;
	file_info->sofar += count;

#else
	if ((have_len && file_info->len > sizeof(gsm_info.sample)) || !have_len) count = read(dsp_fd, gsm_info.sample, sizeof(gsm_info.sample));
	
	gsm_encode(gsm_info.handle, gsm_info.sample, gsm_info.buf);
	write(file_info->handle, (char *)gsm_info.buf, sizeof(gsm_info.buf));

	file_info->len -= count;
	file_info->sofar += count;
	
#endif

}

void SIG_INT(sig)
int sig;
{
	lseek(file_info->handle, 0, SEEK_SET);
	init_head(file_info);
	write(file_info->handle, file_info->head, 44);

	puts("\n");
	exit(1);
}


int main(int argc, char *argv[]){
	int i;
	
	have_len = FALSE;
	file_info = (wav_sig *)malloc(sizeof(wav_sig));
	
	init_default(file_info);
	
	if (argc > 1) init_parm(argc, argv, file_info);
	else{ 
		tellhow(argv);
		exit(-1);
	}
	
	file_info->len *= (file_info->depth / 8)
			* file_info->srate 
			* file_info->chans;
			
	file_info->bps  = (file_info->depth / 8)
			* file_info->srate 
			* file_info->chans;

	file_info->blkalign = file_info->chans
			* (file_info->depth / 8);
		
	if (init_dsp(file_info) == -1){
		fprintf(stderr,"Error initializing DSP\n");
		exit(-1);
	}
	
	if (open_wav_rec(file_info) == -1){
		fprintf(stderr,"Error writing file: %s\n", file_info->name);
		exit(-1);
	}

	buffer = (int *)malloc(bsize);
	
	//old_sigint = (SignalHandler *)
  	signal(SIGINT, SIG_INT);
 
	report(file_info);

#ifdef GSM
	gsm_info.handle = gsm_create();
#endif
	while((have_len && file_info->len > 0) || !have_len){
		write_data();
		update_timer(file_info, 0);
	}
	
	rewrite_head(file_info);

#ifdef GSM
	gsm_destroy(gsm_info.handle);
#endif
	close(dsp_fd);
	close(file_info->handle);
	puts("\n");
}



