/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.LisaacConfiguration;
import org.lisaac.ldt.editors.LisaacDocumentProvider;
import org.lisaac.ldt.views.LisaacOutlineView;

public class AbstractLisaacEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager(LisaacPlugin.getDefault().getPreferenceStore());
    private LisaacOutlineView outlineView;
    private ProjectionSupport projectionSupport;
    private Annotation[] oldAnnotations;
    private ProjectionAnnotationModel annotationModel;

    public AbstractLisaacEditor() {
        this.setSourceViewerConfiguration(new LisaacConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new LisaacDocumentProvider());
        IPreferenceStore store = LisaacPlugin.getDefault().getPreferenceStore();
        store.setDefault("AbstractTextEditor.Accessibility.UseCustomCarets", true);
        store.setDefault("AbstractTextEditor.Accessibility.WideCaret", true);
        store = this.getChainedPreferenceStore();
        this.setPreferenceStore(store);
    }

    private IPreferenceStore getChainedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>();
        stores.add(LisaacPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[0]));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList positions) {
        if (this.annotationModel == null) {
            return;
        }
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap newAnnotations = new HashMap();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    public void removeFoldingStructure() {
        this.annotationModel.removeAllAnnotations();
    }

    public IDocument getDocument() {
        if (this.getDocumentProvider() == null) {
            return null;
        }
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        MyResources ressources = new MyResources();
        ContentAssistAction action = new ContentAssistAction((ResourceBundle)ressources, "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorManager.handlePreferenceStoreChanged(event);
        super.handlePreferenceStoreChanged(event);
        String prop = event.getProperty();
        if (prop.equals("lisaac_competion_delay")) {
            Integer delay;
            IContentAssistant assistant = this.getSourceViewerConfiguration().getContentAssistant(this.getSourceViewer());
            try {
                delay = Integer.valueOf((String)event.getNewValue());
            }
            catch (Exception exception) {
                delay = 500;
            }
            ((ContentAssistant)assistant).setAutoActivationDelay(delay.intValue());
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorManager.affectsTextPresentation(event);
    }

    public void refreshPresentation() {
        IDocument document = this.getDocument();
        if (document != null) {
            this.refreshPresentation(0, document.getLength());
        }
    }

    public void refreshPresentation(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 ext = (ITextViewerExtension2)viewer;
            ext.invalidateTextPresentation(offset, length);
        }
    }

    public IProject getProject() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            IFile file = (IFile)((FileEditorInput)editorInput).getAdapter(IFile.class);
            return file.getProject();
        }
        return null;
    }

    public String getFileName() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            IFile file = (IFile)((FileEditorInput)editorInput).getAdapter(IFile.class);
            return file.getName();
        }
        return null;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlineView == null) {
                this.outlineView = new LisaacOutlineView(this.getDocumentProvider(), (AbstractDecoratedTextEditor)this);
            }
            return this.outlineView;
        }
        return super.getAdapter(required);
    }

    public static class MyResources
    extends ListResourceBundle {
        static final Object[][] contents = new Object[][]{{"CorrectionAssist", "CorrectionAssist"}, {"ContentAssistProposal", "ContentAssistProposal"}, {"TemplateProposals", "TemplateProposals"}};

        public Object[][] getContents() {
            return contents;
        }
    }
}

