package junit.test.svg;

import java.text.ParseException;

import junit.framework.TestCase;
import latexDraw.parsers.svg.elements.path.SVGPathSeg;
import latexDraw.parsers.svg.elements.path.SVGPathSegArc;
import latexDraw.parsers.svg.elements.path.SVGPathSegMoveto;
import latexDraw.parsers.svg.elements.path.SVGPathSeg.PathSeg;
import latexDraw.parsers.svg.parsers.SVGPathHandler;
import latexDraw.parsers.svg.parsers.SVGPathParser;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPathSegArc class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/22/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPathSegArc extends TestCase implements SVGPathHandler
{
	protected final SVGPathSegArc seg = new SVGPathSegArc(1, 2, 3, 4, 5, true, false, true);
	protected int cpt = 0;
	
	@Test
	public void testGetters()
	{
		SVGPathSegArc seg2 = new SVGPathSegArc(1, 2, 3, 4, 5, false, true, false);
		
		assertEquals(seg.getAngle(), 5.);
		assertEquals(seg.getRX(), 3.);
		assertEquals(seg.getRY(), 4.);
		assertEquals(seg.getX(), 1.);
		assertEquals(seg.getY(), 2.);
		assertTrue(seg.isLargeArcFlag());
		assertFalse(seg.isSweepFlag());
		assertTrue(seg.isRelative());
		assertFalse(seg2.isLargeArcFlag());
		assertTrue(seg2.isSweepFlag());
		assertFalse(seg2.isRelative());
		assertEquals(seg.getType(), PathSeg.ARC_REL);
		assertEquals(seg2.getType(), PathSeg.ARC_ABS);
	}
	
	
	@Test
	public void testToString()
	{
		SVGPathSegMoveto m = new SVGPathSegMoveto(0, 0, false);
		SVGPathParser parser = new SVGPathParser(m.toString() + " " + seg.toString(), this);
		
		try { parser.parse(); }
		catch(ParseException e) { fail(); }
	}


	public void onPathSeg(SVGPathSeg pathSeg)
	{
		if((pathSeg instanceof SVGPathSegMoveto) && cpt==0)
		{
			cpt++;
			return ;
		}
		
		assertTrue(pathSeg instanceof SVGPathSegArc);
		
		SVGPathSegArc seg2 = (SVGPathSegArc)pathSeg;
		
		assertEquals(seg.getAngle(), seg2.getAngle());
		assertEquals(seg.getRX(), seg2.getRX());
		assertEquals(seg.getRY(), seg2.getRY());
		assertEquals(seg.getX(), seg2.getX());
		assertEquals(seg.getY(), seg2.getY());
		assertEquals(seg.isLargeArcFlag(), seg2.isLargeArcFlag());
		assertEquals(seg.isRelative(), seg2.isRelative());
		assertEquals(seg.isSweepFlag(), seg2.isSweepFlag());
	}
}
