/*
 * TestColorButton.java
 */

package junit.test;


import java.awt.Color;

import junit.framework.TestCase;
import latexDraw.ui.components.ButtonIcon;
import latexDraw.ui.components.ColorButton;

import org.junit.Before;
import org.junit.Test;



/** 
 * This class contains tests on the class ColorButton.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 06/26/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestColorButton extends TestCase
{
	private ColorButton	cb1;

	private ColorButton	cb2;

	private final Color	c		= new Color(100, 100, 100);


	@Override
	@Before
	public void setUp()
	{
		ButtonIcon bi = new ButtonIcon(c);

		cb1 = new ColorButton("coucou");
		cb2 = new ColorButton(bi);
		assertEquals(c, cb2.getColor());
	}



	@Test
	public void testGetSetColor()
	{
		cb2.setColor(c);
		assertEquals(c, cb2.getColor());
		assertNull(cb1.getColor());
	}

}
