% L2TPNS(8) Layer 2 tunneling protocol network server (LNS)
% This manual page was written by Jonathan McDowell <noodles@earth.li> and Fernando Alves (<fendo@sameswifi.fr>), for the Debian GNU/Linux system (but may be used by others)
% January 31, 2021

# NAME

l2tpns - Layer 2 tunneling protocol network server (LNS)

# SYNOPSIS

**l2tpns** \[-**d**\] \[-**v**\] \[-**c** _file_\] \[-**h** _hostname_\]

# DESCRIPTION

**l2tpns** is a daemon for terminating layer 2 tunneling protocol (L2TP: RFC2661) sessions.

**l2tpns** is a complete L2TP implementation. It supports the LAC, LNS, PPPOE and DHCPv6 server.

Once running, **l2tpns** may be controlled by telnetting to port 23 on the machine running the daemon and with the **nsctl** utility.

# OPTIONS

  **-d**	Detach from terminal and fork into the background. By default l2tpns will stay in the foreground

  **-v**	Increase verbosity for debugging. Can be used multiple times

  **-c** _file_
    Specify configuration file

  **-h** _hostname_
    Force hostname to _hostname_

# FILES

_/etc/l2tpns/startup-config_  
    The default configuration file

_/etc/l2tpns/ip\_pool_  
    IP address pool configuration

_/etc/l2tpns/users_  
    Username/password configuration for access to admin interface

# SIGNALS

**SIGHUP**  
Reload the config from disk and re-open log file

**SIGTERM**, **SIGINT**  
    Stop process. Tunnels and sessions are not terminated. This signal should be used to stop l2tpns on a cluster node where there are other machines to continue handling traffic

**SIGQUIT**  
    Shut down tunnels and sessions, exit process when complete

# MANAGED RADIUS ATTRIBUTE

**Ascend-Client-Primary-DNS**, **Ascend-Client-Secondary-DNS**  
    Specifies a primary and secondary DNS server address to send to user

**Delegated-IPv6-Prefix**  
    Assign a network address IPv6 prefix to a user by DHCPv6

**Framed-IP-Address**  
    The address to be configured for the user (IPv4 address of the interface ppp)

**Framed-Route**  
    provides routing information to be configured for the user

**Framed-IPv6-Route**  
    Has the same action as **Delegated-IPv6-Prefix**. **Delegated-IPv6-Prefix** is the correct one to use

**Framed-IPv6-Address**  
    IPv6 address to be assigned to the user by DHCPv6 (IPv6 address of the interface ppp)

**Idle-Timeout**  
    disconnects the session if no data for more than **Idle-Timeout** (in seconds)

**Session-Timeout**  
    disconnects the user session when the time **Session-Timeout** is reached (in seconds)

**Tunnel-Type**, **Tunnel-Medium-Type**, **Tunnel-Server-Endpoint**, **Tunnel-Password**, **Tunnel-Assignment-Id**  
    attributes returned by the Radius of the remote LNS server (LAC functionality)

    example, Radius that return the information of 2 remote LNS server with which must be open a L2TP TUNNEL:

    - Tunnel-Type: 1 = L2TP
    - Tunnel-Medium-Type: 1 = IPv4
    - Tunnel-Password: 1 = "TheSecretL2TP"
    - Tunnel-Server-Endpoint: 1 = "88.xx.xx.x1"
    - Tunnel-Assignment-Id: 1 = "friendisp_lns1"
    - Tunnel-Type: 2 = L2TP
    - Tunnel-Medium-Type: 2 = IPv4
    - Tunnel-Password: 2 = "TheSecretL2TP"
    - Tunnel-Server-Endpoint: 2 = "88.xx.xx.x2"
    - Tunnel-Assignment-Id: 2 = "friendisp_lns2"

# SEE ALSO

**startup-config**(5), **nsctl**(8)
