/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.checkers.javac;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class DiagnosticsUsingJavacTestGenerated extends AbstractDiagnosticsUsingJavacTest {
    @TestMetadata("compiler/testData/diagnostics/tests")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Tests extends AbstractDiagnosticsUsingJavacTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("Abstract.kt")
        public void testAbstract() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Abstract.kt");
        }

        @TestMetadata("AbstractAccessor.kt")
        public void testAbstractAccessor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractAccessor.kt");
        }

        @TestMetadata("AbstractInAbstractClass.kt")
        public void testAbstractInAbstractClass() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInAbstractClass.kt");
        }

        @TestMetadata("AbstractInClass.kt")
        public void testAbstractInClass() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInClass.kt");
        }

        @TestMetadata("AbstractInTrait.kt")
        public void testAbstractInTrait() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInTrait.kt");
        }

        public void testAllFilesPresentInTests() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousInitializerVarAndConstructor.kt")
        public void testAnonymousInitializerVarAndConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AnonymousInitializerVarAndConstructor.kt");
        }

        @TestMetadata("AnonymousInitializers.kt")
        public void testAnonymousInitializers() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AnonymousInitializers.kt");
        }

        @TestMetadata("AssignToArrayElement.kt")
        public void testAssignToArrayElement() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AssignToArrayElement.kt");
        }

        @TestMetadata("AutoCreatedIt.kt")
        public void testAutoCreatedIt() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AutoCreatedIt.kt");
        }

        @TestMetadata("BacktickNames.kt")
        public void testBacktickNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BacktickNames.kt");
        }

        @TestMetadata("Basic.kt")
        public void testBasic() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Basic.kt");
        }

        @TestMetadata("BinaryCallsOnNullableValues.kt")
        public void testBinaryCallsOnNullableValues() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BinaryCallsOnNullableValues.kt");
        }

        @TestMetadata("Bounds.kt")
        public void testBounds() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Bounds.kt");
        }

        @TestMetadata("BreakContinue.kt")
        public void testBreakContinue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BreakContinue.kt");
        }

        @TestMetadata("BreakContinueInWhen.kt")
        public void testBreakContinueInWhen() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BreakContinueInWhen.kt");
        }

        @TestMetadata("Builders.kt")
        public void testBuilders() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Builders.kt");
        }

        @TestMetadata("Casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Casts.kt");
        }

        @TestMetadata("CharacterLiterals.kt")
        public void testCharacterLiterals() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CharacterLiterals.kt");
        }

        @TestMetadata("checkType.kt")
        public void testCheckType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/checkType.kt");
        }

        @TestMetadata("CompareToWithErrorType.kt")
        public void testCompareToWithErrorType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CompareToWithErrorType.kt");
        }

        @TestMetadata("Constants.kt")
        public void testConstants() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Constants.kt");
        }

        @TestMetadata("Constructors.kt")
        public void testConstructors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Constructors.kt");
        }

        @TestMetadata("ConstructorsOfPrimitives.kt")
        public void testConstructorsOfPrimitives() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ConstructorsOfPrimitives.kt");
        }

        @TestMetadata("CovariantOverrideType.kt")
        public void testCovariantOverrideType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CovariantOverrideType.kt");
        }

        @TestMetadata("DefaultValueForParameterInFunctionType.kt")
        public void testDefaultValueForParameterInFunctionType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValueForParameterInFunctionType.kt");
        }

        @TestMetadata("DefaultValuesCheckWithoutBody.kt")
        public void testDefaultValuesCheckWithoutBody() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValuesCheckWithoutBody.kt");
        }

        @TestMetadata("DefaultValuesTypechecking.kt")
        public void testDefaultValuesTypechecking() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValuesTypechecking.kt");
        }

        @TestMetadata("DeferredTypes.kt")
        public void testDeferredTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeferredTypes.kt");
        }

        @TestMetadata("DeprecatedGetSetPropertyDelegateConvention.kt")
        public void testDeprecatedGetSetPropertyDelegateConvention() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeprecatedGetSetPropertyDelegateConvention.kt");
        }

        @TestMetadata("DeprecatedUnaryOperatorConventions.kt")
        public void testDeprecatedUnaryOperatorConventions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeprecatedUnaryOperatorConventions.kt");
        }

        @TestMetadata("DiamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondFunction.kt");
        }

        @TestMetadata("DiamondFunctionGeneric.kt")
        public void testDiamondFunctionGeneric() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondFunctionGeneric.kt");
        }

        @TestMetadata("DiamondProperty.kt")
        public void testDiamondProperty() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondProperty.kt");
        }

        @TestMetadata("Dollar.kt")
        public void testDollar() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Dollar.kt");
        }

        @TestMetadata("EnumEntryAsType.kt")
        public void testEnumEntryAsType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/EnumEntryAsType.kt");
        }

        @TestMetadata("ExtensionCallInvoke.kt")
        public void testExtensionCallInvoke() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExtensionCallInvoke.kt");
        }

        @TestMetadata("ExternalAccessors.kt")
        public void testExternalAccessors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExternalAccessors.kt");
        }

        @TestMetadata("ExternalAndAbstract.kt")
        public void testExternalAndAbstract() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExternalAndAbstract.kt");
        }

        @TestMetadata("fileDependencyRecursion.kt")
        public void testFileDependencyRecursion() throws Exception {
            runTest("compiler/testData/diagnostics/tests/fileDependencyRecursion.kt");
        }

        @TestMetadata("ForRangeConventions.kt")
        public void testForRangeConventions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ForRangeConventions.kt");
        }

        @TestMetadata("FreeFunctionCalledAsExtension.kt")
        public void testFreeFunctionCalledAsExtension() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FreeFunctionCalledAsExtension.kt");
        }

        @TestMetadata("FunctionCalleeExpressions.kt")
        public void testFunctionCalleeExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionCalleeExpressions.kt");
        }

        @TestMetadata("FunctionParameterWithoutType.kt")
        public void testFunctionParameterWithoutType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionParameterWithoutType.kt");
        }

        @TestMetadata("FunctionReturnTypes.kt")
        public void testFunctionReturnTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionReturnTypes.kt");
        }

        @TestMetadata("GenericArgumentConsistency.kt")
        public void testGenericArgumentConsistency() throws Exception {
            runTest("compiler/testData/diagnostics/tests/GenericArgumentConsistency.kt");
        }

        @TestMetadata("GenericFunctionIsLessSpecific.kt")
        public void testGenericFunctionIsLessSpecific() throws Exception {
            runTest("compiler/testData/diagnostics/tests/GenericFunctionIsLessSpecific.kt");
        }

        @TestMetadata("IdentityComparisonWithPrimitives.kt")
        public void testIdentityComparisonWithPrimitives() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IdentityComparisonWithPrimitives.kt");
        }

        @TestMetadata("implicitIntersection.kt")
        public void testImplicitIntersection() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitIntersection.kt");
        }

        @TestMetadata("implicitNestedIntersection.kt")
        public void testImplicitNestedIntersection() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitNestedIntersection.kt");
        }

        @TestMetadata("implicitNothing.kt")
        public void testImplicitNothing() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitNothing.kt");
        }

        @TestMetadata("IncDec.kt")
        public void testIncDec() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IncDec.kt");
        }

        @TestMetadata("IncorrectCharacterLiterals.kt")
        public void testIncorrectCharacterLiterals() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IncorrectCharacterLiterals.kt");
        }

        @TestMetadata("InferNullabilityInThenBlock.kt")
        public void testInferNullabilityInThenBlock() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InferNullabilityInThenBlock.kt");
        }

        @TestMetadata("Infix.kt")
        public void testInfix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Infix.kt");
        }

        @TestMetadata("InfixModifierApplicability.kt")
        public void testInfixModifierApplicability() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InfixModifierApplicability.kt");
        }

        @TestMetadata("InvokeAndRecursiveResolve.kt")
        public void testInvokeAndRecursiveResolve() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InvokeAndRecursiveResolve.kt");
        }

        @TestMetadata("IsExpressions.kt")
        public void testIsExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IsExpressions.kt");
        }

        @TestMetadata("kt13401.kt")
        public void testKt13401() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt13401.kt");
        }

        @TestMetadata("kt310.kt")
        public void testKt310() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt310.kt");
        }

        @TestMetadata("kt435.kt")
        public void testKt435() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt435.kt");
        }

        @TestMetadata("kt53.kt")
        public void testKt53() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt53.kt");
        }

        @TestMetadata("LValueAssignment.kt")
        public void testLValueAssignment() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LValueAssignment.kt");
        }

        @TestMetadata("LiteralAsResult.kt")
        public void testLiteralAsResult() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LiteralAsResult.kt");
        }

        @TestMetadata("LocalClassAndShortSubpackageNames.kt")
        public void testLocalClassAndShortSubpackageNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LocalClassAndShortSubpackageNames.kt");
        }

        @TestMetadata("localInterfaces.kt")
        public void testLocalInterfaces() throws Exception {
            runTest("compiler/testData/diagnostics/tests/localInterfaces.kt");
        }

        @TestMetadata("MultilineStringTemplates.kt")
        public void testMultilineStringTemplates() throws Exception {
            runTest("compiler/testData/diagnostics/tests/MultilineStringTemplates.kt");
        }

        @TestMetadata("MultipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            runTest("compiler/testData/diagnostics/tests/MultipleBounds.kt");
        }

        @TestMetadata("NamedFunctionTypeParameterInSupertype.kt")
        public void testNamedFunctionTypeParameterInSupertype() throws Exception {
            runTest("compiler/testData/diagnostics/tests/NamedFunctionTypeParameterInSupertype.kt");
        }

        @TestMetadata("Nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Nullability.kt");
        }

        @TestMetadata("NumberPrefixAndSuffix.kt")
        public void testNumberPrefixAndSuffix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/NumberPrefixAndSuffix.kt");
        }

        @TestMetadata("ObjectWithConstructor.kt")
        public void testObjectWithConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ObjectWithConstructor.kt");
        }

        @TestMetadata("OperatorChecks.kt")
        public void testOperatorChecks() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OperatorChecks.kt");
        }

        @TestMetadata("Operators.kt")
        public void testOperators() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Operators.kt");
        }

        @TestMetadata("OperatorsWithWrongNames.kt")
        public void testOperatorsWithWrongNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OperatorsWithWrongNames.kt");
        }

        @TestMetadata("OverrideFunctionWithParamDefaultValue.kt")
        public void testOverrideFunctionWithParamDefaultValue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverrideFunctionWithParamDefaultValue.kt");
        }

        @TestMetadata("OverridenFunctionAndSpecifiedTypeParameter.kt")
        public void testOverridenFunctionAndSpecifiedTypeParameter() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridenFunctionAndSpecifiedTypeParameter.kt");
        }

        @TestMetadata("OverridenSetterVisibility.kt")
        public void testOverridenSetterVisibility() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridenSetterVisibility.kt");
        }

        @TestMetadata("OverridingVarByVal.kt")
        public void testOverridingVarByVal() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridingVarByVal.kt");
        }

        @TestMetadata("PackageInExpressionPosition.kt")
        public void testPackageInExpressionPosition() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageInExpressionPosition.kt");
        }

        @TestMetadata("PackageInTypePosition.kt")
        public void testPackageInTypePosition() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageInTypePosition.kt");
        }

        @TestMetadata("PackageQualified.kt")
        public void testPackageQualified() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageQualified.kt");
        }

        @TestMetadata("PrimaryConstructors.kt")
        public void testPrimaryConstructors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrimaryConstructors.kt");
        }

        @TestMetadata("PrivateFromOuterPackage.kt")
        public void testPrivateFromOuterPackage() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrivateFromOuterPackage.kt");
        }

        @TestMetadata("PrivateSetterForOverridden.kt")
        public void testPrivateSetterForOverridden() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrivateSetterForOverridden.kt");
        }

        @TestMetadata("ProcessingEmptyImport.kt")
        public void testProcessingEmptyImport() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProcessingEmptyImport.kt");
        }

        @TestMetadata("ProjectionOnFunctionArgumentErrror.kt")
        public void testProjectionOnFunctionArgumentErrror() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProjectionOnFunctionArgumentErrror.kt");
        }

        @TestMetadata("ProjectionsInSupertypes.kt")
        public void testProjectionsInSupertypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProjectionsInSupertypes.kt");
        }

        @TestMetadata("Properties.kt")
        public void testProperties() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Properties.kt");
        }

        @TestMetadata("PropertyInitializers.kt")
        public void testPropertyInitializers() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PropertyInitializers.kt");
        }

        @TestMetadata("publishedApi.kt")
        public void testPublishedApi() throws Exception {
            runTest("compiler/testData/diagnostics/tests/publishedApi.kt");
        }

        @TestMetadata("QualifiedExpressions.kt")
        public void testQualifiedExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/QualifiedExpressions.kt");
        }

        @TestMetadata("RecursiveResolve.kt")
        public void testRecursiveResolve() throws Exception {
            runTest("compiler/testData/diagnostics/tests/RecursiveResolve.kt");
        }

        @TestMetadata("RecursiveTypeInference.kt")
        public void testRecursiveTypeInference() throws Exception {
            runTest("compiler/testData/diagnostics/tests/RecursiveTypeInference.kt");
        }

        @TestMetadata("ReserveYield.kt")
        public void testReserveYield() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYield.kt");
        }

        @TestMetadata("ReserveYield2.kt")
        public void testReserveYield2() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYield2.kt");
        }

        @TestMetadata("ResolveOfJavaGenerics.kt")
        public void testResolveOfJavaGenerics() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ResolveOfJavaGenerics.kt");
        }

        @TestMetadata("ResolveToJava.kt")
        public void testResolveToJava() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ResolveToJava.kt");
        }

        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Return.kt");
        }

        @TestMetadata("ReturnInFunctionWithoutBody.kt")
        public void testReturnInFunctionWithoutBody() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReturnInFunctionWithoutBody.kt");
        }

        @TestMetadata("SafeCallInvoke.kt")
        public void testSafeCallInvoke() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallInvoke.kt");
        }

        @TestMetadata("SafeCallNonNullReceiver.kt")
        public void testSafeCallNonNullReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver.kt");
        }

        @TestMetadata("SafeCallNonNullReceiverReturnNull.kt")
        public void testSafeCallNonNullReceiverReturnNull() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiverReturnNull.kt");
        }

        @TestMetadata("SafeCallOnFakePackage.kt")
        public void testSafeCallOnFakePackage() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallOnFakePackage.kt");
        }

        @TestMetadata("SafeCallOnSuperReceiver.kt")
        public void testSafeCallOnSuperReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallOnSuperReceiver.kt");
        }

        @TestMetadata("Serializable.kt")
        public void testSerializable() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Serializable.kt");
        }

        @TestMetadata("SetterVisibility.kt")
        public void testSetterVisibility() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SetterVisibility.kt");
        }

        @TestMetadata("ShiftFunctionTypes.kt")
        public void testShiftFunctionTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ShiftFunctionTypes.kt");
        }

        @TestMetadata("SingleUnderscoreUnsupported.kt")
        public void testSingleUnderscoreUnsupported() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SingleUnderscoreUnsupported.kt");
        }

        @TestMetadata("StarsInFunctionCalls.kt")
        public void testStarsInFunctionCalls() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StarsInFunctionCalls.kt");
        }

        @TestMetadata("StringPrefixAndSuffix.kt")
        public void testStringPrefixAndSuffix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StringPrefixAndSuffix.kt");
        }

        @TestMetadata("StringTemplates.kt")
        public void testStringTemplates() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StringTemplates.kt");
        }

        @TestMetadata("SupertypeListChecks.kt")
        public void testSupertypeListChecks() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SupertypeListChecks.kt");
        }

        @TestMetadata("SyntaxErrorInTestHighlighting.kt")
        public void testSyntaxErrorInTestHighlighting() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlighting.kt");
        }

        @TestMetadata("SyntaxErrorInTestHighlightingEof.kt")
        public void testSyntaxErrorInTestHighlightingEof() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlightingEof.kt");
        }

        @TestMetadata("tailRecOverridden.kt")
        public void testTailRecOverridden() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecOverridden.kt");
        }

        @TestMetadata("tailRecursionComplex.kt")
        public void testTailRecursionComplex() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecursionComplex.kt");
        }

        @TestMetadata("TraitOverrideObjectMethods.kt")
        public void testTraitOverrideObjectMethods() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TraitOverrideObjectMethods.kt");
        }

        @TestMetadata("TraitWithConstructor.kt")
        public void testTraitWithConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TraitWithConstructor.kt");
        }

        @TestMetadata("TypeInference.kt")
        public void testTypeInference() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TypeInference.kt");
        }

        @TestMetadata("TypeMismatchOnOverrideWithSyntaxErrors.kt")
        public void testTypeMismatchOnOverrideWithSyntaxErrors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TypeMismatchOnOverrideWithSyntaxErrors.kt");
        }

        @TestMetadata("Underscore.kt")
        public void testUnderscore() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Underscore.kt");
        }

        @TestMetadata("UnderscoreUsageInAnnotation.kt")
        public void testUnderscoreUsageInAnnotation() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInAnnotation.kt");
        }

        @TestMetadata("UnderscoreUsageInCall.kt")
        public void testUnderscoreUsageInCall() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCall.kt");
        }

        @TestMetadata("UnderscoreUsageInCallableRefTypeLHS.kt")
        public void testUnderscoreUsageInCallableRefTypeLHS() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCallableRefTypeLHS.kt");
        }

        @TestMetadata("UnderscoreUsageInType.kt")
        public void testUnderscoreUsageInType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInType.kt");
        }

        @TestMetadata("UnderscoreUsageInVariableAsFunctionCall.kt")
        public void testUnderscoreUsageInVariableAsFunctionCall() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInVariableAsFunctionCall.kt");
        }

        @TestMetadata("UnitByDefaultForFunctionTypes.kt")
        public void testUnitByDefaultForFunctionTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnitByDefaultForFunctionTypes.kt");
        }

        @TestMetadata("UnitValue.kt")
        public void testUnitValue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnitValue.kt");
        }

        @TestMetadata("Unresolved.kt")
        public void testUnresolved() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Unresolved.kt");
        }

        @TestMetadata("UnusedInDestructuring.kt")
        public void testUnusedInDestructuring() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedInDestructuring.kt");
        }

        @TestMetadata("UnusedParameters.kt")
        public void testUnusedParameters() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedParameters.kt");
        }

        @TestMetadata("UnusedParametersVersion10.kt")
        public void testUnusedParametersVersion10() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedParametersVersion10.kt");
        }

        @TestMetadata("UnusedVariables.kt")
        public void testUnusedVariables() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedVariables.kt");
        }

        @TestMetadata("ValAndFunOverrideCompatibilityClash.kt")
        public void testValAndFunOverrideCompatibilityClash() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ValAndFunOverrideCompatibilityClash.kt");
        }

        @TestMetadata("VarargTypes.kt")
        public void testVarargTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/VarargTypes.kt");
        }

        @TestMetadata("Varargs.kt")
        public void testVarargs() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Varargs.kt");
        }

        @TestMetadata("Variance.kt")
        public void testVariance() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Variance.kt");
        }

        @TestMetadata("compiler/testData/diagnostics/tests/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbigiousAnnotationConstructor.kt")
            public void testAmbigiousAnnotationConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AmbigiousAnnotationConstructor.kt");
            }

            @TestMetadata("AnnotatedConstructor.kt")
            public void testAnnotatedConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructor.kt");
            }

            @TestMetadata("AnnotatedConstructorParams.kt")
            public void testAnnotatedConstructorParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructorParams.kt");
            }

            @TestMetadata("annotatedExpressionInsideAnnotation.kt")
            public void testAnnotatedExpressionInsideAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotatedExpressionInsideAnnotation.kt");
            }

            @TestMetadata("AnnotatedLocalObjectFun.kt")
            public void testAnnotatedLocalObjectFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectFun.kt");
            }

            @TestMetadata("AnnotatedLocalObjectProperty.kt")
            public void testAnnotatedLocalObjectProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectProperty.kt");
            }

            @TestMetadata("AnnotatedLoop.kt")
            public void testAnnotatedLoop() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLoop.kt");
            }

            @TestMetadata("AnnotatedResultType.kt")
            public void testAnnotatedResultType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedResultType.kt");
            }

            @TestMetadata("AnnotatedTryCatch.kt")
            public void testAnnotatedTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedTryCatch.kt");
            }

            @TestMetadata("AnnotationAsDefaultParameter.kt")
            public void testAnnotationAsDefaultParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationAsDefaultParameter.kt");
            }

            @TestMetadata("AnnotationForClassTypeParameter.kt")
            public void testAnnotationForClassTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter.kt");
            }

            @TestMetadata("AnnotationForFunctionTypeParameter.kt")
            public void testAnnotationForFunctionTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForFunctionTypeParameter.kt");
            }

            @TestMetadata("AnnotationForObject.kt")
            public void testAnnotationForObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForObject.kt");
            }

            @TestMetadata("AnnotationIdentifier.kt")
            public void testAnnotationIdentifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationIdentifier.kt");
            }

            @TestMetadata("annotationInheritance.kt")
            public void testAnnotationInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationInheritance.kt");
            }

            @TestMetadata("annotationModifier.kt")
            public void testAnnotationModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationModifier.kt");
            }

            @TestMetadata("AnnotationOnObject.kt")
            public void testAnnotationOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationOnObject.kt");
            }

            @TestMetadata("annotationOnParameterInFunctionType.kt")
            public void testAnnotationOnParameterInFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationOnParameterInFunctionType.kt");
            }

            @TestMetadata("AnnotationsForClasses.kt")
            public void testAnnotationsForClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForClasses.kt");
            }

            @TestMetadata("AnnotationsForPropertyTypeParameter.kt")
            public void testAnnotationsForPropertyTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForPropertyTypeParameter.kt");
            }

            @TestMetadata("annotationsOnLambdaAsCallArgument.kt")
            public void testAnnotationsOnLambdaAsCallArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnLambdaAsCallArgument.kt");
            }

            @TestMetadata("annotationsOnNullableTypes.kt")
            public void testAnnotationsOnNullableTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnNullableTypes.kt");
            }

            @TestMetadata("atAnnotationResolve.kt")
            public void testAtAnnotationResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/atAnnotationResolve.kt");
            }

            @TestMetadata("BasicAnnotations.kt")
            public void testBasicAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/BasicAnnotations.kt");
            }

            @TestMetadata("blockLevelOnTheSameLineWarning.kt")
            public void testBlockLevelOnTheSameLineWarning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/blockLevelOnTheSameLineWarning.kt");
            }

            @TestMetadata("ConstructorCall.kt")
            public void testConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/ConstructorCall.kt");
            }

            @TestMetadata("DanglingMixed.kt")
            public void testDanglingMixed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingMixed.kt");
            }

            @TestMetadata("DanglingNoBrackets.kt")
            public void testDanglingNoBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingNoBrackets.kt");
            }

            @TestMetadata("DanglingWithBrackets.kt")
            public void testDanglingWithBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingWithBrackets.kt");
            }

            @TestMetadata("Deprecated.kt")
            public void testDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/Deprecated.kt");
            }

            @TestMetadata("deprecatedRepeatable.kt")
            public void testDeprecatedRepeatable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/deprecatedRepeatable.kt");
            }

            @TestMetadata("extensionFunctionType.kt")
            public void testExtensionFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/extensionFunctionType.kt");
            }

            @TestMetadata("forParameterAnnotationResolve.kt")
            public void testForParameterAnnotationResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/forParameterAnnotationResolve.kt");
            }

            @TestMetadata("illegalRequireKotlinValue.kt")
            public void testIllegalRequireKotlinValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/illegalRequireKotlinValue.kt");
            }

            @TestMetadata("illegalSinceKotlinValue.kt")
            public void testIllegalSinceKotlinValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/illegalSinceKotlinValue.kt");
            }

            @TestMetadata("inheritFromAnnotationClass.kt")
            public void testInheritFromAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass.kt");
            }

            @TestMetadata("inheritFromAnnotationClass2.kt")
            public void testInheritFromAnnotationClass2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass2.kt");
            }

            @TestMetadata("invalidTypesInAnnotationConstructor.kt")
            public void testInvalidTypesInAnnotationConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/invalidTypesInAnnotationConstructor.kt");
            }

            @TestMetadata("JavaAnnotationConstructors.kt")
            public void testJavaAnnotationConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/JavaAnnotationConstructors.kt");
            }

            @TestMetadata("javaRepeatable.kt")
            public void testJavaRepeatable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/javaRepeatable.kt");
            }

            @TestMetadata("javaRepeatableRetention.kt")
            public void testJavaRepeatableRetention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/javaRepeatableRetention.kt");
            }

            @TestMetadata("javaUnrepeatable.kt")
            public void testJavaUnrepeatable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/javaUnrepeatable.kt");
            }

            @TestMetadata("kt1860-negative.kt")
            public void testKt1860_negative() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1860-negative.kt");
            }

            @TestMetadata("kt1860-positive.kt")
            public void testKt1860_positive() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1860-positive.kt");
            }

            @TestMetadata("kt1886annotationBody_after.kt")
            public void testKt1886annotationBody_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_after.kt");
            }

            @TestMetadata("kt1886annotationBody_before.kt")
            public void testKt1886annotationBody_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_before.kt");
            }

            @TestMetadata("missingValOnParameter.kt")
            public void testMissingValOnParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/missingValOnParameter.kt");
            }

            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/MultiDeclaration.kt");
            }

            @TestMetadata("MutuallyRecursivelyAnnotatedGlobalFunction.kt")
            public void testMutuallyRecursivelyAnnotatedGlobalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/MutuallyRecursivelyAnnotatedGlobalFunction.kt");
            }

            @TestMetadata("nestedClassesInAnnotations.kt")
            public void testNestedClassesInAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/nestedClassesInAnnotations.kt");
            }

            @TestMetadata("noNameProperty.kt")
            public void testNoNameProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/noNameProperty.kt");
            }

            @TestMetadata("NonAnnotationClass.kt")
            public void testNonAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/NonAnnotationClass.kt");
            }

            @TestMetadata("onExpression.kt")
            public void testOnExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onExpression.kt");
            }

            @TestMetadata("onFunctionParameter.kt")
            public void testOnFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onFunctionParameter.kt");
            }

            @TestMetadata("onInitializer.kt")
            public void testOnInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onInitializer.kt");
            }

            @TestMetadata("onLoops.kt")
            public void testOnLoops() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onLoops.kt");
            }

            @TestMetadata("onLoopsUnreachable.kt")
            public void testOnLoopsUnreachable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onLoopsUnreachable.kt");
            }

            @TestMetadata("onMultiDeclaration.kt")
            public void testOnMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onMultiDeclaration.kt");
            }

            @TestMetadata("RecursivelyAnnotated.kt")
            public void testRecursivelyAnnotated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotated.kt");
            }

            @TestMetadata("RecursivelyAnnotatedFunctionParameter.kt")
            public void testRecursivelyAnnotatedFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedFunctionParameter.kt");
            }

            @TestMetadata("RecursivelyAnnotatedGlobalFunction.kt")
            public void testRecursivelyAnnotatedGlobalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalFunction.kt");
            }

            @TestMetadata("RecursivelyAnnotatedGlobalProperty.kt")
            public void testRecursivelyAnnotatedGlobalProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalProperty.kt");
            }

            @TestMetadata("RecursivelyAnnotatedParameter.kt")
            public void testRecursivelyAnnotatedParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameter.kt");
            }

            @TestMetadata("RecursivelyAnnotatedParameterType.kt")
            public void testRecursivelyAnnotatedParameterType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterType.kt");
            }

            @TestMetadata("RecursivelyAnnotatedParameterWithAt.kt")
            public void testRecursivelyAnnotatedParameterWithAt() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterWithAt.kt");
            }

            @TestMetadata("RecursivelyAnnotatedProperty.kt")
            public void testRecursivelyAnnotatedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedProperty.kt");
            }

            @TestMetadata("RecursivelyIncorrectlyAnnotatedParameter.kt")
            public void testRecursivelyIncorrectlyAnnotatedParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyIncorrectlyAnnotatedParameter.kt");
            }

            @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_after.kt")
            public void testRetentionsOfAnnotationWithExpressionTarget_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_after.kt");
            }

            @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_before.kt")
            public void testRetentionsOfAnnotationWithExpressionTarget_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_before.kt");
            }

            @TestMetadata("typeAnnotations.kt")
            public void testTypeAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/typeAnnotations.kt");
            }

            @TestMetadata("typeParameterAsAnnotation.kt")
            public void testTypeParameterAsAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/typeParameterAsAnnotation.kt");
            }

            @TestMetadata("UnresolvedAnnotationOnObject.kt")
            public void testUnresolvedAnnotationOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/UnresolvedAnnotationOnObject.kt");
            }

            @TestMetadata("unresolvedReferenceRange.kt")
            public void testUnresolvedReferenceRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/unresolvedReferenceRange.kt");
            }

            @TestMetadata("WrongAnnotationArgsOnObject.kt")
            public void testWrongAnnotationArgsOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/WrongAnnotationArgsOnObject.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AnnotationParameterMustBeConstant extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAnnotationParameterMustBeConstant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationConstructorDefaultParameter.kt")
                public void testAnnotationConstructorDefaultParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/annotationConstructorDefaultParameter.kt");
                }

                @TestMetadata("booleanLocalVal.kt")
                public void testBooleanLocalVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/booleanLocalVal.kt");
                }

                @TestMetadata("compareAndEquals.kt")
                public void testCompareAndEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/compareAndEquals.kt");
                }

                @TestMetadata("enumConst_after.kt")
                public void testEnumConst_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_after.kt");
                }

                @TestMetadata("enumConst_before.kt")
                public void testEnumConst_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_before.kt");
                }

                @TestMetadata("javaProperties.kt")
                public void testJavaProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/javaProperties.kt");
                }

                @TestMetadata("kotlinProperties.kt")
                public void testKotlinProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/kotlinProperties.kt");
                }

                @TestMetadata("standaloneInExpression.kt")
                public void testStandaloneInExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/standaloneInExpression.kt");
                }

                @TestMetadata("strings.kt")
                public void testStrings() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/strings.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/options")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Options extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInOptions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationAsArg.kt")
                public void testAnnotationAsArg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArg.kt");
                }

                @TestMetadata("annotationAsArgComplex.kt")
                public void testAnnotationAsArgComplex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArgComplex.kt");
                }

                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/assignment.kt");
                }

                @TestMetadata("documented.kt")
                public void testDocumented() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/documented.kt");
                }

                @TestMetadata("forParam.kt")
                public void testForParam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/forParam.kt");
                }

                @TestMetadata("functionExpression.kt")
                public void testFunctionExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/functionExpression.kt");
                }

                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/functions.kt");
                }

                @TestMetadata("javaDocumented.kt")
                public void testJavaDocumented() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaDocumented.kt");
                }

                @TestMetadata("javaKotlinTargetRetention.kt")
                public void testJavaKotlinTargetRetention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaKotlinTargetRetention.kt");
                }

                @TestMetadata("javaretention.kt")
                public void testJavaretention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaretention.kt");
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/multiDeclaration.kt");
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/objectLiteral.kt");
                }

                @TestMetadata("prefix.kt")
                public void testPrefix() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/prefix.kt");
                }

                @TestMetadata("repeatable.kt")
                public void testRepeatable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/repeatable.kt");
                }

                @TestMetadata("retention.kt")
                public void testRetention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/retention.kt");
                }

                @TestMetadata("setterParam.kt")
                public void testSetterParam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/setterParam.kt");
                }

                @TestMetadata("target.kt")
                public void testTarget() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/target.kt");
                }

                @TestMetadata("unrepeatable.kt")
                public void testUnrepeatable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/unrepeatable.kt");
                }

                @TestMetadata("compiler/testData/diagnostics/tests/annotations/options/targets")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Targets extends AbstractDiagnosticsUsingJavacTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("accessors.kt")
                    public void testAccessors() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/accessors.kt");
                    }

                    public void testAllFilesPresentInTargets() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options/targets"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("annotation.kt")
                    public void testAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/annotation.kt");
                    }

                    @TestMetadata("classifier.kt")
                    public void testClassifier() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/classifier.kt");
                    }

                    @TestMetadata("constructor.kt")
                    public void testConstructor() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/constructor.kt");
                    }

                    @TestMetadata("empty.kt")
                    public void testEmpty() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/empty.kt");
                    }

                    @TestMetadata("expr.kt")
                    public void testExpr() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/expr.kt");
                    }

                    @TestMetadata("field.kt")
                    public void testField() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/field.kt");
                    }

                    @TestMetadata("file.kt")
                    public void testFile() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/file.kt");
                    }

                    @TestMetadata("function.kt")
                    public void testFunction() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/function.kt");
                    }

                    @TestMetadata("funtypeargs.kt")
                    public void testFuntypeargs() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/funtypeargs.kt");
                    }

                    @TestMetadata("incorrect.kt")
                    public void testIncorrect() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/incorrect.kt");
                    }

                    @TestMetadata("init.kt")
                    public void testInit() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/init.kt");
                    }

                    @TestMetadata("java.kt")
                    public void testJava() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/java.kt");
                    }

                    @TestMetadata("local.kt")
                    public void testLocal() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/local.kt");
                    }

                    @TestMetadata("nested.kt")
                    public void testNested() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/nested.kt");
                    }

                    @TestMetadata("property.kt")
                    public void testProperty() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/property.kt");
                    }

                    @TestMetadata("returntype.kt")
                    public void testReturntype() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/returntype.kt");
                    }

                    @TestMetadata("suppress.kt")
                    public void testSuppress() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/suppress.kt");
                    }

                    @TestMetadata("type.kt")
                    public void testType() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/type.kt");
                    }

                    @TestMetadata("typeParams.kt")
                    public void testTypeParams() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeParams.kt");
                    }

                    @TestMetadata("typeargs.kt")
                    public void testTypeargs() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeargs.kt");
                    }

                    @TestMetadata("valueparam.kt")
                    public void testValueparam() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/valueparam.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WithUseSiteTarget extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInWithUseSiteTarget() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("DelegateAnnotations.kt")
                public void testDelegateAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/DelegateAnnotations.kt");
                }

                @TestMetadata("diagnosticFileAnnotationInWrongPlace.kt")
                public void testDiagnosticFileAnnotationInWrongPlace() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticFileAnnotationInWrongPlace.kt");
                }

                @TestMetadata("diagnosticWithoutPackage.kt")
                public void testDiagnosticWithoutPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackage.kt");
                }

                @TestMetadata("diagnosticWithoutPackageWithSimpleAnnotation.kt")
                public void testDiagnosticWithoutPackageWithSimpleAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackageWithSimpleAnnotation.kt");
                }

                @TestMetadata("FieldAnnotations.kt")
                public void testFieldAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FieldAnnotations.kt");
                }

                @TestMetadata("fileAnnotationWithoutColon_after.kt")
                public void testFileAnnotationWithoutColon_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_after.kt");
                }

                @TestMetadata("fileAnnotationWithoutColon_before.kt")
                public void testFileAnnotationWithoutColon_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_before.kt");
                }

                @TestMetadata("FileAnnotations.kt")
                public void testFileAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FileAnnotations.kt");
                }

                @TestMetadata("GetterAnnotations.kt")
                public void testGetterAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/GetterAnnotations.kt");
                }

                @TestMetadata("kt23992.kt")
                public void testKt23992() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt23992.kt");
                }

                @TestMetadata("kt23992_after.kt")
                public void testKt23992_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt23992_after.kt");
                }

                @TestMetadata("kt26638.kt")
                public void testKt26638() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt26638.kt");
                }

                @TestMetadata("kt26638_after.kt")
                public void testKt26638_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt26638_after.kt");
                }

                @TestMetadata("ParamAnnotations.kt")
                public void testParamAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ParamAnnotations.kt");
                }

                @TestMetadata("PropertyAnnotations.kt")
                public void testPropertyAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/PropertyAnnotations.kt");
                }

                @TestMetadata("ReceiverAnnotations.kt")
                public void testReceiverAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ReceiverAnnotations.kt");
                }

                @TestMetadata("receiverUseSiteTargetOnExtensionFunction_after.kt")
                public void testReceiverUseSiteTargetOnExtensionFunction_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_after.kt");
                }

                @TestMetadata("receiverUseSiteTargetOnExtensionFunction_before.kt")
                public void testReceiverUseSiteTargetOnExtensionFunction_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_before.kt");
                }

                @TestMetadata("repeatable.kt")
                public void testRepeatable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/repeatable.kt");
                }

                @TestMetadata("SetterAnnotations.kt")
                public void testSetterAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SetterAnnotations.kt");
                }

                @TestMetadata("SparamAnnotations.kt")
                public void testSparamAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SparamAnnotations.kt");
                }

                @TestMetadata("wrongParamAnnotationsOnTypesError.kt")
                public void testWrongParamAnnotationsOnTypesError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypesError.kt");
                }

                @TestMetadata("wrongParamAnnotationsOnTypes_after.kt")
                public void testWrongParamAnnotationsOnTypes_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_after.kt");
                }

                @TestMetadata("wrongParamAnnotationsOnTypes_before.kt")
                public void testWrongParamAnnotationsOnTypes_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_before.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/backingField")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BackingField extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInBackingField() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/backingField"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CustomGetSet.kt")
            public void testCustomGetSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetSet.kt");
            }

            @TestMetadata("CustomGetVal.kt")
            public void testCustomGetVal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVal.kt");
            }

            @TestMetadata("CustomGetValGlobal.kt")
            public void testCustomGetValGlobal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetValGlobal.kt");
            }

            @TestMetadata("CustomGetVar.kt")
            public void testCustomGetVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVar.kt");
            }

            @TestMetadata("CustomSet.kt")
            public void testCustomSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomSet.kt");
            }

            @TestMetadata("ExtensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/ExtensionProperty.kt");
            }

            @TestMetadata("FieldAsParam.kt")
            public void testFieldAsParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldAsParam.kt");
            }

            @TestMetadata("FieldAsProperty.kt")
            public void testFieldAsProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldAsProperty.kt");
            }

            @TestMetadata("FieldDerived.kt")
            public void testFieldDerived() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldDerived.kt");
            }

            @TestMetadata("FieldInInterface.kt")
            public void testFieldInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldInInterface.kt");
            }

            @TestMetadata("FieldInLocal.kt")
            public void testFieldInLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldInLocal.kt");
            }

            @TestMetadata("FieldOnVal.kt")
            public void testFieldOnVal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVal.kt");
            }

            @TestMetadata("FieldOnVar.kt")
            public void testFieldOnVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVar.kt");
            }

            @TestMetadata("FieldReassignment_after.kt")
            public void testFieldReassignment_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_after.kt");
            }

            @TestMetadata("FieldReassignment_before.kt")
            public void testFieldReassignment_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_before.kt");
            }

            @TestMetadata("FieldShadow.kt")
            public void testFieldShadow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldShadow.kt");
            }

            @TestMetadata("InitCustomSetter.kt")
            public void testInitCustomSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/InitCustomSetter.kt");
            }

            @TestMetadata("InitOpenSetter.kt")
            public void testInitOpenSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/InitOpenSetter.kt");
            }

            @TestMetadata("kt782packageLevel.kt")
            public void testKt782packageLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/kt782packageLevel.kt");
            }

            @TestMetadata("SetterWithExplicitType.kt")
            public void testSetterWithExplicitType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/SetterWithExplicitType.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/callableReference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReference extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCallableReference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bareType.kt")
            public void testBareType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/bareType.kt");
            }

            @TestMetadata("callableReferenceAsLastExpressionInBlock.kt")
            public void testCallableReferenceAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceAsLastExpressionInBlock.kt");
            }

            @TestMetadata("classVsPackage.kt")
            public void testClassVsPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/classVsPackage.kt");
            }

            @TestMetadata("ea81649_errorPropertyLHS.kt")
            public void testEa81649_errorPropertyLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/ea81649_errorPropertyLHS.kt");
            }

            @TestMetadata("emptyLhs.kt")
            public void testEmptyLhs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/emptyLhs.kt");
            }

            @TestMetadata("expectedTypeAsSubtypeOfFunctionType.kt")
            public void testExpectedTypeAsSubtypeOfFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/expectedTypeAsSubtypeOfFunctionType.kt");
            }

            @TestMetadata("kt15439_completeCall.kt")
            public void testKt15439_completeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt15439_completeCall.kt");
            }

            @TestMetadata("kt7430_wrongClassOnLHS.kt")
            public void testKt7430_wrongClassOnLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt7430_wrongClassOnLHS.kt");
            }

            @TestMetadata("memberExtensionsImportedFromObjectsUnsupported.kt")
            public void testMemberExtensionsImportedFromObjectsUnsupported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/memberExtensionsImportedFromObjectsUnsupported.kt");
            }

            @TestMetadata("packageInLhs.kt")
            public void testPackageInLhs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/packageInLhs.kt");
            }

            @TestMetadata("parsingPriorityOfGenericArgumentsVsLess.kt")
            public void testParsingPriorityOfGenericArgumentsVsLess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/parsingPriorityOfGenericArgumentsVsLess.kt");
            }

            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/sam.kt");
            }

            @TestMetadata("subtypeArgumentFromRHSForReference.kt")
            public void testSubtypeArgumentFromRHSForReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/subtypeArgumentFromRHSForReference.kt");
            }

            @TestMetadata("unused.kt")
            public void testUnused() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/unused.kt");
            }

            @TestMetadata("whitespacesInExpression.kt")
            public void testWhitespacesInExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/whitespacesInExpression.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/bound")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bound extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBound() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classVsStarImportedCompanion.kt")
                public void testClassVsStarImportedCompanion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedCompanion.kt");
                }

                @TestMetadata("classVsStarImportedObject.kt")
                public void testClassVsStarImportedObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedObject.kt");
                }

                @TestMetadata("companionObject.kt")
                public void testCompanionObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/companionObject.kt");
                }

                @TestMetadata("controlFlow.kt")
                public void testControlFlow() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/controlFlow.kt");
                }

                @TestMetadata("dataFlow.kt")
                public void testDataFlow() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/dataFlow.kt");
                }

                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/expectedType.kt");
                }

                @TestMetadata("expressionWithNullableType.kt")
                public void testExpressionWithNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/expressionWithNullableType.kt");
                }

                @TestMetadata("functionCallWithoutArguments.kt")
                public void testFunctionCallWithoutArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/functionCallWithoutArguments.kt");
                }

                @TestMetadata("innerNested.kt")
                public void testInnerNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/innerNested.kt");
                }

                @TestMetadata("kt12843.kt")
                public void testKt12843() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/kt12843.kt");
                }

                @TestMetadata("noThisInSuperCall.kt")
                public void testNoThisInSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/noThisInSuperCall.kt");
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/object.kt");
                }

                @TestMetadata("privateToThis.kt")
                public void testPrivateToThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/privateToThis.kt");
                }

                @TestMetadata("referenceToStaticMethodOnInstance.kt")
                public void testReferenceToStaticMethodOnInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/referenceToStaticMethodOnInstance.kt");
                }

                @TestMetadata("reservedExpressionSyntax.kt")
                public void testReservedExpressionSyntax() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax.kt");
                }

                @TestMetadata("reservedExpressionSyntax2.kt")
                public void testReservedExpressionSyntax2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax2.kt");
                }

                @TestMetadata("reservedExpressionSyntax3.kt")
                public void testReservedExpressionSyntax3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax3.kt");
                }

                @TestMetadata("syntheticExtensionOnLHS.kt")
                public void testSyntheticExtensionOnLHS() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/syntheticExtensionOnLHS.kt");
                }

                @TestMetadata("valueOfTypeParameterType.kt")
                public void testValueOfTypeParameterType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/valueOfTypeParameterType.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/function")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Function extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("abstractClassConstructors.kt")
                public void testAbstractClassConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/abstractClassConstructors.kt");
                }

                public void testAllFilesPresentInFunction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ambiguityTopLevelVsTopLevel.kt")
                public void testAmbiguityTopLevelVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/ambiguityTopLevelVsTopLevel.kt");
                }

                @TestMetadata("annotationClassConstructor.kt")
                public void testAnnotationClassConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/annotationClassConstructor.kt");
                }

                @TestMetadata("callableRefrenceOnNestedObject.kt")
                public void testCallableRefrenceOnNestedObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/callableRefrenceOnNestedObject.kt");
                }

                @TestMetadata("classMemberVsConstructorLikeFunction.kt")
                public void testClassMemberVsConstructorLikeFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/classMemberVsConstructorLikeFunction.kt");
                }

                @TestMetadata("constructorFromClass.kt")
                public void testConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromClass.kt");
                }

                @TestMetadata("constructorFromCompanion.kt")
                public void testConstructorFromCompanion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromCompanion.kt");
                }

                @TestMetadata("constructorFromExtension.kt")
                public void testConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtension.kt");
                }

                @TestMetadata("constructorFromExtensionInClass.kt")
                public void testConstructorFromExtensionInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtensionInClass.kt");
                }

                @TestMetadata("constructorFromTopLevel.kt")
                public void testConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromTopLevel.kt");
                }

                @TestMetadata("constructorOfNestedClassInObject.kt")
                public void testConstructorOfNestedClassInObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorOfNestedClassInObject.kt");
                }

                @TestMetadata("differentPackageClass.kt")
                public void testDifferentPackageClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageClass.kt");
                }

                @TestMetadata("differentPackageExtension.kt")
                public void testDifferentPackageExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageExtension.kt");
                }

                @TestMetadata("differentPackageTopLevel.kt")
                public void testDifferentPackageTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageTopLevel.kt");
                }

                @TestMetadata("empty.kt")
                public void testEmpty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/empty.kt");
                }

                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionFromTopLevel.kt");
                }

                @TestMetadata("extensionInClassDisallowed.kt")
                public void testExtensionInClassDisallowed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionInClassDisallowed.kt");
                }

                @TestMetadata("extensionOnNullable.kt")
                public void testExtensionOnNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionOnNullable.kt");
                }

                @TestMetadata("extensionToSupertype.kt")
                public void testExtensionToSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionToSupertype.kt");
                }

                @TestMetadata("fakeOverrideType.kt")
                public void testFakeOverrideType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/fakeOverrideType.kt");
                }

                @TestMetadata("genericClassFromTopLevel.kt")
                public void testGenericClassFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/genericClassFromTopLevel.kt");
                }

                @TestMetadata("importedInnerConstructor.kt")
                public void testImportedInnerConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/importedInnerConstructor.kt");
                }

                @TestMetadata("innerConstructorFromClass.kt")
                public void testInnerConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromClass.kt");
                }

                @TestMetadata("innerConstructorFromExtension.kt")
                public void testInnerConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromExtension.kt");
                }

                @TestMetadata("innerConstructorFromTopLevel.kt")
                public void testInnerConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromTopLevel.kt");
                }

                @TestMetadata("javaStaticMethod.kt")
                public void testJavaStaticMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/javaStaticMethod.kt");
                }

                @TestMetadata("lhsNotAClass.kt")
                public void testLhsNotAClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/lhsNotAClass.kt");
                }

                @TestMetadata("localConstructor.kt")
                public void testLocalConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructor.kt");
                }

                @TestMetadata("localConstructorFromExtensionInLocalClass.kt")
                public void testLocalConstructorFromExtensionInLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromExtensionInLocalClass.kt");
                }

                @TestMetadata("localConstructorFromLocalClass.kt")
                public void testLocalConstructorFromLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalClass.kt");
                }

                @TestMetadata("localConstructorFromLocalExtension.kt")
                public void testLocalConstructorFromLocalExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalExtension.kt");
                }

                @TestMetadata("localNamedFun.kt")
                public void testLocalNamedFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFun.kt");
                }

                @TestMetadata("localNamedFunFromExtensionInLocalClass.kt")
                public void testLocalNamedFunFromExtensionInLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromExtensionInLocalClass.kt");
                }

                @TestMetadata("localNamedFunFromLocalClass.kt")
                public void testLocalNamedFunFromLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalClass.kt");
                }

                @TestMetadata("localNamedFunFromLocalExtension.kt")
                public void testLocalNamedFunFromLocalExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalExtension.kt");
                }

                @TestMetadata("longQualifiedName.kt")
                public void testLongQualifiedName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedName.kt");
                }

                @TestMetadata("longQualifiedNameGeneric.kt")
                public void testLongQualifiedNameGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedNameGeneric.kt");
                }

                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/memberFromTopLevel.kt");
                }

                @TestMetadata("nestedConstructorFromClass.kt")
                public void testNestedConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromClass.kt");
                }

                @TestMetadata("nestedConstructorFromExtension.kt")
                public void testNestedConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromExtension.kt");
                }

                @TestMetadata("nestedConstructorFromTopLevel.kt")
                public void testNestedConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromTopLevel.kt");
                }

                @TestMetadata("noAmbiguityLocalVsTopLevel.kt")
                public void testNoAmbiguityLocalVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityLocalVsTopLevel.kt");
                }

                @TestMetadata("noAmbiguityMemberVsExtension.kt")
                public void testNoAmbiguityMemberVsExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsExtension.kt");
                }

                @TestMetadata("noAmbiguityMemberVsTopLevel.kt")
                public void testNoAmbiguityMemberVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsTopLevel.kt");
                }

                @TestMetadata("privateStaticAndPublicMember.kt")
                public void testPrivateStaticAndPublicMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/privateStaticAndPublicMember.kt");
                }

                @TestMetadata("renameOnImport.kt")
                public void testRenameOnImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/renameOnImport.kt");
                }

                @TestMetadata("topLevelFromClass.kt")
                public void testTopLevelFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromClass.kt");
                }

                @TestMetadata("topLevelFromExtension.kt")
                public void testTopLevelFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtension.kt");
                }

                @TestMetadata("topLevelFromExtensionInClass.kt")
                public void testTopLevelFromExtensionInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtensionInClass.kt");
                }

                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromTopLevel.kt");
                }

                @TestMetadata("unresolved.kt")
                public void testUnresolved() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/unresolved.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/generic")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Generic extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInGeneric() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/generic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("argumentAndReturnExpectedType.kt")
                public void testArgumentAndReturnExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentAndReturnExpectedType.kt");
                }

                @TestMetadata("argumentExpectedType.kt")
                public void testArgumentExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentExpectedType.kt");
                }

                @TestMetadata("dependOnArgumentType.kt")
                public void testDependOnArgumentType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/dependOnArgumentType.kt");
                }

                @TestMetadata("expectedFunctionType.kt")
                public void testExpectedFunctionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/expectedFunctionType.kt");
                }

                @TestMetadata("explicitTypeArguments.kt")
                public void testExplicitTypeArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/explicitTypeArguments.kt");
                }

                @TestMetadata("genericExtensionFunction.kt")
                public void testGenericExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericExtensionFunction.kt");
                }

                @TestMetadata("genericFunctionsWithNullableTypes.kt")
                public void testGenericFunctionsWithNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericFunctionsWithNullableTypes.kt");
                }

                @TestMetadata("kt10968.kt")
                public void testKt10968() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt10968.kt");
                }

                @TestMetadata("kt11075.kt")
                public void testKt11075() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt11075.kt");
                }

                @TestMetadata("kt12286.kt")
                public void testKt12286() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt12286.kt");
                }

                @TestMetadata("kt7470.kt")
                public void testKt7470() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt7470.kt");
                }

                @TestMetadata("nestedCallWithOverload.kt")
                public void testNestedCallWithOverload() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/nestedCallWithOverload.kt");
                }

                @TestMetadata("noInferenceFeatureForCallableReferences.kt")
                public void testNoInferenceFeatureForCallableReferences() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/noInferenceFeatureForCallableReferences.kt");
                }

                @TestMetadata("resolutionGenericCallableWithNullableTypes.kt")
                public void testResolutionGenericCallableWithNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionGenericCallableWithNullableTypes.kt");
                }

                @TestMetadata("resolutionWithGenericCallable.kt")
                public void testResolutionWithGenericCallable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionWithGenericCallable.kt");
                }

                @TestMetadata("specialCalls.kt")
                public void testSpecialCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/specialCalls.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("abstractPropertyViaSubclasses.kt")
                public void testAbstractPropertyViaSubclasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/abstractPropertyViaSubclasses.kt");
                }

                @TestMetadata("accessViaSubclass.kt")
                public void testAccessViaSubclass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/accessViaSubclass.kt");
                }

                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classFromClass.kt")
                public void testClassFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/classFromClass.kt");
                }

                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionFromTopLevel.kt");
                }

                @TestMetadata("extensionPropertyOnNullable.kt")
                public void testExtensionPropertyOnNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionPropertyOnNullable.kt");
                }

                @TestMetadata("genericClass.kt")
                public void testGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/genericClass.kt");
                }

                @TestMetadata("javaInstanceField.kt")
                public void testJavaInstanceField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/javaInstanceField.kt");
                }

                @TestMetadata("javaStaticFieldViaImport.kt")
                public void testJavaStaticFieldViaImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/javaStaticFieldViaImport.kt");
                }

                @TestMetadata("kt7564.kt")
                public void testKt7564() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7564.kt");
                }

                @TestMetadata("kt7945_unrelatedClass.kt")
                public void testKt7945_unrelatedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7945_unrelatedClass.kt");
                }

                @TestMetadata("localVariable.kt")
                public void testLocalVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/localVariable.kt");
                }

                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/memberFromTopLevel.kt");
                }

                @TestMetadata("protectedVarFromClass.kt")
                public void testProtectedVarFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/protectedVarFromClass.kt");
                }

                @TestMetadata("returnTypeDependentOnGenericProperty.kt")
                public void testReturnTypeDependentOnGenericProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/returnTypeDependentOnGenericProperty.kt");
                }

                @TestMetadata("samePriorityForFunctionsAndProperties.kt")
                public void testSamePriorityForFunctionsAndProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/samePriorityForFunctionsAndProperties.kt");
                }

                @TestMetadata("syntheticProperties.kt")
                public void testSyntheticProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/syntheticProperties.kt");
                }

                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/topLevelFromTopLevel.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/resolve")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Resolve extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInResolve() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ambiguousWithVararg.kt")
                public void testAmbiguousWithVararg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguousWithVararg.kt");
                }

                @TestMetadata("byArgType.kt")
                public void testByArgType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byArgType.kt");
                }

                @TestMetadata("byGenericArgType.kt")
                public void testByGenericArgType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byGenericArgType.kt");
                }

                @TestMetadata("byValType.kt")
                public void testByValType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byValType.kt");
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/constructor.kt");
                }

                @TestMetadata("innerClassConstructorOnOuterClassInstance.kt")
                public void testInnerClassConstructorOnOuterClassInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/innerClassConstructorOnOuterClassInstance.kt");
                }

                @TestMetadata("intersectionTypeOverloadWithWrongParameter.kt")
                public void testIntersectionTypeOverloadWithWrongParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/intersectionTypeOverloadWithWrongParameter.kt");
                }

                @TestMetadata("kt10036.kt")
                public void testKt10036() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036.kt");
                }

                @TestMetadata("kt10036_bound.kt")
                public void testKt10036_bound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036_bound.kt");
                }

                @TestMetadata("kt12338.kt")
                public void testKt12338() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12338.kt");
                }

                @TestMetadata("kt12751.kt")
                public void testKt12751() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12751.kt");
                }

                @TestMetadata("kt8596.kt")
                public void testKt8596() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt8596.kt");
                }

                @TestMetadata("kt9601.kt")
                public void testKt9601() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt9601.kt");
                }

                @TestMetadata("moreSpecificAmbiguousExtensions.kt")
                public void testMoreSpecificAmbiguousExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificAmbiguousExtensions.kt");
                }

                @TestMetadata("moreSpecificSimple.kt")
                public void testMoreSpecificSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificSimple.kt");
                }

                @TestMetadata("noFakeDescriptorForObject.kt")
                public void testNoFakeDescriptorForObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/noFakeDescriptorForObject.kt");
                }

                @TestMetadata("overloads.kt")
                public void testOverloads() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloads.kt");
                }

                @TestMetadata("overloadsBound.kt")
                public void testOverloadsBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsBound.kt");
                }

                @TestMetadata("overloadsMember.kt")
                public void testOverloadsMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsMember.kt");
                }

                @TestMetadata("valVsFun.kt")
                public void testValVsFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/valVsFun.kt");
                }

                @TestMetadata("withAs.kt")
                public void testWithAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withAs.kt");
                }

                @TestMetadata("withExtFun.kt")
                public void testWithExtFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withExtFun.kt");
                }

                @TestMetadata("withGenericFun.kt")
                public void testWithGenericFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withGenericFun.kt");
                }

                @TestMetadata("withPlaceholderTypes.kt")
                public void testWithPlaceholderTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withPlaceholderTypes.kt");
                }

                @TestMetadata("withVararg.kt")
                public void testWithVararg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withVararg.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/cast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Cast extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AsArray.kt")
            public void testAsArray() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsArray.kt");
            }

            @TestMetadata("AsErasedError.kt")
            public void testAsErasedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedError.kt");
            }

            @TestMetadata("AsErasedFine.kt")
            public void testAsErasedFine() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedFine.kt");
            }

            @TestMetadata("AsErasedStar.kt")
            public void testAsErasedStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedStar.kt");
            }

            @TestMetadata("AsErasedWarning.kt")
            public void testAsErasedWarning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedWarning.kt");
            }

            @TestMetadata("AsInBinaryUnary.kt")
            public void testAsInBinaryUnary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInBinaryUnary.kt");
            }

            @TestMetadata("AsInBlockWithReturnType.kt")
            public void testAsInBlockWithReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInBlockWithReturnType.kt");
            }

            @TestMetadata("AsInExpressionBody.kt")
            public void testAsInExpressionBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInExpressionBody.kt");
            }

            @TestMetadata("AsInPropertyAndPropertyAccessor.kt")
            public void testAsInPropertyAndPropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInPropertyAndPropertyAccessor.kt");
            }

            @TestMetadata("AsNothing.kt")
            public void testAsNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsNothing.kt");
            }

            @TestMetadata("AsTypeAlias.kt")
            public void testAsTypeAlias() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsTypeAlias.kt");
            }

            @TestMetadata("AsWithOtherParameter.kt")
            public void testAsWithOtherParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsWithOtherParameter.kt");
            }

            @TestMetadata("checkCastToNullableType.kt")
            public void testCheckCastToNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/checkCastToNullableType.kt");
            }

            @TestMetadata("constants.kt")
            public void testConstants() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/constants.kt");
            }

            @TestMetadata("DowncastMap.kt")
            public void testDowncastMap() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/DowncastMap.kt");
            }

            @TestMetadata("ExtensionAsNonExtension.kt")
            public void testExtensionAsNonExtension() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/ExtensionAsNonExtension.kt");
            }

            @TestMetadata("FlexibleTargetType.kt")
            public void testFlexibleTargetType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/FlexibleTargetType.kt");
            }

            @TestMetadata("IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt")
            public void testIsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt");
            }

            @TestMetadata("IsErasedAllowForExactSupertypeCheck.kt")
            public void testIsErasedAllowForExactSupertypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForExactSupertypeCheck.kt");
            }

            @TestMetadata("IsErasedAllowForOverridenVarianceWithProjection.kt")
            public void testIsErasedAllowForOverridenVarianceWithProjection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForOverridenVarianceWithProjection.kt");
            }

            @TestMetadata("IsErasedAllowForSupertypeCheckWithContrvariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithContrvariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithContrvariance.kt");
            }

            @TestMetadata("IsErasedAllowForSupertypeCheckWithCovariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithCovariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithCovariance.kt");
            }

            @TestMetadata("IsErasedAllowForTypeWithIrrelevantMixin.kt")
            public void testIsErasedAllowForTypeWithIrrelevantMixin() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithIrrelevantMixin.kt");
            }

            @TestMetadata("IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt")
            public void testIsErasedAllowForTypeWithTwoSameTypeSubstitutions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt");
            }

            @TestMetadata("IsErasedAllowForTypeWithoutTypeArguments.kt")
            public void testIsErasedAllowForTypeWithoutTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithoutTypeArguments.kt");
            }

            @TestMetadata("IsErasedAllowFromOut.kt")
            public void testIsErasedAllowFromOut() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut.kt");
            }

            @TestMetadata("IsErasedAllowFromOut2.kt")
            public void testIsErasedAllowFromOut2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut2.kt");
            }

            @TestMetadata("IsErasedAllowFromOutAtClass.kt")
            public void testIsErasedAllowFromOutAtClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOutAtClass.kt");
            }

            @TestMetadata("IsErasedAllowParameterSubtype.kt")
            public void testIsErasedAllowParameterSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowParameterSubtype.kt");
            }

            @TestMetadata("IsErasedAllowSameClassParameter.kt")
            public void testIsErasedAllowSameClassParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameClassParameter.kt");
            }

            @TestMetadata("IsErasedAllowSameParameterParameter.kt")
            public void testIsErasedAllowSameParameterParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameParameterParameter.kt");
            }

            @TestMetadata("isErasedAnyAndStarred.kt")
            public void testIsErasedAnyAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedAnyAndStarred.kt");
            }

            @TestMetadata("IsErasedDisallowDifferentArgInvariantPosition.kt")
            public void testIsErasedDisallowDifferentArgInvariantPosition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowDifferentArgInvariantPosition.kt");
            }

            @TestMetadata("IsErasedDisallowForOverridenVariance.kt")
            public void testIsErasedDisallowForOverridenVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForOverridenVariance.kt");
            }

            @TestMetadata("IsErasedDisallowForTypeWithConstraints.kt")
            public void testIsErasedDisallowForTypeWithConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForTypeWithConstraints.kt");
            }

            @TestMetadata("IsErasedDisallowFromAny.kt")
            public void testIsErasedDisallowFromAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromAny.kt");
            }

            @TestMetadata("IsErasedDisallowFromIn.kt")
            public void testIsErasedDisallowFromIn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromIn.kt");
            }

            @TestMetadata("IsErasedDisallowFromOut.kt")
            public void testIsErasedDisallowFromOut() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOut.kt");
            }

            @TestMetadata("IsErasedDisallowFromOutAtClass.kt")
            public void testIsErasedDisallowFromOutAtClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOutAtClass.kt");
            }

            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt");
            }

            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt");
            }

            @TestMetadata("IsErasedNonGeneric.kt")
            public void testIsErasedNonGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedNonGeneric.kt");
            }

            @TestMetadata("IsErasedNullableTasT.kt")
            public void testIsErasedNullableTasT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedNullableTasT.kt");
            }

            @TestMetadata("IsErasedStar.kt")
            public void testIsErasedStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedStar.kt");
            }

            @TestMetadata("isErasedTAndStarred.kt")
            public void testIsErasedTAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedTAndStarred.kt");
            }

            @TestMetadata("IsErasedTasT.kt")
            public void testIsErasedTasT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedTasT.kt");
            }

            @TestMetadata("IsErasedToErrorType.kt")
            public void testIsErasedToErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedToErrorType.kt");
            }

            @TestMetadata("isErasedUnrelatedAndStarred.kt")
            public void testIsErasedUnrelatedAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedUnrelatedAndStarred.kt");
            }

            @TestMetadata("IsErasedUpcastToNonReified.kt")
            public void testIsErasedUpcastToNonReified() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedUpcastToNonReified.kt");
            }

            @TestMetadata("IsForTypeWithComplexUpperBound.kt")
            public void testIsForTypeWithComplexUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsForTypeWithComplexUpperBound.kt");
            }

            @TestMetadata("IsRecursionSustainable.kt")
            public void testIsRecursionSustainable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsRecursionSustainable.kt");
            }

            @TestMetadata("IsTraits.kt")
            public void testIsTraits() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsTraits.kt");
            }

            @TestMetadata("IsWithCycleUpperBounds.kt")
            public void testIsWithCycleUpperBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsWithCycleUpperBounds.kt");
            }

            @TestMetadata("kt15161.kt")
            public void testKt15161() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/kt15161.kt");
            }

            @TestMetadata("kt614.kt")
            public void testKt614() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/kt614.kt");
            }

            @TestMetadata("nothingAs.kt")
            public void testNothingAs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/nothingAs.kt");
            }

            @TestMetadata("NullableToNullable.kt")
            public void testNullableToNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/NullableToNullable.kt");
            }

            @TestMetadata("StableTypeForUselessCast.kt")
            public void testStableTypeForUselessCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/StableTypeForUselessCast.kt");
            }

            @TestMetadata("UselessSafeCast.kt")
            public void testUselessSafeCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/UselessSafeCast.kt");
            }

            @TestMetadata("WhenErasedDisallowFromAny.kt")
            public void testWhenErasedDisallowFromAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/WhenErasedDisallowFromAny.kt");
            }

            @TestMetadata("WhenWithExpression.kt")
            public void testWhenWithExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/WhenWithExpression.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/cast/bare")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bare extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBare() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/bare"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("AsNestedBare.kt")
                public void testAsNestedBare() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNestedBare.kt");
                }

                @TestMetadata("AsNullable.kt")
                public void testAsNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullable.kt");
                }

                @TestMetadata("AsNullableNotEnough.kt")
                public void testAsNullableNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullableNotEnough.kt");
                }

                @TestMetadata("EitherAs.kt")
                public void testEitherAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherAs.kt");
                }

                @TestMetadata("EitherIs.kt")
                public void testEitherIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherIs.kt");
                }

                @TestMetadata("EitherNotIs.kt")
                public void testEitherNotIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherNotIs.kt");
                }

                @TestMetadata("EitherSafeAs.kt")
                public void testEitherSafeAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherSafeAs.kt");
                }

                @TestMetadata("EitherWhen.kt")
                public void testEitherWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherWhen.kt");
                }

                @TestMetadata("ErrorsInSubstitution.kt")
                public void testErrorsInSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/ErrorsInSubstitution.kt");
                }

                @TestMetadata("FromErrorType.kt")
                public void testFromErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/FromErrorType.kt");
                }

                @TestMetadata("NullableAs.kt")
                public void testNullableAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAs.kt");
                }

                @TestMetadata("NullableAsNotEnough.kt")
                public void testNullableAsNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNotEnough.kt");
                }

                @TestMetadata("NullableAsNullable.kt")
                public void testNullableAsNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullable.kt");
                }

                @TestMetadata("NullableAsNullableNotEnough.kt")
                public void testNullableAsNullableNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullableNotEnough.kt");
                }

                @TestMetadata("RedundantNullable.kt")
                public void testRedundantNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/RedundantNullable.kt");
                }

                @TestMetadata("ToErrorType.kt")
                public void testToErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/ToErrorType.kt");
                }

                @TestMetadata("UnrelatedAs.kt")
                public void testUnrelatedAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedAs.kt");
                }

                @TestMetadata("UnrelatedColon.kt")
                public void testUnrelatedColon() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedColon.kt");
                }

                @TestMetadata("UnrelatedIs.kt")
                public void testUnrelatedIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedIs.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NeverSucceeds extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNeverSucceeds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/neverSucceeds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CastToNotNullSuper.kt")
                public void testCastToNotNullSuper() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/CastToNotNullSuper.kt");
                }

                @TestMetadata("MappedDirect.kt")
                public void testMappedDirect() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedDirect.kt");
                }

                @TestMetadata("MappedSubtypes.kt")
                public void testMappedSubtypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedSubtypes.kt");
                }

                @TestMetadata("NoGenericsRelated.kt")
                public void testNoGenericsRelated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsRelated.kt");
                }

                @TestMetadata("NoGenericsUnrelated.kt")
                public void testNoGenericsUnrelated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsUnrelated.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/checkArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckArguments extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCheckArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/checkArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayAccessSet.kt")
            public void testArrayAccessSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSet.kt");
            }

            @TestMetadata("arrayAccessSetTooManyArgs.kt")
            public void testArrayAccessSetTooManyArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetTooManyArgs.kt");
            }

            @TestMetadata("booleanExpressions.kt")
            public void testBooleanExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/booleanExpressions.kt");
            }

            @TestMetadata("kt1897_diagnostic_part.kt")
            public void testKt1897_diagnostic_part() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt1897_diagnostic_part.kt");
            }

            @TestMetadata("kt1940.kt")
            public void testKt1940() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt1940.kt");
            }

            @TestMetadata("overloadedFunction.kt")
            public void testOverloadedFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/overloadedFunction.kt");
            }

            @TestMetadata("SpreadVarargs.kt")
            public void testSpreadVarargs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/SpreadVarargs.kt");
            }

            @TestMetadata("twoLambdasFunction.kt")
            public void testTwoLambdasFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/twoLambdasFunction.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/classLiteral")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassLiteral extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassLiteral() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/classLiteral"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/arrays.kt");
            }

            @TestMetadata("classAndObjectLiteralType.kt")
            public void testClassAndObjectLiteralType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/classAndObjectLiteralType.kt");
            }

            @TestMetadata("classLiteralType.kt")
            public void testClassLiteralType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/classLiteralType.kt");
            }

            @TestMetadata("expressionWithNullableType.kt")
            public void testExpressionWithNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/expressionWithNullableType.kt");
            }

            @TestMetadata("genericArrays.kt")
            public void testGenericArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/genericArrays.kt");
            }

            @TestMetadata("genericClasses.kt")
            public void testGenericClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/genericClasses.kt");
            }

            @TestMetadata("inAnnotationArguments.kt")
            public void testInAnnotationArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/inAnnotationArguments.kt");
            }

            @TestMetadata("inAnnotationArguments_noTypeParams.kt")
            public void testInAnnotationArguments_noTypeParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/inAnnotationArguments_noTypeParams.kt");
            }

            @TestMetadata("integerValueType.kt")
            public void testIntegerValueType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/integerValueType.kt");
            }

            @TestMetadata("nonClassesOnLHS.kt")
            public void testNonClassesOnLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/nonClassesOnLHS.kt");
            }

            @TestMetadata("qualifiedClassLiteral.kt")
            public void testQualifiedClassLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/qualifiedClassLiteral.kt");
            }

            @TestMetadata("simpleClassLiteral.kt")
            public void testSimpleClassLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/simpleClassLiteral.kt");
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/smartCast.kt");
            }

            @TestMetadata("typealiases.kt")
            public void testTypealiases() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/typealiases.kt");
            }

            @TestMetadata("unresolvedClass.kt")
            public void testUnresolvedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/unresolvedClass.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/classObjects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassObjects extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassObjects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/classObjects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("builtInClassObjects.kt")
            public void testBuiltInClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/builtInClassObjects.kt");
            }

            @TestMetadata("ClassObjectCannotAccessClassFields.kt")
            public void testClassObjectCannotAccessClassFields() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectCannotAccessClassFields.kt");
            }

            @TestMetadata("classObjectHeader.kt")
            public void testClassObjectHeader() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectHeader.kt");
            }

            @TestMetadata("classObjectInLocalClass.kt")
            public void testClassObjectInLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectInLocalClass.kt");
            }

            @TestMetadata("classObjectRedeclaration.kt")
            public void testClassObjectRedeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectRedeclaration.kt");
            }

            @TestMetadata("ClassObjectVisibility.kt")
            public void testClassObjectVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectVisibility.kt");
            }

            @TestMetadata("ClassObjects.kt")
            public void testClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjects.kt");
            }

            @TestMetadata("companionObjectOfPrivateClassVisibility.kt")
            public void testCompanionObjectOfPrivateClassVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/companionObjectOfPrivateClassVisibility.kt");
            }

            @TestMetadata("importClassInClassObject.kt")
            public void testImportClassInClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/importClassInClassObject.kt");
            }

            @TestMetadata("InnerClassAccessThroughClassObject.kt")
            public void testInnerClassAccessThroughClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughClassObject.kt");
            }

            @TestMetadata("InnerClassAccessThroughEnum_after.kt")
            public void testInnerClassAccessThroughEnum_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_after.kt");
            }

            @TestMetadata("InnerClassAccessThroughEnum_before.kt")
            public void testInnerClassAccessThroughEnum_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_before.kt");
            }

            @TestMetadata("InnerClassClassObject.kt")
            public void testInnerClassClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassClassObject.kt");
            }

            @TestMetadata("invisibleClassObjects.kt")
            public void testInvisibleClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/invisibleClassObjects.kt");
            }

            @TestMetadata("kt3866.kt")
            public void testKt3866() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/kt3866.kt");
            }

            @TestMetadata("multipleDissallowedDefaultObjects.kt")
            public void testMultipleDissallowedDefaultObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/multipleDissallowedDefaultObjects.kt");
            }

            @TestMetadata("nestedClassInPrivateClassObject.kt")
            public void testNestedClassInPrivateClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/nestedClassInPrivateClassObject.kt");
            }

            @TestMetadata("resolveFunctionInsideClassObject.kt")
            public void testResolveFunctionInsideClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/resolveFunctionInsideClassObject.kt");
            }

            @TestMetadata("typeParametersInAnnonymousObject.kt")
            public void testTypeParametersInAnnonymousObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInAnnonymousObject.kt");
            }

            @TestMetadata("typeParametersInAnnonymousObject_after.kt")
            public void testTypeParametersInAnnonymousObject_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInAnnonymousObject_after.kt");
            }

            @TestMetadata("typeParametersInObject.kt")
            public void testTypeParametersInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInObject.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/collectionLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CollectionLiterals extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCollectionLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/collectionLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentsOfAnnotation.kt")
            public void testArgumentsOfAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotation.kt");
            }

            @TestMetadata("argumentsOfAnnotationWithKClass.kt")
            public void testArgumentsOfAnnotationWithKClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotationWithKClass.kt");
            }

            @TestMetadata("basicCollectionLiterals.kt")
            public void testBasicCollectionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/basicCollectionLiterals.kt");
            }

            @TestMetadata("collectionLiteralsAsPrimitiveArrays.kt")
            public void testCollectionLiteralsAsPrimitiveArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsAsPrimitiveArrays.kt");
            }

            @TestMetadata("collectionLiteralsWithVarargs.kt")
            public void testCollectionLiteralsWithVarargs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsWithVarargs.kt");
            }

            @TestMetadata("defaultValuesInAnnotation.kt")
            public void testDefaultValuesInAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesInAnnotation.kt");
            }

            @TestMetadata("defaultValuesWithConstantsInAnnotation.kt")
            public void testDefaultValuesWithConstantsInAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesWithConstantsInAnnotation.kt");
            }

            @TestMetadata("noArrayLiteralsInAnnotationsFeature.kt")
            public void testNoArrayLiteralsInAnnotationsFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/noArrayLiteralsInAnnotationsFeature.kt");
            }

            @TestMetadata("noCollectionLiterals.kt")
            public void testNoCollectionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/noCollectionLiterals.kt");
            }

            @TestMetadata("resolveToFunctionFromBuiltIns.kt")
            public void testResolveToFunctionFromBuiltIns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/resolveToFunctionFromBuiltIns.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/constructorConsistency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConstructorConsistency extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("afterInitialization.kt")
            public void testAfterInitialization() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/afterInitialization.kt");
            }

            @TestMetadata("aliencall.kt")
            public void testAliencall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/aliencall.kt");
            }

            public void testAllFilesPresentInConstructorConsistency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/constructorConsistency"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/assignment.kt");
            }

            @TestMetadata("backing.kt")
            public void testBacking() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/backing.kt");
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/basic.kt");
            }

            @TestMetadata("companion.kt")
            public void testCompanion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/companion.kt");
            }

            @TestMetadata("comparison.kt")
            public void testComparison() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/comparison.kt");
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/delegate.kt");
            }

            @TestMetadata("derived.kt")
            public void testDerived() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/derived.kt");
            }

            @TestMetadata("derivedProperty.kt")
            public void testDerivedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/derivedProperty.kt");
            }

            @TestMetadata("getset.kt")
            public void testGetset() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/getset.kt");
            }

            @TestMetadata("init.kt")
            public void testInit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/init.kt");
            }

            @TestMetadata("initializerWithSecondaryConstructor.kt")
            public void testInitializerWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/initializerWithSecondaryConstructor.kt");
            }

            @TestMetadata("initwithgetter.kt")
            public void testInitwithgetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/initwithgetter.kt");
            }

            @TestMetadata("inspection.kt")
            public void testInspection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/inspection.kt");
            }

            @TestMetadata("lambdaInObject.kt")
            public void testLambdaInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/lambdaInObject.kt");
            }

            @TestMetadata("lateInit.kt")
            public void testLateInit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/lateInit.kt");
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/localObject.kt");
            }

            @TestMetadata("multipleAreNull.kt")
            public void testMultipleAreNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/multipleAreNull.kt");
            }

            @TestMetadata("nobacking.kt")
            public void testNobacking() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/nobacking.kt");
            }

            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/open.kt");
            }

            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/openProperty.kt");
            }

            @TestMetadata("outer.kt")
            public void testOuter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/outer.kt");
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/property.kt");
            }

            @TestMetadata("propertyAccess.kt")
            public void testPropertyAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/propertyAccess.kt");
            }

            @TestMetadata("twoSecondaryConstructors.kt")
            public void testTwoSecondaryConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/twoSecondaryConstructors.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlowAnalysis extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInControlFlowAnalysis() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignedInFinally.kt")
            public void testAssignedInFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInFinally.kt");
            }

            @TestMetadata("assignmentInLocalsInConstructor.kt")
            public void testAssignmentInLocalsInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignmentInLocalsInConstructor.kt");
            }

            @TestMetadata("backingFieldInsideGetter_after.kt")
            public void testBackingFieldInsideGetter_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_after.kt");
            }

            @TestMetadata("backingFieldInsideGetter_before.kt")
            public void testBackingFieldInsideGetter_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_before.kt");
            }

            @TestMetadata("breakContinueInTryFinally.kt")
            public void testBreakContinueInTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinally.kt");
            }

            @TestMetadata("breakInsideLocal.kt")
            public void testBreakInsideLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakInsideLocal.kt");
            }

            @TestMetadata("breakOrContinueInLoopCondition.kt")
            public void testBreakOrContinueInLoopCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakOrContinueInLoopCondition.kt");
            }

            @TestMetadata("checkInnerLocalDeclarations.kt")
            public void testCheckInnerLocalDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkInnerLocalDeclarations.kt");
            }

            @TestMetadata("checkPropertyAccessor.kt")
            public void testCheckPropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkPropertyAccessor.kt");
            }

            @TestMetadata("constructorPropertyInterdependence.kt")
            public void testConstructorPropertyInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/constructorPropertyInterdependence.kt");
            }

            @TestMetadata("definiteReturnInWhen.kt")
            public void testDefiniteReturnInWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturnInWhen.kt");
            }

            @TestMetadata("delegatedPropertyEarlyAccess.kt")
            public void testDelegatedPropertyEarlyAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedPropertyEarlyAccess.kt");
            }

            @TestMetadata("doWhileAssignment.kt")
            public void testDoWhileAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileAssignment.kt");
            }

            @TestMetadata("doWhileNotDefined.kt")
            public void testDoWhileNotDefined() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileNotDefined.kt");
            }

            @TestMetadata("elvisNotProcessed.kt")
            public void testElvisNotProcessed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/elvisNotProcessed.kt");
            }

            @TestMetadata("enumCompanionInterdependence.kt")
            public void testEnumCompanionInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumCompanionInterdependence.kt");
            }

            @TestMetadata("enumInterdependence.kt")
            public void testEnumInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumInterdependence.kt");
            }

            @TestMetadata("fieldAsClassDelegate.kt")
            public void testFieldAsClassDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/fieldAsClassDelegate.kt");
            }

            @TestMetadata("infiniteLoops.kt")
            public void testInfiniteLoops() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/infiniteLoops.kt");
            }

            @TestMetadata("initializationInLambda.kt")
            public void testInitializationInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLambda.kt");
            }

            @TestMetadata("initializationInLocalClass.kt")
            public void testInitializationInLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalClass.kt");
            }

            @TestMetadata("initializationInLocalFun.kt")
            public void testInitializationInLocalFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalFun.kt");
            }

            @TestMetadata("initializationInLocalViaExplicitThis_after.kt")
            public void testInitializationInLocalViaExplicitThis_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_after.kt");
            }

            @TestMetadata("initializationInLocalViaExplicitThis_before.kt")
            public void testInitializationInLocalViaExplicitThis_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_before.kt");
            }

            @TestMetadata("kt1001.kt")
            public void testKt1001() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1001.kt");
            }

            @TestMetadata("kt1027.kt")
            public void testKt1027() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1027.kt");
            }

            @TestMetadata("kt1066.kt")
            public void testKt1066() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1066.kt");
            }

            @TestMetadata("kt10805.kt")
            public void testKt10805() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10805.kt");
            }

            @TestMetadata("kt10823.kt")
            public void testKt10823() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10823.kt");
            }

            @TestMetadata("kt1156.kt")
            public void testKt1156() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1156.kt");
            }

            @TestMetadata("kt1185enums.kt")
            public void testKt1185enums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1185enums.kt");
            }

            @TestMetadata("kt1189.kt")
            public void testKt1189() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1189.kt");
            }

            @TestMetadata("kt1191.kt")
            public void testKt1191() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1191.kt");
            }

            @TestMetadata("kt1219.1301.kt")
            public void testKt1219_1301() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1219.1301.kt");
            }

            @TestMetadata("kt1571.kt")
            public void testKt1571() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1571.kt");
            }

            @TestMetadata("kt1977.kt")
            public void testKt1977() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1977.kt");
            }

            @TestMetadata("kt2166_kt2103.kt")
            public void testKt2166_kt2103() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2166_kt2103.kt");
            }

            @TestMetadata("kt2226.kt")
            public void testKt2226() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2226.kt");
            }

            @TestMetadata("kt2330.kt")
            public void testKt2330() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2330.kt");
            }

            @TestMetadata("kt2334.kt")
            public void testKt2334() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2334.kt");
            }

            @TestMetadata("kt2369.kt")
            public void testKt2369() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2369.kt");
            }

            @TestMetadata("kt2845.kt")
            public void testKt2845() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2845.kt");
            }

            @TestMetadata("kt2960.kt")
            public void testKt2960() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2960.kt");
            }

            @TestMetadata("kt2972.kt")
            public void testKt2972() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2972.kt");
            }

            @TestMetadata("kt3444.kt")
            public void testKt3444() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3444.kt");
            }

            @TestMetadata("kt3501.kt")
            public void testKt3501() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3501.kt");
            }

            @TestMetadata("kt4126.kt")
            public void testKt4126() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4126.kt");
            }

            @TestMetadata("kt4405.kt")
            public void testKt4405() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4405.kt");
            }

            @TestMetadata("kt510.kt")
            public void testKt510() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt510.kt");
            }

            @TestMetadata("kt607.kt")
            public void testKt607() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt607.kt");
            }

            @TestMetadata("kt609.kt")
            public void testKt609() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt609.kt");
            }

            @TestMetadata("kt610.kt")
            public void testKt610() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt610.kt");
            }

            @TestMetadata("kt6788.kt")
            public void testKt6788() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt6788.kt");
            }

            @TestMetadata("kt776.kt")
            public void testKt776() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt776.kt");
            }

            @TestMetadata("kt843.kt")
            public void testKt843() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt843.kt");
            }

            @TestMetadata("kt897.kt")
            public void testKt897() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt897.kt");
            }

            @TestMetadata("localClasses.kt")
            public void testLocalClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localClasses.kt");
            }

            @TestMetadata("localObjectInConstructor.kt")
            public void testLocalObjectInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localObjectInConstructor.kt");
            }

            @TestMetadata("mainWithWarningOnUnusedParam.kt")
            public void testMainWithWarningOnUnusedParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/mainWithWarningOnUnusedParam.kt");
            }

            @TestMetadata("mainWithoutWarningOnUnusedParam.kt")
            public void testMainWithoutWarningOnUnusedParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/mainWithoutWarningOnUnusedParam.kt");
            }

            @TestMetadata("nestedTryFinally.kt")
            public void testNestedTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nestedTryFinally.kt");
            }

            @TestMetadata("nonLocalReturnUnreachable.kt")
            public void testNonLocalReturnUnreachable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnUnreachable.kt");
            }

            @TestMetadata("nonLocalReturnWithFinally.kt")
            public void testNonLocalReturnWithFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnWithFinally.kt");
            }

            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/privateSetter.kt");
            }

            @TestMetadata("propertiesInitWithOtherInstance.kt")
            public void testPropertiesInitWithOtherInstance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstance.kt");
            }

            @TestMetadata("propertiesInitWithOtherInstanceInner.kt")
            public void testPropertiesInitWithOtherInstanceInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceInner.kt");
            }

            @TestMetadata("propertiesInitWithOtherInstanceThisLabel.kt")
            public void testPropertiesInitWithOtherInstanceThisLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceThisLabel.kt");
            }

            @TestMetadata("propertiesOrderInPackage.kt")
            public void testPropertiesOrderInPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesOrderInPackage.kt");
            }

            @TestMetadata("reassignmentInTryCatch.kt")
            public void testReassignmentInTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatch.kt");
            }

            @TestMetadata("reassignmentInTryCatchWithJumps.kt")
            public void testReassignmentInTryCatchWithJumps() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatchWithJumps.kt");
            }

            @TestMetadata("referenceToPropertyInitializer.kt")
            public void testReferenceToPropertyInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/referenceToPropertyInitializer.kt");
            }

            @TestMetadata("repeatUnitializedErrorOnlyForLocalVars.kt")
            public void testRepeatUnitializedErrorOnlyForLocalVars() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/repeatUnitializedErrorOnlyForLocalVars.kt");
            }

            @TestMetadata("scopeOfAnonymousInitializer.kt")
            public void testScopeOfAnonymousInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/scopeOfAnonymousInitializer.kt");
            }

            @TestMetadata("throwInLambda.kt")
            public void testThrowInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/throwInLambda.kt");
            }

            @TestMetadata("tryWithAssignmentUsedInCatch.kt")
            public void testTryWithAssignmentUsedInCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/tryWithAssignmentUsedInCatch.kt");
            }

            @TestMetadata("uninitializedInLocalDeclarations.kt")
            public void testUninitializedInLocalDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedInLocalDeclarations.kt");
            }

            @TestMetadata("UninitializedOrReassignedVariables.kt")
            public void testUninitializedOrReassignedVariables() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedOrReassignedVariables.kt");
            }

            @TestMetadata("unmappedArgs.kt")
            public void testUnmappedArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unmappedArgs.kt");
            }

            @TestMetadata("unresolvedReference.kt")
            public void testUnresolvedReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unresolvedReference.kt");
            }

            @TestMetadata("unusedInAnonymous.kt")
            public void testUnusedInAnonymous() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unusedInAnonymous.kt");
            }

            @TestMetadata("useUninitializedInLambda.kt")
            public void testUseUninitializedInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/useUninitializedInLambda.kt");
            }

            @TestMetadata("varInitializationInIfInCycle.kt")
            public void testVarInitializationInIfInCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/varInitializationInIfInCycle.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DeadCode extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDeadCode() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("commasAndWhitespaces.kt")
                public void testCommasAndWhitespaces() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commasAndWhitespaces.kt");
                }

                @TestMetadata("commentsInDeadCode.kt")
                public void testCommentsInDeadCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commentsInDeadCode.kt");
                }

                @TestMetadata("deadCallInInvokeCall.kt")
                public void testDeadCallInInvokeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInInvokeCall.kt");
                }

                @TestMetadata("deadCallInReceiver.kt")
                public void testDeadCallInReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInReceiver.kt");
                }

                @TestMetadata("deadCodeDifferentExamples.kt")
                public void testDeadCodeDifferentExamples() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeDifferentExamples.kt");
                }

                @TestMetadata("deadCodeFromDifferentSources.kt")
                public void testDeadCodeFromDifferentSources() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeFromDifferentSources.kt");
                }

                @TestMetadata("deadCodeInArrayAccess.kt")
                public void testDeadCodeInArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInArrayAccess.kt");
                }

                @TestMetadata("deadCodeInAssignment.kt")
                public void testDeadCodeInAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInAssignment.kt");
                }

                @TestMetadata("deadCodeInBinaryExpressions.kt")
                public void testDeadCodeInBinaryExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInBinaryExpressions.kt");
                }

                @TestMetadata("deadCodeInCalls.kt")
                public void testDeadCodeInCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInCalls.kt");
                }

                @TestMetadata("deadCodeInDeadCode.kt")
                public void testDeadCodeInDeadCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInDeadCode.kt");
                }

                @TestMetadata("deadCodeInIf.kt")
                public void testDeadCodeInIf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInIf.kt");
                }

                @TestMetadata("deadCodeInInnerExpressions.kt")
                public void testDeadCodeInInnerExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInInnerExpressions.kt");
                }

                @TestMetadata("deadCodeInLocalDeclarations.kt")
                public void testDeadCodeInLocalDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLocalDeclarations.kt");
                }

                @TestMetadata("deadCodeInLoops.kt")
                public void testDeadCodeInLoops() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLoops.kt");
                }

                @TestMetadata("deadCodeInReturn.kt")
                public void testDeadCodeInReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInReturn.kt");
                }

                @TestMetadata("deadCodeInUnaryExpr.kt")
                public void testDeadCodeInUnaryExpr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInUnaryExpr.kt");
                }

                @TestMetadata("deadCodeInWhileFromBreak.kt")
                public void testDeadCodeInWhileFromBreak() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInWhileFromBreak.kt");
                }

                @TestMetadata("expressionInUnitLiteral.kt")
                public void testExpressionInUnitLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/expressionInUnitLiteral.kt");
                }

                @TestMetadata("kt2585_1.kt")
                public void testKt2585_1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_1.kt");
                }

                @TestMetadata("kt2585_2.kt")
                public void testKt2585_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_2.kt");
                }

                @TestMetadata("kt2585_3.kt")
                public void testKt2585_3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_3.kt");
                }

                @TestMetadata("kt3162tryAsInitializer.kt")
                public void testKt3162tryAsInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt3162tryAsInitializer.kt");
                }

                @TestMetadata("kt5200DeadCodeInLambdas.kt")
                public void testKt5200DeadCodeInLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt5200DeadCodeInLambdas.kt");
                }

                @TestMetadata("returnInDeadLambda.kt")
                public void testReturnInDeadLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/returnInDeadLambda.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefiniteReturn extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDefiniteReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt3444_ReturnFromLocalFunctions.kt")
                public void testKt3444_ReturnFromLocalFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt3444_ReturnFromLocalFunctions.kt");
                }

                @TestMetadata("kt4034.kt")
                public void testKt4034() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt4034.kt");
                }

                @TestMetadata("ReturnFromFunctionInObject.kt")
                public void testReturnFromFunctionInObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/ReturnFromFunctionInObject.kt");
                }

                @TestMetadata("simpleClass.kt")
                public void testSimpleClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/simpleClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnnecessaryLateinit extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInUnnecessaryLateinit() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("lateinitRecursiveInLambda.kt")
                public void testLateinitRecursiveInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitRecursiveInLambda.kt");
                }

                @TestMetadata("lateinitWithConstructor.kt")
                public void testLateinitWithConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithConstructor.kt");
                }

                @TestMetadata("lateinitWithErroneousDelegation.kt")
                public void testLateinitWithErroneousDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithErroneousDelegation.kt");
                }

                @TestMetadata("lateinitWithInit.kt")
                public void testLateinitWithInit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithInit.kt");
                }

                @TestMetadata("lateinitWithMultipleConstructors.kt")
                public void testLateinitWithMultipleConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
                }

                @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
                public void testLateinitWithMultipleConstructorsAndDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
                }

                @TestMetadata("lateinitWithPlusAssign.kt")
                public void testLateinitWithPlusAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPlusAssign.kt");
                }

                @TestMetadata("lateinitWithPrimaryConstructorAndConstructor.kt")
                public void testLateinitWithPrimaryConstructorAndConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPrimaryConstructorAndConstructor.kt");
                }

                @TestMetadata("normalLateinit.kt")
                public void testNormalLateinit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinit.kt");
                }

                @TestMetadata("normalLateinitWithTwoConstructors.kt")
                public void testNormalLateinitWithTwoConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinitWithTwoConstructors.kt");
                }

                @TestMetadata("secondaryConstructorDelegateItself.kt")
                public void testSecondaryConstructorDelegateItself() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
                }

                @TestMetadata("secondaryConstructorDelegateLoop.kt")
                public void testSecondaryConstructorDelegateLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateLoop.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/controlStructures")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlStructures extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInControlStructures() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlStructures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("catchGenerics.kt")
            public void testCatchGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchGenerics.kt");
            }

            @TestMetadata("catchInnerClassesOfGenerics.kt")
            public void testCatchInnerClassesOfGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics.kt");
            }

            @TestMetadata("catchInnerClassesOfGenerics_deprecation.kt")
            public void testCatchInnerClassesOfGenerics_deprecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics_deprecation.kt");
            }

            @TestMetadata("catchWithDefault.kt")
            public void testCatchWithDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchWithDefault.kt");
            }

            @TestMetadata("catchingLocalClassesCapturingTypeParameters.kt")
            public void testCatchingLocalClassesCapturingTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchingLocalClassesCapturingTypeParameters.kt");
            }

            @TestMetadata("commonSupertypeOfT.kt")
            public void testCommonSupertypeOfT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/commonSupertypeOfT.kt");
            }

            @TestMetadata("continueAndBreakLabelWithSameFunctionName.kt")
            public void testContinueAndBreakLabelWithSameFunctionName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/continueAndBreakLabelWithSameFunctionName.kt");
            }

            @TestMetadata("emptyIf.kt")
            public void testEmptyIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/emptyIf.kt");
            }

            @TestMetadata("ForLoopWithExtensionIteratorOnNullable.kt")
            public void testForLoopWithExtensionIteratorOnNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForLoopWithExtensionIteratorOnNullable.kt");
            }

            @TestMetadata("forLoopWithNullableRange.kt")
            public void testForLoopWithNullableRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/forLoopWithNullableRange.kt");
            }

            @TestMetadata("forWithNullableIterator.kt")
            public void testForWithNullableIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/forWithNullableIterator.kt");
            }

            @TestMetadata("ForWithoutBraces.kt")
            public void testForWithoutBraces() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForWithoutBraces.kt");
            }

            @TestMetadata("ForbidStatementAsDirectFunctionBody.kt")
            public void testForbidStatementAsDirectFunctionBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForbidStatementAsDirectFunctionBody.kt");
            }

            @TestMetadata("ifElseIntersection.kt")
            public void testIfElseIntersection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifElseIntersection.kt");
            }

            @TestMetadata("ifInResultOfLambda.kt")
            public void testIfInResultOfLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifInResultOfLambda.kt");
            }

            @TestMetadata("ifToAnyDiscriminatingUsages.kt")
            public void testIfToAnyDiscriminatingUsages() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifToAnyDiscriminatingUsages.kt");
            }

            @TestMetadata("ifWhenToAnyComplexExpressions.kt")
            public void testIfWhenToAnyComplexExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenToAnyComplexExpressions.kt");
            }

            @TestMetadata("ifWhenWithoutElse.kt")
            public void testIfWhenWithoutElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenWithoutElse.kt");
            }

            @TestMetadata("improperElseInExpression.kt")
            public void testImproperElseInExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/improperElseInExpression.kt");
            }

            @TestMetadata("jumpAcrossFunctionBoundary.kt")
            public void testJumpAcrossFunctionBoundary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/jumpAcrossFunctionBoundary.kt");
            }

            @TestMetadata("kt10322.kt")
            public void testKt10322() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10322.kt");
            }

            @TestMetadata("kt10706.kt")
            public void testKt10706() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10706.kt");
            }

            @TestMetadata("kt10717.kt")
            public void testKt10717() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10717.kt");
            }

            @TestMetadata("kt1075.kt")
            public void testKt1075() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt1075.kt");
            }

            @TestMetadata("kt4310.kt")
            public void testKt4310() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt4310.kt");
            }

            @TestMetadata("kt657.kt")
            public void testKt657() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt657.kt");
            }

            @TestMetadata("kt770.kt351.kt735_StatementType.kt")
            public void testKt770_kt351_kt735_StatementType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt770.kt351.kt735_StatementType.kt");
            }

            @TestMetadata("kt786.kt")
            public void testKt786() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt786.kt");
            }

            @TestMetadata("kt799.kt")
            public void testKt799() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt799.kt");
            }

            @TestMetadata("lambdasInExclExclAndElvis.kt")
            public void testLambdasInExclExclAndElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/lambdasInExclExclAndElvis.kt");
            }

            @TestMetadata("localReturnInsidePropertyAccessor.kt")
            public void testLocalReturnInsidePropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/localReturnInsidePropertyAccessor.kt");
            }

            @TestMetadata("notAFunctionLabel_after.kt")
            public void testNotAFunctionLabel_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/notAFunctionLabel_after.kt");
            }

            @TestMetadata("notAFunctionLabel_before.kt")
            public void testNotAFunctionLabel_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/notAFunctionLabel_before.kt");
            }

            @TestMetadata("redundantLabel.kt")
            public void testRedundantLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/redundantLabel.kt");
            }

            @TestMetadata("specialConstructsAndPlatformTypes.kt")
            public void testSpecialConstructsAndPlatformTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsAndPlatformTypes.kt");
            }

            @TestMetadata("specialConstructsWithNullableExpectedType.kt")
            public void testSpecialConstructsWithNullableExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsWithNullableExpectedType.kt");
            }

            @TestMetadata("tryReturnType.kt")
            public void testTryReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/tryReturnType.kt");
            }

            @TestMetadata("typeInferenceForExclExcl.kt")
            public void testTypeInferenceForExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/typeInferenceForExclExcl.kt");
            }

            @TestMetadata("valVarCatchParameter.kt")
            public void testValVarCatchParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/valVarCatchParameter.kt");
            }

            @TestMetadata("valVarLoopParameter.kt")
            public void testValVarLoopParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/valVarLoopParameter.kt");
            }

            @TestMetadata("whenInResultOfLambda.kt")
            public void testWhenInResultOfLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/whenInResultOfLambda.kt");
            }

            @TestMetadata("whenToAnyDiscriminatingUsages.kt")
            public void testWhenToAnyDiscriminatingUsages() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/whenToAnyDiscriminatingUsages.kt");
            }

            @TestMetadata("when.kt234.kt973.kt")
            public void testWhen_kt234_kt973() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/when.kt234.kt973.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/coroutines")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coroutines extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCoroutines() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/coroutines/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReference extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invokeOutideSuspend.kt")
                public void testInvokeOutideSuspend() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/invokeOutideSuspend.kt");
                }

                @TestMetadata("outsideSuspend.kt")
                public void testOutsideSuspend() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/outsideSuspend.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CyclicHierarchy extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCyclicHierarchy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classIndirectlyInheritsNested.kt")
            public void testClassIndirectlyInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classIndirectlyInheritsNested.kt");
            }

            @TestMetadata("classInheritsNested.kt")
            public void testClassInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classInheritsNested.kt");
            }

            @TestMetadata("commonSupertypeForCyclicAndUsualTypes.kt")
            public void testCommonSupertypeForCyclicAndUsualTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicAndUsualTypes.kt");
            }

            @TestMetadata("commonSupertypeForCyclicTypes.kt")
            public void testCommonSupertypeForCyclicTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicTypes.kt");
            }

            @TestMetadata("cyclicHierarchy.kt")
            public void testCyclicHierarchy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/cyclicHierarchy.kt");
            }

            @TestMetadata("javaJavaCycle.kt")
            public void testJavaJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaCycle.kt");
            }

            @TestMetadata("javaJavaNested.kt")
            public void testJavaJavaNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaNested.kt");
            }

            @TestMetadata("javaKotlinJavaCycle.kt")
            public void testJavaKotlinJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaKotlinJavaCycle.kt");
            }

            @TestMetadata("kotlinJavaCycle.kt")
            public void testKotlinJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaCycle.kt");
            }

            @TestMetadata("kotlinJavaKotlinCycle.kt")
            public void testKotlinJavaKotlinCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaKotlinCycle.kt");
            }

            @TestMetadata("kotlinJavaNestedCycle.kt")
            public void testKotlinJavaNestedCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaNestedCycle.kt");
            }

            @TestMetadata("kt303.kt")
            public void testKt303() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kt303.kt");
            }

            @TestMetadata("nestedClassInSuperClassParameter.kt")
            public void testNestedClassInSuperClassParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/nestedClassInSuperClassParameter.kt");
            }

            @TestMetadata("objectInheritsNested.kt")
            public void testObjectInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/objectInheritsNested.kt");
            }

            @TestMetadata("twoClassesWithNestedCycle.kt")
            public void testTwoClassesWithNestedCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/twoClassesWithNestedCycle.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WithCompanion extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInWithCompanion() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("everythingInOneScope_after.kt")
                public void testEverythingInOneScope_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_after.kt");
                }

                @TestMetadata("everythingInOneScope_before.kt")
                public void testEverythingInOneScope_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_before.kt");
                }

                @TestMetadata("noMembers_after.kt")
                public void testNoMembers_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_after.kt");
                }

                @TestMetadata("noMembers_before.kt")
                public void testNoMembers_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_before.kt");
                }

                @TestMetadata("onlyInterfaces_after.kt")
                public void testOnlyInterfaces_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_after.kt");
                }

                @TestMetadata("onlyInterfaces_before.kt")
                public void testOnlyInterfaces_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_before.kt");
                }

                @TestMetadata("typeIsLowEnough.kt")
                public void testTypeIsLowEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/typeIsLowEnough.kt");
                }

                @TestMetadata("withIrrelevantInterface_after.kt")
                public void testWithIrrelevantInterface_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_after.kt");
                }

                @TestMetadata("withIrrelevantInterface_before.kt")
                public void testWithIrrelevantInterface_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_before.kt");
                }

                @TestMetadata("withMembers_after.kt")
                public void testWithMembers_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_after.kt");
                }

                @TestMetadata("withMembers_before.kt")
                public void testWithMembers_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_before.kt");
                }

                @TestMetadata("withoutTypeReference.kt")
                public void testWithoutTypeReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withoutTypeReference.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataClasses extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDataClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("componentNamedComponent1.kt")
            public void testComponentNamedComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/componentNamedComponent1.kt");
            }

            @TestMetadata("conflictingCopyOverloads.kt")
            public void testConflictingCopyOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingCopyOverloads.kt");
            }

            @TestMetadata("conflictingOverloads.kt")
            public void testConflictingOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingOverloads.kt");
            }

            @TestMetadata("copyOfPrivateClass.kt")
            public void testCopyOfPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/copyOfPrivateClass.kt");
            }

            @TestMetadata("dataClassExplicitlyOverridingCopyNoDefaults.kt")
            public void testDataClassExplicitlyOverridingCopyNoDefaults() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyNoDefaults.kt");
            }

            @TestMetadata("dataClassExplicitlyOverridingCopyWithDefaults.kt")
            public void testDataClassExplicitlyOverridingCopyWithDefaults() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyWithDefaults.kt");
            }

            @TestMetadata("dataClassNoName.kt")
            public void testDataClassNoName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNoName.kt");
            }

            @TestMetadata("dataClassNotOverridingCopy.kt")
            public void testDataClassNotOverridingCopy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNotOverridingCopy.kt");
            }

            @TestMetadata("dataClassOverridingCopy_lv12.kt")
            public void testDataClassOverridingCopy_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv12.kt");
            }

            @TestMetadata("dataClassOverridingCopy_lv13.kt")
            public void testDataClassOverridingCopy_lv13() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv13.kt");
            }

            @TestMetadata("dataClassVarargParam.kt")
            public void testDataClassVarargParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassVarargParam.kt");
            }

            @TestMetadata("dataInheritance.kt")
            public void testDataInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataInheritance.kt");
            }

            @TestMetadata("dataObject.kt")
            public void testDataObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataObject.kt");
            }

            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/emptyConstructor.kt");
            }

            @TestMetadata("errorTypesInDataClasses.kt")
            public void testErrorTypesInDataClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/errorTypesInDataClasses.kt");
            }

            @TestMetadata("extensionComponentsOnNullable.kt")
            public void testExtensionComponentsOnNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/extensionComponentsOnNullable.kt");
            }

            @TestMetadata("finalMembersInBaseClass.kt")
            public void testFinalMembersInBaseClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/finalMembersInBaseClass.kt");
            }

            @TestMetadata("implementMethodsFromInterface.kt")
            public void testImplementMethodsFromInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementMethodsFromInterface.kt");
            }

            @TestMetadata("implementTraitWhichHasComponent1.kt")
            public void testImplementTraitWhichHasComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasComponent1.kt");
            }

            @TestMetadata("implementTraitWhichHasFinalComponent1.kt")
            public void testImplementTraitWhichHasFinalComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasFinalComponent1.kt");
            }

            @TestMetadata("innerDataClass.kt")
            public void testInnerDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/innerDataClass.kt");
            }

            @TestMetadata("innerOuterDataClass.kt")
            public void testInnerOuterDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/innerOuterDataClass.kt");
            }

            @TestMetadata("multiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclaration.kt");
            }

            @TestMetadata("multiDeclarationFor.kt")
            public void testMultiDeclarationFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclarationFor.kt");
            }

            @TestMetadata("noConstructor.kt")
            public void testNoConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/noConstructor.kt");
            }

            @TestMetadata("notADataClass.kt")
            public void testNotADataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/notADataClass.kt");
            }

            @TestMetadata("oneValParam.kt")
            public void testOneValParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/oneValParam.kt");
            }

            @TestMetadata("repeatedProperties.kt")
            public void testRepeatedProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/repeatedProperties.kt");
            }

            @TestMetadata("sealedDataClass.kt")
            public void testSealedDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/sealedDataClass.kt");
            }

            @TestMetadata("strange.kt")
            public void testStrange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/strange.kt");
            }

            @TestMetadata("twoValParams.kt")
            public void testTwoValParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/twoValParams.kt");
            }

            @TestMetadata("twoVarParams.kt")
            public void testTwoVarParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/twoVarParams.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataFlow extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDataFlow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CalleeExpression.kt")
            public void testCalleeExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/CalleeExpression.kt");
            }

            @TestMetadata("EmptyIf.kt")
            public void testEmptyIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/EmptyIf.kt");
            }

            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/IsExpression.kt");
            }

            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/WhenSubject.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Assignment extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAssignment() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/assignment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignToNewVal.kt")
                public void testAssignToNewVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/assignToNewVal.kt");
                }

                @TestMetadata("kt6118.kt")
                public void testKt6118() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/kt6118.kt");
                }

                @TestMetadata("uninitializedValIsCheck.kt")
                public void testUninitializedValIsCheck() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValIsCheck.kt");
                }

                @TestMetadata("uninitializedValNullability.kt")
                public void testUninitializedValNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValNullability.kt");
                }

                @TestMetadata("when.kt")
                public void testWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/when.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt2835.kt")
                public void testKt2835() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/kt2835.kt");
                }

                @TestMetadata("LocalClassBase.kt")
                public void testLocalClassBase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassBase.kt");
                }

                @TestMetadata("LocalClassDefaultParameters.kt")
                public void testLocalClassDefaultParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDefaultParameters.kt");
                }

                @TestMetadata("LocalClassDelegatedProperties.kt")
                public void testLocalClassDelegatedProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegatedProperties.kt");
                }

                @TestMetadata("LocalClassDelegation.kt")
                public void testLocalClassDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegation.kt");
                }

                @TestMetadata("LocalClassFunctions.kt")
                public void testLocalClassFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassFunctions.kt");
                }

                @TestMetadata("LocalClassInMemberOfLocalClass.kt")
                public void testLocalClassInMemberOfLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInMemberOfLocalClass.kt");
                }

                @TestMetadata("LocalClassInitializer.kt")
                public void testLocalClassInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInitializer.kt");
                }

                @TestMetadata("LocalClassProperty.kt")
                public void testLocalClassProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassProperty.kt");
                }

                @TestMetadata("LocalObject.kt")
                public void testLocalObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObject.kt");
                }

                @TestMetadata("LocalObjectDelegation.kt")
                public void testLocalObjectDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObjectDelegation.kt");
                }

                @TestMetadata("NestedLocalClass.kt")
                public void testNestedLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/NestedLocalClass.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataFlowInfoTraversal extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDataFlowInfoTraversal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AndOr.kt")
            public void testAndOr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AndOr.kt");
            }

            @TestMetadata("ArrayAccess.kt")
            public void testArrayAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayAccess.kt");
            }

            @TestMetadata("ArrayExpression.kt")
            public void testArrayExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayExpression.kt");
            }

            @TestMetadata("ArrayGetSetConvention.kt")
            public void testArrayGetSetConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayGetSetConvention.kt");
            }

            @TestMetadata("ArrayIndices.kt")
            public void testArrayIndices() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayIndices.kt");
            }

            @TestMetadata("Assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Assignment.kt");
            }

            @TestMetadata("AssignmentInInitializer.kt")
            public void testAssignmentInInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentInInitializer.kt");
            }

            @TestMetadata("AssignmentOperation.kt")
            public void testAssignmentOperation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentOperation.kt");
            }

            @TestMetadata("AssignmentToArrayElement.kt")
            public void testAssignmentToArrayElement() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentToArrayElement.kt");
            }

            @TestMetadata("BinaryExpression.kt")
            public void testBinaryExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpression.kt");
            }

            @TestMetadata("BinaryExpressionBooleanOperations.kt")
            public void testBinaryExpressionBooleanOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionBooleanOperations.kt");
            }

            @TestMetadata("BinaryExpressionCompareToConvention.kt")
            public void testBinaryExpressionCompareToConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionCompareToConvention.kt");
            }

            @TestMetadata("BinaryExpressionContainsConvention.kt")
            public void testBinaryExpressionContainsConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionContainsConvention.kt");
            }

            @TestMetadata("BinaryExpressionElvis.kt")
            public void testBinaryExpressionElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionElvis.kt");
            }

            @TestMetadata("BinaryExpressionEqualsConvention.kt")
            public void testBinaryExpressionEqualsConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionEqualsConvention.kt");
            }

            @TestMetadata("BinaryExpressionIdentifier.kt")
            public void testBinaryExpressionIdentifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionIdentifier.kt");
            }

            @TestMetadata("BinaryExpressionPlusConvention.kt")
            public void testBinaryExpressionPlusConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionPlusConvention.kt");
            }

            @TestMetadata("Condition.kt")
            public void testCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Condition.kt");
            }

            @TestMetadata("ContinueOuterLoop.kt")
            public void testContinueOuterLoop() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ContinueOuterLoop.kt");
            }

            @TestMetadata("DeepIf.kt")
            public void testDeepIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DeepIf.kt");
            }

            @TestMetadata("DoWhile.kt")
            public void testDoWhile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhile.kt");
            }

            @TestMetadata("DoWhileCondition.kt")
            public void testDoWhileCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhileCondition.kt");
            }

            @TestMetadata("Elvis.kt")
            public void testElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Elvis.kt");
            }

            @TestMetadata("ExclExcl.kt")
            public void testExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ExclExcl.kt");
            }

            @TestMetadata("For.kt")
            public void testFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/For.kt");
            }

            @TestMetadata("ForLoopRange.kt")
            public void testForLoopRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ForLoopRange.kt");
            }

            @TestMetadata("FunctionLiteral.kt")
            public void testFunctionLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/FunctionLiteral.kt");
            }

            @TestMetadata("IfStatement.kt")
            public void testIfStatement() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfStatement.kt");
            }

            @TestMetadata("IfThenElse.kt")
            public void testIfThenElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElse.kt");
            }

            @TestMetadata("IfThenElseBothInvalid.kt")
            public void testIfThenElseBothInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElseBothInvalid.kt");
            }

            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IsExpression.kt");
            }

            @TestMetadata("kt4332WhenBranches.kt")
            public void testKt4332WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt4332WhenBranches.kt");
            }

            @TestMetadata("kt5155WhenBranches.kt")
            public void testKt5155WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5155WhenBranches.kt");
            }

            @TestMetadata("kt5182WhenBranches.kt")
            public void testKt5182WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5182WhenBranches.kt");
            }

            @TestMetadata("ManyIfs.kt")
            public void testManyIfs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ManyIfs.kt");
            }

            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/MultiDeclaration.kt");
            }

            @TestMetadata("ObjectExpression.kt")
            public void testObjectExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ObjectExpression.kt");
            }

            @TestMetadata("QualifiedExpression.kt")
            public void testQualifiedExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/QualifiedExpression.kt");
            }

            @TestMetadata("Return.kt")
            public void testReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Return.kt");
            }

            @TestMetadata("StringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/StringTemplate.kt");
            }

            @TestMetadata("ThisSuper.kt")
            public void testThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ThisSuper.kt");
            }

            @TestMetadata("Throw.kt")
            public void testThrow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Throw.kt");
            }

            @TestMetadata("TryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryCatch.kt");
            }

            @TestMetadata("TryFinally.kt")
            public void testTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryFinally.kt");
            }

            @TestMetadata("UnaryExpression.kt")
            public void testUnaryExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/UnaryExpression.kt");
            }

            @TestMetadata("When.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/When.kt");
            }

            @TestMetadata("WhenEntryAs.kt")
            public void testWhenEntryAs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryAs.kt");
            }

            @TestMetadata("WhenEntryIs.kt")
            public void testWhenEntryIs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryIs.kt");
            }

            @TestMetadata("WhenIn.kt")
            public void testWhenIn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenIn.kt");
            }

            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenSubject.kt");
            }

            @TestMetadata("While.kt")
            public void testWhile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/While.kt");
            }

            @TestMetadata("WhileCondition.kt")
            public void testWhileCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhileCondition.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Smartcasts extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSmartcasts() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("SmartcastAmbiguitites.kt")
                public void testSmartcastAmbiguitites() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastAmbiguitites.kt");
                }

                @TestMetadata("SmartcastsForStableIdentifiers.kt")
                public void testSmartcastsForStableIdentifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastsForStableIdentifiers.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeclarationChecks extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeclarationChecks() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguousObjectExpressionType.kt")
            public void testAmbiguousObjectExpressionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ambiguousObjectExpressionType.kt");
            }

            @TestMetadata("anonymousFunAsLastExpressionInBlock.kt")
            public void testAnonymousFunAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunAsLastExpressionInBlock.kt");
            }

            @TestMetadata("anonymousFunUnusedLastExpressionInBlock.kt")
            public void testAnonymousFunUnusedLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunUnusedLastExpressionInBlock.kt");
            }

            @TestMetadata("ComponentFunctionReturnTypeMismatch.kt")
            public void testComponentFunctionReturnTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ComponentFunctionReturnTypeMismatch.kt");
            }

            @TestMetadata("ConflictingAndRedundantProjections.kt")
            public void testConflictingAndRedundantProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ConflictingAndRedundantProjections.kt");
            }

            @TestMetadata("DataFlowInMultiDeclInFor.kt")
            public void testDataFlowInMultiDeclInFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInMultiDeclInFor.kt");
            }

            @TestMetadata("DataFlowInfoInMultiDecl.kt")
            public void testDataFlowInfoInMultiDecl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInfoInMultiDecl.kt");
            }

            @TestMetadata("FunctionWithMissingNames.kt")
            public void testFunctionWithMissingNames() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/FunctionWithMissingNames.kt");
            }

            @TestMetadata("illegalModifiersOnClass.kt")
            public void testIllegalModifiersOnClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/illegalModifiersOnClass.kt");
            }

            @TestMetadata("kClassInSignature.kt")
            public void testKClassInSignature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kClassInSignature.kt");
            }

            @TestMetadata("kt1141.kt")
            public void testKt1141() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1141.kt");
            }

            @TestMetadata("kt1193.kt")
            public void testKt1193() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1193.kt");
            }

            @TestMetadata("kt2096.kt")
            public void testKt2096() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2096.kt");
            }

            @TestMetadata("kt2142.kt")
            public void testKt2142() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2142.kt");
            }

            @TestMetadata("kt2397.kt")
            public void testKt2397() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2397.kt");
            }

            @TestMetadata("kt2631_MultipleDeclaration.kt")
            public void testKt2631_MultipleDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2631_MultipleDeclaration.kt");
            }

            @TestMetadata("kt2643MultiDeclInControlFlow.kt")
            public void testKt2643MultiDeclInControlFlow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2643MultiDeclInControlFlow.kt");
            }

            @TestMetadata("kt559.kt")
            public void testKt559() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt559.kt");
            }

            @TestMetadata("localDeclarationModifiers.kt")
            public void testLocalDeclarationModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localDeclarationModifiers.kt");
            }

            @TestMetadata("localFunctionNoInheritVisibility.kt")
            public void testLocalFunctionNoInheritVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localFunctionNoInheritVisibility.kt");
            }

            @TestMetadata("LocalVariableWithNoTypeInformation.kt")
            public void testLocalVariableWithNoTypeInformation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/LocalVariableWithNoTypeInformation.kt");
            }

            @TestMetadata("localVariablesWithTypeParameters_1_3.kt")
            public void testLocalVariablesWithTypeParameters_1_3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localVariablesWithTypeParameters_1_3.kt");
            }

            @TestMetadata("localVariablesWithTypeParameters_1_4.kt")
            public void testLocalVariablesWithTypeParameters_1_4() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localVariablesWithTypeParameters_1_4.kt");
            }

            @TestMetadata("mulitpleVarargParameters.kt")
            public void testMulitpleVarargParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/mulitpleVarargParameters.kt");
            }

            @TestMetadata("MultiDeclarationErrors.kt")
            public void testMultiDeclarationErrors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/MultiDeclarationErrors.kt");
            }

            @TestMetadata("namedFunAsLastExpressionInBlock.kt")
            public void testNamedFunAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/namedFunAsLastExpressionInBlock.kt");
            }

            @TestMetadata("packageDeclarationModifiers.kt")
            public void testPackageDeclarationModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/packageDeclarationModifiers.kt");
            }

            @TestMetadata("propertyInPackageHasNoInheritVisibility.kt")
            public void testPropertyInPackageHasNoInheritVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/propertyInPackageHasNoInheritVisibility.kt");
            }

            @TestMetadata("RedeclarationsInMultiDecl.kt")
            public void testRedeclarationsInMultiDecl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/RedeclarationsInMultiDecl.kt");
            }

            @TestMetadata("ScalaLikeNamedFun.kt")
            public void testScalaLikeNamedFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ScalaLikeNamedFun.kt");
            }

            @TestMetadata("sealedOnMembers.kt")
            public void testSealedOnMembers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/sealedOnMembers.kt");
            }

            @TestMetadata("unambiguousObjectExpressionType.kt")
            public void testUnambiguousObjectExpressionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/unambiguousObjectExpressionType.kt");
            }

            @TestMetadata("valVarFunctionParameter.kt")
            public void testValVarFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/valVarFunctionParameter.kt");
            }

            @TestMetadata("VarianceOnFunctionAndPropertyTypeParameters.kt")
            public void testVarianceOnFunctionAndPropertyTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/VarianceOnFunctionAndPropertyTypeParameters.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DestructuringDeclarations extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDestructuringDeclarations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("destructuringDeclarationAssignedUnresolved.kt")
                public void testDestructuringDeclarationAssignedUnresolved() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationAssignedUnresolved.kt");
                }

                @TestMetadata("destructuringDeclarationMissingInitializer.kt")
                public void testDestructuringDeclarationMissingInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationMissingInitializer.kt");
                }

                @TestMetadata("DoubleDeclForLoop.kt")
                public void testDoubleDeclForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/DoubleDeclForLoop.kt");
                }

                @TestMetadata("FolLoopTypeComponentTypeMismatch.kt")
                public void testFolLoopTypeComponentTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/FolLoopTypeComponentTypeMismatch.kt");
                }

                @TestMetadata("ForLoopComponentFunctionAmbiguity.kt")
                public void testForLoopComponentFunctionAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionAmbiguity.kt");
                }

                @TestMetadata("ForLoopComponentFunctionMissing.kt")
                public void testForLoopComponentFunctionMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionMissing.kt");
                }

                @TestMetadata("ForLoopMissingLoopParameter.kt")
                public void testForLoopMissingLoopParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopMissingLoopParameter.kt");
                }

                @TestMetadata("ForLoopWithExtensions.kt")
                public void testForLoopWithExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopWithExtensions.kt");
                }

                @TestMetadata("ForWithExplicitTypes.kt")
                public void testForWithExplicitTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForWithExplicitTypes.kt");
                }

                @TestMetadata("kt2829.kt")
                public void testKt2829() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/kt2829.kt");
                }

                @TestMetadata("lastDestructuringDeclarationInBlock.kt")
                public void testLastDestructuringDeclarationInBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/lastDestructuringDeclarationInBlock.kt");
                }

                @TestMetadata("RedeclarationInForLoop.kt")
                public void testRedeclarationInForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/RedeclarationInForLoop.kt");
                }

                @TestMetadata("SingleDeclForLoop.kt")
                public void testSingleDeclForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/SingleDeclForLoop.kt");
                }

                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/underscore.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FiniteBoundRestriction extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFiniteBoundRestriction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CasesWithOneTypeParameter.kt")
                public void testCasesWithOneTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithOneTypeParameter.kt");
                }

                @TestMetadata("CasesWithTwoTypeParameters.kt")
                public void testCasesWithTwoTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithTwoTypeParameters.kt");
                }

                @TestMetadata("JavaSuperType.kt")
                public void testJavaSuperType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/JavaSuperType.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonExpansiveInheritanceRestriction extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNonExpansiveInheritanceRestriction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("JavaWithKotlin.kt")
                public void testJavaWithKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin.kt");
                }

                @TestMetadata("JavaWithKotlin2.kt")
                public void testJavaWithKotlin2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin2.kt");
                }

                @TestMetadata("PureKotlin.kt")
                public void testPureKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/PureKotlin.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultArguments extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/diagnostics/tests/defaultArguments/kt5232.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/defaultArguments/superCall.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegatedProperty extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("absentErrorAboutInitializer.kt")
            public void testAbsentErrorAboutInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutInitializer.kt");
            }

            @TestMetadata("absentErrorAboutType.kt")
            public void testAbsentErrorAboutType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutType.kt");
            }

            @TestMetadata("abstractDelegatedProperty.kt")
            public void testAbstractDelegatedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/abstractDelegatedProperty.kt");
            }

            public void testAllFilesPresentInDelegatedProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("backingField.kt")
            public void testBackingField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/backingField.kt");
            }

            @TestMetadata("defaultGetter.kt")
            public void testDefaultGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultGetter.kt");
            }

            @TestMetadata("defaultSetter.kt")
            public void testDefaultSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultSetter.kt");
            }

            @TestMetadata("delegatedPropertyOverridedInTrait.kt")
            public void testDelegatedPropertyOverridedInTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTrait.kt");
            }

            @TestMetadata("delegatedPropertyOverridedInTraitTypeMismatch.kt")
            public void testDelegatedPropertyOverridedInTraitTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTraitTypeMismatch.kt");
            }

            @TestMetadata("disallowImplInTypeParameter.kt")
            public void testDisallowImplInTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/disallowImplInTypeParameter.kt");
            }

            @TestMetadata("genericGetter.kt")
            public void testGenericGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/genericGetter.kt");
            }

            @TestMetadata("getterWithSubtype.kt")
            public void testGetterWithSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/getterWithSubtype.kt");
            }

            @TestMetadata("inTrait.kt")
            public void testInTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/inTrait.kt");
            }

            @TestMetadata("incompleteTypeInference.kt")
            public void testIncompleteTypeInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/incompleteTypeInference.kt");
            }

            @TestMetadata("kt4640.kt")
            public void testKt4640() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt4640.kt");
            }

            @TestMetadata("localVariable.kt")
            public void testLocalVariable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/localVariable.kt");
            }

            @TestMetadata("localWithSmartCast.kt")
            public void testLocalWithSmartCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/localWithSmartCast.kt");
            }

            @TestMetadata("missedGetter.kt")
            public void testMissedGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedGetter.kt");
            }

            @TestMetadata("missedSetter.kt")
            public void testMissedSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedSetter.kt");
            }

            @TestMetadata("nonDefaultAccessors.kt")
            public void testNonDefaultAccessors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/nonDefaultAccessors.kt");
            }

            @TestMetadata("propertyDefferedType.kt")
            public void testPropertyDefferedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/propertyDefferedType.kt");
            }

            @TestMetadata("recursiveType.kt")
            public void testRecursiveType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/recursiveType.kt");
            }

            @TestMetadata("redundantGetter.kt")
            public void testRedundantGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantGetter.kt");
            }

            @TestMetadata("redundantSetter.kt")
            public void testRedundantSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantSetter.kt");
            }

            @TestMetadata("setterThisTypeMismatch.kt")
            public void testSetterThisTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterThisTypeMismatch.kt");
            }

            @TestMetadata("setterWithSupertype.kt")
            public void testSetterWithSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterWithSupertype.kt");
            }

            @TestMetadata("severalReceivers.kt")
            public void testSeveralReceivers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/severalReceivers.kt");
            }

            @TestMetadata("thisInDelegate.kt")
            public void testThisInDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisInDelegate.kt");
            }

            @TestMetadata("thisOfAnyType.kt")
            public void testThisOfAnyType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfAnyType.kt");
            }

            @TestMetadata("thisOfNothingNullableType.kt")
            public void testThisOfNothingNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingNullableType.kt");
            }

            @TestMetadata("thisOfNothingType.kt")
            public void testThisOfNothingType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingType.kt");
            }

            @TestMetadata("twoGetMethods.kt")
            public void testTwoGetMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/twoGetMethods.kt");
            }

            @TestMetadata("typeMismatchForGetReturnType.kt")
            public void testTypeMismatchForGetReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetReturnType.kt");
            }

            @TestMetadata("typeMismatchForGetWithGeneric.kt")
            public void testTypeMismatchForGetWithGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetWithGeneric.kt");
            }

            @TestMetadata("typeMismatchForSetParameter.kt")
            public void testTypeMismatchForSetParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForSetParameter.kt");
            }

            @TestMetadata("typeMismatchForThisGetParameter.kt")
            public void testTypeMismatchForThisGetParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForThisGetParameter.kt");
            }

            @TestMetadata("wrongCountOfParametersInGet.kt")
            public void testWrongCountOfParametersInGet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInGet.kt");
            }

            @TestMetadata("wrongCountOfParametersInSet.kt")
            public void testWrongCountOfParametersInSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInSet.kt");
            }

            @TestMetadata("wrongSetterReturnType.kt")
            public void testWrongSetterReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongSetterReturnType.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegateExpressionAsLambda.kt")
                public void testDelegateExpressionAsLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/delegateExpressionAsLambda.kt");
                }

                @TestMetadata("differentDelegatedExpressions.kt")
                public void testDifferentDelegatedExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/differentDelegatedExpressions.kt");
                }

                @TestMetadata("extensionGet.kt")
                public void testExtensionGet() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionGet.kt");
                }

                @TestMetadata("extensionProperty.kt")
                public void testExtensionProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionProperty.kt");
                }

                @TestMetadata("genericMethodInGenericClass.kt")
                public void testGenericMethodInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethodInGenericClass.kt");
                }

                @TestMetadata("genericMethods.kt")
                public void testGenericMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethods.kt");
                }

                @TestMetadata("labeledDelegatedExpression.kt")
                public void testLabeledDelegatedExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/labeledDelegatedExpression.kt");
                }

                @TestMetadata("manyIncompleteCandidates.kt")
                public void testManyIncompleteCandidates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/manyIncompleteCandidates.kt");
                }

                @TestMetadata("noErrorsForImplicitConstraints.kt")
                public void testNoErrorsForImplicitConstraints() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noErrorsForImplicitConstraints.kt");
                }

                @TestMetadata("noExpectedTypeForSupertypeConstraint.kt")
                public void testNoExpectedTypeForSupertypeConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noExpectedTypeForSupertypeConstraint.kt");
                }

                @TestMetadata("resultTypeOfLambdaForConventionMethods.kt")
                public void testResultTypeOfLambdaForConventionMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/resultTypeOfLambdaForConventionMethods.kt");
                }

                @TestMetadata("typeOfLazyDelegatedPropertyWithObject.kt")
                public void testTypeOfLazyDelegatedPropertyWithObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/typeOfLazyDelegatedPropertyWithObject.kt");
                }

                @TestMetadata("useCompleterWithoutExpectedType.kt")
                public void testUseCompleterWithoutExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useCompleterWithoutExpectedType.kt");
                }

                @TestMetadata("useExpectedType.kt")
                public void testUseExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedType.kt");
                }

                @TestMetadata("useExpectedTypeForVal.kt")
                public void testUseExpectedTypeForVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedTypeForVal.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ProvideDelegate extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProvideDelegate() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("commonCaseForInference.kt")
                public void testCommonCaseForInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/commonCaseForInference.kt");
                }

                @TestMetadata("genericProvideDelegate.kt")
                public void testGenericProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/genericProvideDelegate.kt");
                }

                @TestMetadata("hostAndReceiver1.kt")
                public void testHostAndReceiver1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver1.kt");
                }

                @TestMetadata("hostAndReceiver2.kt")
                public void testHostAndReceiver2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver2.kt");
                }

                @TestMetadata("hostAndReceiver3.kt")
                public void testHostAndReceiver3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver3.kt");
                }

                @TestMetadata("inferenceFromReceiver1.kt")
                public void testInferenceFromReceiver1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver1.kt");
                }

                @TestMetadata("inferenceFromReceiver2.kt")
                public void testInferenceFromReceiver2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver2.kt");
                }

                @TestMetadata("localDelegatedProperty.kt")
                public void testLocalDelegatedProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/localDelegatedProperty.kt");
                }

                @TestMetadata("noOperatorModifierOnProvideDelegate.kt")
                public void testNoOperatorModifierOnProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/noOperatorModifierOnProvideDelegate.kt");
                }

                @TestMetadata("overloadResolutionForSeveralProvideDelegates.kt")
                public void testOverloadResolutionForSeveralProvideDelegates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/overloadResolutionForSeveralProvideDelegates.kt");
                }

                @TestMetadata("provideDelegateOperatorDeclaration.kt")
                public void testProvideDelegateOperatorDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateOperatorDeclaration.kt");
                }

                @TestMetadata("setValue.kt")
                public void testSetValue() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/setValue.kt");
                }

                @TestMetadata("simpleProvideDelegate.kt")
                public void testSimpleProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/simpleProvideDelegate.kt");
                }

                @TestMetadata("unsupportedOperatorProvideDelegate.kt")
                public void testUnsupportedOperatorProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/unsupportedOperatorProvideDelegate.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/delegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Delegation extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDelegation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DelegationAndOverriding.kt")
            public void testDelegationAndOverriding() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationAndOverriding.kt");
            }

            @TestMetadata("DelegationExpectedType.kt")
            public void testDelegationExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationExpectedType.kt");
            }

            @TestMetadata("DelegationNotTotrait.kt")
            public void testDelegationNotTotrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationNotTotrait.kt");
            }

            @TestMetadata("DelegationToJavaIface.kt")
            public void testDelegationToJavaIface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationToJavaIface.kt");
            }

            @TestMetadata("Delegation_ClashingFunctions.kt")
            public void testDelegation_ClashingFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ClashingFunctions.kt");
            }

            @TestMetadata("Delegation_Hierarchy.kt")
            public void testDelegation_Hierarchy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_Hierarchy.kt");
            }

            @TestMetadata("Delegation_MultipleDelegates.kt")
            public void testDelegation_MultipleDelegates() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_MultipleDelegates.kt");
            }

            @TestMetadata("Delegation_ScopeInitializationOrder.kt")
            public void testDelegation_ScopeInitializationOrder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ScopeInitializationOrder.kt");
            }

            @TestMetadata("kt8154.kt")
            public void testKt8154() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt8154.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegation/clashes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Clashes extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClashes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/clashes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("finalMemberOverridden.kt")
                public void testFinalMemberOverridden() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/finalMemberOverridden.kt");
                }

                @TestMetadata("propertyTypeMismatch.kt")
                public void testPropertyTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/propertyTypeMismatch.kt");
                }

                @TestMetadata("returnTypeMismatch.kt")
                public void testReturnTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/returnTypeMismatch.kt");
                }

                @TestMetadata("varOverriddenByVal.kt")
                public void testVarOverriddenByVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/varOverriddenByVal.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CovariantOverrides extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCovariantOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/covariantOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("fromClass.kt")
                public void testFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/fromClass.kt");
                }

                @TestMetadata("irrelevant.kt")
                public void testIrrelevant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/irrelevant.kt");
                }

                @TestMetadata("kt13952.kt")
                public void testKt13952() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/kt13952.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/simple.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MemberHidesSupertypeOverride extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("abstractOverride.kt")
                public void testAbstractOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/abstractOverride.kt");
                }

                public void testAllFilesPresentInMemberHidesSupertypeOverride() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegationToSubType.kt")
                public void testDelegationToSubType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubType.kt");
                }

                @TestMetadata("delegationToSubTypeProperty.kt")
                public void testDelegationToSubTypeProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeProperty.kt");
                }

                @TestMetadata("delegationToSubTypeWithOverride.kt")
                public void testDelegationToSubTypeWithOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverride.kt");
                }

                @TestMetadata("delegationToSubTypeWithOverrideProperty.kt")
                public void testDelegationToSubTypeWithOverrideProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverrideProperty.kt");
                }

                @TestMetadata("diamond.kt")
                public void testDiamond() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/diamond.kt");
                }

                @TestMetadata("explicitOverride.kt")
                public void testExplicitOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/explicitOverride.kt");
                }

                @TestMetadata("fakeOverrideInTheMiddle.kt")
                public void testFakeOverrideInTheMiddle() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/fakeOverrideInTheMiddle.kt");
                }

                @TestMetadata("generic.kt")
                public void testGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/generic.kt");
                }

                @TestMetadata("sameDelegationInHierarchy.kt")
                public void testSameDelegationInHierarchy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy.kt");
                }

                @TestMetadata("sameDelegationInHierarchy2.kt")
                public void testSameDelegationInHierarchy2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy2.kt");
                }

                @TestMetadata("severalDelegates.kt")
                public void testSeveralDelegates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/severalDelegates.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simple.kt");
                }

                @TestMetadata("simpleNoOverride.kt")
                public void testSimpleNoOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleNoOverride.kt");
                }

                @TestMetadata("simpleProp.kt")
                public void testSimpleProp() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleProp.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deparenthesize extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotatedSafeCall.kt")
            public void testAnnotatedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/annotatedSafeCall.kt");
            }

            @TestMetadata("checkDeparenthesizedType.kt")
            public void testCheckDeparenthesizedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/checkDeparenthesizedType.kt");
            }

            @TestMetadata("labeledSafeCall.kt")
            public void testLabeledSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/labeledSafeCall.kt");
            }

            @TestMetadata("multiParenthesizedSafeCall.kt")
            public void testMultiParenthesizedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/multiParenthesizedSafeCall.kt");
            }

            @TestMetadata("parenthesizedSafeCall.kt")
            public void testParenthesizedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/parenthesizedSafeCall.kt");
            }

            @TestMetadata("ParenthesizedVariable.kt")
            public void testParenthesizedVariable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/ParenthesizedVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/deprecated")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deprecated extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeprecated() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationUsage.kt")
            public void testAnnotationUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/annotationUsage.kt");
            }

            @TestMetadata("classWithCompanionObject.kt")
            public void testClassWithCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/classWithCompanionObject.kt");
            }

            @TestMetadata("companionObjectUsage.kt")
            public void testCompanionObjectUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/companionObjectUsage.kt");
            }

            @TestMetadata("componentUsage.kt")
            public void testComponentUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/componentUsage.kt");
            }

            @TestMetadata("deprecatedConstructor.kt")
            public void testDeprecatedConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedConstructor.kt");
            }

            @TestMetadata("deprecatedError.kt")
            public void testDeprecatedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedError.kt");
            }

            @TestMetadata("deprecatedErrorBuilder.kt")
            public void testDeprecatedErrorBuilder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedErrorBuilder.kt");
            }

            @TestMetadata("deprecatedHidden.kt")
            public void testDeprecatedHidden() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedHidden.kt");
            }

            @TestMetadata("deprecatedInheritance.kt")
            public void testDeprecatedInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance.kt");
            }

            @TestMetadata("deprecatedPropertyInheritance.kt")
            public void testDeprecatedPropertyInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance.kt");
            }

            @TestMetadata("functionUsage.kt")
            public void testFunctionUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/functionUsage.kt");
            }

            @TestMetadata("genericConstructorUsage.kt")
            public void testGenericConstructorUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/genericConstructorUsage.kt");
            }

            @TestMetadata("hiddenPropertyAccessors.kt")
            public void testHiddenPropertyAccessors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/hiddenPropertyAccessors.kt");
            }

            @TestMetadata("importJavaSamInterface.kt")
            public void testImportJavaSamInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/importJavaSamInterface.kt");
            }

            @TestMetadata("imports.kt")
            public void testImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/imports.kt");
            }

            @TestMetadata("iteratorUsage.kt")
            public void testIteratorUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/iteratorUsage.kt");
            }

            @TestMetadata("javaDeprecated.kt")
            public void testJavaDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecated.kt");
            }

            @TestMetadata("javaDeprecatedInheritance.kt")
            public void testJavaDeprecatedInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedInheritance.kt");
            }

            @TestMetadata("javaDocDeprecated.kt")
            public void testJavaDocDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDocDeprecated.kt");
            }

            @TestMetadata("nestedTypesUsage.kt")
            public void testNestedTypesUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/nestedTypesUsage.kt");
            }

            @TestMetadata("objectUsage.kt")
            public void testObjectUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/objectUsage.kt");
            }

            @TestMetadata("propertyUsage.kt")
            public void testPropertyUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyUsage.kt");
            }

            @TestMetadata("propertyUseSiteTargetedAnnotations.kt")
            public void testPropertyUseSiteTargetedAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyUseSiteTargetedAnnotations.kt");
            }

            @TestMetadata("propertyWithInvoke.kt")
            public void testPropertyWithInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyWithInvoke.kt");
            }

            @TestMetadata("thisUsage.kt")
            public void testThisUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/thisUsage.kt");
            }

            @TestMetadata("typeUsage.kt")
            public void testTypeUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typeUsage.kt");
            }

            @TestMetadata("typealiasCompanionObject.kt")
            public void testTypealiasCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasCompanionObject.kt");
            }

            @TestMetadata("typealiasConstructor.kt")
            public void testTypealiasConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasConstructor.kt");
            }

            @TestMetadata("typealiasForDeprecatedClass.kt")
            public void testTypealiasForDeprecatedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasForDeprecatedClass.kt");
            }

            @TestMetadata("typealiasUsage.kt")
            public void testTypealiasUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasUsage.kt");
            }

            @TestMetadata("unusedImport.kt")
            public void testUnusedImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/unusedImport.kt");
            }

            @TestMetadata("warningOnConstructorErrorOnClass.kt")
            public void testWarningOnConstructorErrorOnClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/warningOnConstructorErrorOnClass.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DuplicateJvmSignature extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("caseInProperties.kt")
            public void testCaseInProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/caseInProperties.kt");
            }

            @TestMetadata("missingNames.kt")
            public void testMissingNames() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/missingNames.kt");
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/vararg.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AccidentalOverrides extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("accidentalOverrideFromGrandparent.kt")
                public void testAccidentalOverrideFromGrandparent() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
                }

                public void testAllFilesPresentInAccidentalOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classFunctionOverriddenByProperty.kt")
                public void testClassFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
                }

                @TestMetadata("classFunctionOverriddenByPropertyInConstructor.kt")
                public void testClassFunctionOverriddenByPropertyInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
                }

                @TestMetadata("classFunctionOverriddenByPropertyNoGetter.kt")
                public void testClassFunctionOverriddenByPropertyNoGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
                }

                @TestMetadata("classPropertyOverriddenByFunction.kt")
                public void testClassPropertyOverriddenByFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
                }

                @TestMetadata("defaultFunction.kt")
                public void testDefaultFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/defaultFunction.kt");
                }

                @TestMetadata("delegatedFunctionOverriddenByProperty.kt")
                public void testDelegatedFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty.kt");
                }

                @TestMetadata("genericClassFunction.kt")
                public void testGenericClassFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
                }

                @TestMetadata("overridesNothing.kt")
                public void testOverridesNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/overridesNothing.kt");
                }

                @TestMetadata("privateClassFunctionOverriddenByProperty.kt")
                public void testPrivateClassFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
                }

                @TestMetadata("require.kt")
                public void testRequire() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/require.kt");
                }

                @TestMetadata("traitFunctionOverriddenByProperty.kt")
                public void testTraitFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty.kt");
                }

                @TestMetadata("traitFunctionOverriddenByPropertyNoImpl.kt")
                public void testTraitFunctionOverriddenByPropertyNoImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
                }

                @TestMetadata("traitPropertyOverriddenByFunction.kt")
                public void testTraitPropertyOverriddenByFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction.kt");
                }

                @TestMetadata("traitPropertyOverriddenByFunctionNoImpl.kt")
                public void testTraitPropertyOverriddenByFunctionNoImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bridges extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBridges() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/class.kt");
                }

                @TestMetadata("fakeOverrideTrait.kt")
                public void testFakeOverrideTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/fakeOverrideTrait.kt");
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/trait.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Erasure extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInErasure() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("clashFromInterfaceAndSuperClass.kt")
                public void testClashFromInterfaceAndSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass.kt");
                }

                @TestMetadata("collections.kt")
                public void testCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/collections.kt");
                }

                @TestMetadata("delegateToTwoTraits.kt")
                public void testDelegateToTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
                }

                @TestMetadata("delegationAndOwnMethod.kt")
                public void testDelegationAndOwnMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
                }

                @TestMetadata("delegationToTraitImplAndOwnMethod.kt")
                public void testDelegationToTraitImplAndOwnMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
                }

                @TestMetadata("extensionProperties.kt")
                public void testExtensionProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/extensionProperties.kt");
                }

                @TestMetadata("genericType.kt")
                public void testGenericType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/genericType.kt");
                }

                @TestMetadata("inheritFromTwoTraits.kt")
                public void testInheritFromTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/inheritFromTwoTraits.kt");
                }

                @TestMetadata("kotlinAndJavaCollections.kt")
                public void testKotlinAndJavaCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/nullableType.kt");
                }

                @TestMetadata("superTraitAndDelegationToTraitImpl.kt")
                public void testSuperTraitAndDelegationToTraitImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl.kt");
                }

                @TestMetadata("twoTraitsAndOwnFunction.kt")
                public void testTwoTraitsAndOwnFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction.kt");
                }

                @TestMetadata("typeMappedToJava.kt")
                public void testTypeMappedToJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeMappedToJava.kt");
                }

                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameter.kt");
                }

                @TestMetadata("typeParameterWithBound.kt")
                public void testTypeParameterWithBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
                }

                @TestMetadata("typeParameterWithTwoBounds.kt")
                public void testTypeParameterWithTwoBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
                }

                @TestMetadata("typeParameterWithTwoBoundsInWhere.kt")
                public void testTypeParameterWithTwoBoundsInWhere() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FinalMembersFromBuiltIns extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFinalMembersFromBuiltIns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumMembers.kt")
                public void testEnumMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
                }

                @TestMetadata("waitNotifyGetClass.kt")
                public void testWaitNotifyGetClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunctionAndProperty extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFunctionAndProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/class.kt");
                }

                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classObject.kt");
                }

                @TestMetadata("classPropertyInConstructor.kt")
                public void testClassPropertyInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
                }

                @TestMetadata("extensionFunctionAndNormalFunction.kt")
                public void testExtensionFunctionAndNormalFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
                }

                @TestMetadata("extensionPropertyAndFunction.kt")
                public void testExtensionPropertyAndFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
                }

                @TestMetadata("functionAndSetter.kt")
                public void testFunctionAndSetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
                }

                @TestMetadata("functionAndVar.kt")
                public void testFunctionAndVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClass.kt");
                }

                @TestMetadata("localClassInClass.kt")
                public void testLocalClassInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
                }

                @TestMetadata("nestedClass.kt")
                public void testNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/object.kt");
                }

                @TestMetadata("objectExpression.kt")
                public void testObjectExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
                }

                @TestMetadata("objectExpressionInConstructor.kt")
                public void testObjectExpressionInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
                }

                @TestMetadata("privateClassPropertyNoClash.kt")
                public void testPrivateClassPropertyNoClash() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
                }

                @TestMetadata("topLevel.kt")
                public void testTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevel.kt");
                }

                @TestMetadata("topLevelDifferentFiles.kt")
                public void testTopLevelDifferentFiles() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
                }

                @TestMetadata("topLevelGetter.kt")
                public void testTopLevelGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/trait.kt");
                }

                @TestMetadata("withErrorTypes.kt")
                public void testWithErrorTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/withErrorTypes.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecialNames extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSpecialNames() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObject.kt");
                }

                @TestMetadata("classObjectCopiedField.kt")
                public void testClassObjectCopiedField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
                }

                @TestMetadata("classObjectCopiedFieldObject.kt")
                public void testClassObjectCopiedFieldObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject.kt");
                }

                @TestMetadata("dataClassCopy.kt")
                public void testDataClassCopy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/dataClassCopy.kt");
                }

                @TestMetadata("defaults.kt")
                public void testDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/defaults.kt");
                }

                @TestMetadata("delegationBy.kt")
                public void testDelegationBy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/delegationBy.kt");
                }

                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/enum.kt");
                }

                @TestMetadata("innerClassField.kt")
                public void testInnerClassField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/innerClassField.kt");
                }

                @TestMetadata("instance.kt")
                public void testInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/instance.kt");
                }

                @TestMetadata("propertyMetadataCache.kt")
                public void testPropertyMetadataCache() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/propertyMetadataCache.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Statics extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInStatics() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("jkjk.kt")
                public void testJkjk() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/jkjk.kt");
                }

                @TestMetadata("kotlinClassExtendsJavaClass.kt")
                public void testKotlinClassExtendsJavaClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
                }

                @TestMetadata("kotlinClassExtendsJavaClassExtendsJavaClass.kt")
                public void testKotlinClassExtendsJavaClassExtendsJavaClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
                }

                @TestMetadata("kotlinClassImplementsJavaInterface.kt")
                public void testKotlinClassImplementsJavaInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
                }

                @TestMetadata("kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
                public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
                }

                @TestMetadata("kotlinMembersVsJavaNonVisibleStatics.kt")
                public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Synthesized extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSynthesized() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumValuesValueOf.kt")
                public void testEnumValuesValueOf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TraitImpl extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTraitImpl() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("oneTrait.kt")
                public void testOneTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/oneTrait.kt");
                }

                @TestMetadata("traitFunctionOverriddenByPropertyInTrait.kt")
                public void testTraitFunctionOverriddenByPropertyInTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait.kt");
                }

                @TestMetadata("traitPropertyOverriddenByFunctionInTrait.kt")
                public void testTraitPropertyOverriddenByFunctionInTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait.kt");
                }

                @TestMetadata("twoTraits.kt")
                public void testTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/twoTraits.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dynamicTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DynamicTypes extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDynamicTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dynamicTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegationBy.kt")
            public void testDelegationBy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/delegationBy.kt");
            }

            @TestMetadata("unsupported.kt")
            public void testUnsupported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/unsupported.kt");
            }

            @TestMetadata("withInvisibleSynthesized.kt")
            public void testWithInvisibleSynthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/withInvisibleSynthesized.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/enum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enum extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("AbstractEnum.kt")
            public void testAbstractEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractEnum.kt");
            }

            @TestMetadata("AbstractInEnum.kt")
            public void testAbstractInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractInEnum.kt");
            }

            @TestMetadata("AbstractOverrideInEnum.kt")
            public void testAbstractOverrideInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractOverrideInEnum.kt");
            }

            public void testAllFilesPresentInEnum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classObjectInEnum.kt")
            public void testClassObjectInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnum.kt");
            }

            @TestMetadata("classObjectInEnumPrivate.kt")
            public void testClassObjectInEnumPrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnumPrivate.kt");
            }

            @TestMetadata("commonSupertype.kt")
            public void testCommonSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/commonSupertype.kt");
            }

            @TestMetadata("compareTwoDifferentEnums.kt")
            public void testCompareTwoDifferentEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/compareTwoDifferentEnums.kt");
            }

            @TestMetadata("ConstructorCallFromOutside.kt")
            public void testConstructorCallFromOutside() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ConstructorCallFromOutside.kt");
            }

            @TestMetadata("constructorWithDefaultParametersOnly.kt")
            public void testConstructorWithDefaultParametersOnly() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/constructorWithDefaultParametersOnly.kt");
            }

            @TestMetadata("dontCreatePackageTypeForEnumEntry_after.kt")
            public void testDontCreatePackageTypeForEnumEntry_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_after.kt");
            }

            @TestMetadata("dontCreatePackageTypeForEnumEntry_before.kt")
            public void testDontCreatePackageTypeForEnumEntry_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_before.kt");
            }

            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/emptyConstructor.kt");
            }

            @TestMetadata("entryShouldBeOfEnumType.kt")
            public void testEntryShouldBeOfEnumType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/entryShouldBeOfEnumType.kt");
            }

            @TestMetadata("enumEntryCannotHaveClassObject.kt")
            public void testEnumEntryCannotHaveClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumEntryCannotHaveClassObject.kt");
            }

            @TestMetadata("enumEntryInAbstractEnum.kt")
            public void testEnumEntryInAbstractEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumEntryInAbstractEnum.kt");
            }

            @TestMetadata("enumImplementingTrait.kt")
            public void testEnumImplementingTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumImplementingTrait.kt");
            }

            @TestMetadata("enumInheritance.kt")
            public void testEnumInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumInheritance.kt");
            }

            @TestMetadata("enumIsAssignableToBuiltInEnum.kt")
            public void testEnumIsAssignableToBuiltInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumIsAssignableToBuiltInEnum.kt");
            }

            @TestMetadata("enumMissingName.kt")
            public void testEnumMissingName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumMissingName.kt");
            }

            @TestMetadata("enumModifier.kt")
            public void testEnumModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumModifier.kt");
            }

            @TestMetadata("enumStarImport.kt")
            public void testEnumStarImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumStarImport.kt");
            }

            @TestMetadata("enumSubjectTypeCheck.kt")
            public void testEnumSubjectTypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumSubjectTypeCheck.kt");
            }

            @TestMetadata("enumWithAnnotationKeyword.kt")
            public void testEnumWithAnnotationKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumWithAnnotationKeyword.kt");
            }

            @TestMetadata("enumWithEmptyName.kt")
            public void testEnumWithEmptyName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumWithEmptyName.kt");
            }

            @TestMetadata("ExplicitConstructorCall.kt")
            public void testExplicitConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ExplicitConstructorCall.kt");
            }

            @TestMetadata("extendingEnumDirectly.kt")
            public void testExtendingEnumDirectly() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/extendingEnumDirectly.kt");
            }

            @TestMetadata("extensionNamedAsEnumEntry.kt")
            public void testExtensionNamedAsEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/extensionNamedAsEnumEntry.kt");
            }

            @TestMetadata("ifEnumEntry.kt")
            public void testIfEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ifEnumEntry.kt");
            }

            @TestMetadata("importEnumFromJava.kt")
            public void testImportEnumFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/importEnumFromJava.kt");
            }

            @TestMetadata("incompatibleEnumEntryClasses.kt")
            public void testIncompatibleEnumEntryClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnumEntryClasses.kt");
            }

            @TestMetadata("incompatibleEnums.kt")
            public void testIncompatibleEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnums.kt");
            }

            @TestMetadata("incompatibleEnums_1_4.kt")
            public void testIncompatibleEnums_1_4() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnums_1_4.kt");
            }

            @TestMetadata("inheritFromEnumEntry.kt")
            public void testInheritFromEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inheritFromEnumEntry.kt");
            }

            @TestMetadata("inheritanceFromEnum.kt")
            public void testInheritanceFromEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inheritanceFromEnum.kt");
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inline.kt");
            }

            @TestMetadata("InsideEntryConstructorCall.kt")
            public void testInsideEntryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/InsideEntryConstructorCall.kt");
            }

            @TestMetadata("InsideSecondaryConstructorCall.kt")
            public void testInsideSecondaryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/InsideSecondaryConstructorCall.kt");
            }

            @TestMetadata("interfaceWithEnumKeyword.kt")
            public void testInterfaceWithEnumKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/interfaceWithEnumKeyword.kt");
            }

            @TestMetadata("isEnumEntry.kt")
            public void testIsEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/isEnumEntry.kt");
            }

            @TestMetadata("javaEnumValueOfMethod.kt")
            public void testJavaEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumValueOfMethod.kt");
            }

            @TestMetadata("javaEnumValuesMethod.kt")
            public void testJavaEnumValuesMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumValuesMethod.kt");
            }

            @TestMetadata("javaEnumWithAbstractFun.kt")
            public void testJavaEnumWithAbstractFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithAbstractFun.kt");
            }

            @TestMetadata("javaEnumWithFuns.kt")
            public void testJavaEnumWithFuns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithFuns.kt");
            }

            @TestMetadata("javaEnumWithNameClashing.kt")
            public void testJavaEnumWithNameClashing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithNameClashing.kt");
            }

            @TestMetadata("javaEnumWithProperty.kt")
            public void testJavaEnumWithProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithProperty.kt");
            }

            @TestMetadata("kt2834.kt")
            public void testKt2834() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/kt2834.kt");
            }

            @TestMetadata("kt8972_cloneNotAllowed.kt")
            public void testKt8972_cloneNotAllowed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/kt8972_cloneNotAllowed.kt");
            }

            @TestMetadata("localEnums.kt")
            public void testLocalEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/localEnums.kt");
            }

            @TestMetadata("modifiersOnEnumEntry.kt")
            public void testModifiersOnEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/modifiersOnEnumEntry.kt");
            }

            @TestMetadata("multipleConstructors.kt")
            public void testMultipleConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/multipleConstructors.kt");
            }

            @TestMetadata("NonPrivateConstructor.kt")
            public void testNonPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/NonPrivateConstructor.kt");
            }

            @TestMetadata("openMemberInEnum.kt")
            public void testOpenMemberInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/openMemberInEnum.kt");
            }

            @TestMetadata("overrideFinalEnumMethods.kt")
            public void testOverrideFinalEnumMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/overrideFinalEnumMethods.kt");
            }

            @TestMetadata("SecondaryConstructorCall.kt")
            public void testSecondaryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/SecondaryConstructorCall.kt");
            }

            @TestMetadata("starImportNestedClassAndEntries.kt")
            public void testStarImportNestedClassAndEntries() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/starImportNestedClassAndEntries.kt");
            }

            @TestMetadata("typeParametersInEnum.kt")
            public void testTypeParametersInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/typeParametersInEnum.kt");
            }

            @TestMetadata("valuesValueOfAndEntriesAccessibility.kt")
            public void testValuesValueOfAndEntriesAccessibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/valuesValueOfAndEntriesAccessibility.kt");
            }

            @TestMetadata("wrongUnitializedEnumCompanion.kt")
            public void testWrongUnitializedEnumCompanion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/wrongUnitializedEnumCompanion.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/enum/inner")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inner extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInner() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/enum/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("existingClassObject.kt")
                public void testExistingClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/existingClassObject.kt");
                }

                @TestMetadata("insideClass.kt")
                public void testInsideClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideClass.kt");
                }

                @TestMetadata("insideClassObject.kt")
                public void testInsideClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideClassObject.kt");
                }

                @TestMetadata("insideEnum.kt")
                public void testInsideEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnum.kt");
                }

                @TestMetadata("insideEnumEntry_after.kt")
                public void testInsideEnumEntry_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_after.kt");
                }

                @TestMetadata("insideEnumEntry_before.kt")
                public void testInsideEnumEntry_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_before.kt");
                }

                @TestMetadata("insideInnerClassNotAllowed.kt")
                public void testInsideInnerClassNotAllowed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideInnerClassNotAllowed.kt");
                }

                @TestMetadata("insideObject.kt")
                public void testInsideObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideObject.kt");
                }

                @TestMetadata("insideTrait.kt")
                public void testInsideTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideTrait.kt");
                }

                @TestMetadata("redeclarationInClassObject.kt")
                public void testRedeclarationInClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/redeclarationInClassObject.kt");
                }

                @TestMetadata("twoEnums.kt")
                public void testTwoEnums() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnums.kt");
                }

                @TestMetadata("twoEnumsInClassObjectAndInnerClass.kt")
                public void testTwoEnumsInClassObjectAndInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnumsInClassObjectAndInnerClass.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/evaluate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Evaluate extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInEvaluate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("binaryMinusDepOnExpType.kt")
            public void testBinaryMinusDepOnExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusDepOnExpType.kt");
            }

            @TestMetadata("binaryMinusIndepWoExpType.kt")
            public void testBinaryMinusIndepWoExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndepWoExpType.kt");
            }

            @TestMetadata("binaryMinusIndependentExpType.kt")
            public void testBinaryMinusIndependentExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndependentExpType.kt");
            }

            @TestMetadata("divisionByZero.kt")
            public void testDivisionByZero() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/divisionByZero.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/float.kt");
            }

            @TestMetadata("floatLiteralOutOfRange.kt")
            public void testFloatLiteralOutOfRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/floatLiteralOutOfRange.kt");
            }

            @TestMetadata("infixFunOverBuiltinMemberInConst.kt")
            public void testInfixFunOverBuiltinMemberInConst() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/infixFunOverBuiltinMemberInConst.kt");
            }

            @TestMetadata("intOverflow.kt")
            public void testIntOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/intOverflow.kt");
            }

            @TestMetadata("intOverflowWithJavaProperties.kt")
            public void testIntOverflowWithJavaProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/intOverflowWithJavaProperties.kt");
            }

            @TestMetadata("integer.kt")
            public void testInteger() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/integer.kt");
            }

            @TestMetadata("logicWithNumber.kt")
            public void testLogicWithNumber() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/logicWithNumber.kt");
            }

            @TestMetadata("longOverflow.kt")
            public void testLongOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/longOverflow.kt");
            }

            @TestMetadata("noOverflowWithZero.kt")
            public void testNoOverflowWithZero() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/noOverflowWithZero.kt");
            }

            @TestMetadata("numberBinaryOperations.kt")
            public void testNumberBinaryOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperations.kt");
            }

            @TestMetadata("numberBinaryOperationsCall.kt")
            public void testNumberBinaryOperationsCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsCall.kt");
            }

            @TestMetadata("numberBinaryOperationsInfixCall.kt")
            public void testNumberBinaryOperationsInfixCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsInfixCall.kt");
            }

            @TestMetadata("otherOverflow.kt")
            public void testOtherOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/otherOverflow.kt");
            }

            @TestMetadata("parentesized.kt")
            public void testParentesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/parentesized.kt");
            }

            @TestMetadata("qualifiedExpressions.kt")
            public void testQualifiedExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/qualifiedExpressions.kt");
            }

            @TestMetadata("unaryMinusDepOnExpType.kt")
            public void testUnaryMinusDepOnExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusDepOnExpType.kt");
            }

            @TestMetadata("unaryMinusIndepWoExpType.kt")
            public void testUnaryMinusIndepWoExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndepWoExpType.kt");
            }

            @TestMetadata("unaryMinusIndependentExpType.kt")
            public void testUnaryMinusIndependentExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndependentExpType.kt");
            }

            @TestMetadata("wrongLongSuffix.kt")
            public void testWrongLongSuffix() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/wrongLongSuffix.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/evaluate/inlineClasses")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineClasses extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constructorOfUnsignedType.kt")
                public void testConstructorOfUnsignedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/evaluate/inlineClasses/constructorOfUnsignedType.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/exposed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Exposed extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExposed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/exposed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/delegate.kt");
            }

            @TestMetadata("exceptionOnFakeInvisible.kt")
            public void testExceptionOnFakeInvisible() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/exceptionOnFakeInvisible.kt");
            }

            @TestMetadata("functional.kt")
            public void testFunctional() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/functional.kt");
            }

            @TestMetadata("implements.kt")
            public void testImplements() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/implements.kt");
            }

            @TestMetadata("inaccessibleType.kt")
            public void testInaccessibleType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/inaccessibleType.kt");
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internal.kt");
            }

            @TestMetadata("internalAndProtected.kt")
            public void testInternalAndProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internalAndProtected.kt");
            }

            @TestMetadata("internalFromLocal.kt")
            public void testInternalFromLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internalFromLocal.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/local.kt");
            }

            @TestMetadata("localFromInternal.kt")
            public void testLocalFromInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localFromInternal.kt");
            }

            @TestMetadata("localFromPrivate.kt")
            public void testLocalFromPrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localFromPrivate.kt");
            }

            @TestMetadata("localInFunReturnType.kt")
            public void testLocalInFunReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInFunReturnType.kt");
            }

            @TestMetadata("localInMemberType.kt")
            public void testLocalInMemberType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInMemberType.kt");
            }

            @TestMetadata("localInPropertyType.kt")
            public void testLocalInPropertyType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInPropertyType.kt");
            }

            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/nested.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/object.kt");
            }

            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/packagePrivate.kt");
            }

            @TestMetadata("privateFromLocal.kt")
            public void testPrivateFromLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privateFromLocal.kt");
            }

            @TestMetadata("privatePropertyInPrivateConstructor.kt")
            public void testPrivatePropertyInPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privatePropertyInPrivateConstructor.kt");
            }

            @TestMetadata("propertyInConstructorOfPrivateClass.kt")
            public void testPropertyInConstructorOfPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInConstructorOfPrivateClass.kt");
            }

            @TestMetadata("propertyInPrivateConstructor.kt")
            public void testPropertyInPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInPrivateConstructor.kt");
            }

            @TestMetadata("propertyInSimpleConstructor.kt")
            public void testPropertyInSimpleConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInSimpleConstructor.kt");
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protected.kt");
            }

            @TestMetadata("protectedInProtected.kt")
            public void testProtectedInProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedInProtected.kt");
            }

            @TestMetadata("protectedJava.kt")
            public void testProtectedJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedJava.kt");
            }

            @TestMetadata("protectedSameWay.kt")
            public void testProtectedSameWay() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedSameWay.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/simple.kt");
            }

            @TestMetadata("typeArgs.kt")
            public void testTypeArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/typeArgs.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/extensions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Extensions extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExtensions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/classObject.kt");
            }

            @TestMetadata("ExtensionFunctions.kt")
            public void testExtensionFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/ExtensionFunctions.kt");
            }

            @TestMetadata("extensionMemberInClassObject.kt")
            public void testExtensionMemberInClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/extensionMemberInClassObject.kt");
            }

            @TestMetadata("extensionPropertyVsParameter.kt")
            public void testExtensionPropertyVsParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/extensionPropertyVsParameter.kt");
            }

            @TestMetadata("ExtensionsCalledOnSuper.kt")
            public void testExtensionsCalledOnSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/ExtensionsCalledOnSuper.kt");
            }

            @TestMetadata("GenericIterator.kt")
            public void testGenericIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator.kt");
            }

            @TestMetadata("GenericIterator2.kt")
            public void testGenericIterator2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator2.kt");
            }

            @TestMetadata("kt1875.kt")
            public void testKt1875() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt1875.kt");
            }

            @TestMetadata("kt2317.kt")
            public void testKt2317() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt2317.kt");
            }

            @TestMetadata("kt3470.kt")
            public void testKt3470() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt3470.kt");
            }

            @TestMetadata("kt3563.kt")
            public void testKt3563() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt3563.kt");
            }

            @TestMetadata("kt819ExtensionProperties.kt")
            public void testKt819ExtensionProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt819ExtensionProperties.kt");
            }

            @TestMetadata("noClassObjectsInJava.kt")
            public void testNoClassObjectsInJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/noClassObjectsInJava.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/object.kt");
            }

            @TestMetadata("throwOutCandidatesByReceiver.kt")
            public void testThrowOutCandidatesByReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver.kt");
            }

            @TestMetadata("throwOutCandidatesByReceiver2.kt")
            public void testThrowOutCandidatesByReceiver2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver2.kt");
            }

            @TestMetadata("variableInvoke.kt")
            public void testVariableInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/variableInvoke.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/functionAsExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionAsExpression extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionAsExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionAsExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AutoLabels.kt")
            public void testAutoLabels() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/AutoLabels.kt");
            }

            @TestMetadata("Common.kt")
            public void testCommon() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/Common.kt");
            }

            @TestMetadata("DifficultInferenceForParameter.kt")
            public void testDifficultInferenceForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/DifficultInferenceForParameter.kt");
            }

            @TestMetadata("ForbiddenNonLocalReturn.kt")
            public void testForbiddenNonLocalReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ForbiddenNonLocalReturn.kt");
            }

            @TestMetadata("FunctionType.kt")
            public void testFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/FunctionType.kt");
            }

            @TestMetadata("InferenceParametersTypes.kt")
            public void testInferenceParametersTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/InferenceParametersTypes.kt");
            }

            @TestMetadata("MissingParameterTypes.kt")
            public void testMissingParameterTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/MissingParameterTypes.kt");
            }

            @TestMetadata("NameDeprecation.kt")
            public void testNameDeprecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/NameDeprecation.kt");
            }

            @TestMetadata("NoOverloadError.kt")
            public void testNoOverloadError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/NoOverloadError.kt");
            }

            @TestMetadata("Parameters.kt")
            public void testParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/Parameters.kt");
            }

            @TestMetadata("ReceiverByExpectedType.kt")
            public void testReceiverByExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReceiverByExpectedType.kt");
            }

            @TestMetadata("ReturnAndLabels.kt")
            public void testReturnAndLabels() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnAndLabels.kt");
            }

            @TestMetadata("ReturnTypeCheck.kt")
            public void testReturnTypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnTypeCheck.kt");
            }

            @TestMetadata("ScopeCheck.kt")
            public void testScopeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ScopeCheck.kt");
            }

            @TestMetadata("WithGenericParameters.kt")
            public void testWithGenericParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithGenericParameters.kt");
            }

            @TestMetadata("WithOuterGeneric.kt")
            public void testWithOuterGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithOuterGeneric.kt");
            }

            @TestMetadata("WithoutBody.kt")
            public void testWithoutBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithoutBody.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionLiterals extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentOperationInLambda.kt")
            public void testAssignmentOperationInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambda.kt");
            }

            @TestMetadata("assignmentOperationInLambdaWithExpectedType.kt")
            public void testAssignmentOperationInLambdaWithExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambdaWithExpectedType.kt");
            }

            @TestMetadata("DeprecatedSyntax.kt")
            public void testDeprecatedSyntax() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/DeprecatedSyntax.kt");
            }

            @TestMetadata("ExpectedParameterTypeMismatchVariance.kt")
            public void testExpectedParameterTypeMismatchVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParameterTypeMismatchVariance.kt");
            }

            @TestMetadata("ExpectedParametersTypesMismatch.kt")
            public void testExpectedParametersTypesMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParametersTypesMismatch.kt");
            }

            @TestMetadata("functionExpressionAsLastExpressionInBlock.kt")
            public void testFunctionExpressionAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionExpressionAsLastExpressionInBlock.kt");
            }

            @TestMetadata("functionLIteralInBlockInIf.kt")
            public void testFunctionLIteralInBlockInIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLIteralInBlockInIf.kt");
            }

            @TestMetadata("functionLiteralInIf.kt")
            public void testFunctionLiteralInIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralInIf.kt");
            }

            @TestMetadata("functionLiteralWithoutArgumentList.kt")
            public void testFunctionLiteralWithoutArgumentList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralWithoutArgumentList.kt");
            }

            @TestMetadata("higherOrderCallMissingParameters.kt")
            public void testHigherOrderCallMissingParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/higherOrderCallMissingParameters.kt");
            }

            @TestMetadata("kt11733.kt")
            public void testKt11733() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733.kt");
            }

            @TestMetadata("kt11733_1.kt")
            public void testKt11733_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733_1.kt");
            }

            @TestMetadata("kt16016.kt")
            public void testKt16016() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt16016.kt");
            }

            @TestMetadata("kt2906.kt")
            public void testKt2906() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt2906.kt");
            }

            @TestMetadata("kt3343.kt")
            public void testKt3343() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt3343.kt");
            }

            @TestMetadata("kt4529.kt")
            public void testKt4529() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt4529.kt");
            }

            @TestMetadata("kt6541_extensionForExtensionFunction.kt")
            public void testKt6541_extensionForExtensionFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6541_extensionForExtensionFunction.kt");
            }

            @TestMetadata("kt6869.kt")
            public void testKt6869() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6869.kt");
            }

            @TestMetadata("kt7383_starProjectedFunction.kt")
            public void testKt7383_starProjectedFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt7383_starProjectedFunction.kt");
            }

            @TestMetadata("LabeledFunctionLiterals.kt")
            public void testLabeledFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/LabeledFunctionLiterals.kt");
            }

            @TestMetadata("returnNull.kt")
            public void testReturnNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNull.kt");
            }

            @TestMetadata("returnNullWithReturn.kt")
            public void testReturnNullWithReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNullWithReturn.kt");
            }

            @TestMetadata("underscopeParameters.kt")
            public void testUnderscopeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/underscopeParameters.kt");
            }

            @TestMetadata("unusedLiteral.kt")
            public void testUnusedLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteral.kt");
            }

            @TestMetadata("unusedLiteralInsideUnitLiteral.kt")
            public void testUnusedLiteralInsideUnitLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteralInsideUnitLiteral.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DestructuringInLambdas extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDestructuringInLambdas() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complexInference.kt")
                public void testComplexInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/complexInference.kt");
                }

                @TestMetadata("extensionComponents.kt")
                public void testExtensionComponents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/extensionComponents.kt");
                }

                @TestMetadata("inferredFunctionalType.kt")
                public void testInferredFunctionalType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/inferredFunctionalType.kt");
                }

                @TestMetadata("modifiers.kt")
                public void testModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/modifiers.kt");
                }

                @TestMetadata("noExpectedType.kt")
                public void testNoExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/noExpectedType.kt");
                }

                @TestMetadata("redeclaration.kt")
                public void testRedeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/redeclaration.kt");
                }

                @TestMetadata("shadowing.kt")
                public void testShadowing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/shadowing.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/simple.kt");
                }

                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/underscore.kt");
                }

                @TestMetadata("unsupportedFeature.kt")
                public void testUnsupportedFeature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unsupportedFeature.kt");
                }

                @TestMetadata("unusedParameters.kt")
                public void testUnusedParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unusedParameters.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/return")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Return extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/return"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("AutoLabels.kt")
                public void testAutoLabels() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabels.kt");
                }

                @TestMetadata("AutoLabelsNonLocal.kt")
                public void testAutoLabelsNonLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabelsNonLocal.kt");
                }

                @TestMetadata("ForbiddenNonLocalReturnNoType.kt")
                public void testForbiddenNonLocalReturnNoType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/ForbiddenNonLocalReturnNoType.kt");
                }

                @TestMetadata("IfInReturnedExpression.kt")
                public void testIfInReturnedExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfInReturnedExpression.kt");
                }

                @TestMetadata("IfWithoutElse.kt")
                public void testIfWithoutElse() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElse.kt");
                }

                @TestMetadata("IfWithoutElseWithExplicitType.kt")
                public void testIfWithoutElseWithExplicitType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElseWithExplicitType.kt");
                }

                @TestMetadata("LambdaWithParameter.kt")
                public void testLambdaWithParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LambdaWithParameter.kt");
                }

                @TestMetadata("LocalAndNonLocalReturnInLambda.kt")
                public void testLocalAndNonLocalReturnInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalAndNonLocalReturnInLambda.kt");
                }

                @TestMetadata("LocalReturnExplicitLabelNoParens.kt")
                public void testLocalReturnExplicitLabelNoParens() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelNoParens.kt");
                }

                @TestMetadata("LocalReturnExplicitLabelParens.kt")
                public void testLocalReturnExplicitLabelParens() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelParens.kt");
                }

                @TestMetadata("LocalReturnHasTypeNothing.kt")
                public void testLocalReturnHasTypeNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnHasTypeNothing.kt");
                }

                @TestMetadata("LocalReturnInNestedFunction.kt")
                public void testLocalReturnInNestedFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedFunction.kt");
                }

                @TestMetadata("LocalReturnInNestedLambda.kt")
                public void testLocalReturnInNestedLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedLambda.kt");
                }

                @TestMetadata("LocalReturnNoCoercionToUnit.kt")
                public void testLocalReturnNoCoercionToUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNoCoercionToUnit.kt");
                }

                @TestMetadata("LocalReturnNull.kt")
                public void testLocalReturnNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNull.kt");
                }

                @TestMetadata("LocalReturnSecondUnit.kt")
                public void testLocalReturnSecondUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnSecondUnit.kt");
                }

                @TestMetadata("LocalReturnUnit.kt")
                public void testLocalReturnUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnit.kt");
                }

                @TestMetadata("LocalReturnUnitAndDontCareType.kt")
                public void testLocalReturnUnitAndDontCareType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitAndDontCareType.kt");
                }

                @TestMetadata("LocalReturnUnitWithBodyExpression.kt")
                public void testLocalReturnUnitWithBodyExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitWithBodyExpression.kt");
                }

                @TestMetadata("LocalReturnWithExpectedType.kt")
                public void testLocalReturnWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExpectedType.kt");
                }

                @TestMetadata("LocalReturnWithExplicitUnit.kt")
                public void testLocalReturnWithExplicitUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExplicitUnit.kt");
                }

                @TestMetadata("LocalReturnsWithExplicitReturnType.kt")
                public void testLocalReturnsWithExplicitReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnsWithExplicitReturnType.kt");
                }

                @TestMetadata("MixedReturnsFromLambda.kt")
                public void testMixedReturnsFromLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/MixedReturnsFromLambda.kt");
                }

                @TestMetadata("NoCommonSystem.kt")
                public void testNoCommonSystem() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/NoCommonSystem.kt");
                }

                @TestMetadata("SmartCast.kt")
                public void testSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCast.kt");
                }

                @TestMetadata("SmartCastWithExplicitType.kt")
                public void testSmartCastWithExplicitType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCastWithExplicitType.kt");
                }

                @TestMetadata("unresolvedReferenceInReturnBlock.kt")
                public void testUnresolvedReferenceInReturnBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/unresolvedReferenceInReturnBlock.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/generics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Generics extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInGenerics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentsForT.kt")
            public void testArgumentsForT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/argumentsForT.kt");
            }

            @TestMetadata("commonSupertypeContravariant.kt")
            public void testCommonSupertypeContravariant() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant.kt");
            }

            @TestMetadata("commonSupertypeContravariant2.kt")
            public void testCommonSupertypeContravariant2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant2.kt");
            }

            @TestMetadata("doNotCaptureSupertype.kt")
            public void testDoNotCaptureSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/doNotCaptureSupertype.kt");
            }

            @TestMetadata("genericsInType.kt")
            public void testGenericsInType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/genericsInType.kt");
            }

            @TestMetadata("InconsistentTypeParameterBounds.kt")
            public void testInconsistentTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/InconsistentTypeParameterBounds.kt");
            }

            @TestMetadata("invalidArgumentsNumberInWhere.kt")
            public void testInvalidArgumentsNumberInWhere() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/invalidArgumentsNumberInWhere.kt");
            }

            @TestMetadata("kt1575-Class.kt")
            public void testKt1575_Class() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt1575-Class.kt");
            }

            @TestMetadata("kt1575-Function.kt")
            public void testKt1575_Function() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt1575-Function.kt");
            }

            @TestMetadata("kt5508.kt")
            public void testKt5508() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt5508.kt");
            }

            @TestMetadata("kt9203.kt")
            public void testKt9203() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9203.kt");
            }

            @TestMetadata("kt9203_1.kt")
            public void testKt9203_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9203_1.kt");
            }

            @TestMetadata("kt9985.kt")
            public void testKt9985() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9985.kt");
            }

            @TestMetadata("Projections.kt")
            public void testProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/Projections.kt");
            }

            @TestMetadata("PseudoRawTypes.kt")
            public void testPseudoRawTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/PseudoRawTypes.kt");
            }

            @TestMetadata("RawTypeInIsExpression.kt")
            public void testRawTypeInIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsExpression.kt");
            }

            @TestMetadata("RawTypeInIsPattern.kt")
            public void testRawTypeInIsPattern() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsPattern.kt");
            }

            @TestMetadata("recursive.kt")
            public void testRecursive() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/recursive.kt");
            }

            @TestMetadata("RecursiveUpperBoundCheck.kt")
            public void testRecursiveUpperBoundCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundCheck.kt");
            }

            @TestMetadata("RecursiveUpperBoundWithTwoArguments.kt")
            public void testRecursiveUpperBoundWithTwoArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundWithTwoArguments.kt");
            }

            @TestMetadata("resolveGenericBoundsBeforeSupertypes.kt")
            public void testResolveGenericBoundsBeforeSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/resolveGenericBoundsBeforeSupertypes.kt");
            }

            @TestMetadata("sameTypeParameterUse.kt")
            public void testSameTypeParameterUse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/sameTypeParameterUse.kt");
            }

            @TestMetadata("suppressVarianceConflict.kt")
            public void testSuppressVarianceConflict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/suppressVarianceConflict.kt");
            }

            @TestMetadata("TypeParameterBounds.kt")
            public void testTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/TypeParameterBounds.kt");
            }

            @TestMetadata("TypeParametersInTypeParameterBounds.kt")
            public void testTypeParametersInTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/TypeParametersInTypeParameterBounds.kt");
            }

            @TestMetadata("unresolvedClassifierInWhere.kt")
            public void testUnresolvedClassifierInWhere() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/unresolvedClassifierInWhere.kt");
            }

            @TestMetadata("wildcardInValueParameter.kt")
            public void testWildcardInValueParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/wildcardInValueParameter.kt");
            }

            @TestMetadata("wrongNumberOfTypeArgumentsDiagnostic.kt")
            public void testWrongNumberOfTypeArgumentsDiagnostic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/wrongNumberOfTypeArgumentsDiagnostic.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CapturedParameters extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCapturedParameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/capturedParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerLocalClass.kt")
                public void testInnerLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/innerLocalClass.kt");
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localClass.kt");
                }

                @TestMetadata("localWithTypeParameter.kt")
                public void testLocalWithTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localWithTypeParameter.kt");
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/objectLiteral.kt");
                }

                @TestMetadata("uncheckedCast.kt")
                public void testUncheckedCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/uncheckedCast.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CyclicBounds extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCyclicBounds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/cyclicBounds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/functions.kt");
                }

                @TestMetadata("inClass.kt")
                public void testInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/inClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InnerClasses extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInnerClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("bareTypes.kt")
                public void testBareTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypes.kt");
                }

                @TestMetadata("bareTypesComplex.kt")
                public void testBareTypesComplex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypesComplex.kt");
                }

                @TestMetadata("checkBoundsOuter.kt")
                public void testCheckBoundsOuter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/checkBoundsOuter.kt");
                }

                @TestMetadata("importedInner.kt")
                public void testImportedInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/importedInner.kt");
                }

                @TestMetadata("innerSuperCall.kt")
                public void testInnerSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCall.kt");
                }

                @TestMetadata("innerSuperCallSecondary.kt")
                public void testInnerSuperCallSecondary() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCallSecondary.kt");
                }

                @TestMetadata("innerTP.kt")
                public void testInnerTP() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerTP.kt");
                }

                @TestMetadata("innerUncheckedCast.kt")
                public void testInnerUncheckedCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerUncheckedCast.kt");
                }

                @TestMetadata("innerVariance.kt")
                public void testInnerVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerVariance.kt");
                }

                @TestMetadata("iterator.kt")
                public void testIterator() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/iterator.kt");
                }

                @TestMetadata("j+k.kt")
                public void testJ_k() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k.kt");
                }

                @TestMetadata("j+k_complex.kt")
                public void testJ_k_complex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k_complex.kt");
                }

                @TestMetadata("kt3357.kt")
                public void testKt3357() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt3357.kt");
                }

                @TestMetadata("kt408.kt")
                public void testKt408() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt408.kt");
                }

                @TestMetadata("kt6325.kt")
                public void testKt6325() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt6325.kt");
                }

                @TestMetadata("outerArgumentsRequired.kt")
                public void testOuterArgumentsRequired() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/outerArgumentsRequired.kt");
                }

                @TestMetadata("parameterShadowing.kt")
                public void testParameterShadowing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/parameterShadowing.kt");
                }

                @TestMetadata("qualifiedOuter.kt")
                public void testQualifiedOuter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedOuter.kt");
                }

                @TestMetadata("qualifiedTypesResolution.kt")
                public void testQualifiedTypesResolution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedTypesResolution.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simple.kt");
                }

                @TestMetadata("simpleIn.kt")
                public void testSimpleIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleIn.kt");
                }

                @TestMetadata("simpleOut.kt")
                public void testSimpleOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOut.kt");
                }

                @TestMetadata("simpleOutUseSite.kt")
                public void testSimpleOutUseSite() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOutUseSite.kt");
                }

                @TestMetadata("substitutedMemberScope.kt")
                public void testSubstitutedMemberScope() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/substitutedMemberScope.kt");
                }

                @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ImplicitArguments extends AbstractDiagnosticsUsingJavacTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInImplicitArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("fromCompanionObject_after.kt")
                    public void testFromCompanionObject_after() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_after.kt");
                    }

                    @TestMetadata("fromCompanionObject_before.kt")
                    public void testFromCompanionObject_before() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_before.kt");
                    }

                    @TestMetadata("fromOuterClassInObjectLiteral.kt")
                    public void testFromOuterClassInObjectLiteral() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromOuterClassInObjectLiteral.kt");
                    }

                    @TestMetadata("fromSuperClasses.kt")
                    public void testFromSuperClasses() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClasses.kt");
                    }

                    @TestMetadata("fromSuperClassesLocal.kt")
                    public void testFromSuperClassesLocal() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocal.kt");
                    }

                    @TestMetadata("fromSuperClassesLocalInsideInner.kt")
                    public void testFromSuperClassesLocalInsideInner() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocalInsideInner.kt");
                    }

                    @TestMetadata("fromSuperClassesTransitive.kt")
                    public void testFromSuperClassesTransitive() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesTransitive.kt");
                    }

                    @TestMetadata("inStaticScope.kt")
                    public void testInStaticScope() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/inStaticScope.kt");
                    }

                    @TestMetadata("secondLevelDepth.kt")
                    public void testSecondLevelDepth() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/secondLevelDepth.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultipleBoundsMemberScope extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMultipleBoundsMemberScope() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("conflictingReturnType.kt")
                public void testConflictingReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/conflictingReturnType.kt");
                }

                @TestMetadata("flexibleTypes.kt")
                public void testFlexibleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/flexibleTypes.kt");
                }

                @TestMetadata("mostSpecific.kt")
                public void testMostSpecific() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/mostSpecific.kt");
                }

                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/properties.kt");
                }

                @TestMetadata("propertiesConflict.kt")
                public void testPropertiesConflict() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/propertiesConflict.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/simple.kt");
                }

                @TestMetadata("validTypeParameters.kt")
                public void testValidTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/validTypeParameters.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/nullability")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Nullability extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNullability() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/nullability"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("capturedTypeWithPlatformSupertype.kt")
                public void testCapturedTypeWithPlatformSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/capturedTypeWithPlatformSupertype.kt");
                }

                @TestMetadata("considerTypeNotNullOnlyIfItHasNotNullBound.kt")
                public void testConsiderTypeNotNullOnlyIfItHasNotNullBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/considerTypeNotNullOnlyIfItHasNotNullBound.kt");
                }

                @TestMetadata("correctSubstitutionForIncorporationConstraint.kt")
                public void testCorrectSubstitutionForIncorporationConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/correctSubstitutionForIncorporationConstraint.kt");
                }

                @TestMetadata("declarationsBoundsViolation.kt")
                public void testDeclarationsBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/declarationsBoundsViolation.kt");
                }

                @TestMetadata("expressionsBoundsViolation.kt")
                public void testExpressionsBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/expressionsBoundsViolation.kt");
                }

                @TestMetadata("functionalBound.kt")
                public void testFunctionalBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/functionalBound.kt");
                }

                @TestMetadata("inferNotNullTypeFromIntersectionOfNullableTypes.kt")
                public void testInferNotNullTypeFromIntersectionOfNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/inferNotNullTypeFromIntersectionOfNullableTypes.kt");
                }

                @TestMetadata("kt25182.kt")
                public void testKt25182() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/kt25182.kt");
                }

                @TestMetadata("notNullSmartcastOnIntersectionOfNullables.kt")
                public void testNotNullSmartcastOnIntersectionOfNullables() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/notNullSmartcastOnIntersectionOfNullables.kt");
                }

                @TestMetadata("nullToGeneric.kt")
                public void testNullToGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/nullToGeneric.kt");
                }

                @TestMetadata("smartCastRefinedClass.kt")
                public void testSmartCastRefinedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastRefinedClass.kt");
                }

                @TestMetadata("smartCasts.kt")
                public void testSmartCasts() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCasts.kt");
                }

                @TestMetadata("smartCastsOnThis.kt")
                public void testSmartCastsOnThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsOnThis.kt");
                }

                @TestMetadata("smartCastsValueArgument.kt")
                public void testSmartCastsValueArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsValueArgument.kt");
                }

                @TestMetadata("tpBoundsViolation.kt")
                public void testTpBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolation.kt");
                }

                @TestMetadata("tpBoundsViolationVariance.kt")
                public void testTpBoundsViolationVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolationVariance.kt");
                }

                @TestMetadata("tpInBounds.kt")
                public void testTpInBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpInBounds.kt");
                }

                @TestMetadata("useAsReceiver.kt")
                public void testUseAsReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsReceiver.kt");
                }

                @TestMetadata("useAsValueArgument.kt")
                public void testUseAsValueArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsValueArgument.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ProjectionsScope extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("addAll.kt")
                public void testAddAll() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/addAll.kt");
                }

                public void testAllFilesPresentInProjectionsScope() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/projectionsScope"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("approximateDispatchReceiver.kt")
                public void testApproximateDispatchReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/approximateDispatchReceiver.kt");
                }

                @TestMetadata("extensionReceiverTypeMismatch.kt")
                public void testExtensionReceiverTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionReceiverTypeMismatch.kt");
                }

                @TestMetadata("extensionResultSubstitution.kt")
                public void testExtensionResultSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionResultSubstitution.kt");
                }

                @TestMetadata("flexibleProjectedScope.kt")
                public void testFlexibleProjectedScope() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/flexibleProjectedScope.kt");
                }

                @TestMetadata("inValueParameter.kt")
                public void testInValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/inValueParameter.kt");
                }

                @TestMetadata("iterateOnExtension.kt")
                public void testIterateOnExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/iterateOnExtension.kt");
                }

                @TestMetadata("kt7296.kt")
                public void testKt7296() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt7296.kt");
                }

                @TestMetadata("kt8647.kt")
                public void testKt8647() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt8647.kt");
                }

                @TestMetadata("lambdaArgument.kt")
                public void testLambdaArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/lambdaArgument.kt");
                }

                @TestMetadata("leakedApproximatedType.kt")
                public void testLeakedApproximatedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/leakedApproximatedType.kt");
                }

                @TestMetadata("MLOut.kt")
                public void testMLOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/MLOut.kt");
                }

                @TestMetadata("multipleArgumentProjectedOut.kt")
                public void testMultipleArgumentProjectedOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/multipleArgumentProjectedOut.kt");
                }

                @TestMetadata("platformSuperClass.kt")
                public void testPlatformSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/platformSuperClass.kt");
                }

                @TestMetadata("projectedOutConventions.kt")
                public void testProjectedOutConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutConventions.kt");
                }

                @TestMetadata("projectedOutSmartCast.kt")
                public void testProjectedOutSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutSmartCast.kt");
                }

                @TestMetadata("recursiveUpperBoundStar.kt")
                public void testRecursiveUpperBoundStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStar.kt");
                }

                @TestMetadata("recursiveUpperBoundStarOut.kt")
                public void testRecursiveUpperBoundStarOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStarOut.kt");
                }

                @TestMetadata("starNullability.kt")
                public void testStarNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullability.kt");
                }

                @TestMetadata("starNullabilityRecursive.kt")
                public void testStarNullabilityRecursive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullabilityRecursive.kt");
                }

                @TestMetadata("superClass.kt")
                public void testSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/superClass.kt");
                }

                @TestMetadata("typeMismatchConventions.kt")
                public void testTypeMismatchConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchConventions.kt");
                }

                @TestMetadata("typeMismatchInLambda.kt")
                public void testTypeMismatchInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchInLambda.kt");
                }

                @TestMetadata("typeParameterBounds.kt")
                public void testTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeParameterBounds.kt");
                }

                @TestMetadata("unsafeVarianceStar.kt")
                public void testUnsafeVarianceStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceStar.kt");
                }

                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/varargs.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/starProjections")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class StarProjections extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInStarProjections() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/starProjections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("checkBounds.kt")
                public void testCheckBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/checkBounds.kt");
                }

                @TestMetadata("collectionInheritedFromJava.kt")
                public void testCollectionInheritedFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/collectionInheritedFromJava.kt");
                }

                @TestMetadata("inheritedFromJava.kt")
                public void testInheritedFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromJava.kt");
                }

                @TestMetadata("inheritedFromKotlin.kt")
                public void testInheritedFromKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromKotlin.kt");
                }

                @TestMetadata("invalid.kt")
                public void testInvalid() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/invalid.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TpAsReified extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTpAsReified() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/tpAsReified"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CapturedAsReified.kt")
                public void testCapturedAsReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/CapturedAsReified.kt");
                }

                @TestMetadata("ClassDereference.kt")
                public void testClassDereference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ClassDereference.kt");
                }

                @TestMetadata("Conventions.kt")
                public void testConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/Conventions.kt");
                }

                @TestMetadata("GenericAsReifiedArgument.kt")
                public void testGenericAsReifiedArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericAsReifiedArgument.kt");
                }

                @TestMetadata("InConstructor.kt")
                public void testInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InConstructor.kt");
                }

                @TestMetadata("InFunction.kt")
                public void testInFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InFunction.kt");
                }

                @TestMetadata("InProperty.kt")
                public void testInProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InProperty.kt");
                }

                @TestMetadata("InType.kt")
                public void testInType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InType.kt");
                }

                @TestMetadata("InlineableReified.kt")
                public void testInlineableReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InlineableReified.kt");
                }

                @TestMetadata("LocalFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/LocalFun.kt");
                }

                @TestMetadata("NotInlineableReified.kt")
                public void testNotInlineableReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/NotInlineableReified.kt");
                }

                @TestMetadata("ReifiedClass.kt")
                public void testReifiedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/varProjection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class VarProjection extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVarProjection() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/varProjection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("setterNotProjectedOutAssign.kt")
                public void testSetterNotProjectedOutAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterNotProjectedOutAssign.kt");
                }

                @TestMetadata("setterProjectedOutAssign.kt")
                public void testSetterProjectedOutAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutAssign.kt");
                }

                @TestMetadata("setterProjectedOutNoPlusAssign.kt")
                public void testSetterProjectedOutNoPlusAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutNoPlusAssign.kt");
                }

                @TestMetadata("setterProjectedOutPlusAssignDefined.kt")
                public void testSetterProjectedOutPlusAssignDefined() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutPlusAssignDefined.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/imports")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Imports extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInImports() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/imports"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AllUnderImportsAmbiguity.kt")
            public void testAllUnderImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsAmbiguity.kt");
            }

            @TestMetadata("AllUnderImportsLessPriority.kt")
            public void testAllUnderImportsLessPriority() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsLessPriority.kt");
            }

            @TestMetadata("AllUnderImportsSamePriorityForFunction.kt")
            public void testAllUnderImportsSamePriorityForFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForFunction.kt");
            }

            @TestMetadata("AllUnderImportsSamePriorityForProperty.kt")
            public void testAllUnderImportsSamePriorityForProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForProperty.kt");
            }

            @TestMetadata("CheckJavaVisibility.kt")
            public void testCheckJavaVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility.kt");
            }

            @TestMetadata("CheckVisibility.kt")
            public void testCheckVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CheckVisibility.kt");
            }

            @TestMetadata("ClassClash.kt")
            public void testClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassClash.kt");
            }

            @TestMetadata("ClassClashStarImport.kt")
            public void testClassClashStarImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassClashStarImport.kt");
            }

            @TestMetadata("ClassImportsConflicting.kt")
            public void testClassImportsConflicting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassImportsConflicting.kt");
            }

            @TestMetadata("CurrentPackageAndAllUnderImport.kt")
            public void testCurrentPackageAndAllUnderImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndAllUnderImport.kt");
            }

            @TestMetadata("CurrentPackageAndExplicitImport.kt")
            public void testCurrentPackageAndExplicitImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndExplicitImport.kt");
            }

            @TestMetadata("DefaultImportsPriority.kt")
            public void testDefaultImportsPriority() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/DefaultImportsPriority.kt");
            }

            @TestMetadata("ExplicitImportsAmbiguity.kt")
            public void testExplicitImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsAmbiguity.kt");
            }

            @TestMetadata("ExplicitImportsUnambiguityForFunction.kt")
            public void testExplicitImportsUnambiguityForFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsUnambiguityForFunction.kt");
            }

            @TestMetadata("ExplicitPackageImportsAmbiguity.kt")
            public void testExplicitPackageImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitPackageImportsAmbiguity.kt");
            }

            @TestMetadata("ImportClassClash.kt")
            public void testImportClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportClassClash.kt");
            }

            @TestMetadata("ImportFromCompanionObject.kt")
            public void testImportFromCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromCompanionObject.kt");
            }

            @TestMetadata("ImportFromCurrentWithDifferentName.kt")
            public void testImportFromCurrentWithDifferentName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromCurrentWithDifferentName.kt");
            }

            @TestMetadata("ImportFromObject.kt")
            public void testImportFromObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromObject.kt");
            }

            @TestMetadata("ImportFromRootPackage.kt")
            public void testImportFromRootPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromRootPackage.kt");
            }

            @TestMetadata("importFunctionWithAllUnderImport.kt")
            public void testImportFunctionWithAllUnderImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImport.kt");
            }

            @TestMetadata("importFunctionWithAllUnderImportAfterNamedImport.kt")
            public void testImportFunctionWithAllUnderImportAfterNamedImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImportAfterNamedImport.kt");
            }

            @TestMetadata("ImportHidingDefinitionInTheSameFile.kt")
            public void testImportHidingDefinitionInTheSameFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportHidingDefinitionInTheSameFile.kt");
            }

            @TestMetadata("ImportNestedWithDifferentName.kt")
            public void testImportNestedWithDifferentName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportNestedWithDifferentName.kt");
            }

            @TestMetadata("ImportObjectAndUseAsSupertype.kt")
            public void testImportObjectAndUseAsSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportObjectAndUseAsSupertype.kt");
            }

            @TestMetadata("ImportObjectHidesCurrentPackage.kt")
            public void testImportObjectHidesCurrentPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportObjectHidesCurrentPackage.kt");
            }

            @TestMetadata("ImportOverloadFunctions.kt")
            public void testImportOverloadFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportOverloadFunctions.kt");
            }

            @TestMetadata("ImportPrivateMember.kt")
            public void testImportPrivateMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMember.kt");
            }

            @TestMetadata("ImportPrivateMemberFromOtherFile.kt")
            public void testImportPrivateMemberFromOtherFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMemberFromOtherFile.kt");
            }

            @TestMetadata("ImportPrivateMembersWithStar.kt")
            public void testImportPrivateMembersWithStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMembersWithStar.kt");
            }

            @TestMetadata("ImportProtectedClass.kt")
            public void testImportProtectedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportProtectedClass.kt");
            }

            @TestMetadata("ImportResolutionOrder.kt")
            public void testImportResolutionOrder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportResolutionOrder.kt");
            }

            @TestMetadata("ImportTwoTimes.kt")
            public void testImportTwoTimes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimes.kt");
            }

            @TestMetadata("ImportTwoTimesStar.kt")
            public void testImportTwoTimesStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimesStar.kt");
            }

            @TestMetadata("Imports.kt")
            public void testImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/Imports.kt");
            }

            @TestMetadata("ImportsConflicting.kt")
            public void testImportsConflicting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportsConflicting.kt");
            }

            @TestMetadata("InaccessiblePrivateClass.kt")
            public void testInaccessiblePrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateClass.kt");
            }

            @TestMetadata("invisibleFakeReferenceInImport.kt")
            public void testInvisibleFakeReferenceInImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/invisibleFakeReferenceInImport.kt");
            }

            @TestMetadata("JavaPackageLocalClassNotImported.kt")
            public void testJavaPackageLocalClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/JavaPackageLocalClassNotImported.kt");
            }

            @TestMetadata("kt13112.kt")
            public void testKt13112() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/kt13112.kt");
            }

            @TestMetadata("MalformedImports.kt")
            public void testMalformedImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/MalformedImports.kt");
            }

            @TestMetadata("NestedClassClash.kt")
            public void testNestedClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/NestedClassClash.kt");
            }

            @TestMetadata("OperatorRenameOnImport.kt")
            public void testOperatorRenameOnImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/OperatorRenameOnImport.kt");
            }

            @TestMetadata("PackageLocalClassNotImported.kt")
            public void testPackageLocalClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassNotImported.kt");
            }

            @TestMetadata("PackageLocalClassReferencedError.kt")
            public void testPackageLocalClassReferencedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassReferencedError.kt");
            }

            @TestMetadata("PackageVsClass.kt")
            public void testPackageVsClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageVsClass.kt");
            }

            @TestMetadata("PrivateClassNotImported.kt")
            public void testPrivateClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PrivateClassNotImported.kt");
            }

            @TestMetadata("PrivateClassReferencedError.kt")
            public void testPrivateClassReferencedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PrivateClassReferencedError.kt");
            }

            @TestMetadata("propertyClassFileDependencyRecursion.kt")
            public void testPropertyClassFileDependencyRecursion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/propertyClassFileDependencyRecursion.kt");
            }

            @TestMetadata("RenameOnImport.kt")
            public void testRenameOnImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/RenameOnImport.kt");
            }

            @TestMetadata("StarImportFromObject.kt")
            public void testStarImportFromObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/StarImportFromObject.kt");
            }

            @TestMetadata("SyntaxError.kt")
            public void testSyntaxError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/SyntaxError.kt");
            }

            @TestMetadata("TopLevelClassVsPackage.kt")
            public void testTopLevelClassVsPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/TopLevelClassVsPackage.kt");
            }

            @TestMetadata("twoImportLists.kt")
            public void testTwoImportLists() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/twoImportLists.kt");
            }

            @TestMetadata("WrongImport.kt")
            public void testWrongImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/WrongImport.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IncompleteCode extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIncompleteCode() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayBracketsRange.kt")
            public void testArrayBracketsRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/arrayBracketsRange.kt");
            }

            @TestMetadata("checkNothingIsSubtype.kt")
            public void testCheckNothingIsSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/checkNothingIsSubtype.kt");
            }

            @TestMetadata("controlStructuresErrors.kt")
            public void testControlStructuresErrors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/controlStructuresErrors.kt");
            }

            @TestMetadata("illegalSelectorCallableReference.kt")
            public void testIllegalSelectorCallableReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/illegalSelectorCallableReference.kt");
            }

            @TestMetadata("inExpr.kt")
            public void testInExpr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/inExpr.kt");
            }

            @TestMetadata("incompleteAssignment.kt")
            public void testIncompleteAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteAssignment.kt");
            }

            @TestMetadata("incompleteEquals.kt")
            public void testIncompleteEquals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteEquals.kt");
            }

            @TestMetadata("kt1955.kt")
            public void testKt1955() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt1955.kt");
            }

            @TestMetadata("kt2014.kt")
            public void testKt2014() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt2014.kt");
            }

            @TestMetadata("kt4866UnresolvedArrayAccess.kt")
            public void testKt4866UnresolvedArrayAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt4866UnresolvedArrayAccess.kt");
            }

            @TestMetadata("NoSenselessComparisonForErrorType.kt")
            public void testNoSenselessComparisonForErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/NoSenselessComparisonForErrorType.kt");
            }

            @TestMetadata("plusOnTheRight.kt")
            public void testPlusOnTheRight() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/plusOnTheRight.kt");
            }

            @TestMetadata("pseudocodeTraverseNextInstructions.kt")
            public void testPseudocodeTraverseNextInstructions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/pseudocodeTraverseNextInstructions.kt");
            }

            @TestMetadata("senselessComparisonWithNull.kt")
            public void testSenselessComparisonWithNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/senselessComparisonWithNull.kt");
            }

            @TestMetadata("SupertypeOfErrorType.kt")
            public void testSupertypeOfErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/SupertypeOfErrorType.kt");
            }

            @TestMetadata("typeParameterOnLhsOfDot.kt")
            public void testTypeParameterOnLhsOfDot() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/typeParameterOnLhsOfDot.kt");
            }

            @TestMetadata("unresolvedArguments.kt")
            public void testUnresolvedArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedArguments.kt");
            }

            @TestMetadata("unresolvedOperation.kt")
            public void testUnresolvedOperation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedOperation.kt");
            }

            @TestMetadata("variableDeclarationInSelector.kt")
            public void testVariableDeclarationInSelector() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/variableDeclarationInSelector.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DiagnosticWithSyntaxError extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDiagnosticWithSyntaxError() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayExpression.kt")
                public void testArrayExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/arrayExpression.kt");
                }

                @TestMetadata("checkBackingFieldException.kt")
                public void testCheckBackingFieldException() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/checkBackingFieldException.kt");
                }

                @TestMetadata("completeFunctionArgumentsOfNestedCalls.kt")
                public void testCompleteFunctionArgumentsOfNestedCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/completeFunctionArgumentsOfNestedCalls.kt");
                }

                @TestMetadata("declarationAfterDotSelectorExpected.kt")
                public void testDeclarationAfterDotSelectorExpected() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterDotSelectorExpected.kt");
                }

                @TestMetadata("declarationAfterIncompleteElvis.kt")
                public void testDeclarationAfterIncompleteElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterIncompleteElvis.kt");
                }

                @TestMetadata("funEquals.kt")
                public void testFunEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funEquals.kt");
                }

                @TestMetadata("funKeyword.kt")
                public void testFunKeyword() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funKeyword.kt");
                }

                @TestMetadata("funcitonTypes.kt")
                public void testFuncitonTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funcitonTypes.kt");
                }

                @TestMetadata("incompleteEnumReference.kt")
                public void testIncompleteEnumReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteEnumReference.kt");
                }

                @TestMetadata("incompleteVal.kt")
                public void testIncompleteVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteVal.kt");
                }

                @TestMetadata("incompleteValWithAccessor.kt")
                public void testIncompleteValWithAccessor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteValWithAccessor.kt");
                }

                @TestMetadata("incompleteWhen.kt")
                public void testIncompleteWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteWhen.kt");
                }

                @TestMetadata("namedFun.kt")
                public void testNamedFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/namedFun.kt");
                }

                @TestMetadata("noTypeParamsInReturnType.kt")
                public void testNoTypeParamsInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/noTypeParamsInReturnType.kt");
                }

                @TestMetadata("typeReferenceError.kt")
                public void testTypeReferenceError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/typeReferenceError.kt");
                }

                @TestMetadata("valNoName.kt")
                public void testValNoName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valNoName.kt");
                }

                @TestMetadata("valWithNoNameBeforeNextDeclarationWithModifiers.kt")
                public void testValWithNoNameBeforeNextDeclarationWithModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameBeforeNextDeclarationWithModifiers.kt");
                }

                @TestMetadata("valWithNoNameInBlock.kt")
                public void testValWithNoNameInBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameInBlock.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inference extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cannotCompleteResolveAmbiguity.kt")
            public void testCannotCompleteResolveAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveAmbiguity.kt");
            }

            @TestMetadata("cannotCompleteResolveFunctionLiteralsNoUse.kt")
            public void testCannotCompleteResolveFunctionLiteralsNoUse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveFunctionLiteralsNoUse.kt");
            }

            @TestMetadata("cannotCompleteResolveNoInfoForParameter.kt")
            public void testCannotCompleteResolveNoInfoForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoInfoForParameter.kt");
            }

            @TestMetadata("cannotCompleteResolveNoneApplicable.kt")
            public void testCannotCompleteResolveNoneApplicable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoneApplicable.kt");
            }

            @TestMetadata("cannotCompleteResolveWithFunctionLiterals.kt")
            public void testCannotCompleteResolveWithFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveWithFunctionLiterals.kt");
            }

            @TestMetadata("coerceFunctionLiteralToSuspend.kt")
            public void testCoerceFunctionLiteralToSuspend() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/coerceFunctionLiteralToSuspend.kt");
            }

            @TestMetadata("completeInferenceIfManyFailed.kt")
            public void testCompleteInferenceIfManyFailed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/completeInferenceIfManyFailed.kt");
            }

            @TestMetadata("conflictingSubstitutions.kt")
            public void testConflictingSubstitutions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/conflictingSubstitutions.kt");
            }

            @TestMetadata("dependOnExpectedType.kt")
            public void testDependOnExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependOnExpectedType.kt");
            }

            @TestMetadata("dependantOnVariance.kt")
            public void testDependantOnVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependantOnVariance.kt");
            }

            @TestMetadata("dependantOnVarianceNullable.kt")
            public void testDependantOnVarianceNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependantOnVarianceNullable.kt");
            }

            @TestMetadata("expectedTypeAdditionalTest.kt")
            public void testExpectedTypeAdditionalTest() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeAdditionalTest.kt");
            }

            @TestMetadata("expectedTypeDoubleReceiver.kt")
            public void testExpectedTypeDoubleReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeDoubleReceiver.kt");
            }

            @TestMetadata("expectedTypeFromCast.kt")
            public void testExpectedTypeFromCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCast.kt");
            }

            @TestMetadata("expectedTypeFromCastComplexExpression.kt")
            public void testExpectedTypeFromCastComplexExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastComplexExpression.kt");
            }

            @TestMetadata("expectedTypeFromCastParenthesized.kt")
            public void testExpectedTypeFromCastParenthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastParenthesized.kt");
            }

            @TestMetadata("expectedTypeWithGenerics.kt")
            public void testExpectedTypeWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeWithGenerics.kt");
            }

            @TestMetadata("findViewById.kt")
            public void testFindViewById() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/findViewById.kt");
            }

            @TestMetadata("fixVariableToNothing.kt")
            public void testFixVariableToNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/fixVariableToNothing.kt");
            }

            @TestMetadata("fixationOrderForProperConstraints.kt")
            public void testFixationOrderForProperConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/fixationOrderForProperConstraints.kt");
            }

            @TestMetadata("flexibleTypesAsUpperBound.kt")
            public void testFlexibleTypesAsUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/flexibleTypesAsUpperBound.kt");
            }

            @TestMetadata("functionPlaceholderError.kt")
            public void testFunctionPlaceholderError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/functionPlaceholderError.kt");
            }

            @TestMetadata("hasErrorInConstrainingTypes.kt")
            public void testHasErrorInConstrainingTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/hasErrorInConstrainingTypes.kt");
            }

            @TestMetadata("immutableArrayList.kt")
            public void testImmutableArrayList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/immutableArrayList.kt");
            }

            @TestMetadata("implicitInvokeExtensionWithFunctionalArgument.kt")
            public void testImplicitInvokeExtensionWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeExtensionWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeInObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInObjectWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @TestMetadata("inferInFunctionLiterals.kt")
            public void testInferInFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiterals.kt");
            }

            @TestMetadata("inferInFunctionLiteralsWithReturn.kt")
            public void testInferInFunctionLiteralsWithReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiteralsWithReturn.kt");
            }

            @TestMetadata("intersectionTypeMultipleBoundsAsReceiver.kt")
            public void testIntersectionTypeMultipleBoundsAsReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/intersectionTypeMultipleBoundsAsReceiver.kt");
            }

            @TestMetadata("invokeLambdaAsFunction.kt")
            public void testInvokeLambdaAsFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/invokeLambdaAsFunction.kt");
            }

            @TestMetadata("kt11963.kt")
            public void testKt11963() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt11963.kt");
            }

            @TestMetadata("kt12399.kt")
            public void testKt12399() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt12399.kt");
            }

            @TestMetadata("kt1293.kt")
            public void testKt1293() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt1293.kt");
            }

            @TestMetadata("kt28598.kt")
            public void testKt28598() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt28598.kt");
            }

            @TestMetadata("kt28654.kt")
            public void testKt28654() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt28654.kt");
            }

            @TestMetadata("kt3184.kt")
            public void testKt3184() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt3184.kt");
            }

            @TestMetadata("kt6175.kt")
            public void testKt6175() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt6175.kt");
            }

            @TestMetadata("kt619.kt")
            public void testKt619() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt619.kt");
            }

            @TestMetadata("lambdaInValInitializerWithAnonymousFunctions.kt")
            public void testLambdaInValInitializerWithAnonymousFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/lambdaInValInitializerWithAnonymousFunctions.kt");
            }

            @TestMetadata("listConstructor.kt")
            public void testListConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/listConstructor.kt");
            }

            @TestMetadata("localFunctionInsideIfBlock.kt")
            public void testLocalFunctionInsideIfBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/localFunctionInsideIfBlock.kt");
            }

            @TestMetadata("mapFunction.kt")
            public void testMapFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/mapFunction.kt");
            }

            @TestMetadata("mostSpecificAfterInference.kt")
            public void testMostSpecificAfterInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/mostSpecificAfterInference.kt");
            }

            @TestMetadata("NoInferenceFromDeclaredBounds.kt")
            public void testNoInferenceFromDeclaredBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/NoInferenceFromDeclaredBounds.kt");
            }

            @TestMetadata("noInformationForParameter.kt")
            public void testNoInformationForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/noInformationForParameter.kt");
            }

            @TestMetadata("nullableTypeArgumentWithNotNullUpperBound.kt")
            public void testNullableTypeArgumentWithNotNullUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/nullableTypeArgumentWithNotNullUpperBound.kt");
            }

            @TestMetadata("nullableUpperBound.kt")
            public void testNullableUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/nullableUpperBound.kt");
            }

            @TestMetadata("opposite.kt")
            public void testOpposite() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/opposite.kt");
            }

            @TestMetadata("possibleCycleOnConstraints.kt")
            public void testPossibleCycleOnConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/possibleCycleOnConstraints.kt");
            }

            @TestMetadata("reportAboutUnresolvedReferenceAsUnresolved.kt")
            public void testReportAboutUnresolvedReferenceAsUnresolved() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/reportAboutUnresolvedReferenceAsUnresolved.kt");
            }

            @TestMetadata("tryNumberLowerBoundsBeforeUpperBounds.kt")
            public void testTryNumberLowerBoundsBeforeUpperBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/tryNumberLowerBoundsBeforeUpperBounds.kt");
            }

            @TestMetadata("typeConstructorMismatch.kt")
            public void testTypeConstructorMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/typeConstructorMismatch.kt");
            }

            @TestMetadata("typeInferenceExpectedTypeMismatch.kt")
            public void testTypeInferenceExpectedTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/typeInferenceExpectedTypeMismatch.kt");
            }

            @TestMetadata("useFunctionLiteralsToInferType.kt")
            public void testUseFunctionLiteralsToInferType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/useFunctionLiteralsToInferType.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CapturedTypes extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCapturedTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/capturedTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("approximateBeforeFixation.kt")
                public void testApproximateBeforeFixation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximateBeforeFixation.kt");
                }

                @TestMetadata("cannotCaptureInProjection.kt")
                public void testCannotCaptureInProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/cannotCaptureInProjection.kt");
                }

                @TestMetadata("captureForNullableTypes.kt")
                public void testCaptureForNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForNullableTypes.kt");
                }

                @TestMetadata("captureForPlatformTypes.kt")
                public void testCaptureForPlatformTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForPlatformTypes.kt");
                }

                @TestMetadata("captureFromNullableTypeVariable.kt")
                public void testCaptureFromNullableTypeVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeVariable.kt");
                }

                @TestMetadata("captureFromSubtyping.kt")
                public void testCaptureFromSubtyping() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromSubtyping.kt");
                }

                @TestMetadata("captureFromTypeParameterUpperBound.kt")
                public void testCaptureFromTypeParameterUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromTypeParameterUpperBound.kt");
                }

                @TestMetadata("captureTypeOnlyOnTopLevel.kt")
                public void testCaptureTypeOnlyOnTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureTypeOnlyOnTopLevel.kt");
                }

                @TestMetadata("capturedType.kt")
                public void testCapturedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedType.kt");
                }

                @TestMetadata("capturedTypeAndApproximation.kt")
                public void testCapturedTypeAndApproximation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeAndApproximation.kt");
                }

                @TestMetadata("capturedTypeSubstitutedIntoOppositeProjection.kt")
                public void testCapturedTypeSubstitutedIntoOppositeProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeSubstitutedIntoOppositeProjection.kt");
                }

                @TestMetadata("capturedTypeWithInnerTypealias.kt")
                public void testCapturedTypeWithInnerTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithInnerTypealias.kt");
                }

                @TestMetadata("capturedTypeWithTypeVariableSubtyping.kt")
                public void testCapturedTypeWithTypeVariableSubtyping() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithTypeVariableSubtyping.kt");
                }

                @TestMetadata("expectedTypeMismatchWithInVariance.kt")
                public void testExpectedTypeMismatchWithInVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/expectedTypeMismatchWithInVariance.kt");
                }

                @TestMetadata("kt2570.kt")
                public void testKt2570() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2570.kt");
                }

                @TestMetadata("kt2872.kt")
                public void testKt2872() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2872.kt");
                }

                @TestMetadata("memberScopeOfCaptured.kt")
                public void testMemberScopeOfCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/memberScopeOfCaptured.kt");
                }

                @TestMetadata("noCaptureTypeErrorForNonTopLevel.kt")
                public void testNoCaptureTypeErrorForNonTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/noCaptureTypeErrorForNonTopLevel.kt");
                }

                @TestMetadata("notApproximateWhenCopyDescriptors.kt")
                public void testNotApproximateWhenCopyDescriptors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/notApproximateWhenCopyDescriptors.kt");
                }

                @TestMetadata("overApproximationForInCaptured.kt")
                public void testOverApproximationForInCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForInCaptured.kt");
                }

                @TestMetadata("overApproximationForOutCaptured.kt")
                public void testOverApproximationForOutCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForOutCaptured.kt");
                }

                @TestMetadata("starProjectionRegression.kt")
                public void testStarProjectionRegression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/starProjectionRegression.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/coercionToUnit")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CoercionToUnit extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCoercionToUnit() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/coercionToUnit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("coercionToUnitForIfAsLastExpressionInLambda.kt")
                public void testCoercionToUnitForIfAsLastExpressionInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitForIfAsLastExpressionInLambda.kt");
                }

                @TestMetadata("coercionWithExpectedType.kt")
                public void testCoercionWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedType.kt");
                }

                @TestMetadata("coercionWithExpectedTypeAndBound.kt")
                public void testCoercionWithExpectedTypeAndBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedTypeAndBound.kt");
                }

                @TestMetadata("coercionWithExplicitTypeArgument.kt")
                public void testCoercionWithExplicitTypeArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExplicitTypeArgument.kt");
                }

                @TestMetadata("coercionWithoutExpectedType.kt")
                public void testCoercionWithoutExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithoutExpectedType.kt");
                }

                @TestMetadata("indirectCoercionWithExpectedType.kt")
                public void testIndirectCoercionWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/indirectCoercionWithExpectedType.kt");
                }

                @TestMetadata("noCoercion.kt")
                public void testNoCoercion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/noCoercion.kt");
                }

                @TestMetadata("nonPropagationOfCoercionToUnitInsideNestedLambda.kt")
                public void testNonPropagationOfCoercionToUnitInsideNestedLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/nonPropagationOfCoercionToUnitInsideNestedLambda.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/commonSystem")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CommonSystem extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCommonSystem() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/commonSystem"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("boundOnNullableVariable.kt")
                public void testBoundOnNullableVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/boundOnNullableVariable.kt");
                }

                @TestMetadata("dontCaptureTypeVariable.kt")
                public void testDontCaptureTypeVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/dontCaptureTypeVariable.kt");
                }

                @TestMetadata("fixVariablesInRightOrder.kt")
                public void testFixVariablesInRightOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/fixVariablesInRightOrder.kt");
                }

                @TestMetadata("genericCandidateInGenericClass.kt")
                public void testGenericCandidateInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/genericCandidateInGenericClass.kt");
                }

                @TestMetadata("inferenceWithUpperBoundsInLambda.kt")
                public void testInferenceWithUpperBoundsInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/inferenceWithUpperBoundsInLambda.kt");
                }

                @TestMetadata("kt3372toCollection.kt")
                public void testKt3372toCollection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt3372toCollection.kt");
                }

                @TestMetadata("nestedLambdas.kt")
                public void testNestedLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nestedLambdas.kt");
                }

                @TestMetadata("theSameFunctionInArgs.kt")
                public void testTheSameFunctionInArgs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/theSameFunctionInArgs.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/constraints")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Constraints extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConstraints() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/constraints"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constraintOnFunctionLiteral.kt")
                public void testConstraintOnFunctionLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/constraintOnFunctionLiteral.kt");
                }

                @TestMetadata("equalityConstraintOnNullableType.kt")
                public void testEqualityConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/equalityConstraintOnNullableType.kt");
                }

                @TestMetadata("errorUpperBoundConstraint.kt")
                public void testErrorUpperBoundConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/errorUpperBoundConstraint.kt");
                }

                @TestMetadata("ignoreConstraintFromImplicitInNothing.kt")
                public void testIgnoreConstraintFromImplicitInNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/ignoreConstraintFromImplicitInNothing.kt");
                }

                @TestMetadata("kt6320.kt")
                public void testKt6320() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt6320.kt");
                }

                @TestMetadata("kt7351ConstraintFromUnitExpectedType.kt")
                public void testKt7351ConstraintFromUnitExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7351ConstraintFromUnitExpectedType.kt");
                }

                @TestMetadata("kt7433.kt")
                public void testKt7433() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7433.kt");
                }

                @TestMetadata("kt8879.kt")
                public void testKt8879() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt8879.kt");
                }

                @TestMetadata("notNullConstraintOnNullableType.kt")
                public void testNotNullConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/notNullConstraintOnNullableType.kt");
                }

                @TestMetadata("operationsOnIntegerValueTypes.kt")
                public void testOperationsOnIntegerValueTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/operationsOnIntegerValueTypes.kt");
                }

                @TestMetadata("returnLambdaFromLambda.kt")
                public void testReturnLambdaFromLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/returnLambdaFromLambda.kt");
                }

                @TestMetadata("subtypeConstraintOnNullableType.kt")
                public void testSubtypeConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/subtypeConstraintOnNullableType.kt");
                }

                @TestMetadata("supertypeConstraintOnNullableType.kt")
                public void testSupertypeConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/supertypeConstraintOnNullableType.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NestedCalls extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNestedCalls() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nestedCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/arrayAccess.kt");
                }

                @TestMetadata("binaryExpressions.kt")
                public void testBinaryExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/binaryExpressions.kt");
                }

                @TestMetadata("checkTypesForQualifiedProperties.kt")
                public void testCheckTypesForQualifiedProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/checkTypesForQualifiedProperties.kt");
                }

                @TestMetadata("completeNestedCallsForArraySetExpression.kt")
                public void testCompleteNestedCallsForArraySetExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsForArraySetExpression.kt");
                }

                @TestMetadata("completeNestedCallsInference.kt")
                public void testCompleteNestedCallsInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsInference.kt");
                }

                @TestMetadata("completeNestedForVariableAsFunctionCall.kt")
                public void testCompleteNestedForVariableAsFunctionCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedForVariableAsFunctionCall.kt");
                }

                @TestMetadata("externalTypeParameter.kt")
                public void testExternalTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/externalTypeParameter.kt");
                }

                @TestMetadata("inferenceForNestedBinaryCall.kt")
                public void testInferenceForNestedBinaryCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/inferenceForNestedBinaryCall.kt");
                }

                @TestMetadata("kt3395.kt")
                public void testKt3395() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3395.kt");
                }

                @TestMetadata("kt3461checkTypes.kt")
                public void testKt3461checkTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3461checkTypes.kt");
                }

                @TestMetadata("makeNullableIfSafeCall.kt")
                public void testMakeNullableIfSafeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/makeNullableIfSafeCall.kt");
                }

                @TestMetadata("nontrivialCallExpression.kt")
                public void testNontrivialCallExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/nontrivialCallExpression.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/nothingType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NothingType extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNothingType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nothingType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complexDependancyOnVariableWithTrivialConstraint.kt")
                public void testComplexDependancyOnVariableWithTrivialConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/complexDependancyOnVariableWithTrivialConstraint.kt");
                }

                @TestMetadata("generateConstraintWithInnerNothingType.kt")
                public void testGenerateConstraintWithInnerNothingType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/generateConstraintWithInnerNothingType.kt");
                }

                @TestMetadata("implicitNothingConstraintFromReturn.kt")
                public void testImplicitNothingConstraintFromReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/implicitNothingConstraintFromReturn.kt");
                }

                @TestMetadata("kt24490.kt")
                public void testKt24490() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt24490.kt");
                }

                @TestMetadata("lambdaNothingAndExpectedType.kt")
                public void testLambdaNothingAndExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/lambdaNothingAndExpectedType.kt");
                }

                @TestMetadata("nestedLambdaInferenceWithIncorporationOfVariables.kt")
                public void testNestedLambdaInferenceWithIncorporationOfVariables() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/nestedLambdaInferenceWithIncorporationOfVariables.kt");
                }

                @TestMetadata("nothingWithCallableReference.kt")
                public void testNothingWithCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/nothingWithCallableReference.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveCalls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class RecursiveCalls extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRecursiveCalls() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt23531.kt")
                public void testKt23531() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveCalls/kt23531.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class RecursiveLocalFuns extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRecursiveLocalFuns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localFactorial.kt")
                public void testLocalFactorial() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/localFactorial.kt");
                }

                @TestMetadata("recursiveFun.kt")
                public void testRecursiveFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveFun.kt");
                }

                @TestMetadata("recursiveLambda.kt")
                public void testRecursiveLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveLambda.kt");
                }

                @TestMetadata("selfCall.kt")
                public void testSelfCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/selfCall.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/regressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Regressions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRegressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compareBy.kt")
                public void testCompareBy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/compareBy.kt");
                }

                @TestMetadata("kt1029.kt")
                public void testKt1029() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1029.kt");
                }

                @TestMetadata("kt1031.kt")
                public void testKt1031() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1031.kt");
                }

                @TestMetadata("kt1127.kt")
                public void testKt1127() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1127.kt");
                }

                @TestMetadata("kt1145.kt")
                public void testKt1145() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1145.kt");
                }

                @TestMetadata("kt1358.kt")
                public void testKt1358() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1358.kt");
                }

                @TestMetadata("kt1410.kt")
                public void testKt1410() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1410.kt");
                }

                @TestMetadata("kt1718.kt")
                public void testKt1718() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1718.kt");
                }

                @TestMetadata("kt1944.kt")
                public void testKt1944() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1944.kt");
                }

                @TestMetadata("kt2057.kt")
                public void testKt2057() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2057.kt");
                }

                @TestMetadata("kt2179.kt")
                public void testKt2179() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2179.kt");
                }

                @TestMetadata("kt2200.kt")
                public void testKt2200() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2200.kt");
                }

                @TestMetadata("kt2283.kt")
                public void testKt2283() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2283.kt");
                }

                @TestMetadata("kt2286.kt")
                public void testKt2286() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2286.kt");
                }

                @TestMetadata("kt2294.kt")
                public void testKt2294() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2294.kt");
                }

                @TestMetadata("kt2320.kt")
                public void testKt2320() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2320.kt");
                }

                @TestMetadata("kt2324.kt")
                public void testKt2324() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2324.kt");
                }

                @TestMetadata("kt2407.kt")
                public void testKt2407() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2407.kt");
                }

                @TestMetadata("kt2445.kt")
                public void testKt2445() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2445.kt");
                }

                @TestMetadata("kt2459.kt")
                public void testKt2459() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2459.kt");
                }

                @TestMetadata("kt2484.kt")
                public void testKt2484() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2484.kt");
                }

                @TestMetadata("kt2505.kt")
                public void testKt2505() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2505.kt");
                }

                @TestMetadata("kt2514.kt")
                public void testKt2514() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2514.kt");
                }

                @TestMetadata("kt2588.kt")
                public void testKt2588() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2588.kt");
                }

                @TestMetadata("kt2741.kt")
                public void testKt2741() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2741.kt");
                }

                @TestMetadata("kt2754.kt")
                public void testKt2754() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2754.kt");
                }

                @TestMetadata("kt2838.kt")
                public void testKt2838() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2838.kt");
                }

                @TestMetadata("kt2841.kt")
                public void testKt2841() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841.kt");
                }

                @TestMetadata("kt2841_it.kt")
                public void testKt2841_it() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it.kt");
                }

                @TestMetadata("kt2841_it_this.kt")
                public void testKt2841_it_this() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it_this.kt");
                }

                @TestMetadata("kt2841_this.kt")
                public void testKt2841_this() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_this.kt");
                }

                @TestMetadata("kt2842.kt")
                public void testKt2842() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2842.kt");
                }

                @TestMetadata("kt2883.kt")
                public void testKt2883() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2883.kt");
                }

                @TestMetadata("kt3007.kt")
                public void testKt3007() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3007.kt");
                }

                @TestMetadata("kt3038.kt")
                public void testKt3038() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3038.kt");
                }

                @TestMetadata("kt3150.kt")
                public void testKt3150() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3150.kt");
                }

                @TestMetadata("kt3174.kt")
                public void testKt3174() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3174.kt");
                }

                @TestMetadata("kt3301.kt")
                public void testKt3301() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3301.kt");
                }

                @TestMetadata("kt3344.kt")
                public void testKt3344() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3344.kt");
                }

                @TestMetadata("kt3496.kt")
                public void testKt3496() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496.kt");
                }

                @TestMetadata("kt3496_2.kt")
                public void testKt3496_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496_2.kt");
                }

                @TestMetadata("kt3559.kt")
                public void testKt3559() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3559.kt");
                }

                @TestMetadata("kt4420.kt")
                public void testKt4420() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt4420.kt");
                }

                @TestMetadata("kt702.kt")
                public void testKt702() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt702.kt");
                }

                @TestMetadata("kt731.kt")
                public void testKt731() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt731.kt");
                }

                @TestMetadata("kt742.kt")
                public void testKt742() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt742.kt");
                }

                @TestMetadata("kt8132.kt")
                public void testKt8132() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt8132.kt");
                }

                @TestMetadata("kt832.kt")
                public void testKt832() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt832.kt");
                }

                @TestMetadata("kt943.kt")
                public void testKt943() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt943.kt");
                }

                @TestMetadata("kt9461.kt")
                public void testKt9461() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt9461.kt");
                }

                @TestMetadata("kt948.kt")
                public void testKt948() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt948.kt");
                }

                @TestMetadata("noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt")
                public void testNoRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReportingImprovements extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReportingImprovements() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/reportingImprovements"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("cannotInferParameterTypeWithInference.kt")
                public void testCannotInferParameterTypeWithInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/cannotInferParameterTypeWithInference.kt");
                }

                @TestMetadata("ErrorTypeAsGenericParameter.kt")
                public void testErrorTypeAsGenericParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/ErrorTypeAsGenericParameter.kt");
                }

                @TestMetadata("FunctionPlaceholder.kt")
                public void testFunctionPlaceholder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/FunctionPlaceholder.kt");
                }

                @TestMetadata("NoAmbiguityForDifferentFunctionTypes.kt")
                public void testNoAmbiguityForDifferentFunctionTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/NoAmbiguityForDifferentFunctionTypes.kt");
                }

                @TestMetadata("reportUnresolvedReferenceWrongReceiverForManyCandidates.kt")
                public void testReportUnresolvedReferenceWrongReceiverForManyCandidates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/reportUnresolvedReferenceWrongReceiverForManyCandidates.kt");
                }

                @TestMetadata("subtypeForInvariantWithErrorGenerics.kt")
                public void testSubtypeForInvariantWithErrorGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/subtypeForInvariantWithErrorGenerics.kt");
                }

                @TestMetadata("typeInferenceFailedOnComponentN.kt")
                public void testTypeInferenceFailedOnComponentN() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnComponentN.kt");
                }

                @TestMetadata("typeInferenceFailedOnIteratorCall.kt")
                public void testTypeInferenceFailedOnIteratorCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnIteratorCall.kt");
                }

                @TestMetadata("wrongArgumentExtensionFunction.kt")
                public void testWrongArgumentExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentExtensionFunction.kt");
                }

                @TestMetadata("wrongArgumentPassedToLocalExtensionFunction.kt")
                public void testWrongArgumentPassedToLocalExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentPassedToLocalExtensionFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/substitutions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Substitutions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSubstitutions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/substitutions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegationAndInference.kt")
                public void testDelegationAndInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/delegationAndInference.kt");
                }

                @TestMetadata("kt6081SubstituteIntoClassCorrectly.kt")
                public void testKt6081SubstituteIntoClassCorrectly() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt6081SubstituteIntoClassCorrectly.kt");
                }

                @TestMetadata("simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt")
                public void testSimpleSubstitutionCheckTypeArgumentsNotTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt");
                }

                @TestMetadata("substitutionIntoAnonymousClass.kt")
                public void testSubstitutionIntoAnonymousClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoAnonymousClass.kt");
                }

                @TestMetadata("substitutionIntoInnerClass.kt")
                public void testSubstitutionIntoInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoInnerClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/upperBounds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UpperBounds extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInUpperBounds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/upperBounds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("conflictingSubstitutionsFromUpperBound.kt")
                public void testConflictingSubstitutionsFromUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/conflictingSubstitutionsFromUpperBound.kt");
                }

                @TestMetadata("doNotInferFromBoundsOnly.kt")
                public void testDoNotInferFromBoundsOnly() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/doNotInferFromBoundsOnly.kt");
                }

                @TestMetadata("intersectUpperBounds.kt")
                public void testIntersectUpperBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/intersectUpperBounds.kt");
                }

                @TestMetadata("kt2856.kt")
                public void testKt2856() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/kt2856.kt");
                }

                @TestMetadata("nonNullUpperBound.kt")
                public void testNonNullUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/nonNullUpperBound.kt");
                }

                @TestMetadata("typeParameterAsUpperBound.kt")
                public void testTypeParameterAsUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/typeParameterAsUpperBound.kt");
                }

                @TestMetadata("useBoundsIfUnknownParameters.kt")
                public void testUseBoundsIfUnknownParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsIfUnknownParameters.kt");
                }

                @TestMetadata("useBoundsToInferTypeParamsSimple.kt")
                public void testUseBoundsToInferTypeParamsSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsToInferTypeParamsSimple.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/infos")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Infos extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInfos() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/infos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("PropertiesWithBackingFields.kt")
            public void testPropertiesWithBackingFields() throws Exception {
                runTest("compiler/testData/diagnostics/tests/infos/PropertiesWithBackingFields.kt");
            }

            @TestMetadata("SmartCasts.kt")
            public void testSmartCasts() throws Exception {
                runTest("compiler/testData/diagnostics/tests/infos/SmartCasts.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inline extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousObjects.kt")
            public void testAnonymousObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/anonymousObjects.kt");
            }

            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/assignment.kt");
            }

            @TestMetadata("capture.kt")
            public void testCapture() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/capture.kt");
            }

            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/constructor.kt");
            }

            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/default.kt");
            }

            @TestMetadata("defaultLambdaInlineDisable.kt")
            public void testDefaultLambdaInlineDisable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlineDisable.kt");
            }

            @TestMetadata("defaultLambdaInlineSuspend.kt")
            public void testDefaultLambdaInlineSuspend() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlineSuspend.kt");
            }

            @TestMetadata("defaultLambdaInlining.kt")
            public void testDefaultLambdaInlining() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlining.kt");
            }

            @TestMetadata("extensionOnFunction.kt")
            public void testExtensionOnFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/extensionOnFunction.kt");
            }

            @TestMetadata("fromInlineToNoInline.kt")
            public void testFromInlineToNoInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/fromInlineToNoInline.kt");
            }

            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/functions.kt");
            }

            @TestMetadata("inlineLambdaInDefaultInlineParameter.kt")
            public void testInlineLambdaInDefaultInlineParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlineLambdaInDefaultInlineParameter.kt");
            }

            @TestMetadata("inlineLambdaInDefaultInlineParameterDisabled.kt")
            public void testInlineLambdaInDefaultInlineParameterDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlineLambdaInDefaultInlineParameterDisabled.kt");
            }

            @TestMetadata("inlineReified.kt")
            public void testInlineReified() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlineReified.kt");
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/invoke.kt");
            }

            @TestMetadata("isCheck.kt")
            public void testIsCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/isCheck.kt");
            }

            @TestMetadata("kt15410.kt")
            public void testKt15410() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt15410.kt");
            }

            @TestMetadata("kt19679.kt")
            public void testKt19679() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt19679.kt");
            }

            @TestMetadata("kt4869.kt")
            public void testKt4869() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt4869.kt");
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/labeled.kt");
            }

            @TestMetadata("lambdaCast.kt")
            public void testLambdaCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/lambdaCast.kt");
            }

            @TestMetadata("localFun.kt")
            public void testLocalFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/localFun.kt");
            }

            @TestMetadata("messagesForUnsupportedInInline.kt")
            public void testMessagesForUnsupportedInInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/messagesForUnsupportedInInline.kt");
            }

            @TestMetadata("nonVirtualMembersWithInline.kt")
            public void testNonVirtualMembersWithInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nonVirtualMembersWithInline.kt");
            }

            @TestMetadata("nothingToInline.kt")
            public void testNothingToInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nothingToInline.kt");
            }

            @TestMetadata("nullabilityOperations.kt")
            public void testNullabilityOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nullabilityOperations.kt");
            }

            @TestMetadata("nullableFunction.kt")
            public void testNullableFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nullableFunction.kt");
            }

            @TestMetadata("overrideWithInline.kt")
            public void testOverrideWithInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/overrideWithInline.kt");
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/parenthesized.kt");
            }

            @TestMetadata("privateClass.kt")
            public void testPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/privateClass.kt");
            }

            @TestMetadata("propagation.kt")
            public void testPropagation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/propagation.kt");
            }

            @TestMetadata("protectedDepecation.kt")
            public void testProtectedDepecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/protectedDepecation.kt");
            }

            @TestMetadata("publishedApi.kt")
            public void testPublishedApi() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/publishedApi.kt");
            }

            @TestMetadata("recursion.kt")
            public void testRecursion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/recursion.kt");
            }

            @TestMetadata("returns.kt")
            public void testReturns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/returns.kt");
            }

            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/sam.kt");
            }

            @TestMetadata("stringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/stringTemplate.kt");
            }

            @TestMetadata("unsupportedConstruction.kt")
            public void testUnsupportedConstruction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/unsupportedConstruction.kt");
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/vararg.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/when.kt");
            }

            @TestMetadata("wrongUsage.kt")
            public void testWrongUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/wrongUsage.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BinaryExpressions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBinaryExpressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/binaryExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("andOr.kt")
                public void testAndOr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/andOr.kt");
                }

                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/arrayAccess.kt");
                }

                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/assignment.kt");
                }

                @TestMetadata("comparison.kt")
                public void testComparison() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/comparison.kt");
                }

                @TestMetadata("componentAccess.kt")
                public void testComponentAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/componentAccess.kt");
                }

                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/contains.kt");
                }

                @TestMetadata("mathOperations.kt")
                public void testMathOperations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/mathOperations.kt");
                }

                @TestMetadata("rangeTo.kt")
                public void testRangeTo() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/rangeTo.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonLocalReturns extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNonLocalReturns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("anonymousObjects.kt")
                public void testAnonymousObjects() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjects.kt");
                }

                @TestMetadata("anonymousObjectsNested.kt")
                public void testAnonymousObjectsNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjectsNested.kt");
                }

                @TestMetadata("explicitReturnType.kt")
                public void testExplicitReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/explicitReturnType.kt");
                }

                @TestMetadata("fromOnlyLocal.kt")
                public void testFromOnlyLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/fromOnlyLocal.kt");
                }

                @TestMetadata("inlineLambda.kt")
                public void testInlineLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/inlineLambda.kt");
                }

                @TestMetadata("labeledReturn.kt")
                public void testLabeledReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/labeledReturn.kt");
                }

                @TestMetadata("lambdaAsGeneric.kt")
                public void testLambdaAsGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsGeneric.kt");
                }

                @TestMetadata("lambdaAsNonFunction.kt")
                public void testLambdaAsNonFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsNonFunction.kt");
                }

                @TestMetadata("lambdaWithGlobalReturnsInsideOnlyLocalOne.kt")
                public void testLambdaWithGlobalReturnsInsideOnlyLocalOne() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaWithGlobalReturnsInsideOnlyLocalOne.kt");
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/localFun.kt");
                }

                @TestMetadata("nestedNonLocals.kt")
                public void testNestedNonLocals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nestedNonLocals.kt");
                }

                @TestMetadata("noInlineAnnotation.kt")
                public void testNoInlineAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineAnnotation.kt");
                }

                @TestMetadata("noInlineLambda.kt")
                public void testNoInlineLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineLambda.kt");
                }

                @TestMetadata("nonInlinedClass.kt")
                public void testNonInlinedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nonInlinedClass.kt");
                }

                @TestMetadata("onlyLocalReturnLambda.kt")
                public void testOnlyLocalReturnLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambda.kt");
                }

                @TestMetadata("onlyLocalReturnLambdaBinaryExpr.kt")
                public void testOnlyLocalReturnLambdaBinaryExpr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambdaBinaryExpr.kt");
                }

                @TestMetadata("propertyAccessorsAndConstructor.kt")
                public void testPropertyAccessorsAndConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/propertyAccessorsAndConstructor.kt");
                }

                @TestMetadata("toOnlyLocal.kt")
                public void testToOnlyLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/toOnlyLocal.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonPublicMember extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNonPublicMember() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonPublicMember"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inNonPublicClass.kt")
                public void testInNonPublicClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicClass.kt");
                }

                @TestMetadata("inNonPublicInnerClass.kt")
                public void testInNonPublicInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicInnerClass.kt");
                }

                @TestMetadata("inPackage.kt")
                public void testInPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPackage.kt");
                }

                @TestMetadata("inPublicClass.kt")
                public void testInPublicClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPublicClass.kt");
                }

                @TestMetadata("kt14887.kt")
                public void testKt14887() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/kt14887.kt");
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass.kt");
                }

                @TestMetadata("localClass2.kt")
                public void testLocalClass2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass2.kt");
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localFun.kt");
                }

                @TestMetadata("publishedApi.kt")
                public void testPublishedApi() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/publishedApi.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/invoke.kt");
                }

                @TestMetadata("propertyWithBackingField.kt")
                public void testPropertyWithBackingField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/propertyWithBackingField.kt");
                }

                @TestMetadata("unsupportedConstruction.kt")
                public void testUnsupportedConstruction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/unsupportedConstruction.kt");
                }

                @TestMetadata("virtualProperty.kt")
                public void testVirtualProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/virtualProperty.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/regressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Regressions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRegressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt4341.kt")
                public void testKt4341() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/regressions/kt4341.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnaryExpressions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInUnaryExpressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/unaryExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("mathOperation.kt")
                public void testMathOperation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/mathOperation.kt");
                }

                @TestMetadata("notOnCall.kt")
                public void testNotOnCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOnCall.kt");
                }

                @TestMetadata("notOperation.kt")
                public void testNotOperation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOperation.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClasses extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basicInlineClassDeclaration.kt")
            public void testBasicInlineClassDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/basicInlineClassDeclaration.kt");
            }

            @TestMetadata("basicInlineClassDeclarationDisabled.kt")
            public void testBasicInlineClassDeclarationDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/basicInlineClassDeclarationDisabled.kt");
            }

            @TestMetadata("constructorsJvmSignaturesClash.kt")
            public void testConstructorsJvmSignaturesClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/constructorsJvmSignaturesClash.kt");
            }

            @TestMetadata("delegatedPropertyInInlineClass.kt")
            public void testDelegatedPropertyInInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/delegatedPropertyInInlineClass.kt");
            }

            @TestMetadata("functionsJvmSignaturesClash.kt")
            public void testFunctionsJvmSignaturesClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/functionsJvmSignaturesClash.kt");
            }

            @TestMetadata("functionsJvmSignaturesConflictOnInheritance.kt")
            public void testFunctionsJvmSignaturesConflictOnInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/functionsJvmSignaturesConflictOnInheritance.kt");
            }

            @TestMetadata("identityComparisonWithInlineClasses.kt")
            public void testIdentityComparisonWithInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/identityComparisonWithInlineClasses.kt");
            }

            @TestMetadata("inlineClassCanOnlyImplementInterfaces.kt")
            public void testInlineClassCanOnlyImplementInterfaces() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCanOnlyImplementInterfaces.kt");
            }

            @TestMetadata("inlineClassCannotImplementInterfaceByDelegation.kt")
            public void testInlineClassCannotImplementInterfaceByDelegation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCannotImplementInterfaceByDelegation.kt");
            }

            @TestMetadata("inlineClassConstructorParameterWithDefaultValue.kt")
            public void testInlineClassConstructorParameterWithDefaultValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassConstructorParameterWithDefaultValue.kt");
            }

            @TestMetadata("inlineClassDeclarationCheck.kt")
            public void testInlineClassDeclarationCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassDeclarationCheck.kt");
            }

            @TestMetadata("inlineClassImplementsCollection.kt")
            public void testInlineClassImplementsCollection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassImplementsCollection.kt");
            }

            @TestMetadata("inlineClassWithForbiddenUnderlyingType.kt")
            public void testInlineClassWithForbiddenUnderlyingType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassWithForbiddenUnderlyingType.kt");
            }

            @TestMetadata("inlineClassesInsideAnnotations.kt")
            public void testInlineClassesInsideAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassesInsideAnnotations.kt");
            }

            @TestMetadata("lateinitInlineClasses.kt")
            public void testLateinitInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/lateinitInlineClasses.kt");
            }

            @TestMetadata("presenceOfInitializerBlockInsideInlineClass.kt")
            public void testPresenceOfInitializerBlockInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfInitializerBlockInsideInlineClass.kt");
            }

            @TestMetadata("presenceOfPublicPrimaryConstructorForInlineClass.kt")
            public void testPresenceOfPublicPrimaryConstructorForInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfPublicPrimaryConstructorForInlineClass.kt");
            }

            @TestMetadata("propertiesWithBackingFieldsInsideInlineClass.kt")
            public void testPropertiesWithBackingFieldsInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/propertiesWithBackingFieldsInsideInlineClass.kt");
            }

            @TestMetadata("recursiveInlineClasses.kt")
            public void testRecursiveInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/recursiveInlineClasses.kt");
            }

            @TestMetadata("reservedMembersAndConstructsInsideInlineClass.kt")
            public void testReservedMembersAndConstructsInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/reservedMembersAndConstructsInsideInlineClass.kt");
            }

            @TestMetadata("unsignedLiteralsWithoutArtifactOnClasspath.kt")
            public void testUnsignedLiteralsWithoutArtifactOnClasspath() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/unsignedLiteralsWithoutArtifactOnClasspath.kt");
            }

            @TestMetadata("varargsOnParametersOfInlineClassType.kt")
            public void testVarargsOnParametersOfInlineClassType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/varargsOnParametersOfInlineClassType.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("accessingToJavaNestedClass.kt")
            public void testAccessingToJavaNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/accessingToJavaNestedClass.kt");
            }

            @TestMetadata("accessingToKotlinNestedClass.kt")
            public void testAccessingToKotlinNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/accessingToKotlinNestedClass.kt");
            }

            public void testAllFilesPresentInInner() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationInInnerClass.kt")
            public void testAnnotationInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/annotationInInnerClass.kt");
            }

            @TestMetadata("classesInClassObjectHeader.kt")
            public void testClassesInClassObjectHeader() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/classesInClassObjectHeader.kt");
            }

            @TestMetadata("constructorAccess.kt")
            public void testConstructorAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/constructorAccess.kt");
            }

            @TestMetadata("deepInnerClass.kt")
            public void testDeepInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/deepInnerClass.kt");
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/enumEntries.kt");
            }

            @TestMetadata("enumInInnerClass.kt")
            public void testEnumInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/enumInInnerClass.kt");
            }

            @TestMetadata("extensionFun.kt")
            public void testExtensionFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/extensionFun.kt");
            }

            @TestMetadata("extensionLambdaInsideNestedClass.kt")
            public void testExtensionLambdaInsideNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/extensionLambdaInsideNestedClass.kt");
            }

            @TestMetadata("illegalModifier.kt")
            public void testIllegalModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/illegalModifier.kt");
            }

            @TestMetadata("illegalModifier_lv12.kt")
            public void testIllegalModifier_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/illegalModifier_lv12.kt");
            }

            @TestMetadata("innerClassInEnumEntryClassMemberResolve.kt")
            public void testInnerClassInEnumEntryClassMemberResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClassMemberResolve.kt");
            }

            @TestMetadata("innerClassInEnumEntryClass_lv11.kt")
            public void testInnerClassInEnumEntryClass_lv11() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv11.kt");
            }

            @TestMetadata("innerClassInEnumEntryClass_lv12.kt")
            public void testInnerClassInEnumEntryClass_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv12.kt");
            }

            @TestMetadata("innerClassInEnumEntryClass_lv13.kt")
            public void testInnerClassInEnumEntryClass_lv13() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv13.kt");
            }

            @TestMetadata("InnerClassNameClash.kt")
            public void testInnerClassNameClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/InnerClassNameClash.kt");
            }

            @TestMetadata("innerClassesInStaticParameters.kt")
            public void testInnerClassesInStaticParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassesInStaticParameters.kt");
            }

            @TestMetadata("innerConstructorsFromQualifiers.kt")
            public void testInnerConstructorsFromQualifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiers.kt");
            }

            @TestMetadata("innerConstructorsFromQualifiersWithIrrelevantCandidate.kt")
            public void testInnerConstructorsFromQualifiersWithIrrelevantCandidate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiersWithIrrelevantCandidate.kt");
            }

            @TestMetadata("innerErrorForClassObjects.kt")
            public void testInnerErrorForClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerErrorForClassObjects.kt");
            }

            @TestMetadata("innerErrorForObjects.kt")
            public void testInnerErrorForObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerErrorForObjects.kt");
            }

            @TestMetadata("innerThisSuper.kt")
            public void testInnerThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerThisSuper.kt");
            }

            @TestMetadata("interfaceInInnerClass.kt")
            public void testInterfaceInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/interfaceInInnerClass.kt");
            }

            @TestMetadata("kt5854.kt")
            public void testKt5854() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/kt5854.kt");
            }

            @TestMetadata("kt6026.kt")
            public void testKt6026() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/kt6026.kt");
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localClass.kt");
            }

            @TestMetadata("localClassInsideNested.kt")
            public void testLocalClassInsideNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localClassInsideNested.kt");
            }

            @TestMetadata("localThisSuper.kt")
            public void testLocalThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localThisSuper.kt");
            }

            @TestMetadata("modality.kt")
            public void testModality() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/modality.kt");
            }

            @TestMetadata("nestedClassAccessedViaInstanceReference.kt")
            public void testNestedClassAccessedViaInstanceReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassAccessedViaInstanceReference.kt");
            }

            @TestMetadata("nestedClassExtendsOuter.kt")
            public void testNestedClassExtendsOuter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuter.kt");
            }

            @TestMetadata("nestedClassExtendsOuterGeneric.kt")
            public void testNestedClassExtendsOuterGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuterGeneric.kt");
            }

            @TestMetadata("nestedClassInObject.kt")
            public void testNestedClassInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassInObject.kt");
            }

            @TestMetadata("nestedClassNotAllowed_after.kt")
            public void testNestedClassNotAllowed_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_after.kt");
            }

            @TestMetadata("nestedClassNotAllowed_before.kt")
            public void testNestedClassNotAllowed_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_before.kt");
            }

            @TestMetadata("nestedObject.kt")
            public void testNestedObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedObject.kt");
            }

            @TestMetadata("nestedVsInnerAccessOuterMember.kt")
            public void testNestedVsInnerAccessOuterMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedVsInnerAccessOuterMember.kt");
            }

            @TestMetadata("outerGenericParam.kt")
            public void testOuterGenericParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerGenericParam.kt");
            }

            @TestMetadata("outerProtectedMember.kt")
            public void testOuterProtectedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerProtectedMember.kt");
            }

            @TestMetadata("outerSuperClassMember.kt")
            public void testOuterSuperClassMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerSuperClassMember.kt");
            }

            @TestMetadata("referenceToSelfInLocal.kt")
            public void testReferenceToSelfInLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/referenceToSelfInLocal.kt");
            }

            @TestMetadata("resolvePackageClassInObjects.kt")
            public void testResolvePackageClassInObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/resolvePackageClassInObjects.kt");
            }

            @TestMetadata("selfAnnotationForClassObject.kt")
            public void testSelfAnnotationForClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/selfAnnotationForClassObject.kt");
            }

            @TestMetadata("traits.kt")
            public void testTraits() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/traits.kt");
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/visibility.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class QualifiedExpression extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inner/qualifiedExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classObjectOfNestedClass.kt")
                public void testClassObjectOfNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/classObjectOfNestedClass.kt");
                }

                @TestMetadata("constructNestedClass.kt")
                public void testConstructNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/constructNestedClass.kt");
                }

                @TestMetadata("dataLocalVariable.kt")
                public void testDataLocalVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/dataLocalVariable.kt");
                }

                @TestMetadata("enumConstant.kt")
                public void testEnumConstant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/enumConstant.kt");
                }

                @TestMetadata("genericNestedClass.kt")
                public void testGenericNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/genericNestedClass.kt");
                }

                @TestMetadata("importNestedClass.kt")
                public void testImportNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/importNestedClass.kt");
                }

                @TestMetadata("nestedClassInPackage.kt")
                public void testNestedClassInPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedClassInPackage.kt");
                }

                @TestMetadata("nestedEnumConstant.kt")
                public void testNestedEnumConstant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedEnumConstant.kt");
                }

                @TestMetadata("nestedObjects.kt")
                public void testNestedObjects() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedObjects.kt");
                }

                @TestMetadata("typePosition.kt")
                public void testTypePosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/typePosition.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/j+k")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class J_k extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("accessClassObjectFromJava.kt")
            public void testAccessClassObjectFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/accessClassObjectFromJava.kt");
            }

            public void testAllFilesPresentInJ_k() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguousSamAdapters.kt")
            public void testAmbiguousSamAdapters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/ambiguousSamAdapters.kt");
            }

            @TestMetadata("annotationWithArgumentsMissingDependencies.kt")
            public void testAnnotationWithArgumentsMissingDependencies() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/annotationWithArgumentsMissingDependencies.kt");
            }

            @TestMetadata("annotationsInheritance.kt")
            public void testAnnotationsInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/annotationsInheritance.kt");
            }

            @TestMetadata("arrayOfStarParametrized.kt")
            public void testArrayOfStarParametrized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/arrayOfStarParametrized.kt");
            }

            @TestMetadata("callableReferencesStaticMemberClash.kt")
            public void testCallableReferencesStaticMemberClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/callableReferencesStaticMemberClash.kt");
            }

            @TestMetadata("canDeclareIfSamAdapterIsInherited.kt")
            public void testCanDeclareIfSamAdapterIsInherited() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/canDeclareIfSamAdapterIsInherited.kt");
            }

            @TestMetadata("collectorInference.kt")
            public void testCollectorInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/collectorInference.kt");
            }

            @TestMetadata("computeIfAbsentConcurrent.kt")
            public void testComputeIfAbsentConcurrent() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/computeIfAbsentConcurrent.kt");
            }

            @TestMetadata("contravariantIterable.kt")
            public void testContravariantIterable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/contravariantIterable.kt");
            }

            @TestMetadata("defaultMethods.kt")
            public void testDefaultMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/defaultMethods.kt");
            }

            @TestMetadata("defaultMethodsIndirectInheritance.kt")
            public void testDefaultMethodsIndirectInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/defaultMethodsIndirectInheritance.kt");
            }

            @TestMetadata("defaultMethods_warning.kt")
            public void testDefaultMethods_warning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/defaultMethods_warning.kt");
            }

            @TestMetadata("differentFilename.kt")
            public void testDifferentFilename() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/differentFilename.kt");
            }

            @TestMetadata("enumGetOrdinal.kt")
            public void testEnumGetOrdinal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/enumGetOrdinal.kt");
            }

            @TestMetadata("exceptionMessage.kt")
            public void testExceptionMessage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/exceptionMessage.kt");
            }

            @TestMetadata("fieldOverridesField.kt")
            public void testFieldOverridesField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesField.kt");
            }

            @TestMetadata("fieldOverridesFieldOfDifferentType.kt")
            public void testFieldOverridesFieldOfDifferentType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesFieldOfDifferentType.kt");
            }

            @TestMetadata("fieldOverridesNothing.kt")
            public void testFieldOverridesNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesNothing.kt");
            }

            @TestMetadata("finalCollectionSize.kt")
            public void testFinalCollectionSize() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/finalCollectionSize.kt");
            }

            @TestMetadata("flexibleNothing.kt")
            public void testFlexibleNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/flexibleNothing.kt");
            }

            @TestMetadata("genericConstructorWithMultipleBounds.kt")
            public void testGenericConstructorWithMultipleBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/genericConstructorWithMultipleBounds.kt");
            }

            @TestMetadata("GenericsInSupertypes.kt")
            public void testGenericsInSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/GenericsInSupertypes.kt");
            }

            @TestMetadata("inheritAbstractSamAdapter.kt")
            public void testInheritAbstractSamAdapter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/inheritAbstractSamAdapter.kt");
            }

            @TestMetadata("inheritanceStaticMethodFromInterface.kt")
            public void testInheritanceStaticMethodFromInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/inheritanceStaticMethodFromInterface.kt");
            }

            @TestMetadata("InheritedGenericFunction.kt")
            public void testInheritedGenericFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/InheritedGenericFunction.kt");
            }

            @TestMetadata("InnerClassFromJava.kt")
            public void testInnerClassFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/InnerClassFromJava.kt");
            }

            @TestMetadata("innerNestedClassFromJava.kt")
            public void testInnerNestedClassFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/innerNestedClassFromJava.kt");
            }

            @TestMetadata("invisiblePackagePrivateInheritedMember.kt")
            public void testInvisiblePackagePrivateInheritedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/invisiblePackagePrivateInheritedMember.kt");
            }

            @TestMetadata("javaStaticImport.kt")
            public void testJavaStaticImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/javaStaticImport.kt");
            }

            @TestMetadata("KJKInheritance.kt")
            public void testKJKInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritance.kt");
            }

            @TestMetadata("KJKInheritanceGeneric.kt")
            public void testKJKInheritanceGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritanceGeneric.kt");
            }

            @TestMetadata("kt1402.kt")
            public void testKt1402() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1402.kt");
            }

            @TestMetadata("kt1431.kt")
            public void testKt1431() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1431.kt");
            }

            @TestMetadata("kt1730_implementCharSequence.kt")
            public void testKt1730_implementCharSequence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1730_implementCharSequence.kt");
            }

            @TestMetadata("kt2152.kt")
            public void testKt2152() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2152.kt");
            }

            @TestMetadata("kt2394.kt")
            public void testKt2394() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2394.kt");
            }

            @TestMetadata("kt2606.kt")
            public void testKt2606() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2606.kt");
            }

            @TestMetadata("kt2619.kt")
            public void testKt2619() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2619.kt");
            }

            @TestMetadata("kt2641.kt")
            public void testKt2641() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2641.kt");
            }

            @TestMetadata("kt2890.kt")
            public void testKt2890() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2890.kt");
            }

            @TestMetadata("kt3307.kt")
            public void testKt3307() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt3307.kt");
            }

            @TestMetadata("kt3311.kt")
            public void testKt3311() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt3311.kt");
            }

            @TestMetadata("kt6720_abstractProperty.kt")
            public void testKt6720_abstractProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt6720_abstractProperty.kt");
            }

            @TestMetadata("kt7523.kt")
            public void testKt7523() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt7523.kt");
            }

            @TestMetadata("matchers.kt")
            public void testMatchers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/matchers.kt");
            }

            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/mutableIterator.kt");
            }

            @TestMetadata("nullForOptionalOrElse.kt")
            public void testNullForOptionalOrElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/nullForOptionalOrElse.kt");
            }

            @TestMetadata("overrideRawType.kt")
            public void testOverrideRawType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/overrideRawType.kt");
            }

            @TestMetadata("OverrideVararg.kt")
            public void testOverrideVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/OverrideVararg.kt");
            }

            @TestMetadata("overrideWithSamAndTypeParameter.kt")
            public void testOverrideWithSamAndTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/overrideWithSamAndTypeParameter.kt");
            }

            @TestMetadata("packagePrivateClassStaticMember.kt")
            public void testPackagePrivateClassStaticMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/packagePrivateClassStaticMember.kt");
            }

            @TestMetadata("packageVisibility.kt")
            public void testPackageVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/packageVisibility.kt");
            }

            @TestMetadata("privateFieldOverridesNothing.kt")
            public void testPrivateFieldOverridesNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/privateFieldOverridesNothing.kt");
            }

            @TestMetadata("privateNestedClassStaticMember.kt")
            public void testPrivateNestedClassStaticMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/privateNestedClassStaticMember.kt");
            }

            @TestMetadata("protectedStaticSamePackage.kt")
            public void testProtectedStaticSamePackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/protectedStaticSamePackage.kt");
            }

            @TestMetadata("recursionWithJavaSyntheticProperty.kt")
            public void testRecursionWithJavaSyntheticProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursionWithJavaSyntheticProperty.kt");
            }

            @TestMetadata("recursiveRawUpperBound.kt")
            public void testRecursiveRawUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound.kt");
            }

            @TestMetadata("recursiveRawUpperBound2.kt")
            public void testRecursiveRawUpperBound2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound2.kt");
            }

            @TestMetadata("recursiveRawUpperBound3.kt")
            public void testRecursiveRawUpperBound3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound3.kt");
            }

            @TestMetadata("samInConstructorWithGenerics.kt")
            public void testSamInConstructorWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/samInConstructorWithGenerics.kt");
            }

            @TestMetadata("samWithConsumer.kt")
            public void testSamWithConsumer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/samWithConsumer.kt");
            }

            @TestMetadata("selectMoreSpecific.kt")
            public void testSelectMoreSpecific() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/selectMoreSpecific.kt");
            }

            @TestMetadata("serializable.kt")
            public void testSerializable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/serializable.kt");
            }

            @TestMetadata("shadowingPrimitiveStaticField.kt")
            public void testShadowingPrimitiveStaticField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/shadowingPrimitiveStaticField.kt");
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/Simple.kt");
            }

            @TestMetadata("specialBridges.kt")
            public void testSpecialBridges() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/specialBridges.kt");
            }

            @TestMetadata("StaticMembersFromSuperclasses.kt")
            public void testStaticMembersFromSuperclasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/StaticMembersFromSuperclasses.kt");
            }

            @TestMetadata("staticMethodInClass.kt")
            public void testStaticMethodInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/staticMethodInClass.kt");
            }

            @TestMetadata("SupertypeArgumentsNullability-NotNull-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_SpecialTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-SpecialTypes.kt");
            }

            @TestMetadata("SupertypeArgumentsNullability-NotNull-UserTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_UserTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-UserTypes.kt");
            }

            @TestMetadata("SupertypeArgumentsNullability-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_SpecialTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-SpecialTypes.kt");
            }

            @TestMetadata("SupertypeArgumentsNullability-UserTypes.kt")
            public void testSupertypeArgumentsNullability_UserTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-UserTypes.kt");
            }

            @TestMetadata("traitDefaultCall.kt")
            public void testTraitDefaultCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/traitDefaultCall.kt");
            }

            @TestMetadata("typeAliasWithSamConstructor.kt")
            public void testTypeAliasWithSamConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/typeAliasWithSamConstructor.kt");
            }

            @TestMetadata("UnboxingNulls.kt")
            public void testUnboxingNulls() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/UnboxingNulls.kt");
            }

            @TestMetadata("wrongVarianceInJava.kt")
            public void testWrongVarianceInJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/wrongVarianceInJava.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BrokenCode extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBrokenCode() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/brokenCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classDuplicates.kt")
                public void testClassDuplicates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/classDuplicates.kt");
                }

                @TestMetadata("fieldDuplicates.kt")
                public void testFieldDuplicates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/fieldDuplicates.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CollectionOverrides extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCollectionOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/collectionOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("charBuffer.kt")
                public void testCharBuffer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/charBuffer.kt");
                }

                @TestMetadata("collectionStringImpl.kt")
                public void testCollectionStringImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/collectionStringImpl.kt");
                }

                @TestMetadata("commonCollections.kt")
                public void testCommonCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/commonCollections.kt");
                }

                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/contains.kt");
                }

                @TestMetadata("containsAll.kt")
                public void testContainsAll() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAll.kt");
                }

                @TestMetadata("containsAndOverload.kt")
                public void testContainsAndOverload() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAndOverload.kt");
                }

                @TestMetadata("getCharSequence.kt")
                public void testGetCharSequence() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/getCharSequence.kt");
                }

                @TestMetadata("irrelevantCharAtAbstract.kt")
                public void testIrrelevantCharAtAbstract() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantCharAtAbstract.kt");
                }

                @TestMetadata("irrelevantImplCharSequence.kt")
                public void testIrrelevantImplCharSequence() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequence.kt");
                }

                @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
                public void testIrrelevantImplCharSequenceKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequenceKotlin.kt");
                }

                @TestMetadata("irrelevantImplMutableList.kt")
                public void testIrrelevantImplMutableList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableList.kt");
                }

                @TestMetadata("irrelevantImplMutableListKotlin.kt")
                public void testIrrelevantImplMutableListKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableListKotlin.kt");
                }

                @TestMetadata("irrelevantMapGetAbstract.kt")
                public void testIrrelevantMapGetAbstract() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantMapGetAbstract.kt");
                }

                @TestMetadata("mapGetOverride.kt")
                public void testMapGetOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/mapGetOverride.kt");
                }

                @TestMetadata("overridesBuiltinNoMagic.kt")
                public void testOverridesBuiltinNoMagic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/overridesBuiltinNoMagic.kt");
                }

                @TestMetadata("removeAt.kt")
                public void testRemoveAt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAt.kt");
                }

                @TestMetadata("removeAtInt.kt")
                public void testRemoveAtInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAtInt.kt");
                }

                @TestMetadata("sizeFromKotlinOverriddenInJava.kt")
                public void testSizeFromKotlinOverriddenInJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/sizeFromKotlinOverriddenInJava.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/deprecations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Deprecations extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDeprecations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/deprecations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("forFakeOverrides.kt")
                public void testForFakeOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forFakeOverrides.kt");
                }

                @TestMetadata("forMixedOverride.kt")
                public void testForMixedOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forMixedOverride.kt");
                }

                @TestMetadata("forOverrides.kt")
                public void testForOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forOverrides.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericConstructor extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInGenericConstructor() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/genericConstructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classTypeParameterInferredFromArgument.kt")
                public void testClassTypeParameterInferredFromArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/classTypeParameterInferredFromArgument.kt");
                }

                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/innerClass.kt");
                }

                @TestMetadata("noClassTypeParameters.kt")
                public void testNoClassTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParameters.kt");
                }

                @TestMetadata("noClassTypeParametersInvParameter.kt")
                public void testNoClassTypeParametersInvParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParametersInvParameter.kt");
                }

                @TestMetadata("recursive.kt")
                public void testRecursive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/recursive.kt");
                }

                @TestMetadata("selfTypes.kt")
                public void testSelfTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/selfTypes.kt");
                }

                @TestMetadata("superCall.kt")
                public void testSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCall.kt");
                }

                @TestMetadata("superCallImpossibleToInfer.kt")
                public void testSuperCallImpossibleToInfer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCallImpossibleToInfer.kt");
                }

                @TestMetadata("withClassTypeParameters.kt")
                public void testWithClassTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/withClassTypeParameters.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimitiveOverrides extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPrimitiveOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt11140.kt")
                public void testKt11140() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/kt11140.kt");
                }

                @TestMetadata("notNullAnnotated.kt")
                public void testNotNullAnnotated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/notNullAnnotated.kt");
                }

                @TestMetadata("specializedMap.kt")
                public void testSpecializedMap() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/specializedMap.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimitiveOverridesWithInlineClass extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPrimitiveOverridesWithInlineClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inlineClassErasedToPrimitiveInt.kt")
                public void testInlineClassErasedToPrimitiveInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass/inlineClassErasedToPrimitiveInt.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/properties")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Properties extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProperties() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("interface.kt")
                public void testInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/interface.kt");
                }

                @TestMetadata("isName.kt")
                public void testIsName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/isName.kt");
                }

                @TestMetadata("val.kt")
                public void testVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/val.kt");
                }

                @TestMetadata("var.kt")
                public void testVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/var.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/sam")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Sam extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSam() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/sam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enhancedSamConstructor.kt")
                public void testEnhancedSamConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/enhancedSamConstructor.kt");
                }

                @TestMetadata("fakeOverrideFunctionForStaticSam.kt")
                public void testFakeOverrideFunctionForStaticSam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/fakeOverrideFunctionForStaticSam.kt");
                }

                @TestMetadata("inheritedStaticSam.kt")
                public void testInheritedStaticSam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/inheritedStaticSam.kt");
                }

                @TestMetadata("privateCandidatesWithWrongArguments.kt")
                public void testPrivateCandidatesWithWrongArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/privateCandidatesWithWrongArguments.kt");
                }

                @TestMetadata("samOnTypeParameter.kt")
                public void testSamOnTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/samOnTypeParameter.kt");
                }

                @TestMetadata("staticSamFromImportWithStar.kt")
                public void testStaticSamFromImportWithStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/staticSamFromImportWithStar.kt");
                }

                @TestMetadata("staticSamWithExplicitImport.kt")
                public void testStaticSamWithExplicitImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/staticSamWithExplicitImport.kt");
                }

                @TestMetadata("typeInferenceOnSamAdapters.kt")
                public void testTypeInferenceOnSamAdapters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/typeInferenceOnSamAdapters.kt");
                }

                @TestMetadata("withDefaultMethods.kt")
                public void testWithDefaultMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/withDefaultMethods.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SamByProjectedType extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSamByProjectedType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/samByProjectedType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("genericInReturnType.kt")
                public void testGenericInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInReturnType.kt");
                }

                @TestMetadata("genericInValueParameter.kt")
                public void testGenericInValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInValueParameter.kt");
                }

                @TestMetadata("genericSuperWildcard.kt")
                public void testGenericSuperWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericSuperWildcard.kt");
                }

                @TestMetadata("noAdapterBecuaseOfRecursiveUpperBound.kt")
                public void testNoAdapterBecuaseOfRecursiveUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/noAdapterBecuaseOfRecursiveUpperBound.kt");
                }

                @TestMetadata("starProjectionComplexUpperBound.kt")
                public void testStarProjectionComplexUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/starProjectionComplexUpperBound.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/signatureAnnotations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SignatureAnnotations extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSignatureAnnotations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/signatureAnnotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("defaultEnum.kt")
                public void testDefaultEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/defaultEnum.kt");
                }

                @TestMetadata("defaultLongLiteral.kt")
                public void testDefaultLongLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/defaultLongLiteral.kt");
                }

                @TestMetadata("defaultNull.kt")
                public void testDefaultNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/defaultNull.kt");
                }

                @TestMetadata("defaultNullAndParameter.kt")
                public void testDefaultNullAndParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/defaultNullAndParameter.kt");
                }

                @TestMetadata("defaultParameter.kt")
                public void testDefaultParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/defaultParameter.kt");
                }

                @TestMetadata("emptyParameterName.kt")
                public void testEmptyParameterName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/emptyParameterName.kt");
                }

                @TestMetadata("notNullVarargOverride.kt")
                public void testNotNullVarargOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/notNullVarargOverride.kt");
                }

                @TestMetadata("nullableVarargOverride.kt")
                public void testNullableVarargOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/nullableVarargOverride.kt");
                }

                @TestMetadata("overridesDefaultValue.kt")
                public void testOverridesDefaultValue() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/overridesDefaultValue.kt");
                }

                @TestMetadata("overridesParameterName.kt")
                public void testOverridesParameterName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/overridesParameterName.kt");
                }

                @TestMetadata("reorderedParameterNames.kt")
                public void testReorderedParameterNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/reorderedParameterNames.kt");
                }

                @TestMetadata("sameParameterName.kt")
                public void testSameParameterName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/sameParameterName.kt");
                }

                @TestMetadata("specialCharsParameterName.kt")
                public void testSpecialCharsParameterName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/specialCharsParameterName.kt");
                }

                @TestMetadata("stableParameterName.kt")
                public void testStableParameterName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/stableParameterName.kt");
                }

                @TestMetadata("staticMethodWithDefaultValue.kt")
                public void testStaticMethodWithDefaultValue() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/staticMethodWithDefaultValue.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/specialBuiltIns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecialBuiltIns extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSpecialBuiltIns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/specialBuiltIns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("hashtableInheritance.kt")
                public void testHashtableInheritance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/specialBuiltIns/hashtableInheritance.kt");
                }

                @TestMetadata("securityProvider.kt")
                public void testSecurityProvider() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/specialBuiltIns/securityProvider.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/types")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Types extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/types"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayList.kt")
                public void testArrayList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/arrayList.kt");
                }

                @TestMetadata("returnCollection.kt")
                public void testReturnCollection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/returnCollection.kt");
                }

                @TestMetadata("shapeMismatchInCovariantPosition.kt")
                public void testShapeMismatchInCovariantPosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPosition.kt");
                }

                @TestMetadata("shapeMismatchInCovariantPositionGeneric.kt")
                public void testShapeMismatchInCovariantPositionGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPositionGeneric.kt");
                }

                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/typeParameter.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/java8Overrides")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java8Overrides extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstractBaseClassMemberNotImplemented.kt")
            public void testAbstractBaseClassMemberNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractBaseClassMemberNotImplemented.kt");
            }

            @TestMetadata("abstractVsAbstract.kt")
            public void testAbstractVsAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractVsAbstract.kt");
            }

            public void testAllFilesPresentInJava8Overrides() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/java8Overrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("defaultVsAbstract.kt")
            public void testDefaultVsAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/defaultVsAbstract.kt");
            }

            @TestMetadata("hidingMethodOfAny.kt")
            public void testHidingMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/hidingMethodOfAny.kt");
            }

            @TestMetadata("implementingMethodOfAny.kt")
            public void testImplementingMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/implementingMethodOfAny.kt");
            }

            @TestMetadata("notAMethodOfAny.kt")
            public void testNotAMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/notAMethodOfAny.kt");
            }

            @TestMetadata("overridingMethodOfAnyChain.kt")
            public void testOverridingMethodOfAnyChain() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyChain.kt");
            }

            @TestMetadata("overridingMethodOfAnyDiamond.kt")
            public void testOverridingMethodOfAnyDiamond() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyDiamond.kt");
            }

            @TestMetadata("singleRelevantDefault.kt")
            public void testSingleRelevantDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/singleRelevantDefault.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/labels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Labels extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLabels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("automaticLabelFromInfixOperator.kt")
            public void testAutomaticLabelFromInfixOperator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/automaticLabelFromInfixOperator.kt");
            }

            @TestMetadata("kt1703.kt")
            public void testKt1703() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt1703.kt");
            }

            @TestMetadata("kt361.kt")
            public void testKt361() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt361.kt");
            }

            @TestMetadata("kt3920.kt")
            public void testKt3920() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt3920.kt");
            }

            @TestMetadata("kt3988.kt")
            public void testKt3988() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt3988.kt");
            }

            @TestMetadata("kt4247.kt")
            public void testKt4247() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4247.kt");
            }

            @TestMetadata("kt4586.kt")
            public void testKt4586() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4586.kt");
            }

            @TestMetadata("kt4603.kt")
            public void testKt4603() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4603.kt");
            }

            @TestMetadata("kt591.kt")
            public void testKt591() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt591.kt");
            }

            @TestMetadata("labelReferencesInsideObjectExpressions.kt")
            public void testLabelReferencesInsideObjectExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labelReferencesInsideObjectExpressions.kt");
            }

            @TestMetadata("labeledFunctionLiteral.kt")
            public void testLabeledFunctionLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labeledFunctionLiteral.kt");
            }

            @TestMetadata("labelsMustBeNamed.kt")
            public void testLabelsMustBeNamed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labelsMustBeNamed.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lateinit extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLateinit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/lateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("modifierApplicability.kt")
            public void testModifierApplicability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/modifierApplicability.kt");
            }

            @TestMetadata("modifierApplicability_lv12.kt")
            public void testModifierApplicability_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/modifierApplicability_lv12.kt");
            }

            @TestMetadata("setter.kt")
            public void testSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/setter.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/lateinit/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/lateinit/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inapplicableLateinitModifier.kt")
                public void testInapplicableLateinitModifier() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/inapplicableLateinitModifier.kt");
                }

                @TestMetadata("localLateinit.kt")
                public void testLocalLateinit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/localLateinit.kt");
                }

                @TestMetadata("uninitialized.kt")
                public void testUninitialized() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/uninitialized.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/library")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Library extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLibrary() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/library"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Collections.kt")
            public void testCollections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/library/Collections.kt");
            }

            @TestMetadata("kt828.kt")
            public void testKt828() throws Exception {
                runTest("compiler/testData/diagnostics/tests/library/kt828.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/localClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalClasses extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLocalClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/localClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("localAnnotationClass.kt")
            public void testLocalAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/localClasses/localAnnotationClass.kt");
            }

            @TestMetadata("localAnnotationClassError.kt")
            public void testLocalAnnotationClassError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/localClasses/localAnnotationClassError.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/modifiers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Modifiers extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInModifiers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/annotations.kt");
            }

            @TestMetadata("defaultModifier.kt")
            public void testDefaultModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/defaultModifier.kt");
            }

            @TestMetadata("IllegalModifiers.kt")
            public void testIllegalModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/IllegalModifiers.kt");
            }

            @TestMetadata("incompatibleVarianceModifiers.kt")
            public void testIncompatibleVarianceModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/incompatibleVarianceModifiers.kt");
            }

            @TestMetadata("inlineParameters.kt")
            public void testInlineParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/inlineParameters.kt");
            }

            @TestMetadata("internalInInterface.kt")
            public void testInternalInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/internalInInterface.kt");
            }

            @TestMetadata("modifierOnParameterInFunctionType.kt")
            public void testModifierOnParameterInFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/modifierOnParameterInFunctionType.kt");
            }

            @TestMetadata("NoLocalVisibility.kt")
            public void testNoLocalVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/NoLocalVisibility.kt");
            }

            @TestMetadata("openInInterface.kt")
            public void testOpenInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/openInInterface.kt");
            }

            @TestMetadata("primaryConstructorMissingBrackets.kt")
            public void testPrimaryConstructorMissingBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/primaryConstructorMissingBrackets.kt");
            }

            @TestMetadata("primaryConstructorMissingKeyword.kt")
            public void testPrimaryConstructorMissingKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/primaryConstructorMissingKeyword.kt");
            }

            @TestMetadata("privateInInterface.kt")
            public void testPrivateInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/privateInInterface.kt");
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/protected.kt");
            }

            @TestMetadata("redundantTargets.kt")
            public void testRedundantTargets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/redundantTargets.kt");
            }

            @TestMetadata("repeatedModifiers.kt")
            public void testRepeatedModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/repeatedModifiers.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/const")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Const extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInConst() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/const"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("applicability.kt")
                public void testApplicability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/applicability.kt");
                }

                @TestMetadata("arrayInAnnotationArgumentType.kt")
                public void testArrayInAnnotationArgumentType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/arrayInAnnotationArgumentType.kt");
                }

                @TestMetadata("constInteraction.kt")
                public void testConstInteraction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/constInteraction.kt");
                }

                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/fromJava.kt");
                }

                @TestMetadata("fromJavaSubclass.kt")
                public void testFromJavaSubclass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/fromJavaSubclass.kt");
                }

                @TestMetadata("kt12248.kt")
                public void testKt12248() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/kt12248.kt");
                }

                @TestMetadata("kt15913.kt")
                public void testKt15913() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/kt15913.kt");
                }

                @TestMetadata("noDivisionByZeroFeature.kt")
                public void testNoDivisionByZeroFeature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/noDivisionByZeroFeature.kt");
                }

                @TestMetadata("types.kt")
                public void testTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/types.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OperatorInfix extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInOperatorInfix() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/operatorInfix"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("LocalFunctions.kt")
                public void testLocalFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/LocalFunctions.kt");
                }

                @TestMetadata("MemberFunctions.kt")
                public void testMemberFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/MemberFunctions.kt");
                }

                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/Simple.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/multimodule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multimodule extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMultimodule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/internal.kt");
            }

            @TestMetadata("kt14249.kt")
            public void testKt14249() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/kt14249.kt");
            }

            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/packagePrivate.kt");
            }

            @TestMetadata("publishedApiInternal.kt")
            public void testPublishedApiInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/publishedApiInternal.kt");
            }

            @TestMetadata("redundantElseInWhen.kt")
            public void testRedundantElseInWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/redundantElseInWhen.kt");
            }

            @TestMetadata("varargConflict.kt")
            public void testVarargConflict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/varargConflict.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateClass extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDuplicateClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("collectionMethodStub.kt")
                public void testCollectionMethodStub() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/collectionMethodStub.kt");
                }

                @TestMetadata("differentGenericArguments.kt")
                public void testDifferentGenericArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArguments.kt");
                }

                @TestMetadata("differentGenericArgumentsReversed.kt")
                public void testDifferentGenericArgumentsReversed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArgumentsReversed.kt");
                }

                @TestMetadata("duplicateClass.kt")
                public void testDuplicateClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateClass.kt");
                }

                @TestMetadata("duplicateNestedClasses.kt")
                public void testDuplicateNestedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateNestedClasses.kt");
                }

                @TestMetadata("duplicateSuperClass.kt")
                public void testDuplicateSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateSuperClass.kt");
                }

                @TestMetadata("genericArgumentNumberMismatch.kt")
                public void testGenericArgumentNumberMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericArgumentNumberMismatch.kt");
                }

                @TestMetadata("genericSuperClass.kt")
                public void testGenericSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericSuperClass.kt");
                }

                @TestMetadata("inTheSameModuleWithUsage.kt")
                public void testInTheSameModuleWithUsage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsage.kt");
                }

                @TestMetadata("inTheSameModuleWithUsageNoTypeAnnotation.kt")
                public void testInTheSameModuleWithUsageNoTypeAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsageNoTypeAnnotation.kt");
                }

                @TestMetadata("members.kt")
                public void testMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/members.kt");
                }

                @TestMetadata("sameClassNameDifferentPackages.kt")
                public void testSameClassNameDifferentPackages() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameClassNameDifferentPackages.kt");
                }

                @TestMetadata("sameGenericArguments.kt")
                public void testSameGenericArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameGenericArguments.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateMethod extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDuplicateMethod() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateMethod"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classGenericsInParams.kt")
                public void testClassGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParams.kt");
                }

                @TestMetadata("classGenericsInParamsBoundMismatch.kt")
                public void testClassGenericsInParamsBoundMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsBoundMismatch.kt");
                }

                @TestMetadata("classGenericsInParamsIndexMismatch.kt")
                public void testClassGenericsInParamsIndexMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsIndexMismatch.kt");
                }

                @TestMetadata("classGenericsInParamsNameMismatch.kt")
                public void testClassGenericsInParamsNameMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsNameMismatch.kt");
                }

                @TestMetadata("classGenericsInReturnType.kt")
                public void testClassGenericsInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInReturnType.kt");
                }

                @TestMetadata("classVsFunctionGenericsInParamsMismatch.kt")
                public void testClassVsFunctionGenericsInParamsMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classVsFunctionGenericsInParamsMismatch.kt");
                }

                @TestMetadata("covariantReturnTypes.kt")
                public void testCovariantReturnTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/covariantReturnTypes.kt");
                }

                @TestMetadata("differenceInParamNames.kt")
                public void testDifferenceInParamNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differenceInParamNames.kt");
                }

                @TestMetadata("differentGenericsInParams.kt")
                public void testDifferentGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentGenericsInParams.kt");
                }

                @TestMetadata("differentNumberOfParams.kt")
                public void testDifferentNumberOfParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentNumberOfParams.kt");
                }

                @TestMetadata("differentReturnTypes.kt")
                public void testDifferentReturnTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentReturnTypes.kt");
                }

                @TestMetadata("extensionMatch.kt")
                public void testExtensionMatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/extensionMatch.kt");
                }

                @TestMetadata("functionGenericsInParams.kt")
                public void testFunctionGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParams.kt");
                }

                @TestMetadata("functionGenericsInParamsBoundsMismatch.kt")
                public void testFunctionGenericsInParamsBoundsMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsBoundsMismatch.kt");
                }

                @TestMetadata("functionGenericsInParamsEqNull.kt")
                public void testFunctionGenericsInParamsEqNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsEqNull.kt");
                }

                @TestMetadata("functionGenericsInParamsNotIs.kt")
                public void testFunctionGenericsInParamsNotIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsNotIs.kt");
                }

                @TestMetadata("functionGenericsInParamsReturnFooT.kt")
                public void testFunctionGenericsInParamsReturnFooT() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnFooT.kt");
                }

                @TestMetadata("functionGenericsInParamsReturnT.kt")
                public void testFunctionGenericsInParamsReturnT() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnT.kt");
                }

                @TestMetadata("incompleteCodeNoNoneApplicable.kt")
                public void testIncompleteCodeNoNoneApplicable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/incompleteCodeNoNoneApplicable.kt");
                }

                @TestMetadata("noGenericsInParams.kt")
                public void testNoGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noGenericsInParams.kt");
                }

                @TestMetadata("noParams.kt")
                public void testNoParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noParams.kt");
                }

                @TestMetadata("sameGenericsInParams.kt")
                public void testSameGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sameGenericsInParams.kt");
                }

                @TestMetadata("simpleWithInheritance.kt")
                public void testSimpleWithInheritance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/simpleWithInheritance.kt");
                }

                @TestMetadata("sinceKotlin.kt")
                public void testSinceKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sinceKotlin.kt");
                }

                @TestMetadata("substitutedGenericInParams.kt")
                public void testSubstitutedGenericInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/substitutedGenericInParams.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateSuper extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDuplicateSuper() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateSuper"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("differentSuperTraits.kt")
                public void testDifferentSuperTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/differentSuperTraits.kt");
                }

                @TestMetadata("sameSuperTrait.kt")
                public void testSameSuperTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTrait.kt");
                }

                @TestMetadata("sameSuperTraitDifferentBounds.kt")
                public void testSameSuperTraitDifferentBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitDifferentBounds.kt");
                }

                @TestMetadata("sameSuperTraitGenerics.kt")
                public void testSameSuperTraitGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitGenerics.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HiddenClass extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInHiddenClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/hiddenClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("deprecatedHiddenImportPriority.kt")
                public void testDeprecatedHiddenImportPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenImportPriority.kt");
                }

                @TestMetadata("deprecatedHiddenMultipleClasses.kt")
                public void testDeprecatedHiddenMultipleClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenMultipleClasses.kt");
                }

                @TestMetadata("sinceKotlinImportPriority.kt")
                public void testSinceKotlinImportPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinImportPriority.kt");
                }

                @TestMetadata("sinceKotlinMultipleClasses.kt")
                public void testSinceKotlinMultipleClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinMultipleClasses.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/multiplatform")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multiplatform extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMultiplatform() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("headerFunInNonHeaderClass.kt")
            public void testHeaderFunInNonHeaderClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/headerFunInNonHeaderClass.kt");
            }

            @TestMetadata("implDelegatedMember.kt")
            public void testImplDelegatedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implDelegatedMember.kt");
            }

            @TestMetadata("implDynamic.kt")
            public void testImplDynamic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implDynamic.kt");
            }

            @TestMetadata("implFakeOverride.kt")
            public void testImplFakeOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implFakeOverride.kt");
            }

            @TestMetadata("incompatibles.kt")
            public void testIncompatibles() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/incompatibles.kt");
            }

            @TestMetadata("modifierApplicability.kt")
            public void testModifierApplicability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/modifierApplicability.kt");
            }

            @TestMetadata("namedArguments.kt")
            public void testNamedArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/namedArguments.kt");
            }

            @TestMetadata("privateTopLevelDeclarations.kt")
            public void testPrivateTopLevelDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/privateTopLevelDeclarations.kt");
            }

            @TestMetadata("sealedTypeAlias.kt")
            public void testSealedTypeAlias() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/sealedTypeAlias.kt");
            }

            @TestMetadata("sealedTypeAliasTopLevel.kt")
            public void testSealedTypeAliasTopLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/sealedTypeAliasTopLevel.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/defaultArguments")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefaultArguments extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDefaultArguments() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationArgumentEquality.kt")
                public void testAnnotationArgumentEquality() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationArgumentEquality.kt");
                }

                @TestMetadata("annotations.kt")
                public void testAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotations.kt");
                }

                @TestMetadata("annotationsViaActualTypeAlias.kt")
                public void testAnnotationsViaActualTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationsViaActualTypeAlias.kt");
                }

                @TestMetadata("annotationsViaActualTypeAlias2.kt")
                public void testAnnotationsViaActualTypeAlias2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationsViaActualTypeAlias2.kt");
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/constructor.kt");
                }

                @TestMetadata("expectedDeclaresDefaultArguments.kt")
                public void testExpectedDeclaresDefaultArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedDeclaresDefaultArguments.kt");
                }

                @TestMetadata("expectedInheritsDefaultArguments.kt")
                public void testExpectedInheritsDefaultArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedInheritsDefaultArguments.kt");
                }

                @TestMetadata("expectedVsNonExpectedWithDefaults.kt")
                public void testExpectedVsNonExpectedWithDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedVsNonExpectedWithDefaults.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/deprecated")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Deprecated extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDeprecated() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/deprecated"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("header.kt")
                public void testHeader() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/deprecated/header.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/enum")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Enum extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("additionalEntriesInImpl.kt")
                public void testAdditionalEntriesInImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/additionalEntriesInImpl.kt");
                }

                public void testAllFilesPresentInEnum() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constructorInHeaderEnum.kt")
                public void testConstructorInHeaderEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/constructorInHeaderEnum.kt");
                }

                @TestMetadata("differentEntryOrder.kt")
                public void testDifferentEntryOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/differentEntryOrder.kt");
                }

                @TestMetadata("enumEntryWithBody.kt")
                public void testEnumEntryWithBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/enumEntryWithBody.kt");
                }

                @TestMetadata("simpleEnum.kt")
                public void testSimpleEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/simpleEnum.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/generic")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Generic extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInGeneric() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/generic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("functionTypeParameterBounds.kt")
                public void testFunctionTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/functionTypeParameterBounds.kt");
                }

                @TestMetadata("genericMemberBounds.kt")
                public void testGenericMemberBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/genericMemberBounds.kt");
                }

                @TestMetadata("membersInGenericClass.kt")
                public void testMembersInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/membersInGenericClass.kt");
                }

                @TestMetadata("typeParameterBoundsDifferentOrderActualMissing.kt")
                public void testTypeParameterBoundsDifferentOrderActualMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/typeParameterBoundsDifferentOrderActualMissing.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/headerClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HeaderClass extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("actualClassWithDefaultValuesInAnnotationViaTypealias.kt")
                public void testActualClassWithDefaultValuesInAnnotationViaTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualClassWithDefaultValuesInAnnotationViaTypealias.kt");
                }

                @TestMetadata("actualClassWithDifferentConstructors.kt")
                public void testActualClassWithDifferentConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualClassWithDifferentConstructors.kt");
                }

                @TestMetadata("actualMissing.kt")
                public void testActualMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualMissing.kt");
                }

                public void testAllFilesPresentInHeaderClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/headerClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("baseExpectClassWithoutConstructor.kt")
                public void testBaseExpectClassWithoutConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/baseExpectClassWithoutConstructor.kt");
                }

                @TestMetadata("classKinds.kt")
                public void testClassKinds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/classKinds.kt");
                }

                @TestMetadata("dontOverrideMethodsFromInterfaceInCommonCode.kt")
                public void testDontOverrideMethodsFromInterfaceInCommonCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/dontOverrideMethodsFromInterfaceInCommonCode.kt");
                }

                @TestMetadata("expectClassWithExplicitAbstractMember.kt")
                public void testExpectClassWithExplicitAbstractMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectClassWithExplicitAbstractMember.kt");
                }

                @TestMetadata("expectClassWithoutConstructor.kt")
                public void testExpectClassWithoutConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectClassWithoutConstructor.kt");
                }

                @TestMetadata("expectDeclarationWithStrongIncompatibilities.kt")
                public void testExpectDeclarationWithStrongIncompatibilities() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectDeclarationWithStrongIncompatibilities.kt");
                }

                @TestMetadata("expectDeclarationWithWeakIncompatibilities.kt")
                public void testExpectDeclarationWithWeakIncompatibilities() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectDeclarationWithWeakIncompatibilities.kt");
                }

                @TestMetadata("expectFinalActualOpen.kt")
                public void testExpectFinalActualOpen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectFinalActualOpen.kt");
                }

                @TestMetadata("explicitConstructorDelegation.kt")
                public void testExplicitConstructorDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/explicitConstructorDelegation.kt");
                }

                @TestMetadata("extendExpectedClassWithAbstractMember.kt")
                public void testExtendExpectedClassWithAbstractMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extendExpectedClassWithAbstractMember.kt");
                }

                @TestMetadata("extendExpectedClassWithoutExplicitOverrideOfMethod.kt")
                public void testExtendExpectedClassWithoutExplicitOverrideOfMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extendExpectedClassWithoutExplicitOverrideOfMethod.kt");
                }

                @TestMetadata("extraHeaderOnMembers.kt")
                public void testExtraHeaderOnMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extraHeaderOnMembers.kt");
                }

                @TestMetadata("functionAndPropertyWithSameName.kt")
                public void testFunctionAndPropertyWithSameName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/functionAndPropertyWithSameName.kt");
                }

                @TestMetadata("genericClassImplTypeAlias.kt")
                public void testGenericClassImplTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/genericClassImplTypeAlias.kt");
                }

                @TestMetadata("headerClassMember.kt")
                public void testHeaderClassMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/headerClassMember.kt");
                }

                @TestMetadata("headerClassWithFunctionBody.kt")
                public void testHeaderClassWithFunctionBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/headerClassWithFunctionBody.kt");
                }

                @TestMetadata("implDataClass.kt")
                public void testImplDataClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/implDataClass.kt");
                }

                @TestMetadata("implOpenClass.kt")
                public void testImplOpenClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/implOpenClass.kt");
                }

                @TestMetadata("inheritanceByDelegationInExpectClass.kt")
                public void testInheritanceByDelegationInExpectClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/inheritanceByDelegationInExpectClass.kt");
                }

                @TestMetadata("memberPropertyKinds.kt")
                public void testMemberPropertyKinds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/memberPropertyKinds.kt");
                }

                @TestMetadata("modalityCheckForExplicitAndImplicitOverride.kt")
                public void testModalityCheckForExplicitAndImplicitOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/modalityCheckForExplicitAndImplicitOverride.kt");
                }

                @TestMetadata("morePermissiveVisibilityOnActual.kt")
                public void testMorePermissiveVisibilityOnActual() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/morePermissiveVisibilityOnActual.kt");
                }

                @TestMetadata("morePermissiveVisibilityOnActualViaTypeAlias.kt")
                public void testMorePermissiveVisibilityOnActualViaTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/morePermissiveVisibilityOnActualViaTypeAlias.kt");
                }

                @TestMetadata("nestedClasses.kt")
                public void testNestedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/nestedClasses.kt");
                }

                @TestMetadata("nestedClassesWithErrors.kt")
                public void testNestedClassesWithErrors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/nestedClassesWithErrors.kt");
                }

                @TestMetadata("noImplKeywordOnMember.kt")
                public void testNoImplKeywordOnMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/noImplKeywordOnMember.kt");
                }

                @TestMetadata("privateMembers.kt")
                public void testPrivateMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/privateMembers.kt");
                }

                @TestMetadata("simpleHeaderClass.kt")
                public void testSimpleHeaderClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/simpleHeaderClass.kt");
                }

                @TestMetadata("smartCastOnExpectClass.kt")
                public void testSmartCastOnExpectClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/smartCastOnExpectClass.kt");
                }

                @TestMetadata("superClass.kt")
                public void testSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/superClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/inlineClasses")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineClasses extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("expectActualInlineClass.kt")
                public void testExpectActualInlineClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/inlineClasses/expectActualInlineClass.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/java")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Java extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInJava() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/java"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("flexibleTypes.kt")
                public void testFlexibleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/java/flexibleTypes.kt");
                }

                @TestMetadata("parameterNames.kt")
                public void testParameterNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/java/parameterNames.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/topLevelFun")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TopLevelFun extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTopLevelFun() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/topLevelFun"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callHeaderFun.kt")
                public void testCallHeaderFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/callHeaderFun.kt");
                }

                @TestMetadata("callableReferenceOnExpectFun.kt")
                public void testCallableReferenceOnExpectFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/callableReferenceOnExpectFun.kt");
                }

                @TestMetadata("conflictingHeaderDeclarations.kt")
                public void testConflictingHeaderDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/conflictingHeaderDeclarations.kt");
                }

                @TestMetadata("conflictingImplDeclarations.kt")
                public void testConflictingImplDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/conflictingImplDeclarations.kt");
                }

                @TestMetadata("functionModifiers.kt")
                public void testFunctionModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/functionModifiers.kt");
                }

                @TestMetadata("headerAndImplInDIfferentPackages.kt")
                public void testHeaderAndImplInDIfferentPackages() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerAndImplInDIfferentPackages.kt");
                }

                @TestMetadata("headerDeclarationWithBody.kt")
                public void testHeaderDeclarationWithBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerDeclarationWithBody.kt");
                }

                @TestMetadata("headerWithoutImpl.kt")
                public void testHeaderWithoutImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerWithoutImpl.kt");
                }

                @TestMetadata("implDeclarationWithoutBody.kt")
                public void testImplDeclarationWithoutBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/implDeclarationWithoutBody.kt");
                }

                @TestMetadata("implWithoutHeader.kt")
                public void testImplWithoutHeader() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/implWithoutHeader.kt");
                }

                @TestMetadata("inlineFun.kt")
                public void testInlineFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/inlineFun.kt");
                }

                @TestMetadata("simpleHeaderFun.kt")
                public void testSimpleHeaderFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/simpleHeaderFun.kt");
                }

                @TestMetadata("valueParameterModifiers.kt")
                public void testValueParameterModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/valueParameterModifiers.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TopLevelProperty extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTopLevelProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("differentKindsOfProperties.kt")
                public void testDifferentKindsOfProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty/differentKindsOfProperties.kt");
                }

                @TestMetadata("simpleHeaderVar.kt")
                public void testSimpleHeaderVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty/simpleHeaderVar.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/namedArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NamedArguments extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNamedArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/namedArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("allowForJavaAnnotation.kt")
            public void testAllowForJavaAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/allowForJavaAnnotation.kt");
            }

            @TestMetadata("ambiguousNamedArguments1.kt")
            public void testAmbiguousNamedArguments1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments1.kt");
            }

            @TestMetadata("ambiguousNamedArguments2.kt")
            public void testAmbiguousNamedArguments2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments2.kt");
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics1.kt")
            public void testAmbiguousNamedArgumentsWithGenerics1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics1.kt");
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics2.kt")
            public void testAmbiguousNamedArgumentsWithGenerics2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics2.kt");
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics3.kt")
            public void testAmbiguousNamedArgumentsWithGenerics3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics3.kt");
            }

            @TestMetadata("disallowForJavaConstructor.kt")
            public void testDisallowForJavaConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaConstructor.kt");
            }

            @TestMetadata("disallowForJavaMethods.kt")
            public void testDisallowForJavaMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaMethods.kt");
            }

            @TestMetadata("disallowForSamAdapterConstructor.kt")
            public void testDisallowForSamAdapterConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterConstructor.kt");
            }

            @TestMetadata("disallowForSamAdapterFunction.kt")
            public void testDisallowForSamAdapterFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterFunction.kt");
            }

            @TestMetadata("namedArgumentsAndDefaultValues.kt")
            public void testNamedArgumentsAndDefaultValues() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsAndDefaultValues.kt");
            }

            @TestMetadata("namedArgumentsInOverloads.kt")
            public void testNamedArgumentsInOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverloads.kt");
            }

            @TestMetadata("namedArgumentsInOverrides.kt")
            public void testNamedArgumentsInOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverrides.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullabilityAndSmartCasts extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNullabilityAndSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AssertNotNull.kt")
            public void testAssertNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/AssertNotNull.kt");
            }

            @TestMetadata("dataFlowInfoAfterExclExcl.kt")
            public void testDataFlowInfoAfterExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/dataFlowInfoAfterExclExcl.kt");
            }

            @TestMetadata("equalityUnderNotNullCheck.kt")
            public void testEqualityUnderNotNullCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/equalityUnderNotNullCheck.kt");
            }

            @TestMetadata("funcLiteralArgsInsideAmbiguity.kt")
            public void testFuncLiteralArgsInsideAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/funcLiteralArgsInsideAmbiguity.kt");
            }

            @TestMetadata("funcLiteralArgsInsideUnresolvedFunction.kt")
            public void testFuncLiteralArgsInsideUnresolvedFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/funcLiteralArgsInsideUnresolvedFunction.kt");
            }

            @TestMetadata("InfixCallNullability.kt")
            public void testInfixCallNullability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/InfixCallNullability.kt");
            }

            @TestMetadata("kt1270.kt")
            public void testKt1270() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1270.kt");
            }

            @TestMetadata("kt1680.kt")
            public void testKt1680() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1680.kt");
            }

            @TestMetadata("kt1778.kt")
            public void testKt1778() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1778.kt");
            }

            @TestMetadata("kt2109.kt")
            public void testKt2109() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2109.kt");
            }

            @TestMetadata("kt2125.kt")
            public void testKt2125() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2125.kt");
            }

            @TestMetadata("kt2146.kt")
            public void testKt2146() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2146.kt");
            }

            @TestMetadata("kt2164.kt")
            public void testKt2164() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2164.kt");
            }

            @TestMetadata("kt2176.kt")
            public void testKt2176() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2176.kt");
            }

            @TestMetadata("kt2195.kt")
            public void testKt2195() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2195.kt");
            }

            @TestMetadata("kt2212.kt")
            public void testKt2212() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2212.kt");
            }

            @TestMetadata("kt2216.kt")
            public void testKt2216() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2216.kt");
            }

            @TestMetadata("kt2223.kt")
            public void testKt2223() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2223.kt");
            }

            @TestMetadata("kt2234.kt")
            public void testKt2234() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2234.kt");
            }

            @TestMetadata("kt2336.kt")
            public void testKt2336() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2336.kt");
            }

            @TestMetadata("kt244.kt")
            public void testKt244() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt244.kt");
            }

            @TestMetadata("kt362.kt")
            public void testKt362() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt362.kt");
            }

            @TestMetadata("noSenselessNullOnNullableType.kt")
            public void testNoSenselessNullOnNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/noSenselessNullOnNullableType.kt");
            }

            @TestMetadata("noUnnecessaryNotNullAssertionOnErrorType.kt")
            public void testNoUnnecessaryNotNullAssertionOnErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/noUnnecessaryNotNullAssertionOnErrorType.kt");
            }

            @TestMetadata("notnullTypesFromJavaWithSmartcast.kt")
            public void testNotnullTypesFromJavaWithSmartcast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/notnullTypesFromJavaWithSmartcast.kt");
            }

            @TestMetadata("NullableNothingIsExactlyNull.kt")
            public void testNullableNothingIsExactlyNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/NullableNothingIsExactlyNull.kt");
            }

            @TestMetadata("nullableReceiverWithOverloadedMethod.kt")
            public void testNullableReceiverWithOverloadedMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/nullableReceiverWithOverloadedMethod.kt");
            }

            @TestMetadata("PreferExtensionsOnNullableReceiver.kt")
            public void testPreferExtensionsOnNullableReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/PreferExtensionsOnNullableReceiver.kt");
            }

            @TestMetadata("QualifiedExpressionNullability.kt")
            public void testQualifiedExpressionNullability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/QualifiedExpressionNullability.kt");
            }

            @TestMetadata("ReceiverNullability.kt")
            public void testReceiverNullability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/ReceiverNullability.kt");
            }

            @TestMetadata("SenselessNullInWhen.kt")
            public void testSenselessNullInWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/SenselessNullInWhen.kt");
            }

            @TestMetadata("senslessComparisonWithNullOnTypeParameters.kt")
            public void testSenslessComparisonWithNullOnTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/senslessComparisonWithNullOnTypeParameters.kt");
            }

            @TestMetadata("smartCastReceiverWithGenerics.kt")
            public void testSmartCastReceiverWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/smartCastReceiverWithGenerics.kt");
            }

            @TestMetadata("smartCastsAndBooleanExpressions.kt")
            public void testSmartCastsAndBooleanExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/smartCastsAndBooleanExpressions.kt");
            }

            @TestMetadata("unnecessaryNotNullAssertion.kt")
            public void testUnnecessaryNotNullAssertion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/unnecessaryNotNullAssertion.kt");
            }

            @TestMetadata("unstableSmartcastWhenOpenGetterWithOverloading.kt")
            public void testUnstableSmartcastWhenOpenGetterWithOverloading() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/unstableSmartcastWhenOpenGetterWithOverloading.kt");
            }

            @TestMetadata("unstableSmartcastWithOverloadedExtensions.kt")
            public void testUnstableSmartcastWithOverloadedExtensions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/unstableSmartcastWithOverloadedExtensions.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/nullableTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullableTypes extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNullableTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/nullableTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("baseWithNullableUpperBound.kt")
            public void testBaseWithNullableUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/baseWithNullableUpperBound.kt");
            }

            @TestMetadata("elvisOnUnit.kt")
            public void testElvisOnUnit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/elvisOnUnit.kt");
            }

            @TestMetadata("nullAssertOnTypeWithNullableUpperBound.kt")
            public void testNullAssertOnTypeWithNullableUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/nullAssertOnTypeWithNullableUpperBound.kt");
            }

            @TestMetadata("nullableArgumentForIn.kt")
            public void testNullableArgumentForIn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/nullableArgumentForIn.kt");
            }

            @TestMetadata("nullableArgumentToNonNullParameterPlatform.kt")
            public void testNullableArgumentToNonNullParameterPlatform() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/nullableArgumentToNonNullParameterPlatform.kt");
            }

            @TestMetadata("nullableArgumentToNonNullParameterSimple.kt")
            public void testNullableArgumentToNonNullParameterSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/nullableArgumentToNonNullParameterSimple.kt");
            }

            @TestMetadata("redundantNullable.kt")
            public void testRedundantNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/redundantNullable.kt");
            }

            @TestMetadata("redundantNullableInSupertype.kt")
            public void testRedundantNullableInSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/redundantNullableInSupertype.kt");
            }

            @TestMetadata("safeAccessOnUnit.kt")
            public void testSafeAccessOnUnit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/safeAccessOnUnit.kt");
            }

            @TestMetadata("safeCallOnTypeWithNullableUpperBound.kt")
            public void testSafeCallOnTypeWithNullableUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/safeCallOnTypeWithNullableUpperBound.kt");
            }

            @TestMetadata("safeCallWithInvoke.kt")
            public void testSafeCallWithInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/safeCallWithInvoke.kt");
            }

            @TestMetadata("uselessElvis.kt")
            public void testUselessElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullableTypes/uselessElvis.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/numbers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Numbers extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNumbers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/numbers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("characterIsNotANumber.kt")
            public void testCharacterIsNotANumber() throws Exception {
                runTest("compiler/testData/diagnostics/tests/numbers/characterIsNotANumber.kt");
            }

            @TestMetadata("doublesInSimpleConstraints.kt")
            public void testDoublesInSimpleConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/numbers/doublesInSimpleConstraints.kt");
            }

            @TestMetadata("intValuesOutOfRange.kt")
            public void testIntValuesOutOfRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/numbers/intValuesOutOfRange.kt");
            }

            @TestMetadata("numbersInSimpleConstraints.kt")
            public void testNumbersInSimpleConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/numbers/numbersInSimpleConstraints.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/objects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Objects extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInObjects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/objects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("invokeOnInnerObject.kt")
            public void testInvokeOnInnerObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/invokeOnInnerObject.kt");
            }

            @TestMetadata("kt2240.kt")
            public void testKt2240() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/kt2240.kt");
            }

            @TestMetadata("kt5527.kt")
            public void testKt5527() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/kt5527.kt");
            }

            @TestMetadata("localObjectInsideObject.kt")
            public void testLocalObjectInsideObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/localObjectInsideObject.kt");
            }

            @TestMetadata("localObjects.kt")
            public void testLocalObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/localObjects.kt");
            }

            @TestMetadata("nestedClassInAnonymousObject.kt")
            public void testNestedClassInAnonymousObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/nestedClassInAnonymousObject.kt");
            }

            @TestMetadata("objectInsideFun.kt")
            public void testObjectInsideFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/objectInsideFun.kt");
            }

            @TestMetadata("objectLiteralExpressionTypeMismatch.kt")
            public void testObjectLiteralExpressionTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/objectLiteralExpressionTypeMismatch.kt");
            }

            @TestMetadata("Objects.kt")
            public void testObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/Objects.kt");
            }

            @TestMetadata("ObjectsInheritance.kt")
            public void testObjectsInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/ObjectsInheritance.kt");
            }

            @TestMetadata("ObjectsLocal.kt")
            public void testObjectsLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/ObjectsLocal.kt");
            }

            @TestMetadata("ObjectsNested.kt")
            public void testObjectsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/ObjectsNested.kt");
            }

            @TestMetadata("OpenInObject.kt")
            public void testOpenInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/OpenInObject.kt");
            }

            @TestMetadata("upperBoundViolated.kt")
            public void testUpperBoundViolated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/objects/upperBoundViolated.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/objects/kt21515")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Kt21515 extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInKt21515() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/objects/kt21515"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationConstructor.kt")
                public void testAnnotationConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/annotationConstructor.kt");
                }

                @TestMetadata("callableReferenceComplexCasesWithImportsOld.kt")
                public void testCallableReferenceComplexCasesWithImportsOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferenceComplexCasesWithImportsOld.kt");
                }

                @TestMetadata("callableReferencesComplexCasesWithQualificationOld.kt")
                public void testCallableReferencesComplexCasesWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesComplexCasesWithQualificationOld.kt");
                }

                @TestMetadata("callableReferencesNew.kt")
                public void testCallableReferencesNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesNew.kt");
                }

                @TestMetadata("callableReferencesOld.kt")
                public void testCallableReferencesOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesOld.kt");
                }

                @TestMetadata("callableReferencesOldComplexCases.kt")
                public void testCallableReferencesOldComplexCases() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesOldComplexCases.kt");
                }

                @TestMetadata("callableReferencesWithQualificationNew.kt")
                public void testCallableReferencesWithQualificationNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesWithQualificationNew.kt");
                }

                @TestMetadata("callableReferencesWithQualificationOld.kt")
                public void testCallableReferencesWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/callableReferencesWithQualificationOld.kt");
                }

                @TestMetadata("classifierFromCompanionObjectNew.kt")
                public void testClassifierFromCompanionObjectNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/classifierFromCompanionObjectNew.kt");
                }

                @TestMetadata("classifierFromCompanionObjectOld.kt")
                public void testClassifierFromCompanionObjectOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/classifierFromCompanionObjectOld.kt");
                }

                @TestMetadata("classifierFromCompanionObjectWithQualificationNew.kt")
                public void testClassifierFromCompanionObjectWithQualificationNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/classifierFromCompanionObjectWithQualificationNew.kt");
                }

                @TestMetadata("classifierFromCompanionObjectWithQualificationOld.kt")
                public void testClassifierFromCompanionObjectWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/classifierFromCompanionObjectWithQualificationOld.kt");
                }

                @TestMetadata("classifierIsVisibleByTwoPaths.kt")
                public void testClassifierIsVisibleByTwoPaths() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/classifierIsVisibleByTwoPaths.kt");
                }

                @TestMetadata("inheritedFromDeprecatedNew.kt")
                public void testInheritedFromDeprecatedNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/inheritedFromDeprecatedNew.kt");
                }

                @TestMetadata("inheritedFromDeprecatedOld.kt")
                public void testInheritedFromDeprecatedOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/inheritedFromDeprecatedOld.kt");
                }

                @TestMetadata("inheritedFromDeprecatedWithQualificationNew.kt")
                public void testInheritedFromDeprecatedWithQualificationNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/inheritedFromDeprecatedWithQualificationNew.kt");
                }

                @TestMetadata("inheritedFromDeprecatedWithQualificationOld.kt")
                public void testInheritedFromDeprecatedWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/inheritedFromDeprecatedWithQualificationOld.kt");
                }

                @TestMetadata("staticsFromJavaNew.kt")
                public void testStaticsFromJavaNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/staticsFromJavaNew.kt");
                }

                @TestMetadata("staticsFromJavaOld.kt")
                public void testStaticsFromJavaOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/staticsFromJavaOld.kt");
                }

                @TestMetadata("staticsFromJavaWithQualificationNew.kt")
                public void testStaticsFromJavaWithQualificationNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/staticsFromJavaWithQualificationNew.kt");
                }

                @TestMetadata("staticsFromJavaWithQualificationOld.kt")
                public void testStaticsFromJavaWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/staticsFromJavaWithQualificationOld.kt");
                }

                @TestMetadata("useDeprecatedConstructorNew.kt")
                public void testUseDeprecatedConstructorNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/useDeprecatedConstructorNew.kt");
                }

                @TestMetadata("useDeprecatedConstructorOld.kt")
                public void testUseDeprecatedConstructorOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/useDeprecatedConstructorOld.kt");
                }

                @TestMetadata("useDeprecatedConstructorWithQualificationNew.kt")
                public void testUseDeprecatedConstructorWithQualificationNew() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/useDeprecatedConstructorWithQualificationNew.kt");
                }

                @TestMetadata("useDeprecatedConstructorWithQualificationOld.kt")
                public void testUseDeprecatedConstructorWithQualificationOld() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/objects/kt21515/useDeprecatedConstructorWithQualificationOld.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/operatorRem")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OperatorRem extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOperatorRem() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/operatorRem"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DeprecatedModAssignOperatorConventions.kt")
            public void testDeprecatedModAssignOperatorConventions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/DeprecatedModAssignOperatorConventions.kt");
            }

            @TestMetadata("deprecatedModConvention.kt")
            public void testDeprecatedModConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/deprecatedModConvention.kt");
            }

            @TestMetadata("DeprecatedModOperatorConventions.kt")
            public void testDeprecatedModOperatorConventions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/DeprecatedModOperatorConventions.kt");
            }

            @TestMetadata("doNotResolveToInapplicableRem.kt")
            public void testDoNotResolveToInapplicableRem() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/doNotResolveToInapplicableRem.kt");
            }

            @TestMetadata("errorOnExplicitModCall.kt")
            public void testErrorOnExplicitModCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/errorOnExplicitModCall.kt");
            }

            @TestMetadata("forbiddenModOperatorConvention.kt")
            public void testForbiddenModOperatorConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/forbiddenModOperatorConvention.kt");
            }

            @TestMetadata("modWithRemAssign.kt")
            public void testModWithRemAssign() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/modWithRemAssign.kt");
            }

            @TestMetadata("noDeprecatedModConventionWithoutFeature.kt")
            public void testNoDeprecatedModConventionWithoutFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/noDeprecatedModConventionWithoutFeature.kt");
            }

            @TestMetadata("noOperatorRemFeature.kt")
            public void testNoOperatorRemFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/noOperatorRemFeature.kt");
            }

            @TestMetadata("noWarningForModFromBuiltinsWhenApi1_0_after.kt")
            public void testNoWarningForModFromBuiltinsWhenApi1_0_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/noWarningForModFromBuiltinsWhenApi1_0_after.kt");
            }

            @TestMetadata("noWarningForModFromBuiltinsWhenApi1_0_before.kt")
            public void testNoWarningForModFromBuiltinsWhenApi1_0_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/noWarningForModFromBuiltinsWhenApi1_0_before.kt");
            }

            @TestMetadata("numberRemConversions.kt")
            public void testNumberRemConversions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/numberRemConversions.kt");
            }

            @TestMetadata("operatorRem.kt")
            public void testOperatorRem() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/operatorRem.kt");
            }

            @TestMetadata("preferRemAsExtentionOverMod.kt")
            public void testPreferRemAsExtentionOverMod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/preferRemAsExtentionOverMod.kt");
            }

            @TestMetadata("preferRemAsMemberOverMod.kt")
            public void testPreferRemAsMemberOverMod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/preferRemAsMemberOverMod.kt");
            }

            @TestMetadata("preferRemFromCompanionObjectOverRem.kt")
            public void testPreferRemFromCompanionObjectOverRem() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/preferRemFromCompanionObjectOverRem.kt");
            }

            @TestMetadata("preferRemOverModInLocalFunctions.kt")
            public void testPreferRemOverModInLocalFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/preferRemOverModInLocalFunctions.kt");
            }

            @TestMetadata("preferRemWithImplicitReceivers.kt")
            public void testPreferRemWithImplicitReceivers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/preferRemWithImplicitReceivers.kt");
            }

            @TestMetadata("prefereRemAsExtensionOverMemberMod.kt")
            public void testPrefereRemAsExtensionOverMemberMod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/prefereRemAsExtensionOverMemberMod.kt");
            }

            @TestMetadata("remAndRemAssignAmbiguity.kt")
            public void testRemAndRemAssignAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/remAndRemAssignAmbiguity.kt");
            }

            @TestMetadata("remWithModAndModAssign.kt")
            public void testRemWithModAndModAssign() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/remWithModAndModAssign.kt");
            }

            @TestMetadata("remWithModAssign.kt")
            public void testRemWithModAssign() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/remWithModAssign.kt");
            }

            @TestMetadata("resolveModIfRemIsHidden.kt")
            public void testResolveModIfRemIsHidden() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/resolveModIfRemIsHidden.kt");
            }

            @TestMetadata("resolveToModWhenNoOperatorRemFeature.kt")
            public void testResolveToModWhenNoOperatorRemFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/resolveToModWhenNoOperatorRemFeature.kt");
            }

            @TestMetadata("warningOnExplicitModCall1_1.kt")
            public void testWarningOnExplicitModCall1_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/warningOnExplicitModCall1_1.kt");
            }

            @TestMetadata("warningOnExplicitModCall1_2.kt")
            public void testWarningOnExplicitModCall1_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorRem/warningOnExplicitModCall1_2.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/operatorsOverloading")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OperatorsOverloading extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOperatorsOverloading() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/operatorsOverloading"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AssignOperatorAmbiguity.kt")
            public void testAssignOperatorAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/AssignOperatorAmbiguity.kt");
            }

            @TestMetadata("AssignmentOperations.kt")
            public void testAssignmentOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/AssignmentOperations.kt");
            }

            @TestMetadata("assignmentOperationsCheckReturnType.kt")
            public void testAssignmentOperationsCheckReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/assignmentOperationsCheckReturnType.kt");
            }

            @TestMetadata("compareToNullable.kt")
            public void testCompareToNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/compareToNullable.kt");
            }

            @TestMetadata("InconsistentGetSet.kt")
            public void testInconsistentGetSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/InconsistentGetSet.kt");
            }

            @TestMetadata("IteratorAmbiguity.kt")
            public void testIteratorAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/IteratorAmbiguity.kt");
            }

            @TestMetadata("kt1028.kt")
            public void testKt1028() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/kt1028.kt");
            }

            @TestMetadata("kt11300.kt")
            public void testKt11300() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/kt11300.kt");
            }

            @TestMetadata("kt13330.kt")
            public void testKt13330() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/kt13330.kt");
            }

            @TestMetadata("kt13349.kt")
            public void testKt13349() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/kt13349.kt");
            }

            @TestMetadata("kt3450.kt")
            public void testKt3450() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/kt3450.kt");
            }

            @TestMetadata("plusAssignOnArray.kt")
            public void testPlusAssignOnArray() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnArray.kt");
            }

            @TestMetadata("plusAssignOnLocal.kt")
            public void testPlusAssignOnLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnLocal.kt");
            }

            @TestMetadata("plusAssignOnProperty.kt")
            public void testPlusAssignOnProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnProperty.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/overload")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Overload extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOverload() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/overload"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConflictingOlverloadsGenericFunctions.kt")
            public void testConflictingOlverloadsGenericFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOlverloadsGenericFunctions.kt");
            }

            @TestMetadata("ConflictingOverloadsFunsDifferentReturnInClass.kt")
            public void testConflictingOverloadsFunsDifferentReturnInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsFunsDifferentReturnInClass.kt");
            }

            @TestMetadata("ConflictingOverloadsFunsDifferentReturnInPackage.kt")
            public void testConflictingOverloadsFunsDifferentReturnInPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsFunsDifferentReturnInPackage.kt");
            }

            @TestMetadata("ConflictingOverloadsIdenticalExtFunsInPackage.kt")
            public void testConflictingOverloadsIdenticalExtFunsInPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalExtFunsInPackage.kt");
            }

            @TestMetadata("ConflictingOverloadsIdenticalFunsInClass.kt")
            public void testConflictingOverloadsIdenticalFunsInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalFunsInClass.kt");
            }

            @TestMetadata("ConflictingOverloadsIdenticalFunsTPInClass.kt")
            public void testConflictingOverloadsIdenticalFunsTPInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalFunsTPInClass.kt");
            }

            @TestMetadata("ConflictingOverloadsIdenticalValsInClass.kt")
            public void testConflictingOverloadsIdenticalValsInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalValsInClass.kt");
            }

            @TestMetadata("ConflictingOverloadsValsDifferentTypeInClass.kt")
            public void testConflictingOverloadsValsDifferentTypeInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsValsDifferentTypeInClass.kt");
            }

            @TestMetadata("ConstructorVsFunOverload.kt")
            public void testConstructorVsFunOverload() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ConstructorVsFunOverload.kt");
            }

            @TestMetadata("defaultParameters.kt")
            public void testDefaultParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/defaultParameters.kt");
            }

            @TestMetadata("EmptyArgumentListInLambda.kt")
            public void testEmptyArgumentListInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/EmptyArgumentListInLambda.kt");
            }

            @TestMetadata("ExtFunDifferentReceiver.kt")
            public void testExtFunDifferentReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/ExtFunDifferentReceiver.kt");
            }

            @TestMetadata("FunNoConflictInDifferentPackages.kt")
            public void testFunNoConflictInDifferentPackages() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/FunNoConflictInDifferentPackages.kt");
            }

            @TestMetadata("kt10939.kt")
            public void testKt10939() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt10939.kt");
            }

            @TestMetadata("kt1998.kt")
            public void testKt1998() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt1998.kt");
            }

            @TestMetadata("kt2493.kt")
            public void testKt2493() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt2493.kt");
            }

            @TestMetadata("kt7068.kt")
            public void testKt7068() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt7068.kt");
            }

            @TestMetadata("kt7068_2.kt")
            public void testKt7068_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt7068_2.kt");
            }

            @TestMetadata("kt7440.kt")
            public void testKt7440() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/kt7440.kt");
            }

            @TestMetadata("LocalFunctions.kt")
            public void testLocalFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/LocalFunctions.kt");
            }

            @TestMetadata("onlyPrivateOverloadsDiagnostic.kt")
            public void testOnlyPrivateOverloadsDiagnostic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/onlyPrivateOverloadsDiagnostic.kt");
            }

            @TestMetadata("OverloadFunRegularAndExt.kt")
            public void testOverloadFunRegularAndExt() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/OverloadFunRegularAndExt.kt");
            }

            @TestMetadata("OverloadVarAndFunInClass.kt")
            public void testOverloadVarAndFunInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/OverloadVarAndFunInClass.kt");
            }

            @TestMetadata("SyntheticAndNotSynthetic.kt")
            public void testSyntheticAndNotSynthetic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/SyntheticAndNotSynthetic.kt");
            }

            @TestMetadata("TypeParameterMultipleBounds.kt")
            public void testTypeParameterMultipleBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/TypeParameterMultipleBounds.kt");
            }

            @TestMetadata("UnsubstitutedJavaGenetics.kt")
            public void testUnsubstitutedJavaGenetics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/overload/UnsubstitutedJavaGenetics.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/override")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Override extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("AbstractFunImplemented.kt")
            public void testAbstractFunImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractFunImplemented.kt");
            }

            @TestMetadata("AbstractFunNotImplemented.kt")
            public void testAbstractFunNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractFunNotImplemented.kt");
            }

            @TestMetadata("AbstractValImplemented.kt")
            public void testAbstractValImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractValImplemented.kt");
            }

            @TestMetadata("AbstractValNotImplemented.kt")
            public void testAbstractValNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractValNotImplemented.kt");
            }

            @TestMetadata("AbstractVarImplemented.kt")
            public void testAbstractVarImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractVarImplemented.kt");
            }

            @TestMetadata("AbstractVarNotImplemented.kt")
            public void testAbstractVarNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AbstractVarNotImplemented.kt");
            }

            public void testAllFilesPresentInOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AllPrivateFromSuperTypes.kt")
            public void testAllPrivateFromSuperTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/AllPrivateFromSuperTypes.kt");
            }

            @TestMetadata("ComplexValRedeclaration.kt")
            public void testComplexValRedeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ComplexValRedeclaration.kt");
            }

            @TestMetadata("ConflictingFunctionSignatureFromSuperclass.kt")
            public void testConflictingFunctionSignatureFromSuperclass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ConflictingFunctionSignatureFromSuperclass.kt");
            }

            @TestMetadata("ConflictingPropertySignatureFromSuperclass.kt")
            public void testConflictingPropertySignatureFromSuperclass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ConflictingPropertySignatureFromSuperclass.kt");
            }

            @TestMetadata("DefaultParameterValueInOverride.kt")
            public void testDefaultParameterValueInOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DefaultParameterValueInOverride.kt");
            }

            @TestMetadata("DefaultParameterValues-NoErrorsWhenInheritingFromOneTypeTwice.kt")
            public void testDefaultParameterValues_NoErrorsWhenInheritingFromOneTypeTwice() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DefaultParameterValues-NoErrorsWhenInheritingFromOneTypeTwice.kt");
            }

            @TestMetadata("Delegation.kt")
            public void testDelegation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/Delegation.kt");
            }

            @TestMetadata("DelegationFun.kt")
            public void testDelegationFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DelegationFun.kt");
            }

            @TestMetadata("DelegationVal.kt")
            public void testDelegationVal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DelegationVal.kt");
            }

            @TestMetadata("DelegationVar.kt")
            public void testDelegationVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DelegationVar.kt");
            }

            @TestMetadata("DuplicateMethod.kt")
            public void testDuplicateMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/DuplicateMethod.kt");
            }

            @TestMetadata("EqualityOfIntersectionTypes.kt")
            public void testEqualityOfIntersectionTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/EqualityOfIntersectionTypes.kt");
            }

            @TestMetadata("ExtendFunctionClass.kt")
            public void testExtendFunctionClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ExtendFunctionClass.kt");
            }

            @TestMetadata("fakeEquals.kt")
            public void testFakeEquals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/fakeEquals.kt");
            }

            @TestMetadata("FakeOverrideAbstractAndNonAbstractFun.kt")
            public void testFakeOverrideAbstractAndNonAbstractFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/FakeOverrideAbstractAndNonAbstractFun.kt");
            }

            @TestMetadata("FakeOverrideDifferentDeclarationSignatures.kt")
            public void testFakeOverrideDifferentDeclarationSignatures() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/FakeOverrideDifferentDeclarationSignatures.kt");
            }

            @TestMetadata("FakeOverrideModality1.kt")
            public void testFakeOverrideModality1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/FakeOverrideModality1.kt");
            }

            @TestMetadata("FakeOverrideModality2.kt")
            public void testFakeOverrideModality2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/FakeOverrideModality2.kt");
            }

            @TestMetadata("FakeOverrideModality3.kt")
            public void testFakeOverrideModality3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/FakeOverrideModality3.kt");
            }

            @TestMetadata("Generics.kt")
            public void testGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/Generics.kt");
            }

            @TestMetadata("InvisiblePotentialOverride.kt")
            public void testInvisiblePotentialOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/InvisiblePotentialOverride.kt");
            }

            @TestMetadata("kt12358.kt")
            public void testKt12358() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt12358.kt");
            }

            @TestMetadata("kt12467.kt")
            public void testKt12467() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt12467.kt");
            }

            @TestMetadata("kt12482.kt")
            public void testKt12482() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt12482.kt");
            }

            @TestMetadata("kt1862.kt")
            public void testKt1862() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt1862.kt");
            }

            @TestMetadata("kt2052.kt")
            public void testKt2052() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt2052.kt");
            }

            @TestMetadata("kt2491.kt")
            public void testKt2491() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt2491.kt");
            }

            @TestMetadata("kt4763.kt")
            public void testKt4763() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt4763.kt");
            }

            @TestMetadata("kt4763property.kt")
            public void testKt4763property() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt4763property.kt");
            }

            @TestMetadata("kt4785.kt")
            public void testKt4785() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt4785.kt");
            }

            @TestMetadata("kt6014.kt")
            public void testKt6014() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt6014.kt");
            }

            @TestMetadata("kt880.kt")
            public void testKt880() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt880.kt");
            }

            @TestMetadata("kt8990.kt")
            public void testKt8990() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/kt8990.kt");
            }

            @TestMetadata("MissingDelegate.kt")
            public void testMissingDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/MissingDelegate.kt");
            }

            @TestMetadata("MultipleDefaultParametersInSupertypes.kt")
            public void testMultipleDefaultParametersInSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/MultipleDefaultParametersInSupertypes.kt");
            }

            @TestMetadata("MultipleDefaultParametersInSupertypesNoOverride.kt")
            public void testMultipleDefaultParametersInSupertypesNoOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/MultipleDefaultParametersInSupertypesNoOverride.kt");
            }

            @TestMetadata("MultipleDefaultsAndNamesInSupertypes.kt")
            public void testMultipleDefaultsAndNamesInSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/MultipleDefaultsAndNamesInSupertypes.kt");
            }

            @TestMetadata("MultipleDefaultsInSupertypesNoExplicitOverride.kt")
            public void testMultipleDefaultsInSupertypesNoExplicitOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/MultipleDefaultsInSupertypesNoExplicitOverride.kt");
            }

            @TestMetadata("NonGenerics.kt")
            public void testNonGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/NonGenerics.kt");
            }

            @TestMetadata("ObjectDelegationManyImpl.kt")
            public void testObjectDelegationManyImpl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ObjectDelegationManyImpl.kt");
            }

            @TestMetadata("overrideMemberFromFinalClass.kt")
            public void testOverrideMemberFromFinalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/overrideMemberFromFinalClass.kt");
            }

            @TestMetadata("OverrideWithErrors.kt")
            public void testOverrideWithErrors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/OverrideWithErrors.kt");
            }

            @TestMetadata("OverridingFinalMember.kt")
            public void testOverridingFinalMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/OverridingFinalMember.kt");
            }

            @TestMetadata("ParameterDefaultValues-DefaultValueFromOnlyOneSupertype.kt")
            public void testParameterDefaultValues_DefaultValueFromOnlyOneSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ParameterDefaultValues-DefaultValueFromOnlyOneSupertype.kt");
            }

            @TestMetadata("ParentInheritsManyImplementations.kt")
            public void testParentInheritsManyImplementations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ParentInheritsManyImplementations.kt");
            }

            @TestMetadata("PropertyInConstructor.kt")
            public void testPropertyInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/PropertyInConstructor.kt");
            }

            @TestMetadata("ProtectedAndPrivateFromSupertypes.kt")
            public void testProtectedAndPrivateFromSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ProtectedAndPrivateFromSupertypes.kt");
            }

            @TestMetadata("SuspiciousCase1.kt")
            public void testSuspiciousCase1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/SuspiciousCase1.kt");
            }

            @TestMetadata("ToAbstractMembersFromSuper-kt1996.kt")
            public void testToAbstractMembersFromSuper_kt1996() throws Exception {
                runTest("compiler/testData/diagnostics/tests/override/ToAbstractMembersFromSuper-kt1996.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClashesOnInheritance extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClashesOnInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/clashesOnInheritance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("covariantOverrides.kt")
                public void testCovariantOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/covariantOverrides.kt");
                }

                @TestMetadata("flexibleReturnType.kt")
                public void testFlexibleReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnType.kt");
                }

                @TestMetadata("flexibleReturnTypeIn.kt")
                public void testFlexibleReturnTypeIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnTypeIn.kt");
                }

                @TestMetadata("flexibleReturnTypeList.kt")
                public void testFlexibleReturnTypeList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnTypeList.kt");
                }

                @TestMetadata("genericWithUpperBound.kt")
                public void testGenericWithUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/genericWithUpperBound.kt");
                }

                @TestMetadata("kt13355.kt")
                public void testKt13355() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/kt13355.kt");
                }

                @TestMetadata("kt13355viaJava.kt")
                public void testKt13355viaJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/kt13355viaJava.kt");
                }

                @TestMetadata("kt9550.kt")
                public void testKt9550() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/kt9550.kt");
                }

                @TestMetadata("returnTypeMismatch.kt")
                public void testReturnTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/returnTypeMismatch.kt");
                }

                @TestMetadata("unrelatedInherited.kt")
                public void testUnrelatedInherited() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/unrelatedInherited.kt");
                }

                @TestMetadata("valTypeMismatch.kt")
                public void testValTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/valTypeMismatch.kt");
                }

                @TestMetadata("varTypeMismatch.kt")
                public void testVarTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/clashesOnInheritance/varTypeMismatch.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/parameterNames")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ParameterNames extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInParameterNames() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/parameterNames"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("changeOnOverrideDiagnostic.kt")
                public void testChangeOnOverrideDiagnostic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/changeOnOverrideDiagnostic.kt");
                }

                @TestMetadata("differentNamesInSupertypesDiagnostic.kt")
                public void testDifferentNamesInSupertypesDiagnostic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/differentNamesInSupertypesDiagnostic.kt");
                }

                @TestMetadata("invokeInFunctionClass.kt")
                public void testInvokeInFunctionClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/invokeInFunctionClass.kt");
                }

                @TestMetadata("jjkHierarchy.kt")
                public void testJjkHierarchy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/jjkHierarchy.kt");
                }

                @TestMetadata("kjkHierarchy.kt")
                public void testKjkHierarchy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/kjkHierarchy.kt");
                }

                @TestMetadata("kjkWithSeveralSupers.kt")
                public void testKjkWithSeveralSupers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/kjkWithSeveralSupers.kt");
                }

                @TestMetadata("kotlinInheritsBothJavaAndKotlin.kt")
                public void testKotlinInheritsBothJavaAndKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/kotlinInheritsBothJavaAndKotlin.kt");
                }

                @TestMetadata("kotlinInheritsJava.kt")
                public void testKotlinInheritsJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/parameterNames/kotlinInheritsJava.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/typeParameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeParameters extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTypeParameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/typeParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classAndTwoInterfaceBounds.kt")
                public void testClassAndTwoInterfaceBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/typeParameters/classAndTwoInterfaceBounds.kt");
                }

                @TestMetadata("differentSetsOfBounds.kt")
                public void testDifferentSetsOfBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/typeParameters/differentSetsOfBounds.kt");
                }

                @TestMetadata("kt9850.kt")
                public void testKt9850() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/typeParameters/kt9850.kt");
                }

                @TestMetadata("simpleVisitorTwoAccepts.kt")
                public void testSimpleVisitorTwoAccepts() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/override/typeParameters/simpleVisitorTwoAccepts.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/parenthesizedTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParenthesizedTypes extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParenthesizedTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/parenthesizedTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationsOnNullableParenthesizedTypes.kt")
            public void testAnnotationsOnNullableParenthesizedTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/parenthesizedTypes/annotationsOnNullableParenthesizedTypes.kt");
            }

            @TestMetadata("annotationsOnParenthesizedTypes.kt")
            public void testAnnotationsOnParenthesizedTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/parenthesizedTypes/annotationsOnParenthesizedTypes.kt");
            }

            @TestMetadata("splitModifierList.kt")
            public void testSplitModifierList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/parenthesizedTypes/splitModifierList.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/platformTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PlatformTypes extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPlatformTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegateByComplexInheritance.kt")
            public void testDelegateByComplexInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/delegateByComplexInheritance.kt");
            }

            @TestMetadata("dereference.kt")
            public void testDereference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/dereference.kt");
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/elvis.kt");
            }

            @TestMetadata("explicitFlexibleNoPackage.kt")
            public void testExplicitFlexibleNoPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/explicitFlexibleNoPackage.kt");
            }

            @TestMetadata("explicitFlexibleWithPackage.kt")
            public void testExplicitFlexibleWithPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/explicitFlexibleWithPackage.kt");
            }

            @TestMetadata("getParentOfType.kt")
            public void testGetParentOfType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/getParentOfType.kt");
            }

            @TestMetadata("inference.kt")
            public void testInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/inference.kt");
            }

            @TestMetadata("intVsIntegerAmbiguity.kt")
            public void testIntVsIntegerAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/intVsIntegerAmbiguity.kt");
            }

            @TestMetadata("javaEmptyList.kt")
            public void testJavaEmptyList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/javaEmptyList.kt");
            }

            @TestMetadata("methodTypeParameterDefaultBound.kt")
            public void testMethodTypeParameterDefaultBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/methodTypeParameterDefaultBound.kt");
            }

            @TestMetadata("noAnnotationInClassPath.kt")
            public void testNoAnnotationInClassPath() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/noAnnotationInClassPath.kt");
            }

            @TestMetadata("nullableTypeArgument.kt")
            public void testNullableTypeArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/nullableTypeArgument.kt");
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/override.kt");
            }

            @TestMetadata("rawOverrides.kt")
            public void testRawOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/rawOverrides.kt");
            }

            @TestMetadata("rawSamOverrides.kt")
            public void testRawSamOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/rawSamOverrides.kt");
            }

            @TestMetadata("safeCall.kt")
            public void testSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/safeCall.kt");
            }

            @TestMetadata("samAdapterInConstructor.kt")
            public void testSamAdapterInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/samAdapterInConstructor.kt");
            }

            @TestMetadata("samConstructor.kt")
            public void testSamConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/samConstructor.kt");
            }

            @TestMetadata("supertypeArgumentsExplicit.kt")
            public void testSupertypeArgumentsExplicit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/supertypeArgumentsExplicit.kt");
            }

            @TestMetadata("supertypeTypeArguments.kt")
            public void testSupertypeTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/platformTypes/supertypeTypeArguments.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CommonSupertype extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCommonSupertype() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/commonSupertype"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("collectionOrNull.kt")
                public void testCollectionOrNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/collectionOrNull.kt");
                }

                @TestMetadata("inferenceWithBound.kt")
                public void testInferenceWithBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/inferenceWithBound.kt");
                }

                @TestMetadata("mixedElvis.kt")
                public void testMixedElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/mixedElvis.kt");
                }

                @TestMetadata("mixedIf.kt")
                public void testMixedIf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/mixedIf.kt");
                }

                @TestMetadata("recursiveGeneric.kt")
                public void testRecursiveGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/recursiveGeneric.kt");
                }

                @TestMetadata("stringOrNull.kt")
                public void testStringOrNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/stringOrNull.kt");
                }

                @TestMetadata("typeOfElvis.kt")
                public void testTypeOfElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/typeOfElvis.kt");
                }

                @TestMetadata("withNothing.kt")
                public void testWithNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/withNothing.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericVarianceViolation extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInGenericVarianceViolation() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("listSuperType.kt")
                public void testListSuperType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/listSuperType.kt");
                }

                @TestMetadata("rawTypes.kt")
                public void testRawTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/rawTypes.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/simple.kt");
                }

                @TestMetadata("smartCast.kt")
                public void testSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/smartCast.kt");
                }

                @TestMetadata("strangeVariance.kt")
                public void testStrangeVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/strangeVariance.kt");
                }

                @TestMetadata("userDefinedOut.kt")
                public void testUserDefinedOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/userDefinedOut.kt");
                }

                @TestMetadata("valueFromJava.kt")
                public void testValueFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/valueFromJava.kt");
                }

                @TestMetadata("wildcards.kt")
                public void testWildcards() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/wildcards.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/intersection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Intersection extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInIntersection() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/intersection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("map.kt")
                public void testMap() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/intersection/map.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodCall extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMethodCall() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/methodCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("entrySet.kt")
                public void testEntrySet() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/entrySet.kt");
                }

                @TestMetadata("genericsAndArrays.kt")
                public void testGenericsAndArrays() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/genericsAndArrays.kt");
                }

                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/int.kt");
                }

                @TestMetadata("intArray.kt")
                public void testIntArray() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/intArray.kt");
                }

                @TestMetadata("javaCollectionToKotlin.kt")
                public void testJavaCollectionToKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaCollectionToKotlin.kt");
                }

                @TestMetadata("javaToJava.kt")
                public void testJavaToJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaToJava.kt");
                }

                @TestMetadata("javaToKotlin.kt")
                public void testJavaToKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaToKotlin.kt");
                }

                @TestMetadata("kotlinCollectionToJava.kt")
                public void testKotlinCollectionToJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/kotlinCollectionToJava.kt");
                }

                @TestMetadata("kt27565.kt")
                public void testKt27565() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/kt27565.kt");
                }

                @TestMetadata("list.kt")
                public void testList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/list.kt");
                }

                @TestMetadata("multipleExactBounds.kt")
                public void testMultipleExactBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/multipleExactBounds.kt");
                }

                @TestMetadata("multipleExactBoundsNullable.kt")
                public void testMultipleExactBoundsNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/multipleExactBoundsNullable.kt");
                }

                @TestMetadata("objectArray.kt")
                public void testObjectArray() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/objectArray.kt");
                }

                @TestMetadata("overloadingForSubclass.kt")
                public void testOverloadingForSubclass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/overloadingForSubclass.kt");
                }

                @TestMetadata("sam.kt")
                public void testSam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/sam.kt");
                }

                @TestMetadata("singleton.kt")
                public void testSingleton() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/singleton.kt");
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/string.kt");
                }

                @TestMetadata("visitor.kt")
                public void testVisitor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/methodCall/visitor.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NotNullTypeParameter extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNotNullTypeParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enhancementFromAnnotation.kt")
                public void testEnhancementFromAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/enhancementFromAnnotation.kt");
                }

                @TestMetadata("enhancementFromKotlin.kt")
                public void testEnhancementFromKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/enhancementFromKotlin.kt");
                }

                @TestMetadata("methodTypeParameter.kt")
                public void testMethodTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/methodTypeParameter.kt");
                }

                @TestMetadata("noInheritanceReturnType.kt")
                public void testNoInheritanceReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/noInheritanceReturnType.kt");
                }

                @TestMetadata("noInheritanceValueParameter.kt")
                public void testNoInheritanceValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/noInheritanceValueParameter.kt");
                }

                @TestMetadata("onTypeProjection.kt")
                public void testOnTypeProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/onTypeProjection.kt");
                }

                @TestMetadata("substitutionInSuperType.kt")
                public void testSubstitutionInSuperType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/substitutionInSuperType.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NullabilityWarnings extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNullabilityWarnings() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arithmetic.kt")
                public void testArithmetic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/arithmetic.kt");
                }

                @TestMetadata("array.kt")
                public void testArray() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/array.kt");
                }

                @TestMetadata("assignToVar.kt")
                public void testAssignToVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/assignToVar.kt");
                }

                @TestMetadata("conditions.kt")
                public void testConditions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/conditions.kt");
                }

                @TestMetadata("dataFlowInfo.kt")
                public void testDataFlowInfo() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/dataFlowInfo.kt");
                }

                @TestMetadata("defaultParameters.kt")
                public void testDefaultParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/defaultParameters.kt");
                }

                @TestMetadata("delegatedProperties.kt")
                public void testDelegatedProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/delegatedProperties.kt");
                }

                @TestMetadata("delegation.kt")
                public void testDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/delegation.kt");
                }

                @TestMetadata("derefenceExtension.kt")
                public void testDerefenceExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/derefenceExtension.kt");
                }

                @TestMetadata("derefenceMember.kt")
                public void testDerefenceMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/derefenceMember.kt");
                }

                @TestMetadata("elvis.kt")
                public void testElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/elvis.kt");
                }

                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/expectedType.kt");
                }

                @TestMetadata("for.kt")
                public void testFor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/for.kt");
                }

                @TestMetadata("functionArguments.kt")
                public void testFunctionArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/functionArguments.kt");
                }

                @TestMetadata("inferenceInConditionals.kt")
                public void testInferenceInConditionals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/inferenceInConditionals.kt");
                }

                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/invoke.kt");
                }

                @TestMetadata("kt6829.kt")
                public void testKt6829() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/kt6829.kt");
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/multiDeclaration.kt");
                }

                @TestMetadata("noWarningOnDoubleElvis.kt")
                public void testNoWarningOnDoubleElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/noWarningOnDoubleElvis.kt");
                }

                @TestMetadata("notNullAfterSafeCall.kt")
                public void testNotNullAfterSafeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAfterSafeCall.kt");
                }

                @TestMetadata("notNullAssertion.kt")
                public void testNotNullAssertion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAssertion.kt");
                }

                @TestMetadata("notNullAssertionInCall.kt")
                public void testNotNullAssertionInCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAssertionInCall.kt");
                }

                @TestMetadata("notNullTypeMarkedWithNullableAnnotation.kt")
                public void testNotNullTypeMarkedWithNullableAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullTypeMarkedWithNullableAnnotation.kt");
                }

                @TestMetadata("passToJava.kt")
                public void testPassToJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/passToJava.kt");
                }

                @TestMetadata("primitiveArray.kt")
                public void testPrimitiveArray() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/primitiveArray.kt");
                }

                @TestMetadata("safeCall.kt")
                public void testSafeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/safeCall.kt");
                }

                @TestMetadata("senselessComparisonEquals.kt")
                public void testSenselessComparisonEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/senselessComparisonEquals.kt");
                }

                @TestMetadata("senselessComparisonIdentityEquals.kt")
                public void testSenselessComparisonIdentityEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/senselessComparisonIdentityEquals.kt");
                }

                @TestMetadata("throw.kt")
                public void testThrow() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/throw.kt");
                }

                @TestMetadata("uselessElvisInCall.kt")
                public void testUselessElvisInCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/uselessElvisInCall.kt");
                }

                @TestMetadata("uselessElvisRightIsNull.kt")
                public void testUselessElvisRightIsNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/uselessElvisRightIsNull.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class RawTypes extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRawTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/rawTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrays.kt")
                public void testArrays() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/arrays.kt");
                }

                @TestMetadata("errorType.kt")
                public void testErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/errorType.kt");
                }

                @TestMetadata("genericInnerClass.kt")
                public void testGenericInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/genericInnerClass.kt");
                }

                @TestMetadata("interClassesRecursion.kt")
                public void testInterClassesRecursion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/interClassesRecursion.kt");
                }

                @TestMetadata("nonGenericRawMember.kt")
                public void testNonGenericRawMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/nonGenericRawMember.kt");
                }

                @TestMetadata("nonTrivialErasure.kt")
                public void testNonTrivialErasure() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/nonTrivialErasure.kt");
                }

                @TestMetadata("rawEnhancment.kt")
                public void testRawEnhancment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawEnhancment.kt");
                }

                @TestMetadata("rawSupertype.kt")
                public void testRawSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawSupertype.kt");
                }

                @TestMetadata("rawSupertypeOverride.kt")
                public void testRawSupertypeOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawSupertypeOverride.kt");
                }

                @TestMetadata("rawTypeInUpperBound.kt")
                public void testRawTypeInUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawTypeInUpperBound.kt");
                }

                @TestMetadata("rawWithInProjection.kt")
                public void testRawWithInProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawWithInProjection.kt");
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/recursiveBound.kt");
                }

                @TestMetadata("samRaw.kt")
                public void testSamRaw() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/samRaw.kt");
                }

                @TestMetadata("saveRawCapabilitiesAfterSubtitution.kt")
                public void testSaveRawCapabilitiesAfterSubtitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/saveRawCapabilitiesAfterSubtitution.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/simple.kt");
                }

                @TestMetadata("starProjectionToRaw.kt")
                public void testStarProjectionToRaw() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/starProjectionToRaw.kt");
                }

                @TestMetadata("typeEnhancement.kt")
                public void testTypeEnhancement() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/rawTypes/typeEnhancement.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeEnhancement extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTypeEnhancement() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("overriddenExtensions.kt")
                public void testOverriddenExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/overriddenExtensions.kt");
                }

                @TestMetadata("saveAnnotationAfterSubstitution.kt")
                public void testSaveAnnotationAfterSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/saveAnnotationAfterSubstitution.kt");
                }

                @TestMetadata("supertypeDifferentParameterNullability.kt")
                public void testSupertypeDifferentParameterNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/supertypeDifferentParameterNullability.kt");
                }

                @TestMetadata("supertypeDifferentReturnNullability.kt")
                public void testSupertypeDifferentReturnNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/supertypeDifferentReturnNullability.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/privateInFile")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrivateInFile extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPrivateInFile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/privateInFile"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt12429.kt")
            public void testKt12429() throws Exception {
                runTest("compiler/testData/diagnostics/tests/privateInFile/kt12429.kt");
            }

            @TestMetadata("topLevelAnnotationCall.kt")
            public void testTopLevelAnnotationCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/privateInFile/topLevelAnnotationCall.kt");
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/privateInFile/visibility.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/properties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Properties extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperties() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("extensionPropertyMustHaveAccessorsOrBeAbstract.kt")
            public void testExtensionPropertyMustHaveAccessorsOrBeAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/properties/extensionPropertyMustHaveAccessorsOrBeAbstract.kt");
            }

            @TestMetadata("lateinitOnTopLevel.kt")
            public void testLateinitOnTopLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/properties/lateinitOnTopLevel.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InferenceFromGetters extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInferenceFromGetters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/properties/inferenceFromGetters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("blockBodyGetter.kt")
                public void testBlockBodyGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/blockBodyGetter.kt");
                }

                @TestMetadata("cantBeInferred.kt")
                public void testCantBeInferred() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/cantBeInferred.kt");
                }

                @TestMetadata("explicitGetterType.kt")
                public void testExplicitGetterType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/explicitGetterType.kt");
                }

                @TestMetadata("members.kt")
                public void testMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/members.kt");
                }

                @TestMetadata("nullAsNothing.kt")
                public void testNullAsNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/nullAsNothing.kt");
                }

                @TestMetadata("objectExpression.kt")
                public void testObjectExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/objectExpression.kt");
                }

                @TestMetadata("overrides.kt")
                public void testOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/overrides.kt");
                }

                @TestMetadata("primaryConstructorParameter.kt")
                public void testPrimaryConstructorParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/primaryConstructorParameter.kt");
                }

                @TestMetadata("recursiveGetter.kt")
                public void testRecursiveGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/recursiveGetter.kt");
                }

                @TestMetadata("topLevel.kt")
                public void testTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/topLevel.kt");
                }

                @TestMetadata("unsupportedInferenceFromGetters.kt")
                public void testUnsupportedInferenceFromGetters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/unsupportedInferenceFromGetters.kt");
                }

                @TestMetadata("vars.kt")
                public void testVars() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/vars.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/qualifiedExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class QualifiedExpression extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInQualifiedExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/qualifiedExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("calleeExpressionAsCallExpression.kt")
            public void testCalleeExpressionAsCallExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/calleeExpressionAsCallExpression.kt");
            }

            @TestMetadata("GenericClassVsPackage.kt")
            public void testGenericClassVsPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/GenericClassVsPackage.kt");
            }

            @TestMetadata("JavaQualifier.kt")
            public void testJavaQualifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/JavaQualifier.kt");
            }

            @TestMetadata("nullCalleeExpression.kt")
            public void testNullCalleeExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/nullCalleeExpression.kt");
            }

            @TestMetadata("PackageVsClass.kt")
            public void testPackageVsClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsClass.kt");
            }

            @TestMetadata("PackageVsClass2.kt")
            public void testPackageVsClass2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsClass2.kt");
            }

            @TestMetadata("PackageVsRootClass.kt")
            public void testPackageVsRootClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsRootClass.kt");
            }

            @TestMetadata("TypeWithError.kt")
            public void testTypeWithError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/TypeWithError.kt");
            }

            @TestMetadata("visibleClassVsQualifiedClass.kt")
            public void testVisibleClassVsQualifiedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/qualifiedExpression/visibleClassVsQualifiedClass.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/reassignment")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reassignment extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("afterfor.kt")
            public void testAfterfor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/afterfor.kt");
            }

            public void testAllFilesPresentInReassignment() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/reassignment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dowhile.kt")
            public void testDowhile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/dowhile.kt");
            }

            @TestMetadata("else.kt")
            public void testElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/else.kt");
            }

            @TestMetadata("foronly.kt")
            public void testForonly() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/foronly.kt");
            }

            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/if.kt");
            }

            @TestMetadata("ifelse.kt")
            public void testIfelse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/ifelse.kt");
            }

            @TestMetadata("noifelse.kt")
            public void testNoifelse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/noifelse.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/when.kt");
            }

            @TestMetadata("whiletrue.kt")
            public void testWhiletrue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reassignment/whiletrue.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/recovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recovery extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("absentLeftHandSide.kt")
            public void testAbsentLeftHandSide() throws Exception {
                runTest("compiler/testData/diagnostics/tests/recovery/absentLeftHandSide.kt");
            }

            public void testAllFilesPresentInRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/recovery"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("emptyTypeArgs.kt")
            public void testEmptyTypeArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/recovery/emptyTypeArgs.kt");
            }

            @TestMetadata("namelessInJava.kt")
            public void testNamelessInJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/recovery/namelessInJava.kt");
            }

            @TestMetadata("namelessMembers.kt")
            public void testNamelessMembers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/recovery/namelessMembers.kt");
            }

            @TestMetadata("namelessToplevelDeclarations.kt")
            public void testNamelessToplevelDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/recovery/namelessToplevelDeclarations.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/redeclarations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Redeclarations extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRedeclarations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/redeclarations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassRedeclarationInDifferentFiles.kt")
            public void testClassRedeclarationInDifferentFiles() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/ClassRedeclarationInDifferentFiles.kt");
            }

            @TestMetadata("ConflictingExtensionProperties.kt")
            public void testConflictingExtensionProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/ConflictingExtensionProperties.kt");
            }

            @TestMetadata("DuplicateParameterNamesInFunctionType.kt")
            public void testDuplicateParameterNamesInFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/DuplicateParameterNamesInFunctionType.kt");
            }

            @TestMetadata("EnumName.kt")
            public void testEnumName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/EnumName.kt");
            }

            @TestMetadata("FunVsCtorInDifferentFiles.kt")
            public void testFunVsCtorInDifferentFiles() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/FunVsCtorInDifferentFiles.kt");
            }

            @TestMetadata("interfaceTypeParameters.kt")
            public void testInterfaceTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/interfaceTypeParameters.kt");
            }

            @TestMetadata("kt2418.kt")
            public void testKt2418() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/kt2418.kt");
            }

            @TestMetadata("kt2438.kt")
            public void testKt2438() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/kt2438.kt");
            }

            @TestMetadata("kt470.kt")
            public void testKt470() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/kt470.kt");
            }

            @TestMetadata("MultiFilePackageRedeclaration.kt")
            public void testMultiFilePackageRedeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/MultiFilePackageRedeclaration.kt");
            }

            @TestMetadata("NoRedeclarationForClassesInDefaultObject.kt")
            public void testNoRedeclarationForClassesInDefaultObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/NoRedeclarationForClassesInDefaultObject.kt");
            }

            @TestMetadata("NoRedeclarationForEnumEntriesAndDefaultObjectMembers.kt")
            public void testNoRedeclarationForEnumEntriesAndDefaultObjectMembers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/NoRedeclarationForEnumEntriesAndDefaultObjectMembers.kt");
            }

            @TestMetadata("PropertyAndFunInClass.kt")
            public void testPropertyAndFunInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/PropertyAndFunInClass.kt");
            }

            @TestMetadata("PropertyAndInnerClass.kt")
            public void testPropertyAndInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/PropertyAndInnerClass.kt");
            }

            @TestMetadata("RedeclarationInDefaultObject.kt")
            public void testRedeclarationInDefaultObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationInDefaultObject.kt");
            }

            @TestMetadata("RedeclarationInMultiFile.kt")
            public void testRedeclarationInMultiFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationInMultiFile.kt");
            }

            @TestMetadata("RedeclarationMainInFile.kt")
            public void testRedeclarationMainInFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationMainInFile.kt");
            }

            @TestMetadata("RedeclarationMainInMultiFile.kt")
            public void testRedeclarationMainInMultiFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationMainInMultiFile.kt");
            }

            @TestMetadata("RedeclarationParameterlessMain.kt")
            public void testRedeclarationParameterlessMain() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationParameterlessMain.kt");
            }

            @TestMetadata("RedeclarationParameterlessMainInvalid.kt")
            public void testRedeclarationParameterlessMainInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationParameterlessMainInvalid.kt");
            }

            @TestMetadata("RedeclarationParameterlessMain_before.kt")
            public void testRedeclarationParameterlessMain_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationParameterlessMain_before.kt");
            }

            @TestMetadata("RedeclarationSuspendMainInMultiFile.kt")
            public void testRedeclarationSuspendMainInMultiFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationSuspendMainInMultiFile.kt");
            }

            @TestMetadata("RedeclarationSuspendMainInMultiFile_before.kt")
            public void testRedeclarationSuspendMainInMultiFile_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationSuspendMainInMultiFile_before.kt");
            }

            @TestMetadata("Redeclarations.kt")
            public void testRedeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/Redeclarations.kt");
            }

            @TestMetadata("RedeclarationsInObjects.kt")
            public void testRedeclarationsInObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclarationsInObjects.kt");
            }

            @TestMetadata("RedeclaredTypeParameters.kt")
            public void testRedeclaredTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclaredTypeParameters.kt");
            }

            @TestMetadata("RedeclaringPrivateToFile.kt")
            public void testRedeclaringPrivateToFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/RedeclaringPrivateToFile.kt");
            }

            @TestMetadata("SingletonAndFunctionSameName.kt")
            public void testSingletonAndFunctionSameName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/SingletonAndFunctionSameName.kt");
            }

            @TestMetadata("TopLevelPropertyVsClassifier.kt")
            public void testTopLevelPropertyVsClassifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/TopLevelPropertyVsClassifier.kt");
            }

            @TestMetadata("TypeAliasCtorVsFun.kt")
            public void testTypeAliasCtorVsFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/TypeAliasCtorVsFun.kt");
            }

            @TestMetadata("TypeAliasVsClass.kt")
            public void testTypeAliasVsClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/TypeAliasVsClass.kt");
            }

            @TestMetadata("TypeAliasVsProperty.kt")
            public void testTypeAliasVsProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/TypeAliasVsProperty.kt");
            }

            @TestMetadata("typeParameterWithTwoBounds.kt")
            public void testTypeParameterWithTwoBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/redeclarations/typeParameterWithTwoBounds.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ShadowedExtension extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInShadowedExtension() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("extensionFunShadowedByInnerClassConstructor.kt")
                public void testExtensionFunShadowedByInnerClassConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionFunShadowedByInnerClassConstructor.kt");
                }

                @TestMetadata("extensionFunShadowedByMemberFun.kt")
                public void testExtensionFunShadowedByMemberFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionFunShadowedByMemberFun.kt");
                }

                @TestMetadata("extensionFunShadowedByMemberPropertyWithInvoke.kt")
                public void testExtensionFunShadowedByMemberPropertyWithInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionFunShadowedByMemberPropertyWithInvoke.kt");
                }

                @TestMetadata("extensionFunShadowedBySynthesizedMemberFun.kt")
                public void testExtensionFunShadowedBySynthesizedMemberFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionFunShadowedBySynthesizedMemberFun.kt");
                }

                @TestMetadata("extensionFunVsMemberExtensionFun.kt")
                public void testExtensionFunVsMemberExtensionFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionFunVsMemberExtensionFun.kt");
                }

                @TestMetadata("extensionOnErrorType.kt")
                public void testExtensionOnErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionOnErrorType.kt");
                }

                @TestMetadata("extensionOnNullableReceiver.kt")
                public void testExtensionOnNullableReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionOnNullableReceiver.kt");
                }

                @TestMetadata("extensionPropertyShadowedByMemberProperty.kt")
                public void testExtensionPropertyShadowedByMemberProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionPropertyShadowedByMemberProperty.kt");
                }

                @TestMetadata("extensionShadowedByDelegatedMember.kt")
                public void testExtensionShadowedByDelegatedMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionShadowedByDelegatedMember.kt");
                }

                @TestMetadata("extensionVsNonPublicMember.kt")
                public void testExtensionVsNonPublicMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/extensionVsNonPublicMember.kt");
                }

                @TestMetadata("infixExtensionVsNonInfixMember.kt")
                public void testInfixExtensionVsNonInfixMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/infixExtensionVsNonInfixMember.kt");
                }

                @TestMetadata("localExtensionShadowedByMember.kt")
                public void testLocalExtensionShadowedByMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/localExtensionShadowedByMember.kt");
                }

                @TestMetadata("memberExtensionShadowedByMember.kt")
                public void testMemberExtensionShadowedByMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/memberExtensionShadowedByMember.kt");
                }

                @TestMetadata("operatorExtensionVsNonOperatorMember.kt")
                public void testOperatorExtensionVsNonOperatorMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/redeclarations/shadowedExtension/operatorExtensionVsNonOperatorMember.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/reflection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reflection extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReflection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noReflectionInClassPath.kt")
            public void testNoReflectionInClassPath() throws Exception {
                runTest("compiler/testData/diagnostics/tests/reflection/noReflectionInClassPath.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRegressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbiguityOnLazyTypeComputation.kt")
            public void testAmbiguityOnLazyTypeComputation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/AmbiguityOnLazyTypeComputation.kt");
            }

            @TestMetadata("AssignmentsUnderOperators.kt")
            public void testAssignmentsUnderOperators() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/AssignmentsUnderOperators.kt");
            }

            @TestMetadata("CoercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/CoercionToUnit.kt");
            }

            @TestMetadata("correctResultSubstitutorForErrorCandidate.kt")
            public void testCorrectResultSubstitutorForErrorCandidate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/correctResultSubstitutorForErrorCandidate.kt");
            }

            @TestMetadata("delegationWithReceiver.kt")
            public void testDelegationWithReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/delegationWithReceiver.kt");
            }

            @TestMetadata("DoubleDefine.kt")
            public void testDoubleDefine() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/DoubleDefine.kt");
            }

            @TestMetadata("ea40964.kt")
            public void testEa40964() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea40964.kt");
            }

            @TestMetadata("ea43298.kt")
            public void testEa43298() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea43298.kt");
            }

            @TestMetadata("ea53340.kt")
            public void testEa53340() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea53340.kt");
            }

            @TestMetadata("ea65509.kt")
            public void testEa65509() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea65509.kt");
            }

            @TestMetadata("ea66984.kt")
            public void testEa66984() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea66984.kt");
            }

            @TestMetadata("ea69735.kt")
            public void testEa69735() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea69735.kt");
            }

            @TestMetadata("ea72837.kt")
            public void testEa72837() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea72837.kt");
            }

            @TestMetadata("ea76264.kt")
            public void testEa76264() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ea76264.kt");
            }

            @TestMetadata("ErrorsOnIbjectExpressionsAsParameters.kt")
            public void testErrorsOnIbjectExpressionsAsParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/ErrorsOnIbjectExpressionsAsParameters.kt");
            }

            @TestMetadata("intchar.kt")
            public void testIntchar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/intchar.kt");
            }

            @TestMetadata("itselfAsUpperBound.kt")
            public void testItselfAsUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBound.kt");
            }

            @TestMetadata("itselfAsUpperBoundInClass.kt")
            public void testItselfAsUpperBoundInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundInClass.kt");
            }

            @TestMetadata("itselfAsUpperBoundInClassNotNull.kt")
            public void testItselfAsUpperBoundInClassNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundInClassNotNull.kt");
            }

            @TestMetadata("itselfAsUpperBoundLocal.kt")
            public void testItselfAsUpperBoundLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundLocal.kt");
            }

            @TestMetadata("itselfAsUpperBoundMember.kt")
            public void testItselfAsUpperBoundMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundMember.kt");
            }

            @TestMetadata("itselfAsUpperBoundNotNull.kt")
            public void testItselfAsUpperBoundNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundNotNull.kt");
            }

            @TestMetadata("Jet11.kt")
            public void testJet11() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet11.kt");
            }

            @TestMetadata("Jet121.kt")
            public void testJet121() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet121.kt");
            }

            @TestMetadata("Jet124.kt")
            public void testJet124() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet124.kt");
            }

            @TestMetadata("Jet169.kt")
            public void testJet169() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet169.kt");
            }

            @TestMetadata("Jet17.kt")
            public void testJet17() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet17.kt");
            }

            @TestMetadata("Jet183.kt")
            public void testJet183() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet183.kt");
            }

            @TestMetadata("Jet183-1.kt")
            public void testJet183_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet183-1.kt");
            }

            @TestMetadata("Jet53.kt")
            public void testJet53() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet53.kt");
            }

            @TestMetadata("Jet67.kt")
            public void testJet67() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet67.kt");
            }

            @TestMetadata("Jet68.kt")
            public void testJet68() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet68.kt");
            }

            @TestMetadata("Jet69.kt")
            public void testJet69() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet69.kt");
            }

            @TestMetadata("Jet72.kt")
            public void testJet72() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet72.kt");
            }

            @TestMetadata("Jet81.kt")
            public void testJet81() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/Jet81.kt");
            }

            @TestMetadata("kt10243.kt")
            public void testKt10243() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt10243.kt");
            }

            @TestMetadata("kt10243a.kt")
            public void testKt10243a() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt10243a.kt");
            }

            @TestMetadata("kt10633.kt")
            public void testKt10633() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt10633.kt");
            }

            @TestMetadata("kt10824.kt")
            public void testKt10824() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt10824.kt");
            }

            @TestMetadata("kt10843.kt")
            public void testKt10843() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt10843.kt");
            }

            @TestMetadata("kt127.kt")
            public void testKt127() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt127.kt");
            }

            @TestMetadata("kt128.kt")
            public void testKt128() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt128.kt");
            }

            @TestMetadata("kt13685.kt")
            public void testKt13685() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt13685.kt");
            }

            @TestMetadata("kt13954.kt")
            public void testKt13954() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt13954.kt");
            }

            @TestMetadata("kt14740.kt")
            public void testKt14740() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt14740.kt");
            }

            @TestMetadata("kt1489_1728.kt")
            public void testKt1489_1728() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt1489_1728.kt");
            }

            @TestMetadata("kt1550.kt")
            public void testKt1550() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt1550.kt");
            }

            @TestMetadata("kt16086.kt")
            public void testKt16086() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt16086.kt");
            }

            @TestMetadata("kt16086_2.kt")
            public void testKt16086_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt16086_2.kt");
            }

            @TestMetadata("kt1639-JFrame.kt")
            public void testKt1639_JFrame() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt1639-JFrame.kt");
            }

            @TestMetadata("kt1647.kt")
            public void testKt1647() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt1647.kt");
            }

            @TestMetadata("kt1736.kt")
            public void testKt1736() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt1736.kt");
            }

            @TestMetadata("kt174.kt")
            public void testKt174() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt174.kt");
            }

            @TestMetadata("kt201.kt")
            public void testKt201() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt201.kt");
            }

            @TestMetadata("kt235.kt")
            public void testKt235() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt235.kt");
            }

            @TestMetadata("kt2376.kt")
            public void testKt2376() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt2376.kt");
            }

            @TestMetadata("kt251.kt")
            public void testKt251() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt251.kt");
            }

            @TestMetadata("kt258.kt")
            public void testKt258() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt258.kt");
            }

            @TestMetadata("kt26.kt")
            public void testKt26() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt26.kt");
            }

            @TestMetadata("kt26-1.kt")
            public void testKt26_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt26-1.kt");
            }

            @TestMetadata("kt2768.kt")
            public void testKt2768() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt2768.kt");
            }

            @TestMetadata("kt282.kt")
            public void testKt282() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt282.kt");
            }

            @TestMetadata("kt287.kt")
            public void testKt287() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt287.kt");
            }

            @TestMetadata("kt2956.kt")
            public void testKt2956() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt2956.kt");
            }

            @TestMetadata("kt302.kt")
            public void testKt302() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt302.kt");
            }

            @TestMetadata("kt306.kt")
            public void testKt306() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt306.kt");
            }

            @TestMetadata("kt307.kt")
            public void testKt307() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt307.kt");
            }

            @TestMetadata("kt312.kt")
            public void testKt312() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt312.kt");
            }

            @TestMetadata("kt313.kt")
            public void testKt313() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt313.kt");
            }

            @TestMetadata("kt316.kt")
            public void testKt316() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt316.kt");
            }

            @TestMetadata("kt328.kt")
            public void testKt328() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt328.kt");
            }

            @TestMetadata("kt334.kt")
            public void testKt334() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt334.kt");
            }

            @TestMetadata("kt335.336.kt")
            public void testKt335_336() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt335.336.kt");
            }

            @TestMetadata("kt337.kt")
            public void testKt337() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt337.kt");
            }

            @TestMetadata("kt352.kt")
            public void testKt352() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt352.kt");
            }

            @TestMetadata("kt353.kt")
            public void testKt353() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt353.kt");
            }

            @TestMetadata("kt3535.kt")
            public void testKt3535() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt3535.kt");
            }

            @TestMetadata("kt3647.kt")
            public void testKt3647() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt3647.kt");
            }

            @TestMetadata("kt3731.kt")
            public void testKt3731() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt3731.kt");
            }

            @TestMetadata("kt3810.kt")
            public void testKt3810() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt3810.kt");
            }

            @TestMetadata("kt385.109.441.kt")
            public void testKt385_109_441() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt385.109.441.kt");
            }

            @TestMetadata("kt394.kt")
            public void testKt394() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt394.kt");
            }

            @TestMetadata("kt398.kt")
            public void testKt398() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt398.kt");
            }

            @TestMetadata("kt399.kt")
            public void testKt399() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt399.kt");
            }

            @TestMetadata("kt402.kt")
            public void testKt402() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt402.kt");
            }

            @TestMetadata("kt41.kt")
            public void testKt41() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt41.kt");
            }

            @TestMetadata("kt411.kt")
            public void testKt411() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt411.kt");
            }

            @TestMetadata("kt439.kt")
            public void testKt439() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt439.kt");
            }

            @TestMetadata("kt442.kt")
            public void testKt442() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt442.kt");
            }

            @TestMetadata("kt443.kt")
            public void testKt443() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt443.kt");
            }

            @TestMetadata("kt455.kt")
            public void testKt455() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt455.kt");
            }

            @TestMetadata("kt456.kt")
            public void testKt456() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt456.kt");
            }

            @TestMetadata("kt459.kt")
            public void testKt459() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt459.kt");
            }

            @TestMetadata("kt469.kt")
            public void testKt469() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt469.kt");
            }

            @TestMetadata("kt4693.kt")
            public void testKt4693() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt4693.kt");
            }

            @TestMetadata("kt4827.kt")
            public void testKt4827() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt4827.kt");
            }

            @TestMetadata("kt498.kt")
            public void testKt498() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt498.kt");
            }

            @TestMetadata("kt524.kt")
            public void testKt524() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt524.kt");
            }

            @TestMetadata("kt526UnresolvedReferenceInnerStatic.kt")
            public void testKt526UnresolvedReferenceInnerStatic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt526UnresolvedReferenceInnerStatic.kt");
            }

            @TestMetadata("kt5326.kt")
            public void testKt5326() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt5326.kt");
            }

            @TestMetadata("kt5362.kt")
            public void testKt5362() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt5362.kt");
            }

            @TestMetadata("kt549.kt")
            public void testKt549() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt549.kt");
            }

            @TestMetadata("kt557.kt")
            public void testKt557() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt557.kt");
            }

            @TestMetadata("kt571.kt")
            public void testKt571() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt571.kt");
            }

            @TestMetadata("kt575.kt")
            public void testKt575() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt575.kt");
            }

            @TestMetadata("kt58.kt")
            public void testKt58() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt58.kt");
            }

            @TestMetadata("kt580.kt")
            public void testKt580() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt580.kt");
            }

            @TestMetadata("kt588.kt")
            public void testKt588() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt588.kt");
            }

            @TestMetadata("kt597.kt")
            public void testKt597() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt597.kt");
            }

            @TestMetadata("kt600.kt")
            public void testKt600() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt600.kt");
            }

            @TestMetadata("kt604.kt")
            public void testKt604() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt604.kt");
            }

            @TestMetadata("kt618.kt")
            public void testKt618() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt618.kt");
            }

            @TestMetadata("kt629.kt")
            public void testKt629() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt629.kt");
            }

            @TestMetadata("kt630.kt")
            public void testKt630() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt630.kt");
            }

            @TestMetadata("kt6508.kt")
            public void testKt6508() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt6508.kt");
            }

            @TestMetadata("kt688.kt")
            public void testKt688() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt688.kt");
            }

            @TestMetadata("kt691.kt")
            public void testKt691() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt691.kt");
            }

            @TestMetadata("kt701.kt")
            public void testKt701() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt701.kt");
            }

            @TestMetadata("kt716.kt")
            public void testKt716() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt716.kt");
            }

            @TestMetadata("kt743.kt")
            public void testKt743() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt743.kt");
            }

            @TestMetadata("kt750.kt")
            public void testKt750() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt750.kt");
            }

            @TestMetadata("kt762.kt")
            public void testKt762() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt762.kt");
            }

            @TestMetadata("kt7804.kt")
            public void testKt7804() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt7804.kt");
            }

            @TestMetadata("kt847.kt")
            public void testKt847() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt847.kt");
            }

            @TestMetadata("kt860.kt")
            public void testKt860() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt860.kt");
            }

            @TestMetadata("kt9620.kt")
            public void testKt9620() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt9620.kt");
            }

            @TestMetadata("kt9633.kt")
            public void testKt9633() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt9633.kt");
            }

            @TestMetadata("kt9682.kt")
            public void testKt9682() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt9682.kt");
            }

            @TestMetadata("kt9808.kt")
            public void testKt9808() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/kt9808.kt");
            }

            @TestMetadata("noThis.kt")
            public void testNoThis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/noThis.kt");
            }

            @TestMetadata("OrphanStarProjection.kt")
            public void testOrphanStarProjection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/OrphanStarProjection.kt");
            }

            @TestMetadata("OutProjections.kt")
            public void testOutProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/OutProjections.kt");
            }

            @TestMetadata("OverrideResolution.kt")
            public void testOverrideResolution() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/OverrideResolution.kt");
            }

            @TestMetadata("propertyWithExtensionTypeInvoke.kt")
            public void testPropertyWithExtensionTypeInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/propertyWithExtensionTypeInvoke.kt");
            }

            @TestMetadata("resolveSubclassOfList.kt")
            public void testResolveSubclassOfList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/resolveSubclassOfList.kt");
            }

            @TestMetadata("SpecififcityByReceiver.kt")
            public void testSpecififcityByReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/SpecififcityByReceiver.kt");
            }

            @TestMetadata("TypeMismatchOnUnaryOperations.kt")
            public void testTypeMismatchOnUnaryOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/TypeMismatchOnUnaryOperations.kt");
            }

            @TestMetadata("TypeParameterAsASupertype.kt")
            public void testTypeParameterAsASupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/TypeParameterAsASupertype.kt");
            }

            @TestMetadata("UnavaliableQualifiedThis.kt")
            public void testUnavaliableQualifiedThis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/UnavaliableQualifiedThis.kt");
            }

            @TestMetadata("WrongTraceInCallResolver.kt")
            public void testWrongTraceInCallResolver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/regressions/WrongTraceInCallResolver.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/regressions/kt7585")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Kt7585 extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInKt7585() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/regressions/kt7585"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("base.kt")
                public void testBase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/regressions/kt7585/base.kt");
                }

                @TestMetadata("java.kt")
                public void testJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/regressions/kt7585/java.kt");
                }

                @TestMetadata("twoparents.kt")
                public void testTwoparents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/regressions/kt7585/twoparents.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/resolve")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Resolve extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInResolve() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguityOnPropertiesWithTheSamePackageName.kt")
            public void testAmbiguityOnPropertiesWithTheSamePackageName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/ambiguityOnPropertiesWithTheSamePackageName.kt");
            }

            @TestMetadata("ambiguityWithTwoCorrespondingFunctionTypes.kt")
            public void testAmbiguityWithTwoCorrespondingFunctionTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/ambiguityWithTwoCorrespondingFunctionTypes.kt");
            }

            @TestMetadata("anonymousObjectFromTopLevelMember.kt")
            public void testAnonymousObjectFromTopLevelMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/anonymousObjectFromTopLevelMember.kt");
            }

            @TestMetadata("capturedTypesInLambdaParameter.kt")
            public void testCapturedTypesInLambdaParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/capturedTypesInLambdaParameter.kt");
            }

            @TestMetadata("constructorVsCompanion.kt")
            public void testConstructorVsCompanion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/constructorVsCompanion.kt");
            }

            @TestMetadata("CycleInTypeArgs.kt")
            public void testCycleInTypeArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/CycleInTypeArgs.kt");
            }

            @TestMetadata("HiddenDeclarations.kt")
            public void testHiddenDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/HiddenDeclarations.kt");
            }

            @TestMetadata("implicitReceiverProperty.kt")
            public void testImplicitReceiverProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/implicitReceiverProperty.kt");
            }

            @TestMetadata("incompleteConstructorInvocation.kt")
            public void testIncompleteConstructorInvocation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/incompleteConstructorInvocation.kt");
            }

            @TestMetadata("inferenceInLinkedLambdas.kt")
            public void testInferenceInLinkedLambdas() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/inferenceInLinkedLambdas.kt");
            }

            @TestMetadata("inferenceInLinkedLambdasDependentOnExpectedType.kt")
            public void testInferenceInLinkedLambdasDependentOnExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/inferenceInLinkedLambdasDependentOnExpectedType.kt");
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/localObject.kt");
            }

            @TestMetadata("objectLiteralAsArgument.kt")
            public void testObjectLiteralAsArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/objectLiteralAsArgument.kt");
            }

            @TestMetadata("parameterAsDefaultValueInLocalFunction.kt")
            public void testParameterAsDefaultValueInLocalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/parameterAsDefaultValueInLocalFunction.kt");
            }

            @TestMetadata("resolveAnnotatedLambdaArgument.kt")
            public void testResolveAnnotatedLambdaArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveAnnotatedLambdaArgument.kt");
            }

            @TestMetadata("resolveTypeArgsForUnresolvedCall.kt")
            public void testResolveTypeArgsForUnresolvedCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveTypeArgsForUnresolvedCall.kt");
            }

            @TestMetadata("resolveWithFunctionLiteralWithId.kt")
            public void testResolveWithFunctionLiteralWithId() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiteralWithId.kt");
            }

            @TestMetadata("resolveWithFunctionLiterals.kt")
            public void testResolveWithFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiterals.kt");
            }

            @TestMetadata("resolveWithFunctionLiteralsOverload.kt")
            public void testResolveWithFunctionLiteralsOverload() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiteralsOverload.kt");
            }

            @TestMetadata("resolveWithGenerics.kt")
            public void testResolveWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithGenerics.kt");
            }

            @TestMetadata("resolveWithRedeclarationError.kt")
            public void testResolveWithRedeclarationError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithRedeclarationError.kt");
            }

            @TestMetadata("resolveWithSpecifiedFunctionLiteralWithId.kt")
            public void testResolveWithSpecifiedFunctionLiteralWithId() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithSpecifiedFunctionLiteralWithId.kt");
            }

            @TestMetadata("resolveWithoutGenerics.kt")
            public void testResolveWithoutGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/resolveWithoutGenerics.kt");
            }

            @TestMetadata("typeParameterInDefaultValueInLocalFunction.kt")
            public void testTypeParameterInDefaultValueInLocalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/typeParameterInDefaultValueInLocalFunction.kt");
            }

            @TestMetadata("wrongNumberOfTypeArguments.kt")
            public void testWrongNumberOfTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/wrongNumberOfTypeArguments.kt");
            }

            @TestMetadata("wrongReceiver.kt")
            public void testWrongReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/resolve/wrongReceiver.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DslMarker extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDslMarker() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/dslMarker"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotatedFunctionType.kt")
                public void testAnnotatedFunctionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/annotatedFunctionType.kt");
                }

                @TestMetadata("annotatedFunctionType_1_4.kt")
                public void testAnnotatedFunctionType_1_4() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/annotatedFunctionType_1_4.kt");
                }

                @TestMetadata("annotatedTypeArgument.kt")
                public void testAnnotatedTypeArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/annotatedTypeArgument.kt");
                }

                @TestMetadata("dslMarkerOnTypealias.kt")
                public void testDslMarkerOnTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/dslMarkerOnTypealias.kt");
                }

                @TestMetadata("dslMarkerWithTypealiasRecursion.kt")
                public void testDslMarkerWithTypealiasRecursion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/dslMarkerWithTypealiasRecursion.kt");
                }

                @TestMetadata("inheritedMarker.kt")
                public void testInheritedMarker() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/inheritedMarker.kt");
                }

                @TestMetadata("insideTopLevelExtension.kt")
                public void testInsideTopLevelExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/insideTopLevelExtension.kt");
                }

                @TestMetadata("insideTopLevelExtensionAnnotatedType.kt")
                public void testInsideTopLevelExtensionAnnotatedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/insideTopLevelExtensionAnnotatedType.kt");
                }

                @TestMetadata("markersIntersection.kt")
                public void testMarkersIntersection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/markersIntersection.kt");
                }

                @TestMetadata("nestedWithSameReceiver.kt")
                public void testNestedWithSameReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/nestedWithSameReceiver.kt");
                }

                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/properties.kt");
                }

                @TestMetadata("simpleAnnotatedClasses.kt")
                public void testSimpleAnnotatedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/simpleAnnotatedClasses.kt");
                }

                @TestMetadata("simpleAnnotatedTypes.kt")
                public void testSimpleAnnotatedTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/simpleAnnotatedTypes.kt");
                }

                @TestMetadata("substitutedReceiverAnnotatedClasses.kt")
                public void testSubstitutedReceiverAnnotatedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/substitutedReceiverAnnotatedClasses.kt");
                }

                @TestMetadata("substitutedReceiverAnnotatedType.kt")
                public void testSubstitutedReceiverAnnotatedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/substitutedReceiverAnnotatedType.kt");
                }

                @TestMetadata("threeImplicitReceivers.kt")
                public void testThreeImplicitReceivers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/threeImplicitReceivers.kt");
                }

                @TestMetadata("threeImplicitReceivers2.kt")
                public void testThreeImplicitReceivers2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/threeImplicitReceivers2.kt");
                }

                @TestMetadata("twoImplicitReceivers.kt")
                public void testTwoImplicitReceivers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/twoImplicitReceivers.kt");
                }

                @TestMetadata("twoLanguages.kt")
                public void testTwoLanguages() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/twoLanguages.kt");
                }

                @TestMetadata("unsupportedFeature.kt")
                public void testUnsupportedFeature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/unsupportedFeature.kt");
                }

                @TestMetadata("useOfExtensions.kt")
                public void testUseOfExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/useOfExtensions.kt");
                }

                @TestMetadata("usingWith.kt")
                public void testUsingWith() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/usingWith.kt");
                }

                @TestMetadata("usingWithThis.kt")
                public void testUsingWithThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/dslMarker/usingWithThis.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("extensionValueAsNonExtension.kt")
                public void testExtensionValueAsNonExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/extensionValueAsNonExtension.kt");
                }

                @TestMetadata("functionExpectedWhenSeveralInvokesExist.kt")
                public void testFunctionExpectedWhenSeveralInvokesExist() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/functionExpectedWhenSeveralInvokesExist.kt");
                }

                @TestMetadata("implicitInvoke.kt")
                public void testImplicitInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/implicitInvoke.kt");
                }

                @TestMetadata("invokeAndSmartCast.kt")
                public void testInvokeAndSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeAndSmartCast.kt");
                }

                @TestMetadata("invokeAsExtension.kt")
                public void testInvokeAsExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsExtension.kt");
                }

                @TestMetadata("invokeAsMember.kt")
                public void testInvokeAsMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMember.kt");
                }

                @TestMetadata("invokeAsMemberExtension.kt")
                public void testInvokeAsMemberExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMemberExtension.kt");
                }

                @TestMetadata("invokeAsMemberExtensionToExplicitReceiver.kt")
                public void testInvokeAsMemberExtensionToExplicitReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMemberExtensionToExplicitReceiver.kt");
                }

                @TestMetadata("invokeNonExtensionLambdaInContext.kt")
                public void testInvokeNonExtensionLambdaInContext() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeNonExtensionLambdaInContext.kt");
                }

                @TestMetadata("invokeOnVariableWithExtensionFunctionType.kt")
                public void testInvokeOnVariableWithExtensionFunctionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/invokeOnVariableWithExtensionFunctionType.kt");
                }

                @TestMetadata("KT-4372.kt")
                public void testKT_4372() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/KT-4372.kt");
                }

                @TestMetadata("kt3772.kt")
                public void testKt3772() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt3772.kt");
                }

                @TestMetadata("kt3833-invokeInsideNestedClass.kt")
                public void testKt3833_invokeInsideNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt3833-invokeInsideNestedClass.kt");
                }

                @TestMetadata("kt4204-completeNestedCallsForInvoke.kt")
                public void testKt4204_completeNestedCallsForInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt4204-completeNestedCallsForInvoke.kt");
                }

                @TestMetadata("kt4321InvokeOnEnum.kt")
                public void testKt4321InvokeOnEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt4321InvokeOnEnum.kt");
                }

                @TestMetadata("kt9517.kt")
                public void testKt9517() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt9517.kt");
                }

                @TestMetadata("kt9805.kt")
                public void testKt9805() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/kt9805.kt");
                }

                @TestMetadata("reportFunctionExpectedWhenOneInvokeExist.kt")
                public void testReportFunctionExpectedWhenOneInvokeExist() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/reportFunctionExpectedWhenOneInvokeExist.kt");
                }

                @TestMetadata("valNamedInvoke.kt")
                public void testValNamedInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/valNamedInvoke.kt");
                }

                @TestMetadata("wrongInvokeExtension.kt")
                public void testWrongInvokeExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/invoke/wrongInvokeExtension.kt");
                }

                @TestMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Errors extends AbstractDiagnosticsUsingJavacTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInErrors() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/invoke/errors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("ambiguityForInvoke.kt")
                    public void testAmbiguityForInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/ambiguityForInvoke.kt");
                    }

                    @TestMetadata("invisibleInvoke.kt")
                    public void testInvisibleInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/invisibleInvoke.kt");
                    }

                    @TestMetadata("receiverPresenceErrorForInvoke.kt")
                    public void testReceiverPresenceErrorForInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/receiverPresenceErrorForInvoke.kt");
                    }

                    @TestMetadata("typeInferenceErrorForInvoke.kt")
                    public void testTypeInferenceErrorForInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/typeInferenceErrorForInvoke.kt");
                    }

                    @TestMetadata("unresolvedInvoke.kt")
                    public void testUnresolvedInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/unresolvedInvoke.kt");
                    }

                    @TestMetadata("unsafeCallWithInvoke.kt")
                    public void testUnsafeCallWithInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/unsafeCallWithInvoke.kt");
                    }

                    @TestMetadata("wrongReceiverForInvokeOnExpression.kt")
                    public void testWrongReceiverForInvokeOnExpression() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/wrongReceiverForInvokeOnExpression.kt");
                    }

                    @TestMetadata("wrongReceiverTypeForInvoke.kt")
                    public void testWrongReceiverTypeForInvoke() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/resolve/invoke/errors/wrongReceiverTypeForInvoke.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NestedCalls extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNestedCalls() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/nestedCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("analyzeArgsInFreeExpressionPosition.kt")
                public void testAnalyzeArgsInFreeExpressionPosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/analyzeArgsInFreeExpressionPosition.kt");
                }

                @TestMetadata("analyzeUnmappedArguments.kt")
                public void testAnalyzeUnmappedArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/analyzeUnmappedArguments.kt");
                }

                @TestMetadata("argumentsInParentheses.kt")
                public void testArgumentsInParentheses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/argumentsInParentheses.kt");
                }

                @TestMetadata("completeTypeInferenceForNestedInNoneApplicable.kt")
                public void testCompleteTypeInferenceForNestedInNoneApplicable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/completeTypeInferenceForNestedInNoneApplicable.kt");
                }

                @TestMetadata("completeUnmappedArguments.kt")
                public void testCompleteUnmappedArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/completeUnmappedArguments.kt");
                }

                @TestMetadata("kt5971NestedSafeCall.kt")
                public void testKt5971NestedSafeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/kt5971NestedSafeCall.kt");
                }

                @TestMetadata("kt7597.kt")
                public void testKt7597() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/kt7597.kt");
                }

                @TestMetadata("manyInapplicableCandidatesWithLambdas.kt")
                public void testManyInapplicableCandidatesWithLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/manyInapplicableCandidatesWithLambdas.kt");
                }

                @TestMetadata("twoTypeParameters.kt")
                public void testTwoTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/nestedCalls/twoTypeParameters.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/noCandidates")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NoCandidates extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNoCandidates() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/noCandidates"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt2787.kt")
                public void testKt2787() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/noCandidates/kt2787.kt");
                }

                @TestMetadata("resolvedToClassifier.kt")
                public void testResolvedToClassifier() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/noCandidates/resolvedToClassifier.kt");
                }

                @TestMetadata("resolvedToClassifierWithReceiver.kt")
                public void testResolvedToClassifierWithReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/noCandidates/resolvedToClassifierWithReceiver.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OverloadConflicts extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInOverloadConflicts() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/overloadConflicts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("allLambdas.kt")
                public void testAllLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/allLambdas.kt");
                }

                @TestMetadata("extensionReceiverAndVarargs.kt")
                public void testExtensionReceiverAndVarargs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/extensionReceiverAndVarargs.kt");
                }

                @TestMetadata("genericWithProjection.kt")
                public void testGenericWithProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/genericWithProjection.kt");
                }

                @TestMetadata("kt10472.kt")
                public void testKt10472() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/kt10472.kt");
                }

                @TestMetadata("kt10640.kt")
                public void testKt10640() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/kt10640.kt");
                }

                @TestMetadata("numberOfDefaults.kt")
                public void testNumberOfDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/numberOfDefaults.kt");
                }

                @TestMetadata("originalExamples.kt")
                public void testOriginalExamples() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/originalExamples.kt");
                }

                @TestMetadata("varargWithMoreSpecificSignature.kt")
                public void testVarargWithMoreSpecificSignature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargWithMoreSpecificSignature.kt");
                }

                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargs.kt");
                }

                @TestMetadata("varargsInDifferentPositions.kt")
                public void testVarargsInDifferentPositions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsInDifferentPositions.kt");
                }

                @TestMetadata("varargsMixed.kt")
                public void testVarargsMixed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsMixed.kt");
                }

                @TestMetadata("varargsWithRecursiveGenerics.kt")
                public void testVarargsWithRecursiveGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsWithRecursiveGenerics.kt");
                }

                @TestMetadata("withVariance.kt")
                public void testWithVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/overloadConflicts/withVariance.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/priority")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Priority extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPriority() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/priority"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invokeExtensionVsOther.kt")
                public void testInvokeExtensionVsOther() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/invokeExtensionVsOther.kt");
                }

                @TestMetadata("invokeExtensionVsOther2.kt")
                public void testInvokeExtensionVsOther2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/invokeExtensionVsOther2.kt");
                }

                @TestMetadata("kt10219.kt")
                public void testKt10219() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/kt10219.kt");
                }

                @TestMetadata("kt10510.kt")
                public void testKt10510() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/kt10510.kt");
                }

                @TestMetadata("kt9810.kt")
                public void testKt9810() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/kt9810.kt");
                }

                @TestMetadata("kt9965.kt")
                public void testKt9965() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/kt9965.kt");
                }

                @TestMetadata("localExtVsNonLocalExt.kt")
                public void testLocalExtVsNonLocalExt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/localExtVsNonLocalExt.kt");
                }

                @TestMetadata("memberVsLocalExt.kt")
                public void testMemberVsLocalExt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/memberVsLocalExt.kt");
                }

                @TestMetadata("staticVsImplicitReceiverMember.kt")
                public void testStaticVsImplicitReceiverMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/staticVsImplicitReceiverMember.kt");
                }

                @TestMetadata("synthesizedMembersVsExtension.kt")
                public void testSynthesizedMembersVsExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/synthesizedMembersVsExtension.kt");
                }

                @TestMetadata("syntheticPropertiesVsExtensions.kt")
                public void testSyntheticPropertiesVsExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/syntheticPropertiesVsExtensions.kt");
                }

                @TestMetadata("syntheticPropertiesVsMembers.kt")
                public void testSyntheticPropertiesVsMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/priority/syntheticPropertiesVsMembers.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecialConstructions extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSpecialConstructions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/specialConstructions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constantsInIf.kt")
                public void testConstantsInIf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/constantsInIf.kt");
                }

                @TestMetadata("elvisAsCall.kt")
                public void testElvisAsCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/elvisAsCall.kt");
                }

                @TestMetadata("exclExclAsCall.kt")
                public void testExclExclAsCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/exclExclAsCall.kt");
                }

                @TestMetadata("inferenceForElvis.kt")
                public void testInferenceForElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/inferenceForElvis.kt");
                }

                @TestMetadata("multipleSuperClasses.kt")
                public void testMultipleSuperClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/multipleSuperClasses.kt");
                }

                @TestMetadata("reportTypeMismatchDeeplyOnBranches.kt")
                public void testReportTypeMismatchDeeplyOnBranches() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/resolve/specialConstructions/reportTypeMismatchDeeplyOnBranches.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/samConversions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SamConversions extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSamConversions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/samConversions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DisabledForKTSimple.kt")
            public void testDisabledForKTSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/DisabledForKTSimple.kt");
            }

            @TestMetadata("GenericSubstitution.kt")
            public void testGenericSubstitution() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/GenericSubstitution.kt");
            }

            @TestMetadata("GenericSubstitutionKT.kt")
            public void testGenericSubstitutionKT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/GenericSubstitutionKT.kt");
            }

            @TestMetadata("OverloadPriority.kt")
            public void testOverloadPriority() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/OverloadPriority.kt");
            }

            @TestMetadata("OverloadPriorityKT.kt")
            public void testOverloadPriorityKT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/OverloadPriorityKT.kt");
            }

            @TestMetadata("SAMAfterSubstitution.kt")
            public void testSAMAfterSubstitution() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/SAMAfterSubstitution.kt");
            }

            @TestMetadata("SAMAfterSubstitutionKT.kt")
            public void testSAMAfterSubstitutionKT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/SAMAfterSubstitutionKT.kt");
            }

            @TestMetadata("SimpleCorrect.kt")
            public void testSimpleCorrect() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/SimpleCorrect.kt");
            }

            @TestMetadata("SimpleCorrectKT.kt")
            public void testSimpleCorrectKT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/samConversions/SimpleCorrectKT.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/scopes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Scopes extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInScopes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbiguityBetweenRootAndPackage.kt")
            public void testAmbiguityBetweenRootAndPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/AmbiguityBetweenRootAndPackage.kt");
            }

            @TestMetadata("AmbiguousNonExtensions.kt")
            public void testAmbiguousNonExtensions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/AmbiguousNonExtensions.kt");
            }

            @TestMetadata("genericVsNested.kt")
            public void testGenericVsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/genericVsNested.kt");
            }

            @TestMetadata("implicitReceiverMemberVsParameter.kt")
            public void testImplicitReceiverMemberVsParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/implicitReceiverMemberVsParameter.kt");
            }

            @TestMetadata("initializerScopeOfExtensionProperty.kt")
            public void testInitializerScopeOfExtensionProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/initializerScopeOfExtensionProperty.kt");
            }

            @TestMetadata("invisibleSetter.kt")
            public void testInvisibleSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/invisibleSetter.kt");
            }

            @TestMetadata("kt1078.kt")
            public void testKt1078() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1078.kt");
            }

            @TestMetadata("kt1080.kt")
            public void testKt1080() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1080.kt");
            }

            @TestMetadata("kt1244.kt")
            public void testKt1244() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1244.kt");
            }

            @TestMetadata("kt1248.kt")
            public void testKt1248() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1248.kt");
            }

            @TestMetadata("kt151.kt")
            public void testKt151() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt151.kt");
            }

            @TestMetadata("kt1579.kt")
            public void testKt1579() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1579.kt");
            }

            @TestMetadata("kt1579_map_entry.kt")
            public void testKt1579_map_entry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1579_map_entry.kt");
            }

            @TestMetadata("kt1580.kt")
            public void testKt1580() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1580.kt");
            }

            @TestMetadata("kt1642.kt")
            public void testKt1642() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1642.kt");
            }

            @TestMetadata("kt1738.kt")
            public void testKt1738() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1738.kt");
            }

            @TestMetadata("kt1805.kt")
            public void testKt1805() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1805.kt");
            }

            @TestMetadata("kt1806.kt")
            public void testKt1806() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1806.kt");
            }

            @TestMetadata("kt1822.kt")
            public void testKt1822() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1822.kt");
            }

            @TestMetadata("kt1942.kt")
            public void testKt1942() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt1942.kt");
            }

            @TestMetadata("kt2262.kt")
            public void testKt2262() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt2262.kt");
            }

            @TestMetadata("kt250.617.10.kt")
            public void testKt250_617_10() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt250.617.10.kt");
            }

            @TestMetadata("kt323.kt")
            public void testKt323() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt323.kt");
            }

            @TestMetadata("kt37.kt")
            public void testKt37() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt37.kt");
            }

            @TestMetadata("kt587.kt")
            public void testKt587() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt587.kt");
            }

            @TestMetadata("kt900.kt")
            public void testKt900() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt900.kt");
            }

            @TestMetadata("kt900-1.kt")
            public void testKt900_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt900-1.kt");
            }

            @TestMetadata("kt900-2.kt")
            public void testKt900_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt900-2.kt");
            }

            @TestMetadata("kt939.kt")
            public void testKt939() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt939.kt");
            }

            @TestMetadata("kt9430.kt")
            public void testKt9430() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/kt9430.kt");
            }

            @TestMetadata("NoAmbiguityBetweenRootAndPackage.kt")
            public void testNoAmbiguityBetweenRootAndPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/NoAmbiguityBetweenRootAndPackage.kt");
            }

            @TestMetadata("sameClassNameResolve.kt")
            public void testSameClassNameResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/sameClassNameResolve.kt");
            }

            @TestMetadata("stopResolutionOnAmbiguity.kt")
            public void testStopResolutionOnAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/stopResolutionOnAmbiguity.kt");
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/visibility.kt");
            }

            @TestMetadata("visibility2.kt")
            public void testVisibility2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/visibility2.kt");
            }

            @TestMetadata("visibility3.kt")
            public void testVisibility3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/visibility3.kt");
            }

            @TestMetadata("VisibilityInClassObject.kt")
            public void testVisibilityInClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/VisibilityInClassObject.kt");
            }

            @TestMetadata("VisibilityInheritModifier.kt")
            public void testVisibilityInheritModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/scopes/VisibilityInheritModifier.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/classHeader")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClassHeader extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClassHeader() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/classHeader"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationOnClass.kt")
                public void testAnnotationOnClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/annotationOnClass.kt");
                }

                @TestMetadata("annotationOnConstructors.kt")
                public void testAnnotationOnConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/annotationOnConstructors.kt");
                }

                @TestMetadata("classGenericParameters.kt")
                public void testClassGenericParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/classGenericParameters.kt");
                }

                @TestMetadata("classParents.kt")
                public void testClassParents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/classParents.kt");
                }

                @TestMetadata("companionObjectParents.kt")
                public void testCompanionObjectParents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/companionObjectParents.kt");
                }

                @TestMetadata("companionObjectSuperConstructorArguments.kt")
                public void testCompanionObjectSuperConstructorArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/companionObjectSuperConstructorArguments.kt");
                }

                @TestMetadata("constructors.kt")
                public void testConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/constructors.kt");
                }

                @TestMetadata("delegation.kt")
                public void testDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/delegation.kt");
                }

                @TestMetadata("objectParents.kt")
                public void testObjectParents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/objectParents.kt");
                }

                @TestMetadata("objectSuperConstructorArguments.kt")
                public void testObjectSuperConstructorArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/objectSuperConstructorArguments.kt");
                }

                @TestMetadata("simpleDelegation.kt")
                public void testSimpleDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/simpleDelegation.kt");
                }

                @TestMetadata("superConstructorArguments.kt")
                public void testSuperConstructorArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/superConstructorArguments.kt");
                }

                @TestMetadata("superConstructorArgumentsInSecondaryConstructor.kt")
                public void testSuperConstructorArgumentsInSecondaryConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/classHeader/superConstructorArgumentsInSecondaryConstructor.kt");
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inheritance extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("companionObject.kt")
                public void testCompanionObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/companionObject.kt");
                }

                @TestMetadata("companionObjectAfterJava.kt")
                public void testCompanionObjectAfterJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/companionObjectAfterJava.kt");
                }

                @TestMetadata("companionObjectsOrder.kt")
                public void testCompanionObjectsOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/companionObjectsOrder.kt");
                }

                @TestMetadata("innerClasses.kt")
                public void testInnerClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/innerClasses.kt");
                }

                @TestMetadata("kt3856.kt")
                public void testKt3856() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/kt3856.kt");
                }

                @TestMetadata("methodsPriority.kt")
                public void testMethodsPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/methodsPriority.kt");
                }

                @TestMetadata("nestedClassesFromInterface.kt")
                public void testNestedClassesFromInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedClassesFromInterface.kt");
                }

                @TestMetadata("nestedCompanionClass.kt")
                public void testNestedCompanionClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClass.kt");
                }

                @TestMetadata("nestedCompanionClassVsNested.kt")
                public void testNestedCompanionClassVsNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClassVsNested.kt");
                }

                @TestMetadata("nestedCompanionClassVsNestedJava.kt")
                public void testNestedCompanionClassVsNestedJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClassVsNestedJava.kt");
                }

                @TestMetadata("nestedFromJava.kt")
                public void testNestedFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedFromJava.kt");
                }

                @TestMetadata("nestedFromJavaAfterKotlin.kt")
                public void testNestedFromJavaAfterKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedFromJavaAfterKotlin.kt");
                }

                @TestMetadata("nestedVsToplevelClass.kt")
                public void testNestedVsToplevelClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/nestedVsToplevelClass.kt");
                }

                @TestMetadata("severalCompanions.kt")
                public void testSeveralCompanions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/inheritance/severalCompanions.kt");
                }

                @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Statics extends AbstractDiagnosticsUsingJavacTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInStatics() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("hidePrivateByPublic.kt")
                    public void testHidePrivateByPublic() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/hidePrivateByPublic.kt");
                    }

                    @TestMetadata("jjkj.kt")
                    public void testJjkj() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/jjkj.kt");
                    }

                    @TestMetadata("kjk.kt")
                    public void testKjk() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/kjk.kt");
                    }

                    @TestMetadata("localVsStatic.kt")
                    public void testLocalVsStatic() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/localVsStatic.kt");
                    }

                    @TestMetadata("nameClash0.kt")
                    public void testNameClash0() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash0.kt");
                    }

                    @TestMetadata("nameClash1.kt")
                    public void testNameClash1() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash1.kt");
                    }

                    @TestMetadata("nameClash2.kt")
                    public void testNameClash2() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash2.kt");
                    }

                    @TestMetadata("oneInterfaceManyTimes.kt")
                    public void testOneInterfaceManyTimes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/oneInterfaceManyTimes.kt");
                    }

                    @TestMetadata("overloadStatic.kt")
                    public void testOverloadStatic() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/overloadStatic.kt");
                    }

                    @TestMetadata("staticFunVsImport.kt")
                    public void testStaticFunVsImport() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticFunVsImport.kt");
                    }

                    @TestMetadata("staticPropertyVsImport.kt")
                    public void testStaticPropertyVsImport() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticPropertyVsImport.kt");
                    }

                    @TestMetadata("staticVsCompanion.kt")
                    public void testStaticVsCompanion() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsCompanion.kt");
                    }

                    @TestMetadata("staticVsMember.kt")
                    public void testStaticVsMember() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsMember.kt");
                    }

                    @TestMetadata("staticVsOuter.kt")
                    public void testStaticVsOuter() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsOuter.kt");
                    }

                    @TestMetadata("staticsFromjava.kt")
                    public void testStaticsFromjava() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticsFromjava.kt");
                    }

                    @TestMetadata("staticsFromjavaAfterKotlin.kt")
                    public void testStaticsFromjavaAfterKotlin() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticsFromjavaAfterKotlin.kt");
                    }

                    @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class CompanionObject extends AbstractDiagnosticsUsingJavacTest {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("accessToStaticMembersOfParentClassJKJ_after.kt")
                        public void testAccessToStaticMembersOfParentClassJKJ_after() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClassJKJ_after.kt");
                        }

                        @TestMetadata("accessToStaticMembersOfParentClassJKJ_before.kt")
                        public void testAccessToStaticMembersOfParentClassJKJ_before() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClassJKJ_before.kt");
                        }

                        @TestMetadata("accessToStaticMembersOfParentClass_after.kt")
                        public void testAccessToStaticMembersOfParentClass_after() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClass_after.kt");
                        }

                        @TestMetadata("accessToStaticMembersOfParentClass_before.kt")
                        public void testAccessToStaticMembersOfParentClass_before() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClass_before.kt");
                        }

                        public void testAllFilesPresentInCompanionObject() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("inheritFromContainingClass_after.kt")
                        public void testInheritFromContainingClass_after() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromContainingClass_after.kt");
                        }

                        @TestMetadata("inheritFromContainingClass_before.kt")
                        public void testInheritFromContainingClass_before() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromContainingClass_before.kt");
                        }

                        @TestMetadata("inheritFromJavaAfterKotlin_after.kt")
                        public void testInheritFromJavaAfterKotlin_after() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJavaAfterKotlin_after.kt");
                        }

                        @TestMetadata("inheritFromJavaAfterKotlin_before.kt")
                        public void testInheritFromJavaAfterKotlin_before() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJavaAfterKotlin_before.kt");
                        }

                        @TestMetadata("inheritFromJava_after.kt")
                        public void testInheritFromJava_after() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJava_after.kt");
                        }

                        @TestMetadata("inheritFromJava_before.kt")
                        public void testInheritFromJava_before() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJava_before.kt");
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ProtectedVisibility extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProtectedVisibility() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/protectedVisibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complexCompanion.kt")
                public void testComplexCompanion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/complexCompanion.kt");
                }

                @TestMetadata("constructors.kt")
                public void testConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/constructors.kt");
                }

                @TestMetadata("constructorsInner.kt")
                public void testConstructorsInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/constructorsInner.kt");
                }

                @TestMetadata("innerClassInJava.kt")
                public void testInnerClassInJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/innerClassInJava.kt");
                }

                @TestMetadata("innerProtectedClass.kt")
                public void testInnerProtectedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/innerProtectedClass.kt");
                }

                @TestMetadata("javaInheritedInKotlin.kt")
                public void testJavaInheritedInKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/javaInheritedInKotlin.kt");
                }

                @TestMetadata("kt7971.kt")
                public void testKt7971() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/kt7971.kt");
                }

                @TestMetadata("nonSuperCallConstructor.kt")
                public void testNonSuperCallConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructor.kt");
                }

                @TestMetadata("nonSuperCallConstructorJavaDifferentPackage.kt")
                public void testNonSuperCallConstructorJavaDifferentPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructorJavaDifferentPackage.kt");
                }

                @TestMetadata("nonSuperCallConstructorJavaSamePackage.kt")
                public void testNonSuperCallConstructorJavaSamePackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructorJavaSamePackage.kt");
                }

                @TestMetadata("protectedCallOnSubClass.kt")
                public void testProtectedCallOnSubClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/protectedCallOnSubClass.kt");
                }

                @TestMetadata("smartcastOnExtensionReceiver.kt")
                public void testSmartcastOnExtensionReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/smartcastOnExtensionReceiver.kt");
                }

                @TestMetadata("syntheticPropertyExtensions.kt")
                public void testSyntheticPropertyExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/syntheticPropertyExtensions.kt");
                }

                @TestMetadata("syntheticSAMExtensions.kt")
                public void testSyntheticSAMExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/syntheticSAMExtensions.kt");
                }

                @TestMetadata("unstableSmartCast.kt")
                public void testUnstableSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/unstableSmartCast.kt");
                }

                @TestMetadata("withSmartcast.kt")
                public void testWithSmartcast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/scopes/protectedVisibility/withSmartcast.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/script"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/sealed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sealed extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSealed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/sealed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DerivedTopLevel.kt")
            public void testDerivedTopLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/DerivedTopLevel.kt");
            }

            @TestMetadata("DoubleInner.kt")
            public void testDoubleInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/DoubleInner.kt");
            }

            @TestMetadata("ExhaustiveOnRoot.kt")
            public void testExhaustiveOnRoot() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveOnRoot.kt");
            }

            @TestMetadata("ExhaustiveOnTree.kt")
            public void testExhaustiveOnTree() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveOnTree.kt");
            }

            @TestMetadata("ExhaustiveOnTriangleStar.kt")
            public void testExhaustiveOnTriangleStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveOnTriangleStar.kt");
            }

            @TestMetadata("ExhaustiveWhen.kt")
            public void testExhaustiveWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhen.kt");
            }

            @TestMetadata("ExhaustiveWhenDoubleInner.kt")
            public void testExhaustiveWhenDoubleInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenDoubleInner.kt");
            }

            @TestMetadata("ExhaustiveWhenMultipleInner.kt")
            public void testExhaustiveWhenMultipleInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenMultipleInner.kt");
            }

            @TestMetadata("ExhaustiveWhenNegated.kt")
            public void testExhaustiveWhenNegated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenNegated.kt");
            }

            @TestMetadata("ExhaustiveWhenNegatedTwice.kt")
            public void testExhaustiveWhenNegatedTwice() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenNegatedTwice.kt");
            }

            @TestMetadata("ExhaustiveWhenOnNestedSealed.kt")
            public void testExhaustiveWhenOnNestedSealed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenOnNestedSealed.kt");
            }

            @TestMetadata("ExhaustiveWhenOnNullable.kt")
            public void testExhaustiveWhenOnNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenOnNullable.kt");
            }

            @TestMetadata("ExhaustiveWhenWithAdditionalMember.kt")
            public void testExhaustiveWhenWithAdditionalMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenWithAdditionalMember.kt");
            }

            @TestMetadata("ExhaustiveWhenWithElse.kt")
            public void testExhaustiveWhenWithElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenWithElse.kt");
            }

            @TestMetadata("Local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/Local.kt");
            }

            @TestMetadata("LocalSealed.kt")
            public void testLocalSealed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/LocalSealed.kt");
            }

            @TestMetadata("NestedSealed.kt")
            public void testNestedSealed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NestedSealed.kt");
            }

            @TestMetadata("NeverConstructed.kt")
            public void testNeverConstructed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverConstructed.kt");
            }

            @TestMetadata("NeverDerivedFromNested.kt")
            public void testNeverDerivedFromNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverDerivedFromNested.kt");
            }

            @TestMetadata("NeverEnum.kt")
            public void testNeverEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverEnum.kt");
            }

            @TestMetadata("NeverFinal.kt")
            public void testNeverFinal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverFinal.kt");
            }

            @TestMetadata("NeverInterface.kt")
            public void testNeverInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverInterface.kt");
            }

            @TestMetadata("NeverObject.kt")
            public void testNeverObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverObject.kt");
            }

            @TestMetadata("NeverOpen.kt")
            public void testNeverOpen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NeverOpen.kt");
            }

            @TestMetadata("NonExhaustiveWhen.kt")
            public void testNonExhaustiveWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhen.kt");
            }

            @TestMetadata("NonExhaustiveWhenNegated.kt")
            public void testNonExhaustiveWhenNegated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenNegated.kt");
            }

            @TestMetadata("NonExhaustiveWhenWithAdditionalCase.kt")
            public void testNonExhaustiveWhenWithAdditionalCase() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenWithAdditionalCase.kt");
            }

            @TestMetadata("NonExhaustiveWhenWithAnyCase.kt")
            public void testNonExhaustiveWhenWithAnyCase() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenWithAnyCase.kt");
            }

            @TestMetadata("NonPrivateConstructor.kt")
            public void testNonPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NonPrivateConstructor.kt");
            }

            @TestMetadata("NotFinal.kt")
            public void testNotFinal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/NotFinal.kt");
            }

            @TestMetadata("OperationWhen.kt")
            public void testOperationWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/OperationWhen.kt");
            }

            @TestMetadata("RedundantAbstract.kt")
            public void testRedundantAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/RedundantAbstract.kt");
            }

            @TestMetadata("TreeWhen.kt")
            public void testTreeWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/TreeWhen.kt");
            }

            @TestMetadata("TreeWhenFunctional.kt")
            public void testTreeWhenFunctional() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/TreeWhenFunctional.kt");
            }

            @TestMetadata("TreeWhenFunctionalNoIs.kt")
            public void testTreeWhenFunctionalNoIs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/TreeWhenFunctionalNoIs.kt");
            }

            @TestMetadata("WhenOnEmptySealed.kt")
            public void testWhenOnEmptySealed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/WhenOnEmptySealed.kt");
            }

            @TestMetadata("WithInterface.kt")
            public void testWithInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/sealed/WithInterface.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/secondaryConstructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SecondaryConstructors extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSecondaryConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/secondaryConstructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentsResolveInBodyAndDelegationCall.kt")
            public void testArgumentsResolveInBodyAndDelegationCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/argumentsResolveInBodyAndDelegationCall.kt");
            }

            @TestMetadata("classInitializersWithoutPrimary.kt")
            public void testClassInitializersWithoutPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/classInitializersWithoutPrimary.kt");
            }

            @TestMetadata("companionObjectScope.kt")
            public void testCompanionObjectScope() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/companionObjectScope.kt");
            }

            @TestMetadata("constructorCallType.kt")
            public void testConstructorCallType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/constructorCallType.kt");
            }

            @TestMetadata("constructorInObject.kt")
            public void testConstructorInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/constructorInObject.kt");
            }

            @TestMetadata("constructorInTrait.kt")
            public void testConstructorInTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/constructorInTrait.kt");
            }

            @TestMetadata("ctrsAnnotationResolve.kt")
            public void testCtrsAnnotationResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/ctrsAnnotationResolve.kt");
            }

            @TestMetadata("cyclicDelegationCalls.kt")
            public void testCyclicDelegationCalls() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/cyclicDelegationCalls.kt");
            }

            @TestMetadata("dataClasses.kt")
            public void testDataClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/dataClasses.kt");
            }

            @TestMetadata("dataFlowInDelegationCall.kt")
            public void testDataFlowInDelegationCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/dataFlowInDelegationCall.kt");
            }

            @TestMetadata("delegationByWithoutPrimary.kt")
            public void testDelegationByWithoutPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/delegationByWithoutPrimary.kt");
            }

            @TestMetadata("enums.kt")
            public void testEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/enums.kt");
            }

            @TestMetadata("errorsOnEmptyDelegationCall.kt")
            public void testErrorsOnEmptyDelegationCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/errorsOnEmptyDelegationCall.kt");
            }

            @TestMetadata("expectedPrimaryConstructorCall.kt")
            public void testExpectedPrimaryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/expectedPrimaryConstructorCall.kt");
            }

            @TestMetadata("generics.kt")
            public void testGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/generics.kt");
            }

            @TestMetadata("generics2.kt")
            public void testGenerics2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/generics2.kt");
            }

            @TestMetadata("generics3.kt")
            public void testGenerics3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/generics3.kt");
            }

            @TestMetadata("headerSupertypeInitialization.kt")
            public void testHeaderSupertypeInitialization() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerSupertypeInitialization.kt");
            }

            @TestMetadata("implicitSuperCallErrorsIfPrimary.kt")
            public void testImplicitSuperCallErrorsIfPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/implicitSuperCallErrorsIfPrimary.kt");
            }

            @TestMetadata("initializationFromOtherInstance.kt")
            public void testInitializationFromOtherInstance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/initializationFromOtherInstance.kt");
            }

            @TestMetadata("kt6992.kt")
            public void testKt6992() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/kt6992.kt");
            }

            @TestMetadata("kt6993.kt")
            public void testKt6993() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/kt6993.kt");
            }

            @TestMetadata("kt6994.kt")
            public void testKt6994() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/kt6994.kt");
            }

            @TestMetadata("lambdaInDelegation.kt")
            public void testLambdaInDelegation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/lambdaInDelegation.kt");
            }

            @TestMetadata("nestedExtendsInner.kt")
            public void testNestedExtendsInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/nestedExtendsInner.kt");
            }

            @TestMetadata("noDefaultIfEmptySecondary.kt")
            public void testNoDefaultIfEmptySecondary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/noDefaultIfEmptySecondary.kt");
            }

            @TestMetadata("noPrimaryConstructor.kt")
            public void testNoPrimaryConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/noPrimaryConstructor.kt");
            }

            @TestMetadata("noSupertypeInitWithSecondaryConstructors.kt")
            public void testNoSupertypeInitWithSecondaryConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/noSupertypeInitWithSecondaryConstructors.kt");
            }

            @TestMetadata("propertyInitializationWithPrimary.kt")
            public void testPropertyInitializationWithPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/propertyInitializationWithPrimary.kt");
            }

            @TestMetadata("propertyInitializationWithoutPrimary.kt")
            public void testPropertyInitializationWithoutPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/propertyInitializationWithoutPrimary.kt");
            }

            @TestMetadata("redeclarations.kt")
            public void testRedeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/redeclarations.kt");
            }

            @TestMetadata("redeclarationsOfConstructorsIgnored.kt")
            public void testRedeclarationsOfConstructorsIgnored() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/redeclarationsOfConstructorsIgnored.kt");
            }

            @TestMetadata("reportResolutionErrorOnImplicitOnce.kt")
            public void testReportResolutionErrorOnImplicitOnce() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/reportResolutionErrorOnImplicitOnce.kt");
            }

            @TestMetadata("resolvePropertyInitializerWithoutPrimary.kt")
            public void testResolvePropertyInitializerWithoutPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/resolvePropertyInitializerWithoutPrimary.kt");
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/return.kt");
            }

            @TestMetadata("superAnyNonEmpty.kt")
            public void testSuperAnyNonEmpty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/superAnyNonEmpty.kt");
            }

            @TestMetadata("superSecondaryNonExisting.kt")
            public void testSuperSecondaryNonExisting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/superSecondaryNonExisting.kt");
            }

            @TestMetadata("thisNonExisting.kt")
            public void testThisNonExisting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/thisNonExisting.kt");
            }

            @TestMetadata("unreachableCode.kt")
            public void testUnreachableCode() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/unreachableCode.kt");
            }

            @TestMetadata("useOfPropertiesWithPrimary.kt")
            public void testUseOfPropertiesWithPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/useOfPropertiesWithPrimary.kt");
            }

            @TestMetadata("useOfPropertiesWithoutPrimary.kt")
            public void testUseOfPropertiesWithoutPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/useOfPropertiesWithoutPrimary.kt");
            }

            @TestMetadata("valOrValAndModifiersInCtr.kt")
            public void testValOrValAndModifiersInCtr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/valOrValAndModifiersInCtr.kt");
            }

            @TestMetadata("varargsInDelegationCallToPrimary.kt")
            public void testVarargsInDelegationCallToPrimary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/varargsInDelegationCallToPrimary.kt");
            }

            @TestMetadata("varargsInDelegationCallToSecondary.kt")
            public void testVarargsInDelegationCallToSecondary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/secondaryConstructors/varargsInDelegationCallToSecondary.kt");
            }

            @TestMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HeaderCallChecker extends AbstractDiagnosticsUsingJavacTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("accessBaseGenericFromInnerExtendingSameBase.kt")
                public void testAccessBaseGenericFromInnerExtendingSameBase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseGenericFromInnerExtendingSameBase.kt");
                }

                @TestMetadata("accessBaseGenericFromInnerExtendingSameBase2.kt")
                public void testAccessBaseGenericFromInnerExtendingSameBase2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseGenericFromInnerExtendingSameBase2.kt");
                }

                @TestMetadata("accessBaseWithSameExtension.kt")
                public void testAccessBaseWithSameExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseWithSameExtension.kt");
                }

                @TestMetadata("accessGenericBaseWithSameExtension.kt")
                public void testAccessGenericBaseWithSameExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessGenericBaseWithSameExtension.kt");
                }

                public void testAllFilesPresentInHeaderCallChecker() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerInstanceCreation.kt")
                public void testInnerInstanceCreation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/innerInstanceCreation.kt");
                }

                @TestMetadata("lambdaAsArgument.kt")
                public void testLambdaAsArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/lambdaAsArgument.kt");
                }

                @TestMetadata("memberFunAccess.kt")
                public void testMemberFunAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/memberFunAccess.kt");
                }

                @TestMetadata("objectLiteralAsArgument.kt")
                public void testObjectLiteralAsArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/objectLiteralAsArgument.kt");
                }

                @TestMetadata("objectLiteralAsDefaultValueParameter.kt")
                public void testObjectLiteralAsDefaultValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/objectLiteralAsDefaultValueParameter.kt");
                }

                @TestMetadata("operatorCall.kt")
                public void testOperatorCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/operatorCall.kt");
                }

                @TestMetadata("passingInstance.kt")
                public void testPassingInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/passingInstance.kt");
                }

                @TestMetadata("propertyAccess.kt")
                public void testPropertyAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/propertyAccess.kt");
                }

                @TestMetadata("propertyAccessUnitialized.kt")
                public void testPropertyAccessUnitialized() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/propertyAccessUnitialized.kt");
                }

                @TestMetadata("superFunAccess.kt")
                public void testSuperFunAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superFunAccess.kt");
                }

                @TestMetadata("superFunAccessOverriden.kt")
                public void testSuperFunAccessOverriden() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superFunAccessOverriden.kt");
                }

                @TestMetadata("superPropertyAccess.kt")
                public void testSuperPropertyAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superPropertyAccess.kt");
                }

                @TestMetadata("thisAsExtensionReceiver.kt")
                public void testThisAsExtensionReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/thisAsExtensionReceiver.kt");
                }

                @TestMetadata("usingOuterInstance.kt")
                public void testUsingOuterInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/usingOuterInstance.kt");
                }

                @TestMetadata("usingOuterProperty.kt")
                public void testUsingOuterProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/usingOuterProperty.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/senselessComparison")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SenselessComparison extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSenselessComparison() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/senselessComparison"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noExplicitType.kt")
            public void testNoExplicitType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/senselessComparison/noExplicitType.kt");
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/senselessComparison/parenthesized.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/shadowing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Shadowing extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInShadowing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/shadowing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noNameShadowingForSimpleParameters.kt")
            public void testNoNameShadowingForSimpleParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/noNameShadowingForSimpleParameters.kt");
            }

            @TestMetadata("ShadowLambdaParameter.kt")
            public void testShadowLambdaParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowLambdaParameter.kt");
            }

            @TestMetadata("ShadowMultiDeclarationWithFunParameter.kt")
            public void testShadowMultiDeclarationWithFunParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowMultiDeclarationWithFunParameter.kt");
            }

            @TestMetadata("ShadowParameterInFunctionBody.kt")
            public void testShadowParameterInFunctionBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowParameterInFunctionBody.kt");
            }

            @TestMetadata("ShadowParameterInNestedBlockInFor.kt")
            public void testShadowParameterInNestedBlockInFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowParameterInNestedBlockInFor.kt");
            }

            @TestMetadata("ShadowPropertyInClosure.kt")
            public void testShadowPropertyInClosure() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInClosure.kt");
            }

            @TestMetadata("ShadowPropertyInFor.kt")
            public void testShadowPropertyInFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInFor.kt");
            }

            @TestMetadata("ShadowPropertyInFunction.kt")
            public void testShadowPropertyInFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInFunction.kt");
            }

            @TestMetadata("ShadowVariableInFor.kt")
            public void testShadowVariableInFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInFor.kt");
            }

            @TestMetadata("ShadowVariableInNestedBlock.kt")
            public void testShadowVariableInNestedBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedBlock.kt");
            }

            @TestMetadata("ShadowVariableInNestedClosure.kt")
            public void testShadowVariableInNestedClosure() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedClosure.kt");
            }

            @TestMetadata("ShadowVariableInNestedClosureParam.kt")
            public void testShadowVariableInNestedClosureParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedClosureParam.kt");
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/smartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SmartCasts extends AbstractDiagnosticsUsingJavacTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("afterBinaryExpr.kt")
            public void testAfterBinaryExpr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/afterBinaryExpr.kt");
            }

            public void testAllFilesPresentInSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/smartCasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("alwaysNull.kt")
            public void testAlwaysNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/alwaysNull.kt");
            }

            @TestMetadata("alwaysNullWithJava.kt")
            public void testAlwaysNullWithJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/alwaysNullWithJava.kt");
            }

            @TestMetadata("classObjectMember.kt")
            public void testClassObjectMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/classObjectMember.kt");
            }

            @TestMetadata("combineWithNoSelectorInfo.kt")
            public void testCombineWithNoSelectorInfo() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/combineWithNoSelectorInfo.kt");
            }

            @TestMetadata("comparisonUnderAnd.kt")
            public void testComparisonUnderAnd() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/comparisonUnderAnd.kt");
            }

            @TestMetadata("complexComparison.kt")
            public void testComplexComparison() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/complexComparison.kt");
            }

            @TestMetadata("complexConditionsWithExcl.kt")
            public void testComplexConditionsWithExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/complexConditionsWithExcl.kt");
            }

            @TestMetadata("dataFlowInfoForArguments.kt")
            public void testDataFlowInfoForArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/dataFlowInfoForArguments.kt");
            }

            @TestMetadata("doubleLambdaArgument.kt")
            public void testDoubleLambdaArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/doubleLambdaArgument.kt");
            }

            @TestMetadata("elvisExclExcl.kt")
            public void testElvisExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisExclExcl.kt");
            }

            @TestMetadata("elvisExclExclMerge.kt")
            public void testElvisExclExclMerge() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisExclExclMerge.kt");
            }

            @TestMetadata("elvisExclExclPlatform.kt")
            public void testElvisExclExclPlatform() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisExclExclPlatform.kt");
            }

            @TestMetadata("elvisExprNotNull.kt")
            public void testElvisExprNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisExprNotNull.kt");
            }

            @TestMetadata("elvisNothingRHS.kt")
            public void testElvisNothingRHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisNothingRHS.kt");
            }

            @TestMetadata("elvisRHS.kt")
            public void testElvisRHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/elvisRHS.kt");
            }

            @TestMetadata("enumEntryMembers_after.kt")
            public void testEnumEntryMembers_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/enumEntryMembers_after.kt");
            }

            @TestMetadata("enumEntryMembers_before.kt")
            public void testEnumEntryMembers_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/enumEntryMembers_before.kt");
            }

            @TestMetadata("equals.kt")
            public void testEquals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/equals.kt");
            }

            @TestMetadata("exclUnderAnd.kt")
            public void testExclUnderAnd() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/exclUnderAnd.kt");
            }

            @TestMetadata("explicitDefaultGetter.kt")
            public void testExplicitDefaultGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/explicitDefaultGetter.kt");
            }

            @TestMetadata("extensionSafeCall.kt")
            public void testExtensionSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/extensionSafeCall.kt");
            }

            @TestMetadata("fakeSmartCastOnEquality.kt")
            public void testFakeSmartCastOnEquality() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/fakeSmartCastOnEquality.kt");
            }

            @TestMetadata("falseReceiverSmartCast.kt")
            public void testFalseReceiverSmartCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/falseReceiverSmartCast.kt");
            }

            @TestMetadata("falseUnnecessaryCall.kt")
            public void testFalseUnnecessaryCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/falseUnnecessaryCall.kt");
            }

            @TestMetadata("fieldExclExcl.kt")
            public void testFieldExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/fieldExclExcl.kt");
            }

            @TestMetadata("fieldInGetter.kt")
            public void testFieldInGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/fieldInGetter.kt");
            }

            @TestMetadata("fieldPlus.kt")
            public void testFieldPlus() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/fieldPlus.kt");
            }

            @TestMetadata("genericIntersection.kt")
            public void testGenericIntersection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/genericIntersection.kt");
            }

            @TestMetadata("genericSet.kt")
            public void testGenericSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/genericSet.kt");
            }

            @TestMetadata("ifCascadeExprNotNull.kt")
            public void testIfCascadeExprNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/ifCascadeExprNotNull.kt");
            }

            @TestMetadata("ifExprInConditionNonNull.kt")
            public void testIfExprInConditionNonNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/ifExprInConditionNonNull.kt");
            }

            @TestMetadata("ifExprInWhenSubjectNonNull.kt")
            public void testIfExprInWhenSubjectNonNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/ifExprInWhenSubjectNonNull.kt");
            }

            @TestMetadata("ifExprNonNull.kt")
            public void testIfExprNonNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/ifExprNonNull.kt");
            }

            @TestMetadata("ifWhenExprNonNull.kt")
            public void testIfWhenExprNonNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/ifWhenExprNonNull.kt");
            }

            @TestMetadata("implicitReceiver.kt")
            public void testImplicitReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/implicitReceiver.kt");
            }

            @TestMetadata("implicitToGrandSon.kt")
            public void testImplicitToGrandSon() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/implicitToGrandSon.kt");
            }

            @TestMetadata("incDecToNull.kt")
            public void testIncDecToNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/incDecToNull.kt");
            }

            @TestMetadata("kt10232.kt")
            public void testKt10232() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt10232.kt");
            }

            @TestMetadata("kt10444.kt")
            public void testKt10444() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt10444.kt");
            }

            @TestMetadata("kt10483.kt")
            public void testKt10483() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt10483.kt");
            }

            @TestMetadata("kt1461.kt")
            public void testKt1461() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt1461.kt");
            }

            @TestMetadata("kt2422.kt")
            public void testKt2422() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt2422.kt");
            }

            @TestMetadata("kt27221.kt")
            public void testKt27221() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt27221.kt");
            }

            @TestMetadata("kt27221_2.kt")
            public void testKt27221_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt27221_2.kt");
            }

            @TestMetadata("kt27221_irrelevantClasses.kt")
            public void testKt27221_irrelevantClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt27221_irrelevantClasses.kt");
            }

            @TestMetadata("kt2865.kt")
            public void testKt2865() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt2865.kt");
            }

            @TestMetadata("kt3224.kt")
            public void testKt3224() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3224.kt");
            }

            @TestMetadata("kt3244.kt")
            public void testKt3244() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3244.kt");
            }

            @TestMetadata("kt3572.kt")
            public void testKt3572() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3572.kt");
            }

            @TestMetadata("kt3711.kt")
            public void testKt3711() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3711.kt");
            }

            @TestMetadata("kt3899.kt")
            public void testKt3899() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3899.kt");
            }

            @TestMetadata("kt3993.kt")
            public void testKt3993() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt3993.kt");
            }

            @TestMetadata("kt5427.kt")
            public void testKt5427() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt5427.kt");
            }

            @TestMetadata("kt5455.kt")
            public void testKt5455() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt5455.kt");
            }

            @TestMetadata("kt6819.kt")
            public void testKt6819() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt6819.kt");
            }

            @TestMetadata("kt7561.kt")
            public void testKt7561() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/kt7561.kt");
            }

            @TestMetadata("lambdaAndArgument.kt")
            public void testLambdaAndArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaAndArgument.kt");
            }

            @TestMetadata("lambdaAndArgumentFun.kt")
            public void testLambdaAndArgumentFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaAndArgumentFun.kt");
            }

            @TestMetadata("lambdaArgumentNoSubstitutedReturn.kt")
            public void testLambdaArgumentNoSubstitutedReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentNoSubstitutedReturn.kt");
            }

            @TestMetadata("lambdaArgumentWithBoundWithoutType.kt")
            public void testLambdaArgumentWithBoundWithoutType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithBoundWithoutType.kt");
            }

            @TestMetadata("lambdaArgumentWithExpectedGenericType.kt")
            public void testLambdaArgumentWithExpectedGenericType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithExpectedGenericType.kt");
            }

            @TestMetadata("lambdaArgumentWithoutType.kt")
            public void testLambdaArgumentWithoutType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithoutType.kt");
            }

            @TestMetadata("lambdaArgumentWithoutTypeIf.kt")
            public void testLambdaArgumentWithoutTypeIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithoutTypeIf.kt");
            }

            @TestMetadata("lambdaArgumentWithoutTypeIfMerge.kt")
            public void testLambdaArgumentWithoutTypeIfMerge() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithoutTypeIfMerge.kt");
            }

            @TestMetadata("lambdaArgumentWithoutTypeWhen.kt")
            public void testLambdaArgumentWithoutTypeWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaArgumentWithoutTypeWhen.kt");
            }

            @TestMetadata("lambdaCall.kt")
            public void testLambdaCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/smartCasts/lambdaCall.kt");
            }

            @TestMetadata("lambdaCallAnnotated.kt")
            public void testLambdaCallAnnotated() throws Exception {
                run