
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlayer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlayer>
#include <QVideoWidget>
#include <QGraphicsVideoItem>
#include <QMediaMetaData>
#include <QAudioOutput>
#include <QVideoSink>
#include <QMediaTimeRange>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlayer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlayer::staticMetaObject);
}


// int QMediaPlayer::activeAudioTrack()


static void _init_f_activeAudioTrack_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_activeAudioTrack_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->activeAudioTrack ());
}


// int QMediaPlayer::activeSubtitleTrack()


static void _init_f_activeSubtitleTrack_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_activeSubtitleTrack_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->activeSubtitleTrack ());
}


// int QMediaPlayer::activeVideoTrack()


static void _init_f_activeVideoTrack_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_activeVideoTrack_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->activeVideoTrack ());
}


// QAudioOutput *QMediaPlayer::audioOutput()


static void _init_f_audioOutput_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioOutput * > ();
}

static void _call_f_audioOutput_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioOutput * > ((QAudioOutput *)((QMediaPlayer *)cls)->audioOutput ());
}


// QList<QMediaMetaData> QMediaPlayer::audioTracks()


static void _init_f_audioTracks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QMediaMetaData> > ();
}

static void _call_f_audioTracks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QMediaMetaData> > ((QList<QMediaMetaData>)((QMediaPlayer *)cls)->audioTracks ());
}


// float QMediaPlayer::bufferProgress()


static void _init_f_bufferProgress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_bufferProgress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QMediaPlayer *)cls)->bufferProgress ());
}


// QMediaTimeRange QMediaPlayer::bufferedTimeRange()


static void _init_f_bufferedTimeRange_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaTimeRange > ();
}

static void _call_f_bufferedTimeRange_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaTimeRange > ((QMediaTimeRange)((QMediaPlayer *)cls)->bufferedTimeRange ());
}


// qint64 QMediaPlayer::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->duration ());
}


// QMediaPlayer::Error QMediaPlayer::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ((qt_gsi::Converter<QMediaPlayer::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::Error>(((QMediaPlayer *)cls)->error ()));
}


// QString QMediaPlayer::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaPlayer *)cls)->errorString ());
}


// bool QMediaPlayer::hasAudio()


static void _init_f_hasAudio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAudio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->hasAudio ());
}


// bool QMediaPlayer::hasVideo()


static void _init_f_hasVideo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasVideo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->hasVideo ());
}


// bool QMediaPlayer::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isAvailable ());
}


// bool QMediaPlayer::isSeekable()


static void _init_f_isSeekable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeekable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isSeekable ());
}


// int QMediaPlayer::loops()


static void _init_f_loops_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loops_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->loops ());
}


// QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()


static void _init_f_mediaStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_f_mediaStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::MediaStatus>(((QMediaPlayer *)cls)->mediaStatus ()));
}


// QMediaMetaData QMediaPlayer::metaData()


static void _init_f_metaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaMetaData > ();
}

static void _call_f_metaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaMetaData > ((QMediaMetaData)((QMediaPlayer *)cls)->metaData ());
}


// void QMediaPlayer::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->pause ();
}


// void QMediaPlayer::play()


static void _init_f_play_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_play_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->play ();
}


// double QMediaPlayer::playbackRate()


static void _init_f_playbackRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_playbackRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayer *)cls)->playbackRate ());
}


// QMediaPlayer::PlaybackState QMediaPlayer::playbackState()


static void _init_f_playbackState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type > ();
}

static void _call_f_playbackState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type > ((qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::PlaybackState>(((QMediaPlayer *)cls)->playbackState ()));
}


// qint64 QMediaPlayer::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->position ());
}


// void QMediaPlayer::setActiveAudioTrack(int index)


static void _init_f_setActiveAudioTrack_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveAudioTrack_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setActiveAudioTrack (arg1);
}


// void QMediaPlayer::setActiveSubtitleTrack(int index)


static void _init_f_setActiveSubtitleTrack_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveSubtitleTrack_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setActiveSubtitleTrack (arg1);
}


// void QMediaPlayer::setActiveVideoTrack(int index)


static void _init_f_setActiveVideoTrack_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveVideoTrack_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setActiveVideoTrack (arg1);
}


// void QMediaPlayer::setAudioOutput(QAudioOutput *output)


static void _init_f_setAudioOutput_1858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("output");
  decl->add_arg<QAudioOutput * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioOutput_1858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAudioOutput *arg1 = gsi::arg_reader<QAudioOutput * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setAudioOutput (arg1);
}


// void QMediaPlayer::setLoops(int loops)


static void _init_f_setLoops_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("loops");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLoops_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setLoops (arg1);
}


// void QMediaPlayer::setPlaybackRate(double rate)


static void _init_f_setPlaybackRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPlaybackRate (arg1);
}


// void QMediaPlayer::setPosition(qint64 position)


static void _init_f_setPosition_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPosition (arg1);
}


// void QMediaPlayer::setSource(const QUrl &source)


static void _init_f_setSource_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSource_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setSource (arg1);
}


// void QMediaPlayer::setSourceDevice(QIODevice *device, const QUrl &sourceUrl)


static void _init_f_setSourceDevice_3040 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceUrl", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSourceDevice_3040 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const QUrl &arg2 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setSourceDevice (arg1, arg2);
}


// void QMediaPlayer::setVideoOutput(QObject *)


static void _init_f_setVideoOutput_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVideoSink(QVideoSink *sink)


static void _init_f_setVideoSink_1611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sink");
  decl->add_arg<QVideoSink * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoSink_1611 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoSink *arg1 = gsi::arg_reader<QVideoSink * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoSink (arg1);
}


// QUrl QMediaPlayer::source()


static void _init_f_source_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_source_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaPlayer *)cls)->source ());
}


// const QIODevice *QMediaPlayer::sourceDevice()


static void _init_f_sourceDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_f_sourceDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayer *)cls)->sourceDevice ());
}


// void QMediaPlayer::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->stop ();
}


// QList<QMediaMetaData> QMediaPlayer::subtitleTracks()


static void _init_f_subtitleTracks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QMediaMetaData> > ();
}

static void _call_f_subtitleTracks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QMediaMetaData> > ((QList<QMediaMetaData>)((QMediaPlayer *)cls)->subtitleTracks ());
}


// QObject *QMediaPlayer::videoOutput()


static void _init_f_videoOutput_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_videoOutput_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayer *)cls)->videoOutput ());
}


// QVideoSink *QMediaPlayer::videoSink()


static void _init_f_videoSink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoSink * > ();
}

static void _call_f_videoSink_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoSink * > ((QVideoSink *)((QMediaPlayer *)cls)->videoSink ());
}


// QList<QMediaMetaData> QMediaPlayer::videoTracks()


static void _init_f_videoTracks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QMediaMetaData> > ();
}

static void _call_f_videoTracks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QMediaMetaData> > ((QList<QMediaMetaData>)((QMediaPlayer *)cls)->videoTracks ());
}


// static QString QMediaPlayer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayer::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaPlayer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":activeAudioTrack", "@brief Method int QMediaPlayer::activeAudioTrack()\n", true, &_init_f_activeAudioTrack_c0, &_call_f_activeAudioTrack_c0);
  methods += new qt_gsi::GenericMethod (":activeSubtitleTrack", "@brief Method int QMediaPlayer::activeSubtitleTrack()\n", true, &_init_f_activeSubtitleTrack_c0, &_call_f_activeSubtitleTrack_c0);
  methods += new qt_gsi::GenericMethod (":activeVideoTrack", "@brief Method int QMediaPlayer::activeVideoTrack()\n", true, &_init_f_activeVideoTrack_c0, &_call_f_activeVideoTrack_c0);
  methods += new qt_gsi::GenericMethod (":audioOutput", "@brief Method QAudioOutput *QMediaPlayer::audioOutput()\n", true, &_init_f_audioOutput_c0, &_call_f_audioOutput_c0);
  methods += new qt_gsi::GenericMethod (":audioTracks", "@brief Method QList<QMediaMetaData> QMediaPlayer::audioTracks()\n", true, &_init_f_audioTracks_c0, &_call_f_audioTracks_c0);
  methods += new qt_gsi::GenericMethod (":bufferProgress", "@brief Method float QMediaPlayer::bufferProgress()\n", true, &_init_f_bufferProgress_c0, &_call_f_bufferProgress_c0);
  methods += new qt_gsi::GenericMethod ("bufferedTimeRange", "@brief Method QMediaTimeRange QMediaPlayer::bufferedTimeRange()\n", true, &_init_f_bufferedTimeRange_c0, &_call_f_bufferedTimeRange_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method qint64 QMediaPlayer::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QMediaPlayer::Error QMediaPlayer::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod (":errorString", "@brief Method QString QMediaPlayer::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod (":hasAudio", "@brief Method bool QMediaPlayer::hasAudio()\n", true, &_init_f_hasAudio_c0, &_call_f_hasAudio_c0);
  methods += new qt_gsi::GenericMethod (":hasVideo", "@brief Method bool QMediaPlayer::hasVideo()\n", true, &_init_f_hasVideo_c0, &_call_f_hasVideo_c0);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QMediaPlayer::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isSeekable?|:seekable", "@brief Method bool QMediaPlayer::isSeekable()\n", true, &_init_f_isSeekable_c0, &_call_f_isSeekable_c0);
  methods += new qt_gsi::GenericMethod (":loops", "@brief Method int QMediaPlayer::loops()\n", true, &_init_f_loops_c0, &_call_f_loops_c0);
  methods += new qt_gsi::GenericMethod (":mediaStatus", "@brief Method QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()\n", true, &_init_f_mediaStatus_c0, &_call_f_mediaStatus_c0);
  methods += new qt_gsi::GenericMethod (":metaData", "@brief Method QMediaMetaData QMediaPlayer::metaData()\n", true, &_init_f_metaData_c0, &_call_f_metaData_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaPlayer::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Method void QMediaPlayer::play()\n", false, &_init_f_play_0, &_call_f_play_0);
  methods += new qt_gsi::GenericMethod (":playbackRate", "@brief Method double QMediaPlayer::playbackRate()\n", true, &_init_f_playbackRate_c0, &_call_f_playbackRate_c0);
  methods += new qt_gsi::GenericMethod (":playbackState", "@brief Method QMediaPlayer::PlaybackState QMediaPlayer::playbackState()\n", true, &_init_f_playbackState_c0, &_call_f_playbackState_c0);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method qint64 QMediaPlayer::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("setActiveAudioTrack|activeAudioTrack=", "@brief Method void QMediaPlayer::setActiveAudioTrack(int index)\n", false, &_init_f_setActiveAudioTrack_767, &_call_f_setActiveAudioTrack_767);
  methods += new qt_gsi::GenericMethod ("setActiveSubtitleTrack|activeSubtitleTrack=", "@brief Method void QMediaPlayer::setActiveSubtitleTrack(int index)\n", false, &_init_f_setActiveSubtitleTrack_767, &_call_f_setActiveSubtitleTrack_767);
  methods += new qt_gsi::GenericMethod ("setActiveVideoTrack|activeVideoTrack=", "@brief Method void QMediaPlayer::setActiveVideoTrack(int index)\n", false, &_init_f_setActiveVideoTrack_767, &_call_f_setActiveVideoTrack_767);
  methods += new qt_gsi::GenericMethod ("setAudioOutput|audioOutput=", "@brief Method void QMediaPlayer::setAudioOutput(QAudioOutput *output)\n", false, &_init_f_setAudioOutput_1858, &_call_f_setAudioOutput_1858);
  methods += new qt_gsi::GenericMethod ("setLoops|loops=", "@brief Method void QMediaPlayer::setLoops(int loops)\n", false, &_init_f_setLoops_767, &_call_f_setLoops_767);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate|playbackRate=", "@brief Method void QMediaPlayer::setPlaybackRate(double rate)\n", false, &_init_f_setPlaybackRate_1071, &_call_f_setPlaybackRate_1071);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QMediaPlayer::setPosition(qint64 position)\n", false, &_init_f_setPosition_986, &_call_f_setPosition_986);
  methods += new qt_gsi::GenericMethod ("setSource|source=", "@brief Method void QMediaPlayer::setSource(const QUrl &source)\n", false, &_init_f_setSource_1701, &_call_f_setSource_1701);
  methods += new qt_gsi::GenericMethod ("setSourceDevice", "@brief Method void QMediaPlayer::setSourceDevice(QIODevice *device, const QUrl &sourceUrl)\n", false, &_init_f_setSourceDevice_3040, &_call_f_setSourceDevice_3040);
  methods += new qt_gsi::GenericMethod ("setVideoOutput|videoOutput=", "@brief Method void QMediaPlayer::setVideoOutput(QObject *)\n", false, &_init_f_setVideoOutput_1302, &_call_f_setVideoOutput_1302);
  methods += new qt_gsi::GenericMethod ("setVideoSink|videoSink=", "@brief Method void QMediaPlayer::setVideoSink(QVideoSink *sink)\n", false, &_init_f_setVideoSink_1611, &_call_f_setVideoSink_1611);
  methods += new qt_gsi::GenericMethod (":source", "@brief Method QUrl QMediaPlayer::source()\n", true, &_init_f_source_c0, &_call_f_source_c0);
  methods += new qt_gsi::GenericMethod (":sourceDevice", "@brief Method const QIODevice *QMediaPlayer::sourceDevice()\n", true, &_init_f_sourceDevice_c0, &_call_f_sourceDevice_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaPlayer::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":subtitleTracks", "@brief Method QList<QMediaMetaData> QMediaPlayer::subtitleTracks()\n", true, &_init_f_subtitleTracks_c0, &_call_f_subtitleTracks_c0);
  methods += new qt_gsi::GenericMethod (":videoOutput", "@brief Method QObject *QMediaPlayer::videoOutput()\n", true, &_init_f_videoOutput_c0, &_call_f_videoOutput_c0);
  methods += new qt_gsi::GenericMethod (":videoSink", "@brief Method QVideoSink *QMediaPlayer::videoSink()\n", true, &_init_f_videoSink_c0, &_call_f_videoSink_c0);
  methods += new qt_gsi::GenericMethod (":videoTracks", "@brief Method QList<QMediaMetaData> QMediaPlayer::videoTracks()\n", true, &_init_f_videoTracks_c0, &_call_f_videoTracks_c0);
  methods += gsi::qt_signal ("activeTracksChanged()", "activeTracksChanged", "@brief Signal declaration for QMediaPlayer::activeTracksChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("audioOutputChanged()", "audioOutputChanged", "@brief Signal declaration for QMediaPlayer::audioOutputChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("bufferProgressChanged(float)", "bufferProgressChanged", gsi::arg("progress"), "@brief Signal declaration for QMediaPlayer::bufferProgressChanged(float progress)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMediaPlayer::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("duration"), "@brief Signal declaration for QMediaPlayer::durationChanged(qint64 duration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("errorChanged()", "errorChanged", "@brief Signal declaration for QMediaPlayer::errorChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::Error>::target_type &, const QString & > ("errorOccurred(QMediaPlayer::Error, const QString &)", "errorOccurred", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QMediaPlayer::errorOccurred(QMediaPlayer::Error error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("hasAudioChanged(bool)", "hasAudioChanged", gsi::arg("available"), "@brief Signal declaration for QMediaPlayer::hasAudioChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("hasVideoChanged(bool)", "hasVideoChanged", gsi::arg("videoAvailable"), "@brief Signal declaration for QMediaPlayer::hasVideoChanged(bool videoAvailable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("loopsChanged()", "loopsChanged", "@brief Signal declaration for QMediaPlayer::loopsChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > ("mediaStatusChanged(QMediaPlayer::MediaStatus)", "mediaStatusChanged", gsi::arg("status"), "@brief Signal declaration for QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("metaDataChanged()", "metaDataChanged", "@brief Signal declaration for QMediaPlayer::metaDataChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMediaPlayer::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("playbackRateChanged(double)", "playbackRateChanged", gsi::arg("rate"), "@brief Signal declaration for QMediaPlayer::playbackRateChanged(double rate)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type & > ("playbackStateChanged(QMediaPlayer::PlaybackState)", "playbackStateChanged", gsi::arg("newState"), "@brief Signal declaration for QMediaPlayer::playbackStateChanged(QMediaPlayer::PlaybackState newState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("positionChanged(qint64)", "positionChanged", gsi::arg("position"), "@brief Signal declaration for QMediaPlayer::positionChanged(qint64 position)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("seekableChanged(bool)", "seekableChanged", gsi::arg("seekable"), "@brief Signal declaration for QMediaPlayer::seekableChanged(bool seekable)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("sourceChanged(const QUrl &)", "sourceChanged", gsi::arg("media"), "@brief Signal declaration for QMediaPlayer::sourceChanged(const QUrl &media)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("tracksChanged()", "tracksChanged", "@brief Signal declaration for QMediaPlayer::tracksChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("videoOutputChanged()", "videoOutputChanged", "@brief Signal declaration for QMediaPlayer::videoOutputChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlayer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaPlayer> decl_QMediaPlayer (qtdecl_QObject (), "QtMultimedia", "QMediaPlayer_Native",
  methods_QMediaPlayer (),
  "@hide\n@alias QMediaPlayer");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer () { return decl_QMediaPlayer; }

}


class QMediaPlayer_Adaptor : public QMediaPlayer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlayer_Adaptor();

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent)
  QMediaPlayer_Adaptor() : QMediaPlayer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent)
  QMediaPlayer_Adaptor(QObject *parent) : QMediaPlayer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlayer_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlayer::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlayer::receivers(const char *signal)
  int fp_QMediaPlayer_receivers_c1731 (const char *signal) const {
    return QMediaPlayer::receivers(signal);
  }

  //  [expose] QObject *QMediaPlayer::sender()
  QObject * fp_QMediaPlayer_sender_c0 () const {
    return QMediaPlayer::sender();
  }

  //  [expose] int QMediaPlayer::senderSignalIndex()
  int fp_QMediaPlayer_senderSignalIndex_c0 () const {
    return QMediaPlayer::senderSignalIndex();
  }

  //  [emitter impl] void QMediaPlayer::activeTracksChanged()
  void emitter_QMediaPlayer_activeTracksChanged_0()
  {
    emit QMediaPlayer::activeTracksChanged();
  }

  //  [emitter impl] void QMediaPlayer::audioOutputChanged()
  void emitter_QMediaPlayer_audioOutputChanged_0()
  {
    emit QMediaPlayer::audioOutputChanged();
  }

  //  [emitter impl] void QMediaPlayer::bufferProgressChanged(float progress)
  void emitter_QMediaPlayer_bufferProgressChanged_970(float progress)
  {
    emit QMediaPlayer::bufferProgressChanged(progress);
  }

  //  [emitter impl] void QMediaPlayer::destroyed(QObject *)
  void emitter_QMediaPlayer_destroyed_1302(QObject *arg1)
  {
    emit QMediaPlayer::destroyed(arg1);
  }

  //  [emitter impl] void QMediaPlayer::durationChanged(qint64 duration)
  void emitter_QMediaPlayer_durationChanged_986(qint64 duration)
  {
    emit QMediaPlayer::durationChanged(duration);
  }

  //  [emitter impl] void QMediaPlayer::errorChanged()
  void emitter_QMediaPlayer_errorChanged_0()
  {
    emit QMediaPlayer::errorChanged();
  }

  //  [emitter impl] void QMediaPlayer::errorOccurred(QMediaPlayer::Error error, const QString &errorString)
  void emitter_QMediaPlayer_errorOccurred_4173(QMediaPlayer::Error error, const QString &errorString)
  {
    emit QMediaPlayer::errorOccurred(error, errorString);
  }

  //  [adaptor impl] bool QMediaPlayer::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaPlayer::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlayer_Adaptor, bool, QEvent *>(&QMediaPlayer_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaPlayer::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaPlayer::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlayer_Adaptor, bool, QObject *, QEvent *>(&QMediaPlayer_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaPlayer::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QMediaPlayer::hasAudioChanged(bool available)
  void emitter_QMediaPlayer_hasAudioChanged_864(bool available)
  {
    emit QMediaPlayer::hasAudioChanged(available);
  }

  //  [emitter impl] void QMediaPlayer::hasVideoChanged(bool videoAvailable)
  void emitter_QMediaPlayer_hasVideoChanged_864(bool videoAvailable)
  {
    emit QMediaPlayer::hasVideoChanged(videoAvailable);
  }

  //  [emitter impl] void QMediaPlayer::loopsChanged()
  void emitter_QMediaPlayer_loopsChanged_0()
  {
    emit QMediaPlayer::loopsChanged();
  }

  //  [emitter impl] void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)
  void emitter_QMediaPlayer_mediaStatusChanged_2858(QMediaPlayer::MediaStatus status)
  {
    emit QMediaPlayer::mediaStatusChanged(status);
  }

  //  [emitter impl] void QMediaPlayer::metaDataChanged()
  void emitter_QMediaPlayer_metaDataChanged_0()
  {
    emit QMediaPlayer::metaDataChanged();
  }

  //  [emitter impl] void QMediaPlayer::objectNameChanged(const QString &objectName)
  void emitter_QMediaPlayer_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMediaPlayer::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QMediaPlayer::playbackRateChanged(double rate)
  void emitter_QMediaPlayer_playbackRateChanged_1071(double rate)
  {
    emit QMediaPlayer::playbackRateChanged(rate);
  }

  //  [emitter impl] void QMediaPlayer::playbackStateChanged(QMediaPlayer::PlaybackState newState)
  void emitter_QMediaPlayer_playbackStateChanged_3054(QMediaPlayer::PlaybackState newState)
  {
    emit QMediaPlayer::playbackStateChanged(newState);
  }

  //  [emitter impl] void QMediaPlayer::positionChanged(qint64 position)
  void emitter_QMediaPlayer_positionChanged_986(qint64 position)
  {
    emit QMediaPlayer::positionChanged(position);
  }

  //  [emitter impl] void QMediaPlayer::seekableChanged(bool seekable)
  void emitter_QMediaPlayer_seekableChanged_864(bool seekable)
  {
    emit QMediaPlayer::seekableChanged(seekable);
  }

  //  [emitter impl] void QMediaPlayer::sourceChanged(const QUrl &media)
  void emitter_QMediaPlayer_sourceChanged_1701(const QUrl &media)
  {
    emit QMediaPlayer::sourceChanged(media);
  }

  //  [emitter impl] void QMediaPlayer::tracksChanged()
  void emitter_QMediaPlayer_tracksChanged_0()
  {
    emit QMediaPlayer::tracksChanged();
  }

  //  [emitter impl] void QMediaPlayer::videoOutputChanged()
  void emitter_QMediaPlayer_videoOutputChanged_0()
  {
    emit QMediaPlayer::videoOutputChanged();
  }

  //  [adaptor impl] void QMediaPlayer::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaPlayer::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlayer_Adaptor, QChildEvent *>(&QMediaPlayer_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaPlayer::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayer::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaPlayer::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlayer_Adaptor, QEvent *>(&QMediaPlayer_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaPlayer::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlayer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlayer_Adaptor, const QMetaMethod &>(&QMediaPlayer_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlayer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaPlayer::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaPlayer::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlayer_Adaptor, QTimerEvent *>(&QMediaPlayer_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaPlayer::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlayer_Adaptor::~QMediaPlayer_Adaptor() { }

//  Constructor QMediaPlayer::QMediaPlayer(QObject *parent) (adaptor class)

static void _init_ctor_QMediaPlayer_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMediaPlayer_Adaptor> ();
}

static void _call_ctor_QMediaPlayer_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMediaPlayer_Adaptor *> (new QMediaPlayer_Adaptor (arg1));
}


// emitter void QMediaPlayer::activeTracksChanged()

static void _init_emitter_activeTracksChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_activeTracksChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_activeTracksChanged_0 ();
}


// emitter void QMediaPlayer::audioOutputChanged()

static void _init_emitter_audioOutputChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_audioOutputChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_audioOutputChanged_0 ();
}


// emitter void QMediaPlayer::bufferProgressChanged(float progress)

static void _init_emitter_bufferProgressChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("progress");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bufferProgressChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_bufferProgressChanged_970 (arg1);
}


// void QMediaPlayer::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaPlayer::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMediaPlayer::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_destroyed_1302 (arg1);
}


// void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QMediaPlayer::durationChanged(qint64 duration)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_durationChanged_986 (arg1);
}


// emitter void QMediaPlayer::errorChanged()

static void _init_emitter_errorChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_errorChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_errorChanged_0 ();
}


// emitter void QMediaPlayer::errorOccurred(QMediaPlayer::Error error, const QString &errorString)

static void _init_emitter_errorOccurred_4173 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_errorOccurred_4173 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_errorOccurred_4173 (arg1, arg2);
}


// bool QMediaPlayer::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QMediaPlayer::hasAudioChanged(bool available)

static void _init_emitter_hasAudioChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_hasAudioChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_hasAudioChanged_864 (arg1);
}


// emitter void QMediaPlayer::hasVideoChanged(bool videoAvailable)

static void _init_emitter_hasVideoChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_hasVideoChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_hasVideoChanged_864 (arg1);
}


// exposed bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_isSignalConnected_c2394 (arg1));
}


// emitter void QMediaPlayer::loopsChanged()

static void _init_emitter_loopsChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_loopsChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_loopsChanged_0 ();
}


// emitter void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)

static void _init_emitter_mediaStatusChanged_2858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mediaStatusChanged_2858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_mediaStatusChanged_2858 (arg1);
}


// emitter void QMediaPlayer::metaDataChanged()

static void _init_emitter_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_metaDataChanged_0 ();
}


// emitter void QMediaPlayer::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_objectNameChanged_4567 (arg1);
}


// emitter void QMediaPlayer::playbackRateChanged(double rate)

static void _init_emitter_playbackRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_playbackRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_playbackRateChanged_1071 (arg1);
}


// emitter void QMediaPlayer::playbackStateChanged(QMediaPlayer::PlaybackState newState)

static void _init_emitter_playbackStateChanged_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_playbackStateChanged_3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::PlaybackState>::target_type & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_playbackStateChanged_3054 (arg1);
}


// emitter void QMediaPlayer::positionChanged(qint64 position)

static void _init_emitter_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_positionChanged_986 (arg1);
}


// exposed int QMediaPlayer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_receivers_c1731 (arg1));
}


// emitter void QMediaPlayer::seekableChanged(bool seekable)

static void _init_emitter_seekableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seekable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_seekableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_seekableChanged_864 (arg1);
}


// exposed QObject *QMediaPlayer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_sender_c0 ());
}


// exposed int QMediaPlayer::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_senderSignalIndex_c0 ());
}


// emitter void QMediaPlayer::sourceChanged(const QUrl &media)

static void _init_emitter_sourceChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sourceChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_sourceChanged_1701 (arg1);
}


// void QMediaPlayer::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QMediaPlayer::tracksChanged()

static void _init_emitter_tracksChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_tracksChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_tracksChanged_0 ();
}


// emitter void QMediaPlayer::videoOutputChanged()

static void _init_emitter_videoOutputChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_videoOutputChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaPlayer_Adaptor *)cls)->emitter_QMediaPlayer_videoOutputChanged_0 ();
}


namespace gsi
{

gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer ();

static gsi::Methods methods_QMediaPlayer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlayer::QMediaPlayer(QObject *parent)\nThis method creates an object of class QMediaPlayer.", &_init_ctor_QMediaPlayer_Adaptor_1302, &_call_ctor_QMediaPlayer_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_activeTracksChanged", "@brief Emitter for signal void QMediaPlayer::activeTracksChanged()\nCall this method to emit this signal.", false, &_init_emitter_activeTracksChanged_0, &_call_emitter_activeTracksChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_audioOutputChanged", "@brief Emitter for signal void QMediaPlayer::audioOutputChanged()\nCall this method to emit this signal.", false, &_init_emitter_audioOutputChanged_0, &_call_emitter_audioOutputChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_bufferProgressChanged", "@brief Emitter for signal void QMediaPlayer::bufferProgressChanged(float progress)\nCall this method to emit this signal.", false, &_init_emitter_bufferProgressChanged_970, &_call_emitter_bufferProgressChanged_970);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlayer::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlayer::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMediaPlayer::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QMediaPlayer::durationChanged(qint64 duration)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_errorChanged", "@brief Emitter for signal void QMediaPlayer::errorChanged()\nCall this method to emit this signal.", false, &_init_emitter_errorChanged_0, &_call_emitter_errorChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_errorOccurred", "@brief Emitter for signal void QMediaPlayer::errorOccurred(QMediaPlayer::Error error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_errorOccurred_4173, &_call_emitter_errorOccurred_4173);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlayer::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlayer::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_hasAudioChanged", "@brief Emitter for signal void QMediaPlayer::hasAudioChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_hasAudioChanged_864, &_call_emitter_hasAudioChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_hasVideoChanged", "@brief Emitter for signal void QMediaPlayer::hasVideoChanged(bool videoAvailable)\nCall this method to emit this signal.", false, &_init_emitter_hasVideoChanged_864, &_call_emitter_hasVideoChanged_864);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_loopsChanged", "@brief Emitter for signal void QMediaPlayer::loopsChanged()\nCall this method to emit this signal.", false, &_init_emitter_loopsChanged_0, &_call_emitter_loopsChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_mediaStatusChanged", "@brief Emitter for signal void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)\nCall this method to emit this signal.", false, &_init_emitter_mediaStatusChanged_2858, &_call_emitter_mediaStatusChanged_2858);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged", "@brief Emitter for signal void QMediaPlayer::metaDataChanged()\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_0, &_call_emitter_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMediaPlayer::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_playbackRateChanged", "@brief Emitter for signal void QMediaPlayer::playbackRateChanged(double rate)\nCall this method to emit this signal.", false, &_init_emitter_playbackRateChanged_1071, &_call_emitter_playbackRateChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_playbackStateChanged", "@brief Emitter for signal void QMediaPlayer::playbackStateChanged(QMediaPlayer::PlaybackState newState)\nCall this method to emit this signal.", false, &_init_emitter_playbackStateChanged_3054, &_call_emitter_playbackStateChanged_3054);
  methods += new qt_gsi::GenericMethod ("emit_positionChanged", "@brief Emitter for signal void QMediaPlayer::positionChanged(qint64 position)\nCall this method to emit this signal.", false, &_init_emitter_positionChanged_986, &_call_emitter_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlayer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_seekableChanged", "@brief Emitter for signal void QMediaPlayer::seekableChanged(bool seekable)\nCall this method to emit this signal.", false, &_init_emitter_seekableChanged_864, &_call_emitter_seekableChanged_864);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlayer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlayer::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_sourceChanged", "@brief Emitter for signal void QMediaPlayer::sourceChanged(const QUrl &media)\nCall this method to emit this signal.", false, &_init_emitter_sourceChanged_1701, &_call_emitter_sourceChanged_1701);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlayer::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_tracksChanged", "@brief Emitter for signal void QMediaPlayer::tracksChanged()\nCall this method to emit this signal.", false, &_init_emitter_tracksChanged_0, &_call_emitter_tracksChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_videoOutputChanged", "@brief Emitter for signal void QMediaPlayer::videoOutputChanged()\nCall this method to emit this signal.", false, &_init_emitter_videoOutputChanged_0, &_call_emitter_videoOutputChanged_0);
  return methods;
}

gsi::Class<QMediaPlayer_Adaptor> decl_QMediaPlayer_Adaptor (qtdecl_QMediaPlayer (), "QtMultimedia", "QMediaPlayer",
  methods_QMediaPlayer_Adaptor (),
  "@qt\n@brief Binding of QMediaPlayer");

}


//  Implementation of the enum wrapper class for QMediaPlayer::Error
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::Error> decl_QMediaPlayer_Error_Enum ("QtMultimedia", "QMediaPlayer_Error",
    gsi::enum_const ("NoError", QMediaPlayer::NoError, "@brief Enum constant QMediaPlayer::NoError") +
    gsi::enum_const ("ResourceError", QMediaPlayer::ResourceError, "@brief Enum constant QMediaPlayer::ResourceError") +
    gsi::enum_const ("FormatError", QMediaPlayer::FormatError, "@brief Enum constant QMediaPlayer::FormatError") +
    gsi::enum_const ("NetworkError", QMediaPlayer::NetworkError, "@brief Enum constant QMediaPlayer::NetworkError") +
    gsi::enum_const ("AccessDeniedError", QMediaPlayer::AccessDeniedError, "@brief Enum constant QMediaPlayer::AccessDeniedError"),
  "@qt\n@brief This class represents the QMediaPlayer::Error enum");

static gsi::QFlagsClass<QMediaPlayer::Error > decl_QMediaPlayer_Error_Enums ("QtMultimedia", "QMediaPlayer_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_Error_Enum_in_parent (decl_QMediaPlayer_Error_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enum_as_child (decl_QMediaPlayer_Error_Enum, "Error");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enums_as_child (decl_QMediaPlayer_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaPlayer::MediaStatus
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::MediaStatus> decl_QMediaPlayer_MediaStatus_Enum ("QtMultimedia", "QMediaPlayer_MediaStatus",
    gsi::enum_const ("NoMedia", QMediaPlayer::NoMedia, "@brief Enum constant QMediaPlayer::NoMedia") +
    gsi::enum_const ("LoadingMedia", QMediaPlayer::LoadingMedia, "@brief Enum constant QMediaPlayer::LoadingMedia") +
    gsi::enum_const ("LoadedMedia", QMediaPlayer::LoadedMedia, "@brief Enum constant QMediaPlayer::LoadedMedia") +
    gsi::enum_const ("StalledMedia", QMediaPlayer::StalledMedia, "@brief Enum constant QMediaPlayer::StalledMedia") +
    gsi::enum_const ("BufferingMedia", QMediaPlayer::BufferingMedia, "@brief Enum constant QMediaPlayer::BufferingMedia") +
    gsi::enum_const ("BufferedMedia", QMediaPlayer::BufferedMedia, "@brief Enum constant QMediaPlayer::BufferedMedia") +
    gsi::enum_const ("EndOfMedia", QMediaPlayer::EndOfMedia, "@brief Enum constant QMediaPlayer::EndOfMedia") +
    gsi::enum_const ("InvalidMedia", QMediaPlayer::InvalidMedia, "@brief Enum constant QMediaPlayer::InvalidMedia"),
  "@qt\n@brief This class represents the QMediaPlayer::MediaStatus enum");

static gsi::QFlagsClass<QMediaPlayer::MediaStatus > decl_QMediaPlayer_MediaStatus_Enums ("QtMultimedia", "QMediaPlayer_QFlags_MediaStatus",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::MediaStatus> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_MediaStatus_Enum_in_parent (decl_QMediaPlayer_MediaStatus_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enum_as_child (decl_QMediaPlayer_MediaStatus_Enum, "MediaStatus");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enums_as_child (decl_QMediaPlayer_MediaStatus_Enums, "QFlags_MediaStatus");

}


//  Implementation of the enum wrapper class for QMediaPlayer::PlaybackState
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::PlaybackState> decl_QMediaPlayer_PlaybackState_Enum ("QtMultimedia", "QMediaPlayer_PlaybackState",
    gsi::enum_const ("StoppedState", QMediaPlayer::StoppedState, "@brief Enum constant QMediaPlayer::StoppedState") +
    gsi::enum_const ("PlayingState", QMediaPlayer::PlayingState, "@brief Enum constant QMediaPlayer::PlayingState") +
    gsi::enum_const ("PausedState", QMediaPlayer::PausedState, "@brief Enum constant QMediaPlayer::PausedState"),
  "@qt\n@brief This class represents the QMediaPlayer::PlaybackState enum");

static gsi::QFlagsClass<QMediaPlayer::PlaybackState > decl_QMediaPlayer_PlaybackState_Enums ("QtMultimedia", "QMediaPlayer_QFlags_PlaybackState",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::PlaybackState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_PlaybackState_Enum_in_parent (decl_QMediaPlayer_PlaybackState_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_PlaybackState_Enum_as_child (decl_QMediaPlayer_PlaybackState_Enum, "PlaybackState");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_PlaybackState_Enums_as_child (decl_QMediaPlayer_PlaybackState_Enums, "QFlags_PlaybackState");

}

