
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSortFilterProxyModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSortFilterProxyModel>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QItemSelection>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QModelRoleDataSpan>
#include <QObject>
#include <QPersistentModelIndex>
#include <QRegularExpression>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSortFilterProxyModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSortFilterProxyModel::staticMetaObject);
}


// bool QSortFilterProxyModel::autoAcceptChildRows()


static void _init_f_autoAcceptChildRows_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoAcceptChildRows_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->autoAcceptChildRows ());
}


// QModelIndex QSortFilterProxyModel::buddy(const QModelIndex &index)


static void _init_f_buddy_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_buddy_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->buddy (arg1));
}


// bool QSortFilterProxyModel::canFetchMore(const QModelIndex &parent)


static void _init_f_canFetchMore_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_canFetchMore_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->canFetchMore (arg1));
}


// int QSortFilterProxyModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->columnCount (arg1));
}


// QVariant QSortFilterProxyModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSortFilterProxyModel *)cls)->data (arg1, arg2));
}


// bool QSortFilterProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::DropAction>::target_type & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg5 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}


// bool QSortFilterProxyModel::dynamicSortFilter()


static void _init_f_dynamicSortFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_dynamicSortFilter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->dynamicSortFilter ());
}


// void QSortFilterProxyModel::fetchMore(const QModelIndex &parent)


static void _init_f_fetchMore_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fetchMore_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->fetchMore (arg1);
}


// Qt::CaseSensitivity QSortFilterProxyModel::filterCaseSensitivity()


static void _init_f_filterCaseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_filterCaseSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QSortFilterProxyModel *)cls)->filterCaseSensitivity ()));
}


// int QSortFilterProxyModel::filterKeyColumn()


static void _init_f_filterKeyColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_filterKeyColumn_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->filterKeyColumn ());
}


// QRegularExpression QSortFilterProxyModel::filterRegularExpression()


static void _init_f_filterRegularExpression_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegularExpression > ();
}

static void _call_f_filterRegularExpression_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegularExpression > ((QRegularExpression)((QSortFilterProxyModel *)cls)->filterRegularExpression ());
}


// int QSortFilterProxyModel::filterRole()


static void _init_f_filterRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_filterRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->filterRole ());
}


// QFlags<Qt::ItemFlag> QSortFilterProxyModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSortFilterProxyModel *)cls)->flags (arg1));
}


// bool QSortFilterProxyModel::hasChildren(const QModelIndex &parent)


static void _init_f_hasChildren_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasChildren_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->hasChildren (arg1));
}


// QVariant QSortFilterProxyModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSortFilterProxyModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// QModelIndex QSortFilterProxyModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->index (arg1, arg2, arg3));
}


// bool QSortFilterProxyModel::insertColumns(int column, int count, const QModelIndex &parent)


static void _init_f_insertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->insertColumns (arg1, arg2, arg3));
}


// bool QSortFilterProxyModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->insertRows (arg1, arg2, arg3));
}


// void QSortFilterProxyModel::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->invalidate ();
}


// bool QSortFilterProxyModel::isRecursiveFilteringEnabled()


static void _init_f_isRecursiveFilteringEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRecursiveFilteringEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->isRecursiveFilteringEnabled ());
}


// bool QSortFilterProxyModel::isSortLocaleAware()


static void _init_f_isSortLocaleAware_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortLocaleAware_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->isSortLocaleAware ());
}


// QModelIndex QSortFilterProxyModel::mapFromSource(const QModelIndex &sourceIndex)


static void _init_f_mapFromSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapFromSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->mapFromSource (arg1));
}


// QItemSelection QSortFilterProxyModel::mapSelectionFromSource(const QItemSelection &sourceSelection)


static void _init_f_mapSelectionFromSource_c2727 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceSelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_f_mapSelectionFromSource_c2727 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  ret.write<QItemSelection > ((QItemSelection)((QSortFilterProxyModel *)cls)->mapSelectionFromSource (arg1));
}


// QItemSelection QSortFilterProxyModel::mapSelectionToSource(const QItemSelection &proxySelection)


static void _init_f_mapSelectionToSource_c2727 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxySelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_f_mapSelectionToSource_c2727 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  ret.write<QItemSelection > ((QItemSelection)((QSortFilterProxyModel *)cls)->mapSelectionToSource (arg1));
}


// QModelIndex QSortFilterProxyModel::mapToSource(const QModelIndex &proxyIndex)


static void _init_f_mapToSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapToSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->mapToSource (arg1));
}


// QList<QModelIndex> QSortFilterProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)


static void _init_f_match_c7932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits", true, "1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags", true, "Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_f_match_c7932 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  QFlags<Qt::MatchFlag> arg5 = args ? gsi::arg_reader<QFlags<Qt::MatchFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::MatchFlag> >() (Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap), heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSortFilterProxyModel *)cls)->match (arg1, arg2, arg3, arg4, arg5));
}


// QMimeData *QSortFilterProxyModel::mimeData(const QList<QModelIndex> &indexes)


static void _init_f_mimeData_c3010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_f_mimeData_c3010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  ret.write<QMimeData * > ((QMimeData *)((QSortFilterProxyModel *)cls)->mimeData (arg1));
}


// QStringList QSortFilterProxyModel::mimeTypes()


static void _init_f_mimeTypes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_mimeTypes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSortFilterProxyModel *)cls)->mimeTypes ());
}


// QObject *QSortFilterProxyModel::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSortFilterProxyModel *)cls)->parent ());
}


// QModelIndex QSortFilterProxyModel::parent(const QModelIndex &child)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->parent (arg1));
}


// bool QSortFilterProxyModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// bool QSortFilterProxyModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->removeRows (arg1, arg2, arg3));
}


// int QSortFilterProxyModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->rowCount (arg1));
}


// void QSortFilterProxyModel::setAutoAcceptChildRows(bool accept)


static void _init_f_setAutoAcceptChildRows_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accept");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoAcceptChildRows_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setAutoAcceptChildRows (arg1);
}


// bool QSortFilterProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->setData (arg1, arg2, arg3));
}


// void QSortFilterProxyModel::setDynamicSortFilter(bool enable)


static void _init_f_setDynamicSortFilter_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDynamicSortFilter_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setDynamicSortFilter (arg1);
}


// void QSortFilterProxyModel::setFilterCaseSensitivity(Qt::CaseSensitivity cs)


static void _init_f_setFilterCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cs");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterCaseSensitivity_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}


// void QSortFilterProxyModel::setFilterFixedString(const QString &pattern)


static void _init_f_setFilterFixedString_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterFixedString_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterFixedString (arg1);
}


// void QSortFilterProxyModel::setFilterKeyColumn(int column)


static void _init_f_setFilterKeyColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterKeyColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterKeyColumn (arg1);
}


// void QSortFilterProxyModel::setFilterRegularExpression(const QString &pattern)


static void _init_f_setFilterRegularExpression_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterRegularExpression_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterRegularExpression (arg1);
}


// void QSortFilterProxyModel::setFilterRegularExpression(const QRegularExpression &regularExpression)


static void _init_f_setFilterRegularExpression_3188 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("regularExpression");
  decl->add_arg<const QRegularExpression & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterRegularExpression_3188 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegularExpression &arg1 = gsi::arg_reader<const QRegularExpression & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterRegularExpression (arg1);
}


// void QSortFilterProxyModel::setFilterRole(int role)


static void _init_f_setFilterRole_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterRole_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterRole (arg1);
}


// void QSortFilterProxyModel::setFilterWildcard(const QString &pattern)


static void _init_f_setFilterWildcard_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pattern");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterWildcard_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setFilterWildcard (arg1);
}


// bool QSortFilterProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)


static void _init_f_setHeaderData_5242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setHeaderData_5242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel *)cls)->setHeaderData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3, arg4));
}


// void QSortFilterProxyModel::setRecursiveFilteringEnabled(bool recursive)


static void _init_f_setRecursiveFilteringEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("recursive");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRecursiveFilteringEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setRecursiveFilteringEnabled (arg1);
}


// void QSortFilterProxyModel::setSortCaseSensitivity(Qt::CaseSensitivity cs)


static void _init_f_setSortCaseSensitivity_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cs");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortCaseSensitivity_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setSortCaseSensitivity (qt_gsi::QtToCppAdaptor<Qt::CaseSensitivity>(arg1).cref());
}


// void QSortFilterProxyModel::setSortLocaleAware(bool on)


static void _init_f_setSortLocaleAware_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortLocaleAware_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setSortLocaleAware (arg1);
}


// void QSortFilterProxyModel::setSortRole(int role)


static void _init_f_setSortRole_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortRole_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setSortRole (arg1);
}


// void QSortFilterProxyModel::setSourceModel(QAbstractItemModel *sourceModel)


static void _init_f_setSourceModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->setSourceModel (arg1);
}


// QModelIndex QSortFilterProxyModel::sibling(int row, int column, const QModelIndex &idx)


static void _init_f_sibling_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_sibling_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel *)cls)->sibling (arg1, arg2, arg3));
}


// void QSortFilterProxyModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// Qt::CaseSensitivity QSortFilterProxyModel::sortCaseSensitivity()


static void _init_f_sortCaseSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ();
}

static void _call_f_sortCaseSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CaseSensitivity>::target_type > ((qt_gsi::Converter<Qt::CaseSensitivity>::target_type)qt_gsi::CppToQtAdaptor<Qt::CaseSensitivity>(((QSortFilterProxyModel *)cls)->sortCaseSensitivity ()));
}


// int QSortFilterProxyModel::sortColumn()


static void _init_f_sortColumn_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_sortColumn_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->sortColumn ());
}


// Qt::SortOrder QSortFilterProxyModel::sortOrder()


static void _init_f_sortOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::SortOrder>::target_type > ();
}

static void _call_f_sortOrder_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::SortOrder>::target_type > ((qt_gsi::Converter<Qt::SortOrder>::target_type)qt_gsi::CppToQtAdaptor<Qt::SortOrder>(((QSortFilterProxyModel *)cls)->sortOrder ()));
}


// int QSortFilterProxyModel::sortRole()


static void _init_f_sortRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_sortRole_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSortFilterProxyModel *)cls)->sortRole ());
}


// QSize QSortFilterProxyModel::span(const QModelIndex &index)


static void _init_f_span_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_span_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QSortFilterProxyModel *)cls)->span (arg1));
}


// QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDropActions()


static void _init_f_supportedDropActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_f_supportedDropActions_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSortFilterProxyModel *)cls)->supportedDropActions ());
}


// static QString QSortFilterProxyModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSortFilterProxyModel::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSortFilterProxyModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":autoAcceptChildRows", "@brief Method bool QSortFilterProxyModel::autoAcceptChildRows()\n", true, &_init_f_autoAcceptChildRows_c0, &_call_f_autoAcceptChildRows_c0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Method QModelIndex QSortFilterProxyModel::buddy(const QModelIndex &index)\nThis is a reimplementation of QAbstractProxyModel::buddy", true, &_init_f_buddy_c2395, &_call_f_buddy_c2395);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Method bool QSortFilterProxyModel::canFetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractProxyModel::canFetchMore", true, &_init_f_canFetchMore_c2395, &_call_f_canFetchMore_c2395);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QSortFilterProxyModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QSortFilterProxyModel::data(const QModelIndex &index, int role)\nThis is a reimplementation of QAbstractProxyModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QSortFilterProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractProxyModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
  methods += new qt_gsi::GenericMethod (":dynamicSortFilter", "@brief Method bool QSortFilterProxyModel::dynamicSortFilter()\n", true, &_init_f_dynamicSortFilter_c0, &_call_f_dynamicSortFilter_c0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Method void QSortFilterProxyModel::fetchMore(const QModelIndex &parent)\nThis is a reimplementation of QAbstractProxyModel::fetchMore", false, &_init_f_fetchMore_2395, &_call_f_fetchMore_2395);
  methods += new qt_gsi::GenericMethod (":filterCaseSensitivity", "@brief Method Qt::CaseSensitivity QSortFilterProxyModel::filterCaseSensitivity()\n", true, &_init_f_filterCaseSensitivity_c0, &_call_f_filterCaseSensitivity_c0);
  methods += new qt_gsi::GenericMethod (":filterKeyColumn", "@brief Method int QSortFilterProxyModel::filterKeyColumn()\n", true, &_init_f_filterKeyColumn_c0, &_call_f_filterKeyColumn_c0);
  methods += new qt_gsi::GenericMethod (":filterRegularExpression", "@brief Method QRegularExpression QSortFilterProxyModel::filterRegularExpression()\n", true, &_init_f_filterRegularExpression_c0, &_call_f_filterRegularExpression_c0);
  methods += new qt_gsi::GenericMethod (":filterRole", "@brief Method int QSortFilterProxyModel::filterRole()\n", true, &_init_f_filterRole_c0, &_call_f_filterRole_c0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QSortFilterProxyModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractProxyModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Method bool QSortFilterProxyModel::hasChildren(const QModelIndex &parent)\nThis is a reimplementation of QAbstractProxyModel::hasChildren", true, &_init_f_hasChildren_c2395, &_call_f_hasChildren_c2395);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QSortFilterProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractProxyModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QSortFilterProxyModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Method bool QSortFilterProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertColumns", false, &_init_f_insertColumns_3713, &_call_f_insertColumns_3713);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QSortFilterProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QSortFilterProxyModel::invalidate()\n", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
  methods += new qt_gsi::GenericMethod ("isRecursiveFilteringEnabled?|:recursiveFilteringEnabled", "@brief Method bool QSortFilterProxyModel::isRecursiveFilteringEnabled()\n", true, &_init_f_isRecursiveFilteringEnabled_c0, &_call_f_isRecursiveFilteringEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isSortLocaleAware?|:isSortLocaleAware", "@brief Method bool QSortFilterProxyModel::isSortLocaleAware()\n", true, &_init_f_isSortLocaleAware_c0, &_call_f_isSortLocaleAware_c0);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Method QModelIndex QSortFilterProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis is a reimplementation of QAbstractProxyModel::mapFromSource", true, &_init_f_mapFromSource_c2395, &_call_f_mapFromSource_c2395);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@brief Method QItemSelection QSortFilterProxyModel::mapSelectionFromSource(const QItemSelection &sourceSelection)\nThis is a reimplementation of QAbstractProxyModel::mapSelectionFromSource", true, &_init_f_mapSelectionFromSource_c2727, &_call_f_mapSelectionFromSource_c2727);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@brief Method QItemSelection QSortFilterProxyModel::mapSelectionToSource(const QItemSelection &proxySelection)\nThis is a reimplementation of QAbstractProxyModel::mapSelectionToSource", true, &_init_f_mapSelectionToSource_c2727, &_call_f_mapSelectionToSource_c2727);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Method QModelIndex QSortFilterProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis is a reimplementation of QAbstractProxyModel::mapToSource", true, &_init_f_mapToSource_c2395, &_call_f_mapToSource_c2395);
  methods += new qt_gsi::GenericMethod ("match", "@brief Method QList<QModelIndex> QSortFilterProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis is a reimplementation of QAbstractItemModel::match", true, &_init_f_match_c7932, &_call_f_match_c7932);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Method QMimeData *QSortFilterProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis is a reimplementation of QAbstractProxyModel::mimeData", true, &_init_f_mimeData_c3010, &_call_f_mimeData_c3010);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Method QStringList QSortFilterProxyModel::mimeTypes()\nThis is a reimplementation of QAbstractProxyModel::mimeTypes", true, &_init_f_mimeTypes_c0, &_call_f_mimeTypes_c0);
  methods += new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QSortFilterProxyModel::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QSortFilterProxyModel::parent(const QModelIndex &child)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QSortFilterProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QSortFilterProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QSortFilterProxyModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("setAutoAcceptChildRows|autoAcceptChildRows=", "@brief Method void QSortFilterProxyModel::setAutoAcceptChildRows(bool accept)\n", false, &_init_f_setAutoAcceptChildRows_864, &_call_f_setAutoAcceptChildRows_864);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method bool QSortFilterProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractProxyModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
  methods += new qt_gsi::GenericMethod ("setDynamicSortFilter|dynamicSortFilter=", "@brief Method void QSortFilterProxyModel::setDynamicSortFilter(bool enable)\n", false, &_init_f_setDynamicSortFilter_864, &_call_f_setDynamicSortFilter_864);
  methods += new qt_gsi::GenericMethod ("setFilterCaseSensitivity|filterCaseSensitivity=", "@brief Method void QSortFilterProxyModel::setFilterCaseSensitivity(Qt::CaseSensitivity cs)\n", false, &_init_f_setFilterCaseSensitivity_2324, &_call_f_setFilterCaseSensitivity_2324);
  methods += new qt_gsi::GenericMethod ("setFilterFixedString", "@brief Method void QSortFilterProxyModel::setFilterFixedString(const QString &pattern)\n", false, &_init_f_setFilterFixedString_2025, &_call_f_setFilterFixedString_2025);
  methods += new qt_gsi::GenericMethod ("setFilterKeyColumn|filterKeyColumn=", "@brief Method void QSortFilterProxyModel::setFilterKeyColumn(int column)\n", false, &_init_f_setFilterKeyColumn_767, &_call_f_setFilterKeyColumn_767);
  methods += new qt_gsi::GenericMethod ("setFilterRegularExpression|filterRegularExpression=", "@brief Method void QSortFilterProxyModel::setFilterRegularExpression(const QString &pattern)\n", false, &_init_f_setFilterRegularExpression_2025, &_call_f_setFilterRegularExpression_2025);
  methods += new qt_gsi::GenericMethod ("setFilterRegularExpression|filterRegularExpression=", "@brief Method void QSortFilterProxyModel::setFilterRegularExpression(const QRegularExpression &regularExpression)\n", false, &_init_f_setFilterRegularExpression_3188, &_call_f_setFilterRegularExpression_3188);
  methods += new qt_gsi::GenericMethod ("setFilterRole|filterRole=", "@brief Method void QSortFilterProxyModel::setFilterRole(int role)\n", false, &_init_f_setFilterRole_767, &_call_f_setFilterRole_767);
  methods += new qt_gsi::GenericMethod ("setFilterWildcard", "@brief Method void QSortFilterProxyModel::setFilterWildcard(const QString &pattern)\n", false, &_init_f_setFilterWildcard_2025, &_call_f_setFilterWildcard_2025);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Method bool QSortFilterProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis is a reimplementation of QAbstractProxyModel::setHeaderData", false, &_init_f_setHeaderData_5242, &_call_f_setHeaderData_5242);
  methods += new qt_gsi::GenericMethod ("setRecursiveFilteringEnabled|recursiveFilteringEnabled=", "@brief Method void QSortFilterProxyModel::setRecursiveFilteringEnabled(bool recursive)\n", false, &_init_f_setRecursiveFilteringEnabled_864, &_call_f_setRecursiveFilteringEnabled_864);
  methods += new qt_gsi::GenericMethod ("setSortCaseSensitivity|sortCaseSensitivity=", "@brief Method void QSortFilterProxyModel::setSortCaseSensitivity(Qt::CaseSensitivity cs)\n", false, &_init_f_setSortCaseSensitivity_2324, &_call_f_setSortCaseSensitivity_2324);
  methods += new qt_gsi::GenericMethod ("setSortLocaleAware", "@brief Method void QSortFilterProxyModel::setSortLocaleAware(bool on)\n", false, &_init_f_setSortLocaleAware_864, &_call_f_setSortLocaleAware_864);
  methods += new qt_gsi::GenericMethod ("setSortRole|sortRole=", "@brief Method void QSortFilterProxyModel::setSortRole(int role)\n", false, &_init_f_setSortRole_767, &_call_f_setSortRole_767);
  methods += new qt_gsi::GenericMethod ("setSourceModel|sourceModel=", "@brief Method void QSortFilterProxyModel::setSourceModel(QAbstractItemModel *sourceModel)\nThis is a reimplementation of QAbstractProxyModel::setSourceModel", false, &_init_f_setSourceModel_2419, &_call_f_setSourceModel_2419);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Method QModelIndex QSortFilterProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis is a reimplementation of QAbstractProxyModel::sibling", true, &_init_f_sibling_c3713, &_call_f_sibling_c3713);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Method void QSortFilterProxyModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractProxyModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
  methods += new qt_gsi::GenericMethod (":sortCaseSensitivity", "@brief Method Qt::CaseSensitivity QSortFilterProxyModel::sortCaseSensitivity()\n", true, &_init_f_sortCaseSensitivity_c0, &_call_f_sortCaseSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("sortColumn", "@brief Method int QSortFilterProxyModel::sortColumn()\n", true, &_init_f_sortColumn_c0, &_call_f_sortColumn_c0);
  methods += new qt_gsi::GenericMethod ("sortOrder", "@brief Method Qt::SortOrder QSortFilterProxyModel::sortOrder()\n", true, &_init_f_sortOrder_c0, &_call_f_sortOrder_c0);
  methods += new qt_gsi::GenericMethod (":sortRole", "@brief Method int QSortFilterProxyModel::sortRole()\n", true, &_init_f_sortRole_c0, &_call_f_sortRole_c0);
  methods += new qt_gsi::GenericMethod ("span", "@brief Method QSize QSortFilterProxyModel::span(const QModelIndex &index)\nThis is a reimplementation of QAbstractProxyModel::span", true, &_init_f_span_c2395, &_call_f_span_c2395);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Method QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDropActions()\nThis is a reimplementation of QAbstractProxyModel::supportedDropActions", true, &_init_f_supportedDropActions_c0, &_call_f_supportedDropActions_c0);
  methods += gsi::qt_signal<bool > ("autoAcceptChildRowsChanged(bool)", "autoAcceptChildRowsChanged", gsi::arg("autoAcceptChildRows"), "@brief Signal declaration for QSortFilterProxyModel::autoAcceptChildRowsChanged(bool autoAcceptChildRows)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeInserted(const QModelIndex &, int, int)", "columnsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationColumn"), "@brief Signal declaration for QSortFilterProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeRemoved(const QModelIndex &, int, int)", "columnsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsInserted(const QModelIndex &, int, int)", "columnsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("column"), "@brief Signal declaration for QSortFilterProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsRemoved(const QModelIndex &, int, int)", "columnsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QList<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QList<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QSortFilterProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSortFilterProxyModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("dynamicSortFilterChanged(bool)", "dynamicSortFilterChanged", gsi::arg("dynamicSortFilter"), "@brief Signal declaration for QSortFilterProxyModel::dynamicSortFilterChanged(bool dynamicSortFilter)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > ("filterCaseSensitivityChanged(Qt::CaseSensitivity)", "filterCaseSensitivityChanged", gsi::arg("filterCaseSensitivity"), "@brief Signal declaration for QSortFilterProxyModel::filterCaseSensitivityChanged(Qt::CaseSensitivity filterCaseSensitivity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("filterRoleChanged(int)", "filterRoleChanged", gsi::arg("filterRole"), "@brief Signal declaration for QSortFilterProxyModel::filterRoleChanged(int filterRole)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSortFilterProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSortFilterProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelAboutToBeReset()", "modelAboutToBeReset", "@brief Signal declaration for QSortFilterProxyModel::modelAboutToBeReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelReset()", "modelReset", "@brief Signal declaration for QSortFilterProxyModel::modelReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSortFilterProxyModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("recursiveFilteringEnabledChanged(bool)", "recursiveFilteringEnabledChanged", gsi::arg("recursiveFilteringEnabled"), "@brief Signal declaration for QSortFilterProxyModel::recursiveFilteringEnabledChanged(bool recursiveFilteringEnabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeInserted(const QModelIndex &, int, int)", "rowsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationRow"), "@brief Signal declaration for QSortFilterProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeRemoved(const QModelIndex &, int, int)", "rowsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsInserted(const QModelIndex &, int, int)", "rowsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("row"), "@brief Signal declaration for QSortFilterProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsRemoved(const QModelIndex &, int, int)", "rowsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSortFilterProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > ("sortCaseSensitivityChanged(Qt::CaseSensitivity)", "sortCaseSensitivityChanged", gsi::arg("sortCaseSensitivity"), "@brief Signal declaration for QSortFilterProxyModel::sortCaseSensitivityChanged(Qt::CaseSensitivity sortCaseSensitivity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("sortLocaleAwareChanged(bool)", "sortLocaleAwareChanged", gsi::arg("sortLocaleAware"), "@brief Signal declaration for QSortFilterProxyModel::sortLocaleAwareChanged(bool sortLocaleAware)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("sortRoleChanged(int)", "sortRoleChanged", gsi::arg("sortRole"), "@brief Signal declaration for QSortFilterProxyModel::sortRoleChanged(int sortRole)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("sourceModelChanged()", "sourceModelChanged", "@brief Signal declaration for QSortFilterProxyModel::sourceModelChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSortFilterProxyModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractProxyModel> &qtdecl_QAbstractProxyModel ();

qt_gsi::QtNativeClass<QSortFilterProxyModel> decl_QSortFilterProxyModel (qtdecl_QAbstractProxyModel (), "QtCore", "QSortFilterProxyModel_Native",
  methods_QSortFilterProxyModel (),
  "@hide\n@alias QSortFilterProxyModel");

GSI_QTCORE_PUBLIC gsi::Class<QSortFilterProxyModel> &qtdecl_QSortFilterProxyModel () { return decl_QSortFilterProxyModel; }

}


class QSortFilterProxyModel_Adaptor : public QSortFilterProxyModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSortFilterProxyModel_Adaptor();

  //  [adaptor ctor] QSortFilterProxyModel::QSortFilterProxyModel(QObject *parent)
  QSortFilterProxyModel_Adaptor() : QSortFilterProxyModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSortFilterProxyModel::QSortFilterProxyModel(QObject *parent)
  QSortFilterProxyModel_Adaptor(QObject *parent) : QSortFilterProxyModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSortFilterProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QSortFilterProxyModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSortFilterProxyModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QSortFilterProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QSortFilterProxyModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QSortFilterProxyModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QSortFilterProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QSortFilterProxyModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QSortFilterProxyModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QSortFilterProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QSortFilterProxyModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QSortFilterProxyModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QSortFilterProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QSortFilterProxyModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSortFilterProxyModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QSortFilterProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QSortFilterProxyModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QSortFilterProxyModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QSortFilterProxyModel::beginResetModel()
  void fp_QSortFilterProxyModel_beginResetModel_0 () {
    QSortFilterProxyModel::beginResetModel();
  }

  //  [expose] void QSortFilterProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QSortFilterProxyModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QSortFilterProxyModel::changePersistentIndex(from, to);
  }

  //  [expose] void QSortFilterProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QSortFilterProxyModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QSortFilterProxyModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QSortFilterProxyModel::createIndex(int row, int column, const void *data)
  QModelIndex fp_QSortFilterProxyModel_createIndex_c3069 (int row, int column, const void *data) const {
    return QSortFilterProxyModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QSortFilterProxyModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QSortFilterProxyModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QSortFilterProxyModel::createIndex(row, column, id);
  }

  //  [expose] QModelIndex QSortFilterProxyModel::createSourceIndex(int row, int col, void *internalPtr)
  QModelIndex fp_QSortFilterProxyModel_createSourceIndex_c2374 (int row, int col, void *internalPtr) const {
    return QSortFilterProxyModel::createSourceIndex(row, col, internalPtr);
  }

  //  [expose] bool QSortFilterProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QSortFilterProxyModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QSortFilterProxyModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QSortFilterProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QSortFilterProxyModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QSortFilterProxyModel::encodeData(indexes, stream);
  }

  //  [expose] void QSortFilterProxyModel::endInsertColumns()
  void fp_QSortFilterProxyModel_endInsertColumns_0 () {
    QSortFilterProxyModel::endInsertColumns();
  }

  //  [expose] void QSortFilterProxyModel::endInsertRows()
  void fp_QSortFilterProxyModel_endInsertRows_0 () {
    QSortFilterProxyModel::endInsertRows();
  }

  //  [expose] void QSortFilterProxyModel::endMoveColumns()
  void fp_QSortFilterProxyModel_endMoveColumns_0 () {
    QSortFilterProxyModel::endMoveColumns();
  }

  //  [expose] void QSortFilterProxyModel::endMoveRows()
  void fp_QSortFilterProxyModel_endMoveRows_0 () {
    QSortFilterProxyModel::endMoveRows();
  }

  //  [expose] void QSortFilterProxyModel::endRemoveColumns()
  void fp_QSortFilterProxyModel_endRemoveColumns_0 () {
    QSortFilterProxyModel::endRemoveColumns();
  }

  //  [expose] void QSortFilterProxyModel::endRemoveRows()
  void fp_QSortFilterProxyModel_endRemoveRows_0 () {
    QSortFilterProxyModel::endRemoveRows();
  }

  //  [expose] void QSortFilterProxyModel::endResetModel()
  void fp_QSortFilterProxyModel_endResetModel_0 () {
    QSortFilterProxyModel::endResetModel();
  }

  //  [expose] void QSortFilterProxyModel::invalidateColumnsFilter()
  void fp_QSortFilterProxyModel_invalidateColumnsFilter_0 () {
    QSortFilterProxyModel::invalidateColumnsFilter();
  }

  //  [expose] void QSortFilterProxyModel::invalidateFilter()
  void fp_QSortFilterProxyModel_invalidateFilter_0 () {
    QSortFilterProxyModel::invalidateFilter();
  }

  //  [expose] void QSortFilterProxyModel::invalidateRowsFilter()
  void fp_QSortFilterProxyModel_invalidateRowsFilter_0 () {
    QSortFilterProxyModel::invalidateRowsFilter();
  }

  //  [expose] bool QSortFilterProxyModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSortFilterProxyModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSortFilterProxyModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QSortFilterProxyModel::persistentIndexList()
  QList<QModelIndex> fp_QSortFilterProxyModel_persistentIndexList_c0 () const {
    return QSortFilterProxyModel::persistentIndexList();
  }

  //  [expose] int QSortFilterProxyModel::receivers(const char *signal)
  int fp_QSortFilterProxyModel_receivers_c1731 (const char *signal) const {
    return QSortFilterProxyModel::receivers(signal);
  }

  //  [expose] QObject *QSortFilterProxyModel::sender()
  QObject * fp_QSortFilterProxyModel_sender_c0 () const {
    return QSortFilterProxyModel::sender();
  }

  //  [expose] int QSortFilterProxyModel::senderSignalIndex()
  int fp_QSortFilterProxyModel_senderSignalIndex_c0 () const {
    return QSortFilterProxyModel::senderSignalIndex();
  }

  //  [emitter impl] void QSortFilterProxyModel::autoAcceptChildRowsChanged(bool autoAcceptChildRows)
  void emitter_QSortFilterProxyModel_autoAcceptChildRowsChanged_864(bool autoAcceptChildRows)
  {
    emit QSortFilterProxyModel::autoAcceptChildRowsChanged(autoAcceptChildRows);
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QSortFilterProxyModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QSortFilterProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QSortFilterProxyModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QSortFilterProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSortFilterProxyModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QSortFilterProxyModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::clearItemData(const QModelIndex &index)
  bool cbs_clearItemData_2395_0(const QModelIndex &index)
  {
    return QSortFilterProxyModel::clearItemData(index);
  }

  virtual bool clearItemData(const QModelIndex &index)
  {
    if (cb_clearItemData_2395_0.can_issue()) {
      return cb_clearItemData_2395_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_clearItemData_2395_0, index);
    } else {
      return QSortFilterProxyModel::clearItemData(index);
    }
  }

  //  [adaptor impl] int QSortFilterProxyModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QSortFilterProxyModel_Adaptor, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QSortFilterProxyModel::columnCount(parent);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_columnsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  void emitter_QSortFilterProxyModel_columnsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationColumn);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_columnsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_columnsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  void emitter_QSortFilterProxyModel_columnsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (column);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_columnsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] QVariant QSortFilterProxyModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    return QSortFilterProxyModel::data(index, role);
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QSortFilterProxyModel_Adaptor, QVariant, const QModelIndex &, int>(&QSortFilterProxyModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      return QSortFilterProxyModel::data(index, role);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  void emitter_QSortFilterProxyModel_dataChanged_6833(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    emit QSortFilterProxyModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QSortFilterProxyModel::destroyed(QObject *)
  void emitter_QSortFilterProxyModel_destroyed_1302(QObject *arg1)
  {
    emit QSortFilterProxyModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QSortFilterProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QSortFilterProxyModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QSortFilterProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSortFilterProxyModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::dynamicSortFilterChanged(bool dynamicSortFilter)
  void emitter_QSortFilterProxyModel_dynamicSortFilterChanged_864(bool dynamicSortFilter)
  {
    emit QSortFilterProxyModel::dynamicSortFilterChanged(dynamicSortFilter);
  }

  //  [adaptor impl] bool QSortFilterProxyModel::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSortFilterProxyModel::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSortFilterProxyModel_Adaptor, bool, QEvent *>(&QSortFilterProxyModel_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSortFilterProxyModel::event(_event);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QSortFilterProxyModel::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSortFilterProxyModel_Adaptor, bool, QObject *, QEvent *>(&QSortFilterProxyModel_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QSortFilterProxyModel::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QSortFilterProxyModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QSortFilterProxyModel_Adaptor, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QSortFilterProxyModel::fetchMore(parent);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::filterCaseSensitivityChanged(Qt::CaseSensitivity filterCaseSensitivity)
  void emitter_QSortFilterProxyModel_filterCaseSensitivityChanged_2324(Qt::CaseSensitivity filterCaseSensitivity)
  {
    emit QSortFilterProxyModel::filterCaseSensitivityChanged(filterCaseSensitivity);
  }

  //  [emitter impl] void QSortFilterProxyModel::filterRoleChanged(int filterRole)
  void emitter_QSortFilterProxyModel_filterRoleChanged_767(int filterRole)
  {
    emit QSortFilterProxyModel::filterRoleChanged(filterRole);
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QSortFilterProxyModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QSortFilterProxyModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QSortFilterProxyModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QSortFilterProxyModel::flags(index);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QSortFilterProxyModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QSortFilterProxyModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QSortFilterProxyModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QSortFilterProxyModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QSortFilterProxyModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QSortFilterProxyModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QSortFilterProxyModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QSortFilterProxyModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QSortFilterProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QSortFilterProxyModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSortFilterProxyModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QSortFilterProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QSortFilterProxyModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSortFilterProxyModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QSortFilterProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QSortFilterProxyModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QSortFilterProxyModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QSortFilterProxyModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QSortFilterProxyModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QSortFilterProxyModel::itemData(index);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSortFilterProxyModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSortFilterProxyModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QSortFilterProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSortFilterProxyModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSortFilterProxyModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::mapFromSource(const QModelIndex &sourceIndex)
  QModelIndex cbs_mapFromSource_c2395_0(const QModelIndex &sourceIndex) const
  {
    return QSortFilterProxyModel::mapFromSource(sourceIndex);
  }

  virtual QModelIndex mapFromSource(const QModelIndex &sourceIndex) const
  {
    if (cb_mapFromSource_c2395_0.can_issue()) {
      return cb_mapFromSource_c2395_0.issue<QSortFilterProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_mapFromSource_c2395_0, sourceIndex);
    } else {
      return QSortFilterProxyModel::mapFromSource(sourceIndex);
    }
  }

  //  [adaptor impl] QItemSelection QSortFilterProxyModel::mapSelectionFromSource(const QItemSelection &sourceSelection)
  QItemSelection cbs_mapSelectionFromSource_c2727_0(const QItemSelection &sourceSelection) const
  {
    return QSortFilterProxyModel::mapSelectionFromSource(sourceSelection);
  }

  virtual QItemSelection mapSelectionFromSource(const QItemSelection &sourceSelection) const
  {
    if (cb_mapSelectionFromSource_c2727_0.can_issue()) {
      return cb_mapSelectionFromSource_c2727_0.issue<QSortFilterProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QSortFilterProxyModel_Adaptor::cbs_mapSelectionFromSource_c2727_0, sourceSelection);
    } else {
      return QSortFilterProxyModel::mapSelectionFromSource(sourceSelection);
    }
  }

  //  [adaptor impl] QItemSelection QSortFilterProxyModel::mapSelectionToSource(const QItemSelection &proxySelection)
  QItemSelection cbs_mapSelectionToSource_c2727_0(const QItemSelection &proxySelection) const
  {
    return QSortFilterProxyModel::mapSelectionToSource(proxySelection);
  }

  virtual QItemSelection mapSelectionToSource(const QItemSelection &proxySelection) const
  {
    if (cb_mapSelectionToSource_c2727_0.can_issue()) {
      return cb_mapSelectionToSource_c2727_0.issue<QSortFilterProxyModel_Adaptor, QItemSelection, const QItemSelection &>(&QSortFilterProxyModel_Adaptor::cbs_mapSelectionToSource_c2727_0, proxySelection);
    } else {
      return QSortFilterProxyModel::mapSelectionToSource(proxySelection);
    }
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::mapToSource(const QModelIndex &proxyIndex)
  QModelIndex cbs_mapToSource_c2395_0(const QModelIndex &proxyIndex) const
  {
    return QSortFilterProxyModel::mapToSource(proxyIndex);
  }

  virtual QModelIndex mapToSource(const QModelIndex &proxyIndex) const
  {
    if (cb_mapToSource_c2395_0.can_issue()) {
      return cb_mapToSource_c2395_0.issue<QSortFilterProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_mapToSource_c2395_0, proxyIndex);
    } else {
      return QSortFilterProxyModel::mapToSource(proxyIndex);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QSortFilterProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QSortFilterProxyModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QSortFilterProxyModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QSortFilterProxyModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QSortFilterProxyModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QSortFilterProxyModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QSortFilterProxyModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QSortFilterProxyModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QSortFilterProxyModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QSortFilterProxyModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QSortFilterProxyModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QSortFilterProxyModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QSortFilterProxyModel_Adaptor, QStringList>(&QSortFilterProxyModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QSortFilterProxyModel::mimeTypes();
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::modelAboutToBeReset()
  void emitter_QSortFilterProxyModel_modelAboutToBeReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::modelAboutToBeReset()'");
  }

  //  [emitter impl] void QSortFilterProxyModel::modelReset()
  void emitter_QSortFilterProxyModel_modelReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::modelReset()'");
  }

  //  [adaptor impl] bool QSortFilterProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSortFilterProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSortFilterProxyModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QSortFilterProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSortFilterProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSortFilterProxyModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QSortFilterProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)
  void cbs_multiData_c4483_0(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    QSortFilterProxyModel::multiData(index, roleDataSpan);
  }

  virtual void multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    if (cb_multiData_c4483_0.can_issue()) {
      cb_multiData_c4483_0.issue<QSortFilterProxyModel_Adaptor, const QModelIndex &, QModelRoleDataSpan>(&QSortFilterProxyModel_Adaptor::cbs_multiData_c4483_0, index, roleDataSpan);
    } else {
      QSortFilterProxyModel::multiData(index, roleDataSpan);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::objectNameChanged(const QString &objectName)
  void emitter_QSortFilterProxyModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::parent(const QModelIndex &child)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &child) const
  {
    return QSortFilterProxyModel::parent(child);
  }

  virtual QModelIndex parent(const QModelIndex &child) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QSortFilterProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_parent_c2395_0, child);
    } else {
      return QSortFilterProxyModel::parent(child);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::recursiveFilteringEnabledChanged(bool recursiveFilteringEnabled)
  void emitter_QSortFilterProxyModel_recursiveFilteringEnabledChanged_864(bool recursiveFilteringEnabled)
  {
    emit QSortFilterProxyModel::recursiveFilteringEnabledChanged(recursiveFilteringEnabled);
  }

  //  [adaptor impl] bool QSortFilterProxyModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSortFilterProxyModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QSortFilterProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QSortFilterProxyModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSortFilterProxyModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QSortFilterProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QSortFilterProxyModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::revert()
  void cbs_revert_0_0()
  {
    QSortFilterProxyModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QSortFilterProxyModel_Adaptor>(&QSortFilterProxyModel_Adaptor::cbs_revert_0_0);
    } else {
      QSortFilterProxyModel::revert();
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QSortFilterProxyModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QSortFilterProxyModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QSortFilterProxyModel_Adaptor, QHash<int, QByteArray> >(&QSortFilterProxyModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QSortFilterProxyModel::roleNames();
    }
  }

  //  [adaptor impl] int QSortFilterProxyModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QSortFilterProxyModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QSortFilterProxyModel_Adaptor, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QSortFilterProxyModel::rowCount(parent);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_rowsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  void emitter_QSortFilterProxyModel_rowsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationRow);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_rowsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_rowsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  void emitter_QSortFilterProxyModel_rowsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (row);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)'");
  }

  //  [emitter impl] void QSortFilterProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSortFilterProxyModel_rowsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] bool QSortFilterProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QSortFilterProxyModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QSortFilterProxyModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QSortFilterProxyModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QSortFilterProxyModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QSortFilterProxyModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QSortFilterProxyModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QSortFilterProxyModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QSortFilterProxyModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QSortFilterProxyModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QSortFilterProxyModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::setSourceModel(QAbstractItemModel *sourceModel)
  void cbs_setSourceModel_2419_0(QAbstractItemModel *sourceModel)
  {
    QSortFilterProxyModel::setSourceModel(sourceModel);
  }

  virtual void setSourceModel(QAbstractItemModel *sourceModel)
  {
    if (cb_setSourceModel_2419_0.can_issue()) {
      cb_setSourceModel_2419_0.issue<QSortFilterProxyModel_Adaptor, QAbstractItemModel *>(&QSortFilterProxyModel_Adaptor::cbs_setSourceModel_2419_0, sourceModel);
    } else {
      QSortFilterProxyModel::setSourceModel(sourceModel);
    }
  }

  //  [adaptor impl] QModelIndex QSortFilterProxyModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QSortFilterProxyModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QSortFilterProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QSortFilterProxyModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSortFilterProxyModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QSortFilterProxyModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSortFilterProxyModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSortFilterProxyModel::sort(column, order);
    }
  }

  //  [emitter impl] void QSortFilterProxyModel::sortCaseSensitivityChanged(Qt::CaseSensitivity sortCaseSensitivity)
  void emitter_QSortFilterProxyModel_sortCaseSensitivityChanged_2324(Qt::CaseSensitivity sortCaseSensitivity)
  {
    emit QSortFilterProxyModel::sortCaseSensitivityChanged(sortCaseSensitivity);
  }

  //  [emitter impl] void QSortFilterProxyModel::sortLocaleAwareChanged(bool sortLocaleAware)
  void emitter_QSortFilterProxyModel_sortLocaleAwareChanged_864(bool sortLocaleAware)
  {
    emit QSortFilterProxyModel::sortLocaleAwareChanged(sortLocaleAware);
  }

  //  [emitter impl] void QSortFilterProxyModel::sortRoleChanged(int sortRole)
  void emitter_QSortFilterProxyModel_sortRoleChanged_767(int sortRole)
  {
    emit QSortFilterProxyModel::sortRoleChanged(sortRole);
  }

  //  [emitter impl] void QSortFilterProxyModel::sourceModelChanged()
  void emitter_QSortFilterProxyModel_sourceModelChanged_3914()
  {
    throw tl::Exception ("Can't emit private signal 'void QSortFilterProxyModel::sourceModelChanged()'");
  }

  //  [adaptor impl] QSize QSortFilterProxyModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QSortFilterProxyModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QSortFilterProxyModel_Adaptor, QSize, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QSortFilterProxyModel::span(index);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::submit()
  bool cbs_submit_0_0()
  {
    return QSortFilterProxyModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QSortFilterProxyModel_Adaptor, bool>(&QSortFilterProxyModel_Adaptor::cbs_submit_0_0);
    } else {
      return QSortFilterProxyModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QSortFilterProxyModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QSortFilterProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QSortFilterProxyModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QSortFilterProxyModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QSortFilterProxyModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QSortFilterProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QSortFilterProxyModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QSortFilterProxyModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QSortFilterProxyModel::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSortFilterProxyModel_Adaptor, QChildEvent *>(&QSortFilterProxyModel_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QSortFilterProxyModel::childEvent(event);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QSortFilterProxyModel::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSortFilterProxyModel_Adaptor, QEvent *>(&QSortFilterProxyModel_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QSortFilterProxyModel::customEvent(event);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSortFilterProxyModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSortFilterProxyModel_Adaptor, const QMetaMethod &>(&QSortFilterProxyModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSortFilterProxyModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::filterAcceptsColumn(int source_column, const QModelIndex &source_parent)
  bool cbs_filterAcceptsColumn_c3054_0(int source_column, const QModelIndex &source_parent) const
  {
    return QSortFilterProxyModel::filterAcceptsColumn(source_column, source_parent);
  }

  virtual bool filterAcceptsColumn(int source_column, const QModelIndex &source_parent) const
  {
    if (cb_filterAcceptsColumn_c3054_0.can_issue()) {
      return cb_filterAcceptsColumn_c3054_0.issue<QSortFilterProxyModel_Adaptor, bool, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_filterAcceptsColumn_c3054_0, source_column, source_parent);
    } else {
      return QSortFilterProxyModel::filterAcceptsColumn(source_column, source_parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::filterAcceptsRow(int source_row, const QModelIndex &source_parent)
  bool cbs_filterAcceptsRow_c3054_0(int source_row, const QModelIndex &source_parent) const
  {
    return QSortFilterProxyModel::filterAcceptsRow(source_row, source_parent);
  }

  virtual bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const
  {
    if (cb_filterAcceptsRow_c3054_0.can_issue()) {
      return cb_filterAcceptsRow_c3054_0.issue<QSortFilterProxyModel_Adaptor, bool, int, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_filterAcceptsRow_c3054_0, source_row, source_parent);
    } else {
      return QSortFilterProxyModel::filterAcceptsRow(source_row, source_parent);
    }
  }

  //  [adaptor impl] bool QSortFilterProxyModel::lessThan(const QModelIndex &source_left, const QModelIndex &source_right)
  bool cbs_lessThan_c4682_0(const QModelIndex &source_left, const QModelIndex &source_right) const
  {
    return QSortFilterProxyModel::lessThan(source_left, source_right);
  }

  virtual bool lessThan(const QModelIndex &source_left, const QModelIndex &source_right) const
  {
    if (cb_lessThan_c4682_0.can_issue()) {
      return cb_lessThan_c4682_0.issue<QSortFilterProxyModel_Adaptor, bool, const QModelIndex &, const QModelIndex &>(&QSortFilterProxyModel_Adaptor::cbs_lessThan_c4682_0, source_left, source_right);
    } else {
      return QSortFilterProxyModel::lessThan(source_left, source_right);
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::resetInternalData()
  void cbs_resetInternalData_0_0()
  {
    QSortFilterProxyModel::resetInternalData();
  }

  virtual void resetInternalData()
  {
    if (cb_resetInternalData_0_0.can_issue()) {
      cb_resetInternalData_0_0.issue<QSortFilterProxyModel_Adaptor>(&QSortFilterProxyModel_Adaptor::cbs_resetInternalData_0_0);
    } else {
      QSortFilterProxyModel::resetInternalData();
    }
  }

  //  [adaptor impl] void QSortFilterProxyModel::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QSortFilterProxyModel::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSortFilterProxyModel_Adaptor, QTimerEvent *>(&QSortFilterProxyModel_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QSortFilterProxyModel::timerEvent(event);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_clearItemData_2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_mapFromSource_c2395_0;
  gsi::Callback cb_mapSelectionFromSource_c2727_0;
  gsi::Callback cb_mapSelectionToSource_c2727_0;
  gsi::Callback cb_mapToSource_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_multiData_c4483_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_setSourceModel_2419_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_filterAcceptsColumn_c3054_0;
  gsi::Callback cb_filterAcceptsRow_c3054_0;
  gsi::Callback cb_lessThan_c4682_0;
  gsi::Callback cb_resetInternalData_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSortFilterProxyModel_Adaptor::~QSortFilterProxyModel_Adaptor() { }

//  Constructor QSortFilterProxyModel::QSortFilterProxyModel(QObject *parent) (adaptor class)

static void _init_ctor_QSortFilterProxyModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSortFilterProxyModel_Adaptor> ();
}

static void _call_ctor_QSortFilterProxyModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QSortFilterProxyModel_Adaptor *> (new QSortFilterProxyModel_Adaptor (arg1));
}


// emitter void QSortFilterProxyModel::autoAcceptChildRowsChanged(bool autoAcceptChildRows)

static void _init_emitter_autoAcceptChildRowsChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("autoAcceptChildRows");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_autoAcceptChildRowsChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_autoAcceptChildRowsChanged_864 (arg1);
}


// exposed void QSortFilterProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSortFilterProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QSortFilterProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QSortFilterProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QSortFilterProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSortFilterProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QSortFilterProxyModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_beginResetModel_0 ();
}


// QModelIndex QSortFilterProxyModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QSortFilterProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QSortFilterProxyModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}


// exposed void QSortFilterProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QSortFilterProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QSortFilterProxyModel::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// bool QSortFilterProxyModel::clearItemData(const QModelIndex &index)

static void _init_cbs_clearItemData_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_clearItemData_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_clearItemData_2395_0 (arg1));
}

static void _set_callback_cbs_clearItemData_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_clearItemData_2395_0 = cb;
}


// int QSortFilterProxyModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSortFilterProxyModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// emitter void QSortFilterProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)

static void _init_emitter_columnsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSortFilterProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)

static void _init_emitter_columnsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("column");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSortFilterProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_columnsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QModelIndex QSortFilterProxyModel::createIndex(int row, int column, const void *data)

static void _init_fp_createIndex_c3069 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "nullptr");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c3069 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const void *arg3 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_createIndex_c3069 (arg1, arg2, arg3));
}


// exposed QModelIndex QSortFilterProxyModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_createIndex_c2657 (arg1, arg2, arg3));
}


// exposed QModelIndex QSortFilterProxyModel::createSourceIndex(int row, int col, void *internalPtr)

static void _init_fp_createSourceIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("col");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("internalPtr");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createSourceIndex_c2374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  void *arg3 = gsi::arg_reader<void * >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_createSourceIndex_c2374 (arg1, arg2, arg3));
}


// void QSortFilterProxyModel::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QSortFilterProxyModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSortFilterProxyModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QSortFilterProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)

static void _init_emitter_dataChanged_6833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QList<int>()");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_6833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QList<int> &arg3 = args ? gsi::arg_reader<const QList<int> & >() (args, heap) : gsi::arg_maker<const QList<int> & >() (QList<int>(), heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_dataChanged_6833 (arg1, arg2, arg3);
}


// exposed bool QSortFilterProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QSortFilterProxyModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_destroyed_1302 (arg1);
}


// void QSortFilterProxyModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QSortFilterProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// emitter void QSortFilterProxyModel::dynamicSortFilterChanged(bool dynamicSortFilter)

static void _init_emitter_dynamicSortFilterChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dynamicSortFilter");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_dynamicSortFilterChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_dynamicSortFilterChanged_864 (arg1);
}


// exposed void QSortFilterProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QSortFilterProxyModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endInsertColumns_0 ();
}


// exposed void QSortFilterProxyModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endInsertRows_0 ();
}


// exposed void QSortFilterProxyModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endMoveColumns_0 ();
}


// exposed void QSortFilterProxyModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endMoveRows_0 ();
}


// exposed void QSortFilterProxyModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endRemoveColumns_0 ();
}


// exposed void QSortFilterProxyModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endRemoveRows_0 ();
}


// exposed void QSortFilterProxyModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_endResetModel_0 ();
}


// bool QSortFilterProxyModel::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSortFilterProxyModel::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSortFilterProxyModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}


// bool QSortFilterProxyModel::filterAcceptsColumn(int source_column, const QModelIndex &source_parent)

static void _init_cbs_filterAcceptsColumn_c3054_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source_column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("source_parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_filterAcceptsColumn_c3054_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_filterAcceptsColumn_c3054_0 (arg1, arg2));
}

static void _set_callback_cbs_filterAcceptsColumn_c3054_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_filterAcceptsColumn_c3054_0 = cb;
}


// bool QSortFilterProxyModel::filterAcceptsRow(int source_row, const QModelIndex &source_parent)

static void _init_cbs_filterAcceptsRow_c3054_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source_row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("source_parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_filterAcceptsRow_c3054_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_filterAcceptsRow_c3054_0 (arg1, arg2));
}

static void _set_callback_cbs_filterAcceptsRow_c3054_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_filterAcceptsRow_c3054_0 = cb;
}


// emitter void QSortFilterProxyModel::filterCaseSensitivityChanged(Qt::CaseSensitivity filterCaseSensitivity)

static void _init_emitter_filterCaseSensitivityChanged_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterCaseSensitivity");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filterCaseSensitivityChanged_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_filterCaseSensitivityChanged_2324 (arg1);
}


// emitter void QSortFilterProxyModel::filterRoleChanged(int filterRole)

static void _init_emitter_filterRoleChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterRole");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filterRoleChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_filterRoleChanged_767 (arg1);
}


// QFlags<Qt::ItemFlag> QSortFilterProxyModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// bool QSortFilterProxyModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}


// QVariant QSortFilterProxyModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSortFilterProxyModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QSortFilterProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QSortFilterProxyModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// bool QSortFilterProxyModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QSortFilterProxyModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed void QSortFilterProxyModel::invalidateColumnsFilter()

static void _init_fp_invalidateColumnsFilter_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_invalidateColumnsFilter_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_invalidateColumnsFilter_0 ();
}


// exposed void QSortFilterProxyModel::invalidateFilter()

static void _init_fp_invalidateFilter_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_invalidateFilter_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_invalidateFilter_0 ();
}


// exposed void QSortFilterProxyModel::invalidateRowsFilter()

static void _init_fp_invalidateRowsFilter_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_invalidateRowsFilter_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_invalidateRowsFilter_0 ();
}


// exposed bool QSortFilterProxyModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QSortFilterProxyModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QSortFilterProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QSortFilterProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_layoutChanged_7947 (arg1, arg2);
}


// bool QSortFilterProxyModel::lessThan(const QModelIndex &source_left, const QModelIndex &source_right)

static void _init_cbs_lessThan_c4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source_left");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("source_right");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_lessThan_c4682_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_lessThan_c4682_0 (arg1, arg2));
}

static void _set_callback_cbs_lessThan_c4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_lessThan_c4682_0 = cb;
}


// QModelIndex QSortFilterProxyModel::mapFromSource(const QModelIndex &sourceIndex)

static void _init_cbs_mapFromSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapFromSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mapFromSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapFromSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mapFromSource_c2395_0 = cb;
}


// QItemSelection QSortFilterProxyModel::mapSelectionFromSource(const QItemSelection &sourceSelection)

static void _init_cbs_mapSelectionFromSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceSelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionFromSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mapSelectionFromSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionFromSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mapSelectionFromSource_c2727_0 = cb;
}


// QItemSelection QSortFilterProxyModel::mapSelectionToSource(const QItemSelection &proxySelection)

static void _init_cbs_mapSelectionToSource_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxySelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QItemSelection > ();
}

static void _call_cbs_mapSelectionToSource_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QItemSelection > ((QItemSelection)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mapSelectionToSource_c2727_0 (arg1));
}

static void _set_callback_cbs_mapSelectionToSource_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mapSelectionToSource_c2727_0 = cb;
}


// QModelIndex QSortFilterProxyModel::mapToSource(const QModelIndex &proxyIndex)

static void _init_cbs_mapToSource_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_mapToSource_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mapToSource_c2395_0 (arg1));
}

static void _set_callback_cbs_mapToSource_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mapToSource_c2395_0 = cb;
}


// QList<QModelIndex> QSortFilterProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QSortFilterProxyModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QSortFilterProxyModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSortFilterProxyModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// emitter void QSortFilterProxyModel::modelAboutToBeReset()

static void _init_emitter_modelAboutToBeReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelAboutToBeReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_modelAboutToBeReset_3767 ();
}


// emitter void QSortFilterProxyModel::modelReset()

static void _init_emitter_modelReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_modelReset_3767 ();
}


// bool QSortFilterProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QSortFilterProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// void QSortFilterProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)

static void _init_cbs_multiData_c4483_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roleDataSpan");
  decl->add_arg<QModelRoleDataSpan > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_multiData_c4483_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QModelRoleDataSpan arg2 = args.read<QModelRoleDataSpan > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_multiData_c4483_0 (arg1, arg2);
}

static void _set_callback_cbs_multiData_c4483_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_multiData_c4483_0 = cb;
}


// emitter void QSortFilterProxyModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_objectNameChanged_4567 (arg1);
}


// QModelIndex QSortFilterProxyModel::parent(const QModelIndex &child)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}


// exposed QList<QModelIndex> QSortFilterProxyModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_persistentIndexList_c0 ());
}


// exposed int QSortFilterProxyModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_receivers_c1731 (arg1));
}


// emitter void QSortFilterProxyModel::recursiveFilteringEnabledChanged(bool recursiveFilteringEnabled)

static void _init_emitter_recursiveFilteringEnabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("recursiveFilteringEnabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_recursiveFilteringEnabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_recursiveFilteringEnabledChanged_864 (arg1);
}


// bool QSortFilterProxyModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QSortFilterProxyModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// void QSortFilterProxyModel::resetInternalData()

static void _init_cbs_resetInternalData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resetInternalData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_resetInternalData_0_0 ();
}

static void _set_callback_cbs_resetInternalData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_resetInternalData_0_0 = cb;
}


// void QSortFilterProxyModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// QHash<int, QByteArray> QSortFilterProxyModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QSortFilterProxyModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSortFilterProxyModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// emitter void QSortFilterProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)

static void _init_emitter_rowsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSortFilterProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSortFilterProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)

static void _init_emitter_rowsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("row");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSortFilterProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_rowsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QObject *QSortFilterProxyModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_sender_c0 ());
}


// exposed int QSortFilterProxyModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSortFilterProxyModel_Adaptor *)cls)->fp_QSortFilterProxyModel_senderSignalIndex_c0 ());
}


// bool QSortFilterProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QSortFilterProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QSortFilterProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// void QSortFilterProxyModel::setSourceModel(QAbstractItemModel *sourceModel)

static void _init_cbs_setSourceModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSourceModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_setSourceModel_2419_0 (arg1);
}

static void _set_callback_cbs_setSourceModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_setSourceModel_2419_0 = cb;
}


// QModelIndex QSortFilterProxyModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSortFilterProxyModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QSortFilterProxyModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// emitter void QSortFilterProxyModel::sortCaseSensitivityChanged(Qt::CaseSensitivity sortCaseSensitivity)

static void _init_emitter_sortCaseSensitivityChanged_2324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sortCaseSensitivity");
  decl->add_arg<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sortCaseSensitivityChanged_2324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CaseSensitivity>::target_type & >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_sortCaseSensitivityChanged_2324 (arg1);
}


// emitter void QSortFilterProxyModel::sortLocaleAwareChanged(bool sortLocaleAware)

static void _init_emitter_sortLocaleAwareChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sortLocaleAware");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sortLocaleAwareChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_sortLocaleAwareChanged_864 (arg1);
}


// emitter void QSortFilterProxyModel::sortRoleChanged(int sortRole)

static void _init_emitter_sortRoleChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sortRole");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sortRoleChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_sortRoleChanged_767 (arg1);
}


// emitter void QSortFilterProxyModel::sourceModelChanged()

static void _init_emitter_sourceModelChanged_3914 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_sourceModelChanged_3914 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSortFilterProxyModel_Adaptor *)cls)->emitter_QSortFilterProxyModel_sourceModelChanged_3914 ();
}


// QSize QSortFilterProxyModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QSortFilterProxyModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QSortFilterProxyModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSortFilterProxyModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSortFilterProxyModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QSortFilterProxyModel::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSortFilterProxyModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSortFilterProxyModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QSortFilterProxyModel> &qtdecl_QSortFilterProxyModel ();

static gsi::Methods methods_QSortFilterProxyModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSortFilterProxyModel::QSortFilterProxyModel(QObject *parent)\nThis method creates an object of class QSortFilterProxyModel.", &_init_ctor_QSortFilterProxyModel_Adaptor_1302, &_call_ctor_QSortFilterProxyModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_autoAcceptChildRowsChanged", "@brief Emitter for signal void QSortFilterProxyModel::autoAcceptChildRowsChanged(bool autoAcceptChildRows)\nCall this method to emit this signal.", false, &_init_emitter_autoAcceptChildRowsChanged_864, &_call_emitter_autoAcceptChildRowsChanged_864);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QSortFilterProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QSortFilterProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QSortFilterProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QSortFilterProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QSortFilterProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QSortFilterProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QSortFilterProxyModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QSortFilterProxyModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QSortFilterProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QSortFilterProxyModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QSortFilterProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QSortFilterProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSortFilterProxyModel::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@brief Virtual method bool QSortFilterProxyModel::clearItemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@hide", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0, &_set_callback_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QSortFilterProxyModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeInserted", "@brief Emitter for signal void QSortFilterProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeInserted_7372, &_call_emitter_columnsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeMoved", "@brief Emitter for signal void QSortFilterProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeMoved_10318, &_call_emitter_columnsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeRemoved", "@brief Emitter for signal void QSortFilterProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeRemoved_7372, &_call_emitter_columnsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsInserted", "@brief Emitter for signal void QSortFilterProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsInserted_7372, &_call_emitter_columnsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsMoved", "@brief Emitter for signal void QSortFilterProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nCall this method to emit this signal.", false, &_init_emitter_columnsMoved_10318, &_call_emitter_columnsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsRemoved", "@brief Emitter for signal void QSortFilterProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsRemoved_7372, &_call_emitter_columnsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSortFilterProxyModel::createIndex(int row, int column, const void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c3069, &_call_fp_createIndex_c3069);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSortFilterProxyModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*createSourceIndex", "@brief Method QModelIndex QSortFilterProxyModel::createSourceIndex(int row, int col, void *internalPtr)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createSourceIndex_c2374, &_call_fp_createSourceIndex_c2374);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSortFilterProxyModel::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QSortFilterProxyModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QSortFilterProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_6833, &_call_emitter_dataChanged_6833);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QSortFilterProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSortFilterProxyModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSortFilterProxyModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QSortFilterProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("emit_dynamicSortFilterChanged", "@brief Emitter for signal void QSortFilterProxyModel::dynamicSortFilterChanged(bool dynamicSortFilter)\nCall this method to emit this signal.", false, &_init_emitter_dynamicSortFilterChanged_864, &_call_emitter_dynamicSortFilterChanged_864);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QSortFilterProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QSortFilterProxyModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QSortFilterProxyModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QSortFilterProxyModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QSortFilterProxyModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QSortFilterProxyModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QSortFilterProxyModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QSortFilterProxyModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSortFilterProxyModel::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSortFilterProxyModel::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QSortFilterProxyModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("*filterAcceptsColumn", "@brief Virtual method bool QSortFilterProxyModel::filterAcceptsColumn(int source_column, const QModelIndex &source_parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_filterAcceptsColumn_c3054_0, &_call_cbs_filterAcceptsColumn_c3054_0);
  methods += new qt_gsi::GenericMethod ("*filterAcceptsColumn", "@hide", true, &_init_cbs_filterAcceptsColumn_c3054_0, &_call_cbs_filterAcceptsColumn_c3054_0, &_set_callback_cbs_filterAcceptsColumn_c3054_0);
  methods += new qt_gsi::GenericMethod ("*filterAcceptsRow", "@brief Virtual method bool QSortFilterProxyModel::filterAcceptsRow(int source_row, const QModelIndex &source_parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_filterAcceptsRow_c3054_0, &_call_cbs_filterAcceptsRow_c3054_0);
  methods += new qt_gsi::GenericMethod ("*filterAcceptsRow", "@hide", true, &_init_cbs_filterAcceptsRow_c3054_0, &_call_cbs_filterAcceptsRow_c3054_0, &_set_callback_cbs_filterAcceptsRow_c3054_0);
  methods += new qt_gsi::GenericMethod ("emit_filterCaseSensitivityChanged", "@brief Emitter for signal void QSortFilterProxyModel::filterCaseSensitivityChanged(Qt::CaseSensitivity filterCaseSensitivity)\nCall this method to emit this signal.", false, &_init_emitter_filterCaseSensitivityChanged_2324, &_call_emitter_filterCaseSensitivityChanged_2324);
  methods += new qt_gsi::GenericMethod ("emit_filterRoleChanged", "@brief Emitter for signal void QSortFilterProxyModel::filterRoleChanged(int filterRole)\nCall this method to emit this signal.", false, &_init_emitter_filterRoleChanged_767, &_call_emitter_filterRoleChanged_767);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QSortFilterProxyModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QSortFilterProxyModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QSortFilterProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QSortFilterProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QSortFilterProxyModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QSortFilterProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QSortFilterProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*invalidateColumnsFilter", "@brief Method void QSortFilterProxyModel::invalidateColumnsFilter()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_invalidateColumnsFilter_0, &_call_fp_invalidateColumnsFilter_0);
  methods += new qt_gsi::GenericMethod ("*invalidateFilter", "@brief Method void QSortFilterProxyModel::invalidateFilter()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_invalidateFilter_0, &_call_fp_invalidateFilter_0);
  methods += new qt_gsi::GenericMethod ("*invalidateRowsFilter", "@brief Method void QSortFilterProxyModel::invalidateRowsFilter()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_invalidateRowsFilter_0, &_call_fp_invalidateRowsFilter_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSortFilterProxyModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QSortFilterProxyModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QSortFilterProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QSortFilterProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("*lessThan", "@brief Virtual method bool QSortFilterProxyModel::lessThan(const QModelIndex &source_left, const QModelIndex &source_right)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_lessThan_c4682_0, &_call_cbs_lessThan_c4682_0);
  methods += new qt_gsi::GenericMethod ("*lessThan", "@hide", true, &_init_cbs_lessThan_c4682_0, &_call_cbs_lessThan_c4682_0, &_set_callback_cbs_lessThan_c4682_0);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Virtual method QModelIndex QSortFilterProxyModel::mapFromSource(const QModelIndex &sourceIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@hide", true, &_init_cbs_mapFromSource_c2395_0, &_call_cbs_mapFromSource_c2395_0, &_set_callback_cbs_mapFromSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@brief Virtual method QItemSelection QSortFilterProxyModel::mapSelectionFromSource(const QItemSelection &sourceSelection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionFromSource", "@hide", true, &_init_cbs_mapSelectionFromSource_c2727_0, &_call_cbs_mapSelectionFromSource_c2727_0, &_set_callback_cbs_mapSelectionFromSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@brief Virtual method QItemSelection QSortFilterProxyModel::mapSelectionToSource(const QItemSelection &proxySelection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapSelectionToSource", "@hide", true, &_init_cbs_mapSelectionToSource_c2727_0, &_call_cbs_mapSelectionToSource_c2727_0, &_set_callback_cbs_mapSelectionToSource_c2727_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Virtual method QModelIndex QSortFilterProxyModel::mapToSource(const QModelIndex &proxyIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@hide", true, &_init_cbs_mapToSource_c2395_0, &_call_cbs_mapToSource_c2395_0, &_set_callback_cbs_mapToSource_c2395_0);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QSortFilterProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QSortFilterProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QSortFilterProxyModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modelAboutToBeReset", "@brief Emitter for signal void QSortFilterProxyModel::modelAboutToBeReset()\nCall this method to emit this signal.", false, &_init_emitter_modelAboutToBeReset_3767, &_call_emitter_modelAboutToBeReset_3767);
  methods += new qt_gsi::GenericMethod ("emit_modelReset", "@brief Emitter for signal void QSortFilterProxyModel::modelReset()\nCall this method to emit this signal.", false, &_init_emitter_modelReset_3767, &_call_emitter_modelReset_3767);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QSortFilterProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QSortFilterProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@brief Virtual method void QSortFilterProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@hide", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0, &_set_callback_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSortFilterProxyModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QSortFilterProxyModel::parent(const QModelIndex &child)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QSortFilterProxyModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSortFilterProxyModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_recursiveFilteringEnabledChanged", "@brief Emitter for signal void QSortFilterProxyModel::recursiveFilteringEnabledChanged(bool recursiveFilteringEnabled)\nCall this method to emit this signal.", false, &_init_emitter_recursiveFilteringEnabledChanged_864, &_call_emitter_recursiveFilteringEnabledChanged_864);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QSortFilterProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QSortFilterProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Virtual method void QSortFilterProxyModel::resetInternalData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@hide", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0, &_set_callback_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QSortFilterProxyModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QSortFilterProxyModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QSortFilterProxyModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeInserted", "@brief Emitter for signal void QSortFilterProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeInserted_7372, &_call_emitter_rowsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeMoved", "@brief Emitter for signal void QSortFilterProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeMoved_10318, &_call_emitter_rowsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeRemoved", "@brief Emitter for signal void QSortFilterProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeRemoved_7372, &_call_emitter_rowsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsInserted", "@brief Emitter for signal void QSortFilterProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsInserted_7372, &_call_emitter_rowsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsMoved", "@brief Emitter for signal void QSortFilterProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nCall this method to emit this signal.", false, &_init_emitter_rowsMoved_10318, &_call_emitter_rowsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsRemoved", "@brief Emitter for signal void QSortFilterProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsRemoved_7372, &_call_emitter_rowsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSortFilterProxyModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSortFilterProxyModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QSortFilterProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QSortFilterProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QSortFilterProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@brief Virtual method void QSortFilterProxyModel::setSourceModel(QAbstractItemModel *sourceModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setSourceModel", "@hide", false, &_init_cbs_setSourceModel_2419_0, &_call_cbs_setSourceModel_2419_0, &_set_callback_cbs_setSourceModel_2419_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QSortFilterProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QSortFilterProxyModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("emit_sortCaseSensitivityChanged", "@brief Emitter for signal void QSortFilterProxyModel::sortCaseSensitivityChanged(Qt::CaseSensitivity sortCaseSensitivity)\nCall this method to emit this signal.", false, &_init_emitter_sortCaseSensitivityChanged_2324, &_call_emitter_sortCaseSensitivityChanged_2324);
  methods += new qt_gsi::GenericMethod ("emit_sortLocaleAwareChanged", "@brief Emitter for signal void QSortFilterProxyModel::sortLocaleAwareChanged(bool sortLocaleAware)\nCall this method to emit this signal.", false, &_init_emitter_sortLocaleAwareChanged_864, &_call_emitter_sortLocaleAwareChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_sortRoleChanged", "@brief Emitter for signal void QSortFilterProxyModel::sortRoleChanged(int sortRole)\nCall this method to emit this signal.", false, &_init_emitter_sortRoleChanged_767, &_call_emitter_sortRoleChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_sourceModelChanged", "@brief Emitter for signal void QSortFilterProxyModel::sourceModelChanged()\nCall this method to emit this signal.", false, &_init_emitter_sourceModelChanged_3914, &_call_emitter_sourceModelChanged_3914);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QSortFilterProxyModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QSortFilterProxyModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QSortFilterProxyModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSortFilterProxyModel::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QSortFilterProxyModel_Adaptor> decl_QSortFilterProxyModel_Adaptor (qtdecl_QSortFilterProxyModel (), "QtCore", "QSortFilterProxyModel",
  methods_QSortFilterProxyModel_Adaptor (),
  "@qt\n@brief Binding of QSortFilterProxyModel");

}

