#---------------------------------------------------------------------------------------
# Bundle: KLayoutStd.app
#
# Descriptions:
#  This script invokes the standard 'klayout.app' application bundle.
#  More specifically, it uses the embedded Qt5.
#  Ruby and Python packages should be in the default directories.
#---------------------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Localizing the language
# Workaround discussed in https://github.com/KLayout/klayout/issues/1213
#--------------------------------------------------------------------------
export LANG=$(defaults read -g AppleLocale).UTF-8

#--------------------------------------------------------------------------
# Your setups
#--------------------------------------------------------------------------

#--------------------------------------------------------------------------
# Export the 'KLAYOUT_GIT_HTTP_PROXY' environment variable if you need to
# use the git-based Salt Package Manager through a proxy server.
#--------------------------------------------------------------------------
#export KLAYOUT_GIT_HTTP_PROXY="http://111.222.333.444:5678"

#--------------------------------------------------------------------------
# Export the 'PYTHONHOME' environment variable if required
#--------------------------------------------------------------------------
#export PYTHONHOME=

#--------------------------------------------------------------------------
# With "-n" option, you can invoke multiple instances
#--------------------------------------------------------------------------
myklayout=/Applications/klayout.app
myconfig=$HOME/.klayout/klayoutrc

open -n -a $myklayout --args -e -c $myconfig -style=fusion $@
