
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractTextDocumentLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractTextDocumentLayout>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPaintDevice>
#include <QPainter>
#include <QPointF>
#include <QRectF>
#include <QSizeF>
#include <QTextBlock>
#include <QTextCharFormat>
#include <QTextDocument>
#include <QTextFormat>
#include <QTextFrame>
#include <QTextInlineObject>
#include <QTextObjectInterface>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractTextDocumentLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractTextDocumentLayout::staticMetaObject);
}


// QString QAbstractTextDocumentLayout::anchorAt(const QPointF &pos)


static void _init_f_anchorAt_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_anchorAt_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QString > ((QString)((QAbstractTextDocumentLayout *)cls)->anchorAt (arg1));
}


// QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)


static void _init_f_blockBoundingRect_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_blockBoundingRect_c2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout *)cls)->blockBoundingRect (arg1));
}


// QTextDocument *QAbstractTextDocumentLayout::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocument * > ((QTextDocument *)((QAbstractTextDocumentLayout *)cls)->document ());
}


// QSizeF QAbstractTextDocumentLayout::documentSize()


static void _init_f_documentSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_documentSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QAbstractTextDocumentLayout *)cls)->documentSize ());
}


// void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)


static void _init_f_draw_6787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_draw_6787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QAbstractTextDocumentLayout::PaintContext &arg2 = gsi::arg_reader<const QAbstractTextDocumentLayout::PaintContext & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout *)cls)->draw (arg1, arg2);
}


// QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)


static void _init_f_frameBoundingRect_c1615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_frameBoundingRect_c1615 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextFrame *arg1 = gsi::arg_reader<QTextFrame * >() (args, heap);
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout *)cls)->frameBoundingRect (arg1));
}


// QTextObjectInterface *QAbstractTextDocumentLayout::handlerForObject(int objectType)


static void _init_f_handlerForObject_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectType");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextObjectInterface * > ();
}

static void _call_f_handlerForObject_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTextObjectInterface * > ((QTextObjectInterface *)((QAbstractTextDocumentLayout *)cls)->handlerForObject (arg1));
}


// int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)


static void _init_f_hitTest_c4147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("accuracy");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_hitTest_c4147 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & >() (args, heap);
  ret.write<int > ((int)((QAbstractTextDocumentLayout *)cls)->hitTest (arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref()));
}


// int QAbstractTextDocumentLayout::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractTextDocumentLayout *)cls)->pageCount ());
}


// QPaintDevice *QAbstractTextDocumentLayout::paintDevice()


static void _init_f_paintDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_paintDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QAbstractTextDocumentLayout *)cls)->paintDevice ());
}


// void QAbstractTextDocumentLayout::registerHandler(int objectType, QObject *component)


static void _init_f_registerHandler_1961 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectType");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("component");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_registerHandler_1961 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QObject *arg2 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout *)cls)->registerHandler (arg1, arg2);
}


// void QAbstractTextDocumentLayout::setPaintDevice(QPaintDevice *device)


static void _init_f_setPaintDevice_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaintDevice_1803 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout *)cls)->setPaintDevice (arg1);
}


// void QAbstractTextDocumentLayout::unregisterHandler(int objectType, QObject *component)


static void _init_f_unregisterHandler_1961 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectType");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("component", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_unregisterHandler_1961 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout *)cls)->unregisterHandler (arg1, arg2);
}


// static QString QAbstractTextDocumentLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::tr (arg1, arg2, arg3));
}


// static QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractTextDocumentLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("anchorAt", "@brief Method QString QAbstractTextDocumentLayout::anchorAt(const QPointF &pos)\n", true, &_init_f_anchorAt_c1986, &_call_f_anchorAt_c1986);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Method QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\n", true, &_init_f_blockBoundingRect_c2306, &_call_f_blockBoundingRect_c2306);
  methods += new qt_gsi::GenericMethod ("document", "@brief Method QTextDocument *QAbstractTextDocumentLayout::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@brief Method QSizeF QAbstractTextDocumentLayout::documentSize()\n", true, &_init_f_documentSize_c0, &_call_f_documentSize_c0);
  methods += new qt_gsi::GenericMethod ("draw", "@brief Method void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)\n", false, &_init_f_draw_6787, &_call_f_draw_6787);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Method QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)\n", true, &_init_f_frameBoundingRect_c1615, &_call_f_frameBoundingRect_c1615);
  methods += new qt_gsi::GenericMethod ("handlerForObject", "@brief Method QTextObjectInterface *QAbstractTextDocumentLayout::handlerForObject(int objectType)\n", true, &_init_f_handlerForObject_c767, &_call_f_handlerForObject_c767);
  methods += new qt_gsi::GenericMethod ("hitTest", "@brief Method int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)\n", true, &_init_f_hitTest_c4147, &_call_f_hitTest_c4147);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Method int QAbstractTextDocumentLayout::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
  methods += new qt_gsi::GenericMethod (":paintDevice", "@brief Method QPaintDevice *QAbstractTextDocumentLayout::paintDevice()\n", true, &_init_f_paintDevice_c0, &_call_f_paintDevice_c0);
  methods += new qt_gsi::GenericMethod ("registerHandler", "@brief Method void QAbstractTextDocumentLayout::registerHandler(int objectType, QObject *component)\n", false, &_init_f_registerHandler_1961, &_call_f_registerHandler_1961);
  methods += new qt_gsi::GenericMethod ("setPaintDevice|paintDevice=", "@brief Method void QAbstractTextDocumentLayout::setPaintDevice(QPaintDevice *device)\n", false, &_init_f_setPaintDevice_1803, &_call_f_setPaintDevice_1803);
  methods += new qt_gsi::GenericMethod ("unregisterHandler", "@brief Method void QAbstractTextDocumentLayout::unregisterHandler(int objectType, QObject *component)\n", false, &_init_f_unregisterHandler_1961, &_call_f_unregisterHandler_1961);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractTextDocumentLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSizeF & > ("documentSizeChanged(const QSizeF &)", "documentSizeChanged", gsi::arg("newSize"), "@brief Signal declaration for QAbstractTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractTextDocumentLayout::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("pageCountChanged(int)", "pageCountChanged", gsi::arg("newPages"), "@brief Signal declaration for QAbstractTextDocumentLayout::pageCountChanged(int newPages)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRectF & > ("update(const QRectF &)", "update", gsi::arg("arg1"), "@brief Signal declaration for QAbstractTextDocumentLayout::update(const QRectF &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QTextBlock & > ("updateBlock(const QTextBlock &)", "updateBlock", gsi::arg("block"), "@brief Signal declaration for QAbstractTextDocumentLayout::updateBlock(const QTextBlock &block)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractTextDocumentLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractTextDocumentLayout> decl_QAbstractTextDocumentLayout (qtdecl_QObject (), "QtGui", "QAbstractTextDocumentLayout_Native",
  methods_QAbstractTextDocumentLayout (),
  "@hide\n@alias QAbstractTextDocumentLayout");

GSI_QTGUI_PUBLIC gsi::Class<QAbstractTextDocumentLayout> &qtdecl_QAbstractTextDocumentLayout () { return decl_QAbstractTextDocumentLayout; }

}


class QAbstractTextDocumentLayout_Adaptor : public QAbstractTextDocumentLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractTextDocumentLayout_Adaptor();

  //  [adaptor ctor] QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc)
  QAbstractTextDocumentLayout_Adaptor(QTextDocument *doc) : QAbstractTextDocumentLayout(doc)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QTextCharFormat QAbstractTextDocumentLayout::format(int pos)
  QTextCharFormat fp_QAbstractTextDocumentLayout_format_767 (int pos) {
    return QAbstractTextDocumentLayout::format(pos);
  }

  //  [expose] int QAbstractTextDocumentLayout::formatIndex(int pos)
  int fp_QAbstractTextDocumentLayout_formatIndex_767 (int pos) {
    return QAbstractTextDocumentLayout::formatIndex(pos);
  }

  //  [expose] bool QAbstractTextDocumentLayout::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractTextDocumentLayout_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractTextDocumentLayout::isSignalConnected(signal);
  }

  //  [expose] int QAbstractTextDocumentLayout::receivers(const char *signal)
  int fp_QAbstractTextDocumentLayout_receivers_c1731 (const char *signal) const {
    return QAbstractTextDocumentLayout::receivers(signal);
  }

  //  [expose] QObject *QAbstractTextDocumentLayout::sender()
  QObject * fp_QAbstractTextDocumentLayout_sender_c0 () const {
    return QAbstractTextDocumentLayout::sender();
  }

  //  [expose] int QAbstractTextDocumentLayout::senderSignalIndex()
  int fp_QAbstractTextDocumentLayout_senderSignalIndex_c0 () const {
    return QAbstractTextDocumentLayout::senderSignalIndex();
  }

  //  [adaptor impl] QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)
  QRectF cbs_blockBoundingRect_c2306_0(const QTextBlock &block) const
  {
    __SUPPRESS_UNUSED_WARNING (block);
    throw qt_gsi::AbstractMethodCalledException("blockBoundingRect");
  }

  virtual QRectF blockBoundingRect(const QTextBlock &block) const
  {
    if (cb_blockBoundingRect_c2306_0.can_issue()) {
      return cb_blockBoundingRect_c2306_0.issue<QAbstractTextDocumentLayout_Adaptor, QRectF, const QTextBlock &>(&QAbstractTextDocumentLayout_Adaptor::cbs_blockBoundingRect_c2306_0, block);
    } else {
      throw qt_gsi::AbstractMethodCalledException("blockBoundingRect");
    }
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::destroyed(QObject *)
  void emitter_QAbstractTextDocumentLayout_destroyed_1302(QObject *arg1)
  {
    emit QAbstractTextDocumentLayout::destroyed(arg1);
  }

  //  [adaptor impl] QSizeF QAbstractTextDocumentLayout::documentSize()
  QSizeF cbs_documentSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("documentSize");
  }

  virtual QSizeF documentSize() const
  {
    if (cb_documentSize_c0_0.can_issue()) {
      return cb_documentSize_c0_0.issue<QAbstractTextDocumentLayout_Adaptor, QSizeF>(&QAbstractTextDocumentLayout_Adaptor::cbs_documentSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("documentSize");
    }
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)
  void emitter_QAbstractTextDocumentLayout_documentSizeChanged_1875(const QSizeF &newSize)
  {
    emit QAbstractTextDocumentLayout::documentSizeChanged(newSize);
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  void cbs_draw_6787_0(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  {
    __SUPPRESS_UNUSED_WARNING (painter);
    __SUPPRESS_UNUSED_WARNING (context);
    throw qt_gsi::AbstractMethodCalledException("draw");
  }

  virtual void draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  {
    if (cb_draw_6787_0.can_issue()) {
      cb_draw_6787_0.issue<QAbstractTextDocumentLayout_Adaptor, QPainter *, const QAbstractTextDocumentLayout::PaintContext &>(&QAbstractTextDocumentLayout_Adaptor::cbs_draw_6787_0, painter, context);
    } else {
      throw qt_gsi::AbstractMethodCalledException("draw");
    }
  }

  //  [adaptor impl] bool QAbstractTextDocumentLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractTextDocumentLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractTextDocumentLayout_Adaptor, bool, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractTextDocumentLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractTextDocumentLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractTextDocumentLayout_Adaptor, bool, QObject *, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractTextDocumentLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)
  QRectF cbs_frameBoundingRect_c1615_0(QTextFrame *frame) const
  {
    __SUPPRESS_UNUSED_WARNING (frame);
    throw qt_gsi::AbstractMethodCalledException("frameBoundingRect");
  }

  virtual QRectF frameBoundingRect(QTextFrame *frame) const
  {
    if (cb_frameBoundingRect_c1615_0.can_issue()) {
      return cb_frameBoundingRect_c1615_0.issue<QAbstractTextDocumentLayout_Adaptor, QRectF, QTextFrame *>(&QAbstractTextDocumentLayout_Adaptor::cbs_frameBoundingRect_c1615_0, frame);
    } else {
      throw qt_gsi::AbstractMethodCalledException("frameBoundingRect");
    }
  }

  //  [adaptor impl] int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)
  int cbs_hitTest_c4147_0(const QPointF &point, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & accuracy) const
  {
    __SUPPRESS_UNUSED_WARNING (point);
    __SUPPRESS_UNUSED_WARNING (accuracy);
    throw qt_gsi::AbstractMethodCalledException("hitTest");
  }

  virtual int hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy) const
  {
    if (cb_hitTest_c4147_0.can_issue()) {
      return cb_hitTest_c4147_0.issue<QAbstractTextDocumentLayout_Adaptor, int, const QPointF &, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type &>(&QAbstractTextDocumentLayout_Adaptor::cbs_hitTest_c4147_0, point, qt_gsi::CppToQtAdaptor<Qt::HitTestAccuracy>(accuracy));
    } else {
      throw qt_gsi::AbstractMethodCalledException("hitTest");
    }
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::objectNameChanged(const QString &objectName)
  void emitter_QAbstractTextDocumentLayout_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractTextDocumentLayout::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] int QAbstractTextDocumentLayout::pageCount()
  int cbs_pageCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("pageCount");
  }

  virtual int pageCount() const
  {
    if (cb_pageCount_c0_0.can_issue()) {
      return cb_pageCount_c0_0.issue<QAbstractTextDocumentLayout_Adaptor, int>(&QAbstractTextDocumentLayout_Adaptor::cbs_pageCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pageCount");
    }
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::pageCountChanged(int newPages)
  void emitter_QAbstractTextDocumentLayout_pageCountChanged_767(int newPages)
  {
    emit QAbstractTextDocumentLayout::pageCountChanged(newPages);
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::update(const QRectF &)
  void emitter_QAbstractTextDocumentLayout_update_1862(const QRectF &arg1)
  {
    emit QAbstractTextDocumentLayout::update(arg1);
  }

  //  [emitter impl] void QAbstractTextDocumentLayout::updateBlock(const QTextBlock &block)
  void emitter_QAbstractTextDocumentLayout_updateBlock_2306(const QTextBlock &block)
  {
    emit QAbstractTextDocumentLayout::updateBlock(block);
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractTextDocumentLayout::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractTextDocumentLayout_Adaptor, QChildEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractTextDocumentLayout::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractTextDocumentLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractTextDocumentLayout_Adaptor, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractTextDocumentLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractTextDocumentLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractTextDocumentLayout_Adaptor, const QMetaMethod &>(&QAbstractTextDocumentLayout_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractTextDocumentLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)
  void cbs_documentChanged_2085_0(int from, int charsRemoved, int charsAdded)
  {
    __SUPPRESS_UNUSED_WARNING (from);
    __SUPPRESS_UNUSED_WARNING (charsRemoved);
    __SUPPRESS_UNUSED_WARNING (charsAdded);
    throw qt_gsi::AbstractMethodCalledException("documentChanged");
  }

  virtual void documentChanged(int from, int charsRemoved, int charsAdded)
  {
    if (cb_documentChanged_2085_0.can_issue()) {
      cb_documentChanged_2085_0.issue<QAbstractTextDocumentLayout_Adaptor, int, int, int>(&QAbstractTextDocumentLayout_Adaptor::cbs_documentChanged_2085_0, from, charsRemoved, charsAdded);
    } else {
      throw qt_gsi::AbstractMethodCalledException("documentChanged");
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  void cbs_drawInlineObject_8199_0(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
  }

  virtual void drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    if (cb_drawInlineObject_8199_0.can_issue()) {
      cb_drawInlineObject_8199_0.issue<QAbstractTextDocumentLayout_Adaptor, QPainter *, const QRectF &, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_drawInlineObject_8199_0, painter, rect, object, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_positionInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
  }

  virtual void positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_positionInlineObject_5127_0.can_issue()) {
      cb_positionInlineObject_5127_0.issue<QAbstractTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_positionInlineObject_5127_0, item, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_resizeInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
  }

  virtual void resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_resizeInlineObject_5127_0.can_issue()) {
      cb_resizeInlineObject_5127_0.issue<QAbstractTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_resizeInlineObject_5127_0, item, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractTextDocumentLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractTextDocumentLayout_Adaptor, QTimerEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractTextDocumentLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_blockBoundingRect_c2306_0;
  gsi::Callback cb_documentSize_c0_0;
  gsi::Callback cb_draw_6787_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_frameBoundingRect_c1615_0;
  gsi::Callback cb_hitTest_c4147_0;
  gsi::Callback cb_pageCount_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_documentChanged_2085_0;
  gsi::Callback cb_drawInlineObject_8199_0;
  gsi::Callback cb_positionInlineObject_5127_0;
  gsi::Callback cb_resizeInlineObject_5127_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractTextDocumentLayout_Adaptor::~QAbstractTextDocumentLayout_Adaptor() { }

//  Constructor QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc) (adaptor class)

static void _init_ctor_QAbstractTextDocumentLayout_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("doc");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QAbstractTextDocumentLayout_Adaptor> ();
}

static void _call_ctor_QAbstractTextDocumentLayout_Adaptor_1955 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  ret.write<QAbstractTextDocumentLayout_Adaptor *> (new QAbstractTextDocumentLayout_Adaptor (arg1));
}


// QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)

static void _init_cbs_blockBoundingRect_c2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_blockBoundingRect_c2306_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = args.read<const QTextBlock & > (heap);
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_blockBoundingRect_c2306_0 (arg1));
}

static void _set_callback_cbs_blockBoundingRect_c2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_blockBoundingRect_c2306_0 = cb;
}


// void QAbstractTextDocumentLayout::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractTextDocumentLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAbstractTextDocumentLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_destroyed_1302 (arg1);
}


// void QAbstractTextDocumentLayout::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)

static void _init_cbs_documentChanged_2085_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("charsRemoved");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("charsAdded");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_documentChanged_2085_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_documentChanged_2085_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_documentChanged_2085_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_documentChanged_2085_0 = cb;
}


// QSizeF QAbstractTextDocumentLayout::documentSize()

static void _init_cbs_documentSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_cbs_documentSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_documentSize_c0_0 ());
}

static void _set_callback_cbs_documentSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_documentSize_c0_0 = cb;
}


// emitter void QAbstractTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)

static void _init_emitter_documentSizeChanged_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSize");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_documentSizeChanged_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_documentSizeChanged_1875 (arg1);
}


// void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)

static void _init_cbs_draw_6787_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_draw_6787_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_draw_6787_0 (arg1, arg2);
}

static void _set_callback_cbs_draw_6787_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_draw_6787_0 = cb;
}


// void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)

static void _init_cbs_drawInlineObject_8199_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("object");
  decl->add_arg<QTextInlineObject > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("posInDocument");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("format");
  decl->add_arg<const QTextFormat & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_cbs_drawInlineObject_8199_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  QTextInlineObject arg3 = args.read<QTextInlineObject > (heap);
  int arg4 = args.read<int > (heap);
  const QTextFormat &arg5 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_drawInlineObject_8199_0 (arg1, arg2, arg3, arg4, arg5);
}

static void _set_callback_cbs_drawInlineObject_8199_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_drawInlineObject_8199_0 = cb;
}


// bool QAbstractTextDocumentLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed QTextCharFormat QAbstractTextDocumentLayout::format(int pos)

static void _init_fp_format_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_fp_format_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_format_767 (arg1));
}


// exposed int QAbstractTextDocumentLayout::formatIndex(int pos)

static void _init_fp_formatIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_formatIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_formatIndex_767 (arg1));
}


// QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)

static void _init_cbs_frameBoundingRect_c1615_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_frameBoundingRect_c1615_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextFrame *arg1 = args.read<QTextFrame * > (heap);
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_frameBoundingRect_c1615_0 (arg1));
}

static void _set_callback_cbs_frameBoundingRect_c1615_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_frameBoundingRect_c1615_0 = cb;
}


// int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)

static void _init_cbs_hitTest_c4147_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("accuracy");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_cbs_hitTest_c4147_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (heap);
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_hitTest_c4147_0 (arg1, arg2));
}

static void _set_callback_cbs_hitTest_c4147_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_hitTest_c4147_0 = cb;
}


// exposed bool QAbstractTextDocumentLayout::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractTextDocumentLayout::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_objectNameChanged_4567 (arg1);
}


// int QAbstractTextDocumentLayout::pageCount()

static void _init_cbs_pageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_pageCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_pageCount_c0_0 ());
}

static void _set_callback_cbs_pageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_pageCount_c0_0 = cb;
}


// emitter void QAbstractTextDocumentLayout::pageCountChanged(int newPages)

static void _init_emitter_pageCountChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newPages");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pageCountChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_pageCountChanged_767 (arg1);
}


// void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_positionInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_positionInlineObject_5127_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextInlineObject arg1 = args.read<QTextInlineObject > (heap);
  int arg2 = args.read<int > (heap);
  const QTextFormat &arg3 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_positionInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_positionInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_positionInlineObject_5127_0 = cb;
}


// exposed int QAbstractTextDocumentLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_receivers_c1731 (arg1));
}


// void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_resizeInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_resizeInlineObject_5127_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextInlineObject arg1 = args.read<QTextInlineObject > (heap);
  int arg2 = args.read<int > (heap);
  const QTextFormat &arg3 = args.read<const QTextFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_resizeInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_resizeInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_resizeInlineObject_5127_0 = cb;
}


// exposed QObject *QAbstractTextDocumentLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_sender_c0 ());
}


// exposed int QAbstractTextDocumentLayout::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_senderSignalIndex_c0 ());
}


// void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QAbstractTextDocumentLayout::update(const QRectF &)

static void _init_emitter_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QRectF(0., 0., 1000000000., 1000000000.)");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_update_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(0., 0., 1000000000., 1000000000.), heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_update_1862 (arg1);
}


// emitter void QAbstractTextDocumentLayout::updateBlock(const QTextBlock &block)

static void _init_emitter_updateBlock_2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_updateBlock_2306 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextBlock &arg1 = gsi::arg_reader<const QTextBlock & >() (args, heap);
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->emitter_QAbstractTextDocumentLayout_updateBlock_2306 (arg1);
}


namespace gsi
{

gsi::Class<QAbstractTextDocumentLayout> &qtdecl_QAbstractTextDocumentLayout ();

static gsi::Methods methods_QAbstractTextDocumentLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc)\nThis method creates an object of class QAbstractTextDocumentLayout.", &_init_ctor_QAbstractTextDocumentLayout_Adaptor_1955, &_call_ctor_QAbstractTextDocumentLayout_Adaptor_1955);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Virtual method QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0);
  methods += new qt_gsi::GenericMethod ("blockBoundingRect", "@hide", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0, &_set_callback_cbs_blockBoundingRect_c2306_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractTextDocumentLayout::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractTextDocumentLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractTextDocumentLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractTextDocumentLayout::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*documentChanged", "@brief Virtual method void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0);
  methods += new qt_gsi::GenericMethod ("*documentChanged", "@hide", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0, &_set_callback_cbs_documentChanged_2085_0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@brief Virtual method QSizeF QAbstractTextDocumentLayout::documentSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0);
  methods += new qt_gsi::GenericMethod ("documentSize", "@hide", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0, &_set_callback_cbs_documentSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_documentSizeChanged", "@brief Emitter for signal void QAbstractTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nCall this method to emit this signal.", false, &_init_emitter_documentSizeChanged_1875, &_call_emitter_documentSizeChanged_1875);
  methods += new qt_gsi::GenericMethod ("draw", "@brief Virtual method void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0);
  methods += new qt_gsi::GenericMethod ("draw", "@hide", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0, &_set_callback_cbs_draw_6787_0);
  methods += new qt_gsi::GenericMethod ("*drawInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0);
  methods += new qt_gsi::GenericMethod ("*drawInlineObject", "@hide", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0, &_set_callback_cbs_drawInlineObject_8199_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractTextDocumentLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*format", "@brief Method QTextCharFormat QAbstractTextDocumentLayout::format(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_format_767, &_call_fp_format_767);
  methods += new qt_gsi::GenericMethod ("*formatIndex", "@brief Method int QAbstractTextDocumentLayout::formatIndex(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_formatIndex_767, &_call_fp_formatIndex_767);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Virtual method QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0);
  methods += new qt_gsi::GenericMethod ("frameBoundingRect", "@hide", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0, &_set_callback_cbs_frameBoundingRect_c1615_0);
  methods += new qt_gsi::GenericMethod ("hitTest", "@brief Virtual method int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0);
  methods += new qt_gsi::GenericMethod ("hitTest", "@hide", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0, &_set_callback_cbs_hitTest_c4147_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractTextDocumentLayout::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractTextDocumentLayout::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Virtual method int QAbstractTextDocumentLayout::pageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("pageCount", "@hide", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0, &_set_callback_cbs_pageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_pageCountChanged", "@brief Emitter for signal void QAbstractTextDocumentLayout::pageCountChanged(int newPages)\nCall this method to emit this signal.", false, &_init_emitter_pageCountChanged_767, &_call_emitter_pageCountChanged_767);
  methods += new qt_gsi::GenericMethod ("*positionInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*positionInlineObject", "@hide", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0, &_set_callback_cbs_positionInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractTextDocumentLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resizeInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*resizeInlineObject", "@hide", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0, &_set_callback_cbs_resizeInlineObject_5127_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractTextDocumentLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractTextDocumentLayout::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_update", "@brief Emitter for signal void QAbstractTextDocumentLayout::update(const QRectF &)\nCall this method to emit this signal.", false, &_init_emitter_update_1862, &_call_emitter_update_1862);
  methods += new qt_gsi::GenericMethod ("emit_updateBlock", "@brief Emitter for signal void QAbstractTextDocumentLayout::updateBlock(const QTextBlock &block)\nCall this method to emit this signal.", false, &_init_emitter_updateBlock_2306, &_call_emitter_updateBlock_2306);
  return methods;
}

gsi::Class<QAbstractTextDocumentLayout_Adaptor> decl_QAbstractTextDocumentLayout_Adaptor (qtdecl_QAbstractTextDocumentLayout (), "QtGui", "QAbstractTextDocumentLayout",
  methods_QAbstractTextDocumentLayout_Adaptor (),
  "@qt\n@brief Binding of QAbstractTextDocumentLayout");

}

