
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCamera.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCamera>
#include <QVideoWidget>
#include <QGraphicsVideoItem>
#include <QAbstractVideoSurface>
#include <QCameraInfo>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCamera

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCamera::staticMetaObject);
}


// QMultimedia::AvailabilityStatus QCamera::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QCamera *)cls)->availability ()));
}


// QFlags<QCamera::CaptureMode> QCamera::captureMode()


static void _init_f_captureMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::CaptureMode> > ();
}

static void _call_f_captureMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::CaptureMode> > ((QFlags<QCamera::CaptureMode>)((QCamera *)cls)->captureMode ());
}


// void QCamera::captureModeChanged(QFlags<QCamera::CaptureMode>)


static void _init_f_captureModeChanged_3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_captureModeChanged_3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->captureModeChanged (arg1);
}


// QCamera::Error QCamera::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::Error>::target_type > ((qt_gsi::Converter<QCamera::Error>::target_type)qt_gsi::CppToQtAdaptor<QCamera::Error>(((QCamera *)cls)->error ()));
}


// void QCamera::error(QCamera::Error)


static void _init_f_error_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_1740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->error (qt_gsi::QtToCppAdaptor<QCamera::Error>(arg1).cref());
}


// QString QCamera::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCamera *)cls)->errorString ());
}


// QCameraExposure *QCamera::exposure()


static void _init_f_exposure_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraExposure * > ();
}

static void _call_f_exposure_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraExposure * > ((QCameraExposure *)((QCamera *)cls)->exposure ());
}


// QCameraFocus *QCamera::focus()


static void _init_f_focus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraFocus * > ();
}

static void _call_f_focus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraFocus * > ((QCameraFocus *)((QCamera *)cls)->focus ());
}


// QCameraImageProcessing *QCamera::imageProcessing()


static void _init_f_imageProcessing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraImageProcessing * > ();
}

static void _call_f_imageProcessing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraImageProcessing * > ((QCameraImageProcessing *)((QCamera *)cls)->imageProcessing ());
}


// bool QCamera::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)


static void _init_f_isCaptureModeSupported_c3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCaptureModeSupported_c3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isCaptureModeSupported (arg1));
}


// void QCamera::load()


static void _init_f_load_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_load_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->load ();
}


// void QCamera::lockFailed()


static void _init_f_lockFailed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_lockFailed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->lockFailed ();
}


// QCamera::LockStatus QCamera::lockStatus()


static void _init_f_lockStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::LockStatus>::target_type > ();
}

static void _call_f_lockStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::LockStatus>::target_type > ((qt_gsi::Converter<QCamera::LockStatus>::target_type)qt_gsi::CppToQtAdaptor<QCamera::LockStatus>(((QCamera *)cls)->lockStatus ()));
}


// QCamera::LockStatus QCamera::lockStatus(QCamera::LockType lock)


static void _init_f_lockStatus_c2029 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lock");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockType>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QCamera::LockStatus>::target_type > ();
}

static void _call_f_lockStatus_c2029 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::LockType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockType>::target_type & >() (args, heap);
  ret.write<qt_gsi::Converter<QCamera::LockStatus>::target_type > ((qt_gsi::Converter<QCamera::LockStatus>::target_type)qt_gsi::CppToQtAdaptor<QCamera::LockStatus>(((QCamera *)cls)->lockStatus (qt_gsi::QtToCppAdaptor<QCamera::LockType>(arg1).cref())));
}


// void QCamera::lockStatusChanged(QCamera::LockStatus, QCamera::LockChangeReason)


static void _init_f_lockStatusChanged_4956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockStatus>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_lockStatusChanged_4956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::LockStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockStatus>::target_type & >() (args, heap);
  const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->lockStatusChanged (qt_gsi::QtToCppAdaptor<QCamera::LockStatus>(arg1).cref(), qt_gsi::QtToCppAdaptor<QCamera::LockChangeReason>(arg2).cref());
}


// void QCamera::lockStatusChanged(QCamera::LockType, QCamera::LockStatus, QCamera::LockChangeReason)


static void _init_f_lockStatusChanged_6877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockStatus>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_lockStatusChanged_6877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::LockType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockType>::target_type & >() (args, heap);
  const qt_gsi::Converter<QCamera::LockStatus>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockStatus>::target_type & >() (args, heap);
  const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QCamera::LockChangeReason>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->lockStatusChanged (qt_gsi::QtToCppAdaptor<QCamera::LockType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QCamera::LockStatus>(arg2).cref(), qt_gsi::QtToCppAdaptor<QCamera::LockChangeReason>(arg3).cref());
}


// void QCamera::locked()


static void _init_f_locked_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_locked_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->locked ();
}


// QFlags<QCamera::LockType> QCamera::requestedLocks()


static void _init_f_requestedLocks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::LockType> > ();
}

static void _call_f_requestedLocks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::LockType> > ((QFlags<QCamera::LockType>)((QCamera *)cls)->requestedLocks ());
}


// void QCamera::searchAndLock()


static void _init_f_searchAndLock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_searchAndLock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->searchAndLock ();
}


// void QCamera::searchAndLock(QFlags<QCamera::LockType> locks)


static void _init_f_searchAndLock_2725 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locks");
  decl->add_arg<QFlags<QCamera::LockType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_searchAndLock_2725 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::LockType> arg1 = gsi::arg_reader<QFlags<QCamera::LockType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->searchAndLock (arg1);
}


// void QCamera::setCaptureMode(QFlags<QCamera::CaptureMode> mode)


static void _init_f_setCaptureMode_3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaptureMode_3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setCaptureMode (arg1);
}


// void QCamera::setViewfinder(QVideoWidget *viewfinder)


static void _init_f_setViewfinder_1818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewfinder");
  decl->add_arg<QVideoWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewfinder_1818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoWidget *arg1 = gsi::arg_reader<QVideoWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setViewfinder (arg1);
}


// void QCamera::setViewfinder(QGraphicsVideoItem *viewfinder)


static void _init_f_setViewfinder_2422 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewfinder");
  decl->add_arg<QGraphicsVideoItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewfinder_2422 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsVideoItem *arg1 = gsi::arg_reader<QGraphicsVideoItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setViewfinder (arg1);
}


// void QCamera::setViewfinder(QAbstractVideoSurface *surface)


static void _init_f_setViewfinder_2739 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("surface");
  decl->add_arg<QAbstractVideoSurface * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewfinder_2739 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractVideoSurface *arg1 = gsi::arg_reader<QAbstractVideoSurface * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setViewfinder (arg1);
}


// void QCamera::setViewfinderSettings(const QCameraViewfinderSettings &settings)


static void _init_f_setViewfinderSettings_3871 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings");
  decl->add_arg<const QCameraViewfinderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewfinderSettings_3871 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraViewfinderSettings &arg1 = gsi::arg_reader<const QCameraViewfinderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setViewfinderSettings (arg1);
}


// void QCamera::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->start ();
}


// QCamera::State QCamera::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::State>::target_type > ((qt_gsi::Converter<QCamera::State>::target_type)qt_gsi::CppToQtAdaptor<QCamera::State>(((QCamera *)cls)->state ()));
}


// void QCamera::stateChanged(QCamera::State)


static void _init_f_stateChanged_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QCamera::State>(arg1).cref());
}


// QCamera::Status QCamera::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::Status>::target_type > ((qt_gsi::Converter<QCamera::Status>::target_type)qt_gsi::CppToQtAdaptor<QCamera::Status>(((QCamera *)cls)->status ()));
}


// void QCamera::statusChanged(QCamera::Status)


static void _init_f_statusChanged_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_statusChanged_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::Status>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Status>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->statusChanged (qt_gsi::QtToCppAdaptor<QCamera::Status>(arg1).cref());
}


// void QCamera::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->stop ();
}


// QFlags<QCamera::LockType> QCamera::supportedLocks()


static void _init_f_supportedLocks_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::LockType> > ();
}

static void _call_f_supportedLocks_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::LockType> > ((QFlags<QCamera::LockType>)((QCamera *)cls)->supportedLocks ());
}


// QList<QCamera::FrameRateRange> QCamera::supportedViewfinderFrameRateRanges(const QCameraViewfinderSettings &settings)


static void _init_f_supportedViewfinderFrameRateRanges_c3871 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QCameraViewfinderSettings()");
  decl->add_arg<const QCameraViewfinderSettings & > (argspec_0);
  decl->set_return<QList<QCamera::FrameRateRange> > ();
}

static void _call_f_supportedViewfinderFrameRateRanges_c3871 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraViewfinderSettings &arg1 = args ? gsi::arg_reader<const QCameraViewfinderSettings & >() (args, heap) : gsi::arg_maker<const QCameraViewfinderSettings & >() (QCameraViewfinderSettings(), heap);
  ret.write<QList<QCamera::FrameRateRange> > ((QList<QCamera::FrameRateRange>)((QCamera *)cls)->supportedViewfinderFrameRateRanges (arg1));
}


// QList<QVideoFrame::PixelFormat> QCamera::supportedViewfinderPixelFormats(const QCameraViewfinderSettings &settings)


static void _init_f_supportedViewfinderPixelFormats_c3871 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QCameraViewfinderSettings()");
  decl->add_arg<const QCameraViewfinderSettings & > (argspec_0);
  decl->set_return<QList<QVideoFrame::PixelFormat> > ();
}

static void _call_f_supportedViewfinderPixelFormats_c3871 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraViewfinderSettings &arg1 = args ? gsi::arg_reader<const QCameraViewfinderSettings & >() (args, heap) : gsi::arg_maker<const QCameraViewfinderSettings & >() (QCameraViewfinderSettings(), heap);
  ret.write<QList<QVideoFrame::PixelFormat> > ((QList<QVideoFrame::PixelFormat>)((QCamera *)cls)->supportedViewfinderPixelFormats (arg1));
}


// QList<QSize> QCamera::supportedViewfinderResolutions(const QCameraViewfinderSettings &settings)


static void _init_f_supportedViewfinderResolutions_c3871 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QCameraViewfinderSettings()");
  decl->add_arg<const QCameraViewfinderSettings & > (argspec_0);
  decl->set_return<QList<QSize> > ();
}

static void _call_f_supportedViewfinderResolutions_c3871 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraViewfinderSettings &arg1 = args ? gsi::arg_reader<const QCameraViewfinderSettings & >() (args, heap) : gsi::arg_maker<const QCameraViewfinderSettings & >() (QCameraViewfinderSettings(), heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QCamera *)cls)->supportedViewfinderResolutions (arg1));
}


// QList<QCameraViewfinderSettings> QCamera::supportedViewfinderSettings(const QCameraViewfinderSettings &settings)


static void _init_f_supportedViewfinderSettings_c3871 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QCameraViewfinderSettings()");
  decl->add_arg<const QCameraViewfinderSettings & > (argspec_0);
  decl->set_return<QList<QCameraViewfinderSettings> > ();
}

static void _call_f_supportedViewfinderSettings_c3871 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraViewfinderSettings &arg1 = args ? gsi::arg_reader<const QCameraViewfinderSettings & >() (args, heap) : gsi::arg_maker<const QCameraViewfinderSettings & >() (QCameraViewfinderSettings(), heap);
  ret.write<QList<QCameraViewfinderSettings> > ((QList<QCameraViewfinderSettings>)((QCamera *)cls)->supportedViewfinderSettings (arg1));
}


// void QCamera::unload()


static void _init_f_unload_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unload_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->unload ();
}


// void QCamera::unlock()


static void _init_f_unlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unlock_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->unlock ();
}


// void QCamera::unlock(QFlags<QCamera::LockType> locks)


static void _init_f_unlock_2725 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locks");
  decl->add_arg<QFlags<QCamera::LockType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unlock_2725 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::LockType> arg1 = gsi::arg_reader<QFlags<QCamera::LockType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->unlock (arg1);
}


// QCameraViewfinderSettings QCamera::viewfinderSettings()


static void _init_f_viewfinderSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraViewfinderSettings > ();
}

static void _call_f_viewfinderSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraViewfinderSettings > ((QCameraViewfinderSettings)((QCamera *)cls)->viewfinderSettings ());
}


// static QList<QByteArray> QCamera::availableDevices()


static void _init_f_availableDevices_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QByteArray> > ();
}

static void _call_f_availableDevices_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QByteArray> > ((QList<QByteArray>)QCamera::availableDevices ());
}


// static QString QCamera::deviceDescription(const QByteArray &device)


static void _init_f_deviceDescription_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_deviceDescription_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QString > ((QString)QCamera::deviceDescription (arg1));
}


// static QString QCamera::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCamera::tr (arg1, arg2, arg3));
}


// static QString QCamera::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCamera::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCamera () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QCamera::availability()\nThis is a reimplementation of QMediaObject::availability", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod (":captureMode", "@brief Method QFlags<QCamera::CaptureMode> QCamera::captureMode()\n", true, &_init_f_captureMode_c0, &_call_f_captureMode_c0);
  methods += new qt_gsi::GenericMethod ("captureModeChanged", "@brief Method void QCamera::captureModeChanged(QFlags<QCamera::CaptureMode>)\n", false, &_init_f_captureModeChanged_3027, &_call_f_captureModeChanged_3027);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QCamera::Error QCamera::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QCamera::error(QCamera::Error)\n", false, &_init_f_error_1740, &_call_f_error_1740);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QCamera::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("exposure", "@brief Method QCameraExposure *QCamera::exposure()\n", true, &_init_f_exposure_c0, &_call_f_exposure_c0);
  methods += new qt_gsi::GenericMethod ("focus", "@brief Method QCameraFocus *QCamera::focus()\n", true, &_init_f_focus_c0, &_call_f_focus_c0);
  methods += new qt_gsi::GenericMethod ("imageProcessing", "@brief Method QCameraImageProcessing *QCamera::imageProcessing()\n", true, &_init_f_imageProcessing_c0, &_call_f_imageProcessing_c0);
  methods += new qt_gsi::GenericMethod ("isCaptureModeSupported?", "@brief Method bool QCamera::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)\n", true, &_init_f_isCaptureModeSupported_c3027, &_call_f_isCaptureModeSupported_c3027);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method void QCamera::load()\n", false, &_init_f_load_0, &_call_f_load_0);
  methods += new qt_gsi::GenericMethod ("lockFailed", "@brief Method void QCamera::lockFailed()\n", false, &_init_f_lockFailed_0, &_call_f_lockFailed_0);
  methods += new qt_gsi::GenericMethod (":lockStatus", "@brief Method QCamera::LockStatus QCamera::lockStatus()\n", true, &_init_f_lockStatus_c0, &_call_f_lockStatus_c0);
  methods += new qt_gsi::GenericMethod ("lockStatus", "@brief Method QCamera::LockStatus QCamera::lockStatus(QCamera::LockType lock)\n", true, &_init_f_lockStatus_c2029, &_call_f_lockStatus_c2029);
  methods += new qt_gsi::GenericMethod ("lockStatusChanged", "@brief Method void QCamera::lockStatusChanged(QCamera::LockStatus, QCamera::LockChangeReason)\n", false, &_init_f_lockStatusChanged_4956, &_call_f_lockStatusChanged_4956);
  methods += new qt_gsi::GenericMethod ("lockStatusChanged_withType", "@brief Method void QCamera::lockStatusChanged(QCamera::LockType, QCamera::LockStatus, QCamera::LockChangeReason)\n", false, &_init_f_lockStatusChanged_6877, &_call_f_lockStatusChanged_6877);
  methods += new qt_gsi::GenericMethod ("locked", "@brief Method void QCamera::locked()\n", false, &_init_f_locked_0, &_call_f_locked_0);
  methods += new qt_gsi::GenericMethod ("requestedLocks", "@brief Method QFlags<QCamera::LockType> QCamera::requestedLocks()\n", true, &_init_f_requestedLocks_c0, &_call_f_requestedLocks_c0);
  methods += new qt_gsi::GenericMethod ("searchAndLock", "@brief Method void QCamera::searchAndLock()\n", false, &_init_f_searchAndLock_0, &_call_f_searchAndLock_0);
  methods += new qt_gsi::GenericMethod ("searchAndLock", "@brief Method void QCamera::searchAndLock(QFlags<QCamera::LockType> locks)\n", false, &_init_f_searchAndLock_2725, &_call_f_searchAndLock_2725);
  methods += new qt_gsi::GenericMethod ("setCaptureMode|captureMode=", "@brief Method void QCamera::setCaptureMode(QFlags<QCamera::CaptureMode> mode)\n", false, &_init_f_setCaptureMode_3027, &_call_f_setCaptureMode_3027);
  methods += new qt_gsi::GenericMethod ("setViewfinder", "@brief Method void QCamera::setViewfinder(QVideoWidget *viewfinder)\n", false, &_init_f_setViewfinder_1818, &_call_f_setViewfinder_1818);
  methods += new qt_gsi::GenericMethod ("setViewfinder", "@brief Method void QCamera::setViewfinder(QGraphicsVideoItem *viewfinder)\n", false, &_init_f_setViewfinder_2422, &_call_f_setViewfinder_2422);
  methods += new qt_gsi::GenericMethod ("setViewfinder", "@brief Method void QCamera::setViewfinder(QAbstractVideoSurface *surface)\n", false, &_init_f_setViewfinder_2739, &_call_f_setViewfinder_2739);
  methods += new qt_gsi::GenericMethod ("setViewfinderSettings|viewfinderSettings=", "@brief Method void QCamera::setViewfinderSettings(const QCameraViewfinderSettings &settings)\n", false, &_init_f_setViewfinderSettings_3871, &_call_f_setViewfinderSettings_3871);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QCamera::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QCamera::State QCamera::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QCamera::stateChanged(QCamera::State)\n", false, &_init_f_stateChanged_1731, &_call_f_stateChanged_1731);
  methods += new qt_gsi::GenericMethod (":status", "@brief Method QCamera::Status QCamera::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += new qt_gsi::GenericMethod ("statusChanged", "@brief Method void QCamera::statusChanged(QCamera::Status)\n", false, &_init_f_statusChanged_1862, &_call_f_statusChanged_1862);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QCamera::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("supportedLocks", "@brief Method QFlags<QCamera::LockType> QCamera::supportedLocks()\n", true, &_init_f_supportedLocks_c0, &_call_f_supportedLocks_c0);
  methods += new qt_gsi::GenericMethod ("supportedViewfinderFrameRateRanges", "@brief Method QList<QCamera::FrameRateRange> QCamera::supportedViewfinderFrameRateRanges(const QCameraViewfinderSettings &settings)\n", true, &_init_f_supportedViewfinderFrameRateRanges_c3871, &_call_f_supportedViewfinderFrameRateRanges_c3871);
  methods += new qt_gsi::GenericMethod ("supportedViewfinderPixelFormats", "@brief Method QList<QVideoFrame::PixelFormat> QCamera::supportedViewfinderPixelFormats(const QCameraViewfinderSettings &settings)\n", true, &_init_f_supportedViewfinderPixelFormats_c3871, &_call_f_supportedViewfinderPixelFormats_c3871);
  methods += new qt_gsi::GenericMethod ("supportedViewfinderResolutions", "@brief Method QList<QSize> QCamera::supportedViewfinderResolutions(const QCameraViewfinderSettings &settings)\n", true, &_init_f_supportedViewfinderResolutions_c3871, &_call_f_supportedViewfinderResolutions_c3871);
  methods += new qt_gsi::GenericMethod ("supportedViewfinderSettings", "@brief Method QList<QCameraViewfinderSettings> QCamera::supportedViewfinderSettings(const QCameraViewfinderSettings &settings)\n", true, &_init_f_supportedViewfinderSettings_c3871, &_call_f_supportedViewfinderSettings_c3871);
  methods += new qt_gsi::GenericMethod ("unload", "@brief Method void QCamera::unload()\n", false, &_init_f_unload_0, &_call_f_unload_0);
  methods += new qt_gsi::GenericMethod ("unlock", "@brief Method void QCamera::unlock()\n", false, &_init_f_unlock_0, &_call_f_unlock_0);
  methods += new qt_gsi::GenericMethod ("unlock", "@brief Method void QCamera::unlock(QFlags<QCamera::LockType> locks)\n", false, &_init_f_unlock_2725, &_call_f_unlock_2725);
  methods += new qt_gsi::GenericMethod (":viewfinderSettings", "@brief Method QCameraViewfinderSettings QCamera::viewfinderSettings()\n", true, &_init_f_viewfinderSettings_c0, &_call_f_viewfinderSettings_c0);
  methods += new qt_gsi::GenericStaticMethod ("availableDevices", "@brief Static method QList<QByteArray> QCamera::availableDevices()\nThis method is static and can be called without an instance.", &_init_f_availableDevices_0, &_call_f_availableDevices_0);
  methods += new qt_gsi::GenericStaticMethod ("deviceDescription", "@brief Static method QString QCamera::deviceDescription(const QByteArray &device)\nThis method is static and can be called without an instance.", &_init_f_deviceDescription_2309, &_call_f_deviceDescription_2309);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCamera::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCamera::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

qt_gsi::QtNativeClass<QCamera> decl_QCamera (qtdecl_QMediaObject (), "QtMultimedia", "QCamera_Native",
  methods_QCamera (),
  "@hide\n@alias QCamera");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCamera> &qtdecl_QCamera () { return decl_QCamera; }

}


class QCamera_Adaptor : public QCamera, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCamera_Adaptor();

  //  [adaptor ctor] QCamera::QCamera(QObject *parent)
  QCamera_Adaptor() : QCamera()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QObject *parent)
  QCamera_Adaptor(QObject *parent) : QCamera(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QByteArray &deviceName, QObject *parent)
  QCamera_Adaptor(const QByteArray &deviceName) : QCamera(deviceName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QByteArray &deviceName, QObject *parent)
  QCamera_Adaptor(const QByteArray &deviceName, QObject *parent) : QCamera(deviceName, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QCameraInfo &cameraInfo, QObject *parent)
  QCamera_Adaptor(const QCameraInfo &cameraInfo) : QCamera(cameraInfo)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QCameraInfo &cameraInfo, QObject *parent)
  QCamera_Adaptor(const QCameraInfo &cameraInfo, QObject *parent) : QCamera(cameraInfo, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QCamera::Position position, QObject *parent)
  QCamera_Adaptor(QCamera::Position position) : QCamera(position)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QCamera::Position position, QObject *parent)
  QCamera_Adaptor(QCamera::Position position, QObject *parent) : QCamera(position, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QCamera::addPropertyWatch(QByteArray const &name)
  void fp_QCamera_addPropertyWatch_2309 (QByteArray const &name) {
    QCamera::addPropertyWatch(name);
  }

  //  [expose] bool QCamera::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCamera_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCamera::isSignalConnected(signal);
  }

  //  [expose] int QCamera::receivers(const char *signal)
  int fp_QCamera_receivers_c1731 (const char *signal) const {
    return QCamera::receivers(signal);
  }

  //  [expose] void QCamera::removePropertyWatch(QByteArray const &name)
  void fp_QCamera_removePropertyWatch_2309 (QByteArray const &name) {
    QCamera::removePropertyWatch(name);
  }

  //  [expose] QObject *QCamera::sender()
  QObject * fp_QCamera_sender_c0 () const {
    return QCamera::sender();
  }

  //  [expose] int QCamera::senderSignalIndex()
  int fp_QCamera_senderSignalIndex_c0 () const {
    return QCamera::senderSignalIndex();
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QCamera::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QCamera::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QCamera_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QCamera_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QCamera::availability();
    }
  }

  //  [adaptor impl] bool QCamera::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QCamera::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QCamera_Adaptor, bool, QObject *>(&QCamera_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QCamera::bind(arg1);
    }
  }

  //  [adaptor impl] bool QCamera::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCamera::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCamera_Adaptor, bool, QEvent *>(&QCamera_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCamera::event(arg1);
    }
  }

  //  [adaptor impl] bool QCamera::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCamera::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCamera_Adaptor, bool, QObject *, QEvent *>(&QCamera_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCamera::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCamera::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QCamera::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QCamera_Adaptor, bool>(&QCamera_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QCamera::isAvailable();
    }
  }

  //  [adaptor impl] QMediaService *QCamera::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QCamera::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QCamera_Adaptor, QMediaService *>(&QCamera_Adaptor::cbs_service_c0_0);
    } else {
      return QCamera::service();
    }
  }

  //  [adaptor impl] void QCamera::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QCamera::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QCamera_Adaptor, QObject *>(&QCamera_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QCamera::unbind(arg1);
    }
  }

  //  [adaptor impl] void QCamera::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCamera::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCamera_Adaptor, QChildEvent *>(&QCamera_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCamera::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCamera::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCamera::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCamera_Adaptor, QEvent *>(&QCamera_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCamera::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCamera::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCamera::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCamera_Adaptor, const QMetaMethod &>(&QCamera_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCamera::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCamera::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCamera::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCamera_Adaptor, QTimerEvent *>(&QCamera_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCamera::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCamera_Adaptor::~QCamera_Adaptor() { }

//  Constructor QCamera::QCamera(QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (arg1));
}


//  Constructor QCamera::QCamera(const QByteArray &deviceName, QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_3503 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deviceName");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_3503 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (arg1, arg2));
}


//  Constructor QCamera::QCamera(const QCameraInfo &cameraInfo, QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_3569 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cameraInfo");
  decl->add_arg<const QCameraInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_3569 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraInfo &arg1 = gsi::arg_reader<const QCameraInfo & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (arg1, arg2));
}


//  Constructor QCamera::QCamera(QCamera::Position position, QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_3265 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const qt_gsi::Converter<QCamera::Position>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_3265 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::Position>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Position>::target_type & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (qt_gsi::QtToCppAdaptor<QCamera::Position>(arg1).cref(), arg2));
}


// exposed void QCamera::addPropertyWatch(QByteArray const &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->fp_QCamera_addPropertyWatch_2309 (arg1);
}


// QMultimedia::AvailabilityStatus QCamera::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QCamera_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// bool QCamera::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// void QCamera::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCamera::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QCamera::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCamera::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCamera::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QCamera::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QCamera::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->fp_QCamera_isSignalConnected_c2394 (arg1));
}


// exposed int QCamera::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCamera_Adaptor *)cls)->fp_QCamera_receivers_c1731 (arg1));
}


// exposed void QCamera::removePropertyWatch(QByteArray const &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->fp_QCamera_removePropertyWatch_2309 (arg1);
}


// exposed QObject *QCamera::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCamera_Adaptor *)cls)->fp_QCamera_sender_c0 ());
}


// exposed int QCamera::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera_Adaptor *)cls)->fp_QCamera_senderSignalIndex_c0 ());
}


// QMediaService *QCamera::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QCamera_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// void QCamera::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QCamera::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


namespace gsi
{

gsi::Class<QCamera> &qtdecl_QCamera ();

static gsi::Methods methods_QCamera_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_1302, &_call_ctor_QCamera_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(const QByteArray &deviceName, QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_3503, &_call_ctor_QCamera_Adaptor_3503);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(const QCameraInfo &cameraInfo, QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_3569, &_call_ctor_QCamera_Adaptor_3569);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(QCamera::Position position, QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_3265, &_call_ctor_QCamera_Adaptor_3265);
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QCamera::addPropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QCamera::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QCamera::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCamera::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCamera::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCamera::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCamera::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCamera::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QCamera::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCamera::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCamera::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QCamera::removePropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCamera::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCamera::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QCamera::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCamera::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QCamera::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  return methods;
}

gsi::Class<QCamera_Adaptor> decl_QCamera_Adaptor (qtdecl_QCamera (), "QtMultimedia", "QCamera",
  methods_QCamera_Adaptor (),
  "@qt\n@brief Binding of QCamera");

}


//  Implementation of the enum wrapper class for QCamera::CaptureMode
namespace qt_gsi
{

static gsi::Enum<QCamera::CaptureMode> decl_QCamera_CaptureMode_Enum ("QtMultimedia", "QCamera_CaptureMode",
    gsi::enum_const ("CaptureViewfinder", QCamera::CaptureViewfinder, "@brief Enum constant QCamera::CaptureViewfinder") +
    gsi::enum_const ("CaptureStillImage", QCamera::CaptureStillImage, "@brief Enum constant QCamera::CaptureStillImage") +
    gsi::enum_const ("CaptureVideo", QCamera::CaptureVideo, "@brief Enum constant QCamera::CaptureVideo"),
  "@qt\n@brief This class represents the QCamera::CaptureMode enum");

static gsi::QFlagsClass<QCamera::CaptureMode > decl_QCamera_CaptureMode_Enums ("QtMultimedia", "QCamera_QFlags_CaptureMode",
  "@qt\n@brief This class represents the QFlags<QCamera::CaptureMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_CaptureMode_Enum_in_parent (decl_QCamera_CaptureMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_CaptureMode_Enum_as_child (decl_QCamera_CaptureMode_Enum, "CaptureMode");
static gsi::ClassExt<QCamera> decl_QCamera_CaptureMode_Enums_as_child (decl_QCamera_CaptureMode_Enums, "QFlags_CaptureMode");

}


//  Implementation of the enum wrapper class for QCamera::Error
namespace qt_gsi
{

static gsi::Enum<QCamera::Error> decl_QCamera_Error_Enum ("QtMultimedia", "QCamera_Error",
    gsi::enum_const ("NoError", QCamera::NoError, "@brief Enum constant QCamera::NoError") +
    gsi::enum_const ("CameraError", QCamera::CameraError, "@brief Enum constant QCamera::CameraError") +
    gsi::enum_const ("InvalidRequestError", QCamera::InvalidRequestError, "@brief Enum constant QCamera::InvalidRequestError") +
    gsi::enum_const ("ServiceMissingError", QCamera::ServiceMissingError, "@brief Enum constant QCamera::ServiceMissingError") +
    gsi::enum_const ("NotSupportedFeatureError", QCamera::NotSupportedFeatureError, "@brief Enum constant QCamera::NotSupportedFeatureError"),
  "@qt\n@brief This class represents the QCamera::Error enum");

static gsi::QFlagsClass<QCamera::Error > decl_QCamera_Error_Enums ("QtMultimedia", "QCamera_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QCamera::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_Error_Enum_in_parent (decl_QCamera_Error_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_Error_Enum_as_child (decl_QCamera_Error_Enum, "Error");
static gsi::ClassExt<QCamera> decl_QCamera_Error_Enums_as_child (decl_QCamera_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QCamera::LockChangeReason
namespace qt_gsi
{

static gsi::Enum<QCamera::LockChangeReason> decl_QCamera_LockChangeReason_Enum ("QtMultimedia", "QCamera_LockChangeReason",
    gsi::enum_const ("UserRequest", QCamera::UserRequest, "@brief Enum constant QCamera::UserRequest") +
    gsi::enum_const ("LockAcquired", QCamera::LockAcquired, "@brief Enum constant QCamera::LockAcquired") +
    gsi::enum_const ("LockFailed", QCamera::LockFailed, "@brief Enum constant QCamera::LockFailed") +
    gsi::enum_const ("LockLost", QCamera::LockLost, "@brief Enum constant QCamera::LockLost") +
    gsi::enum_const ("LockTemporaryLost", QCamera::LockTemporaryLost, "@brief Enum constant QCamera::LockTemporaryLost"),
  "@qt\n@brief This class represents the QCamera::LockChangeReason enum");

static gsi::QFlagsClass<QCamera::LockChangeReason > decl_QCamera_LockChangeReason_Enums ("QtMultimedia", "QCamera_QFlags_LockChangeReason",
  "@qt\n@brief This class represents the QFlags<QCamera::LockChangeReason> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_LockChangeReason_Enum_in_parent (decl_QCamera_LockChangeReason_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_LockChangeReason_Enum_as_child (decl_QCamera_LockChangeReason_Enum, "LockChangeReason");
static gsi::ClassExt<QCamera> decl_QCamera_LockChangeReason_Enums_as_child (decl_QCamera_LockChangeReason_Enums, "QFlags_LockChangeReason");

}


//  Implementation of the enum wrapper class for QCamera::LockStatus
namespace qt_gsi
{

static gsi::Enum<QCamera::LockStatus> decl_QCamera_LockStatus_Enum ("QtMultimedia", "QCamera_LockStatus",
    gsi::enum_const ("Unlocked", QCamera::Unlocked, "@brief Enum constant QCamera::Unlocked") +
    gsi::enum_const ("Searching", QCamera::Searching, "@brief Enum constant QCamera::Searching") +
    gsi::enum_const ("Locked", QCamera::Locked, "@brief Enum constant QCamera::Locked"),
  "@qt\n@brief This class represents the QCamera::LockStatus enum");

static gsi::QFlagsClass<QCamera::LockStatus > decl_QCamera_LockStatus_Enums ("QtMultimedia", "QCamera_QFlags_LockStatus",
  "@qt\n@brief This class represents the QFlags<QCamera::LockStatus> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_LockStatus_Enum_in_parent (decl_QCamera_LockStatus_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_LockStatus_Enum_as_child (decl_QCamera_LockStatus_Enum, "LockStatus");
static gsi::ClassExt<QCamera> decl_QCamera_LockStatus_Enums_as_child (decl_QCamera_LockStatus_Enums, "QFlags_LockStatus");

}


//  Implementation of the enum wrapper class for QCamera::LockType
namespace qt_gsi
{

static gsi::Enum<QCamera::LockType> decl_QCamera_LockType_Enum ("QtMultimedia", "QCamera_LockType",
    gsi::enum_const ("NoLock", QCamera::NoLock, "@brief Enum constant QCamera::NoLock") +
    gsi::enum_const ("LockExposure", QCamera::LockExposure, "@brief Enum constant QCamera::LockExposure") +
    gsi::enum_const ("LockWhiteBalance", QCamera::LockWhiteBalance, "@brief Enum constant QCamera::LockWhiteBalance") +
    gsi::enum_const ("LockFocus", QCamera::LockFocus, "@brief Enum constant QCamera::LockFocus"),
  "@qt\n@brief This class represents the QCamera::LockType enum");

static gsi::QFlagsClass<QCamera::LockType > decl_QCamera_LockType_Enums ("QtMultimedia", "QCamera_QFlags_LockType",
  "@qt\n@brief This class represents the QFlags<QCamera::LockType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_LockType_Enum_in_parent (decl_QCamera_LockType_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_LockType_Enum_as_child (decl_QCamera_LockType_Enum, "LockType");
static gsi::ClassExt<QCamera> decl_QCamera_LockType_Enums_as_child (decl_QCamera_LockType_Enums, "QFlags_LockType");

}


//  Implementation of the enum wrapper class for QCamera::Position
namespace qt_gsi
{

static gsi::Enum<QCamera::Position> decl_QCamera_Position_Enum ("QtMultimedia", "QCamera_Position",
    gsi::enum_const ("UnspecifiedPosition", QCamera::UnspecifiedPosition, "@brief Enum constant QCamera::UnspecifiedPosition") +
    gsi::enum_const ("BackFace", QCamera::BackFace, "@brief Enum constant QCamera::BackFace") +
    gsi::enum_const ("FrontFace", QCamera::FrontFace, "@brief Enum constant QCamera::FrontFace"),
  "@qt\n@brief This class represents the QCamera::Position enum");

static gsi::QFlagsClass<QCamera::Position > decl_QCamera_Position_Enums ("QtMultimedia", "QCamera_QFlags_Position",
  "@qt\n@brief This class represents the QFlags<QCamera::Position> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_Position_Enum_in_parent (decl_QCamera_Position_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_Position_Enum_as_child (decl_QCamera_Position_Enum, "Position");
static gsi::ClassExt<QCamera> decl_QCamera_Position_Enums_as_child (decl_QCamera_Position_Enums, "QFlags_Position");

}


//  Implementation of the enum wrapper class for QCamera::State
namespace qt_gsi
{

static gsi::Enum<QCamera::State> decl_QCamera_State_Enum ("QtMultimedia", "QCamera_State",
    gsi::enum_const ("UnloadedState", QCamera::UnloadedState, "@brief Enum constant QCamera::UnloadedState") +
    gsi::enum_const ("LoadedState", QCamera::LoadedState, "@brief Enum constant QCamera::LoadedState") +
    gsi::enum_const ("ActiveState", QCamera::ActiveState, "@brief Enum constant QCamera::ActiveState"),
  "@qt\n@brief This class represents the QCamera::State enum");

static gsi::QFlagsClass<QCamera::State > decl_QCamera_State_Enums ("QtMultimedia", "QCamera_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QCamera::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_State_Enum_in_parent (decl_QCamera_State_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_State_Enum_as_child (decl_QCamera_State_Enum, "State");
static gsi::ClassExt<QCamera> decl_QCamera_State_Enums_as_child (decl_QCamera_State_Enums, "QFlags_State");

}


//  Implementation of the enum wrapper class for QCamera::Status
namespace qt_gsi
{

static gsi::Enum<QCamera::Status> decl_QCamera_Status_Enum ("QtMultimedia", "QCamera_Status",
    gsi::enum_const ("UnavailableStatus", QCamera::UnavailableStatus, "@brief Enum constant QCamera::UnavailableStatus") +
    gsi::enum_const ("UnloadedStatus", QCamera::UnloadedStatus, "@brief Enum constant QCamera::UnloadedStatus") +
    gsi::enum_const ("LoadingStatus", QCamera::LoadingStatus, "@brief Enum constant QCamera::LoadingStatus") +
    gsi::enum_const ("UnloadingStatus", QCamera::UnloadingStatus, "@brief Enum constant QCamera::UnloadingStatus") +
    gsi::enum_const ("LoadedStatus", QCamera::LoadedStatus, "@brief Enum constant QCamera::LoadedStatus") +
    gsi::enum_const ("StandbyStatus", QCamera::StandbyStatus, "@brief Enum constant QCamera::StandbyStatus") +
    gsi::enum_const ("StartingStatus", QCamera::StartingStatus, "@brief Enum constant QCamera::StartingStatus") +
    gsi::enum_const ("StoppingStatus", QCamera::StoppingStatus, "@brief Enum constant QCamera::StoppingStatus") +
    gsi::enum_const ("ActiveStatus", QCamera::ActiveStatus, "@brief Enum constant QCamera::ActiveStatus"),
  "@qt\n@brief This class represents the QCamera::Status enum");

static gsi::QFlagsClass<QCamera::Status > decl_QCamera_Status_Enums ("QtMultimedia", "QCamera_QFlags_Status",
  "@qt\n@brief This class represents the QFlags<QCamera::Status> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_Status_Enum_in_parent (decl_QCamera_Status_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_Status_Enum_as_child (decl_QCamera_Status_Enum, "Status");
static gsi::ClassExt<QCamera> decl_QCamera_Status_Enums_as_child (decl_QCamera_Status_Enums, "QFlags_Status");

}

