
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLine>
#include <QPoint>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLine

//  Constructor QLine::QLine()


static void _init_ctor_QLine_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLine> ();
}

static void _call_ctor_QLine_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLine *> (new QLine ());
}


//  Constructor QLine::QLine(const QPoint &pt1, const QPoint &pt2)


static void _init_ctor_QLine_3724 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt1");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pt2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return_new<QLine> ();
}

static void _call_ctor_QLine_3724 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPoint &arg2 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QLine *> (new QLine (arg1, arg2));
}


//  Constructor QLine::QLine(int x1, int y1, int x2, int y2)


static void _init_ctor_QLine_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QLine> ();
}

static void _call_ctor_QLine_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLine *> (new QLine (arg1, arg2, arg3, arg4));
}


// int QLine::dx()


static void _init_f_dx_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dx_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->dx ());
}


// int QLine::dy()


static void _init_f_dy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->dy ());
}


// bool QLine::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLine *)cls)->isNull ());
}


// bool QLine::operator!=(const QLine &d)


static void _init_f_operator_excl__eq__c1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1786 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLine &arg1 = gsi::arg_reader<const QLine & >() (args, heap);
  ret.write<bool > ((bool)((QLine *)cls)->operator!= (arg1));
}


// bool QLine::operator==(const QLine &d)


static void _init_f_operator_eq__eq__c1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1786 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLine &arg1 = gsi::arg_reader<const QLine & >() (args, heap);
  ret.write<bool > ((bool)((QLine *)cls)->operator== (arg1));
}


// QPoint QLine::p1()


static void _init_f_p1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_p1_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QLine *)cls)->p1 ());
}


// QPoint QLine::p2()


static void _init_f_p2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_p2_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QLine *)cls)->p2 ());
}


// void QLine::setLine(int x1, int y1, int x2, int y2)


static void _init_f_setLine_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setLine_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->setLine (arg1, arg2, arg3, arg4);
}


// void QLine::setP1(const QPoint &p1)


static void _init_f_setP1_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setP1_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->setP1 (arg1);
}


// void QLine::setP2(const QPoint &p2)


static void _init_f_setP2_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p2");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setP2_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->setP2 (arg1);
}


// void QLine::setPoints(const QPoint &p1, const QPoint &p2)


static void _init_f_setPoints_3724 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPoints_3724 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QPoint &arg2 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->setPoints (arg1, arg2);
}


// void QLine::translate(const QPoint &p)


static void _init_f_translate_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->translate (arg1);
}


// void QLine::translate(int dx, int dy)


static void _init_f_translate_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLine *)cls)->translate (arg1, arg2);
}


// QLine QLine::translated(const QPoint &p)


static void _init_f_translated_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QLine > ();
}

static void _call_f_translated_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QLine > ((QLine)((QLine *)cls)->translated (arg1));
}


// QLine QLine::translated(int dx, int dy)


static void _init_f_translated_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QLine > ();
}

static void _call_f_translated_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLine > ((QLine)((QLine *)cls)->translated (arg1, arg2));
}


// int QLine::x1()


static void _init_f_x1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x1_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->x1 ());
}


// int QLine::x2()


static void _init_f_x2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x2_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->x2 ());
}


// int QLine::y1()


static void _init_f_y1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y1_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->y1 ());
}


// int QLine::y2()


static void _init_f_y2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y2_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLine *)cls)->y2 ());
}



namespace gsi
{

static gsi::Methods methods_QLine () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLine::QLine()\nThis method creates an object of class QLine.", &_init_ctor_QLine_0, &_call_ctor_QLine_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLine::QLine(const QPoint &pt1, const QPoint &pt2)\nThis method creates an object of class QLine.", &_init_ctor_QLine_3724, &_call_ctor_QLine_3724);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLine::QLine(int x1, int y1, int x2, int y2)\nThis method creates an object of class QLine.", &_init_ctor_QLine_2744, &_call_ctor_QLine_2744);
  methods += new qt_gsi::GenericMethod ("dx", "@brief Method int QLine::dx()\n", true, &_init_f_dx_c0, &_call_f_dx_c0);
  methods += new qt_gsi::GenericMethod ("dy", "@brief Method int QLine::dy()\n", true, &_init_f_dy_c0, &_call_f_dy_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QLine::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QLine::operator!=(const QLine &d)\n", true, &_init_f_operator_excl__eq__c1786, &_call_f_operator_excl__eq__c1786);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QLine::operator==(const QLine &d)\n", true, &_init_f_operator_eq__eq__c1786, &_call_f_operator_eq__eq__c1786);
  methods += new qt_gsi::GenericMethod (":p1", "@brief Method QPoint QLine::p1()\n", true, &_init_f_p1_c0, &_call_f_p1_c0);
  methods += new qt_gsi::GenericMethod (":p2", "@brief Method QPoint QLine::p2()\n", true, &_init_f_p2_c0, &_call_f_p2_c0);
  methods += new qt_gsi::GenericMethod ("setLine", "@brief Method void QLine::setLine(int x1, int y1, int x2, int y2)\n", false, &_init_f_setLine_2744, &_call_f_setLine_2744);
  methods += new qt_gsi::GenericMethod ("setP1|p1=", "@brief Method void QLine::setP1(const QPoint &p1)\n", false, &_init_f_setP1_1916, &_call_f_setP1_1916);
  methods += new qt_gsi::GenericMethod ("setP2|p2=", "@brief Method void QLine::setP2(const QPoint &p2)\n", false, &_init_f_setP2_1916, &_call_f_setP2_1916);
  methods += new qt_gsi::GenericMethod ("setPoints", "@brief Method void QLine::setPoints(const QPoint &p1, const QPoint &p2)\n", false, &_init_f_setPoints_3724, &_call_f_setPoints_3724);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QLine::translate(const QPoint &p)\n", false, &_init_f_translate_1916, &_call_f_translate_1916);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QLine::translate(int dx, int dy)\n", false, &_init_f_translate_1426, &_call_f_translate_1426);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QLine QLine::translated(const QPoint &p)\n", true, &_init_f_translated_c1916, &_call_f_translated_c1916);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QLine QLine::translated(int dx, int dy)\n", true, &_init_f_translated_c1426, &_call_f_translated_c1426);
  methods += new qt_gsi::GenericMethod ("x1", "@brief Method int QLine::x1()\n", true, &_init_f_x1_c0, &_call_f_x1_c0);
  methods += new qt_gsi::GenericMethod ("x2", "@brief Method int QLine::x2()\n", true, &_init_f_x2_c0, &_call_f_x2_c0);
  methods += new qt_gsi::GenericMethod ("y1", "@brief Method int QLine::y1()\n", true, &_init_f_y1_c0, &_call_f_y1_c0);
  methods += new qt_gsi::GenericMethod ("y2", "@brief Method int QLine::y2()\n", true, &_init_f_y2_c0, &_call_f_y2_c0);
  return methods;
}

gsi::Class<QLine> decl_QLine ("QtCore", "QLine",
  methods_QLine (),
  "@qt\n@brief Binding of QLine");


GSI_QTCORE_PUBLIC gsi::Class<QLine> &qtdecl_QLine () { return decl_QLine; }

}

