/***************************************************************************
 *   Copyright (C) 2009 by BUI Quang Minh   *
 *   minh.bui@univie.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "modelprotein.h"
#include <string>

/*
	following are definitions for various protein models encoded in a string.
	This string contains the lower triangle of the rate matrix and the state frequencies at the end.
	It should follow the amino acid order:
	A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V
	Ala Arg Asn Asp Cys Gln Glu Gly His Ile Leu Lys Met Phe Pro Ser Thr Trp Tyr Val
*/

/* this function is taken from RAxML source code */
static bool initProtMat(double f[20], double daa[400], string prot_model)
{ 
  double max, temp;
  int i, j;
  double scaler;

  if (prot_model == "POISSON") {
	  for (i = 0; i < 400; i++) daa[i] = 1.0;
	  for (i = 0; i < 20; i++) f[i] = 0.05;
  } else if (prot_model == "DAYHOFF")
	  {	
	    daa[ 1*20+ 0] =   27.00; daa[ 2*20+ 0] =   98.00; daa[ 2*20+ 1] =   32.00; daa[ 3*20+ 0] =  120.00;
	    daa[ 3*20+ 1] =    0.00; daa[ 3*20+ 2] =  905.00; daa[ 4*20+ 0] =   36.00; daa[ 4*20+ 1] =   23.00;
	    daa[ 4*20+ 2] =    0.00; daa[ 4*20+ 3] =    0.00; daa[ 5*20+ 0] =   89.00; daa[ 5*20+ 1] =  246.00;
	    daa[ 5*20+ 2] =  103.00; daa[ 5*20+ 3] =  134.00; daa[ 5*20+ 4] =    0.00; daa[ 6*20+ 0] =  198.00;
	    daa[ 6*20+ 1] =    1.00; daa[ 6*20+ 2] =  148.00; daa[ 6*20+ 3] = 1153.00; daa[ 6*20+ 4] =    0.00;
	    daa[ 6*20+ 5] =  716.00; daa[ 7*20+ 0] =  240.00; daa[ 7*20+ 1] =    9.00; daa[ 7*20+ 2] =  139.00;
	    daa[ 7*20+ 3] =  125.00; daa[ 7*20+ 4] =   11.00; daa[ 7*20+ 5] =   28.00; daa[ 7*20+ 6] =   81.00;
	    daa[ 8*20+ 0] =   23.00; daa[ 8*20+ 1] =  240.00; daa[ 8*20+ 2] =  535.00; daa[ 8*20+ 3] =   86.00;
	    daa[ 8*20+ 4] =   28.00; daa[ 8*20+ 5] =  606.00; daa[ 8*20+ 6] =   43.00; daa[ 8*20+ 7] =   10.00;
	    daa[ 9*20+ 0] =   65.00; daa[ 9*20+ 1] =   64.00; daa[ 9*20+ 2] =   77.00; daa[ 9*20+ 3] =   24.00;
	    daa[ 9*20+ 4] =   44.00; daa[ 9*20+ 5] =   18.00; daa[ 9*20+ 6] =   61.00; daa[ 9*20+ 7] =    0.00;
	    daa[ 9*20+ 8] =    7.00; daa[10*20+ 0] =   41.00; daa[10*20+ 1] =   15.00; daa[10*20+ 2] =   34.00;
	    daa[10*20+ 3] =    0.00; daa[10*20+ 4] =    0.00; daa[10*20+ 5] =   73.00; daa[10*20+ 6] =   11.00;
	    daa[10*20+ 7] =    7.00; daa[10*20+ 8] =   44.00; daa[10*20+ 9] =  257.00; daa[11*20+ 0] =   26.00;
	    daa[11*20+ 1] =  464.00; daa[11*20+ 2] =  318.00; daa[11*20+ 3] =   71.00; daa[11*20+ 4] =    0.00;
	    daa[11*20+ 5] =  153.00; daa[11*20+ 6] =   83.00; daa[11*20+ 7] =   27.00; daa[11*20+ 8] =   26.00;
	    daa[11*20+ 9] =   46.00; daa[11*20+10] =   18.00; daa[12*20+ 0] =   72.00; daa[12*20+ 1] =   90.00;
	    daa[12*20+ 2] =    1.00; daa[12*20+ 3] =    0.00; daa[12*20+ 4] =    0.00; daa[12*20+ 5] =  114.00;
	    daa[12*20+ 6] =   30.00; daa[12*20+ 7] =   17.00; daa[12*20+ 8] =    0.00; daa[12*20+ 9] =  336.00;
	    daa[12*20+10] =  527.00; daa[12*20+11] =  243.00; daa[13*20+ 0] =   18.00; daa[13*20+ 1] =   14.00;
	    daa[13*20+ 2] =   14.00; daa[13*20+ 3] =    0.00; daa[13*20+ 4] =    0.00; daa[13*20+ 5] =    0.00;
	    daa[13*20+ 6] =    0.00; daa[13*20+ 7] =   15.00; daa[13*20+ 8] =   48.00; daa[13*20+ 9] =  196.00;
	    daa[13*20+10] =  157.00; daa[13*20+11] =    0.00; daa[13*20+12] =   92.00; daa[14*20+ 0] =  250.00;
	    daa[14*20+ 1] =  103.00; daa[14*20+ 2] =   42.00; daa[14*20+ 3] =   13.00; daa[14*20+ 4] =   19.00;
	    daa[14*20+ 5] =  153.00; daa[14*20+ 6] =   51.00; daa[14*20+ 7] =   34.00; daa[14*20+ 8] =   94.00;
	    daa[14*20+ 9] =   12.00; daa[14*20+10] =   32.00; daa[14*20+11] =   33.00; daa[14*20+12] =   17.00;
	    daa[14*20+13] =   11.00; daa[15*20+ 0] =  409.00; daa[15*20+ 1] =  154.00; daa[15*20+ 2] =  495.00;
	    daa[15*20+ 3] =   95.00; daa[15*20+ 4] =  161.00; daa[15*20+ 5] =   56.00; daa[15*20+ 6] =   79.00;
	    daa[15*20+ 7] =  234.00; daa[15*20+ 8] =   35.00; daa[15*20+ 9] =   24.00; daa[15*20+10] =   17.00;
	    daa[15*20+11] =   96.00; daa[15*20+12] =   62.00; daa[15*20+13] =   46.00; daa[15*20+14] =  245.00;
	    daa[16*20+ 0] =  371.00; daa[16*20+ 1] =   26.00; daa[16*20+ 2] =  229.00; daa[16*20+ 3] =   66.00;
	    daa[16*20+ 4] =   16.00; daa[16*20+ 5] =   53.00; daa[16*20+ 6] =   34.00; daa[16*20+ 7] =   30.00;
	    daa[16*20+ 8] =   22.00; daa[16*20+ 9] =  192.00; daa[16*20+10] =   33.00; daa[16*20+11] =  136.00;
	    daa[16*20+12] =  104.00; daa[16*20+13] =   13.00; daa[16*20+14] =   78.00; daa[16*20+15] =  550.00;
	    daa[17*20+ 0] =    0.00; daa[17*20+ 1] =  201.00; daa[17*20+ 2] =   23.00; daa[17*20+ 3] =    0.00;
	    daa[17*20+ 4] =    0.00; daa[17*20+ 5] =    0.00; daa[17*20+ 6] =    0.00; daa[17*20+ 7] =    0.00;
	    daa[17*20+ 8] =   27.00; daa[17*20+ 9] =    0.00; daa[17*20+10] =   46.00; daa[17*20+11] =    0.00;
	    daa[17*20+12] =    0.00; daa[17*20+13] =   76.00; daa[17*20+14] =    0.00; daa[17*20+15] =   75.00;
	    daa[17*20+16] =    0.00; daa[18*20+ 0] =   24.00; daa[18*20+ 1] =    8.00; daa[18*20+ 2] =   95.00;
	    daa[18*20+ 3] =    0.00; daa[18*20+ 4] =   96.00; daa[18*20+ 5] =    0.00; daa[18*20+ 6] =   22.00;
	    daa[18*20+ 7] =    0.00; daa[18*20+ 8] =  127.00; daa[18*20+ 9] =   37.00; daa[18*20+10] =   28.00;
	    daa[18*20+11] =   13.00; daa[18*20+12] =    0.00; daa[18*20+13] =  698.00; daa[18*20+14] =    0.00;
	    daa[18*20+15] =   34.00; daa[18*20+16] =   42.00; daa[18*20+17] =   61.00; daa[19*20+ 0] =  208.00;
	    daa[19*20+ 1] =   24.00; daa[19*20+ 2] =   15.00; daa[19*20+ 3] =   18.00; daa[19*20+ 4] =   49.00;
	    daa[19*20+ 5] =   35.00; daa[19*20+ 6] =   37.00; daa[19*20+ 7] =   54.00; daa[19*20+ 8] =   44.00;
	    daa[19*20+ 9] =  889.00; daa[19*20+10] =  175.00; daa[19*20+11] =   10.00; daa[19*20+12] =  258.00;
	    daa[19*20+13] =   12.00; daa[19*20+14] =   48.00; daa[19*20+15] =   30.00; daa[19*20+16] =  157.00;
	    daa[19*20+17] =    0.00; daa[19*20+18] =   28.00;	    	    

/*
 * ROUNDING ERROR again:
	    f[ 0] = 0.087000; f[ 1] = 0.041000; f[ 2] = 0.040000; f[ 3] = 0.047000;
	    f[ 4] = 0.034000; f[ 5] = 0.038000; f[ 6] = 0.050000; f[ 7] = 0.089000;
	    f[ 8] = 0.034000; f[ 9] = 0.037000; f[10] = 0.085000; f[11] = 0.080000;
	    f[12] = 0.014000; f[13] = 0.040000; f[14] = 0.051000; f[15] = 0.070000;
	    f[16] = 0.058000; f[17] = 0.011000; f[18] = 0.030000; f[19] = 0.064000;
*/
	    //NOTE: Originally, f[19]=0.064718 but frequencies do not sum up to 1
	    f[ 0] = 0.087127; f[ 1] = 0.040904; f[ 2] = 0.040432; f[ 3] = 0.046872;
	    f[ 4] = 0.033474; f[ 5] = 0.038255; f[ 6] = 0.049530; f[ 7] = 0.088612;
	    f[ 8] = 0.033618; f[ 9] = 0.036886; f[10] = 0.085357; f[11] = 0.080482;
	    f[12] = 0.014753; f[13] = 0.039772; f[14] = 0.050680; f[15] = 0.069577;
	    f[16] = 0.058542; f[17] = 0.010494; f[18] = 0.029916; f[19] = 0.064717;

	  }
	else if (prot_model == "DCMUT") 
	  {	
	    daa[ 1*20+ 0] =   26.78280; daa[ 2*20+ 0] =   98.44740; daa[ 2*20+ 1] =   32.70590; daa[ 3*20+ 0] =  119.98050; 
	    daa[ 3*20+ 1] =    0.00000; daa[ 3*20+ 2] =  893.15150; daa[ 4*20+ 0] =   36.00160; daa[ 4*20+ 1] =   23.23740; 
	    daa[ 4*20+ 2] =    0.00000; daa[ 4*20+ 3] =    0.00000; daa[ 5*20+ 0] =   88.77530; daa[ 5*20+ 1] =  243.99390; 
	    daa[ 5*20+ 2] =  102.85090; daa[ 5*20+ 3] =  134.85510; daa[ 5*20+ 4] =    0.00000; daa[ 6*20+ 0] =  196.11670; 
	    daa[ 6*20+ 1] =    0.00000; daa[ 6*20+ 2] =  149.34090; daa[ 6*20+ 3] = 1138.86590; daa[ 6*20+ 4] =    0.00000; 
	    daa[ 6*20+ 5] =  708.60220; daa[ 7*20+ 0] =  238.61110; daa[ 7*20+ 1] =    8.77910; daa[ 7*20+ 2] =  138.53520; 
	    daa[ 7*20+ 3] =  124.09810; daa[ 7*20+ 4] =   10.72780; daa[ 7*20+ 5] =   28.15810; daa[ 7*20+ 6] =   81.19070; 
	    daa[ 8*20+ 0] =   22.81160; daa[ 8*20+ 1] =  238.31480; daa[ 8*20+ 2] =  529.00240; daa[ 8*20+ 3] =   86.82410; 
	    daa[ 8*20+ 4] =   28.27290; daa[ 8*20+ 5] =  601.16130; daa[ 8*20+ 6] =   43.94690; daa[ 8*20+ 7] =   10.68020; 
	    daa[ 9*20+ 0] =   65.34160; daa[ 9*20+ 1] =   63.26290; daa[ 9*20+ 2] =   76.80240; daa[ 9*20+ 3] =   23.92480; 
	    daa[ 9*20+ 4] =   43.80740; daa[ 9*20+ 5] =   18.03930; daa[ 9*20+ 6] =   60.95260; daa[ 9*20+ 7] =    0.00000; 
	    daa[ 9*20+ 8] =    7.69810; daa[10*20+ 0] =   40.64310; daa[10*20+ 1] =   15.49240; daa[10*20+ 2] =   34.11130; 
	    daa[10*20+ 3] =    0.00000; daa[10*20+ 4] =    0.00000; daa[10*20+ 5] =   73.07720; daa[10*20+ 6] =   11.28800; 
	    daa[10*20+ 7] =    7.15140; daa[10*20+ 8] =   44.35040; daa[10*20+ 9] =  255.66850; daa[11*20+ 0] =   25.86350; 
	    daa[11*20+ 1] =  461.01240; daa[11*20+ 2] =  314.83710; daa[11*20+ 3] =   71.69130; daa[11*20+ 4] =    0.00000; 
	    daa[11*20+ 5] =  151.90780; daa[11*20+ 6] =   83.00780; daa[11*20+ 7] =   26.76830; daa[11*20+ 8] =   27.04750; 
	    daa[11*20+ 9] =   46.08570; daa[11*20+10] =   18.06290; daa[12*20+ 0] =   71.78400; daa[12*20+ 1] =   89.63210; 
	    daa[12*20+ 2] =    0.00000; daa[12*20+ 3] =    0.00000; daa[12*20+ 4] =    0.00000; daa[12*20+ 5] =  112.74990; 
	    daa[12*20+ 6] =   30.48030; daa[12*20+ 7] =   17.03720; daa[12*20+ 8] =    0.00000; daa[12*20+ 9] =  333.27320; 
	    daa[12*20+10] =  523.01150; daa[12*20+11] =  241.17390; daa[13*20+ 0] =   18.36410; daa[13*20+ 1] =   13.69060; 
	    daa[13*20+ 2] =   13.85030; daa[13*20+ 3] =    0.00000; daa[13*20+ 4] =    0.00000; daa[13*20+ 5] =    0.00000; 
	    daa[13*20+ 6] =    0.00000; daa[13*20+ 7] =   15.34780; daa[13*20+ 8] =   47.59270; daa[13*20+ 9] =  195.19510; 
	    daa[13*20+10] =  156.51600; daa[13*20+11] =    0.00000; daa[13*20+12] =   92.18600; daa[14*20+ 0] =  248.59200; 
	    daa[14*20+ 1] =  102.83130; daa[14*20+ 2] =   41.92440; daa[14*20+ 3] =   13.39400; daa[14*20+ 4] =   18.75500; 
	    daa[14*20+ 5] =  152.61880; daa[14*20+ 6] =   50.70030; daa[14*20+ 7] =   34.71530; daa[14*20+ 8] =   93.37090; 
	    daa[14*20+ 9] =   11.91520; daa[14*20+10] =   31.62580; daa[14*20+11] =   33.54190; daa[14*20+12] =   17.02050; 
	    daa[14*20+13] =   11.05060; daa[15*20+ 0] =  405.18700; daa[15*20+ 1] =  153.15900; daa[15*20+ 2] =  488.58920; 
	    daa[15*20+ 3] =   95.60970; daa[15*20+ 4] =  159.83560; daa[15*20+ 5] =   56.18280; daa[15*20+ 6] =   79.39990; 
	    daa[15*20+ 7] =  232.22430; daa[15*20+ 8] =   35.36430; daa[15*20+ 9] =   24.79550; daa[15*20+10] =   17.14320; 
	    daa[15*20+11] =   95.45570; daa[15*20+12] =   61.99510; daa[15*20+13] =   45.99010; daa[15*20+14] =  242.72020; 
	    daa[16*20+ 0] =  368.03650; daa[16*20+ 1] =   26.57450; daa[16*20+ 2] =  227.16970; daa[16*20+ 3] =   66.09300; 
	    daa[16*20+ 4] =   16.23660; daa[16*20+ 5] =   52.56510; daa[16*20+ 6] =   34.01560; daa[16*20+ 7] =   30.66620; 
	    daa[16*20+ 8] =   22.63330; daa[16*20+ 9] =  190.07390; daa[16*20+10] =   33.10900; daa[16*20+11] =  135.05990; 
	    daa[16*20+12] =  103.15340; daa[16*20+13] =   13.66550; daa[16*20+14] =   78.28570; daa[16*20+15] =  543.66740; 
	    daa[17*20+ 0] =    0.00000; daa[17*20+ 1] =  200.13750; daa[17*20+ 2] =   22.49680; daa[17*20+ 3] =    0.00000; 
	    daa[17*20+ 4] =    0.00000; daa[17*20+ 5] =    0.00000; daa[17*20+ 6] =    0.00000; daa[17*20+ 7] =    0.00000; 
	    daa[17*20+ 8] =   27.05640; daa[17*20+ 9] =    0.00000; daa[17*20+10] =   46.17760; daa[17*20+11] =    0.00000; 
	    daa[17*20+12] =    0.00000; daa[17*20+13] =   76.23540; daa[17*20+14] =    0.00000; daa[17*20+15] =   74.08190; 
	    daa[17*20+16] =    0.00000; daa[18*20+ 0] =   24.41390; daa[18*20+ 1] =    7.80120; daa[18*20+ 2] =   94.69400; 
	    daa[18*20+ 3] =    0.00000; daa[18*20+ 4] =   95.31640; daa[18*20+ 5] =    0.00000; daa[18*20+ 6] =   21.47170; 
	    daa[18*20+ 7] =    0.00000; daa[18*20+ 8] =  126.54000; daa[18*20+ 9] =   37.48340; daa[18*20+10] =   28.65720; 
	    daa[18*20+11] =   13.21420; daa[18*20+12] =    0.00000; daa[18*20+13] =  695.26290; daa[18*20+14] =    0.00000; 
	    daa[18*20+15] =   33.62890; daa[18*20+16] =   41.78390; daa[18*20+17] =   60.80700; daa[19*20+ 0] =  205.95640; 
	    daa[19*20+ 1] =   24.03680; daa[19*20+ 2] =   15.80670; daa[19*20+ 3] =   17.83160; daa[19*20+ 4] =   48.46780; 
	    daa[19*20+ 5] =   34.69830; daa[19*20+ 6] =   36.72500; daa[19*20+ 7] =   53.81650; daa[19*20+ 8] =   43.87150; 
	    daa[19*20+ 9] =  881.00380; daa[19*20+10] =  174.51560; daa[19*20+11] =   10.38500; daa[19*20+12] =  256.59550; 
	    daa[19*20+13] =   12.36060; daa[19*20+14] =   48.50260; daa[19*20+15] =   30.38360; daa[19*20+16] =  156.19970; 
	    daa[19*20+17] =    0.00000; daa[19*20+18] =   27.93790;   	    	   

	    /* ROUNDING ERROR:
	    f[ 0] = 0.08700; f[ 1] = 0.04100; f[ 2] = 0.04000; f[ 3] = 0.04700;
	    f[ 4] = 0.03300; f[ 5] = 0.03800; f[ 6] = 0.04900; f[ 7] = 0.08900;
	    f[ 8] = 0.03400; f[ 9] = 0.03700; f[10] = 0.08500; f[11] = 0.08000;
	    f[12] = 0.01500; f[13] = 0.04000; f[14] = 0.05200; f[15] = 0.06900;
	    f[16] = 0.05900; f[17] = 0.01000; f[18] = 0.03000; f[19] = 0.06500;
*/
	    // NOTE: originally f[19]=0.064718 but frequencies do not sum up to 1
	    f[ 0] = 0.087127; f[ 1] = 0.040904; f[ 2] = 0.040432; f[ 3] = 0.046872;
	    f[ 4] = 0.033474; f[ 5] = 0.038255; f[ 6] = 0.049530; f[ 7] = 0.088612;
	    f[ 8] = 0.033619; f[ 9] = 0.036886; f[10] = 0.085357; f[11] = 0.080481;
	    f[12] = 0.014753; f[13] = 0.039772; f[14] = 0.050680; f[15] = 0.069577;
	    f[16] = 0.058542; f[17] = 0.010494; f[18] = 0.029916; f[19] = 0.064717;

	  }
	else if (prot_model == "JTT") 
	  {
	    daa[ 1*20+ 0] =   58.00; daa[ 2*20+ 0] =   54.00; daa[ 2*20+ 1] =   45.00; daa[ 3*20+ 0] =   81.00;
	    daa[ 3*20+ 1] =   16.00; daa[ 3*20+ 2] =  528.00; daa[ 4*20+ 0] =   56.00; daa[ 4*20+ 1] =  113.00;
	    daa[ 4*20+ 2] =   34.00; daa[ 4*20+ 3] =   10.00; daa[ 5*20+ 0] =   57.00; daa[ 5*20+ 1] =  310.00;
	    daa[ 5*20+ 2] =   86.00; daa[ 5*20+ 3] =   49.00; daa[ 5*20+ 4] =    9.00; daa[ 6*20+ 0] =  105.00;
	    daa[ 6*20+ 1] =   29.00; daa[ 6*20+ 2] =   58.00; daa[ 6*20+ 3] =  767.00; daa[ 6*20+ 4] =    5.00;
	    daa[ 6*20+ 5] =  323.00; daa[ 7*20+ 0] =  179.00; daa[ 7*20+ 1] =  137.00; daa[ 7*20+ 2] =   81.00;
	    daa[ 7*20+ 3] =  130.00; daa[ 7*20+ 4] =   59.00; daa[ 7*20+ 5] =   26.00; daa[ 7*20+ 6] =  119.00;
	    daa[ 8*20+ 0] =   27.00; daa[ 8*20+ 1] =  328.00; daa[ 8*20+ 2] =  391.00; daa[ 8*20+ 3] =  112.00;
	    daa[ 8*20+ 4] =   69.00; daa[ 8*20+ 5] =  597.00; daa[ 8*20+ 6] =   26.00; daa[ 8*20+ 7] =   23.00;
	    daa[ 9*20+ 0] =   36.00; daa[ 9*20+ 1] =   22.00; daa[ 9*20+ 2] =   47.00; daa[ 9*20+ 3] =   11.00;
	    daa[ 9*20+ 4] =   17.00; daa[ 9*20+ 5] =    9.00; daa[ 9*20+ 6] =   12.00; daa[ 9*20+ 7] =    6.00;
	    daa[ 9*20+ 8] =   16.00; daa[10*20+ 0] =   30.00; daa[10*20+ 1] =   38.00; daa[10*20+ 2] =   12.00;
	    daa[10*20+ 3] =    7.00; daa[10*20+ 4] =   23.00; daa[10*20+ 5] =   72.00; daa[10*20+ 6] =    9.00;
	    daa[10*20+ 7] =    6.00; daa[10*20+ 8] =   56.00; daa[10*20+ 9] =  229.00; daa[11*20+ 0] =   35.00;
	    daa[11*20+ 1] =  646.00; daa[11*20+ 2] =  263.00; daa[11*20+ 3] =   26.00; daa[11*20+ 4] =    7.00;
	    daa[11*20+ 5] =  292.00; daa[11*20+ 6] =  181.00; daa[11*20+ 7] =   27.00; daa[11*20+ 8] =   45.00;
	    daa[11*20+ 9] =   21.00; daa[11*20+10] =   14.00; daa[12*20+ 0] =   54.00; daa[12*20+ 1] =   44.00;
	    daa[12*20+ 2] =   30.00; daa[12*20+ 3] =   15.00; daa[12*20+ 4] =   31.00; daa[12*20+ 5] =   43.00;
	    daa[12*20+ 6] =   18.00; daa[12*20+ 7] =   14.00; daa[12*20+ 8] =   33.00; daa[12*20+ 9] =  479.00;
	    daa[12*20+10] =  388.00; daa[12*20+11] =   65.00; daa[13*20+ 0] =   15.00; daa[13*20+ 1] =    5.00;
	    daa[13*20+ 2] =   10.00; daa[13*20+ 3] =    4.00; daa[13*20+ 4] =   78.00; daa[13*20+ 5] =    4.00;
	    daa[13*20+ 6] =    5.00; daa[13*20+ 7] =    5.00; daa[13*20+ 8] =   40.00; daa[13*20+ 9] =   89.00;
	    daa[13*20+10] =  248.00; daa[13*20+11] =    4.00; daa[13*20+12] =   43.00; daa[14*20+ 0] =  194.00;
	    daa[14*20+ 1] =   74.00; daa[14*20+ 2] =   15.00; daa[14*20+ 3] =   15.00; daa[14*20+ 4] =   14.00;
	    daa[14*20+ 5] =  164.00; daa[14*20+ 6] =   18.00; daa[14*20+ 7] =   24.00; daa[14*20+ 8] =  115.00;
	    daa[14*20+ 9] =   10.00; daa[14*20+10] =  102.00; daa[14*20+11] =   21.00; daa[14*20+12] =   16.00;
	    daa[14*20+13] =   17.00; daa[15*20+ 0] =  378.00; daa[15*20+ 1] =  101.00; daa[15*20+ 2] =  503.00;
	    daa[15*20+ 3] =   59.00; daa[15*20+ 4] =  223.00; daa[15*20+ 5] =   53.00; daa[15*20+ 6] =   30.00;
	    daa[15*20+ 7] =  201.00; daa[15*20+ 8] =   73.00; daa[15*20+ 9] =   40.00; daa[15*20+10] =   59.00;
	    daa[15*20+11] =   47.00; daa[15*20+12] =   29.00; daa[15*20+13] =   92.00; daa[15*20+14] =  285.00;
	    daa[16*20+ 0] =  475.00; daa[16*20+ 1] =   64.00; daa[16*20+ 2] =  232.00; daa[16*20+ 3] =   38.00;
	    daa[16*20+ 4] =   42.00; daa[16*20+ 5] =   51.00; daa[16*20+ 6] =   32.00; daa[16*20+ 7] =   33.00;
	    daa[16*20+ 8] =   46.00; daa[16*20+ 9] =  245.00; daa[16*20+10] =   25.00; daa[16*20+11] =  103.00;
	    daa[16*20+12] =  226.00; daa[16*20+13] =   12.00; daa[16*20+14] =  118.00; daa[16*20+15] =  477.00;
	    daa[17*20+ 0] =    9.00; daa[17*20+ 1] =  126.00; daa[17*20+ 2] =    8.00; daa[17*20+ 3] =    4.00;
	    daa[17*20+ 4] =  115.00; daa[17*20+ 5] =   18.00; daa[17*20+ 6] =   10.00; daa[17*20+ 7] =   55.00;
	    daa[17*20+ 8] =    8.00; daa[17*20+ 9] =    9.00; daa[17*20+10] =   52.00; daa[17*20+11] =   10.00;
	    daa[17*20+12] =   24.00; daa[17*20+13] =   53.00; daa[17*20+14] =    6.00; daa[17*20+15] =   35.00;
	    daa[17*20+16] =   12.00; daa[18*20+ 0] =   11.00; daa[18*20+ 1] =   20.00; daa[18*20+ 2] =   70.00;
	    daa[18*20+ 3] =   46.00; daa[18*20+ 4] =  209.00; daa[18*20+ 5] =   24.00; daa[18*20+ 6] =    7.00;
	    daa[18*20+ 7] =    8.00; daa[18*20+ 8] =  573.00; daa[18*20+ 9] =   32.00; daa[18*20+10] =   24.00;
	    daa[18*20+11] =    8.00; daa[18*20+12] =   18.00; daa[18*20+13] =  536.00; daa[18*20+14] =   10.00;
	    daa[18*20+15] =   63.00; daa[18*20+16] =   21.00; daa[18*20+17] =   71.00; daa[19*20+ 0] =  298.00;
	    daa[19*20+ 1] =   17.00; daa[19*20+ 2] =   16.00; daa[19*20+ 3] =   31.00; daa[19*20+ 4] =   62.00;
	    daa[19*20+ 5] =   20.00; daa[19*20+ 6] =   45.00; daa[19*20+ 7] =   47.00; daa[19*20+ 8] =   11.00;
	    daa[19*20+ 9] =  961.00; daa[19*20+10] =  180.00; daa[19*20+11] =   14.00; daa[19*20+12] =  323.00;
	    daa[19*20+13] =   62.00; daa[19*20+14] =   23.00; daa[19*20+15] =   38.00; daa[19*20+16] =  112.00;
	    daa[19*20+17] =   25.00; daa[19*20+18] =   16.00;
	    	    
	    /* ROUNDING ERROR:
	    f[ 0] = 0.07700; f[ 1] = 0.05200; f[ 2] = 0.04200; f[ 3] = 0.05100;
	    f[ 4] = 0.02000; f[ 5] = 0.04100; f[ 6] = 0.06200; f[ 7] = 0.07300;
	    f[ 8] = 0.02300; f[ 9] = 0.05400; f[10] = 0.09200; f[11] = 0.05900;
	    f[12] = 0.02400; f[13] = 0.04000; f[14] = 0.05100; f[15] = 0.06900;
	    f[16] = 0.05800; f[17] = 0.01400; f[18] = 0.03200; f[19] = 0.06600;
	    */
	    // NOTE: originally, f[19]=0.066005 but frequencies do not sum up to 1
	    f[ 0] = 0.076748; f[ 1] = 0.051691; f[ 2] = 0.042645; f[ 3] = 0.051544;
	    f[ 4] = 0.019803; f[ 5] = 0.040752; f[ 6] = 0.061830; f[ 7] = 0.073152;
	    f[ 8] = 0.022944; f[ 9] = 0.053761; f[10] = 0.091904; f[11] = 0.058676;
	    f[12] = 0.023826; f[13] = 0.040126; f[14] = 0.050901; f[15] = 0.068765;
	    f[16] = 0.058565; f[17] = 0.014261; f[18] = 0.032102; f[19] = 0.066004;

	  }
	else if (prot_model == "MTREV") 
	  {
	    daa[ 1*20+ 0] =   23.18; daa[ 2*20+ 0] =   26.95; daa[ 2*20+ 1] =   13.24; daa[ 3*20+ 0] =   17.67;
	    daa[ 3*20+ 1] =    1.90; daa[ 3*20+ 2] =  794.38; daa[ 4*20+ 0] =   59.93; daa[ 4*20+ 1] =  103.33;
	    daa[ 4*20+ 2] =   58.94; daa[ 4*20+ 3] =    1.90; daa[ 5*20+ 0] =    1.90; daa[ 5*20+ 1] =  220.99;
	    daa[ 5*20+ 2] =  173.56; daa[ 5*20+ 3] =   55.28; daa[ 5*20+ 4] =   75.24; daa[ 6*20+ 0] =    9.77;
	    daa[ 6*20+ 1] =    1.90; daa[ 6*20+ 2] =   63.05; daa[ 6*20+ 3] =  583.55; daa[ 6*20+ 4] =    1.90;
	    daa[ 6*20+ 5] =  313.56; daa[ 7*20+ 0] =  120.71; daa[ 7*20+ 1] =   23.03; daa[ 7*20+ 2] =   53.30;
	    daa[ 7*20+ 3] =   56.77; daa[ 7*20+ 4] =   30.71; daa[ 7*20+ 5] =    6.75; daa[ 7*20+ 6] =   28.28;
	    daa[ 8*20+ 0] =   13.90; daa[ 8*20+ 1] =  165.23; daa[ 8*20+ 2] =  496.13; daa[ 8*20+ 3] =  113.99;
	    daa[ 8*20+ 4] =  141.49; daa[ 8*20+ 5] =  582.40; daa[ 8*20+ 6] =   49.12; daa[ 8*20+ 7] =    1.90;
	    daa[ 9*20+ 0] =   96.49; daa[ 9*20+ 1] =    1.90; daa[ 9*20+ 2] =   27.10; daa[ 9*20+ 3] =    4.34;
	    daa[ 9*20+ 4] =   62.73; daa[ 9*20+ 5] =    8.34; daa[ 9*20+ 6] =    3.31; daa[ 9*20+ 7] =    5.98;
	    daa[ 9*20+ 8] =   12.26; daa[10*20+ 0] =   25.46; daa[10*20+ 1] =   15.58; daa[10*20+ 2] =   15.16;
	    daa[10*20+ 3] =    1.90; daa[10*20+ 4] =   25.65; daa[10*20+ 5] =   39.70; daa[10*20+ 6] =    1.90;
	    daa[10*20+ 7] =    2.41; daa[10*20+ 8] =   11.49; daa[10*20+ 9] =  329.09; daa[11*20+ 0] =    8.36;
	    daa[11*20+ 1] =  141.40; daa[11*20+ 2] =  608.70; daa[11*20+ 3] =    2.31; daa[11*20+ 4] =    1.90;
	    daa[11*20+ 5] =  465.58; daa[11*20+ 6] =  313.86; daa[11*20+ 7] =   22.73; daa[11*20+ 8] =  127.67;
	    daa[11*20+ 9] =   19.57; daa[11*20+10] =   14.88; daa[12*20+ 0] =  141.88; daa[12*20+ 1] =    1.90;
	    daa[12*20+ 2] =   65.41; daa[12*20+ 3] =    1.90; daa[12*20+ 4] =    6.18; daa[12*20+ 5] =   47.37;
	    daa[12*20+ 6] =    1.90; daa[12*20+ 7] =    1.90; daa[12*20+ 8] =   11.97; daa[12*20+ 9] =  517.98;
	    daa[12*20+10] =  537.53; daa[12*20+11] =   91.37; daa[13*20+ 0] =    6.37; daa[13*20+ 1] =    4.69;
	    daa[13*20+ 2] =   15.20; daa[13*20+ 3] =    4.98; daa[13*20+ 4] =   70.80; daa[13*20+ 5] =   19.11;
	    daa[13*20+ 6] =    2.67; daa[13*20+ 7] =    1.90; daa[13*20+ 8] =   48.16; daa[13*20+ 9] =   84.67;
	    daa[13*20+10] =  216.06; daa[13*20+11] =    6.44; daa[13*20+12] =   90.82; daa[14*20+ 0] =   54.31;
	    daa[14*20+ 1] =   23.64; daa[14*20+ 2] =   73.31; daa[14*20+ 3] =   13.43; daa[14*20+ 4] =   31.26;
	    daa[14*20+ 5] =  137.29; daa[14*20+ 6] =   12.83; daa[14*20+ 7] =    1.90; daa[14*20+ 8] =   60.97;
	    daa[14*20+ 9] =   20.63; daa[14*20+10] =   40.10; daa[14*20+11] =   50.10; daa[14*20+12] =   18.84;
	    daa[14*20+13] =   17.31; daa[15*20+ 0] =  387.86; daa[15*20+ 1] =    6.04; daa[15*20+ 2] =  494.39;
	    daa[15*20+ 3] =   69.02; daa[15*20+ 4] =  277.05; daa[15*20+ 5] =   54.11; daa[15*20+ 6] =   54.71;
	    daa[15*20+ 7] =  125.93; daa[15*20+ 8] =   77.46; daa[15*20+ 9] =   47.70; daa[15*20+10] =   73.61;
	    daa[15*20+11] =  105.79; daa[15*20+12] =  111.16; daa[15*20+13] =   64.29; daa[15*20+14] =  169.90;
	    daa[16*20+ 0] =  480.72; daa[16*20+ 1] =    2.08; daa[16*20+ 2] =  238.46; daa[16*20+ 3] =   28.01;
	    daa[16*20+ 4] =  179.97; daa[16*20+ 5] =   94.93; daa[16*20+ 6] =   14.82; daa[16*20+ 7] =   11.17;
	    daa[16*20+ 8] =   44.78; daa[16*20+ 9] =  368.43; daa[16*20+10] =  126.40; daa[16*20+11] =  136.33;
	    daa[16*20+12] =  528.17; daa[16*20+13] =   33.85; daa[16*20+14] =  128.22; daa[16*20+15] =  597.21;
	    daa[17*20+ 0] =    1.90; daa[17*20+ 1] =   21.95; daa[17*20+ 2] =   10.68; daa[17*20+ 3] =   19.86;
	    daa[17*20+ 4] =   33.60; daa[17*20+ 5] =    1.90; daa[17*20+ 6] =    1.90; daa[17*20+ 7] =   10.92;
	    daa[17*20+ 8] =    7.08; daa[17*20+ 9] =    1.90; daa[17*20+10] =   32.44; daa[17*20+11] =   24.00;
	    daa[17*20+12] =   21.71; daa[17*20+13] =    7.84; daa[17*20+14] =    4.21; daa[17*20+15] =   38.58;
	    daa[17*20+16] =    9.99; daa[18*20+ 0] =    6.48; daa[18*20+ 1] =    1.90; daa[18*20+ 2] =  191.36;
	    daa[18*20+ 3] =   21.21; daa[18*20+ 4] =  254.77; daa[18*20+ 5] =   38.82; daa[18*20+ 6] =   13.12;
	    daa[18*20+ 7] =    3.21; daa[18*20+ 8] =  670.14; daa[18*20+ 9] =   25.01; daa[18*20+10] =   44.15;
	    daa[18*20+11] =   51.17; daa[18*20+12] =   39.96; daa[18*20+13] =  465.58; daa[18*20+14] =   16.21;
	    daa[18*20+15] =   64.92; daa[18*20+16] =   38.73; daa[18*20+17] =   26.25; daa[19*20+ 0] =  195.06;
	    daa[19*20+ 1] =    7.64; daa[19*20+ 2] =    1.90; daa[19*20+ 3] =    1.90; daa[19*20+ 4] =    1.90;
	    daa[19*20+ 5] =   19.00; daa[19*20+ 6] =   21.14; daa[19*20+ 7] =    2.53; daa[19*20+ 8] =    1.90;
	    daa[19*20+ 9] = 1222.94; daa[19*20+10] =   91.67; daa[19*20+11] =    1.90; daa[19*20+12] =  387.54;
	    daa[19*20+13] =    6.35; daa[19*20+14] =    8.23; daa[19*20+15] =    1.90; daa[19*20+16] =  204.54;
	    daa[19*20+17] =    5.37; daa[19*20+18] =    1.90;
	    
	    
	    f[ 0] = 0.072000; f[ 1] = 0.019000; f[ 2] = 0.039000; f[ 3] = 0.019000;
	    f[ 4] = 0.006000; f[ 5] = 0.025000; f[ 6] = 0.024000; f[ 7] = 0.056000;
	    f[ 8] = 0.028000; f[ 9] = 0.088000; f[10] = 0.169000; f[11] = 0.023000;
	    f[12] = 0.054000; f[13] = 0.061000; f[14] = 0.054000; f[15] = 0.072000;
	    f[16] = 0.086000; f[17] = 0.029000; f[18] = 0.033000; f[19] = 0.043000;
/*
	The original matrix from Adachi & Hasegawa (1996) is:
	    f[ 0] = 0.072000; f[ 1] = 0.019000; f[ 2] = 0.039000; f[ 3] = 0.019000;
	    f[ 4] = 0.006000; f[ 5] = 0.025000; f[ 6] = 0.024000; f[ 7] = 0.056000;
	    f[ 8] = 0.028000; f[ 9] = 0.087000; f[10] = 0.168000; f[11] = 0.023000;
	    f[12] = 0.053000; f[13] = 0.061000; f[14] = 0.055000; f[15] = 0.072000;
	    f[16] = 0.088000; f[17] = 0.029000; f[18] = 0.033000; f[19] = 0.044000;
	but they sum up to 1.001
*/
	  }
	else if (prot_model == "WAG") 
	  {
	    daa[ 1*20+ 0] =  55.15710; daa[ 2*20+ 0] =  50.98480; daa[ 2*20+ 1] =  63.53460; 
	    daa[ 3*20+ 0] =  73.89980; daa[ 3*20+ 1] =  14.73040; daa[ 3*20+ 2] = 542.94200; 
	    daa[ 4*20+ 0] = 102.70400; daa[ 4*20+ 1] =  52.81910; daa[ 4*20+ 2] =  26.52560; 
	    daa[ 4*20+ 3] =   3.02949; daa[ 5*20+ 0] =  90.85980; daa[ 5*20+ 1] = 303.55000; 
	    daa[ 5*20+ 2] = 154.36400; daa[ 5*20+ 3] =  61.67830; daa[ 5*20+ 4] =   9.88179; 
	    daa[ 6*20+ 0] = 158.28500; daa[ 6*20+ 1] =  43.91570; daa[ 6*20+ 2] =  94.71980; 
	    daa[ 6*20+ 3] = 617.41600; daa[ 6*20+ 4] =   2.13520; daa[ 6*20+ 5] = 546.94700; 
	    daa[ 7*20+ 0] = 141.67200; daa[ 7*20+ 1] =  58.46650; daa[ 7*20+ 2] = 112.55600; 
	    daa[ 7*20+ 3] =  86.55840; daa[ 7*20+ 4] =  30.66740; daa[ 7*20+ 5] =  33.00520; 
	    daa[ 7*20+ 6] =  56.77170; daa[ 8*20+ 0] =  31.69540; daa[ 8*20+ 1] = 213.71500; 
	    daa[ 8*20+ 2] = 395.62900; daa[ 8*20+ 3] =  93.06760; daa[ 8*20+ 4] =  24.89720; 
	    daa[ 8*20+ 5] = 429.41100; daa[ 8*20+ 6] =  57.00250; daa[ 8*20+ 7] =  24.94100; 
	    daa[ 9*20+ 0] =  19.33350; daa[ 9*20+ 1] =  18.69790; daa[ 9*20+ 2] =  55.42360; 
	    daa[ 9*20+ 3] =   3.94370; daa[ 9*20+ 4] =  17.01350; daa[ 9*20+ 5] =  11.39170; 
	    daa[ 9*20+ 6] =  12.73950; daa[ 9*20+ 7] =   3.04501; daa[ 9*20+ 8] =  13.81900; 
	    daa[10*20+ 0] =  39.79150; daa[10*20+ 1] =  49.76710; daa[10*20+ 2] =  13.15280; 
	    daa[10*20+ 3] =   8.48047; daa[10*20+ 4] =  38.42870; daa[10*20+ 5] =  86.94890; 
	    daa[10*20+ 6] =  15.42630; daa[10*20+ 7] =   6.13037; daa[10*20+ 8] =  49.94620; 
	    daa[10*20+ 9] = 317.09700; daa[11*20+ 0] =  90.62650; daa[11*20+ 1] = 535.14200; 
	    daa[11*20+ 2] = 301.20100; daa[11*20+ 3] =  47.98550; daa[11*20+ 4] =   7.40339; 
	    daa[11*20+ 5] = 389.49000; daa[11*20+ 6] = 258.44300; daa[11*20+ 7] =  37.35580; 
	    daa[11*20+ 8] =  89.04320; daa[11*20+ 9] =  32.38320; daa[11*20+10] =  25.75550; 
	    daa[12*20+ 0] =  89.34960; daa[12*20+ 1] =  68.31620; daa[12*20+ 2] =  19.82210; 
	    daa[12*20+ 3] =  10.37540; daa[12*20+ 4] =  39.04820; daa[12*20+ 5] = 154.52600; 
	    daa[12*20+ 6] =  31.51240; daa[12*20+ 7] =  17.41000; daa[12*20+ 8] =  40.41410; 
	    daa[12*20+ 9] = 425.74600; daa[12*20+10] = 485.40200; daa[12*20+11] =  93.42760; 
	    daa[13*20+ 0] =  21.04940; daa[13*20+ 1] =  10.27110; daa[13*20+ 2] =   9.61621; 
	    daa[13*20+ 3] =   4.67304; daa[13*20+ 4] =  39.80200; daa[13*20+ 5] =   9.99208; 
	    daa[13*20+ 6] =   8.11339; daa[13*20+ 7] =   4.99310; daa[13*20+ 8] =  67.93710; 
	    daa[13*20+ 9] = 105.94700; daa[13*20+10] = 211.51700; daa[13*20+11] =   8.88360; 
	    daa[13*20+12] = 119.06300; daa[14*20+ 0] = 143.85500; daa[14*20+ 1] =  67.94890; 
	    daa[14*20+ 2] =  19.50810; daa[14*20+ 3] =  42.39840; daa[14*20+ 4] =  10.94040; 
	    daa[14*20+ 5] =  93.33720; daa[14*20+ 6] =  68.23550; daa[14*20+ 7] =  24.35700; 
	    daa[14*20+ 8] =  69.61980; daa[14*20+ 9] =   9.99288; daa[14*20+10] =  41.58440; 
	    daa[14*20+11] =  55.68960; daa[14*20+12] =  17.13290; daa[14*20+13] =  16.14440; 
	    daa[15*20+ 0] = 337.07900; daa[15*20+ 1] = 122.41900; daa[15*20+ 2] = 397.42300; 
	    daa[15*20+ 3] = 107.17600; daa[15*20+ 4] = 140.76600; daa[15*20+ 5] = 102.88700; 
	    daa[15*20+ 6] =  70.49390; daa[15*20+ 7] = 134.18200; daa[15*20+ 8] =  74.01690; 
	    daa[15*20+ 9] =  31.94400; daa[15*20+10] =  34.47390; daa[15*20+11] =  96.71300; 
	    daa[15*20+12] =  49.39050; daa[15*20+13] =  54.59310; daa[15*20+14] = 161.32800; 
	    daa[16*20+ 0] = 212.11100; daa[16*20+ 1] =  55.44130; daa[16*20+ 2] = 203.00600; 
	    daa[16*20+ 3] =  37.48660; daa[16*20+ 4] =  51.29840; daa[16*20+ 5] =  85.79280; 
	    daa[16*20+ 6] =  82.27650; daa[16*20+ 7] =  22.58330; daa[16*20+ 8] =  47.33070; 
	    daa[16*20+ 9] = 145.81600; daa[16*20+10] =  32.66220; daa[16*20+11] = 138.69800; 
	    daa[16*20+12] = 151.61200; daa[16*20+13] =  17.19030; daa[16*20+14] =  79.53840; 
	    daa[16*20+15] = 437.80200; daa[17*20+ 0] =  11.31330; daa[17*20+ 1] = 116.39200; 
	    daa[17*20+ 2] =   7.19167; daa[17*20+ 3] =  12.97670; daa[17*20+ 4] =  71.70700; 
	    daa[17*20+ 5] =  21.57370; daa[17*20+ 6] =  15.65570; daa[17*20+ 7] =  33.69830; 
	    daa[17*20+ 8] =  26.25690; daa[17*20+ 9] =  21.24830; daa[17*20+10] =  66.53090; 
	    daa[17*20+11] =  13.75050; daa[17*20+12] =  51.57060; daa[17*20+13] = 152.96400; 
	    daa[17*20+14] =  13.94050; daa[17*20+15] =  52.37420; daa[17*20+16] =  11.08640; 
	    daa[18*20+ 0] =  24.07350; daa[18*20+ 1] =  38.15330; daa[18*20+ 2] = 108.60000; 
	    daa[18*20+ 3] =  32.57110; daa[18*20+ 4] =  54.38330; daa[18*20+ 5] =  22.77100; 
	    daa[18*20+ 6] =  19.63030; daa[18*20+ 7] =  10.36040; daa[18*20+ 8] = 387.34400; 
	    daa[18*20+ 9] =  42.01700; daa[18*20+10] =  39.86180; daa[18*20+11] =  13.32640; 
	    daa[18*20+12] =  42.84370; daa[18*20+13] = 645.42800; daa[18*20+14] =  21.60460; 
	    daa[18*20+15] =  78.69930; daa[18*20+16] =  29.11480; daa[18*20+17] = 248.53900; 
	    daa[19*20+ 0] = 200.60100; daa[19*20+ 1] =  25.18490; daa[19*20+ 2] =  19.62460; 
	    daa[19*20+ 3] =  15.23350; daa[19*20+ 4] = 100.21400; daa[19*20+ 5] =  30.12810; 
	    daa[19*20+ 6] =  58.87310; daa[19*20+ 7] =  18.72470; daa[19*20+ 8] =  11.83580; 
	    daa[19*20+ 9] = 782.13000; daa[19*20+10] = 180.03400; daa[19*20+11] =  30.54340; 
	    daa[19*20+12] = 205.84500; daa[19*20+13] =  64.98920; daa[19*20+14] =  31.48870; 
	    daa[19*20+15] =  23.27390; daa[19*20+16] = 138.82300; daa[19*20+17] =  36.53690; 
	    daa[19*20+18] =  31.47300; 
	    	   
/*		THIS WRONG FREQUENCIES ARE ROUNDED to 3 digits, same for RAxML
  	    f[0]  = 0.08700; f[1]  = 0.04400; f[2]  = 0.03900; f[3]  = 0.05700;
	    f[4]  = 0.01900; f[5]  = 0.03700; f[6]  = 0.05800; f[7]  = 0.08300;
	    f[8]  = 0.02400; f[9]  = 0.04900; f[10] = 0.08600; f[11] = 0.06200;
	    f[12] = 0.02000; f[13] = 0.03800; f[14] = 0.04600; f[15] = 0.07000;
	    f[16] = 0.06100; f[17] = 0.01400; f[18] = 0.03500; f[19] = 0.07100;   
*/
	    // NOTE: originally, f[19]= 0.0708956 but frequencies do not sum up to 1
	    f[0] = 0.0866279; f[1] =  0.043972; f[2] =  0.0390894; f[3] =  0.0570451;
	    f[4] =  0.0193078; f[5] =  0.0367281; f[6] =  0.0580589; f[7] =  0.0832518;
	    f[8] =  0.0244313; f[9] =  0.048466; f[10] =  0.086209; f[11] = 0.0620286;
	    f[12] = 0.0195027; f[13] =  0.0384319; f[14] =  0.0457631; f[15] = 0.0695179;
	    f[16] =  0.0610127; f[17] =  0.0143859; f[18] =  0.0352742; f[19] =  0.0708957;
	  }
	else if (prot_model == "RTREV") 
	  {
	    daa[1*20+0]= 34;         daa[2*20+0]= 51;         daa[2*20+1]= 35;         daa[3*20+0]= 10;         
	    daa[3*20+1]= 30;         daa[3*20+2]= 384;        daa[4*20+0]= 439;        daa[4*20+1]= 92;         
	    daa[4*20+2]= 128;        daa[4*20+3]= 1;          daa[5*20+0]= 32;         daa[5*20+1]= 221;        
	    daa[5*20+2]= 236;        daa[5*20+3]= 78;         daa[5*20+4]= 70;         daa[6*20+0]= 81;         
	    daa[6*20+1]= 10;         daa[6*20+2]= 79;         daa[6*20+3]= 542;        daa[6*20+4]= 1;          
	    daa[6*20+5]= 372;        daa[7*20+0]= 135;        daa[7*20+1]= 41;         daa[7*20+2]= 94;         
	    daa[7*20+3]= 61;         daa[7*20+4]= 48;         daa[7*20+5]= 18;         daa[7*20+6]= 70;         
	    daa[8*20+0]= 30;         daa[8*20+1]= 90;         daa[8*20+2]= 320;        daa[8*20+3]= 91;         
	    daa[8*20+4]= 124;        daa[8*20+5]= 387;        daa[8*20+6]= 34;         daa[8*20+7]= 68;         
	    daa[9*20+0]= 1;          daa[9*20+1]= 24;         daa[9*20+2]= 35;         daa[9*20+3]= 1;          
	    daa[9*20+4]= 104;        daa[9*20+5]= 33;         daa[9*20+6]= 1;          daa[9*20+7]= 1;          
	    daa[9*20+8]= 34;         daa[10*20+0]= 45;        daa[10*20+1]= 18;        daa[10*20+2]= 15;        
	    daa[10*20+3]= 5;         daa[10*20+4]= 110;       daa[10*20+5]= 54;        daa[10*20+6]= 21;        
	    daa[10*20+7]= 3;         daa[10*20+8]= 51;        daa[10*20+9]= 385;       daa[11*20+0]= 38;        
	    daa[11*20+1]= 593;       daa[11*20+2]= 123;       daa[11*20+3]= 20;        daa[11*20+4]= 16;        
	    daa[11*20+5]= 309;       daa[11*20+6]= 141;       daa[11*20+7]= 30;        daa[11*20+8]= 76;        
	    daa[11*20+9]= 34;        daa[11*20+10]= 23;       daa[12*20+0]= 235;       daa[12*20+1]= 57;        
	    daa[12*20+2]= 1;         daa[12*20+3]= 1;         daa[12*20+4]= 156;       daa[12*20+5]= 158;       
	    daa[12*20+6]= 1;         daa[12*20+7]= 37;        daa[12*20+8]= 116;       daa[12*20+9]= 375;       
	    daa[12*20+10]= 581;      daa[12*20+11]= 134;      daa[13*20+0]= 1;         daa[13*20+1]= 7;         
	    daa[13*20+2]= 49;        daa[13*20+3]= 1;         daa[13*20+4]= 70;        daa[13*20+5]= 1;         
	    daa[13*20+6]= 1;         daa[13*20+7]= 7;         daa[13*20+8]= 141;       daa[13*20+9]= 64;        
	    daa[13*20+10]= 179;      daa[13*20+11]= 14;       daa[13*20+12]= 247;      daa[14*20+0]= 97;        
	    daa[14*20+1]= 24;        daa[14*20+2]= 33;        daa[14*20+3]= 55;        daa[14*20+4]= 1;         
	    daa[14*20+5]= 68;        daa[14*20+6]= 52;        daa[14*20+7]= 17;        daa[14*20+8]= 44;        
	    daa[14*20+9]= 10;        daa[14*20+10]= 22;       daa[14*20+11]= 43;       daa[14*20+12]= 1;        
	    daa[14*20+13]= 11;       daa[15*20+0]= 460;       daa[15*20+1]= 102;       daa[15*20+2]= 294;       
	    daa[15*20+3]= 136;       daa[15*20+4]= 75;        daa[15*20+5]= 225;       daa[15*20+6]= 95;        
	    daa[15*20+7]= 152;       daa[15*20+8]= 183;       daa[15*20+9]= 4;         daa[15*20+10]= 24;       
	    daa[15*20+11]= 77;       daa[15*20+12]= 1;        daa[15*20+13]= 20;       daa[15*20+14]= 134;      
	    daa[16*20+0]= 258;       daa[16*20+1]= 64;        daa[16*20+2]= 148;       daa[16*20+3]= 55;        
	    daa[16*20+4]= 117;       daa[16*20+5]= 146;       daa[16*20+6]= 82;        daa[16*20+7]= 7;         
	    daa[16*20+8]= 49;        daa[16*20+9]= 72;        daa[16*20+10]= 25;       daa[16*20+11]= 110;      
	    daa[16*20+12]= 131;      daa[16*20+13]= 69;       daa[16*20+14]= 62;       daa[16*20+15]= 671;      
	    daa[17*20+0]= 5;         daa[17*20+1]= 13;        daa[17*20+2]= 16;        daa[17*20+3]= 1;         
	    daa[17*20+4]= 55;        daa[17*20+5]= 10;        daa[17*20+6]= 17;        daa[17*20+7]= 23;        
	    daa[17*20+8]= 48;        daa[17*20+9]= 39;        daa[17*20+10]= 47;       daa[17*20+11]= 6;        
	    daa[17*20+12]= 111;      daa[17*20+13]= 182;      daa[17*20+14]= 9;        daa[17*20+15]= 14;       
	    daa[17*20+16]= 1;        daa[18*20+0]= 55;        daa[18*20+1]= 47;        daa[18*20+2]= 28;        
	    daa[18*20+3]= 1;         daa[18*20+4]= 131;       daa[18*20+5]= 45;        daa[18*20+6]= 1;         
	    daa[18*20+7]= 21;        daa[18*20+8]= 307;       daa[18*20+9]= 26;        daa[18*20+10]= 64;       
	    daa[18*20+11]= 1;        daa[18*20+12]= 74;       daa[18*20+13]= 1017;     daa[18*20+14]= 14;       
	    daa[18*20+15]= 31;       daa[18*20+16]= 34;       daa[18*20+17]= 176;      daa[19*20+0]= 197;       
	    daa[19*20+1]= 29;        daa[19*20+2]= 21;        daa[19*20+3]= 6;         daa[19*20+4]= 295;       
	    daa[19*20+5]= 36;        daa[19*20+6]= 35;        daa[19*20+7]= 3;         daa[19*20+8]= 1;         
	    daa[19*20+9]= 1048;      daa[19*20+10]= 112;      daa[19*20+11]= 19;       daa[19*20+12]= 236;      
	    daa[19*20+13]= 92;       daa[19*20+14]= 25;       daa[19*20+15]= 39;       daa[19*20+16]= 196;      
	    daa[19*20+17]= 26;       daa[19*20+18]= 59;       
	    
	    f[0]= 0.0646;           f[1]= 0.0453;           f[2]= 0.0376;           f[3]= 0.0422;           
	    f[4]= 0.0114;           f[5]= 0.0606;           f[6]= 0.0607;           f[7]= 0.0639;           
	    f[8]= 0.0273;           f[9]= 0.0679;           f[10]= 0.1018;          f[11]= 0.0751;          
	    f[12]= 0.015;           f[13]= 0.0287;          f[14]= 0.0681;          f[15]= 0.0488;          
	    f[16]= 0.0622;          f[17]= 0.0251;          f[18]= 0.0318;          f[19]= 0.0619;	    	    
	  }
	else if (prot_model == "CPREV") 
	  {
	    daa[1*20+0]= 105;        daa[2*20+0]= 227;        daa[2*20+1]= 357;        daa[3*20+0]= 175;        
	    daa[3*20+1]= 43;         daa[3*20+2]= 4435;       daa[4*20+0]= 669;        daa[4*20+1]= 823;        
	    daa[4*20+2]= 538;        daa[4*20+3]= 10;         daa[5*20+0]= 157;        daa[5*20+1]= 1745;       
	    daa[5*20+2]= 768;        daa[5*20+3]= 400;        daa[5*20+4]= 10;         daa[6*20+0]= 499;        
	    daa[6*20+1]= 152;        daa[6*20+2]= 1055;       daa[6*20+3]= 3691;       daa[6*20+4]= 10;         
	    daa[6*20+5]= 3122;       daa[7*20+0]= 665;        daa[7*20+1]= 243;        daa[7*20+2]= 653;        
	    daa[7*20+3]= 431;        daa[7*20+4]= 303;        daa[7*20+5]= 133;        daa[7*20+6]= 379;        
	    daa[8*20+0]= 66;         daa[8*20+1]= 715;        daa[8*20+2]= 1405;       daa[8*20+3]= 331;        
	    daa[8*20+4]= 441;        daa[8*20+5]= 1269;       daa[8*20+6]= 162;        daa[8*20+7]= 19;         
	    daa[9*20+0]= 145;        daa[9*20+1]= 136;        daa[9*20+2]= 168;        daa[9*20+3]= 10;         
	    daa[9*20+4]= 280;        daa[9*20+5]= 92;         daa[9*20+6]= 148;        daa[9*20+7]= 40;         
	    daa[9*20+8]= 29;         daa[10*20+0]= 197;       daa[10*20+1]= 203;       daa[10*20+2]= 113;       
	    daa[10*20+3]= 10;        daa[10*20+4]= 396;       daa[10*20+5]= 286;       daa[10*20+6]= 82;        
	    daa[10*20+7]= 20;        daa[10*20+8]= 66;        daa[10*20+9]= 1745;      daa[11*20+0]= 236;       
	    daa[11*20+1]= 4482;      daa[11*20+2]= 2430;      daa[11*20+3]= 412;       daa[11*20+4]= 48;        
	    daa[11*20+5]= 3313;      daa[11*20+6]= 2629;      daa[11*20+7]= 263;       daa[11*20+8]= 305;       
	    daa[11*20+9]= 345;       daa[11*20+10]= 218;      daa[12*20+0]= 185;       daa[12*20+1]= 125;       
	    daa[12*20+2]= 61;        daa[12*20+3]= 47;        daa[12*20+4]= 159;       daa[12*20+5]= 202;       
	    daa[12*20+6]= 113;       daa[12*20+7]= 21;        daa[12*20+8]= 10;        daa[12*20+9]= 1772;      
	    daa[12*20+10]= 1351;     daa[12*20+11]= 193;      daa[13*20+0]= 68;        daa[13*20+1]= 53;        
	    daa[13*20+2]= 97;        daa[13*20+3]= 22;        daa[13*20+4]= 726;       daa[13*20+5]= 10;        
	    daa[13*20+6]= 145;       daa[13*20+7]= 25;        daa[13*20+8]= 127;       daa[13*20+9]= 454;       
	    daa[13*20+10]= 1268;     daa[13*20+11]= 72;       daa[13*20+12]= 327;      daa[14*20+0]= 490;       
	    daa[14*20+1]= 87;        daa[14*20+2]= 173;       daa[14*20+3]= 170;       daa[14*20+4]= 285;       
	    daa[14*20+5]= 323;       daa[14*20+6]= 185;       daa[14*20+7]= 28;        daa[14*20+8]= 152;       
	    daa[14*20+9]= 117;       daa[14*20+10]= 219;      daa[14*20+11]= 302;      daa[14*20+12]= 100;      
	    daa[14*20+13]= 43;       daa[15*20+0]= 2440;      daa[15*20+1]= 385;       daa[15*20+2]= 2085;      
	    daa[15*20+3]= 590;       daa[15*20+4]= 2331;      daa[15*20+5]= 396;       daa[15*20+6]= 568;       
	    daa[15*20+7]= 691;       daa[15*20+8]= 303;       daa[15*20+9]= 216;       daa[15*20+10]= 516;      
	    daa[15*20+11]= 868;      daa[15*20+12]= 93;       daa[15*20+13]= 487;      daa[15*20+14]= 1202;     
	    daa[16*20+0]= 1340;      daa[16*20+1]= 314;       daa[16*20+2]= 1393;      daa[16*20+3]= 266;       
	    daa[16*20+4]= 576;       daa[16*20+5]= 241;       daa[16*20+6]= 369;       daa[16*20+7]= 92;        
	    daa[16*20+8]= 32;        daa[16*20+9]= 1040;      daa[16*20+10]= 156;      daa[16*20+11]= 918;      
	    daa[16*20+12]= 645;      daa[16*20+13]= 148;      daa[16*20+14]= 260;      daa[16*20+15]= 2151;     
	    daa[17*20+0]= 14;        daa[17*20+1]= 230;       daa[17*20+2]= 40;        daa[17*20+3]= 18;        
	    daa[17*20+4]= 435;       daa[17*20+5]= 53;        daa[17*20+6]= 63;        daa[17*20+7]= 82;        
	    daa[17*20+8]= 69;        daa[17*20+9]= 42;        daa[17*20+10]= 159;      daa[17*20+11]= 10;       
	    daa[17*20+12]= 86;       daa[17*20+13]= 468;      daa[17*20+14]= 49;       daa[17*20+15]= 73;       
	    daa[17*20+16]= 29;       daa[18*20+0]= 56;        daa[18*20+1]= 323;       daa[18*20+2]= 754;       
	    daa[18*20+3]= 281;       daa[18*20+4]= 1466;      daa[18*20+5]= 391;       daa[18*20+6]= 142;       
	    daa[18*20+7]= 10;        daa[18*20+8]= 1971;      daa[18*20+9]= 89;        daa[18*20+10]= 189;      
	    daa[18*20+11]= 247;      daa[18*20+12]= 215;      daa[18*20+13]= 2370;     daa[18*20+14]= 97;       
	    daa[18*20+15]= 522;      daa[18*20+16]= 71;       daa[18*20+17]= 346;      daa[19*20+0]= 968;       
	    daa[19*20+1]= 92;        daa[19*20+2]= 83;        daa[19*20+3]= 75;        daa[19*20+4]= 592;       
	    daa[19*20+5]= 54;        daa[19*20+6]= 200;       daa[19*20+7]= 91;        daa[19*20+8]= 25;        
	    daa[19*20+9]= 4797;      daa[19*20+10]= 865;      daa[19*20+11]= 249;      daa[19*20+12]= 475;      
	    daa[19*20+13]= 317;      daa[19*20+14]= 122;      daa[19*20+15]= 167;      daa[19*20+16]= 760;      
	    daa[19*20+17]= 10;       daa[19*20+18]= 119;      
	    
	    f[0]= 0.076;            f[1]= 0.062;            f[2]= 0.041;            f[3]= 0.037;            
	    f[4]= 0.009;            f[5]= 0.038;            f[6]= 0.049;            f[7]= 0.084;            
	    f[8]= 0.025;            f[9]= 0.081;            f[10]= 0.101;           f[11]= 0.05;            
	    f[12]= 0.022;           f[13]= 0.051;           f[14]= 0.043;           f[15]= 0.062;           
	    f[16]= 0.054;           f[17]= 0.018;           f[18]= 0.031;           f[19]= 0.066; 
	  }
	else if (prot_model == "VT") 
	  {

	    daa[1*20+0]=   1.2412691067876198;
	    daa[2*20+0]=   1.2184237953498958;
	    daa[2*20+1]=   1.5720770753326880;
	    daa[3*20+0]=   1.3759368509441177;
	    daa[3*20+1]=   0.7550654439001206;
	    daa[3*20+2]=   7.8584219153689405;
	    daa[4*20+0]=   2.4731223087544874;
	    daa[4*20+1]=   1.4414262567428417;
	    daa[4*20+2]=   0.9784679122774127;
	    daa[4*20+3]=   0.2272488448121475;
	    daa[5*20+0]=   2.2155167805137470;
	    daa[5*20+1]=   5.5120819705248678;
	    daa[5*20+2]=   3.0143201670924822;
	    daa[5*20+3]=   1.6562495638176040;
	    daa[5*20+4]=   0.4587469126746136;
	    daa[6*20+0]=   2.3379911207495061;
	    daa[6*20+1]=   1.3542404860613146;
	    daa[6*20+2]=   2.0093434778398112;
	    daa[6*20+3]=   9.6883451875685065;
	    daa[6*20+4]=   0.4519167943192672;
	    daa[6*20+5]=   6.8124601839937675;
	    daa[7*20+0]=   3.3386555146457697;
	    daa[7*20+1]=   1.3121700301622004;
	    daa[7*20+2]=   2.4117632898861809;
	    daa[7*20+3]=   1.9142079025990228;
	    daa[7*20+4]=   1.1034605684472507;
	    daa[7*20+5]=   0.8776110594765502;
	    daa[7*20+6]=   1.3860121390169038;
	    daa[8*20+0]=   0.9615841926910841;
	    daa[8*20+1]=   4.9238668283945266;
	    daa[8*20+2]=   6.1974384977884114;
	    daa[8*20+3]=   2.1459640610133781;
	    daa[8*20+4]=   1.5196756759380692;
	    daa[8*20+5]=   7.9943228564946525;
	    daa[8*20+6]=   1.6360079688522375;
	    daa[8*20+7]=   0.8561248973045037;
	    daa[9*20+0]=   0.8908203061925510;
	    daa[9*20+1]=   0.4323005487925516;
	    daa[9*20+2]=   0.9179291175331520;
	    daa[9*20+3]=   0.2161660372725585;
	    daa[9*20+4]=   0.9126668032539315;
	    daa[9*20+5]=   0.4882733432879921;
	    daa[9*20+6]=   0.4035497929633328;
	    daa[9*20+7]=   0.2888075033037488;
	    daa[9*20+8]=   0.5787937115407940;
	    daa[10*20+0]=  1.0778497408764076;
	    daa[10*20+1]=  0.8386701149158265;
	    daa[10*20+2]=  0.4098311270816011;
	    daa[10*20+3]=  0.3574207468998517;
	    daa[10*20+4]=  1.4081315998413697;
	    daa[10*20+5]=  1.3318097154194044;
	    daa[10*20+6]=  0.5610717242294755;
	    daa[10*20+7]=  0.3578662395745526;
	    daa[10*20+8]=  1.0765007949562073;
	    daa[10*20+9]=  6.0019110258426362;
	    daa[11*20+0]=  1.4932055816372476;
	    daa[11*20+1]=  10.017330817366002;
	    daa[11*20+2]=  4.4034547578962568;
	    daa[11*20+3]=  1.4521790561663968;
	    daa[11*20+4]=  0.3371091785647479;
	    daa[11*20+5]=  6.0519085243118811;
	    daa[11*20+6]=  4.3290086529582830;
	    daa[11*20+7]=  0.8945563662345198;
	    daa[11*20+8]=  1.8085136096039203;
	    daa[11*20+9]=  0.6244297525127139;
	    daa[11*20+10]= 0.5642322882556321;
	    daa[12*20+0]=  1.9006455961717605;
	    daa[12*20+1]=  1.2488638689609959;
	    daa[12*20+2]=  0.9378803706165143;
	    daa[12*20+3]=  0.4075239926000898;
	    daa[12*20+4]=  1.2213054800811556;
	    daa[12*20+5]=  1.9106190827629084;
	    daa[12*20+6]=  0.7471936218068498;
	    daa[12*20+7]=  0.5954812791740037;
	    daa[12*20+8]=  1.3808291710019667;
	    daa[12*20+9]=  6.7597899772045418;
	    daa[12*20+10]= 8.0327792947421148;
	    daa[12*20+11]= 1.7129670976916258;
	    daa[13*20+0]=  0.6883439026872615;
	    daa[13*20+1]=  0.4224945197276290;
	    daa[13*20+2]=  0.5044944273324311;
	    daa[13*20+3]=  0.1675129724559251;
	    daa[13*20+4]=  1.6953951980808002;
	    daa[13*20+5]=  0.3573432522499545;
	    daa[13*20+6]=  0.2317194387691585;
	    daa[13*20+7]=  0.3693722640980460;
	    daa[13*20+8]=  1.3629765501081097;
	    daa[13*20+9]=  2.2864286949316077;
	    daa[13*20+10]= 4.3611548063555778;
	    daa[13*20+11]= 0.3910559903834828;
	    daa[13*20+12]= 2.3201373546296349;
	    daa[14*20+0]=  2.7355620089953550;
	    daa[14*20+1]=  1.3091837782420783;
	    daa[14*20+2]=  0.7103720531974738;
	    daa[14*20+3]=  1.0714605979577547;
	    daa[14*20+4]=  0.4326227078645523;
	    daa[14*20+5]=  2.3019177728300728;
	    daa[14*20+6]=  1.5132807416252063;
	    daa[14*20+7]=  0.7744933618134962;
	    daa[14*20+8]=  1.8370555852070649;
	    daa[14*20+9]=  0.4811402387911145;
	    daa[14*20+10]= 1.0084320519837335;
	    daa[14*20+11]= 1.3918935593582853;
	    daa[14*20+12]= 0.4953193808676289;
	    daa[14*20+13]= 0.3746821107962129;
	    daa[15*20+0]=  6.4208961859142883;
	    daa[15*20+1]=  1.9202994262316166;
	    daa[15*20+2]=  6.1234512396801764;
	    daa[15*20+3]=  2.2161944596741829;
	    daa[15*20+4]=  3.6366815408744255;
	    daa[15*20+5]=  2.3193703643237220;
	    daa[15*20+6]=  1.8273535587773553;
	    daa[15*20+7]=  3.0637776193717610;
	    daa[15*20+8]=  1.9699895187387506;
	    daa[15*20+9]=  0.6047491507504744;
	    daa[15*20+10]= 0.8953754669269811;
	    daa[15*20+11]= 1.9776630140912268;
	    daa[15*20+12]= 1.0657482318076852;
	    daa[15*20+13]= 1.1079144700606407;
	    daa[15*20+14]= 3.5465914843628927;
	    daa[16*20+0]=  5.2892514169776437;
	    daa[16*20+1]=  1.3363401740560601;
	    daa[16*20+2]=  3.8852506105922231;
	    daa[16*20+3]=  1.5066839872944762;
	    daa[16*20+4]=  1.7557065205837685;
	    daa[16*20+5]=  2.1576510103471440;
	    daa[16*20+6]=  1.5839981708584689;
	    daa[16*20+7]=  0.7147489676267383;
	    daa[16*20+8]=  1.6136654573285647;
	    daa[16*20+9]=  2.6344778384442731;
	    daa[16*20+10]= 1.0192004372506540;
	    daa[16*20+11]= 2.5513781312660280;
	    daa[16*20+12]= 3.3628488360462363;
	    daa[16*20+13]= 0.6882725908872254;
	    daa[16*20+14]= 1.9485376673137556;
	    daa[16*20+15]= 8.8479984061248178;
	    daa[17*20+0]=  0.5488578478106930;
	    daa[17*20+1]=  1.5170142153962840;
	    daa[17*20+2]=  0.1808525752605976;
	    daa[17*20+3]=  0.2496584188151770;
	    daa[17*20+4]=  1.6275179891253113;
	    daa[17*20+5]=  0.8959082681546182;
	    daa[17*20+6]=  0.4198391148111098;
	    daa[17*20+7]=  0.9349753595598769;
	    daa[17*20+8]=  0.6301954684360302;
	    daa[17*20+9]=  0.5604648274060783;
	    daa[17*20+10]= 1.5183114434679339;
	    daa[17*20+11]= 0.5851920879490173;
	    daa[17*20+12]= 1.4680478689711018;
	    daa[17*20+13]= 3.3448437239772266;
	    daa[17*20+14]= 0.4326058001438786;
	    daa[17*20+15]= 0.6791126595939816;
	    daa[17*20+16]= 0.4514203099376473;
	    daa[18*20+0]=  0.5411769916657778;
	    daa[18*20+1]=  0.8912614404565405;
	    daa[18*20+2]=  1.0894926581511342;
	    daa[18*20+3]=  0.7447620891784513;
	    daa[18*20+4]=  2.1579775140421025;
	    daa[18*20+5]=  0.9183596801412757;
	    daa[18*20+6]=  0.5818111331782764;
	    daa[18*20+7]=  0.3374467649724478;
	    daa[18*20+8]=  7.7587442309146040;
	    daa[18*20+9]=  0.8626796044156272;
	    daa[18*20+10]= 1.2452243224541324;
	    daa[18*20+11]= 0.7835447533710449;
	    daa[18*20+12]= 1.0899165770956820;
	    daa[18*20+13]= 10.384852333133459;
	    daa[18*20+14]= 0.4819109019647465;
	    daa[18*20+15]= 0.9547229305958682;
	    daa[18*20+16]= 0.8564314184691215;
	    daa[18*20+17]= 4.5377235790405388;
	    daa[19*20+0]=  4.6501894691803214;
	    daa[19*20+1]=  0.7807017855806767;
	    daa[19*20+2]=  0.4586061981719967;
	    daa[19*20+3]=  0.4594535241660911;
	    daa[19*20+4]=  2.2627456996290891;
	    daa[19*20+5]=  0.6366932501396869;
	    daa[19*20+6]=  0.8940572875547330;
	    daa[19*20+7]=  0.6193321034173915;
	    daa[19*20+8]=  0.5333220944030346;
	    daa[19*20+9]=  14.872933461519061;
	    daa[19*20+10]= 3.5458093276667237;
	    daa[19*20+11]= 0.7801080335991272;
	    daa[19*20+12]= 4.0584577156753401;
	    daa[19*20+13]= 1.7039730522675411;
	    daa[19*20+14]= 0.5985498912985666;
	    daa[19*20+15]= 0.9305232113028208;
	    daa[19*20+16]= 3.4242218450865543;
	    daa[19*20+17]= 0.5658969249032649;
	    daa[19*20+18]= 1.0000000000000000;
	    
	    f[0]=  0.0770764620135024;
	    f[1]=  0.0500819370772208;
	    f[2]=  0.0462377395993731;
	    f[3]=  0.0537929860758246;
	    f[4]=  0.0144533387583345;
	    f[5]=  0.0408923608974345;
	    f[6]=  0.0633579339160905;
	    f[7]=  0.0655672355884439;
	    f[8]=  0.0218802687005936;
	    f[9]=  0.0591969699027449;
	    f[10]= 0.0976461276528445;
	    f[11]= 0.0592079410822730;
	    f[12]= 0.0220695876653368;
	    f[13]= 0.0413508521834260;
	    f[14]= 0.0476871596856874;
	    f[15]= 0.0707295165111524;
	    f[16]= 0.0567759161524817;
	    f[17]= 0.0127019797647213;
	    f[18]= 0.0323746050281867;
	    f[19]= 0.0669190817443274;
	  }
	else if (prot_model == "BLOSUM62") 
	  {
	    daa[1*20+0]= 0.735790389698;  daa[2*20+0]= 0.485391055466;  daa[2*20+1]= 1.297446705134;  
	    daa[3*20+0]= 0.543161820899;  
	    daa[3*20+1]= 0.500964408555;  daa[3*20+2]= 3.180100048216;  daa[4*20+0]= 1.45999531047;   
	    daa[4*20+1]= 0.227826574209;  
	    daa[4*20+2]= 0.397358949897;  daa[4*20+3]= 0.240836614802;  daa[5*20+0]= 1.199705704602;  
	    daa[5*20+1]= 3.020833610064;  
	    daa[5*20+2]= 1.839216146992;  daa[5*20+3]= 1.190945703396;  daa[5*20+4]= 0.32980150463;   
	    daa[6*20+0]= 1.1709490428;    
	    daa[6*20+1]= 1.36057419042;   daa[6*20+2]= 1.24048850864;   daa[6*20+3]= 3.761625208368;  
	    daa[6*20+4]= 0.140748891814;  
	    daa[6*20+5]= 5.528919177928;  daa[7*20+0]= 1.95588357496;   daa[7*20+1]= 0.418763308518;  
	    daa[7*20+2]= 1.355872344485;  
	    daa[7*20+3]= 0.798473248968;  daa[7*20+4]= 0.418203192284;  daa[7*20+5]= 0.609846305383;  
	    daa[7*20+6]= 0.423579992176;  
	    daa[8*20+0]= 0.716241444998;  daa[8*20+1]= 1.456141166336;  daa[8*20+2]= 2.414501434208;  
	    daa[8*20+3]= 0.778142664022;  
	    daa[8*20+4]= 0.354058109831;  daa[8*20+5]= 2.43534113114;   daa[8*20+6]= 1.626891056982;  
	    daa[8*20+7]= 0.539859124954;  
	    daa[9*20+0]= 0.605899003687;  daa[9*20+1]= 0.232036445142;  daa[9*20+2]= 0.283017326278;  
	    daa[9*20+3]= 0.418555732462;  
	    daa[9*20+4]= 0.774894022794;  daa[9*20+5]= 0.236202451204;  daa[9*20+6]= 0.186848046932;  
	    daa[9*20+7]= 0.189296292376;  
	    daa[9*20+8]= 0.252718447885;  daa[10*20+0]= 0.800016530518; daa[10*20+1]= 0.622711669692; 
	    daa[10*20+2]= 0.211888159615; 
	    daa[10*20+3]= 0.218131577594; daa[10*20+4]= 0.831842640142; daa[10*20+5]= 0.580737093181; 
	    daa[10*20+6]= 0.372625175087; 
	    daa[10*20+7]= 0.217721159236; daa[10*20+8]= 0.348072209797; daa[10*20+9]= 3.890963773304; 
	    daa[11*20+0]= 1.295201266783; 
	    daa[11*20+1]= 5.411115141489; daa[11*20+2]= 1.593137043457; daa[11*20+3]= 1.032447924952; 
	    daa[11*20+4]= 0.285078800906; 
	    daa[11*20+5]= 3.945277674515; daa[11*20+6]= 2.802427151679; daa[11*20+7]= 0.752042440303; 
	    daa[11*20+8]= 1.022507035889; 
	    daa[11*20+9]= 0.406193586642; daa[11*20+10]= 0.445570274261;daa[12*20+0]= 1.253758266664; 
	    daa[12*20+1]= 0.983692987457; 
	    daa[12*20+2]= 0.648441278787; daa[12*20+3]= 0.222621897958; daa[12*20+4]= 0.76768882348;  
	    daa[12*20+5]= 2.494896077113; 
	    daa[12*20+6]= 0.55541539747;  daa[12*20+7]= 0.459436173579; daa[12*20+8]= 0.984311525359; 
	    daa[12*20+9]= 3.364797763104; 
	    daa[12*20+10]= 6.030559379572;daa[12*20+11]= 1.073061184332;daa[13*20+0]= 0.492964679748; 
	    daa[13*20+1]= 0.371644693209; 
	    daa[13*20+2]= 0.354861249223; daa[13*20+3]= 0.281730694207; daa[13*20+4]= 0.441337471187; 
	    daa[13*20+5]= 0.14435695975;  
	    daa[13*20+6]= 0.291409084165; daa[13*20+7]= 0.368166464453; daa[13*20+8]= 0.714533703928; 
	    daa[13*20+9]= 1.517359325954; 
	    daa[13*20+10]= 2.064839703237;daa[13*20+11]= 0.266924750511;daa[13*20+12]= 1.77385516883; 
	    daa[14*20+0]= 1.173275900924; 
	    daa[14*20+1]= 0.448133661718; daa[14*20+2]= 0.494887043702; daa[14*20+3]= 0.730628272998; 
	    daa[14*20+4]= 0.356008498769; 
	    daa[14*20+5]= 0.858570575674; daa[14*20+6]= 0.926563934846; daa[14*20+7]= 0.504086599527; daa[14*20+8]= 0.527007339151; 
	    daa[14*20+9]= 0.388355409206; daa[14*20+10]= 0.374555687471;daa[14*20+11]= 1.047383450722;daa[14*20+12]= 0.454123625103;
	    daa[14*20+13]= 0.233597909629;daa[15*20+0]= 4.325092687057; daa[15*20+1]= 1.12278310421;  daa[15*20+2]= 2.904101656456; 
	    daa[15*20+3]= 1.582754142065; daa[15*20+4]= 1.197188415094; daa[15*20+5]= 1.934870924596; daa[15*20+6]= 1.769893238937; 
	    daa[15*20+7]= 1.509326253224; daa[15*20+8]= 1.11702976291;  daa[15*20+9]= 0.35754441246;  daa[15*20+10]= 0.352969184527;
	    daa[15*20+11]= 1.752165917819;daa[15*20+12]= 0.918723415746;daa[15*20+13]= 0.540027644824;daa[15*20+14]= 1.169129577716;
	    daa[16*20+0]= 1.729178019485; daa[16*20+1]= 0.914665954563; daa[16*20+2]= 1.898173634533; daa[16*20+3]= 0.934187509431; 
	    daa[16*20+4]= 1.119831358516; daa[16*20+5]= 1.277480294596; daa[16*20+6]= 1.071097236007; daa[16*20+7]= 0.641436011405; 
	    daa[16*20+8]= 0.585407090225; daa[16*20+9]= 1.17909119726;  daa[16*20+10]= 0.915259857694;daa[16*20+11]= 1.303875200799;
	    daa[16*20+12]= 1.488548053722;daa[16*20+13]= 0.488206118793;daa[16*20+14]= 1.005451683149;daa[16*20+15]= 5.15155629227; 
	    daa[17*20+0]= 0.465839367725; daa[17*20+1]= 0.426382310122; daa[17*20+2]= 0.191482046247; daa[17*20+3]= 0.145345046279; 
	    daa[17*20+4]= 0.527664418872; daa[17*20+5]= 0.758653808642; daa[17*20+6]= 0.407635648938; daa[17*20+7]= 0.508358924638; 
	    daa[17*20+8]= 0.30124860078;  daa[17*20+9]= 0.34198578754;  daa[17*20+10]= 0.6914746346;  daa[17*20+11]= 0.332243040634;
	    daa[17*20+12]= 0.888101098152;daa[17*20+13]= 2.074324893497;daa[17*20+14]= 0.252214830027;daa[17*20+15]= 0.387925622098;
	    daa[17*20+16]= 0.513128126891;daa[18*20+0]= 0.718206697586; daa[18*20+1]= 0.720517441216; daa[18*20+2]= 0.538222519037; 
	    daa[18*20+3]= 0.261422208965; daa[18*20+4]= 0.470237733696; daa[18*20+5]= 0.95898974285;  daa[18*20+6]= 0.596719300346; 
	    daa[18*20+7]= 0.308055737035; daa[18*20+8]= 4.218953969389; daa[18*20+9]= 0.674617093228; daa[18*20+10]= 0.811245856323;
	    daa[18*20+11]= 0.7179934869;  daa[18*20+12]= 0.951682162246;daa[18*20+13]= 6.747260430801;daa[18*20+14]= 0.369405319355;
	    daa[18*20+15]= 0.796751520761;daa[18*20+16]= 0.801010243199;daa[18*20+17]= 4.054419006558;daa[19*20+0]= 2.187774522005; 
	    daa[19*20+1]= 0.438388343772; daa[19*20+2]= 0.312858797993; daa[19*20+3]= 0.258129289418; daa[19*20+4]= 1.116352478606; 
	    daa[19*20+5]= 0.530785790125; daa[19*20+6]= 0.524253846338; daa[19*20+7]= 0.25334079019;  daa[19*20+8]= 0.20155597175;  
	    daa[19*20+9]= 8.311839405458; daa[19*20+10]= 2.231405688913;daa[19*20+11]= 0.498138475304;daa[19*20+12]= 2.575850755315;
	    daa[19*20+13]= 0.838119610178;daa[19*20+14]= 0.496908410676;daa[19*20+15]= 0.561925457442;daa[19*20+16]= 2.253074051176;
	    daa[19*20+17]= 0.266508731426;daa[19*20+18]= 1;             
	    
	    f[0]= 0.074;                 f[1]= 0.052;                 f[2]= 0.045;                 f[3]= 0.054;                 
	    f[4]= 0.025;                 f[5]= 0.034;                 f[6]= 0.054;                 f[7]= 0.074;                 
	    f[8]= 0.026;                 f[9]= 0.068;                 f[10]= 0.099;                f[11]= 0.058;                
	    f[12]= 0.025;                f[13]= 0.047;                f[14]= 0.039;                f[15]= 0.057;                
	    f[16]= 0.051;                f[17]= 0.013;                f[18]= 0.032;                f[19]= 0.073;
	  }
	else if (prot_model == "MTMAM") 
	  {
	    daa[1*20+0]= 32;              daa[2*20+0]= 2;    daa[2*20+1]= 4;               daa[3*20+0]= 11;
	    daa[3*20+1]= 1e-6;            daa[3*20+2]= 864;  daa[4*20+0]= 1e-6;            daa[4*20+1]= 186;
	    daa[4*20+2]= 1e-6;            daa[4*20+3]= 1e-6; daa[5*20+0]= 1e-6;            daa[5*20+1]= 246;
	    daa[5*20+2]= 8;               daa[5*20+3]= 49;   daa[5*20+4]= 1e-6;            daa[6*20+0]= 1e-6;
	    daa[6*20+1]= 1e-6;            daa[6*20+2]= 1e-6; daa[6*20+3]= 569;             daa[6*20+4]= 1e-6;
	    daa[6*20+5]= 274;             daa[7*20+0]= 78;   daa[7*20+1]= 18;              daa[7*20+2]= 47;
	    daa[7*20+3]= 79;              daa[7*20+4]= 1e-6; daa[7*20+5]= 1e-6;            daa[7*20+6]= 22;
	    daa[8*20+0]= 8;               daa[8*20+1]= 232;  daa[8*20+2]= 458;             daa[8*20+3]= 11;
	    daa[8*20+4]= 305;             daa[8*20+5]= 550;  daa[8*20+6]= 22;              daa[8*20+7]= 1e-6;
	    daa[9*20+0]= 75;              daa[9*20+1]= 1e-6; daa[9*20+2]= 19;              daa[9*20+3]= 1e-6;
	    daa[9*20+4]= 41;              daa[9*20+5]= 1e-6; daa[9*20+6]= 1e-6;            daa[9*20+7]= 1e-6;
	    daa[9*20+8]= 1e-6;            daa[10*20+0]= 21;  daa[10*20+1]= 6;              daa[10*20+2]= 1e-6;
	    daa[10*20+3]= 1e-6;           daa[10*20+4]= 27;  daa[10*20+5]= 20;             daa[10*20+6]= 1e-6;
	    daa[10*20+7]= 1e-6;           daa[10*20+8]= 26;  daa[10*20+9]= 232;            daa[11*20+0]= 1e-6;
	    daa[11*20+1]= 50;             daa[11*20+2]= 408; daa[11*20+3]= 1e-6;           daa[11*20+4]= 1e-6;
	    daa[11*20+5]= 242;            daa[11*20+6]= 215; daa[11*20+7]= 1e-6;           daa[11*20+8]= 1e-6;
	    daa[11*20+9]= 6;              daa[11*20+10]= 4;  daa[12*20+0]= 76;             daa[12*20+1]= 1e-6;
	    daa[12*20+2]= 21;             daa[12*20+3]= 1e-6;daa[12*20+4]= 1e-6;           daa[12*20+5]= 22;
	    daa[12*20+6]= 1e-6;           daa[12*20+7]= 1e-6;daa[12*20+8]= 1e-6;           daa[12*20+9]= 378;
	    daa[12*20+10]= 609;           daa[12*20+11]= 59; daa[13*20+0]= 1e-6;           daa[13*20+1]= 1e-6;
	    daa[13*20+2]= 6;              daa[13*20+3]= 5;   daa[13*20+4]= 7;              daa[13*20+5]= 1e-6;
	    daa[13*20+6]= 1e-6;           daa[13*20+7]= 1e-6;daa[13*20+8]= 1e-6;           daa[13*20+9]= 57;
	    daa[13*20+10]= 246;           daa[13*20+11]= 1e-6;  daa[13*20+12]= 11;            daa[14*20+0]= 53;
	    daa[14*20+1]= 9;              daa[14*20+2]= 33;  daa[14*20+3]= 2;              daa[14*20+4]= 1e-6;
	    daa[14*20+5]= 51;             daa[14*20+6]= 1e-6;daa[14*20+7]= 1e-6;           daa[14*20+8]= 53;
	    daa[14*20+9]= 5;              daa[14*20+10]= 43; daa[14*20+11]= 18;            daa[14*20+12]= 1e-6;
	    daa[14*20+13]= 17;            daa[15*20+0]= 342; daa[15*20+1]= 3;              daa[15*20+2]= 446;
	    daa[15*20+3]= 16;             daa[15*20+4]= 347; daa[15*20+5]= 30;             daa[15*20+6]= 21;
	    daa[15*20+7]= 112;            daa[15*20+8]= 20;  daa[15*20+9]= 1e-6;           daa[15*20+10]= 74;
	    daa[15*20+11]= 65;            daa[15*20+12]= 47; daa[15*20+13]= 90;            daa[15*20+14]= 202;
	    daa[16*20+0]= 681;            daa[16*20+1]= 1e-6;daa[16*20+2]= 110;            daa[16*20+3]= 1e-6;
	    daa[16*20+4]= 114;            daa[16*20+5]= 1e-6;daa[16*20+6]= 4;              daa[16*20+7]= 1e-6;
	    daa[16*20+8]= 1;              daa[16*20+9]= 360; daa[16*20+10]= 34;            daa[16*20+11]= 50;
	    daa[16*20+12]= 691;           daa[16*20+13]= 8;  daa[16*20+14]= 78;            daa[16*20+15]= 614;
	    daa[17*20+0]= 5;              daa[17*20+1]= 16;  daa[17*20+2]= 6;              daa[17*20+3]= 1e-6;
	    daa[17*20+4]= 65;             daa[17*20+5]= 1e-6;daa[17*20+6]= 1e-6;           daa[17*20+7]= 1e-6;
	    daa[17*20+8]= 1e-6;           daa[17*20+9]= 1e-6;daa[17*20+10]= 12;            daa[17*20+11]= 1e-6;
	    daa[17*20+12]= 13;            daa[17*20+13]= 1e-6;  daa[17*20+14]= 7;             daa[17*20+15]= 17;
	    daa[17*20+16]= 1e-6;          daa[18*20+0]= 1e-6;daa[18*20+1]= 1e-6;           daa[18*20+2]= 156;
	    daa[18*20+3]= 1e-6;           daa[18*20+4]= 530; daa[18*20+5]= 54;             daa[18*20+6]= 1e-6;
	    daa[18*20+7]= 1;              daa[18*20+8]= 1525;daa[18*20+9]= 16;             daa[18*20+10]= 25;
	    daa[18*20+11]= 67;            daa[18*20+12]= 1e-6;  daa[18*20+13]= 682;           daa[18*20+14]= 8;
	    daa[18*20+15]= 107;           daa[18*20+16]= 1e-6;  daa[18*20+17]= 14;            daa[19*20+0]= 398;
	    daa[19*20+1]= 1e-6;           daa[19*20+2]= 1e-6;daa[19*20+3]= 10;             daa[19*20+4]= 1e-6;
	    daa[19*20+5]= 33;             daa[19*20+6]= 20;  daa[19*20+7]= 5;              daa[19*20+8]= 1e-6;
	    daa[19*20+9]= 2220;           daa[19*20+10]= 100;daa[19*20+11]= 1e-6;          daa[19*20+12]= 832;
	    daa[19*20+13]= 6;             daa[19*20+14]= 1e-6;  daa[19*20+15]= 1e-6;          daa[19*20+16]= 237;
	    daa[19*20+17]= 1e-6;          daa[19*20+18]= 1e-6;
	    
	    f[0]= 0.06920;  f[1]=  0.01840;  f[2]= 0.04000;  f[3]= 0.018600;
	    f[4]= 0.00650;  f[5]=  0.02380;  f[6]= 0.02360;  f[7]= 0.055700;
	    f[8]= 0.02770;  f[9]=  0.09050;  f[10]=0.16750;  f[11]= 0.02210;
	    f[12]=0.05610;  f[13]= 0.06110;  f[14]=0.05360;  f[15]= 0.07250;
	    f[16]=0.08700;  f[17]= 0.02930;  f[18]=0.03400;  f[19]= 0.04280;
	  }
	else if (prot_model == "LG") 
	  {
	    daa[1*20+0] = 0.425093;

	    daa[2*20+0] = 0.276818; daa[2*20+1] = 0.751878;

	    daa[3*20+0] = 0.395144; daa[3*20+1] = 0.123954; daa[3*20+2] = 5.076149;
	    
	    daa[4*20+0] = 2.489084; daa[4*20+1] = 0.534551; daa[4*20+2] = 0.528768; daa[4*20+3] = 0.062556;
								 
	    daa[5*20+0] = 0.969894; daa[5*20+1] = 2.807908; daa[5*20+2] = 1.695752; daa[5*20+3] = 0.523386; daa[5*20+4] = 0.084808;

	    daa[6*20+0] = 1.038545; daa[6*20+1] = 0.363970; daa[6*20+2] = 0.541712; daa[6*20+3] = 5.243870; daa[6*20+4] = 0.003499; daa[6*20+5] = 4.128591;

	    daa[7*20+0] = 2.066040; daa[7*20+1] = 0.390192; daa[7*20+2] = 1.437645; daa[7*20+3] = 0.844926; daa[7*20+4] = 0.569265; daa[7*20+5] = 0.267959; daa[7*20+6] = 0.348847;
 
	    daa[8*20+0] = 0.358858; daa[8*20+1] = 2.426601; daa[8*20+2] = 4.509238; daa[8*20+3] = 0.927114; daa[8*20+4] = 0.640543; daa[8*20+5] = 4.813505; daa[8*20+6] = 0.423881; 
	    daa[8*20+7] = 0.311484;

	    daa[9*20+0] = 0.149830; daa[9*20+1] = 0.126991; daa[9*20+2] = 0.191503; daa[9*20+3] = 0.010690; daa[9*20+4] = 0.320627; daa[9*20+5] = 0.072854; daa[9*20+6] = 0.044265; 
	    daa[9*20+7] = 0.008705; daa[9*20+8] = 0.108882; 

	    daa[10*20+0] = 0.395337; daa[10*20+1] = 0.301848; daa[10*20+2] = 0.068427; daa[10*20+3] = 0.015076; daa[10*20+4] = 0.594007; daa[10*20+5] = 0.582457; daa[10*20+6] = 0.069673; 
	    daa[10*20+7] = 0.044261; daa[10*20+8] = 0.366317; daa[10*20+9] = 4.145067 ;

	    daa[11*20+0] = 0.536518; daa[11*20+1] = 6.326067; daa[11*20+2] = 2.145078; daa[11*20+3] = 0.282959; daa[11*20+4] = 0.013266; daa[11*20+5] = 3.234294; daa[11*20+6] = 1.807177; 
	    daa[11*20+7] = 0.296636; daa[11*20+8] = 0.697264; daa[11*20+9] = 0.159069; daa[11*20+10] = 0.137500;


	    daa[12*20+0] = 1.124035; daa[12*20+1] = 0.484133; daa[12*20+2] = 0.371004; daa[12*20+3] = 0.025548; daa[12*20+4] = 0.893680; daa[12*20+5] = 1.672569; daa[12*20+6] = 0.173735; 
	    daa[12*20+7] = 0.139538; daa[12*20+8] = 0.442472; daa[12*20+9] = 4.273607; daa[12*20+10] = 6.312358; daa[12*20+11] = 0.656604;

	    daa[13*20+0] = 0.253701; daa[13*20+1] = 0.052722;daa[13*20+2] = 0.089525; daa[13*20+3] = 0.017416; daa[13*20+4] = 1.105251; daa[13*20+5] = 0.035855; daa[13*20+6] = 0.018811; 
	    daa[13*20+7] = 0.089586; daa[13*20+8] = 0.682139; daa[13*20+9] = 1.112727; daa[13*20+10] = 2.592692; daa[13*20+11] = 0.023918; daa[13*20+12] = 1.798853;

	    daa[14*20+0] = 1.177651; daa[14*20+1] = 0.332533;daa[14*20+2] = 0.161787; daa[14*20+3] = 0.394456; daa[14*20+4] = 0.075382; daa[14*20+5] = 0.624294; daa[14*20+6] = 0.419409; 
	    daa[14*20+7] = 0.196961; daa[14*20+8] = 0.508851; daa[14*20+9] = 0.078281; daa[14*20+10] = 0.249060; daa[14*20+11] = 0.390322; daa[14*20+12] = 0.099849; 
	    daa[14*20+13] = 0.094464;
 
	    daa[15*20+0] = 4.727182; daa[15*20+1] = 0.858151;daa[15*20+2] = 4.008358; daa[15*20+3] = 1.240275; daa[15*20+4] = 2.784478; daa[15*20+5] = 1.223828; daa[15*20+6] = 0.611973; 
	    daa[15*20+7] = 1.739990; daa[15*20+8] = 0.990012; daa[15*20+9] = 0.064105; daa[15*20+10] = 0.182287; daa[15*20+11] = 0.748683; daa[15*20+12] = 0.346960; 
	    daa[15*20+13] = 0.361819; daa[15*20+14] = 1.338132;
 
	    daa[16*20+0] = 2.139501; daa[16*20+1] = 0.578987;daa[16*20+2] = 2.000679; daa[16*20+3] = 0.425860; daa[16*20+4] = 1.143480; daa[16*20+5] = 1.080136; daa[16*20+6] = 0.604545; 
	    daa[16*20+7] = 0.129836; daa[16*20+8] = 0.584262; daa[16*20+9] = 1.033739; daa[16*20+10] = 0.302936; daa[16*20+11] = 1.136863; daa[16*20+12] = 2.020366; 
	    daa[16*20+13] = 0.165001; daa[16*20+14] = 0.571468; daa[16*20+15] = 6.472279;

	    daa[17*20+0] = 0.180717; daa[17*20+1] = 0.593607;daa[17*20+2] = 0.045376; daa[17*20+3] = 0.029890; daa[17*20+4] = 0.670128; daa[17*20+5] = 0.236199; daa[17*20+6] = 0.077852; 
	    daa[17*20+7] = 0.268491; daa[17*20+8] = 0.597054; daa[17*20+9] = 0.111660; daa[17*20+10] = 0.619632; daa[17*20+11] = 0.049906; daa[17*20+12] = 0.696175; 
	    daa[17*20+13] = 2.457121; daa[17*20+14] = 0.095131; daa[17*20+15] = 0.248862; daa[17*20+16] = 0.140825;

	    daa[18*20+0] = 0.218959; daa[18*20+1] = 0.314440;daa[18*20+2] = 0.612025; daa[18*20+3] = 0.135107; daa[18*20+4] = 1.165532; daa[18*20+5] = 0.257336; daa[18*20+6] = 0.120037; 
	    daa[18*20+7] = 0.054679; daa[18*20+8] = 5.306834; daa[18*20+9] = 0.232523; daa[18*20+10] = 0.299648; daa[18*20+11] = 0.131932; daa[18*20+12] = 0.481306; 
	    daa[18*20+13] = 7.803902; daa[18*20+14] = 0.089613; daa[18*20+15] = 0.400547; daa[18*20+16] = 0.245841; daa[18*20+17] = 3.151815;

	    daa[19*20+0] = 2.547870; daa[19*20+1] = 0.170887;daa[19*20+2] = 0.083688; daa[19*20+3] = 0.037967; daa[19*20+4] = 1.959291; daa[19*20+5] = 0.210332; daa[19*20+6] = 0.245034; 
	    daa[19*20+7] = 0.076701; daa[19*20+8] = 0.119013; daa[19*20+9] = 10.649107; daa[19*20+10] = 1.702745; daa[19*20+11] = 0.185202; daa[19*20+12] = 1.898718; 
	    daa[19*20+13] = 0.654683; daa[19*20+14] = 0.296501; daa[19*20+15] = 0.098369; daa[19*20+16] = 2.188158; daa[19*20+17] = 0.189510; daa[19*20+18] = 0.249313;
	    
/*	same problem here
 * 	    f[0] = 0.07906;
	    f[1] = 0.05594; 
	    f[2] = 0.04198; 
	    f[3] = 0.05305; 
	    f[4] = 0.01294; 
	    f[5] = 0.04077; 
	    f[6] = 0.07158; 
	    f[7] = 0.05734; 
	    f[8] = 0.02235; 
	    f[9] = 0.06216; 
	    f[10] = 0.09908; 
	    f[11] = 0.06460; 
	    f[12] = 0.02295; 
	    f[13] = 0.04230; 
	    f[14] = 0.04404; 
	    f[15] = 0.06120; 
	    f[16] = 0.05329; 
	    f[17] = 0.01207; 
	    f[18] = 0.03415; 
	    f[19] = 0.06915;*/
	    // NOTE: originally f[19]=0.069147 but frequencies do not sum up to 1
	    f[0] = 0.079066; f[1] = 0.055941; f[2] = 0.041977; f[3] = 0.053052;
	    f[4] = 0.012937; f[5] = 0.040767; f[6] = 0.071586; f[7] = 0.057337;
	    f[8] = 0.022355; f[9] = 0.062157; f[10] = 0.099081; f[11] = 0.064600;
	    f[12] = 0.022951; f[13] = 0.042302; f[14] = 0.044040; f[15] = 0.061197;
	    f[16] = 0.053287; f[17] = 0.012066; f[18] = 0.034155; f[19] = 0.069146;

	  }	  
	else if (prot_model == "MTART") 
	  {
	   

	    daa[1*20+0]=   0.2;
	    daa[2*20+0]=   0.2;
           daa[2*20+1]=   0.2;
           daa[3*20+0]=   1;
           daa[3*20+1]=   4;
           daa[3*20+2]=   500;
           daa[4*20+0]=   254;
           daa[4*20+1]=   36;
           daa[4*20+2]=   98;
           daa[4*20+3]=   11;
           daa[5*20+0]=   0.2;
           daa[5*20+1]=   154;
           daa[5*20+2]=   262;
           daa[5*20+3]=   0.2;
           daa[5*20+4]=   0.2;
           daa[6*20+0]=   0.2;
           daa[6*20+1]=   0.2;
           daa[6*20+2]=   183;
           daa[6*20+3]=   862;
           daa[6*20+4]=   0.2;
           daa[6*20+5]=   262;
           daa[7*20+0]=   200;
           daa[7*20+1]=   0.2;
           daa[7*20+2]=   121;
           daa[7*20+3]=   12;
           daa[7*20+4]=   81;
           daa[7*20+5]=   3;
           daa[7*20+6]=   44;
           daa[8*20+0]=   0.2;
           daa[8*20+1]=   41;
           daa[8*20+2]=   180;
           daa[8*20+3]=   0.2;
           daa[8*20+4]=   12;
           daa[8*20+5]=   314;
           daa[8*20+6]=   15;
           daa[8*20+7]=   0.2;
           daa[9*20+0]=   26;
           daa[9*20+1]=   2;
           daa[9*20+2]=   21;
           daa[9*20+3]=   7;
           daa[9*20+4]=   63;
           daa[9*20+5]=   11;
           daa[9*20+6]=   7;
           daa[9*20+7]=   3;
           daa[9*20+8]=   0.2;
           daa[10*20+0]=  4;
           daa[10*20+1]=  2;
           daa[10*20+2]=  13;
           daa[10*20+3]=  1;
           daa[10*20+4]=  79;
           daa[10*20+5]=  16;
           daa[10*20+6]=  2;
           daa[10*20+7]=  1;
           daa[10*20+8]=  6;
           daa[10*20+9]=  515;
           daa[11*20+0]=  0.2;
           daa[11*20+1]=  209;
           daa[11*20+2]=  467;
           daa[11*20+3]=  2;
           daa[11*20+4]=  0.2;
           daa[11*20+5]=  349;
           daa[11*20+6]=  106;
           daa[11*20+7]=  0.2;
           daa[11*20+8]=  0.2;
           daa[11*20+9]=  3;
           daa[11*20+10]= 4;
           daa[12*20+0]=  121;
           daa[12*20+1]=  5;
           daa[12*20+2]=  79;
           daa[12*20+3]=  0.2;
           daa[12*20+4]=  312;
           daa[12*20+5]=  67;
           daa[12*20+6]=  0.2;
           daa[12*20+7]=  56;
           daa[12*20+8]=  0.2;
           daa[12*20+9]=  515;
           daa[12*20+10]= 885;
           daa[12*20+11]= 106;
           daa[13*20+0]=  13;
           daa[13*20+1]=  5;
           daa[13*20+2]=  20;
           daa[13*20+3]=  0.2;
           daa[13*20+4]=  184;
           daa[13*20+5]=  0.2;
           daa[13*20+6]=  0.2;
           daa[13*20+7]=  1;
           daa[13*20+8]=  14;
           daa[13*20+9]=  118;
           daa[13*20+10]= 263;
           daa[13*20+11]= 11;
           daa[13*20+12]= 322;
           daa[14*20+0]=  49;
           daa[14*20+1]=  0.2;
           daa[14*20+2]=  17;
           daa[14*20+3]=  0.2;
           daa[14*20+4]=  0.2;
           daa[14*20+5]=  39;
           daa[14*20+6]=  8;
           daa[14*20+7]=  0.2;
           daa[14*20+8]=  1;
           daa[14*20+9]=  0.2;
           daa[14*20+10]= 12;
           daa[14*20+11]= 17;
           daa[14*20+12]= 5;
           daa[14*20+13]= 15;
           daa[15*20+0]=  673;
           daa[15*20+1]=  3;
           daa[15*20+2]=  398;
           daa[15*20+3]=  44;
           daa[15*20+4]=  664;
           daa[15*20+5]=  52;
           daa[15*20+6]=  31;
           daa[15*20+7]=  226;
           daa[15*20+8]=  11;
           daa[15*20+9]=  7;
           daa[15*20+10]= 8;
           daa[15*20+11]= 144;
           daa[15*20+12]= 112;
           daa[15*20+13]= 36;
           daa[15*20+14]= 87;
           daa[16*20+0]=  244;
           daa[16*20+1]=  0.2;
           daa[16*20+2]=  166;
           daa[16*20+3]=  0.2;
           daa[16*20+4]=  183;
           daa[16*20+5]=  44;
           daa[16*20+6]=  43;
           daa[16*20+7]=  0.2;
           daa[16*20+8]=  19;
           daa[16*20+9]=  204;
           daa[16*20+10]= 48;
           daa[16*20+11]= 70;
           daa[16*20+12]= 289;
           daa[16*20+13]= 14;
           daa[16*20+14]= 47;
           daa[16*20+15]= 660;
           daa[17*20+0]=  0.2;
           daa[17*20+1]=  0.2;
           daa[17*20+2]=  8;
           daa[17*20+3]=  0.2;
           daa[17*20+4]=  22;
           daa[17*20+5]=  7;
           daa[17*20+6]=  11;
           daa[17*20+7]=  2;
           daa[17*20+8]=  0.2;
           daa[17*20+9]=  0.2;
           daa[17*20+10]= 21;
           daa[17*20+11]= 16;
           daa[17*20+12]= 71;
           daa[17*20+13]= 54;
           daa[17*20+14]= 0.2;
           daa[17*20+15]= 2;
           daa[17*20+16]= 0.2;
           daa[18*20+0]=  1;
           daa[18*20+1]=  4;
           daa[18*20+2]=  251;
           daa[18*20+3]=  0.2;
           daa[18*20+4]=  72;
           daa[18*20+5]=  87;
           daa[18*20+6]=  8;
           daa[18*20+7]=  9;
           daa[18*20+8]=  191;
           daa[18*20+9]=  12;
           daa[18*20+10]= 20;
           daa[18*20+11]= 117;
           daa[18*20+12]= 71;
           daa[18*20+13]= 792;
           daa[18*20+14]= 18;
           daa[18*20+15]= 30;
           daa[18*20+16]= 46;
           daa[18*20+17]= 38;
           daa[19*20+0]=  340;
           daa[19*20+1]=  0.2;
           daa[19*20+2]=  23;
           daa[19*20+3]=  0.2;
           daa[19*20+4]=  350;
           daa[19*20+5]=  0.2;
           daa[19*20+6]=  14;
           daa[19*20+7]=  3;
           daa[19*20+8]=  0.2;
           daa[19*20+9]=  1855;
           daa[19*20+10]= 85;
           daa[19*20+11]= 26;
           daa[19*20+12]= 281;
           daa[19*20+13]= 52;
           daa[19*20+14]= 32;
           daa[19*20+15]= 61;
           daa[19*20+16]= 544;
           daa[19*20+17]= 0.2;
           daa[19*20+18]= 2;
           
           f[0]=  0.054116;
           f[1]=  0.018227;
           f[2]=  0.039903;
           f[3]=  0.020160;
           f[4]=  0.009709;
           f[5]=  0.018781;
           f[6]=  0.024289;
           f[7]=  0.068183;
           f[8]=  0.024518;
           f[9]=  0.092638;
           f[10]= 0.148658;
           f[11]= 0.021718;
           f[12]= 0.061453;
           f[13]= 0.088668;
           f[14]= 0.041826;
           f[15]= 0.091030;
           f[16]= 0.049194;
           f[17]= 0.029786;
           f[18]= 0.039443;
           f[19]= 0.057700;
	  }
	else if (prot_model == "MTZOA") 
	  {
           daa[1*20+0]=   3.3;
           daa[2*20+0]=   1.7;
           daa[2*20+1]=   33.6;
           daa[3*20+0]=   16.1;
           daa[3*20+1]=   3.2;
           daa[3*20+2]=   617.0;
           daa[4*20+0]=   272.5;
           daa[4*20+1]=   61.1;
           daa[4*20+2]=   94.6;
           daa[4*20+3]=   9.5;
           daa[5*20+0]=   7.3;
           daa[5*20+1]=   231.0;
           daa[5*20+2]=   190.3;
           daa[5*20+3]=   19.3;
           daa[5*20+4]=   49.1;
           daa[6*20+0]=   17.1;
           daa[6*20+1]=   6.4;
           daa[6*20+2]=   174.0;
           daa[6*20+3]=   883.6;
           daa[6*20+4]=   3.4;
           daa[6*20+5]=   349.4;
           daa[7*20+0]=   289.3;
           daa[7*20+1]=   7.2;
           daa[7*20+2]=   99.3;
           daa[7*20+3]=   26.0;
           daa[7*20+4]=   82.4;
           daa[7*20+5]=   8.9;
           daa[7*20+6]=   43.1;
           daa[8*20+0]=   2.3;
           daa[8*20+1]=   61.7;
           daa[8*20+2]=   228.9;
           daa[8*20+3]=   55.6;
           daa[8*20+4]=   37.5;
           daa[8*20+5]=   421.8;
           daa[8*20+6]=   14.9;
           daa[8*20+7]=   7.4;
           daa[9*20+0]=   33.2;
           daa[9*20+1]=   0.2;
           daa[9*20+2]=   24.3;
           daa[9*20+3]=   1.5;
           daa[9*20+4]=   48.8;
           daa[9*20+5]=   0.2;
           daa[9*20+6]=   7.3;
           daa[9*20+7]=   3.4;
           daa[9*20+8]=   1.6;
           daa[10*20+0]=  15.6;
           daa[10*20+1]=  4.1;
           daa[10*20+2]=  7.9;
           daa[10*20+3]=  0.5;
           daa[10*20+4]=  59.7;
           daa[10*20+5]=  23.0;
           daa[10*20+6]=  1.0;
           daa[10*20+7]=  3.5;
           daa[10*20+8]=  6.6;
           daa[10*20+9]=  425.2;
           daa[11*20+0]=  0.2;
           daa[11*20+1]=  292.3;
           daa[11*20+2]=  413.4;
           daa[11*20+3]=  0.2;
           daa[11*20+4]=  0.2;
           daa[11*20+5]=  334.0;
           daa[11*20+6]=  163.2;
           daa[11*20+7]=  10.1;
           daa[11*20+8]=  23.9;
           daa[11*20+9]=  8.4;
           daa[11*20+10]= 6.7;
           daa[12*20+0]=  136.5;
           daa[12*20+1]=  3.8;
           daa[12*20+2]=  73.7;
           daa[12*20+3]=  0.2;
           daa[12*20+4]=  264.8;
           daa[12*20+5]=  83.9;
           daa[12*20+6]=  0.2;
           daa[12*20+7]=  52.2;
           daa[12*20+8]=  7.1;
           daa[12*20+9]=  449.7;
           daa[12*20+10]= 636.3;
           daa[12*20+11]= 83.0;
           daa[13*20+0]=  26.5;
           daa[13*20+1]=  0.2;
           daa[13*20+2]=  12.9;
           daa[13*20+3]=  2.0;
           daa[13*20+4]=  167.8;
           daa[13*20+5]=  9.5;
           daa[13*20+6]=  0.2;
           daa[13*20+7]=  5.8;
           daa[13*20+8]=  13.1;
           daa[13*20+9]=  90.3;
           daa[13*20+10]= 234.2;
           daa[13*20+11]= 16.3;
           daa[13*20+12]= 215.6;
           daa[14*20+0]=  61.8;
           daa[14*20+1]=  7.5;
           daa[14*20+2]=  22.6;
           daa[14*20+3]=  0.2;
           daa[14*20+4]=  8.1;
           daa[14*20+5]=  52.2;
           daa[14*20+6]=  20.6;
           daa[14*20+7]=  1.3;
           daa[14*20+8]=  15.6;
           daa[14*20+9]=  2.6;
           daa[14*20+10]= 11.4;
           daa[14*20+11]= 24.3;
           daa[14*20+12]= 5.4;
           daa[14*20+13]= 10.5;
           daa[15*20+0]=  644.9;
           daa[15*20+1]=  11.8;
           daa[15*20+2]=  420.2;
           daa[15*20+3]=  51.4;
           daa[15*20+4]=  656.3;
           daa[15*20+5]=  96.4;
           daa[15*20+6]=  38.4;
           daa[15*20+7]=  257.1;
           daa[15*20+8]=  23.1;
           daa[15*20+9]=  7.2;
           daa[15*20+10]= 15.2;
           daa[15*20+11]= 144.9;
           daa[15*20+12]= 95.3;
           daa[15*20+13]= 32.2;
           daa[15*20+14]= 79.7;
           daa[16*20+0]=  378.1;
           daa[16*20+1]=  3.2;
           daa[16*20+2]=  184.6;
           daa[16*20+3]=  2.3;
           daa[16*20+4]=  199.0;
           daa[16*20+5]=  39.4;
           daa[16*20+6]=  34.5;
           daa[16*20+7]=  5.2;
           daa[16*20+8]=  19.4;
           daa[16*20+9]=  222.3;
           daa[16*20+10]= 50.0;
           daa[16*20+11]= 75.5;
           daa[16*20+12]= 305.1;
           daa[16*20+13]= 19.3;
           daa[16*20+14]= 56.9;
           daa[16*20+15]= 666.3;
           daa[17*20+0]=  3.1;
           daa[17*20+1]=  16.9;
           daa[17*20+2]=  6.4;
           daa[17*20+3]=  0.2;
           daa[17*20+4]=  36.1;
           daa[17*20+5]=  6.1;
           daa[17*20+6]=  3.5;
           daa[17*20+7]=  12.3;
           daa[17*20+8]=  4.5;
           daa[17*20+9]=  9.7;
           daa[17*20+10]= 27.2;
           daa[17*20+11]= 6.6;
           daa[17*20+12]= 48.7;
           daa[17*20+13]= 58.2;
           daa[17*20+14]= 1.3;
           daa[17*20+15]= 10.3;
           daa[17*20+16]= 3.6;
           daa[18*20+0]=  2.1;
           daa[18*20+1]=  13.8;
           daa[18*20+2]=  141.6;
           daa[18*20+3]=  13.9;
           daa[18*20+4]=  76.7;
           daa[18*20+5]=  52.3;
           daa[18*20+6]=  10.0;
           daa[18*20+7]=  4.3;
           daa[18*20+8]=  266.5;
           daa[18*20+9]=  13.1;
           daa[18*20+10]= 5.7;
           daa[18*20+11]= 45.0;
           daa[18*20+12]= 41.4;
           daa[18*20+13]= 590.5;
           daa[18*20+14]= 4.2;
           daa[18*20+15]= 29.7;
           daa[18*20+16]= 29.0;
           daa[18*20+17]= 79.8;
           daa[19*20+0]=  321.9;
           daa[19*20+1]=  5.1;
           daa[19*20+2]=  7.1;
           daa[19*20+3]=  3.7;
           daa[19*20+4]=  243.8;
           daa[19*20+5]=  9.0;
           daa[19*20+6]=  16.3;
           daa[19*20+7]=  23.7;
           daa[19*20+8]=  0.3;
           daa[19*20+9]=  1710.6;
           daa[19*20+10]= 126.1;
           daa[19*20+11]= 11.1;
           daa[19*20+12]= 279.6;
           daa[19*20+13]= 59.6;
           daa[19*20+14]= 17.9;
           daa[19*20+15]= 49.5;
           daa[19*20+16]= 396.4;
           daa[19*20+17]= 13.7;
           daa[19*20+18]= 15.6;
           
           f[0]=  0.069;
           f[1]=  0.021;
           f[2]=  0.030;
           f[3]=  0.020;
           f[4]=  0.010;
           f[5]=  0.019;
           f[6]=  0.025;
           f[7]=  0.072;
           f[8]=  0.027;
           f[9]=  0.085;
           f[10]= 0.157;
           f[11]= 0.019;
           f[12]= 0.051;
           f[13]= 0.082;
           f[14]= 0.045;
           f[15]= 0.081;
           f[16]= 0.056;
           f[17]= 0.028;
           f[18]= 0.037;
           f[19]= 0.066;
	  }
	else if (prot_model == "PMB") 
	  {
           daa[1*20+0]=   0.674995699;
           daa[2*20+0]=   0.589645178;
           daa[2*20+1]=   1.189067034;
           daa[3*20+0]=   0.462499504;
           daa[3*20+1]=   0.605460903;
           daa[3*20+2]=   3.573373315;
           daa[4*20+0]=   1.065445546;
           daa[4*20+1]=   0.31444833;
           daa[4*20+2]=   0.589852457;
           daa[4*20+3]=   0.246951424;
           daa[5*20+0]=   1.111766964;
           daa[5*20+1]=   2.967840934;
           daa[5*20+2]=   2.299755865;
           daa[5*20+3]=   1.686058219;
           daa[5*20+4]=   0.245163782;
           daa[6*20+0]=   1.046334652;
           daa[6*20+1]=   1.201770702;
           daa[6*20+2]=   1.277836748;
           daa[6*20+3]=   4.399995525;
           daa[6*20+4]=   0.091071867;
           daa[6*20+5]=   4.15967899;
           daa[7*20+0]=   1.587964372;
           daa[7*20+1]=   0.523770553;
           daa[7*20+2]=   1.374854049;
           daa[7*20+3]=   0.734992057;
           daa[7*20+4]=   0.31706632;
           daa[7*20+5]=   0.596789898;
           daa[7*20+6]=   0.463812837;
           daa[8*20+0]=   0.580830874;
           daa[8*20+1]=   1.457127446;
           daa[8*20+2]=   2.283037894;
           daa[8*20+3]=   0.839348444;
           daa[8*20+4]=   0.411543728;
           daa[8*20+5]=   1.812173605;
           daa[8*20+6]=   0.877842609;
           daa[8*20+7]=   0.476331437;
           daa[9*20+0]=   0.464590585;
           daa[9*20+1]=   0.35964586;
           daa[9*20+2]=   0.426069419;
           daa[9*20+3]=   0.266775558;
           daa[9*20+4]=   0.417547309;
           daa[9*20+5]=   0.315256838;
           daa[9*20+6]=   0.30421529;
           daa[9*20+7]=   0.180198883;
           daa[9*20+8]=   0.285186418;
           daa[10*20+0]=  0.804404505;
           daa[10*20+1]=  0.520701585;
           daa[10*20+2]=  0.41009447;
           daa[10*20+3]=  0.269124919;
           daa[10*20+4]=  0.450795211;
           daa[10*20+5]=  0.625792937;
           daa[10*20+6]=  0.32078471;
           daa[10*20+7]=  0.259854426;
           daa[10*20+8]=  0.363981358;
           daa[10*20+9]=  4.162454693;
           daa[11*20+0]=  0.831998835;
           daa[11*20+1]=  4.956476453;
           daa[11*20+2]=  2.037575629;
           daa[11*20+3]=  1.114178954;
           daa[11*20+4]=  0.274163536;
           daa[11*20+5]=  3.521346591;
           daa[11*20+6]=  2.415974716;
           daa[11*20+7]=  0.581001076;
           daa[11*20+8]=  0.985885486;
           daa[11*20+9]=  0.374784947;
           daa[11*20+10]= 0.498011337;
           daa[12*20+0]=  1.546725076;
           daa[12*20+1]=  0.81346254;
           daa[12*20+2]=  0.737846301;
           daa[12*20+3]=  0.341932741;
           daa[12*20+4]=  0.618614612;
           daa[12*20+5]=  2.067388546;
           daa[12*20+6]=  0.531773639;
           daa[12*20+7]=  0.465349326;
           daa[12*20+8]=  0.380925433;
           daa[12*20+9]=  3.65807012;
           daa[12*20+10]= 5.002338375;
           daa[12*20+11]= 0.661095832;
           daa[13*20+0]=  0.546169219;
           daa[13*20+1]=  0.303437244;
           daa[13*20+2]=  0.425193716;
           daa[13*20+3]=  0.219005213;
           daa[13*20+4]=  0.669206193;
           daa[13*20+5]=  0.406042546;
           daa[13*20+6]=  0.224154698;
           daa[13*20+7]=  0.35402891;
           daa[13*20+8]=  0.576231691;
           daa[13*20+9]=  1.495264661;
           daa[13*20+10]= 2.392638293;
           daa[13*20+11]= 0.269496317;
           daa[13*20+12]= 2.306919847;
           daa[14*20+0]=  1.241586045;
           daa[14*20+1]=  0.65577338;
           daa[14*20+2]=  0.711495595;
           daa[14*20+3]=  0.775624818;
           daa[14*20+4]=  0.198679914;
           daa[14*20+5]=  0.850116543;
           daa[14*20+6]=  0.794584081;
           daa[14*20+7]=  0.588254139;
           daa[14*20+8]=  0.456058589;
           daa[14*20+9]=  0.366232942;
           daa[14*20+10]= 0.430073179;
           daa[14*20+11]= 1.036079005;
           daa[14*20+12]= 0.337502282;
           daa[14*20+13]= 0.481144863;
           daa[15*20+0]=  3.452308792;
           daa[15*20+1]=  0.910144334;
           daa[15*20+2]=  2.572577221;
           daa[15*20+3]=  1.440896785;
           daa[15*20+4]=  0.99870098;
           daa[15*20+5]=  1.348272505;
           daa[15*20+6]=  1.205509425;
           daa[15*20+7]=  1.402122097;
           daa[15*20+8]=  0.799966711;
           daa[15*20+9]=  0.530641901;
           daa[15*20+10]= 0.402471997;
           daa[15*20+11]= 1.234648153;
           daa[15*20+12]= 0.945453716;
           daa[15*20+13]= 0.613230817;
           daa[15*20+14]= 1.217683028;
           daa[16*20+0]=  1.751412803;
           daa[16*20+1]=  0.89517149;
           daa[16*20+2]=  1.823161023;
           daa[16*20+3]=  0.994227284;
           daa[16*20+4]=  0.847312432;
           daa[16*20+5]=  1.320626678;
           daa[16*20+6]=  0.949599791;
           daa[16*20+7]=  0.542185658;
           daa[16*20+8]=  0.83039281;
           daa[16*20+9]=  1.114132523;
           daa[16*20+10]= 0.779827336;
           daa[16*20+11]= 1.290709079;
           daa[16*20+12]= 1.551488041;
           daa[16*20+13]= 0.718895136;
           daa[16*20+14]= 0.780913179;
           daa[16*20+15]= 4.448982584;
           daa[17*20+0]=  0.35011051;
           daa[17*20+1]=  0.618778365;
           daa[17*20+2]=  0.422407388;
           daa[17*20+3]=  0.362495245;
           daa[17*20+4]=  0.445669347;
           daa[17*20+5]=  0.72038474;
           daa[17*20+6]=  0.261258229;
           daa[17*20+7]=  0.37874827;
           daa[17*20+8]=  0.72436751;
           daa[17*20+9]=  0.516260502;
           daa[17*20+10]= 0.794797115;
           daa[17*20+11]= 0.43340962;
           daa[17*20+12]= 0.768395107;
           daa[17*20+13]= 3.29519344;
           daa[17*20+14]= 0.499869138;
           daa[17*20+15]= 0.496334956;
           daa[17*20+16]= 0.38372361;
           daa[18*20+0]=  0.573154753;
           daa[18*20+1]=  0.628599063;
           daa[18*20+2]=  0.720013799;
           daa[18*20+3]=  0.436220437;
           daa[18*20+4]=  0.55626163;
           daa[18*20+5]=  0.728970584;
           daa[18*20+6]=  0.50720003;
           daa[18*20+7]=  0.284727562;
           daa[18*20+8]=  2.210952064;
           daa[18*20+9]=  0.570562395;
           daa[18*20+10]= 0.811019594;
           daa[18*20+11]= 0.664884513;
           daa[18*20+12]= 0.93253606;
           daa[18*20+13]= 5.894735673;
           daa[18*20+14]= 0.433748126;
           daa[18*20+15]= 0.593795813;
           daa[18*20+16]= 0.523549536;
           daa[18*20+17]= 2.996248013;
           daa[19*20+0]=  2.063050067;
           daa[19*20+1]=  0.388680158;
           daa[19*20+2]=  0.474418852;
           daa[19*20+3]=  0.275658381;
           daa[19*20+4]=  0.998911631;
           daa[19*20+5]=  0.634408285;
           daa[19*20+6]=  0.527640634;
           daa[19*20+7]=  0.314700907;
           daa[19*20+8]=  0.305792277;
           daa[19*20+9]=  8.002789424;
           daa[19*20+10]= 2.113077156;
           daa[19*20+11]= 0.526184203;
           daa[19*20+12]= 1.737356217;
           daa[19*20+13]= 0.983844803;
           daa[19*20+14]= 0.551333603;
           daa[19*20+15]= 0.507506011;
           daa[19*20+16]= 1.89965079;
           daa[19*20+17]= 0.429570747;
           daa[19*20+18]= 0.716795463;
           
           f[0]=  0.076;
           f[1]=  0.054;
           f[2]=  0.038;
           f[3]=  0.045;
           f[4]=  0.028;
           f[5]=  0.034;
           f[6]=  0.053;
           f[7]=  0.078;
           f[8]=  0.030;
           f[9]=  0.060;
           f[10]= 0.096;
           f[11]= 0.052;
           f[12]= 0.022;
           f[13]= 0.045;
           f[14]= 0.042;
           f[15]= 0.068;
           f[16]= 0.056;
           f[17]= 0.016;
           f[18]= 0.036;
           f[19]= 0.071;
	  }
	else if (prot_model == "HIVB") 
	  {
           daa[1*20+0]=   0.30750700;
           daa[2*20+0]=   0.00500000;
           daa[2*20+1]=   0.29554300;
           daa[3*20+0]=   1.45504000;
           daa[3*20+1]=   0.00500000;
           daa[3*20+2]=   17.66120000;
           daa[4*20+0]=   0.12375800;
           daa[4*20+1]=   0.35172100;
           daa[4*20+2]=   0.08606420;
           daa[4*20+3]=   0.00500000;
           daa[5*20+0]=   0.05511280;
           daa[5*20+1]=   3.42150000;
           daa[5*20+2]=   0.67205200;
           daa[5*20+3]=   0.00500000;
           daa[5*20+4]=   0.00500000;
           daa[6*20+0]=   1.48135000;
           daa[6*20+1]=   0.07492180;
           daa[6*20+2]=   0.07926330;
           daa[6*20+3]=   10.58720000;
           daa[6*20+4]=   0.00500000;
           daa[6*20+5]=   2.56020000;
           daa[7*20+0]=   2.13536000;
           daa[7*20+1]=   3.65345000;
           daa[7*20+2]=   0.32340100;
           daa[7*20+3]=   2.83806000;
           daa[7*20+4]=   0.89787100;
           daa[7*20+5]=   0.06191370;
           daa[7*20+6]=   3.92775000;
           daa[8*20+0]=   0.08476130;
           daa[8*20+1]=   9.04044000;
           daa[8*20+2]=   7.64585000;
           daa[8*20+3]=   1.91690000;
           daa[8*20+4]=   0.24007300;
           daa[8*20+5]=   7.05545000;
           daa[8*20+6]=   0.11974000;
           daa[8*20+7]=   0.00500000;
           daa[9*20+0]=   0.00500000;
           daa[9*20+1]=   0.67728900;
           daa[9*20+2]=   0.68056500;
           daa[9*20+3]=   0.01767920;
           daa[9*20+4]=   0.00500000;
           daa[9*20+5]=   0.00500000;
           daa[9*20+6]=   0.00609079;
           daa[9*20+7]=   0.00500000;
           daa[9*20+8]=   0.10311100;
           daa[10*20+0]=  0.21525600;
           daa[10*20+1]=  0.70142700;
           daa[10*20+2]=  0.00500000;
           daa[10*20+3]=  0.00876048;
           daa[10*20+4]=  0.12977700;
           daa[10*20+5]=  1.49456000;
           daa[10*20+6]=  0.00500000;
           daa[10*20+7]=  0.00500000;
           daa[10*20+8]=  1.74171000;
           daa[10*20+9]=  5.95879000;
           daa[11*20+0]=  0.00500000;
           daa[11*20+1]=  20.45000000;
           daa[11*20+2]=  7.90443000;
           daa[11*20+3]=  0.00500000;
           daa[11*20+4]=  0.00500000;
           daa[11*20+5]=  6.54737000;
           daa[11*20+6]=  4.61482000;
           daa[11*20+7]=  0.52170500;
           daa[11*20+8]=  0.00500000;
           daa[11*20+9]=  0.32231900;
           daa[11*20+10]= 0.08149950;
           daa[12*20+0]=  0.01866430;
           daa[12*20+1]=  2.51394000;
           daa[12*20+2]=  0.00500000;
           daa[12*20+3]=  0.00500000;
           daa[12*20+4]=  0.00500000;
           daa[12*20+5]=  0.30367600;
           daa[12*20+6]=  0.17578900;
           daa[12*20+7]=  0.00500000;
           daa[12*20+8]=  0.00500000;
           daa[12*20+9]=  11.20650000;
           daa[12*20+10]= 5.31961000;
           daa[12*20+11]= 1.28246000;
           daa[13*20+0]=  0.01412690;
           daa[13*20+1]=  0.00500000;
           daa[13*20+2]=  0.00500000;
           daa[13*20+3]=  0.00500000;
           daa[13*20+4]=  9.29815000;
           daa[13*20+5]=  0.00500000;
           daa[13*20+6]=  0.00500000;
           daa[13*20+7]=  0.29156100;
           daa[13*20+8]=  0.14555800;
           daa[13*20+9]=  3.39836000;
           daa[13*20+10]= 8.52484000;
           daa[13*20+11]= 0.03426580;
           daa[13*20+12]= 0.18802500;
           daa[14*20+0]=  2.12217000;
           daa[14*20+1]=  1.28355000;
           daa[14*20+2]=  0.00739578;
           daa[14*20+3]=  0.03426580;
           daa[14*20+4]=  0.00500000;
           daa[14*20+5]=  4.47211000;
           daa[14*20+6]=  0.01202260;
           daa[14*20+7]=  0.00500000;
           daa[14*20+8]=  2.45318000;
           daa[14*20+9]=  0.04105930;
           daa[14*20+10]= 2.07757000;
           daa[14*20+11]= 0.03138620;
           daa[14*20+12]= 0.00500000;
           daa[14*20+13]= 0.00500000;
           daa[15*20+0]=  2.46633000;
           daa[15*20+1]=  3.47910000;
           daa[15*20+2]=  13.14470000;
           daa[15*20+3]=  0.52823000;
           daa[15*20+4]=  4.69314000;
           daa[15*20+5]=  0.11631100;
           daa[15*20+6]=  0.00500000;
           daa[15*20+7]=  4.38041000;
           daa[15*20+8]=  0.38274700;
           daa[15*20+9]=  1.21803000;
           daa[15*20+10]= 0.92765600;
           daa[15*20+11]= 0.50411100;
           daa[15*20+12]= 0.00500000;
           daa[15*20+13]= 0.95647200;
           daa[15*20+14]= 5.37762000;
           daa[16*20+0]=  15.91830000;
           daa[16*20+1]=  2.86868000;
           daa[16*20+2]=  6.88667000;
           daa[16*20+3]=  0.27472400;
           daa[16*20+4]=  0.73996900;
           daa[16*20+5]=  0.24358900;
           daa[16*20+6]=  0.28977400;
           daa[16*20+7]=  0.36961500;
           daa[16*20+8]=  0.71159400;
           daa[16*20+9]=  8.61217000;
           daa[16*20+10]= 0.04376730;
           daa[16*20+11]= 4.67142000;
           daa[16*20+12]= 4.94026000;
           daa[16*20+13]= 0.01412690;
           daa[16*20+14]= 2.01417000;
           daa[16*20+15]= 8.93107000;
           daa[17*20+0]=  0.00500000;
           daa[17*20+1]=  0.99133800;
           daa[17*20+2]=  0.00500000;
           daa[17*20+3]=  0.00500000;
           daa[17*20+4]=  2.63277000;
           daa[17*20+5]=  0.02665600;
           daa[17*20+6]=  0.00500000;
           daa[17*20+7]=  1.21674000;
           daa[17*20+8]=  0.06951790;
           daa[17*20+9]=  0.00500000;
           daa[17*20+10]= 0.74884300;
           daa[17*20+11]= 0.00500000;
           daa[17*20+12]= 0.08907800;
           daa[17*20+13]= 0.82934300;
           daa[17*20+14]= 0.04445060;
           daa[17*20+15]= 0.02487280;
           daa[17*20+16]= 0.00500000;
           daa[18*20+0]=  0.00500000;
           daa[18*20+1]=  0.00991826;
           daa[18*20+2]=  1.76417000;
           daa[18*20+3]=  0.67465300;
           daa[18*20+4]=  7.57932000;
           daa[18*20+5]=  0.11303300;
           daa[18*20+6]=  0.07926330;
           daa[18*20+7]=  0.00500000;
           daa[18*20+8]=  18.69430000;
           daa[18*20+9]=  0.14816800;
           daa[18*20+10]= 0.11198600;
           daa[18*20+11]= 0.00500000;
           daa[18*20+12]= 0.00500000;
           daa[18*20+13]= 15.34000000;
           daa[18*20+14]= 0.03043810;
           daa[18*20+15]= 0.64802400;
           daa[18*20+16]= 0.10565200;
           daa[18*20+17]= 1.28022000;
           daa[19*20+0]=  7.61428000;
           daa[19*20+1]=  0.08124540;
           daa[19*20+2]=  0.02665600;
           daa[19*20+3]=  1.04793000;
           daa[19*20+4]=  0.42002700;
           daa[19*20+5]=  0.02091530;
           daa[19*20+6]=  1.02847000;
           daa[19*20+7]=  0.95315500;
           daa[19*20+8]=  0.00500000;
           daa[19*20+9]=  17.73890000;
           daa[19*20+10]= 1.41036000;
           daa[19*20+11]= 0.26582900;
           daa[19*20+12]= 6.85320000;
           daa[19*20+13]= 0.72327400;
           daa[19*20+14]= 0.00500000;
           daa[19*20+15]= 0.07492180;
           daa[19*20+16]= 0.70922600;
           daa[19*20+17]= 0.00500000;
           daa[19*20+18]= 0.04105930;
           /* ROUNDING ERROR:
           f[0]=  0.060;
           f[1]=  0.066;
           f[2]=  0.044;
           f[3]=  0.042;
           f[4]=  0.020;
           f[5]=  0.054;
           f[6]=  0.071;
           f[7]=  0.072;
           f[8]=  0.022;
           f[9]=  0.070;
           f[10]= 0.099;
           f[11]= 0.057;
           f[12]= 0.020;
           f[13]= 0.029;
           f[14]= 0.046;
           f[15]= 0.051;
           f[16]= 0.054;
           f[17]= 0.033;
           f[18]= 0.028;
           f[19]= 0.062;
           */
           f[0]= 0.060490222;           f[1]= 0.066039665;           f[2]= 0.044127815;           f[3]= 0.042109048;
           f[4]= 0.020075899;           f[5]= 0.053606488;           f[6]= 0.071567447;           f[7]= 0.072308239;
           f[8]= 0.022293943;           f[9]= 0.069730629;           f[10]= 0.098851122;          f[11]= 0.056968211;
           f[12]= 0.019768318;          f[13]= 0.028809447;          f[14]= 0.046025282;          f[15]= 0.05060433;
           f[16]= 0.053636813;          f[17]= 0.033011601;          f[18]= 0.028350243;          f[19]= 0.061625237;

	  }
	else if (prot_model == "HIVW") 
	  {
           daa[1*20+0]=   0.0744808;
           daa[2*20+0]=   0.6175090;
           daa[2*20+1]=   0.1602400;
           daa[3*20+0]=   4.4352100;
           daa[3*20+1]=   0.0674539;
           daa[3*20+2]=   29.4087000;
           daa[4*20+0]=   0.1676530;
           daa[4*20+1]=   2.8636400;
           daa[4*20+2]=   0.0604932;
           daa[4*20+3]=   0.0050000;
           daa[5*20+0]=   0.0050000;
           daa[5*20+1]=   10.6746000;
           daa[5*20+2]=   0.3420680;
           daa[5*20+3]=   0.0050000;
           daa[5*20+4]=   0.0050000;
           daa[6*20+0]=   5.5632500;
           daa[6*20+1]=   0.0251632;
           daa[6*20+2]=   0.2015260;
           daa[6*20+3]=   12.1233000;
           daa[6*20+4]=   0.0050000;
           daa[6*20+5]=   3.2065600;
           daa[7*20+0]=   1.8685000;
           daa[7*20+1]=   13.4379000;
           daa[7*20+2]=   0.0604932;
           daa[7*20+3]=   10.3969000;
           daa[7*20+4]=   0.0489798;
           daa[7*20+5]=   0.0604932;
           daa[7*20+6]=   14.7801000;
           daa[8*20+0]=   0.0050000;
           daa[8*20+1]=   6.8440500;
           daa[8*20+2]=   8.5987600;
           daa[8*20+3]=   2.3177900;
           daa[8*20+4]=   0.0050000;
           daa[8*20+5]=   18.5465000;
           daa[8*20+6]=   0.0050000;
           daa[8*20+7]=   0.0050000;
           daa[9*20+0]=   0.0050000;
           daa[9*20+1]=   1.3406900;
           daa[9*20+2]=   0.9870280;
           daa[9*20+3]=   0.1451240;
           daa[9*20+4]=   0.0050000;
           daa[9*20+5]=   0.0342252;
           daa[9*20+6]=   0.0390512;
           daa[9*20+7]=   0.0050000;
           daa[9*20+8]=   0.0050000;
           daa[10*20+0]=  0.1602400;
           daa[10*20+1]=  0.5867570;
           daa[10*20+2]=  0.0050000;
           daa[10*20+3]=  0.0050000;
           daa[10*20+4]=  0.0050000;
           daa[10*20+5]=  2.8904800;
           daa[10*20+6]=  0.1298390;
           daa[10*20+7]=  0.0489798;
           daa[10*20+8]=  1.7638200;
           daa[10*20+9]=  9.1024600;
           daa[11*20+0]=  0.5927840;
           daa[11*20+1]=  39.8897000;
           daa[11*20+2]=  10.6655000;
           daa[11*20+3]=  0.8943130;
           daa[11*20+4]=  0.0050000;
           daa[11*20+5]=  13.0705000;
           daa[11*20+6]=  23.9626000;
           daa[11*20+7]=  0.2794250;
           daa[11*20+8]=  0.2240600;
           daa[11*20+9]=  0.8174810;
           daa[11*20+10]= 0.0050000;
           daa[12*20+0]=  0.0050000;
           daa[12*20+1]=  3.2865200;
           daa[12*20+2]=  0.2015260;
           daa[12*20+3]=  0.0050000;
           daa[12*20+4]=  0.0050000;
           daa[12*20+5]=  0.0050000;
           daa[12*20+6]=  0.0050000;
           daa[12*20+7]=  0.0489798;
           daa[12*20+8]=  0.0050000;
           daa[12*20+9]=  17.3064000;
           daa[12*20+10]= 11.3839000;
           daa[12*20+11]= 4.0956400;
           daa[13*20+0]=  0.5979230;
           daa[13*20+1]=  0.0050000;
           daa[13*20+2]=  0.0050000;
           daa[13*20+3]=  0.0050000;
           daa[13*20+4]=  0.3629590;
           daa[13*20+5]=  0.0050000;
           daa[13*20+6]=  0.0050000;
           daa[13*20+7]=  0.0050000;
           daa[13*20+8]=  0.0050000;
           daa[13*20+9]=  1.4828800;
           daa[13*20+10]= 7.4878100;
           daa[13*20+11]= 0.0050000;
           daa[13*20+12]= 0.0050000;
           daa[14*20+0]=  1.0098100;
           daa[14*20+1]=  0.4047230;
           daa[14*20+2]=  0.3448480;
           daa[14*20+3]=  0.0050000;
           daa[14*20+4]=  0.0050000;
           daa[14*20+5]=  3.0450200;
           daa[14*20+6]=  0.0050000;
           daa[14*20+7]=  0.0050000;
           daa[14*20+8]=  13.9444000;
           daa[14*20+9]=  0.0050000;
           daa[14*20+10]= 9.8309500;
           daa[14*20+11]= 0.1119280;
           daa[14*20+12]= 0.0050000;
           daa[14*20+13]= 0.0342252;
           daa[15*20+0]=  8.5942000;
           daa[15*20+1]=  8.3502400;
           daa[15*20+2]=  14.5699000;
           daa[15*20+3]=  0.4278810;
           daa[15*20+4]=  1.1219500;
           daa[15*20+5]=  0.1602400;
           daa[15*20+6]=  0.0050000;
           daa[15*20+7]=  6.2796600;
           daa[15*20+8]=  0.7251570;
           daa[15*20+9]=  0.7400910;
           daa[15*20+10]= 6.1439600;
           daa[15*20+11]= 0.0050000;
           daa[15*20+12]= 0.3925750;
           daa[15*20+13]= 4.2793900;
           daa[15*20+14]= 14.2490000;
           daa[16*20+0]=  24.1422000;
           daa[16*20+1]=  0.9282030;
           daa[16*20+2]=  4.5420600;
           daa[16*20+3]=  0.6303950;
           daa[16*20+4]=  0.0050000;
           daa[16*20+5]=  0.2030910;
           daa[16*20+6]=  0.4587430;
           daa[16*20+7]=  0.0489798;
           daa[16*20+8]=  0.9595600;
           daa[16*20+9]=  9.3634500;
           daa[16*20+10]= 0.0050000;
           daa[16*20+11]= 4.0480200;
           daa[16*20+12]= 7.4131300;
           daa[16*20+13]= 0.1145120;
           daa[16*20+14]= 4.3370100;
           daa[16*20+15]= 6.3407900;
           daa[17*20+0]=  0.0050000;
           daa[17*20+1]=  5.9656400;
           daa[17*20+2]=  0.0050000;
           daa[17*20+3]=  0.0050000;
           daa[17*20+4]=  5.4989400;
           daa[17*20+5]=  0.0443298;
           daa[17*20+6]=  0.0050000;
           daa[17*20+7]=  2.8258000;
           daa[17*20+8]=  0.0050000;
           daa[17*20+9]=  0.0050000;
           daa[17*20+10]= 1.3703100;
           daa[17*20+11]= 0.0050000;
           daa[17*20+12]= 0.0050000;
           daa[17*20+13]= 0.0050000;
           daa[17*20+14]= 0.0050000;
           daa[17*20+15]= 1.1015600;
           daa[17*20+16]= 0.0050000;
           daa[18*20+0]=  0.0050000;
           daa[18*20+1]=  0.0050000;
           daa[18*20+2]=  5.0647500;
           daa[18*20+3]=  2.2815400;
           daa[18*20+4]=  8.3483500;
           daa[18*20+5]=  0.0050000;
           daa[18*20+6]=  0.0050000;
           daa[18*20+7]=  0.0050000;
           daa[18*20+8]=  47.4889000;
           daa[18*20+9]=  0.1145120;
           daa[18*20+10]= 0.0050000;
           daa[18*20+11]= 0.0050000;
           daa[18*20+12]= 0.5791980;
           daa[18*20+13]= 4.1272800;
           daa[18*20+14]= 0.0050000;
           daa[18*20+15]= 0.9331420;
           daa[18*20+16]= 0.4906080;
           daa[18*20+17]= 0.0050000;
           daa[19*20+0]=  24.8094000;
           daa[19*20+1]=  0.2794250;
           daa[19*20+2]=  0.0744808;
           daa[19*20+3]=  2.9178600;
           daa[19*20+4]=  0.0050000;
           daa[19*20+5]=  0.0050000;
           daa[19*20+6]=  2.1995200;
           daa[19*20+7]=  2.7962200;
           daa[19*20+8]=  0.8274790;
           daa[19*20+9]=  24.8231000;
           daa[19*20+10]= 2.9534400;
           daa[19*20+11]= 0.1280650;
           daa[19*20+12]= 14.7683000;
           daa[19*20+13]= 2.2800000;
           daa[19*20+14]= 0.0050000;
           daa[19*20+15]= 0.8626370;
           daa[19*20+16]= 0.0050000;
           daa[19*20+17]= 0.0050000;
           daa[19*20+18]= 1.3548200;
           /*
           f[0]=  0.038;
           f[1]=  0.057;
           f[2]=  0.089;
           f[3]=  0.034;
           f[4]=  0.024;
           f[5]=  0.044;
           f[6]=  0.062;
           f[7]=  0.084;
           f[8]=  0.016;
           f[9]=  0.098;
           f[10]= 0.058;
           f[11]= 0.064;
           f[12]= 0.016;
           f[13]= 0.042;
           f[14]= 0.046;
           f[15]= 0.055;
           f[16]= 0.081;
           f[17]= 0.020;
           f[18]= 0.021;
           f[19]= 0.051;
           */
           // NOTE: originally f[19]=0.0515639 but frequencies do not sum up to 1
           f[0]= 0.0377494;             f[1]= 0.057321;              f[2]= 0.0891129;             f[3]= 0.0342034;
           f[4]= 0.0240105;             f[5]= 0.0437824;             f[6]= 0.0618606;             f[7]= 0.0838496;
           f[8]= 0.0156076;             f[9]= 0.0983641;             f[10]= 0.0577867;            f[11]= 0.0641682;
           f[12]= 0.0158419;            f[13]= 0.0422741;            f[14]= 0.0458601;            f[15]= 0.0550846;
           f[16]= 0.0813774;            f[17]= 0.019597;             f[18]= 0.0205847;            f[19]= 0.0515638;

	  }
	else if (prot_model == "JTTDCMUT") 
	  {
           daa[1*20+0]=   0.531678;
           daa[2*20+0]=   0.557967;
           daa[2*20+1]=   0.451095;
           daa[3*20+0]=   0.827445;
           daa[3*20+1]=   0.154899;
           daa[3*20+2]=   5.549530;
           daa[4*20+0]=   0.574478;
           daa[4*20+1]=   1.019843;
           daa[4*20+2]=   0.313311;
           daa[4*20+3]=   0.105625;
           daa[5*20+0]=   0.556725;
           daa[5*20+1]=   3.021995;
           daa[5*20+2]=   0.768834;
           daa[5*20+3]=   0.521646;
           daa[5*20+4]=   0.091304;
           daa[6*20+0]=   1.066681;
           daa[6*20+1]=   0.318483;
           daa[6*20+2]=   0.578115;
           daa[6*20+3]=   7.766557;
           daa[6*20+4]=   0.053907;
           daa[6*20+5]=   3.417706;
           daa[7*20+0]=   1.740159;
           daa[7*20+1]=   1.359652;
           daa[7*20+2]=   0.773313;
           daa[7*20+3]=   1.272434;
           daa[7*20+4]=   0.546389;
           daa[7*20+5]=   0.231294;
           daa[7*20+6]=   1.115632;
           daa[8*20+0]=   0.219970;
           daa[8*20+1]=   3.210671;
           daa[8*20+2]=   4.025778;
           daa[8*20+3]=   1.032342;
           daa[8*20+4]=   0.724998;
           daa[8*20+5]=   5.684080;
           daa[8*20+6]=   0.243768;
           daa[8*20+7]=   0.201696;
           daa[9*20+0]=   0.361684;
           daa[9*20+1]=   0.239195;
           daa[9*20+2]=   0.491003;
           daa[9*20+3]=   0.115968;
           daa[9*20+4]=   0.150559;
           daa[9*20+5]=   0.078270;
           daa[9*20+6]=   0.111773;
           daa[9*20+7]=   0.053769;
           daa[9*20+8]=   0.181788;
           daa[10*20+0]=  0.310007;
           daa[10*20+1]=  0.372261;
           daa[10*20+2]=  0.137289;
           daa[10*20+3]=  0.061486;
           daa[10*20+4]=  0.164593;
           daa[10*20+5]=  0.709004;
           daa[10*20+6]=  0.097485;
           daa[10*20+7]=  0.069492;
           daa[10*20+8]=  0.540571;
           daa[10*20+9]=  2.335139;
           daa[11*20+0]=  0.369437;
           daa[11*20+1]=  6.529255;
           daa[11*20+2]=  2.529517;
           daa[11*20+3]=  0.282466;
           daa[11*20+4]=  0.049009;
           daa[11*20+5]=  2.966732;
           daa[11*20+6]=  1.731684;
           daa[11*20+7]=  0.269840;
           daa[11*20+8]=  0.525096;
           daa[11*20+9]=  0.202562;
           daa[11*20+10]= 0.146481;
           daa[12*20+0]=  0.469395;
           daa[12*20+1]=  0.431045;
           daa[12*20+2]=  0.330720;
           daa[12*20+3]=  0.190001;
           daa[12*20+4]=  0.409202;
           daa[12*20+5]=  0.456901;
           daa[12*20+6]=  0.175084;
           daa[12*20+7]=  0.130379;
           daa[12*20+8]=  0.329660;
           daa[12*20+9]=  4.831666;
           daa[12*20+10]= 3.856906;
           daa[12*20+11]= 0.624581;
           daa[13*20+0]=  0.138293;
           daa[13*20+1]=  0.065314;
           daa[13*20+2]=  0.073481;
           daa[13*20+3]=  0.032522;
           daa[13*20+4]=  0.678335;
           daa[13*20+5]=  0.045683;
           daa[13*20+6]=  0.043829;
           daa[13*20+7]=  0.050212;
           daa[13*20+8]=  0.453428;
           daa[13*20+9]=  0.777090;
           daa[13*20+10]= 2.500294;
           daa[13*20+11]= 0.024521;
           daa[13*20+12]= 0.436181;
           daa[14*20+0]=  1.959599;
           daa[14*20+1]=  0.710489;
           daa[14*20+2]=  0.121804;
           daa[14*20+3]=  0.127164;
           daa[14*20+4]=  0.123653;
           daa[14*20+5]=  1.608126;
           daa[14*20+6]=  0.191994;
           daa[14*20+7]=  0.208081;
           daa[14*20+8]=  1.141961;
           daa[14*20+9]=  0.098580;
           daa[14*20+10]= 1.060504;
           daa[14*20+11]= 0.216345;
           daa[14*20+12]= 0.164215;
           daa[14*20+13]= 0.148483;
           daa[15*20+0]=  3.887095;
           daa[15*20+1]=  1.001551;
           daa[15*20+2]=  5.057964;
           daa[15*20+3]=  0.589268;
           daa[15*20+4]=  2.155331;
           daa[15*20+5]=  0.548807;
           daa[15*20+6]=  0.312449;
           daa[15*20+7]=  1.874296;
           daa[15*20+8]=  0.743458;
           daa[15*20+9]=  0.405119;
           daa[15*20+10]= 0.592511;
           daa[15*20+11]= 0.474478;
           daa[15*20+12]= 0.285564;
           daa[15*20+13]= 0.943971;
           daa[15*20+14]= 2.788406;
           daa[16*20+0]=  4.582565;
           daa[16*20+1]=  0.650282;
           daa[16*20+2]=  2.351311;
           daa[16*20+3]=  0.425159;
           daa[16*20+4]=  0.469823;
           daa[16*20+5]=  0.523825;
           daa[16*20+6]=  0.331584;
           daa[16*20+7]=  0.316862;
           daa[16*20+8]=  0.477355;
           daa[16*20+9]=  2.553806;
           daa[16*20+10]= 0.272514;
           daa[16*20+11]= 0.965641;
           daa[16*20+12]= 2.114728;
           daa[16*20+13]= 0.138904;
           daa[16*20+14]= 1.176961;
           daa[16*20+15]= 4.777647;
           daa[17*20+0]=  0.084329;
           daa[17*20+1]=  1.257961;
           daa[17*20+2]=  0.027700;
           daa[17*20+3]=  0.057466;
           daa[17*20+4]=  1.104181;
           daa[17*20+5]=  0.172206;
           daa[17*20+6]=  0.114381;
           daa[17*20+7]=  0.544180;
           daa[17*20+8]=  0.128193;
           daa[17*20+9]=  0.134510;
           daa[17*20+10]= 0.530324;
           daa[17*20+11]= 0.089134;
           daa[17*20+12]= 0.201334;
           daa[17*20+13]= 0.537922;
           daa[17*20+14]= 0.069965;
           daa[17*20+15]= 0.310927;
           daa[17*20+16]= 0.080556;
           daa[18*20+0]=  0.139492;
           daa[18*20+1]=  0.235601;
           daa[18*20+2]=  0.700693;
           daa[18*20+3]=  0.453952;
           daa[18*20+4]=  2.114852;
           daa[18*20+5]=  0.254745;
           daa[18*20+6]=  0.063452;
           daa[18*20+7]=  0.052500;
           daa[18*20+8]=  5.848400;
           daa[18*20+9]=  0.303445;
           daa[18*20+10]= 0.241094;
           daa[18*20+11]= 0.087904;
           daa[18*20+12]= 0.189870;
           daa[18*20+13]= 5.484236;
           daa[18*20+14]= 0.113850;
           daa[18*20+15]= 0.628608;
           daa[18*20+16]= 0.201094;
           daa[18*20+17]= 0.747889;
           daa[19*20+0]=  2.924161;
           daa[19*20+1]=  0.171995;
           daa[19*20+2]=  0.164525;
           daa[19*20+3]=  0.315261;
           daa[19*20+4]=  0.621323;
           daa[19*20+5]=  0.179771;
           daa[19*20+6]=  0.465271;
           daa[19*20+7]=  0.470140;
           daa[19*20+8]=  0.121827;
           daa[19*20+9]=  9.533943;
           daa[19*20+10]= 1.761439;
           daa[19*20+11]= 0.124066;
           daa[19*20+12]= 3.038533;
           daa[19*20+13]= 0.593478;
           daa[19*20+14]= 0.211561;
           daa[19*20+15]= 0.408532;
           daa[19*20+16]= 1.143980;
           daa[19*20+17]= 0.239697;
           daa[19*20+18]= 0.165473;
           
           f[0]=  0.077;
           f[1]=  0.051;
           f[2]=  0.043;
           f[3]=  0.051;
           f[4]=  0.020;
           f[5]=  0.041;
           f[6]=  0.062;
           f[7]=  0.075;
           f[8]=  0.023;
           f[9]=  0.053;
           f[10]= 0.091;
           f[11]= 0.059;
           f[12]= 0.024;
           f[13]= 0.040;
           f[14]= 0.051;
           f[15]= 0.068;
           f[16]= 0.059;
           f[17]= 0.014;
           f[18]= 0.032;
           f[19]= 0.066;
	  }
	else if (prot_model == "FLU") 
	  {
	    daa[ 1*20+ 0] 	=	0.138658765	;
	    daa[ 2*20+ 0] 	=	0.053366579	;
	    daa[ 2*20+ 1] 	=	0.161000889	;
	    daa[ 3*20+ 0] 	=	0.584852306	;
	    daa[ 3*20+ 1] 	=	0.006771843	;
	    daa[ 3*20+ 2] 	=	7.737392871	;
	    daa[ 4*20+ 0] 	=	0.026447095	;
	    daa[ 4*20+ 1] 	=	0.167207008	;
	    daa[ 4*20+ 2] 	=	1.30E-05	;
	    daa[ 4*20+ 3] 	=	1.41E-02	;
	    daa[ 5*20+ 0] 	=	0.353753982	;
	    daa[ 5*20+ 1] 	=	3.292716942	;
	    daa[ 5*20+ 2] 	=	0.530642655	;
	    daa[ 5*20+ 3] 	=	0.145469388	;
	    daa[ 5*20+ 4] 	=	0.002547334	;
	    daa[ 6*20+ 0] 	=	1.484234503	;
	    daa[ 6*20+ 1] 	=	0.124897617	;
	    daa[ 6*20+ 2] 	=	0.061652192	;
	    daa[ 6*20+ 3] 	=	5.370511279	;
	    daa[ 6*20+ 4] 	=	3.91E-11	;
	    daa[ 6*20+ 5] 	=	1.195629122	;
	    daa[ 7*20+ 0] 	=	1.132313122	;
	    daa[ 7*20+ 1] 	=	1.190624465	;
	    daa[ 7*20+ 2] 	=	0.322524648	;
	    daa[ 7*20+ 3] 	=	1.934832784	;
	    daa[ 7*20+ 4] 	=	0.116941459	;
	    daa[ 7*20+ 5] 	=	0.108051341	;
	    daa[ 7*20+ 6] 	=	1.593098825	;
	    daa[ 8*20+ 0] 	=	0.214757862	;
	    daa[ 8*20+ 1] 	=	1.879569938	;
	    daa[ 8*20+ 2] 	=	1.387096032	;
	    daa[ 8*20+ 3] 	=	0.887570549	;
	    daa[ 8*20+ 4] 	=	2.18E-02	;
	    daa[ 8*20+ 5] 	=	5.330313412	;
	    daa[ 8*20+ 6] 	=	0.256491863	;
	    daa[ 8*20+ 7] 	=	0.058774527	;
	    daa[ 9*20+ 0] 	=	0.149926734	;
	    daa[ 9*20+ 1] 	=	0.246117172	;
	    daa[ 9*20+ 2] 	=	0.218571975	;
	    daa[ 9*20+ 3] 	=	0.014085917	;
	    daa[ 9*20+ 4] 	=	0.001112158	;
	    daa[ 9*20+ 5] 	=	0.02883995	;
	    daa[ 9*20+ 6] 	=	1.42E-02	;
	    daa[ 9*20+ 7] 	=	1.63E-05	;
	    daa[ 9*20+ 8] 	=	0.243190142	;
	    daa[10*20+ 0] 	=	0.023116952	;
	    daa[10*20+ 1] 	=	0.296045557	;
	    daa[10*20+ 2] 	=	8.36E-04	;
	    daa[10*20+ 3] 	=	0.005730682	;
	    daa[10*20+ 4] 	=	0.005613627	;
	    daa[10*20+ 5] 	=	1.020366955	;
	    daa[10*20+ 6] 	=	0.016499536	;
	    daa[10*20+ 7] 	=	0.006516229	;
	    daa[10*20+ 8] 	=	0.321611694	;
	    daa[10*20+ 9] 	=	3.512072282	;
	    daa[11*20+ 0] 	=	0.47433361	;
	    daa[11*20+ 1] 	=	15.30009662	;
	    daa[11*20+ 2] 	=	2.646847965	;
	    daa[11*20+ 3] 	=	0.29004298	;
	    daa[11*20+ 4] 	=	3.83E-06	;
	    daa[11*20+ 5] 	=	2.559587177	;
	    daa[11*20+ 6] 	=	3.881488809	;
	    daa[11*20+ 7] 	=	0.264148929	;
	    daa[11*20+ 8] 	=	0.347302791	;
	    daa[11*20+ 9] 	=	0.227707997	;
	    daa[11*20+10] 	=	0.129223639	;
	    daa[12*20+ 0] 	=	0.058745423	;
	    daa[12*20+ 1] 	=	0.890162346	;
	    daa[12*20+ 2] 	=	0.005251688	;
	    daa[12*20+ 3] 	=	0.041762964	;
	    daa[12*20+ 4] 	=	0.11145731	;
	    daa[12*20+ 5] 	=	0.190259181	;
	    daa[12*20+ 6] 	=	0.313974351	;
	    daa[12*20+ 7] 	=	0.001500467	;
	    daa[12*20+ 8] 	=	0.001273509	;
	    daa[12*20+ 9] 	=	9.017954203	;
	    daa[12*20+10] 	=	6.746936485	;
	    daa[12*20+11] 	=	1.331291619	;
	    daa[13*20+ 0] 	=	0.080490909	;
	    daa[13*20+ 1] 	=	1.61E-02	;
	    daa[13*20+ 2] 	=	8.36E-04	;
	    daa[13*20+ 3] 	=	1.06E-06	;
	    daa[13*20+ 4] 	=	0.104053666	;
	    daa[13*20+ 5] 	=	0.032680657	;
	    daa[13*20+ 6] 	=	0.001003501	;
	    daa[13*20+ 7] 	=	0.001236645	;
	    daa[13*20+ 8] 	=	0.119028506	;
	    daa[13*20+ 9] 	=	1.463357278	;
	    daa[13*20+10] 	=	2.986800036	;
	    daa[13*20+11] 	=	3.20E-01	;
	    daa[13*20+12] 	=	0.279910509	;
	    daa[14*20+ 0] 	=	0.659311478	;
	    daa[14*20+ 1] 	=	0.15402718	;
	    daa[14*20+ 2] 	=	3.64E-02	;
	    daa[14*20+ 3] 	=	0.188539456	;
	    daa[14*20+ 4] 	=	1.59E-13	;
	    daa[14*20+ 5] 	=	0.712769599	;
	    daa[14*20+ 6] 	=	0.319558828	;
	    daa[14*20+ 7] 	=	0.038631761	;
	    daa[14*20+ 8] 	=	0.924466914	;
	    daa[14*20+ 9] 	=	0.080543327	;
	    daa[14*20+10] 	=	0.634308521	;
	    daa[14*20+11] 	=	0.195750632	;
	    daa[14*20+12] 	=	5.69E-02	;
	    daa[14*20+13] 	=	0.00713243	;
	    daa[15*20+ 0] 	=	3.011344519	;
	    daa[15*20+ 1] 	=	0.95013841	;
	    daa[15*20+ 2] 	=	3.881310531	;
	    daa[15*20+ 3] 	=	0.338372183	;
	    daa[15*20+ 4] 	=	0.336263345	;
	    daa[15*20+ 5] 	=	0.487822499	;
	    daa[15*20+ 6] 	=	0.307140298	;
	    daa[15*20+ 7] 	=	1.585646577	;
	    daa[15*20+ 8] 	=	0.58070425	;
	    daa[15*20+ 9] 	=	0.290381075	;
	    daa[15*20+10] 	=	0.570766693	;
	    daa[15*20+11] 	=	0.283807672	;
	    daa[15*20+12] 	=	0.007026588	;
	    daa[15*20+13] 	=	0.99668567	;
	    daa[15*20+14] 	=	2.087385344	;
	    daa[16*20+ 0] 	=	5.418298175	;
	    daa[16*20+ 1] 	=	0.183076905	;
	    daa[16*20+ 2] 	=	2.140332316	;
	    daa[16*20+ 3] 	=	0.135481233	;
	    daa[16*20+ 4] 	=	0.011975266	;
	    daa[16*20+ 5] 	=	0.602340963	;
	    daa[16*20+ 6] 	=	0.280124895	;
	    daa[16*20+ 7] 	=	0.01880803	;
	    daa[16*20+ 8] 	=	0.368713573	;
	    daa[16*20+ 9] 	=	2.904052286	;
	    daa[16*20+10] 	=	0.044926357	;
	    daa[16*20+11] 	=	1.5269642	;
	    daa[16*20+12] 	=	2.031511321	;
	    daa[16*20+13] 	=	0.000134906	;
	    daa[16*20+14] 	=	0.542251094	;
	    daa[16*20+15] 	=	2.206859934	;
	    daa[17*20+ 0] 	=	1.96E-01	;
	    daa[17*20+ 1] 	=	1.369429408	;
	    daa[17*20+ 2] 	=	5.36E-04	;
	    daa[17*20+ 3] 	=	1.49E-05	;
	    daa[17*20+ 4] 	=	0.09410668	;
	    daa[17*20+ 5] 	=	4.40E-02	;
	    daa[17*20+ 6] 	=	0.155245492	;
	    daa[17*20+ 7] 	=	0.196486447	;
	    daa[17*20+ 8] 	=	2.24E-02	;
	    daa[17*20+ 9] 	=	0.03213215	;
	    daa[17*20+10] 	=	0.431277663	;
	    daa[17*20+11] 	=	4.98E-05	;
	    daa[17*20+12] 	=	0.070460039	;
	    daa[17*20+13] 	=	0.814753094	;
	    daa[17*20+14] 	=	0.000431021	;
	    daa[17*20+15] 	=	0.099835753	;
	    daa[17*20+16] 	=	0.207066206	;
	    daa[18*20+ 0] 	=	0.018289288	;
	    daa[18*20+ 1] 	=	0.099855497	;
	    daa[18*20+ 2] 	=	0.373101927	;
	    daa[18*20+ 3] 	=	0.525398543	;
	    daa[18*20+ 4] 	=	0.601692431	;
	    daa[18*20+ 5] 	=	0.072205935	;
	    daa[18*20+ 6] 	=	0.10409287	;
	    daa[18*20+ 7] 	=	0.074814997	;
	    daa[18*20+ 8] 	=	6.448954446	;
	    daa[18*20+ 9] 	=	0.273934263	;
	    daa[18*20+10] 	=	0.340058468	;
	    daa[18*20+11] 	=	0.012416222	;
	    daa[18*20+12] 	=	0.874272175	;
	    daa[18*20+13] 	=	5.393924245	;
	    daa[18*20+14] 	=	1.82E-04	;
	    daa[18*20+15] 	=	0.39255224	;
	    daa[18*20+16] 	=	0.12489802	;
	    daa[18*20+17] 	=	0.42775543	;
	    daa[19*20+ 0] 	=	3.53200527	;
	    daa[19*20+ 1] 	=	0.103964386	;
	    daa[19*20+ 2] 	=	0.010257517	;
	    daa[19*20+ 3] 	=	0.297123975	;
	    daa[19*20+ 4] 	=	0.054904564	;
	    daa[19*20+ 5] 	=	0.406697814	;
	    daa[19*20+ 6] 	=	0.285047948	;
	    daa[19*20+ 7] 	=	0.337229619	;
	    daa[19*20+ 8] 	=	0.098631355	;
	    daa[19*20+ 9] 	=	14.39405219	;
	    daa[19*20+10] 	=	0.890598579	;
	    daa[19*20+11] 	=	0.07312793	;
	    daa[19*20+12] 	=	4.904842235	;
	    daa[19*20+13] 	=	0.592587985	;
	    daa[19*20+14] 	=	0.058971975	;
	    daa[19*20+15] 	=	0.088256423	;
	    daa[19*20+16] 	=	0.654109108	;
	    daa[19*20+17] 	=	0.256900461	;
	    daa[19*20+18] 	=	0.167581647	;
	    
 
  
	    f[0]	=	0.0471	;
	    f[1]	=	0.0509	;
	    f[2]	=	0.0742	;
	    f[3]	=	0.0479	;
	    f[4]	=	0.0250	;
	    f[5]	=	0.0333	;
	    f[6]	=	0.0546	;
	    f[7]	=	0.0764	;
	    f[8]	=	0.0200	;
	    f[9]	=	0.0671	;
	    f[10]	=	0.0715	;
	    f[11]	=	0.0568	;
	    f[12]	=	0.0181	;
	    f[13]	=	0.0305	;
	    f[14]	=	0.0507	;
	    f[15]	=	0.0884	;
	    f[16]	=	0.0743	;
	    f[17]	=	0.0185	;
	    f[18]	=	0.0315	;
	    f[19]	=	0.0632	;
	  }
	else  return false;

  for (i=0; i<20; i++)  
	daa[i*20+i] = 0.0;
  for (i=0; i<20; i++)
    for (j=0; j<i; j++)               
      daa[j*20+i] = daa[i*20+j];

  max = 0;
  
  for(i = 0; i < 19; i++)
    for(j = i + 1; j < 20; j++)
      {
		temp = daa[i * 20 + j];
		if(temp > max) 
			max = temp;
      }
 
  const double AA_SCALE = 10.0;
  scaler = AA_SCALE / max;
   
  /* SCALING HAS BEEN RE-INTRODUCED TO RESOLVE NUMERICAL  PROBLEMS */   

  for(i = 0; i < 20; i++)
      for(j = 0; j < 20; j++)
		{  
		daa[i*20+j] *= scaler;
		}
	return true;
}

string model_WAG = 
"0.551571 \
0.509848  0.635346 \
0.738998  0.147304  5.429420 \
1.027040  0.528191  0.265256  0.0302949 \
0.908598  3.035500  1.543640  0.616783  0.0988179 \
1.582850  0.439157  0.947198  6.174160  0.021352  5.469470 \
1.416720  0.584665  1.125560  0.865584  0.306674  0.330052  0.567717 \
0.316954  2.137150  3.956290  0.930676  0.248972  4.294110  0.570025  0.249410 \
0.193335  0.186979  0.554236  0.039437  0.170135  0.113917  0.127395  0.0304501 0.138190 \
0.397915  0.497671  0.131528  0.0848047 0.384287  0.869489  0.154263  0.0613037 0.499462  3.170970 \
0.906265  5.351420  3.012010  0.479855  0.0740339 3.894900  2.584430  0.373558  0.890432  0.323832  0.257555 \
0.893496  0.683162  0.198221  0.103754  0.390482  1.545260  0.315124  0.174100  0.404141  4.257460  4.854020  0.934276 \
0.210494  0.102711  0.0961621 0.0467304 0.398020  0.0999208 0.0811339 0.049931  0.679371  1.059470  2.115170  0.088836  1.190630 \
1.438550  0.679489  0.195081  0.423984  0.109404  0.933372  0.682355  0.243570  0.696198  0.0999288 0.415844  0.556896  0.171329  0.161444 \
3.370790  1.224190  3.974230  1.071760  1.407660  1.028870  0.704939  1.341820  0.740169  0.319440  0.344739  0.967130  0.493905  0.545931  1.613280 \
2.121110  0.554413  2.030060  0.374866  0.512984  0.857928  0.822765  0.225833  0.473307  1.458160  0.326622  1.386980  1.516120  0.171903  0.795384  4.378020 \
0.113133  1.163920  0.0719167 0.129767  0.717070  0.215737  0.156557  0.336983  0.262569  0.212483  0.665309  0.137505  0.515706  1.529640  0.139405  0.523742  0.110864 \
0.240735  0.381533  1.086000  0.325711  0.543833  0.227710  0.196303  0.103604  3.873440  0.420170  0.398618  0.133264  0.428437  6.454280  0.216046  0.786993  0.291148  2.485390 \
2.006010  0.251849  0.196246  0.152335  1.002140  0.301281  0.588731  0.187247  0.118358  7.821300  1.800340  0.305434  2.058450  0.649892  0.314887  0.232739  1.388230  0.365369  0.314730 \
\
0.0866279 0.043972  0.0390894 0.0570451 0.0193078 0.0367281 0.0580589 0.0832518 0.0244313 0.048466  0.086209  0.0620286 0.0195027 0.0384319 0.0457631 0.0695179 0.0610127 0.0143859 0.0352742 0.0708956";

string model_cpREV = 
"  105\
  227  357\
  175   43 4435\
  669  823  538   10\
  157 1745  768  400   10\
  499  152 1055 3691   10 3122\
  665  243  653  431  303  133  379\
   66  715 1405  331  441 1269  162   19\
  145  136  168   10  280   92  148   40   29\
  197  203  113   10  396  286   82   20   66 1745\
  236 4482 2430  412   48 3313 2629  263  305  345  218\
  185  125   61   47  159  202  113   21   10 1772 1351  193\
   68   53   97   22  726   10  145   25  127  454 1268   72  327\
  490   87  173  170  285  323  185   28  152  117  219  302  100   43\
 2440  385 2085  590 2331  396  568  691  303  216  516  868   93  487 1202\
 1340  314 1393  266  576  241  369   92   32 1040  156  918  645  148  260 2151\
   14  230   40   18  435   53   63   82   69   42  159   10   86  468   49   73   29\
   56  323  754  281 1466  391  142   10 1971   89  189  247  215 2370   97  522   71  346\
  968   92   83   75  592   54  200   91   25 4797  865  249  475  317  122  167  760   10  119\
\
 0.0755 0.0621 0.0410 0.0371 0.0091 0.0382 0.0495 0.0838 0.0246 0.0806\
 0.1011 0.0504 0.0220 0.0506 0.0431 0.0622 0.0543 0.0181 0.0307 0.0660";

string model_mtREV = 
"  23.18\
  26.95  13.24\
  17.67   1.90 794.38\
  59.93 103.33  58.94   1.90\
   1.90 220.99 173.56  55.28  75.24\
   9.77   1.90  63.05 583.55   1.90 313.56\
 120.71  23.03  53.30  56.77  30.71   6.75  28.28\
  13.90 165.23 496.13 113.99 141.49 582.40  49.12   1.90\
  96.49   1.90  27.10   4.34  62.73   8.34   3.31   5.98  12.26\
  25.46  15.58  15.16   1.90  25.65  39.70   1.90   2.41  11.49 329.09\
   8.36 141.40 608.70   2.31   1.90 465.58 313.86  22.73 127.67  19.57  14.88\
 141.88   1.90  65.41   1.90   6.18  47.37   1.90   1.90  11.97 517.98 537.53  91.37\
   6.37   4.69  15.20   4.98  70.80  19.11   2.67   1.90  48.16  84.67 216.06   6.44  90.82\
  54.31  23.64  73.31  13.43  31.26 137.29  12.83   1.90  60.97  20.63  40.10  50.10  18.84  17.31\
 387.86   6.04 494.39  69.02 277.05  54.11  54.71 125.93  77.46  47.70  73.61 105.79 111.16  64.29 169.90\
 480.72   2.08 238.46  28.01 179.97  94.93  14.82  11.17  44.78 368.43 126.40 136.33 528.17  33.85 128.22 597.21\
   1.90  21.95  10.68  19.86  33.60   1.90   1.90  10.92   7.08   1.90  32.44  24.00  21.71   7.84   4.21  38.58   9.99\
   6.48   1.90 191.36  21.21 254.77  38.82  13.12   3.21 670.14  25.01  44.15  51.17  39.96 465.58  16.21  64.92  38.73  26.25\
 195.06   7.64   1.90   1.90   1.90  19.00  21.14   2.53   1.90 1222.94  91.67   1.90 387.54   6.35   8.23   1.90 204.54   5.37   1.90\
\
0.072 0.019 0.039 0.019 0.006 0.025 0.024 0.056 0.028 0.088 0.169\
0.023 0.054 0.061 0.054 0.072 0.086 0.029 0.033 0.043";

/*
string model_Dayhoff = 
" 27									    \
 98  32									    \
120   0 905								    \
 36  23   0   0								    \
 89 246 103 134   0							    \
198   1 148 1153  0 716							    \
240   9 139 125  11  28  81						    \
 23 240 535  86  28 606  43  10						    \
 65  64  77  24  44  18  61   0   7					    \
 41  15  34   0   0  73  11   7  44 257					    \
 26 464 318  71   0 153  83  27  26  46  18				    \
 72  90   1   0   0 114  30  17   0 336 527 243				    \
 18  14  14   0   0   0   0  15  48 196 157   0  92			    \
250 103  42  13  19 153  51  34  94  12  32  33  17  11			    \
409 154 495  95 161  56  79 234  35  24  17  96  62  46 245		    \
371  26 229  66  16  53  34  30  22 192  33 136 104  13  78 550		    \
  0 201  23   0   0   0   0   0  27   0  46   0   0  76   0  75   0	    \
 24   8  95   0  96   0  22   0 127  37  28  13   0 698   0  34  42  61	    \
208  24  15  18  49  35  37  54  44 889 175  10 258  12  48  30 157   0  28 \
\
0.087127 0.040904 0.040432 0.046872 0.033474 0.038255 0.049530\
0.088612 0.033618 0.036886 0.085357 0.080482 0.014753 0.039772\
0.050680 0.069577 0.058542 0.010494 0.029916 0.064718";
*/
string model_mtMAM = 
" 32                                                                         \
  2   4                                                                     \
 11   0 864                                                                 \
  0 186   0   0                                                             \
  0 246   8  49   0                                                         \
  0   0   0 569   0 274                                                     \
 78  18  47  79   0   0  22                                                 \
  8 232 458  11 305 550  22   0                                             \
 75   0  19   0  41   0   0   0   0                                         \
 21   6   0   0  27  20   0   0  26 232                                     \
  0  50 408   0   0 242 215   0   0   6   4                                 \
 76   0  21   0   0  22   0   0   0 378 609  59                             \
  0   0   6   5   7   0   0   0   0  57 246   0  11                         \
 53   9  33   2   0  51   0   0  53   5  43  18   0  17                     \
342   3 446  16 347  30  21 112  20   0  74  65  47  90 202                 \
681   0 110   0 114   0   4   0   1 360  34  50 691   8  78 614             \
  5  16   6   0  65   0   0   0   0   0  12   0  13   0   7  17   0         \
  0   0 156   0 530  54   0   1 1525 16  25  67   0 682   8 107   0  14    \
398   0   0  10   0  33  20   5   0 2220 100  0 832   6   0   0 237   0   0 \
\
0.0692 0.0184 0.0400 0.0186 0.0065 0.0238 0.0236 0.0557 0.0277 0.0905\
0.1675 0.0221 0.0561 0.0611 0.0536 0.0725 0.0870 0.0293 0.0340 0.0428";


string model_JTT=
" 58                                                                        \
 54  45                                                                    \
 81  16 528                                                                \
 56 113  34  10                                                            \
 57 310  86  49   9                                                        \
105  29  58 767   5 323                                                    \
179 137  81 130  59  26 119                                                \
 27 328 391 112  69 597  26  23                                            \
 36  22  47  11  17   9  12   6  16                                        \
 30  38  12   7  23  72   9   6  56 229                                    \
 35 646 263  26   7 292 181  27  45  21  14                                \
 54  44  30  15  31  43  18  14  33 479 388  65                            \
 15   5  10   4  78   4   5   5  40  89 248   4  43                        \
194  74  15  15  14 164  18  24 115  10 102  21  16  17                    \
378 101 503  59 223  53  30 201  73  40  59  47  29  92 285                \
475  64 232  38  42  51  32  33  46 245  25 103 226  12 118 477            \
  9 126   8   4 115  18  10  55   8   9  52  10  24  53   6  35  12        \
 11  20  70  46 209  24   7   8 573  32  24   8  18 536  10  63  21  71    \
298  17  16  31  62  20  45  47  11 961 180  14 323  62  23  38 112  25  16 \
\
0.076748 0.051691 0.042645 0.051544 0.019803 0.040752 0.061830\
0.073152 0.022944 0.053761 0.091904 0.058676 0.023826 0.040126\
0.050901 0.068765 0.058565 0.014261 0.032102 0.066005";

string model_LG = 
"0.425093 \
0.276818 0.751878 \
0.395144 0.123954 5.076149 \
2.489084 0.534551 0.528768 0.062556 \
0.969894 2.807908 1.695752 0.523386 0.084808 \
1.038545 0.363970 0.541712 5.243870 0.003499 4.128591 \
2.066040 0.390192 1.437645 0.844926 0.569265 0.267959 0.348847 \
0.358858 2.426601 4.509238 0.927114 0.640543 4.813505 0.423881 0.311484 \
0.149830 0.126991 0.191503 0.010690 0.320627 0.072854 0.044265 0.008705 0.108882 \
0.395337 0.301848 0.068427 0.015076 0.594007 0.582457 0.069673 0.044261 0.366317 4.145067 \
0.536518 6.326067 2.145078 0.282959 0.013266 3.234294 1.807177 0.296636 0.697264 0.159069 0.137500 \
1.124035 0.484133 0.371004 0.025548 0.893680 1.672569 0.173735 0.139538 0.442472 4.273607 6.312358 0.656604 \
0.253701 0.052722 0.089525 0.017416 1.105251 0.035855 0.018811 0.089586 0.682139 1.112727 2.592692 0.023918 1.798853 \
1.177651 0.332533 0.161787 0.394456 0.075382 0.624294 0.419409 0.196961 0.508851 0.078281 0.249060 0.390322 0.099849 0.094464 \
4.727182 0.858151 4.008358 1.240275 2.784478 1.223828 0.611973 1.739990 0.990012 0.064105 0.182287 0.748683 0.346960 0.361819 1.338132 \
2.139501 0.578987 2.000679 0.425860 1.143480 1.080136 0.604545 0.129836 0.584262 1.033739 0.302936 1.136863 2.020366 0.165001 0.571468 6.472279 \
0.180717 0.593607 0.045376 0.029890 0.670128 0.236199 0.077852 0.268491 0.597054 0.111660 0.619632 0.049906 0.696175 2.457121 0.095131 0.248862 0.140825 \
0.218959 0.314440 0.612025 0.135107 1.165532 0.257336 0.120037 0.054679 5.306834 0.232523 0.299648 0.131932 0.481306 7.803902 0.089613 0.400547 0.245841 3.151815 \
2.547870 0.170887 0.083688 0.037967 1.959291 0.210332 0.245034 0.076701 0.119013 10.649107 1.702745 0.185202 1.898718 0.654683 0.296501 0.098369 2.188158 0.189510 0.249313 \
\
0.079066 0.055941 0.041977 0.053052 0.012937 0.040767 0.071586 0.057337 0.022355 0.062157 0.099081 0.064600 0.022951 0.042302 0.044040 0.061197 0.053287 0.012066 0.034155 0.069147";

string model_mtART = 
"0.2 \
0.2 0.2 \
1 4 500 \
254 36 98 11 \
0.2 154 262 0.2 0.2 \
0.2 0.2 183 862 0.2 262 \
200 0.2 121 12 81 3 44 \
0.2 41 180 0.2 12 314 15 0.2 \
26 2 21 7 63 11 7 3 0.2 \
4 2 13 1 79 16 2 1 6 515 \
0.2 209 467 2 0.2 349 106 0.2 0.2 3 4 \
121 5 79 0.2 312 67 0.2 56 0.2 515 885 106 \
13 5 20 0.2 184 0.2 0.2 1 14 118 263 11 322 \
49 0.2 17 0.2 0.2 39 8 0.2 1 0.2 12 17 5 15 \
673 3 398 44 664 52 31 226 11 7 8 144 112 36 87 \
244 0.2 166 0.2 183 44 43 0.2 19 204 48 70 289 14 47 660 \
0.2 0.2 8 0.2 22 7 11 2 0.2 0.2 21 16 71 54 0.2 2 0.2 \
1 4 251 0.2 72 87 8 9 191 12 20 117 71 792 18 30 46 38 \
340 0.2 23 0.2 350 0.2 14 3 0.2 1855 85 26 281 52 32 61 544 0.2 2 \
\
0.054116 0.018227 0.039903 0.020160 0.009709 0.018781 0.024289 0.068183 0.024518 0.092638 \
0.148658 0.021718 0.061453 0.088668 0.041826 0.091030 0.049194 0.029786 0.039443 0.057700";


string model_mtZOA = 
"   3.3\
   1.7  33.6\
  16.1   3.2 617.0\
 272.5  61.1  94.6   9.5\
   7.3 231.0 190.3  19.3  49.1\
  17.1   6.4 174.0 883.6   3.4 349.4\
 289.3   7.2  99.3  26.0  82.4   8.9  43.1\
   2.3  61.7 228.9  55.6  37.5 421.8  14.9   7.4\
  33.2   0.2  24.3   1.5  48.8   0.2   7.3   3.4   1.6\
  15.6   4.1   7.9   0.5  59.7  23.0   1.0   3.5   6.6 425.2\
   0.2 292.3 413.4   0.2   0.2 334.0 163.2  10.1  23.9   8.4   6.7\
 136.5   3.8  73.7   0.2 264.8  83.9   0.2  52.2   7.1 449.7 636.3  83.0\
  26.5   0.2  12.9   2.0 167.8   9.5   0.2   5.8  13.1  90.3 234.2  16.3 215.6\
  61.8   7.5  22.6   0.2   8.1  52.2  20.6   1.3  15.6   2.6  11.4  24.3   5.4  10.5\
 644.9  11.8 420.2  51.4 656.3  96.4  38.4 257.1  23.1   7.2  15.2 144.9  95.3  32.2  79.7\
 378.1   3.2 184.6   2.3 199.0  39.4  34.5   5.2  19.4 222.3  50.0  75.5 305.1  19.3  56.9 666.3\
   3.1  16.9   6.4   0.2  36.1   6.1   3.5  12.3   4.5   9.7  27.2   6.6  48.7  58.2   1.3  10.3   3.6\
   2.1  13.8 141.6  13.9  76.7  52.3  10.0   4.3 266.5  13.1   5.7  45.0  41.4 590.5   4.2  29.7  29.0  79.8\
 321.9   5.1   7.1   3.7 243.8   9.0  16.3  23.7   0.3 1710.6 126.1  11.1 279.6  59.6  17.9  49.5 396.4  13.7  15.6 \
\
    0.068880    0.021037    0.030390    0.020696    0.009966    0.018623    0.024989    0.071968    0.026814    0.085072    0.156717    0.019276    0.050652    0.081712    0.044803    0.080535    0.056386    0.027998    0.037404    0.066083";

void get_rtREV(double **q, double *f) {
	/* rtRev */
	q[ 0][ 0] =   0; q[ 1][ 0] =  34; q[ 2][ 0] =  51; q[ 3][ 0] =  10; q[ 4][ 0] = 439;
	q[ 5][ 0] =  32; q[ 6][ 0] =  81; q[ 7][ 0] = 135; q[ 8][ 0] =  30; q[ 9][ 0] =   1;
	q[10][ 0] =  45; q[11][ 0] =  38; q[12][ 0] = 235; q[13][ 0] =   1; q[14][ 0] =  97;
	q[15][ 0] = 460; q[16][ 0] = 258; q[17][ 0] =   5; q[18][ 0] =  55; q[19][ 0] = 197;

	q[ 0][ 1] =  34; q[ 1][ 1] =   0; q[ 2][ 1] =  35; q[ 3][ 1] =  30; q[ 4][ 1] =  92;
	q[ 5][ 1] = 221; q[ 6][ 1] =  10; q[ 7][ 1] =  41; q[ 8][ 1] =  90; q[ 9][ 1] =  24;
	q[10][ 1] =  18; q[11][ 1] = 593; q[12][ 1] =  57; q[13][ 1] =   7; q[14][ 1] =  24;
	q[15][ 1] = 102; q[16][ 1] =  64; q[17][ 1] =  13; q[18][ 1] =  47; q[19][ 1] =  29;

	q[ 0][ 2] =  51; q[ 1][ 2] =  35; q[ 2][ 2] =   0; q[ 3][ 2] = 384; q[ 4][ 2] = 128;
	q[ 5][ 2] = 236; q[ 6][ 2] =  79; q[ 7][ 2] =  94; q[ 8][ 2] = 320; q[ 9][ 2] =  35;
	q[10][ 2] =  15; q[11][ 2] = 123; q[12][ 2] =   1; q[13][ 2] =  49; q[14][ 2] =  33;
	q[15][ 2] = 294; q[16][ 2] = 148; q[17][ 2] =  16; q[18][ 2] =  28; q[19][ 2] =  21;

	q[ 0][ 3] =  10; q[ 1][ 3] =  30; q[ 2][ 3] = 384; q[ 3][ 3] =   0; q[ 4][ 3] =   1;
	q[ 5][ 3] =  78; q[ 6][ 3] = 542; q[ 7][ 3] =  61; q[ 8][ 3] =  91; q[ 9][ 3] =   1;
	q[10][ 3] =   5; q[11][ 3] =  20; q[12][ 3] =   1; q[13][ 3] =   1; q[14][ 3] =  55;
	q[15][ 3] = 136; q[16][ 3] =  55; q[17][ 3] =   1; q[18][ 3] =   1; q[19][ 3] =   6;

	q[ 0][ 4] = 439; q[ 1][ 4] =  92; q[ 2][ 4] = 128; q[ 3][ 4] =   1; q[ 4][ 4] =   0;
	q[ 5][ 4] =  70; q[ 6][ 4] =   1; q[ 7][ 4] =  48; q[ 8][ 4] = 124; q[ 9][ 4] = 104;
	q[10][ 4] = 110; q[11][ 4] =  16; q[12][ 4] = 156; q[13][ 4] =  70; q[14][ 4] =   1;
	q[15][ 4] =  75; q[16][ 4] = 117; q[17][ 4] =  55; q[18][ 4] = 131; q[19][ 4] = 295;

	q[ 0][ 5] =  32; q[ 1][ 5] = 221; q[ 2][ 5] = 236; q[ 3][ 5] =  78; q[ 4][ 5] =  70;
	q[ 5][ 5] =   0; q[ 6][ 5] = 372; q[ 7][ 5] =  18; q[ 8][ 5] = 387; q[ 9][ 5] =  33;
	q[10][ 5] =  54; q[11][ 5] = 309; q[12][ 5] = 158; q[13][ 5] =   1; q[14][ 5] =  68;
	q[15][ 5] = 225; q[16][ 5] = 146; q[17][ 5] =  10; q[18][ 5] =  45; q[19][ 5] =  36;

	q[ 0][ 6] =  81; q[ 1][ 6] =  10; q[ 2][ 6] =  79; q[ 3][ 6] = 542; q[ 4][ 6] =   1;
	q[ 5][ 6] = 372; q[ 6][ 6] =   0; q[ 7][ 6] =  70; q[ 8][ 6] =  34; q[ 9][ 6] =   1;
	q[10][ 6] =  21; q[11][ 6] = 141; q[12][ 6] =   1; q[13][ 6] =   1; q[14][ 6] =  52;
	q[15][ 6] =  95; q[16][ 6] =  82; q[17][ 6] =  17; q[18][ 6] =   1; q[19][ 6] =  35;

	q[ 0][ 7] = 135; q[ 1][ 7] =  41; q[ 2][ 7] =  94; q[ 3][ 7] =  61; q[ 4][ 7] =  48;
	q[ 5][ 7] =  18; q[ 6][ 7] =  70; q[ 7][ 7] =   0; q[ 8][ 7] =  68; q[ 9][ 7] =   1;
	q[10][ 7] =   3; q[11][ 7] =  30; q[12][ 7] =  37; q[13][ 7] =   7; q[14][ 7] =  17;
	q[15][ 7] = 152; q[16][ 7] =   7; q[17][ 7] =  23; q[18][ 7] =  21; q[19][ 7] =   3;

	q[ 0][ 8] =  30; q[ 1][ 8] =  90; q[ 2][ 8] = 320; q[ 3][ 8] =  91; q[ 4][ 8] = 124;
	q[ 5][ 8] = 387; q[ 6][ 8] =  34; q[ 7][ 8] =  68; q[ 8][ 8] =   0; q[ 9][ 8] =  34;
	q[10][ 8] =  51; q[11][ 8] =  76; q[12][ 8] = 116; q[13][ 8] = 141; q[14][ 8] =  44;
	q[15][ 8] = 183; q[16][ 8] =  49; q[17][ 8] =  48; q[18][ 8] = 307; q[19][ 8] =   1;

	q[ 0][ 9] =   1; q[ 1][ 9] =  24; q[ 2][ 9] =  35; q[ 3][ 9] =   1; q[ 4][ 9] = 104;
	q[ 5][ 9] =  33; q[ 6][ 9] =   1; q[ 7][ 9] =   1; q[ 8][ 9] =  34; q[ 9][ 9] =   0;
	q[10][ 9] = 385; q[11][ 9] =  34; q[12][ 9] = 375; q[13][ 9] =  64; q[14][ 9] =  10;
	q[15][ 9] =   4; q[16][ 9] =  72; q[17][ 9] =  39; q[18][ 9] =  26; q[19][ 9] =1048;

	q[ 0][10] =  45; q[ 1][10] =  18; q[ 2][10] =  15; q[ 3][10] =   5; q[ 4][10] = 110;
	q[ 5][10] =  54; q[ 6][10] =  21; q[ 7][10] =   3; q[ 8][10] =  51; q[ 9][10] = 385;
	q[10][10] =   0; q[11][10] =  23; q[12][10] = 581; q[13][10] = 179; q[14][10] =  22;
	q[15][10] =  24; q[16][10] =  25; q[17][10] =  47; q[18][10] =  64; q[19][10] = 112;

	q[ 0][11] =  38; q[ 1][11] = 593; q[ 2][11] = 123; q[ 3][11] =  20; q[ 4][11] =  16;
	q[ 5][11] = 309; q[ 6][11] = 141; q[ 7][11] =  30; q[ 8][11] =  76; q[ 9][11] =  34;
	q[10][11] =  23; q[11][11] =   0; q[12][11] = 134; q[13][11] =  14; q[14][11] =  43;
	q[15][11] =  77; q[16][11] = 110; q[17][11] =   6; q[18][11] =   1; q[19][11] =  19;

	q[ 0][12] = 235; q[ 1][12] =  57; q[ 2][12] =   1; q[ 3][12] =   1; q[ 4][12] = 156;
	q[ 5][12] = 158; q[ 6][12] =   1; q[ 7][12] =  37; q[ 8][12] = 116; q[ 9][12] = 375;
	q[10][12] = 581; q[11][12] = 134; q[12][12] =   0; q[13][12] = 247; q[14][12] =   1;
	q[15][12] =   1; q[16][12] = 131; q[17][12] = 111; q[18][12] =  74; q[19][12] = 236;

	q[ 0][13] =   1; q[ 1][13] =   7; q[ 2][13] =  49; q[ 3][13] =   1; q[ 4][13] =  70;
	q[ 5][13] =   1; q[ 6][13] =   1; q[ 7][13] =   7; q[ 8][13] = 141; q[ 9][13] =  64;
	q[10][13] = 179; q[11][13] =  14; q[12][13] = 247; q[13][13] =   0; q[14][13] =  11;
	q[15][13] =  20; q[16][13] =  69; q[17][13] = 182; q[18][13] =1017; q[19][13] =  92;

	q[ 0][14] =  97; q[ 1][14] =  24; q[ 2][14] =  33; q[ 3][14] =  55; q[ 4][14] =   1;
	q[ 5][14] =  68; q[ 6][14] =  52; q[ 7][14] =  17; q[ 8][14] =  44; q[ 9][14] =  10;
	q[10][14] =  22; q[11][14] =  43; q[12][14] =   1; q[13][14] =  11; q[14][14] =   0;
	q[15][14] = 134; q[16][14] =  62; q[17][14] =   9; q[18][14] =  14; q[19][14] =  25;

	q[ 0][15] = 460; q[ 1][15] = 102; q[ 2][15] = 294; q[ 3][15] = 136; q[ 4][15] =  75;
	q[ 5][15] = 225; q[ 6][15] =  95; q[ 7][15] = 152; q[ 8][15] = 183; q[ 9][15] =   4;
	q[10][15] =  24; q[11][15] =  77; q[12][15] =   1; q[13][15] =  20; q[14][15] = 134;
	q[15][15] =   0; q[16][15] = 671; q[17][15] =  14; q[18][15] =  31; q[19][15] =  39;

	q[ 0][16] = 258; q[ 1][16] =  64; q[ 2][16] = 148; q[ 3][16] =  55; q[ 4][16] = 117;
	q[ 5][16] = 146; q[ 6][16] =  82; q[ 7][16] =   7; q[ 8][16] =  49; q[ 9][16] =  72;
	q[10][16] =  25; q[11][16] = 110; q[12][16] = 131; q[13][16] =  69; q[14][16] =  62;
	q[15][16] = 671; q[16][16] =   0; q[17][16] =   1; q[18][16] =  34; q[19][16] = 196;

	q[ 0][17] =   5; q[ 1][17] =  13; q[ 2][17] =  16; q[ 3][17] =   1; q[ 4][17] =  55;
	q[ 5][17] =  10; q[ 6][17] =  17; q[ 7][17] =  23; q[ 8][17] =  48; q[ 9][17] =  39;
	q[10][17] =  47; q[11][17] =   6; q[12][17] = 111; q[13][17] = 182; q[14][17] =   9;
	q[15][17] =  14; q[16][17] =   1; q[17][17] =   0; q[18][17] = 176; q[19][17] =  26;

	q[ 0][18] =  55; q[ 1][18] =  47; q[ 2][18] =  28; q[ 3][18] =   1; q[ 4][18] = 131;
	q[ 5][18] =  45; q[ 6][18] =   1; q[ 7][18] =  21; q[ 8][18] = 307; q[ 9][18] =  26;
	q[10][18] =  64; q[11][18] =   1; q[12][18] =  74; q[13][18] =1017; q[14][18] =  14;
	q[15][18] =  31; q[16][18] =  34; q[17][18] = 176; q[18][18] =   0; q[19][18] =  59;

	q[ 0][19] = 197; q[ 1][19] =  29; q[ 2][19] =  21; q[ 3][19] =   6; q[ 4][19] = 295;
	q[ 5][19] =  36; q[ 6][19] =  35; q[ 7][19] =   3; q[ 8][19] =   1; q[ 9][19] =1048;
	q[10][19] = 112; q[11][19] =  19; q[12][19] = 236; q[13][19] =  92; q[14][19] =  25;
	q[15][19] =  39; q[16][19] = 196; q[17][19] =  26; q[18][19] =  59; q[19][19] =   0;

	f[ 0] = 0.0646;
	f[ 1] = 0.0453;
	f[ 2] = 0.0376;
	f[ 3] = 0.0422;
	f[ 4] = 0.0114;
	f[ 5] = 0.0606;
	f[ 6] = 0.0607;
	f[ 7] = 0.0639;
	f[ 8] = 0.0273;
	f[ 9] = 0.0679;
	f[10] = 0.1018;
	f[11] = 0.0751;
	f[12] = 0.0150;
	f[13] = 0.0287;
	f[14] = 0.0681;
	f[15] = 0.0488;
	f[16] = 0.0622;
	f[17] = 0.0251;
	f[18] = 0.0318;
	f[19] = 0.0619;
}

void get_VT(double **q, double *f) {
	/*
	* Mueller, T. and Vingron, M. 
	* "Modeling Amino Acid Replacement" 
	* Journal of Comp. Biology, 7(6):761-776,2000
	*/

	/* amino acid frequencies */
	f[ 0]=0.0770764620135024 ; f[ 1]=0.0500819370772208 ;
	f[ 2]=0.0462377395993731 ; f[ 3]=0.0537929860758246 ;
	f[ 4]=0.0144533387583345 ; f[ 5]=0.0408923608974345 ;
	f[ 6]=0.0633579339160905 ; f[ 7]=0.0655672355884439 ;
	f[ 8]=0.0218802687005936 ; f[ 9]=0.0591969699027449 ;
	f[10]=0.0976461276528445 ; f[11]=0.0592079410822730 ;
	f[12]=0.0220695876653368 ; f[13]=0.0413508521834260 ;
	f[14]=0.0476871596856874 ; f[15]=0.0707295165111524 ;
	f[16]=0.0567759161524817 ; f[17]=0.0127019797647213 ;
	f[18]=0.0323746050281867 ; f[19]=0.0669190817443274 ;

	/* relative rates */

	q[ 0][ 1] = 1.2412691067876198;  q[ 0][ 2] = 1.2184237953498958;
	q[ 0][ 3] = 1.3759368509441177;  q[ 0][ 4] = 2.4731223087544874;
	q[ 0][ 5] = 2.2155167805137470;  q[ 0][ 6] = 2.3379911207495061;
	q[ 0][ 7] = 3.3386555146457697;  q[ 0][ 8] = 0.9615841926910841;
	q[ 0][ 9] = 0.8908203061925510;  q[ 0][10] = 1.0778497408764076;
	q[ 0][11] = 1.4932055816372476;  q[ 0][12] = 1.9006455961717605;
	q[ 0][13] = 0.6883439026872615;  q[ 0][14] = 2.7355620089953550;
	q[ 0][15] = 6.4208961859142883;  q[ 0][16] = 5.2892514169776437;
	q[ 0][17] = 0.5488578478106930;  q[ 0][18] = 0.5411769916657778;
	q[ 0][19] = 4.6501894691803214;

	q[ 1][ 2] = 1.5720770753326880;  q[ 1][ 3] = 0.7550654439001206;
	q[ 1][ 4] = 1.4414262567428417;  q[ 1][ 5] = 5.5120819705248678;
	q[ 1][ 6] = 1.3542404860613146;  q[ 1][ 7] = 1.3121700301622004;
	q[ 1][ 8] = 4.9238668283945266;  q[ 1][ 9] = 0.4323005487925516;
	q[ 1][10] = 0.8386701149158265;  q[ 1][11] = 10.0173308173660018;
	q[ 1][12] = 1.2488638689609959;  q[ 1][13] = 0.4224945197276290;
	q[ 1][14] = 1.3091837782420783;  q[ 1][15] = 1.9202994262316166;
	q[ 1][16] = 1.3363401740560601;  q[ 1][17] = 1.5170142153962840;
	q[ 1][18] = 0.8912614404565405;  q[ 1][19] = 0.7807017855806767;

	q[ 2][ 3] = 7.8584219153689405;  q[ 2][ 4] = 0.9784679122774127;
	q[ 2][ 5] = 3.0143201670924822;  q[ 2][ 6] = 2.0093434778398112;
	q[ 2][ 7] = 2.4117632898861809;  q[ 2][ 8] = 6.1974384977884114;
	q[ 2][ 9] = 0.9179291175331520;  q[ 2][10] = 0.4098311270816011;
	q[ 2][11] = 4.4034547578962568;  q[ 2][12] = 0.9378803706165143;
	q[ 2][13] = 0.5044944273324311;  q[ 2][14] = 0.7103720531974738;
	q[ 2][15] = 6.1234512396801764;  q[ 2][16] = 3.8852506105922231;
	q[ 2][17] = 0.1808525752605976;  q[ 2][18] = 1.0894926581511342;
	q[ 2][19] = 0.4586061981719967;

	q[ 3][ 4] = 0.2272488448121475;  q[ 3][ 5] = 1.6562495638176040;
	q[ 3][ 6] = 9.6883451875685065;  q[ 3][ 7] = 1.9142079025990228;
	q[ 3][ 8] = 2.1459640610133781;  q[ 3][ 9] = 0.2161660372725585;
	q[ 3][10] = 0.3574207468998517;  q[ 3][11] = 1.4521790561663968;
	q[ 3][12] = 0.4075239926000898;  q[ 3][13] = 0.1675129724559251;
	q[ 3][14] = 1.0714605979577547;  q[ 3][15] = 2.2161944596741829;
	q[ 3][16] = 1.5066839872944762;  q[ 3][17] = 0.2496584188151770;
	q[ 3][18] = 0.7447620891784513;  q[ 3][19] = 0.4594535241660911;

	q[ 4][ 5] = 0.4587469126746136;  q[ 4][ 6] = 0.4519167943192672;
	q[ 4][ 7] = 1.1034605684472507;  q[ 4][ 8] = 1.5196756759380692;
	q[ 4][ 9] = 0.9126668032539315;  q[ 4][10] = 1.4081315998413697;
	q[ 4][11] = 0.3371091785647479;  q[ 4][12] = 1.2213054800811556;
	q[ 4][13] = 1.6953951980808002;  q[ 4][14] = 0.4326227078645523;
	q[ 4][15] = 3.6366815408744255;  q[ 4][16] = 1.7557065205837685;
	q[ 4][17] = 1.6275179891253113;  q[ 4][18] = 2.1579775140421025;
	q[ 4][19] = 2.2627456996290891;

	q[ 5][ 6] = 6.8124601839937675;  q[ 5][ 7] = 0.8776110594765502;
	q[ 5][ 8] = 7.9943228564946525;  q[ 5][ 9] = 0.4882733432879921;
	q[ 5][10] = 1.3318097154194044;  q[ 5][11] = 6.0519085243118811;
	q[ 5][12] = 1.9106190827629084;  q[ 5][13] = 0.3573432522499545;
	q[ 5][14] = 2.3019177728300728;  q[ 5][15] = 2.3193703643237220;
	q[ 5][16] = 2.1576510103471440;  q[ 5][17] = 0.8959082681546182;
	q[ 5][18] = 0.9183596801412757;  q[ 5][19] = 0.6366932501396869;

	q[ 6][ 7] = 1.3860121390169038;  q[ 6][ 8] = 1.6360079688522375;
	q[ 6][ 9] = 0.4035497929633328;  q[ 6][10] = 0.5610717242294755;
	q[ 6][11] = 4.3290086529582830;  q[ 6][12] = 0.7471936218068498;
	q[ 6][13] = 0.2317194387691585;  q[ 6][14] = 1.5132807416252063;
	q[ 6][15] = 1.8273535587773553;  q[ 6][16] = 1.5839981708584689;
	q[ 6][17] = 0.4198391148111098;  q[ 6][18] = 0.5818111331782764;
	q[ 6][19] = 0.8940572875547330;

	q[ 7][ 8] = 0.8561248973045037;  q[ 7][ 9] = 0.2888075033037488;
	q[ 7][10] = 0.3578662395745526;  q[ 7][11] = 0.8945563662345198;
	q[ 7][12] = 0.5954812791740037;  q[ 7][13] = 0.3693722640980460;
	q[ 7][14] = 0.7744933618134962;  q[ 7][15] = 3.0637776193717610;
	q[ 7][16] = 0.7147489676267383;  q[ 7][17] = 0.9349753595598769;
	q[ 7][18] = 0.3374467649724478;  q[ 7][19] = 0.6193321034173915;

	q[ 8][ 9] = 0.5787937115407940;  q[ 8][10] = 1.0765007949562073;
	q[ 8][11] = 1.8085136096039203;  q[ 8][12] = 1.3808291710019667;
	q[ 8][13] = 1.3629765501081097;  q[ 8][14] = 1.8370555852070649;
	q[ 8][15] = 1.9699895187387506;  q[ 8][16] = 1.6136654573285647;
	q[ 8][17] = 0.6301954684360302;  q[ 8][18] = 7.7587442309146040;
	q[ 8][19] = 0.5333220944030346;

	q[ 9][10] = 6.0019110258426362;  q[ 9][11] = 0.6244297525127139;
	q[ 9][12] = 6.7597899772045418;  q[ 9][13] = 2.2864286949316077;
	q[ 9][14] = 0.4811402387911145;  q[ 9][15] = 0.6047491507504744;
	q[ 9][16] = 2.6344778384442731;  q[ 9][17] = 0.5604648274060783;
	q[ 9][18] = 0.8626796044156272;  q[ 9][19] = 14.8729334615190609;

	q[10][11] = 0.5642322882556321;  q[10][12] = 8.0327792947421148;
	q[10][13] = 4.3611548063555778;  q[10][14] = 1.0084320519837335;
	q[10][15] = 0.8953754669269811;  q[10][16] = 1.0192004372506540;
	q[10][17] = 1.5183114434679339;  q[10][18] = 1.2452243224541324;
	q[10][19] = 3.5458093276667237;

	q[11][12] = 1.7129670976916258;  q[11][13] = 0.3910559903834828;
	q[11][14] = 1.3918935593582853;  q[11][15] = 1.9776630140912268;
	q[11][16] = 2.5513781312660280;  q[11][17] = 0.5851920879490173;
	q[11][18] = 0.7835447533710449;  q[11][19] = 0.7801080335991272;

	q[12][13] = 2.3201373546296349;  q[12][14] = 0.4953193808676289;
	q[12][15] = 1.0657482318076852;  q[12][16] = 3.3628488360462363;
	q[12][17] = 1.4680478689711018;  q[12][18] = 1.0899165770956820;
	q[12][19] = 4.0584577156753401;

	q[13][14] = 0.3746821107962129;  q[13][15] = 1.1079144700606407;
	q[13][16] = 0.6882725908872254;  q[13][17] = 3.3448437239772266;
	q[13][18] = 10.3848523331334590;  q[13][19] = 1.7039730522675411;

	q[14][15] = 3.5465914843628927;  q[14][16] = 1.9485376673137556;
	q[14][17] = 0.4326058001438786;  q[14][18] = 0.4819109019647465;
	q[14][19] = 0.5985498912985666;

	q[15][16] = 8.8479984061248178;  q[15][17] = 0.6791126595939816;
	q[15][18] = 0.9547229305958682;  q[15][19] = 0.9305232113028208;

	q[16][17] = 0.4514203099376473;  q[16][18] = 0.8564314184691215;
	q[16][19] = 3.4242218450865543;

	q[17][18] = 4.5377235790405388;  q[17][19] = 0.5658969249032649;

	q[18][19] = 1.0000000000000000;


} /* vt data */

//this part are taken from PUZZLE-TREE
void get_Dayhoff(double **q, double *f) {
	/*
	 * Dayhoff model for amino acid evolution
	 * Dayhoff, M.O., Schwartz, R.M., Orcutt, B.C. (1978)
	 * "A model of evolutionary change in proteins."
	 * Dayhoff, M.O. (ed.) Atlas of Protein Sequence Structur., Vol5, Suppl. 3,
	 * National Biomedical Research Foundation, Washington DC, pp. 345-352.
	 */

	q[0][1]=9.6472567159749e-01; 	q[0][2]=3.5927991886410e+00;
	q[0][3]=4.3200552414656e+00; 	q[0][4]=1.3184584178499e+00;
	q[0][5]=3.2267534963169e+00; 	q[0][6]=7.0141987829615e+00;
	q[0][7]=8.5773867857875e+00; 	q[0][8]=8.1434196396611e-01;
	q[0][9]=2.3518447453539e+00; 	q[0][10]=1.4735711728911e+00;
	q[0][11]=9.3940162271805e-01; 	q[0][12]=2.5490196078431e+00;
	q[0][13]=6.5922920892495e-01; 	q[0][14]=8.9189834148670e+00;
	q[0][15]=1.4540712836859e+01; 	q[0][16]=1.3411904595370e+01;
	q[0][17]=3.8517964118027e-02; 	q[0][18]=8.7897227856660e-01;
	q[0][19]=7.4036511156187e+00;

	q[1][2]=1.1890243902439e+00; 	q[1][3]=5.9525626545377e-02;
	q[1][4]=8.4778922655537e-01; 	q[1][5]=8.8348561504191e+00;
	q[1][6]=5.5954088952654e-02; 	q[1][7]=3.1434881434075e-01;
	q[1][8]=8.4753987678285e+00; 	q[1][9]=2.2684090115941e+00;
	q[1][10]=5.5954088952654e-01; 	q[1][11]=1.6681312769010e+01;
	q[1][12]=3.1707317073171e+00; 	q[1][13]=4.8959827833572e-01;
	q[1][14]=3.6754156468900e+00; 	q[1][15]=5.4755072760812e+00;
	q[1][16]=9.6472567159749e-01; 	q[1][17]=7.5538020086083e+00;
	q[1][18]=2.7977044476327e-01; 	q[1][19]=8.6083213773314e-01;

	q[2][3]=3.2459324155194e+01; 	q[2][4]=7.3852625416383e-02;
	q[2][5]=3.7732198142415e+00; 	q[2][6]=5.3911764705882e+00;
	q[2][7]=5.0264375413087e+00; 	q[2][8]=1.9061418685121e+01;
	q[2][9]=2.7901430842607e+00; 	q[2][10]=1.2482698961938e+00;
	q[2][11]=1.1542279411765e+01; 	q[2][12]=1.9117647058824e-01;
	q[2][13]=5.0183823529412e-01; 	q[2][14]=1.5181660899654e+00;
	q[2][15]=1.7697478991597e+01; 	q[2][16]=8.3557302231237e+00;
	q[2][17]=8.6029411764706e-01; 	q[2][18]=3.4411764705882e+00;
	q[2][19]=5.7352941176471e-01;

	q[3][4]=2.5534152404601e-02; 	q[3][5]=4.8811013767209e+00;
	q[3][6]=4.0561952440551e+01; 	q[3][7]=4.4423506911730e+00;
	q[3][8]=3.0865788117500e+00; 	q[3][9]=8.5749078239692e-01;
	q[3][10]=2.5926985518518e-02; 	q[3][11]=2.5930851063830e+00;
	q[3][12]=1.1667143483333e-01; 	q[3][13]=1.2963492759259e-02;
	q[3][14]=4.7853935065891e-01; 	q[3][15]=3.4167709637046e+00;
	q[3][16]=2.3984722282163e+00; 	q[3][17]=3.2408731898147e-02;
	q[3][18]=8.1351689612015e-02; 	q[3][19]=6.3829787234043e-01;

	q[4][5]=2.1864264103535e-02; 	q[4][6]=1.4770525083277e-02;
	q[4][7]=3.9055458751427e-01; 	q[4][8]=1.0223340673168e+00;
	q[4][9]=1.5970515970516e+00; 	q[4][10]=3.9098448749850e-02;
	q[4][11]=8.0776309049169e-03; 	q[4][12]=1.4155086538140e-01;
	q[4][13]=8.6898395721925e-02; 	q[4][14]=6.8155604487784e-01;
	q[4][15]=5.8097784568373e+00; 	q[4][16]=5.9929928084086e-01;
	q[4][17]=3.4759358288770e-01; 	q[4][18]=3.4759358288770e+00;
	q[4][19]=1.7647058823529e+00;

	q[5][6]=2.5476780185759e+01; 	q[5][7]=1.0174974779977e+00;
	q[5][8]=2.1573939173192e+01; 	q[5][9]=6.5266504894988e-01;
	q[5][10]=2.6634492806410e+00; 	q[5][11]=5.5466331269350e+00;
	q[5][12]=4.0247678018576e+00; 	q[5][13]=1.8038017885416e-02;
	q[5][14]=5.5044618466582e+00; 	q[5][15]=2.0267580716497e+00;
	q[5][16]=1.9256432155439e+00; 	q[5][17]=9.6202762055552e-02;
	q[5][18]=1.0061919504644e-01; 	q[5][19]=1.2538699690402e+00;

	q[6][7]=2.8869795109055e+00; 	q[6][8]=1.5519031141869e+00;
	q[6][9]=2.1701112877583e+00; 	q[6][10]=4.0484429065744e-01;
	q[6][11]=2.9823529411765e+00; 	q[6][12]=1.0705882352941e+00;
	q[6][13]=1.9801735189768e-02; 	q[6][14]=1.7993079584775e+00;
	q[6][15]=2.8184873949580e+00; 	q[6][16]=1.2261663286004e+00;
	q[6][17]=7.3114099162219e-02; 	q[6][18]=7.6470588235294e-01;
	q[6][19]=1.3058823529412e+00;

	q[7][8]=3.7906768788150e-01; 	q[7][9]=2.3128004846840e-02;
	q[7][10]=2.5776602775942e-01; 	q[7][11]=9.6662260409782e-01;
	q[7][12]=6.0145406477198e-01; 	q[7][13]=5.4775280898876e-01;
	q[7][14]=1.2382877804129e+00; 	q[7][15]=8.2853366065527e+00;
	q[7][16]=1.1110604644803e+00; 	q[7][17]=1.2888301387971e-01;
	q[7][18]=1.7114723586662e-02; 	q[7][19]=1.9233311302049e+00;

	q[8][9]=2.7354343963341e-01; 	q[8][10]=1.5876246692449e+00;
	q[8][11]=9.6993944636678e-01; 	q[8][12]=1.2544085640577e-01;
	q[8][13]=1.6868512110727e+00; 	q[8][14]=3.3075513942601e+00;
	q[8][15]=1.2530894710826e+00; 	q[8][16]=8.1434196396611e-01;
	q[8][17]=1.0121107266436e+00; 	q[8][18]=4.4982698961938e+00;
	q[8][19]=1.5570934256055e+00;

	q[9][10]=9.2275320303002e+00; 	q[9][11]=1.6663354531002e+00;
	q[9][12]=1.1780604133545e+01; 	q[9][13]=6.9753577106518e+00;
	q[9][14]=4.2551201720752e-01; 	q[9][15]=8.8575970928912e-01;
	q[9][16]=6.8951811852420e+00; 	q[9][17]=9.8802836705702e-02;
	q[9][18]=1.3434022257552e+00; 	q[9][19]=3.1526232114467e+01;

	q[10][11]=6.5787197231834e-01; 	q[10][12]=1.8622837370242e+01;
	q[10][13]=5.6340830449827e+00; 	q[10][14]=1.1377976796255e+00;
	q[10][15]=6.1690558576372e-01; 	q[10][16]=1.2098794893211e+00;
	q[10][17]=1.7543252595156e+00; 	q[10][18]=1.0346020761246e+00;
	q[10][19]=6.2906574394464e+00;

	q[11][12]=8.6029411764706e+00; 	q[11][13]=6.6640454965565e-03;
	q[11][14]=1.2089100346021e+00; 	q[11][15]=3.4411764705882e+00;
	q[11][16]=4.9442190669371e+00; 	q[11][17]=3.4272233982290e-02;
	q[11][18]=4.7794117647059e-01; 	q[11][19]=3.7500000000000e-01;

	q[12][13]=3.2500000000000e+00; 	q[12][14]=5.9976931949250e-01;
	q[12][15]=2.1848739495798e+00; 	q[12][16]=3.6916835699797e+00;
	q[12][17]=1.6247577591604e-01; 	q[12][18]=1.1508700794053e-01;
	q[12][19]=9.0588235294118e+00;

	q[13][14]=3.9359861591695e-01; 	q[13][15]=1.6386554621849e+00;
	q[13][16]=4.9442190669371e-01; 	q[13][17]=2.8676470588235e+00;
	q[13][18]=2.4852941176471e+01; 	q[13][19]=4.4117647058824e-01;

	q[14][15]=8.6431043005437e+00; 	q[14][16]=2.8308077795013e+00;
	q[14][17]=3.5840244687362e-02; 	q[14][18]=4.3804743506776e-02;
	q[14][19]=1.7301038062284e+00;

	q[15][16]=1.9663865546218e+01; 	q[15][17]=2.7857142857143e+00;
	q[15][18]=1.2016806722689e+00; 	q[15][19]=1.0840336134454e+00;

	q[16][17]=4.2019597219666e-02; 	q[16][18]=1.5162271805274e+00;
	q[16][19]=5.6592292089249e+00;

	q[17][18]=2.2941176470588e+00; 	q[17][19]=1.2654363316538e-01;

	q[18][19]=1.0000000000000e+00;


	f[0] = 0.087; f[1] = 0.041; f[2] = 0.040; f[3] = 0.047;
	f[4] = 0.033; f[5] = 0.038; f[6] = 0.05; f[7] = 0.089;
	f[8] = 0.034; f[9] = 0.037; f[10] = 0.085; f[11] = 0.08;
	f[12] = 0.015; f[13] = 0.04; f[14] = 0.051; f[15] = 0.07;
	f[16] = 0.058; f[17] = 0.01; f[18] = 0.03; f[19] = 0.065;

} /* dayhoff data */


ModelProtein::ModelProtein(const char *model_name, string model_params, StateFreqType freq, string freq_params, PhyloTree *tree, bool count_rates)
 : ModelGTR(tree, count_rates)
{
	init(model_name, model_params, freq, freq_params);
}


void ModelProtein::init(const char *model_name, string model_params, StateFreqType freq, string freq_params) {
	assert(num_states == 20);
	name = model_name;
	//string model_str;
	//bool user_model = false;
	double daa[400];
	string name_upper = model_name;
	for (string::iterator it = name_upper.begin(); it != name_upper.end(); it++)
		(*it) = toupper(*it);

	if (initProtMat(state_freq, daa, name_upper)) {
		int i, j, k;
		double sum = 0.0;
		for (i = 0; i < num_states; i++)
			sum += (double) state_freq[i];
		if (round(sum*1e8) != 1e8) {
			cout.precision(7);
			cout << "WARNING: " <<  name_upper << " state frequencies do not sum up to 1: " << sum << endl;
		}
		if (verbose_mode >= VB_DEBUG) {
			cout.precision(6);
			cout.unsetf(ios::fixed);
			cout << name_upper << " rate matrix and state frequencies:" << endl;
			for (i=0; i < num_states; i++) {
				for (j=0; j < num_states; j++)
					cout << ((j>0) ? "\t":"") << daa[i*20+j];
				cout << endl;
			}
			for (i=0; i < num_states; i++)
				cout << ((i>0)? "\t":"") << state_freq[i];
			cout << endl;

		}
		for (i = 0, k = 0; i < num_states-1; i++)
			for (j = i+1; j < num_states; j++)
				rates[k++] = daa[i*20+j];
	} else if (!model_params.empty()) {
		stringstream ss(model_params);
		readRates(ss);
		readStateFreq(ss);
	} else {
		// if name does not match, read the user-defined model
		readParameters(model_name);
	}
	if (freq_params != "") {
//		stringstream ss(freq_params);
		readStateFreq(freq_params);
	}
/*	if (name == "WAG") { model_str = model_WAG;}
	else if (name == "cpREV") model_str = model_cpREV;
	else if (name == "mtREV") model_str = model_mtREV;
	//else if (name == "Dayhoff") model_str = model_Dayhoff;
	else if (name == "mtMAM") model_str = model_mtMAM;
	else if (name == "JTT") model_str = model_JTT;
	else if (name == "LG") model_str = model_LG;
	else if (name == "mtART") model_str = model_mtART;
	else if (name == "mtZOA") model_str = model_mtZOA;
	else if (name == "VT" || name == "rtREV" || name == "Dayhoff" || name == "PAM") {
		double *q[num_states];
		int i, j, k;
		for (i = 0; i < num_states; i++)
			q[i] = new double[num_states];
		if (name == "VT") 
			get_VT(q, state_freq);
		else if (name == "rtREV")
			get_rtREV(q, state_freq);
		else 
			get_Dayhoff(q, state_freq);

		for (i = 0, k = 0; i < num_states-1; i++)
			for (j = i+1; j < num_states; j++)
				rates[k++] = q[i][j];
		for (i = num_states-1; i >= 0; i--)
			delete q[i];
	} else {
		//outError("Invalid model name: " + name);	
		user_model = true;
	}

	if (!model_str.empty()) {
		// read rates from internal string
		try {
			istringstream in(model_str);
			readRates(in);
			readStateFreq(in);
		}
		catch (const char *str) {
			outError(str);
		} 
	} else if (user_model) {
		readParameters(model_name);
	}*/

	num_params = 0;
	//assert(freq != FREQ_ESTIMATE);
	if (freq == FREQ_UNKNOWN) freq = FREQ_USER_DEFINED;
	ModelGTR::init(freq);
}

void ModelProtein::readRates(istream &in) throw(const char*, string) {
	int nrates = getNumRateEntries();
	int row = 1, col = 0;
	// since states for protein is stored in lower-triangle, special treatment is needed
	for (int i = 0; i < nrates; i++, col++) {
		if (col == row) {
			row++; col = 0;
		}
		// switch col and row
		int id = col*(2*num_states-col-1)/2 + (row-col-1);
		if (id >= nrates) {
			cout << row << " " << col << endl;
		}
		assert(id < nrates && id >= 0); // make sure that the conversion is correct
		if (!(in >> rates[id]))
			throw name+string(": Rate entries could not be read");
		if (rates[id] < 0.0)
			throw "Negative rates found";
	}
}


