ITK 5.0 Release Candidate 2 Release Notes
=========================================

We are happy to announce the Insight Toolkit (ITK) Release Candidate 2! :tada:  This will be the final release candidate before the 5.0.0 release, and the community is encouraged to adopt 5.0 RC 2 in ITK-based applications.

**Python Packages**

ITK Python packages can be installed by running:

```
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

**Library Sources**

- [InsightToolkit-5.0rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightToolkit-5.0rc02.tar.gz)
- [InsightToolkit-5.0rc02.tar.xz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightData-5.0rc02.tar.xz)
- [InsightToolkit-5.0rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightToolkit-5.0rc02.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.0rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightData-5.0rc02.tar.gz)
- [InsightData-5.0rc02.tar.xz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightData-5.0rc02.tar.xz)
- [InsightData-5.0rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/InsightData-5.0rc02.zip)


**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.0rc02/SHA512SUMS)

This release features a major upgrade to the ITK *Spatial Object* framework, lead by Stephen Aylward, with contributions from Hastings Greer, Forrest Lee, Niels Dekker, Dženan Zukić, and Hans Johnson. In ITK, a [`itk::SpatialObject`](https://docs.itk.org/projects/doxygen/en/stable/classitk_1_1SpatialObject.html) provides a representation of *objects* and the mechanism to specify their spatial relationship relative to other objects in a scene. Objects can be images but also abstract, parametric entities, such as a ellipse, box, or arrow, or point-based, such as a tube, contour, or surface. Objects can be organized into spatial hierarchies.`SpatialObject`s are key for model-based registration, integration of segmentation results in multiple formats, conversions to and from images, and capturing spatial relationships between structures.

In ITK 5, the `SpatialObject` framework was refactored to improve consistency in the the programming interface and simplify implementation and usage. As a result, incorrect or unexpected behaviors are avoided. Complexity and dependency were reduced by removing a dependency on the VNL tree data structures. Additionally, *IndexSpace* was removed from the API of all `SpatialObject`s to prevent ambiguity while providing a consistent and intuitive interface. Only two reference spaces are consistently and explicitly available in the API: *ObjectSpace* and *WorldSpace*. *ObjectSpace* is the space local to each object, where the object's parameters are defined. *WorldSpace* is the coordinate system defined by the top-level `SpatialObject` in a hierachy, which is defined by parent-child object relationships. Only two transforms are now consistently and explicitly available in the API: *ObjectToParent* transform and *ObjectToWorld* transform. The *ObjectToParent* transform moves an object within its parent's *ObjectSpace*. The *ObjectToWorld* transform is derived from component *ObjectToParent* transforms and is provided for convenience and to reduce redundant computations. The API is now more explicit regarding the space that an operation applies to. For instance, `IsInside(point)` is now `IsInsideInObjectSpace(point)` or `IsInsideInWorldSpace(point)`. For more information on the `SpatialObject`s changes, see the [ITK 5 Migration Guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md).

The Python package synchronization infrastructure for static global variables was refactored to support more variables and permit future additions to the singleton. This will prevent the need to rebuild remote module binary Python packages following future releases of ITK 5. However, current remote module Python packages that use ITK 5 should be rebuilt and republished for ITK 5.0 RC 2.

For an overview of ITK 5's transition to modern C++, performance-related changes, the new, Pythonic API, the project's migration to GitHub, and Mesh improvements, see the [ITK 5 Alpha 1: Modern C++](https://discourse.itk.org/t/itk-5-0-alpha-1-modern-c/843/7), [ITK 5 Alpha 2: Performance](https://discourse.itk.org/t/itk-5-0-alpha-2-performance/959), [ITK 5 Beta 1: Pythonic Interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271), [ITK 5 Beta 3: GitHub](https://discourse.itk.org/t/itk-5-0-beta-3-github/1504) and [ITK 5 Release Candidate 1: Meshes](https://discourse.itk.org/t/itk-5-0-release-candidate-1-meshes/1576/3) release announcements.

New Remote Modules
------------------

- [`ITKIOScanco`](https://github.com/KitwareMedical/ITKIOScanco): read and write Scanco microCT *.isq* files.
- [`ITKTotalVariation`](https://github.com/InsightSoftwareConsortium/ITKTotalVariation): total variation image denoising.
- [`ITKRTK`](https://github.com/SimonRit/RTK): the Reconstruction Toolkit provides high performance implementations of advanced tomographic image reconstruction algorithms.
- [`ITKThickness3D`](https://github.com/InsightSoftwareConsortium/ITKThickness3D): compute the skeleton and thickness transform from 3D images.

Performance Improvements
------------------------

- Add MetaDataDictionary move support.
- MetaDataDictionary uses copy-on-write.
- `itk::Barrier` is now deprecated: replace with the new multi-threading functions.
- Range-based for loops supported in `itk::FixedArray`.
- Major performance improvements to TimeProbe, ResourceProbe constructor (issue #350).

Documentation
-------------

- Repository *README* files were migrated to Markdown.

Infrastructure
--------------

- Continuous code coverage builds from Azure Pipelines.
- Better support for unicode in KWSys.
- `itksys::hash_map` and `itksys::hash_set` are deprecated in favor of `std` equivalents.
- New GitHub pull request templates and issue templates.
- New scripts added to update ITK remote modules.

Core
----

- `itk::SpatialObject` framework refactored (see release notes introduction).
- Initial streaming support added to `itk::ResampleImageFilter` for linear transforms.

Third Party
-----------

- Eigen 3 updated to the latest version.
- Better support for building against a system Eigen.
- GDCM updated to the latest version.
- HDF5 updated to 1.10.4.
- ITKVtkGlue support for VTK with `VTK_RENDERING_BACKEND` set to `None`.
- KWSys updated to the latest version.
- MetaIO updated to the latest version.
- VXL updated to the latest version.
- MINC updated to the latest version.

Python
------

- Static variable synchronization method refactored; ITK 5 remote module Python packages need to be rebuilt against 5.0 RC 2.
- Add wrapping for `itk.PCAShapeSignedDistanceFunction`.
- Docstrings added to snake case functions.
- Python tests should now be defined in *<ITK-module>/wrapping/test/CMakeLists.txt* to exclude their definition when wrapping is not enabled.
- Conversion between ITK matrices and NumPy arrays is now supported.
- Additional wrapping types for `itk.ImageDuplicator`.
- Additional types supported for NumPy <-> ITK Image conversion.
- Additional wrapping and typemaps for `std::vector<itk::Image<...>::Pointer>`.
- Add wrapping for `itk.TriangleMeshToBinaryImageFilter`.
- Add wrapping for `itk.ExtrapolateImageFunction`.
- Add wrapping for `itk.WindowedSincInterpolateImageFunction`.

To install the 5.0 Release Candidate 2 Python packages, run

```sh
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

What's Next
-----------

There are many more improvements not mentioned above. For more details, please see the change log below. Congratulations and thank you to everyone who contributed to this release.

The [ITK 5 Migration Guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md) is available to help transition a code base from ITK 4 to ITK 5. Please discuss your experiences on [Discourse](https://discourse.itk.org).

The ITK 5.0.0 final release is [scheduled for May](https://github.com/InsightSoftwareConsortium/ITK/milestone/5).

**Enjoy ITK!**

```
Bradley Lowekamp @blowekamp (14):
      ENH: Add move support to the MetaDataDictionary object
      PERF: Implement copy on write for MetaDataDictionary
      ENH: adding MetaDataDictionary GTests
      BUG: Do not modify MetaDataDictionary with operator[] const
      ENH: Improve ExposeMetaData efficiency
      COMP: Address CMake policy warnings in ThirdParty libraries
      ENH: Update AzurePipelines configuration from master
      ENH: Explicitly set the XCode version used in Azure
      COMP: Use CMP0048 new for wrapping
      COMP: Set CMP0048 to new in ITK (Remote) Modules
      COMP: Address OSX Clang "direct access" linkage warnings
      ENH: Add Azure Pipelines script for coverage
      BUG: Fix Li threshold calculator for negative image values
      DOC: Correct documented Canny Segmentation filter example

Dženan Zukić @dzenanz (18):
      ENH: add better support for Unicode by using UTF-8 by default in KWSys
      BUG: propagate ITK_LIBRARY_PROPERTIES into zlib
      COMP: fixing MSVC warning C4800
      ENH: refactoring NarrowBandImageFilterBase to not use Barrier
      DOC: fixing code sample
      COMP: compile fixes for Visual Studio 2017
      ENH: ModifiedTimeType uses 64 bits on Windows - it was 32 before
      ENH: refactor itkThreadPoolTest and rename into itkMultithreadingTest
      ENH: shuffling tests in ITKCommon to make the split more logical
      ENH: introduce a parameter to control level of output
      ENH: concentrating WaitForAll() in Iterate()
      ENH: ParallelSparseFieldLevelSetImageFilter no longer uses barrier
      ENH: moving Barrier into Deprecated module
      ENH: prevent false sharing between threads
      STYLE: declaration alignment
      ENH: replace itksys::hash_map and hash_set by std equivalents
      COMP: missing override for destructors
      Update ITK5MigrationGuide.md

Eigen Upstream (3):
      Eigen3 2019-01-26 (e2c082bf)
      Eigen3 2019-03-05 (0805e8fd)
      Eigen3 2019-03-14 (8a3c2d91)

Forrest Li @floryst (4):
      ENH: Update arrow spatial object
      ENH: Update EllipseSpatialObject
      ENH: Update box spatial object
      ENH: Update polygon SO and delete polygon group SO

Francois Budin @fbudin69500 (25):
      BUG: Implement but hide MetaDataDictionary iterator methods
      BUG: Explicitly give Python library path to ITK Python targets for MSVC
      ENH: Wrap itkPCAShapeSignedDistanceFunction
      ENH: Synchronize factories across modules in Python
      ENH: Explicitly return `None` when calling `__call__`` if filter has no output
      ENH: Deprecated object call function and improve procedural call function
      ENH: Adds argument completion with procedural calls
      ENH: Add docstring to snake case functions
      BUG: Disable Python tests if `ITK_BUILD_DEFAULT_MODULES` is OFF
      BUG: Returns a copy of the VNL matrix instead of a reference
      ENH: Add helper functions to convert NumPy arrays to ITK matrices and back
      ENH: Add `ttype` keyword in New() function for Python templated classes
      ENH: `isinstance()` can be called without template parameters of classinfo
      BUG: Wrap itkImageDuplicator for all image types as it is used by NumPyBridge
      ENH: itkPCAShapeSignedDistanceFunction supports float images
      ENH: Add advanced CMake option `ITK_DO_NOT_BUILD_TESTDRIVERS`
      ENH: Move part of CI configuration into Azure YML files
      ENH: Move Python tests into wrapping subfolder
      BUG: Correct CMake variable name and move baseline files to appropriate folder
      ENH: Only run Python tests on Linux and Windows
      ENH: Adds wrapping for std::vector<itk::Image<...>::Pointer> and typemaps
      ENH: New test to verify that` ObjectFactoryBasePrivate` is destroyed correctly
      ENH: Enable forcing creating snake_case function for non-ProcessObject classes
      ENH: Add snake case method for non itkProcess derived class itkImageDuplicator
      BUG: itkObjectFactoryBasePrivateDestructor was not compiling with MSVC

GDCM Upstream @malaterre (3):
      GDCM 2019-02-07 (8e1cfd05)
      GDCM 2018-10-23 (2e701ed7)
      GDCM 2019-02-08 (815caa81)

HDF5 Maintainers (1):
      HDF5 2018-10-15 (545c5fb2)

Hans J. Johnson (27):
      STYLE: Remove exact duplicate test code
      ENH: Improve by adding enhanced complexity to testing
      ENH: Add test for IsInsideInObjectSpace.
      DOC: Improve diagnostic message from ExtractImageFilter
      ENH: TransformIOBaseTemplate Must be explicitly instantiated
      STYLE: Instance variables should be private
      STYLE: Move default [con/de]strutor to .h (part 2)
      STYLE: Class derived from TransformBase need explicit instantiation
      STYLE: Remove functions that are not used
      ENH: Use member functions with default values
      COMP: Refactor to remove const_cast of void *
      STYLE: Fix spelling s/ranage/range/g in comment.
      ENH: Improve coverage for itk::FastMarchingImageFilterBase.
      COMP: Allow compiler option fixed in gcc 4.1.0
      PERF: Allow overwriting ABI/Optimization & Warning flags
      DOC: Minor spelling corrections
      ENH: Improve test coverage of ImageMoments
      DOC: Expand GetAxisAlignedBoundingBoxRegion replacement code
      STYLE: Prefer using Update() for consistency
      ENH: Avoid deprecated SpatialObject function calls
      ENH: ProtectedComputeMyBoundingBox return not used
      ENH: Clean up tests to pass under new API
      COMP: Consolodate duplicate LogTester code
      COMP: Support ITK_LEGACY_REMOVE for SpatialObjects
      ENH: Add legacy interface to SpatialObjects
      BUG: Match return types for nullptr return values
      COMP: Remove compilation warning unmatched types

Hastings Greer @HastingsGreer (6):
      BUG: ImageSpatialObject's BoundingBox was nonfunctional if not axis aligned
      BUG: ImageMaskSpatialObject::IsInside uses image cosines
      COMP: fix compilation errors
      COMP: Various compiler errors
      COMP: fixes to enable compilation with gcc
      COMP: Update tests

Jerome Schmid @schmidje (1):
      COMP: VtkGlue module-Provide support for VTK new cmake targets

Jon Haitz Legarreta Gorroño @jhlegarreta  (29):
      ENH: Add a PrintHelper file to overload boolean and vector printing.
      ENH: Add a parameter to test to improve `itk::ResampleImageFilter` testing.
      ENH: Update the ITKIOFDF remote module.
      ENH: Improve `itk::ResampleImageFilter` class coverage.
      BUG: Fix `ìtkResmapleImageTest2` test failing on 32-bit systems.
      DOC: Transition `Examples` folder `README` file to Markdown.
      DOC: Increase `VNL` ThirdParty module `README` information accuracy.
      ENH: Conform to GitHub PR and issue template guidelines.
      DOC: Transition the `Nonunit/Review` `README` to Markdown syntax.
      ENH: Bump the latest version of the `ITKThickness3D` remote.
      BUG: Fix GitHub community template syntax errors.
      STYLE: Transition GitHub community template filenames to lowercase.
      DOC: Change GitHub community template guidelines to HTML comment markup.
      ENH: Add new GitHub community issue templates.
      STYLE: Improve coverage issue template name wording.
      DOC: Fix PR template not being displayed.
      DOC: Add emojis to GitHub issue templates.
      ENH: Update a few remote modules to their latest commit versions.
      DOC: Improve the CONTRIBUTING guidelines document
      DOC: Fix typo.
      DOC: Add checklist to PR template.
      ENH: Add a script to update the remote module commit hashes
      ENH: Add a script to update the ITK tag as required in files
      ENH: Update the Remote module Python package version automatically
      STYLE: Rename remote module maintenance script
      DOC: Add Remote module PyPI update notice in Release guide
      ENH: Bump remote modules.
      ENH: Bump remote modules to latest commits
      ENH: Bump remote modules to their latest commits
      COMP: Fix Software Guide line length too long warnings

KWSys Upstream @bradking (2):
      KWSys 2019-02-14 (e270ce9f)
      KWSys 2019-03-28 (e92bdbe8)

Matthew McCormick @thewtex (51):
      ENH: Use HDF5 1.10.4
      DOC: Updates to the README
      DOC: Use 'ITK: The Insight Toolkit' for README title
      ENH: Add legacy multi-frame DICOM MD5 content links
      COMP: Avoid duplicate wrapping of VectorContainer with unsigned short
      BUG: MeshIOBase ivars used for number points, cells, pixels
      STYLE: Keep ProjectObject methods protected in ResampleImageFilter
      STYLE: Remove unnecessary ResampleImageFilter input/output checks
      DOC: Updates to the Release documentation for 5.0 RC 1
      ENH: Update CI ExternalDataVersion to 5.0rc01
      DOC: Add ITK 5 Release Candidate 1 release notes
      ENH: Add regression test for reading legacy multi-frame DICOM
      ENH: Update itk_hdf5_mangle.h for HDF5 1.10.4
      COMP: Re-apply HDF5 Emscripten clobbered by 1.10.4 update
      ENH: Add probot-stale GitHub bot configuration
      ENH: Add test result analysis to Azure Pipelines web interface
      COMP: Set CMP0083 for PIE flags
      COMP: HDF5 CMake does not have INTEGER cache type
      COMP: Do not also pass png_ptr twice to png_set_error_fn
      ENH: Wrap TriangleMeshToBinaryImageFilter
      PERF: Use constexpr in complex NumericTraits
      BUG: VTKPolyDataMeshIO CanReadFile returns false for non-PolyData
      COMP: Set CMP0083 for PIE flags
      BUG: Use VERSION_GREATER_EQUAL for PIE check
      ENH: Bump CMakeLists.txt version to 4.13.2
      ENH: Add missing SHA512 content link
      ENH: Explicitly use Python 3.7 in Azure builds
      COMP: Prevent duplicate wrapping ouput file specification
      BUG: Add executable bit to prefer-type-alias-over-typedef.sh
      COMP: Specify type in LiThresholdCalculator min call
      ENH: Wrap ExtrapolateImageFunction
      ENH: Add Python wrapping for SymmetricEigenAnalysisImageFilter
      BUG: Add missing ITKImageGrid circle.png content links
      BUG: itkResampleImageTest2Streaming verification
      ENH: Add IOScanco remote module
      COMP: Add backwards compatible EnlargeRegionOverBox
      BUG: Set dashboard_do_coverage in Azure configuration
      COMP: Add export specification to ITKSpatialObjects
      BUG: Mark HDF5 CMake variables as advanced
      BUG: Mark INSTALL_GTEST CMake variable as advanced
      STYLE: NIFTI CMake variable spacing
      BUG: Do not use CACHE variables for NIFTI when not required
      BUG: Mark TESTLIB_VCL_WHERE_ROOT_DIR_H as advanced
      BUG: Remove BUILD_* GDCM settings from the cache
      BUG: Remove ALLOW_UNSUPPORTED from the cache
      STYLE: C-style variable declarations in WindowedSinceInterpolateImageFunction
      ENH: Add wrapping for WindowedSincInterpolateImageFunction
      ENH: ITKVtkGlue only requires rendering libraries when needed
      COMP: GaussianInterpolateImageFunction test narrowing
      BUG: Allow Python tests in module test/CMakeLists.txt
      ENH: Add new content links for ITK 5.0 RC 2

MetaIO Maintainers (2):
      MetaIO 2019-01-15 (6efa2b32)
      MetaIO 2019-04-24 (9d2012d1)

Mihail Isakov @issakomi (4):
      BUG: WhatModulesITK.py doesn't detect ITKMeshIO
      STYLE: header included twice, spelling
      BUG: index overflow in BinaryMask3DMeshSource
      BUG: changed to signed

Niels Dekker @N-Dekker (28):
      PERF: Remove SystemInformation data from ResourceProbe, fix issue #350
      COMP: Fix support itk::VectorContainer<TElementIdentifier, bool>
      COMP: Fix SymmetricEigenAnalysis support TMatrix = itk::Array2D<T>
      COMP: Trailing return types (reference, const_reference) VectorContainer
      STYLE: HoughTransform2DCircles, GaussianDerivativeImageFunc member init.
      COMP: Win32Header no longer disable MSVC warning C4800, C4290, C4786
      COMP: Removed unreachable code, fixing VS2017 warning (level 4) C4702
      STYLE: Removed '2' from GaussianDerivativeImageFunction::ImageDimension2
      STYLE: Renamed SpatialFunction within GaussianDerivativeImageFunction
      BUG: Fixes crashes in unit tests when argv[0] == nullptr
      STYLE: Removed InitializeConstShapedNeighborhoodIterator()
      STYLE: ImageFileReader uses std::unique_ptr<[]>, try-catch-throw removed
      STYLE: Renamed array of radii EllipseSpatialObject to RadiiInObjectSpace
      STYLE: Remove GetPixelTypeName() from both Image and Mesh SpatialObject
      ENH: GTest for ImageMaskSpatialObject::GetAxisAlignedBoundingBoxRegion()
      STYLE: Removed unused private EventObject::EventFactoryFunction type
      COMP: Support ITK_LEGACY_SILENT for ThreadInfoStruct
      STYLE: Removed five unused nested types from ImageSpatialObject
      ENH: Add static member function Size<VDimension>::Filled(SizeValueType)
      STYLE: Removed legacy-only ComputeMyBoundingBox() which was not in ITK4
      STYLE: Renamed ProtectedComputeMyBoundingBox() to ComputeMyBoundingBox()
      STYLE: Remove const from SpatialObject::ComputeMyBoundingBox()
      BUG: Fix #734 Incorrect results GetAxisAlignedBoundingBoxRegion() for 2D
      ENH: Extend test ImageMaskSpatialObject::GetAxisAlignedBoundingBoxRegion
      STYLE: SpatialObject GetModifiableMyBoundingBoxInObjectSpace() non-const
      PERF: ImageMaskSpatialObject::GetAxisAlignedBoundingBoxRegion() faster
      ENH: Add explicit constructors Point and FixedArray for C++11 std::array
      ENH: Add begin() and end() to FixedArray, support range-based for-loops

Pablo Hernandez-Cerdan @phcerdan (11):
      ENH: Add itk-module-init.cmake to Eigen3
      COMP: Make ThirdParty Eigen3 COMPILE_DEPENDS
      COMP: Revert "COMP: Make ThirdParty Eigen3 COMPILE_DEPENDS"
      BUG: Fix Eigen3 INSTALL_DIR
      DOC: Update ITK5MigrationGuide
      BUG: Fix OFFIS_DMCTK_VERSION_NUMBER where wrunlock was introduced
      BUG: Fix export for ITKDeprecated classes
      BUG: Do no install any Eigen3 targets if ITK_USE_SYSTEM_EIGEN=ON
      ENH: Update Remote Module IsotropicWavelets
      ENH: Add COMPILE_DEFINITIONS to castxml
      ENH: Add remote module TotalVariation

Roman Grothausmann @romangrothausmann (4):
      ENH: new tests to verify streaming capabilities of itkResampleImageFilter
      BUG: corrected logic for checking that streaming was not used
      ENH: compare outputs of itkResampleImageTest2Streaming to determine success:
      ENH: Stream ResampleImageFilter for linear transforms

Simon Rit @SimonRit (2):
      ENH: add RTK as a remote module
      ENH: added test to check that Matrix returns a copy of the vnl matrix

Stephen R.Aylward @aylward (47):
      ENH: Refactor of SpatialObject top-level class
      ENH: Remove itkAffineGeometryFrame file
      ENH: Update ArrowSpatialObject
      ENH: Children name match using string.find (i.e., any substring)
      ENH: Refined SpatialObject base class and organized .h.  Refactoring.
      ENH: Refactor Line and Landmark Spatial Objects
      ENH: Refactor Mesh and fix bugs found in previous refactorings
      BUG: Remove itkPlaneSpatialObject because it implemented a boxSO
      ENH: Refactor itkPolygon[Group]SpatialObject
      ENH: Refactor Scene to be a Group and refine base SpatialObject
      ENH: Refactoring the SpatialObject to be more intuitive
      ENH: SpatialObjects have "MyBoundingBox" and "FamilyBoundingBox"
      ENH: Resolved SpatialObject member function and variable names
      ENH: Updated subclasses to match SpatialObjectAPI
      ENH: SpatialObjectPoint and Properties updated
      ENH: Removed unwanted TreeNode classes
      ENH: Removing outdated source files
      COMP: SpatialObjectProperties now a cxx file that compiles
      ENH: Refactor SpatialObjectPoints and TubeSpatialObjectPoints
      ENH: Update PolygonGroup IO to use new spatial object classes
      ENH: Refactoring for IO
      ENH: Renamed functions to make coordinate system explicit
      ENH: Refactoring Meta*Converter classes
      ENH: Update to tests to fit new SO API
      BUG: Fixed bugs on windows for tests
      ENH: Updated wrapping and examples to compile SpatialObjects
      ENH: Updated itkGetObjectMcro to itkGetModifiableObjectMacro
      ENH: Updates to fix failing tests
      ENH: Fix two more tests
      BUG: Fix bug in ImageMaskSO bounding box
      ENH: Making tests pass...one bug at a time...
      BUG: Missing center computation in isInside function for Ellipse
      ENH: Adding support for Clone member function to perform a deep copy
      BUG: Last spatial-object-specific tests now pass.
      BUG: Fix const issues regarding My/Family Bounding Box
      BUG: Fix warnings and other minor things
      ENH: Fixing PolygonSpatialObject
      ENH: Made ContourSO and PolygonSO more consistent in logic
      BUG: Fix IsInsideObjectSpace function in PolygonSpatialObject
      BUG: Fix multiple bugs in refactoring of spatial objects
      DOC: SpatialObject docs in migration guide (#630)
      DOC: Detail function change in ImageMaskSpatialObject
      DOC: Specify ITK class alternatives to removed SO member functions
      BUG: Adds RemovePoint() to PointBasedSpatialObjects (#693)
      DOC: PointBasedSpatialObject's PointListType migration docs provided (#652)
      BUG: Adding a consistent Clear() to SpatialObjects (#700)
      DOC: Update recommendation for computing a Boundoing Region in IndexSpace (#699)

Thomas Janvier @T4mmi (1):
      ENH: Add Thickness3D Remote module.

VXL Maintainers (3):
      VNL 2019-03-04 (1e8a027f)
      VNL 2019-03-11 (3d183906)
      VNL 2019-03-22 (d0ff9f72)

Vladimir S. FONOV @vfonov (2):
      MINC 2019-04-23 (44fae20d)
      ENH: fixed build script

Ziv Yaniv @zivy (1):
      BUG: PNGImageIO segfaults on corrupt png.

@maekclena (13):
      BUG: Initialize array with expected number of elements
      BUG: Disable TIFF predictor
      BUG: Python3 compatibility
      ENH: Cleanup python wrapping tests
      ENH: Address review comments
      ENH: Update maintenance script
      BUG: Replace sed by ex for portability
      ENH: fix inconsistencies and clearer output
      ENH: Update remote modules
      BUG: fix gaussian interpolate test
      BUG: Ignore comment lines
      STYLE: Visually indent array
      BUG: Remove outdated class declaration
```
