ITK Release 4.6
===============

New Documentation

------------------------------------------------------------------------

Our documentation continues to improve. Remote modules are now grouped
in the Doxygen Module page \[1\]. A number of new examples were added to
the Sphinx repository and the Wiki, which can now also be build as
Remote modules. The Software Guide was split into two books and
configure and build instructions were revised.

\[1\] <https://docs.itk.org/projects/doxygen/en/v4.6.0/modules.html>

New Features

------------------------------------------------------------------------

-   CMake improvements

` - Improved Remote Module support`\
` - Add ITK_FORBID_DOWNLOADS for package maintainers`\
` - ITK_USE_SYSTEM_EXPAT available`

-   Filtering Improvements

` - Moved TransformToDisplacementField out of Review`\
` - An entire noise image generation module`\
`   - `[`https://hdl.handle.net/10380/3158`](https://hdl.handle.net/10380/3158)\
` - Better pipeline support for ResampleImageFilter`\
` - Move MagnitudeAndPhaseToComplexImageFilter out of Review`\
` - Setters for LabelMap overlay filters`\
` - More consistent filter progress reporting`

-   ImageIO improvements

` - Register the GE image formats by default`\
` - More IO modules are built as shared libraries`\
` - OpenFileForReading/Writing methods in ImageIO`\
` - Support for system tiff 4.0.0-4.0.2 (e.g. some Ubuntu versions)`\
` - Mangling to internal OpenJPEG`\
` - SCIFIO improvements`

-   Infrastructure improvements

` - MetaDataObject print specialization for common types`\
` - Improvements to ResourceProbe and RealTimeClock`\
` - More Solve methods for VNLSparseLUSolverTraits`\
` - Output stream operator for LightObject exposed`\
` - FFTW bump to 3.3.3`

-   New Remote Modules

` - Skull stripper`\
`   - `[`https://hdl.handle.net/10380/3353`](https://hdl.handle.net/10380/3353)\
` - Wiki examples`\
` - Sphinx examples`\
` - Variational registration`\
`   - `[`https://hdl.handle.net/10380/3460`](https://hdl.handle.net/10380/3460)\
` - AnalyzeObjectMapIO`\
`   - `[`https://hdl.handle.net/1926/593`](https://hdl.handle.net/1926/593)\
` - FDFImageIO`\
` - SplitComponents`\
`   - `[`https://hdl.handle.net/10380/320`](https://hdl.handle.net/10380/320)

-   Registrationv4 improvements

` - v4 regular step gradient descent optimizer`\
` - v4 amoeba optimizer`\
` - v4 exhaustive optimizer`\
` - v4 Powell optimizer`\
` - v4 one-plus-one-evolutionary optimizer`\
` - v4 LBFGS optimizer improvements`\
` - Use registration method classes as pipeline filters`

-   Performance improvements

` - Registrationv4`\
` - Histogram computation`\
` - Improved SmartPointer copy`\
` - CompositeTransform`\
` - Registration Jacobian re-use`

-   Wrapping improvements

` - pygccxml 1.0.0`\
` - .pth symlink usable in a virtualenv`\
` - Cleaner CMake configuration`\
` - SWIG and PCRE updated to 3.0.2, 8.34`\
` - Latest GCCXML, which works with GCC 4.9`\
` - Sweeping wrapping generation cleanup`\
` `

-   Many style improvements -- ITK gets more stylish with every release!

<!-- -->

-   Improved code coverage -- some measures put us over 85%!

<!-- -->

-   -   Lots\* of important bug fixes

List of changes since v4.6rc03

------------------------------------------------------------------------

Arnaud Gelas (1):

`     DOC: ThresholdBetween does not exist, it should be ThresholdOutside`

Bradley Lowekamp (6):

`     BUG: Remove division in inner loop for otsu threshold calculator`\
`     COMP: Fix implicit conversion warnings`\
`     BUG: Print the histogram calculator for auto threshold filter`\
`     BUG: Use tolerant float compare when choosing better otsu threshold`\
`     BUG: Fix out of bounds access for image region size`\
`     BUG: Add export specification to DCMTKFileReader and utilities`

Luis Ibanez (1):

`     BUG: Increased OtsuThreshold computation precision`

Matthew McCormick (13):

`     COMP: Remove unused local typedef's.`\
`     COMP: Make Doxygen Modules group definition consistent.`\
`     STYLE: Improve readability and const correctness of ImageIORegion.`\
`     BUG: GDCM does not apply rescale slope / intercept on write.`\
`     COMP: Ignore itkIndex.h -Warray-bounds warnings on GCC 4.9.`\
`     COMP: Remove unused typedefs in ITKReview module.`\
`     COMP: Remove unused FFTW typedef's.`\
`     COMP: Remove unused typedefs from the Examples.`\
`     COMP: Remove unused typedefs in compatibility code.`\
`     BUG: Fix GDCM buffer size when written pixel type is different.`\
`     COMP: Disable array above bounds warnings in FixedArray for GCC 4.9.`\
`     BUG: Increase itkVoronoiPartitioningImageFilterTest1 for 32-bit builds.`\
`     BUG: Set output type to unsigned char when writing uchar in GDCMIO test.`

Michka Popoff (3):

`     BUG: Fix GeodesicActiveContourImageFilterOutput7.png`\
`     STYLE: Threshold Segmentation LevelSet Image Filter Figure`\
`     ENH: Remove GeodesicActiveContourImageFilter.py example`

List of changes since v4.6rc02

------------------------------------------------------------------------

Ali Ghayoor (1):

`   ENH: Convert seven ImageRegistration examples to ITKv4`

Bradley Lowekamp (2):

`   BUG: Remove multiple per-pixel allocations in Mahalanobis Membership`\
`   COMP: Fix unused-local-typedef warnings in the Registration and Numeric`

Hans Johnson (1):

`   ENH: Prepare for ITKv4 registration Examples`

Matthew McCormick (5):

`   BUG: Improve module Group membership detection.`\
`   COMP: Fix unused-local-typedef warnings in Group Core.`\
`   BUG: Update TransformReadWrite example.`\
`   COMP: Fix unused-local-typedef warnings in the Filtering Group.`\
`   COMP: Remove unused typedefs.`

Nick Tustison (1):

`   ENH:  Missed spec for generic computation type.`

List of changes since v4.6rc01

------------------------------------------------------------------------

Bradley Lowekamp (3):

`     BUG: Do not ENABLED_SHARED for GDCMIO`\
`     DOC: Add break in brief description of Canny edge filter`\
`     BUG: Add additional MetaDataObject explicit instantiation.`

Jean-Christophe Fillion-Robin (2):

`     COMP: Fix `“`unused-local-typedefs`”` warnings`\
`     COMP: Fix `“`unused-local-typedefs`”` warning in LandmarkBasedTransformInitializer`

Kent Williams (1):

`     COMP: Fix typo in ReflectiveImageRegionConstIterator.`

Matthew McCormick (4):

`     DOC: CMake warning BRANWEB -> BRAINWEB.`\
`     BUG: Remove -Wno-unused-local-typedefs flag.`\
`     COMP: Fix IOSTL Doxygen group and Windows shared build.`\
`     BUG: Use Remote repository explicitly on git fetch.`

Michka Popoff (6):

`     COMP: Move itkMatrixCoefficients wrapping to Filtering module`\
`     COMP: Fix wrapping with Core only`\
`     STYLE: Pep8 cleanup for generators`\
`     COMP: Fix default wrapping with all modules`\
`     ENH: Use open() instead of file() for python 3 compatibility`\
`     ENH: Allow to use methods which pass std::string by reference from python`

Nick Tustison (1):

`     ENH:  Adding generic computation type.`

List of changes since v4.5.0

------------------------------------------------------------------------

Alexander Schmidt-Richberg (1):

`     ENH: Added *.remote.cmake for remote module VariationalRegistration`

Ali Ghayoor (22):

`     ENH: Add a registration test for LBFGS-B optimizer`\
`     ENH: Add versorTransformOptimizerv4 class to ITKv4`\
`     BUG: Fix Coverity defects for LBFGS-B tests`\
`     BUG: avoid division by zero in versorOptimizerv4`\
`     ENH: Add RegularStep gradient optimizer to ITKv4`\
`     DOC: The use of VersorTransformOptimizerv4 is deprecated.`\
`     ENH: [SG]et optimizable params ITKv4 registration`\
`     ENH: remove VersorTransformOptimizerv4 from ITKv4`\
`     ENH: Add AmoebaOptimizerv4 to ITKv4 registration`\
`     ENH: Add ExhaustiveOptimizerv4 to ITKv4 registration`\
`     ENH: Add PowellOptimizerv4 to ITKv4 registration`\
`     BUG: define the GetStopConditionDescription as a public member funciton`\
`     ENH: Add OnePlusOneEvolutionaryOptimizerv4 to ITKv4 registration`\
`     BUG: lbfgsb optimizer could not be used in unbounded mode`\
`     ENH: Add GetCurrentIteration to ExhaustiveOptimizerv4`\
`     ENH: Add currentIteration to the AmoebaOptimizerv4`\
`     PERF: Move the currentIteration to optimizersv4 base class`\
`     ENH: Move the NumberOfIterations to the Optimizersv4 base class`\
`     PERF: Change the parent class of RegularStepGradDescentv4 optimizer`\
`     ENH: Add currentIteration to LBFGSBOptimizerv4`\
`     BUG: Fix memory leak in LBFGSBOptimzierv4`\
`     ENH: Add distance vector to KdTree search API`

Bill Lorensen (32):

`     BUG: Tiff compression was broken and untested`\
`     ENH: Add SetJPEGQuality method`\
`     COMP: Missing breaks in swithc`\
`     COMP: Uninitialized scalar field`\
`     COMP: Uninitialized scalar field`\
`     COMP: Unused pointer value`\
`     ENH: Add SkullStrip Remote Module`\
`     BUG: Tiff compression was broken and untested`\
`     COMP: Missing breaks in swithc`\
`     ENH: Improved message for missing IO factories`\
`     COMP: Remove vcl_time and vcl_clock`\
`     ENH: Remove vcl_math calls`\
`     COMP: std::abs integral overloads not always provided`\
`     COMP: Array versus singleton access`\
`     COMP: Failed to check dynamic_cast results`\
`     STYLE: Empty lines exceed 3`\
`     COMP: Uninitialized member data`\
`     BUG: Two tests try to write the same file`\
`     ENH: Uninitialized scalar field`\
`     COMP: Constructor initialize list improvement`\
`     COMP: Type warnings in constructors`\
`     BUG: Copy/paste error`\
`     COMP: Arguments of wrong type`\
`     BUG: Buffer not null terminated`\
`     BUG: Dereference after null check`\
`     BUG: Division or modulo by zero`\
`     ENH: Uninitialized scalar field`\
`     BUG: Uninitialized scalar field`\
`     BUG: Not restoring ostream format`\
`     ENH: Add an exception safe state restore class for streams`\
`     BUG: Not restoring ostream format`\
`     ENH: Add WikiExamples as a remote module`

Brad King (4):

`     COMP: Remove extra calls to cmake_minimum_required`\
`     COMP: Fix cmake_minimum_required call order`\
`     COMP: Set CMake Policies CMP0025 and CMP0042 as necessary`\
`     COMP: Add missing call to cmake_minimum_required`

Bradley Lowekamp (91):

`     ENH: Removed non-work TCL Examples`\
`     DOC: Add missing const in Doxygen GetConstReferenceMacro`\
`     BUG: Correctly re-throw exception to restore AbortEvent, ProcessAborted`\
`     BUG: Emit StartEvent before a ProgressEvent`\
`     BUG: Do not throw exception in Probes with mis-matched Stop`\
`     BUG: Correctly re-throw exception to restore AbortEvent, ProcessAborted`\
`     BUG: Adding export specification to Exception objects`\
`     COMP: fix unused variable warning in abort test`\
`     BUG: Adding export specification to Exception objects`\
`     COMP: fix failing voronoi segmentation tests`\
`     COMP: Remove explicit typed exception specifications`\
`     ENH: Print Object name for observers of objects`\
`     ENH: Adding progress reporting to some filters`\
`     BUG: fixing grind peak progress to reach 1.0`\
`     COMP: use std::transform with static_cast to avoid conversion warning`\
`     BUG: disable ipa-cp-clone in GDCM`\
`     COMP: fix unused variable warning in abort test`\
`     BUG: Do not throw exception in Probes with mis-matched Stop`\
`     BUG: Address Shared Library issues with SCIFIO`\
`     COMP: fix failing voronoi segmentation tests`\
`     COMP: export required in explicitly defined NumbericTraits consts`\
`     DOC: Make comment the Doxygen brief`\
`     BUG: Adding missing raw data file to MINC test`\
`     BUG: Fix linkage for SmartPointerForwardReference for clang 4`\
`     BUG: Fixing missing char type and doc for Thresholding filters`\
`     BUG: Add support for system libtiff 4.0.0-4.0.2`\
`     BUG: remove second wrapping of BinShrink for scalars`\
`     BUG: Fix LabelStatistics and LabelOverlap to require same image size`\
`     PERF: Remove IncreaseFrequencyOfMeasurement from inner loops`\
`     STYLE: Save deference iterator mapped type to variable`\
`     PERF: switch to scanline and linear iterators`\
`     COMP: Fix checks for system libtiff`\
`     PERF: add namespace swap to SmartPoitners`\
`     PERF: Use stl iterator algorithm in Iterator Partitioner`\
`     BUG: Add mutex lock to MersenneTwister GetInstance`\
`     STYLE: MersenneTwister move methods to cxx, docs`\
`     STYLE: renaming files to standard ITK conventions`\
`     ENH: Improving Noise Simulation Filters`\
`     COMP: Explicitly make constant an unsigned int`\
`     BUG: Fix uninitialized ivar in NoiseBaseImageFilter`\
`     ENH: Make NoiseBaseImageFilter an abstract base class`\
`     COMP: remove extraneous cast to double`\
`     BUG: Same test function in different file causes conflict`\
`     ENH: Explicitly specify internal linkage for internal observer objects`\
`     ENH: Enable observed events to modify observers`\
`     BUG: Catch exception in DeleteEvent`\
`     STYLE: dynamic_cast to pointer does not throw`\
`     COMP: Fix GCC warning about unused typedef in ConceptChecking`\
`     COMP: Adding itkMacro.h for ITK_NULLPTR definition`\
`     ENH: Use DynamicCastInDebugMod for name input macros`\
`     BUG: Add support for signed char output`\
`     BUG: Use NewMacro for Clone with TimeVaryingVElocityFieldTransforms`\
`     ENH: Improve DataObjectDecorator with Modifiable, Graft ReleaseData`\
`     ENH: Improve Resample's use of pipeline inputs`\
`     ENH: Adding output of line and file on test failure`\
`     ENH: Add InitialTransform as pipelined input with inplace option`\
`     ENH: Use Transform base class as default template parameter`\
`     ENH: Use InitialTransform in deformation examples`\
`     COMP: add missing stl algorithm header for std::max`\
`     COMP: add missing stl algorithm header for std::max`\
`     Revert `“`ENH:`` ``Add`` ``Remote`` ``module`` ``group`` ``description`` ``to`` ``Doxygen.`”\
`     COMP: Remove incorrect override declaration`\
`     ENH: Encapsulate expat header`\
`     ENH: Make IntialMoving and InitialFixed transforms decorated inputs`\
`     ENH: Update SimpleRegistration test`\
`     BUG: Don't create new Decorator in GenerateData`\
`     BUG: Use referenceImage for output information`\
`     ENH: Adding some ImageIO libraries as shared`\
`     ENH: Use TransformParametersAdaporBase on Transform base class`\
`     ENH: Removing const_casts from ImageRegistrationv4 tests`\
`     BUG: Add AllocateOutputs method to other v4 RegistrationMethods`\
`     ENH: Update v4 registration tests to set initial transform`\
`     BUG: Explicitly instantiate common MetaDataObjects`\
`     BUG: Disable explicit visibility with OSX gcc  and llvm gcc 4.2`\
`     ENH: Register GE Image formats`\
`     COMP: Fix warning for overloading AllocateElements`\
`     COMP: Suppress warning for using extern template instantiation`\
`     PERF: Use shallow swap over deep assignment`\
`     ENH: Use LearingRate member variable for scaling gradient`\
`     ENH: support learning rate estimation for regular step optimizer`\
`     COMP: Add space between string literals`\
`     ENH: remove catch as dynamic_cast of pointers is nothrow`\
`     BUG: Use rounding in TestingStretchIntensity for portability`\
`     BUG: Warn if unsupported ITK_BRAINWEB_DATA_ROOT is being used`\
`     ENH: Use MultiResolutionIteration event for registration`\
`     ENH: Use exception safe copy-and-swap for assignment`\
`     BUG: Use DEPENDS for dependent files`\
`     STYLE: Add itkPrintSelfObjectMacro to improve indenting`\
`     BUG: Print missing member variables`\
`     ENH: Make more IO modules shared.`\
`     COMP: Add missing header for EXIT_FAILURE`

Brian Helba (66):

`     ENH: Disable tip to enable Uncrustify from SetupForDevelopment`\
`     STYLE: Rename TValueType template parameters to TValue`\
`     COMP: Fix compiler warnings with ITK_USE_SYSTEM_VXL`\
`     BUG: Make all specializations NumericTrails::SetLength re-zero contents`\
`     ENH: 3048, 3224: Refactor *SampleFilters to fix multiple issues`\
`     ENH: Re-enable the array-bounds warnings for GCC 4.7`\
`     DOC: Fix a bug with SquaredEdgeLengthDecimationQuadEdgeMeshFilter`\
`     DOC: Clean up comments in NiftiImageIO, for better Doxygen compatibility`\
`     STYLE: Remove unused typedefs from AlgorithmsPrintTests`\
`     BUG: Fix improper usage of VoronoiSegmentationRGBImageFilter`\
`     ENH: Move OpenFileForReading/Writing from StreamingImageIO to parent class`\
`     ENH: Improve OpenFileForReading/Writing logic and documentation`\
`     BUG: Prevent ObjectFactoryBase from possibly throwing an exception`\
`     STYLE: Make internal-use CMake variables lowercase in KWStyle.cmake`\
`     PERF: Prevent FindKWStyle.cmake from being called multiple times`\
`     BUG: Fix FindKWStyle crash when kwstyle returns empty version info`\
`     BUG: Fix Coverity issue 1081600: Use after free`\
`     BUG: Update SmoothingRecursiveYvvGaussianFilter to fix CMake warnings`\
`     ENH: Update ImageIO classes to use OpenFileForReading/Writing`\
`     COMP: Fix array subscript build warning`\
`     COMP: Except Git's status messages from CTest reporting`\
`     COMP: Suppress Coverity defect when Examples create an ITK object`\
`     BUG: Fix uninitialized variable in GradientRecursiveGaussianImageFilter`\
`     DOC: Fix documentation in VoronoiDiagram2DGenerator`\
`     BUG: Coverity 1081062: Fix big parameter passed by value`\
`     BUG: Update IOSTL to include new bug fixes upstream`\
`     DOC: Improve documentation for StatisticsAlgorithm functions`\
`     BUG: Coverity 1130670: Buffer not null terminated in GE4ImageIO`\
`     BUG: Coverity 1103200: Copy into fixed size buffer in GE5ImageIO`\
`     STYLE: Coverity 1080839: Dead default in switch in QuadEdgeMeshEulerOperatorJoinVertexTest`\
`     STYLE: Coverity 1080963: Dereference after null check in TreeIteratorBase`\
`     BUG: Coverity 1081009: Missing break in switch in GiftiMeshIO`\
`     BUG: Coverity 1081422: Uninitialized pointer field in QuadEdgeMeshFrontBaseIterator`\
`     STYLE: Coverity 1081140: Dereference before null check`\
`     BUG: Coverity 1081547: Uninitialized pointer field in ConnectedRegionsMeshFilter`\
`     STYLE: Coverity 40ee44a9: Self assignment in VoronoiSegmentationImageFilterTest`\
`     BUG: Coverity 1081129: Dereference before null check in itkIOCommonTest`\
`     COMP: Update libminc from upstream, fixing a compiler warning on OSX`\
`     BUG: Coverity 1081019: Improper use of negative value in StringTools`\
`     COMP: Fix downcast warnings`\
`     BUG: Coverity 1103189: Big parameter passed by value in FindSampleBound`\
`     COMP: Fix implicit conversion warning`\
`     COMP: Fix unused variable warning on Intel compilers`\
`     BUG: Fix uninitialized variable in GradientRecursiveGaussianImageFilter`\
`     BUG: Make all specializations NumericTrails::SetLength re-zero contents`\
`     BUG: Update SmoothingRecursiveYvvGaussianFilter remote module`\
`     BUG: Update SplitComponents remote module`\
`     COMP: Fix implicit conversion warning`\
`     BUG: Update SmoothingRecursiveYvvGaussianFilter remote module`\
`     COMP: Update LesionSizingToolkit remote module from upstream`\
`     STYLE: Coverity 1103618-1103620: Structurally dead code`\
`     STYLE: Coverity 1081585: Structurally dead code`\
`     STYLE: Coverity 1081584: Structurally dead code`\
`     STYLE: Coverity 1081583: Structurally dead code`\
`     STYLE: Coverity 1081580: Structurally dead code`\
`     STYLE: Coverity 1081570-1081578: Structurally dead code`\
`     STYLE: Coverity 1081566-1081568: Structurally dead code`\
`     STYLE: Coverity 1081564: Structurally dead code`\
`     STYLE: Coverity 1080826-1080827: Logically dead code`\
`     STYLE: Coverity 1080862: Logically dead code`\
`     STYLE: Coverity 1081598: Unused pointer value`\
`     BUG: Coverity 1103595: Uninitialized pointer field`\
`     BUG: Coverity 1081508: Uninitialized pointer field`\
`     BUG: Fix uninitialized pointer fields`\
`     BUG: Coverity 1081381: Uninitialized scalar field`\
`     STYLE: Coverity 1103107-1103116: Logically dead code`

Constantine Zakkaroff (1):

`     DOC: HelloWorld Comments Edit for ITKSoftwareGuide`

David Cole (2):

`     COMP: Eliminate some level 4 warnings`\
`     BUG: Add missing header files to enable try_run tests to run without crashing`

Dirk Padfield (2):

`     DOC: Improved comments and reorganized code for IsolatedConnected`\
`     DOC: Corrected documentation for threshold boundaries.`

Eric Greveson (1):

`     ENH: Add setters for the overlay functor in labelmap overlay filters.`

Fotis Drakopoulos (1):

`     ENH: Adding GetFEMFilter method to PhysicsBasedNonRidgidRegistrationMethod.`

GCC-XML Upstream (1):

`     pygccxml 1.0.0 (reduced)`

Gaëtan Lehmann (1):

`     ENH: Importing files from Noise Simulation Article`

Gib Bogle (1):

`     BUG: Windows BigTIFF errors: stat failure and lack of COMPRESSION_DEFLATE`

Google double-conversion Maintainers (1):

`     COMP: Google double-conversion (reduced)`

Guillaume Pasero (1):

`     ENH: Add mangling to internal OpenJpeg`

Hans Johnson (40):

`     PERF: 15% speed improvement for registration`\
`     PERF: Simplify conditionals in loop`\
`     COMP: Conditional assert check warning unused var.`\
`     COMP: SimpleITK linkage failure`\
`     BUG: Missing Modified() call`\
`     COMP: SimpleITK linkage failure`\
`     BUG: Element numbers 1053, 1052 not hex`\
`     BUG: Remove valgrind reported leak`\
`     BUG: Add missing transform types to factory`\
`     BUG: Missing Modified() call`\
`     PERF: Reviewing code for facilitating compiler optimizations`\
`     COMP: Fix const constructor for const arrays`\
`     ENH: Add LBFGOptimizerv4(for BSPline registration)`\
`     COMP: Test failure from numerical precision`\
`     BUG: Memory leak introduced.`\
`     COMP: Remove deprecated 'register' keyword`\
`     ENH: Ignore autocompletion clang helper files`\
`     ENH: Move to latest remote module tag`\
`     STYLE: Improve testing of member Get/Set functions`\
`     COMP: Update AnalyzeObjectMapIO replacing deprecated`\
`     DOC: Fixed documentation regarding multi-threading`\
`     DOC: Improved Image Representation`\
`     PERF: Minimize redundant function calls`\
`     PERF: Pull loop termination constants out of loop`\
`     ENH: Refactoring the CompositeTransform class`\
`     STYLE: Explicitly declare virtual for derived class member functions`\
`     STYLE: Explicitly recognize virtual functions`\
`     STYLE: Add ITK_NULLPTR supporting c++11 checks`\
`     BUG: Missing parentheses for logic comparison`\
`     STYLE: Explicitly declare virtual (cont. of 1c8609)`\
`     STYLE: Consistency of threadID and threadId`\
`     BUG: FFTConvolutionImageFilter outputs incorrect`\
`     STYLE: GetStopConditionDescription abstract method`\
`     PERF: Re-use jacobian rather than instantiation`\
`     ENH: Improve test in preparation for performance testing`\
`     PERF: Code simplifications for performance testing`\
`     BUG: Missed an API change for Allocate`\
`     STYLE: Remove unnecessary comments.`\
`     BUG: Expose unusable functions`\
`     BUG: Incomplete refactoring of member variable name`

Jean-Christophe Fillion-Robin (1):

`     COMP: Fix `“`unused-local-typedefs`”` warnings`

Jens Wetzl (2):

`     BUG: Fix race conditions in itkInvertDisplacementFieldImageFilter`\
`     STYLE: Incorporated reviewer suggestions`

Jon Haitz Legarreta (8):

`     ENH: New test for itkSigmoidTransferFunction.`\
`     COMP: Fix type casting build warning.`\
`     ENH: New test for itkLogSigmoidTransferFunction`\
`     ENH: Added call to Print() method`\
`     STYLE: Changed LogSigmoidTransferFunction template argument names.`\
`     ENH: Added StatisticsRelabelImageFilterTest to testing`\
`     BUG: Fix issues with the BinaryStatisticsOpeningImageFilter test`\
`     COMP: Test for itkCustomColormapFunction`

Kent Williams (13):

`     ENH: Add remote module for AnalyzeObjectMapIO`\
`     BUG: incorrect loop var increment`\
`     COMP: Update the DoubleConversion library upstream update script.`\
`     ENH: Turn off DCMTK Logger messages by default`\
`     COMP: fixed license test command in UpdateDoubleConversionFromGoogle.sh`\
`     ENH: Add FDFImageIO as a remote module.`\
`     PERF: replace image allocate followed by fillbuffer with allocate(true)`\
`     COMP: Add test to verify Slope/Intercept handling`\
`     BUG: GDCM reporting wrong spacing for some Media Types`\
`     ENH: Add test for itkTestingStretchIntensityImageFilter`\
`     COMP: Fix misplaced closing brace`\
`     ENH: Remove try/catch exception handling around dynamic_catch`\
`     ENH: Disallow vector multiply by itself`

Liza Shrestha (1):

`     COMP: Added new unit tests for increasing code coverage`

Luis Ibanez (11):

`     ENH: Add STLMeshIO remote module.`\
`     BUG: Fixed module name IOSTL.`\
`     COMP: Fixing instantiation of templated functions.`\
`     BUG: Fixed Affine test 32bits. Precision checks.`\
`     PERF: Accelerate initialize via selective testing.`\
`     COMP: ShapeUniqueLabelMapFilter test was missing.`\
`     STYLE: Coverity 1103119: Logically dead code`\
`     BUG: itkLoggerThreadWrapper test was disabled.`\
`     BUG: No DiscreteHessianGaussianImageFunctionTest.`\
`     BUG: DiffusionTensorReconstruction lacked Progress`\
`     BUG: TestingExtractSliceImageFilter lacked test.`

Luke Bloy (4):

`     BUG: Fixes itkBoxSpatialObject part of issue ITK-3153`\
`     BUG: Fixes itkImageMaskSpatialObject part of issue ITK-3153`\
`     BUG: Fixes itkBoxSpatialObject part of issue ITK-3153`\
`     BUG: Fixes itkImageMaskSpatialObject part of issue ITK-3153`

Marius Staring (2):

`     ENH: add reset function to resource probe`\
`     ENH: adding handle to RealTimeClock`

Mark Hiner (1):

`     ENH: bump to latest scifio-imageio`

Martin Steghöfer (1):

`     BUG: Match behavior of SimpleFastMutexLock on different platforms (#ITK-3248)`

Matthew McCormick (93):

`     ENH: Bump CMakeLists.txt to version 4.6.0.`\
`     BUG: Remove unused itkAffineTransformXX.txt content links.`\
`     BUG: Avoid SimpleImageRegistration{Float,Double}Test output clobbering.`\
`     BUG: Prevent MINC transform tests outputs from clobbering.`\
`     BUG: Add random number generator seed for vnl_algo_test_sparse_lm.`\
`     COMP: Update libminc to latest version.`\
`     ENH: Only build tests for modules explicitly enabled.`\
`     BUG: Remove unused forward declarations in RegistrationMethodsv4.`\
`     COMP: Update libminc to latest version.`\
`     ENH: Add REQUIRES_DISPLAY CTest label.`\
`     ENH: Add SplitComponents Remote Module.`\
`     DOC: Suggest MeshFileReader instead VTKPolyDataReader.`\
`     DOC: Add itkSetGetDecoratedInputMacro definition for Doxygen.`\
`     COMP: Bump DCMTK to fix warning.`\
`     BUG: Wrap TransformFileReader, TransformFileWriter.`\
`     BUG: Remove unused itkAffineTransformXX.txt content links.`\
`     COMP: Wrap OptimizerParameterScalesEstimatorTemplate.`\
`     COMP: CommandIterationUpdate has field whose type uses anonymous namespace.`\
`     COMP: Do not use -fno-ipa-cp-clone with clang.`\
`     ENH: Move TransformToDisplacementFieldSource out of Review.`\
`     ENH: Bump ITK version to 4.5.1.`\
`     COMP: ImageRegistrationHistogramPlotter Clone never referenced.`\
`     ENH: Add the ITK_INSTALL_LIBRARY_DIR to WrapITK.pth.`\
`     ENH: Bump SCIFIO to add wrapping.`\
`     COMP: ImageRegistrationHistogramPlotter unchecked dynamic_cast.`\
`     BUG: Fix Array memory leaks with non-const construction.`\
`     BUG: Prevent ambiguous Array construction methods.`\
`     COMP: HDF5 library version variables contain '@'.`\
`     COMP: Remove add_custom_command(SOURCE...`\
`     COMP: Wrap OptimizerParameterScalesEstimatorTemplate.`\
`     BUG: Wrap TransformFileReader, TransformFileWriter.`\
`     COMP: Add missing itkVerson.h header.`\
`     COMP: LBFGSOptimizerBasev4 explicit Doxygen link request.`\
`     ENH: Bump FFTW to 3.3.3.`\
`     COMP: Duplicated VectorContainer wrapping for real types.`\
`     BUG: Increase tolerance for itkFEMC0TriangularElement-NodalLoads-BCs`\
`     STYLE: Add missing `“`Test`”` to GDCM test names and filenames.`\
`     DOC: No ReferenceImage members in TransformToDisplacementFieldSource.`\
`     COMP: Bump LesionSizingToolkit for Doxygen warnings.`\
`     BUG: GDCM Series does not write z-spacing.`\
`     COMP: Remove unreachable return statements.`\
`     ENH: Add ITK_FORBID_DOWNLOADS option. ITK-3239`\
`     COMP: Bump SplitComponents Remote for Doxygen warnings.`\
`     COMP: return will never be executed after exception thrown.`\
`     BUG: Invalid read during ImageIOBase SetDirection.`\
`     COMP: Fix failed itkTIFFImageIOCompressionTest merge.`\
`     ENH: Bump version to 4.5.2.`\
`     COMP: return will never be executed after exception thrown.`\
`     COMP: SigmoidTransferFunction conversion from double.`\
`     BUG: BoxImageFilter GenerateInputRequestRegion public -> protected.`\
`     DOC: KernelImageFilter does not reimplement GenerateInputRequestedRegion.`\
`     STYLE: Remove SigmoidTransferFunction .hxx doxy comments.`\
`     BUG: Clean up Python module2module test.`\
`     BUG: TestingExtractSliceImageFilterTest v3 direction strategy.`\
`     STYLE: Remove duplicated TestingExtractSliceImageFilter doxygen.`\
`     COMP: Use latex formula for HoughTransform doxygen.`\
`     COMP: SigmoidTransferFunction members Alpha, Beta real type.`\
`     STYLE: Fix SigmoidTransformFunction template argument names.`\
`     COMP: BuildHeaderTest.py print_function import.`\
`     BUG: Fix print function errors in pygccxml.`\
`     BUG: Fix print functions in igenerator.py.`\
`     ENH: Add Remote module group description to Doxygen.`\
`     STYLE: Clean up MetaDataObjectBase.`\
`     STYLE: Clean up MetaDataObject.`\
`     ENH: Add unit test for MetaDataObject.`\
`     ENH: Add MetaDataObject Print specialization for common types.`\
`     STYLE: Fix template statements in SigmoidTransformFunction.`\
`     BUG: Remove public MetaDataObject constructors.`\
`     BUG: Add missing private copy constructors to MetaDataObject.`\
`     BUG: Remove FEMRegistrationFilter debug code.`\
`     DOC: Improve documentation and types for SplitRequestedRegion.`\
`     Revert "Revert `“`ENH:`` ``Add`` ``Remote`` ``module`` ``group`` ``description`` ``to`` ``Doxygen.`”`"`\
`     DOC: Remove errant `“`+`”` in Remote_documentation.`\
`     ENH: For shared libraries when wrapping.`\
`     ENH: Collect all wrapping configuration checks in one place.`\
`     ENH: Better CMake defaults with wrapping.`\
`     ENH: Replace CSWIG preprocessor definition with ITK_WRAPPING.`\
`     BUG: Remove old itkSampleBuildTest.cmake.in file.`\
`     ENH: Move MagnitudeAndPhaseToComplexImageFilter out of Review.`\
`     COMP: Fix Doxygen warnings in itkMetaDataObject.h.`\
`     BUG: Exclude Remote Modules the default ON Group values.`\
`     COMP: Documentation CMake target must come before add_custom_command.`\
`     BUG: Assign Remote modules to groups more robustly.`\
`     BUG: Remove MagnitudeAndPhaseWriteComplexImageFilter test from Review Module.`\
`     BUG: Remove old tests from Review for classes that have been removed.`\
`     DOC: Fix Software Guide LaTeX syntax errors in the examples.`\
`     COMP: Define ITKCommon_EXPORT_EXPLICIT for Doxygen.`\
`     COMP: Remove itkImageReadComplexWriteMagnitudeAndPhaseTest.cxx from list.`\
`     BUG: Move MagnitudeAndPhaseToComplexImageFilter to the ImageIntensity module.`\
`     COMP: StdStreamStateSave Doxygen include.`\
`     ENH: Add Sphinx examples as a Remote Module.`\
`     BUG: Remove ITK_INSTALL_NO_LIBRARIES and ITK_INSTALL_NO_DEVELOPMENT.`\
`     ENH: Make ITK_WRAPPING INTERNAL.`

Matthew Woehlke (1):

`     COMP: Fix egregious -Wcast-qual warnings`

Michka Popoff (53):

`     BUG: Fix for the WrapITK.pth destination path`\
`     COMP: Fixes the Python wrapping under OS 10.8.5`\
`     STYLE: Removed itkExtras folder`\
`     BUG: Fix for the WrapITK.pth destination path`\
`     COMP: Fixed itkQuasiNewtonOptimizerv4 wrapping warnings`\
`     STYLE: 4 space indentation for python files`\
`     COMP: Fixed itkGradientDescentOptimizerv4 wrapping warnings`\
`     STYLE: Removed deprecated itk functions`\
`     STYLE: Removed unused and misplaced python tests`\
`     STYLE: Removed legacy python importing`\
`     STYLE: Pep8 cleanup for the python files`\
`     STYLE: Remove deprecated python strel function`\
`     COMP: Fixed itkQuasiNewtonOptimizerv4 wrapping warnings`\
`     COMP: Fixed itkGradientDescentOptimizerv4 wrapping warnings`\
`     ENH: Use python warnings module for template warnings`\
`     COMP: Duplicated wrapping for double in Array2D`\
`     COMP: Update SWIG to 2.0.12`\
`     COMP: Require at least Python 2.6 for Python wrapping`\
`     ENH: Remove python dl dependency`\
`     ENH: Remove psyco import`\
`     COMP: Update PCRE to 8.34`\
`     ENH: Update Swig to 3.0.0`\
`     STYLE: Remove WrapITK versions`\
`     COMP: Remove cmp0011 in wrapping`\
`     COMP: Remove unused code in ConfigureWrapping.cmake`\
`     COMP: Remove clrLine in itkExtras`\
`     COMP: Fix the python import and progress callbacks`\
`     STYLE: Remove reference to CableSwig`\
`     STYLE: Clean up BinaryThresholdImageFilter (python)`\
`     COMP: Fix the Python ResampleImageFilter test`\
`     ENH: Bump SCIFIO for OS X installation`\
`     ENH: Bump SCIFIO for OS X installation`\
`     COMP: Update PCRE to 8.35`\
`     STYLE: Remove unused compile all code for Python Wrapping`\
`     ENH: Replace python print with print() function`\
`     STYLE: Remove deprecated Python wrapping macros`\
`     COMP: Fix failing header test`\
`     COMP: Fix the writing of .idx files`\
`     COMP: Fix python print import for .pth file creation`\
`     COMP: Fix print import statement in itkExtras.py`\
`     STYLE: Refactor swig call and code cleanup`\
`     COMP: Fix for wrapping warnings (RealTimeClock and SimpleFastMutexLock)`\
`     STYLE: Remove old Python examples`\
`     COMP: Update gccxml`\
`     ENH: Use pygccxml snapshot.`\
`     ENH: Update to swig 3.0.2`\
`     DOC: Update commit instructions for JIRA bugtracker`\
`     ENH: Update GCCXML`\
`     BUG: Fix wrapping with dimension 2 only`\
`     COMP: Temporarily hide pygccxml warnings`\
`     BUG: Do not wrap BinaryMask3DMeshSource when building with 2D only`\
`     COMP: Move itkMatrixCoefficients wrapping to Filtering module`\
`     COMP: Fix wrapping with Core only`

Miguel Algaba (1):

`     ENH: Added further Solve methods to VNLSparseLUSolverTraits`

Nick Tustison (2):

`     BUG:  Ignored the case for exceeding iteration limit.`\
`     ENH: Preparing point set metrics for use with registration.`

Rashad M (1):

`     STYLE: Allow system installed expat library with ITK_USE_SYSTEM_EXPAT=ON`

Sean McBride (6):

`     BUG: initialize m_SmallBlock ivar in ctor; fixes garbage read`\
`     BUG: changed some variables involved in shifting to unsigned`\
`     COMP: Updated libminc to a78661bb592359ab86f417cc0c298299e593d808`\
`     BUG: initialize m_SmallBlock ivar in ctor; fixes garbage read`\
`     PERF: Mark ImageRegistration8Test with RUNS_LONG`\
`     COMP: workaround clang -Windent warnings by fixing indentation`

Sebastian Pölsterl (1):

`     BUG: Return null pointer if class label does not exist (#3235)`

Taylor Braun-Jones (1):

`     ENH: Expose the output stream operator for LightObject`

Vladimir Chalupecky (1):

`     DOC: Fix description of SpatialObject::GetBoundingBox()`

Vladimir S. FONOV (3):

`     COMP: Fixed libminc to build on Windows`\
`     COMP: Updated libminc, hopefully reducing number of warnings`\
`     COMP: Improved MINCIOTransform tests`

Wei Liu (1):

`     BUG: Fixed a bug in ExpectationMaximiationMixtureModelEstimator.`

Yves Frederix (1):

`     ENH: GeodesicActiveContourShapePrior deals with DerivativeSigma equal to zero`
