package CExpr::Equal;

use 5.6.0;
use strict;
use warnings;

use CExpr;

our @ISA = qw/CExpr/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $left = shift;
    my $right = shift;

    my $self = {left => $left,
                right => $right,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $left = $self->{left}->dump_c;
    my $right = $self->{right}->dump_c;

    return "($left == $right)";
  }

sub compute
  {
    my $self = shift;

    my $left = $self->{left}->compute;
    my $right = $self->{right}->compute;

    return $left == $right;
  }

sub get_refs
  {
    my $self = shift;
    return ($self->{left}->get_refs, $self->{right}->get_refs);
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;
    $self->{left}->layout($accept_incomplete, $namespace);
    $self->{right}->layout($accept_incomplete, $namespace);
  }

1;
