<?php

//    listurls.php
//    Shows a List of Urls
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: listurls.php,v 1.19 2004/05/26 09:38:56 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");



if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;
      
   if ($all)
   {
      // Show all the URLs, retrieved ones as well as not
      $strGenSQL = "Select Schedule.IDUrl, Schedule.Url, Url.StatusCode, Url.ReasonPhrase, Url.ConnStatus" .
         " from Schedule LEFT JOIN Url ON Schedule.IDUrl=Url.IDUrl" . 
         " order by Schedule.Status, Schedule.HopCount, Schedule.IDServer"
	 . " LIMIT " . $initpage . ", " . $pagesize;

      $strCountSQL="select count(*) from Schedule";

      $strSection=$strListofAllUrls;
      $otherinfo="&all=1"; // Keeps on showing the complete list
   }
   else
   {
      // Shows only the retrieved URLs
      $otherinfo="";

      $strSection=$strListofUrls;

      if (isset($StatusCode))
      {
         $strWhere=" WHERE StatusCode=" .$StatusCode;
         $otherinfo=$otherinfo . "&StatusCode=" . $StatusCode;
         $strSection = $strSection . " - " . $strStatusCode . "=" .
            $StatusCode;
      }
      else $strWhere="";
         
      $strGenSQL = "Select IDUrl, Url, StatusCode, ReasonPhrase, ConnStatus" .
         " from Url" . $strWhere .
	 " ORDER BY Url ASC " .
	 " LIMIT " . $initpage . ", " . $pagesize;
   
      $strCountSQL="select count(*) from Url" . $strWhere;

   }
   
   $pagetitle = "Database: $dbname - " . $strSection;
   eval("\$strhome = \"$strDBHome \";");
   $linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";

   if (!isset($count))
   {
      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }
      
?>
<?php include ("./include/header.inc.php"); ?>

<?php

   // A database has been selected

// HTTP results
   
?>
<h4><?php echo $strSection; ?></h4>
<p>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<br>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</p>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found

?>
<table>
<tr>
<th> N. </th>
<th> ID </th>
<th> Url </th>
<th> <?php echo $strStatusCode; ?> & <br> <?php echo $strReasonPhrase; ?></th>
<th> <?php echo $strConnectionStatus; ?></th>
</tr>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;
         ($i % 2)? $trclass='odd':$trclass='even';
?>
 <tr class="<?php echo $trclass; ?>">
   <td align="right"> <?php echo number_format($initpage+$i); ?> </td>
   <td align="right"> <?php echo number_format($row["IDUrl"]); ?> </td>
   <td align="left"><a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrl"]; ?>"><?php echo GetURL($row["Url"]); ?></A></td><?php
   if ($row["StatusCode"])
   {
?>
   <td align="center"> <?php echo $row["StatusCode"]; ?> - <?php echo $row["ReasonPhrase"]; ?></td>
   <td align="center"> <?php echo $row["ConnStatus"]; ?></td>
<?php
   }
   else
   {
?>
   <td align="center" colspan="2"><em><?php
   echo $strNotRetrieved;
   if (!empty($row['ConnStatus']))
      echo ' - ' . $row['ConnStatus'];
?></em></td>
<?php   
   }
?>
 </tr>
<?php         
      }

?>
</table>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>

<?php
   }

   $MyDB->Free();

}

?>

<br>

<?php include ("./include/footer.inc.php"); ?>
