<?php

/**
 * Test configuration
 */
define('REDIS_HOST', getenv('REDIS_TEST_HOST'));
define('REDIS_PORT', getenv('REDIS_TEST_PORT')
                   ? (int)getenv('REDIS_TEST_PORT')
                   : Redis::DEFAULT_PORT);
define('REDIS_PASS', getenv('REDIS_TEST_PASS')
                   ? getenv('REDIS_TEST_PASS')
                   : null);

function NewRedisTestInstance($status = false) {
  $r = new Redis();
  $conn = $r->connect(REDIS_HOST, REDIS_PORT);
  if ($status) var_dump($conn);
  $authok = REDIS_PASS ? $r->auth(REDIS_PASS) : true;
  if ($status) var_dump($authok);
  return $r;
}

function GetTestKeyName($test, $rand = false) {
  static $ts;
  $ts = $ts ?: time();
  return 'REDIS_TEST:' . md5( $test . $ts . ( $rand ? '' : rand(0,1000000) ) );
}
