package org.apache.maven.doxia.parser.module;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.Collection;

/**
 * Handles ParserModule lookups.
 *
 * @since 1.6
 */
public interface ParserModuleManager
{
    /**
     * Returns a collection of ParserModules.
     *
     * @return The ParserModules.
     */
    Collection<ParserModule> getParserModules();

    /**
     * Returns the ParserModule that corresponds to the given id.
     *
     * @param id The identifier.
     * @return The corresponding ParserModule.
     * @throws ParserModuleNotFoundException if no ParserModule could be found
     * for the given id.
     */
    ParserModule getParserModule( String id )
        throws ParserModuleNotFoundException;
}
