/*
 * The Doomsday Engine Project -- libcore
 *
 * Copyright © 2004-2017 Jaakko Keränen <jaakko.keranen@iki.fi>
 *
 * @par License
 * LGPL: http://www.gnu.org/licenses/lgpl.html
 *
 * <small>This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details. You should have received a copy of
 * the GNU Lesser General Public License along with this program; if not, see:
 * http://www.gnu.org/licenses</small>
 */

#ifndef LIBDENG2_TEXTVALUE_H
#define LIBDENG2_TEXTVALUE_H

#include "../Value"
#include "../String"

#include <list>

namespace de {

/**
 * The TextValue class is a subclass of Value that holds a text string.
 *
 * @ingroup data
 */
class DENG2_PUBLIC TextValue : public Value
{
public:
    /// An error occurs in string pattern replacements. @ingroup errors
    DENG2_ERROR(IllegalPatternError);

public:
    TextValue(String const &initialValue = "");

    /// Converts the TextValue to plain text.
    operator String const &() const;

    Text typeId() const;
    Value *duplicate() const;
    Number asNumber() const;
    Text asText() const;
    Record *memberScope() const;
    dsize size() const;
    bool contains(Value const &value) const;
    bool isTrue() const;
    dint compare(Value const &value) const;
    void sum(Value const &value);
    void multiply(Value const &value);
    void divide(Value const &value);
    void modulo(Value const &divisor);

    static String substitutePlaceholders(String const &pattern, const std::list<Value const *> &args);

    // Implements ISerializable.
    void operator >> (Writer &to) const;
    void operator << (Reader &from);

protected:
    /// Changes the text of the value.
    void setValue(String const &text);

private:
    Text _value;
};

} // namespace de

#endif /* LIBDENG2_TEXTVALUE_H */
