#! /usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os

input_filename = sys.argv[1]
output_filename = sys.argv[2]
license_filename = sys.argv[3]

macro_name = os.path.basename(output_filename)
string_name = os.path.splitext(macro_name)[0].upper()
macro_name = macro_name.replace('.', '_').upper()

input_f = open(input_filename, 'r')
output_f = open(output_filename, 'w')

output_f.write('/*\n')

license_f = open(license_filename, 'r')
for line in license_f:
    if line.strip() != '':
        output_f.write('    ')
    output_f.write(line)

output_f.write('''*/

#ifndef %(0)s
#define %(0)s

#define %(1)s \\
''' % { '0' : macro_name, '1' : string_name})

for line in input_f:
    line = line.replace('\n', '\\n')
    line = line.replace('"', '\\"')
    output_f.write('    \"%s\" \\\n' % line)

output_f.write('''    \"\"

#endif
''')

input_f.close()
output_f.close()
