/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.sql;

public  interface   Statement   extends Wrapper
{
    int CLOSE_ALL_RESULTS = 3;
    int CLOSE_CURRENT_RESULT = 1;
    int EXECUTE_FAILED = -3;
    int KEEP_CURRENT_RESULT = 2;
    int NO_GENERATED_KEYS = 2;
    int RETURN_GENERATED_KEYS = 1;
    int SUCCESS_NO_INFO = -2;

    public  void 	addBatch(String sql)    throws  SQLException;
    public  void 	cancel()    throws  SQLException;
    public  void 	clearBatch()    throws  SQLException;
    public  void 	clearWarnings() throws  SQLException;
    public  void 	close() throws  SQLException;
    public  boolean 	execute(String sql) throws  SQLException;
    public  boolean 	execute(String sql, int autoGeneratedKeys)  throws  SQLException;
    public  boolean 	execute(String sql, int[] columnIndexes)    throws  SQLException;
    public  boolean 	execute(String sql, String[] columnNames)   throws  SQLException;
    public  int[] 	executeBatch()  throws  SQLException;
    public  ResultSet 	executeQuery(String sql)    throws  SQLException;
    public  int 	executeUpdate(String sql)   throws  SQLException;
    public  int 	executeUpdate(String sql, int autoGeneratedKeys)    throws  SQLException;
    public  int 	executeUpdate(String sql, int[] columnIndexes)  throws  SQLException;
    public  int 	executeUpdate(String sql, String[] columnNames) throws  SQLException;
    public  Connection 	getConnection() throws  SQLException;
    public  int 	getFetchDirection() throws  SQLException;
    public  int 	getFetchSize()  throws  SQLException;
    public  ResultSet 	getGeneratedKeys()  throws  SQLException;
    public  int 	getMaxFieldSize()   throws  SQLException;
    public  int 	getMaxRows()    throws  SQLException;
    public  boolean 	getMoreResults()    throws  SQLException;
    public  boolean 	getMoreResults(int current) throws  SQLException;
    public  int 	getQueryTimeout()   throws  SQLException;
    public  ResultSet 	getResultSet()  throws  SQLException;
    public  int 	getResultSetConcurrency()   throws  SQLException;
    public  int 	getResultSetHoldability()   throws  SQLException;
    public  int 	getResultSetType()  throws  SQLException;
    public  int 	getUpdateCount()    throws  SQLException;
    public  SQLWarning 	getWarnings()   throws  SQLException;
    public  boolean 	isClosed()  throws  SQLException;
    public  boolean 	isPoolable()    throws  SQLException;
    public  void 	setCursorName(String name)  throws  SQLException;
    public  void 	setEscapeProcessing(boolean enable) throws  SQLException;
    public  void 	setFetchDirection(int direction)    throws  SQLException;
    public  void 	setFetchSize(int rows)  throws  SQLException;
    public  void 	setMaxFieldSize(int max)    throws  SQLException;
    public  void 	setMaxRows(int max) throws  SQLException;
    public  void 	setPoolable(boolean poolable)   throws  SQLException;
    public  void 	setQueryTimeout(int seconds)    throws  SQLException;
}
