/*

Derby - Class org.apache.derbyTesting.perf.clients.IndexJoinClient

Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ResultSet;

/**
 * Test client which performs an index join between the {@code TENKTUP1} and
 * {@code ONEKTUP} tables generated by {@code WisconsinFiller}.
 */
public class IndexJoinClient implements Client {

    private Connection conn;
    private PreparedStatement ps;

    public void init(Connection c) throws SQLException {
        conn = c;
        ps = c.prepareStatement(
            "SELECT TENKTUP1.UNIQUE1 FROM TENKTUP1, ONEKTUP WHERE " +
            "TENKTUP1.UNIQUE1 = ONEKTUP.UNIQUE1");
        c.setAutoCommit(false);
    }

    public void doWork() throws SQLException {
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            rs.getInt(1);
        }
        rs.close();
        conn.commit();
    }

    public void printReport(PrintStream out) {}
    
}
