% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbIsReadOnly.R
\name{dbIsReadOnly}
\alias{dbIsReadOnly}
\title{Is this DBMS object read only?}
\usage{
dbIsReadOnly(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\description{
This generic tests whether a database object is read only.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbIsReadOnly")}
}
\examples{
dbIsReadOnly(ANSI())
}
\seealso{
Other DBIDriver generics: 
\code{\link{DBIDriver-class}},
\code{\link{dbCanConnect}()},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbDriver}()},
\code{\link{dbGetInfo}()},
\code{\link{dbIsValid}()},
\code{\link{dbListConnections}()}

Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}

Other DBIResult generics: 
\code{\link{DBIResult-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbColumnInfo}()},
\code{\link{dbFetch}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsValid}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()}

Other DBIConnector generics: 
\code{\link{DBIConnector-class}},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbGetConnectArgs}()}
}
\concept{DBIConnection generics}
\concept{DBIConnector generics}
\concept{DBIDriver generics}
\concept{DBIResult generics}
