% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBIConnector.R
\docType{class}
\name{DBIConnector-class}
\alias{DBIConnector-class}
\title{DBIConnector class}
\description{
Wraps objects of the \linkS4class{DBIDriver} class to include connection options.
The purpose of this class is to store both the driver
and the connection options.
A database connection can be established
with a call to \code{\link[=dbConnect]{dbConnect()}}, passing only that object
without additional arguments.
}
\details{
To prevent leakage of passwords and other credentials,
this class supports delayed evaluation.
All arguments can optionally be a function (callable without arguments).
In such a case, the function is evaluated transparently when connecting in
\code{\link[=dbGetConnectArgs]{dbGetConnectArgs()}}.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a connector:
cnr <- new("DBIConnector",
  .drv = RSQLite::SQLite(),
  .conn_args = list(dbname = ":memory:")
)
cnr

# Establish a connection through this connector:
con <- dbConnect(cnr)
con

# Access the database through this connection:
dbGetQuery(con, "SELECT 1 AS a")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBI classes: 
\code{\link{DBIConnection-class}},
\code{\link{DBIDriver-class}},
\code{\link{DBIObject-class}},
\code{\link{DBIResult-class}},
\code{\link{DBIResultArrow-class}}

Other DBIConnector generics: 
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbGetConnectArgs}()},
\code{\link{dbIsReadOnly}()}
}
\concept{DBI classes}
\concept{DBIConnector generics}
