DACSCOOKIE(1)                DACS Commands Manual                DACSCOOKIE(1)



[1mNAME[0m
       dacscookie - create [1mDACS [22mcredentials and emit as a cookie

[1mSYNOPSIS[0m
       [1mdacscookie [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-create[22m] [[1m-i [4m[22mident[24m] [[1m-user [4m[22muser[24m]
                            [[1m-ip [4m[22mipaddr[24m]
                            [[1m-role [4m[22mrole_str[24m] [[1m-expires [4m[22mdate[24m] [[1m-ua [4m[22mstr[24m]
                            [1mdacscookie [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [1m-decrypt [22m[[1m-concise[22m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacscookie [22mutility constructs [1mDACS [22mcredentials that represent a
       single [1mDACS [22midentity and emits them as the [4mNAME[24m=[4mVALUE[24m element of a [34m[1mHTTP[0m
       [1m[34mcookie[0m[1m[22m[2] ([34m[1mRFC 2109[0m[1m[22m[3], [34m[1mRFC 2965[0m[1m[22m[4], [34m[1mRFC 6265[0m[1m[22m[5]) that may be used by
       [1mDACS[22m. It can also decode and display these cookies, provided the same
       encryption keys used to create the cookies are available. The program
       is useful for testing purposes, or by programs that perform
       authentication (e.g., by calling [34m[1mdacsauth(1)[0m[1m[22m[6]) and need to return
       credentials. It may also be used to generate an identity "offline"; the
       resulting credentials could be used by applications other than standard
       Web browsers, or be distributed via any secure channel (e.g., encrypted
       email) for use by the recipient.

       Configured or derived defaults are used if optional identity
       information is not provided.

           [1mSecurity[0m
           Only the [1mDACS [22madministrator should be able to successfully run this
           program. Because DACS keys and configuration files must be limited
           to the administrator, this will normally be the case, but a careful
           administrator will set file permissions to deny access to all other
           users, or even delete the binary.

           Similarly, access to cookies generated by this program must be
           carefully controlled. Any jurisdiction within the same federation
           in which the credentials were created will be able to directly
           decrypt the credentials.

[1mOPTIONS[0m
       [1mdacscookie [22mrecognizes these options for cookie creation:

       [1m-create[0m
           Create the specified credentials and emit them to the standard
           output as the [4mNAME[24m=[4mVALUE[24m component of an HTTP cookie. This is the
           default.

       [1m-expires [4m[22mdate[0m
           Set the expiry date for the cookie. If [4mdate[24m begins with '+' and is
           followed by a digit string, the expiry date will be that number of
           seconds relative to the current time. Otherwise, the date is
           expected to be in one of the recognized formats (see [34m[1mconcise[0m
           [1m[34msyntax[0m[1m[22m[7]). If not provided, the configured default value,
           [34m[1mAUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS[0m[1m[22m[8], will be used.

       [1m-i [4m[22mident[0m
           The identity ([4mident[24m) is given in the [34m[1mconcise syntax[0m[1m[22m[7]. Note that
           any elements that are explicitly given will override those that
           appear in [4mident[24m.

       [1m-ip [4m[22mipaddr[0m
           Use [4mipaddr[24m as the user's IP address (in standard dot notation). If
           not provided, this element will be obtained from any [1m-i [22mflag or
           else omitted from the credentials.

       [1m-role [4m[22mrole_str[0m
           Use [4mrole_str[24m as the user's role string, which must be syntactically
           correct. If not provided, this element will be obtained from any [1m-i[0m
           flag or else omitted from the credentials.

       [1m-ua [4m[22mstr[0m
           Use [4mstr[24m as the user agent string associated with the credentials.
           If no string is specified, the credentials cannot be verified
           against a user agent string. See [34m[1mdacs.conf(5)[0m[1m[22m[9].

       [1m-user [4m[22mname[0m
           Use [4mname[24m, a syntactically correct username, within the applicable
           jurisdiction. If not provided, this element must be specified using
           the [1m-i [22mflag.


       [1mdacscookie [22mrecognizes these options for cookie decryption:

       [1m-decrypt[0m
           Instead of creating credentials, read a cookie from the standard
           input and print its decoded contents to the standard output. If the
           input is invalid in any way, a message is displayed.

       [1m-concise[0m
           With the [1m-decrypt [22mflag, only print the identity in the [34m[1mconcise user[0m
           [1m[34msyntax[0m[1m[22m[7].

[1mEXAMPLES[0m
       The following will generate an identity and store it in a file:

           % dacscookie -u j1.example.com -user bobo > cookie.out
           % chmod 0600 cookie.out

       The following will display various elements of the credentials to
       stdout:

           % dacscookie -u j1.example.com -decrypt < cookie.out
           % rm cookie.out


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_auth_agent(8)[0m[1m[22m[10], [34m[1mdacs_auth_transfer(8)[0m[1m[22m[11],
       [34m[1mdacs_authenticate(8)[0m[1m[22m[12], [34m[1mdacsauth(1)[0m[1m[22m[6], [34m[1mdacscred(1)[0m[1m[22m[13],
       [34m[1mdacs_current_credentials(8)[0m[1m[22m[14].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[15])

[1mCOPYING[0m
       Copyright (C) 2003-2015 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[16] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. HTTP cookie
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

        3. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

        4. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

        5. RFC 6265
           http://www.rfc-editor.org/rfc/rfc6265.txt

        6. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        7. concise syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

        8. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

        9. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_UA

       10. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       11. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       12. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       13. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       14. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       15. www.dss.ca
           http://www.dss.ca

       16. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                     DACSCOOKIE(1)
