." The first line of this file must contain the '"[e][r][t][v] line
." to tell man to run the appropriate filter "t" for table.
."
."	$Id: bwctlrc.man 493 2008-10-09 16:27:47Z aaron $
."
."######################################################################
."#									#
."#			   Copyright (C)  2004				#
."#	     			Internet2				#
."#			   All Rights Reserved				#
."#									#
."######################################################################
."
."	File:		bwctlrc.8
."
."	Author:		Jeff Boote and Aaron Brown
."			    Internet2
."
."	Date:		Tue Jan 06 07:44:09 EST 2009
."
."	Description:	
."
.PP
The format of this file is:
.RS
.IP \(bu
Comment lines are any line where the first non-whitespace character is '#'.
These lines are counted for the purposes of returning line numbers in error
messages but are otherwise ignored by the spawned \fBbwctld\fR.
.IP \(bu
Lines may be continued using the semi-standard '\\' character followed
immediately by a newline character. This is the only valid place for
the '\\' character. If it is found elsewhere, a syntax error is reported.
.IP \(bu
Blank lines are treated as comment lines.
.IP \(bu
All other lines are used to set configuration options. The format of these
lines is an initial keyword followed by a variable list of arguments,
separated by whitespace.
.RE
.SH CONFIGURATION OPTIONS
.TP
.BI access_priority " priority"
Syslog \fIpriority\fR to log access messages.
.RS
.IP Default:
LOG_INFO
.RE
.TP
.B allow_unsync
Directs \fBbwctld\fR to continue accepting valid requests for throughput
tests when the system clock is not synchronized. \fBbwctld\fR prefers
to have an NTP synchronized system clock to ensure the two endpoints of the
test are actually agreeing to the same scheduled time window for
test execution. This option is used to bypass this requirement for
systems that either do not have the NTP system calls, or prefer not
to configure NTP.
.RS
.PP
Note: if the difference between the system clocks on the two endpoints
is too great, the eventual throughput test will fail when the
endpoints attempt to run the test at different times. The threshold
for this difference is controlled using the \fIsync_fuzz\fR option.
(If you set allow_unsync, you should set \fIsync_fuzz\fR to a reasonable
value for your system.)
.PP
.IP Default:
unset (set if the operating system does have the NTP system calls)
.RE
.TP
.BI auth_mode " authmode"
Specify the authentication modes the server is willing to use for
communication. \fIauth_mode\fR should be set as a character string, with
any or all of the characters "AEO". The modes are:
.RS
.IP \fBA\fR
[\fBA\fR]uthenticated. This mode encrypts the control connection.
.IP \fBE\fR
[\fBE\fR]ncrypted. This mode encrypts the control connection. If the
test supports encryption, this mode will additionally encrypt the test
stream. (Encryption of the test stream is not currently supported, so
this mode is currently identical to authenticated.)
.IP \fBO\fR
[\fBO\fR]pen. No encryption of any kind is done.
.PP
The server can specify all the modes with which it is willing to communicate. The
most strict mode that both the server and the client are willing to use
will be selected.
.IP Default:
"AEO"
.RE
.TP
.BI bottleneck_capacity " bottleneckcapacity"
This value is used in the algorithm to dynamically set the TCP
send/recv window sizes. This option is likely to be removed in the
future once a dynamic \fIbottleneck_capacity\fR algorithm is incorporated
into the code. (This option only really works when the local NIC is
the bottleneck.) If this option is not specified, the dynamic window
calculation requested by the \fB-W\fR option to \fBbwctl\fR is not
done and the advisory value is used.
.RS
.IP Default:
unset
.RE
.TP
.BI control_timeout " controltimeout"
Number of seconds to wait for protocol messages before timing out. This
value should be significantly larger than what typical users specify
for the \fB-I\fR flag of \fBbwctl\fR or \fBbwctl\fR will have to open
a new control connection for each new test it requests.
.RS
.IP Default:
7200 (Picked to be the same as the default for TCP keepalive)
.RE
.TP
.BI die_by " dieby"
Number of seconds to wait for child processes to gracefully terminate
before killing them with \fBSIGKILL\fR. This is in response to the master
process receiving \fBSIGTERM\fR or \fBSIGHUP\fR.
.RS
.IP Default:
30
.RE
.TP
.BI facility " facility"
Syslog \fIfacility\fR to log messages.
.RS
.IP Default:
LOG_DAEMON
.RE
.TP
.BI group " group"
Specifies the gid the \fBbwctld\fR process should run as. \fIgroup\fR
can be specified using a valid group name on the system or by using -gid.
This option is only used if \fBbwctld\fR is started as root.
.RS
.IP Default:
unset
.RE
.TP
.BI iperf_cmd " iperfcmd"
The path to the \fBIperf\fR command on the system. If the \fIiperf_cmd\fR
does not contain a '/' character, then the PATH of the \fBbwctld\fR
environment will be searched to find the \fBIperf\fR executable.
.RS
.IP Default:
iperf
.RE
.TP
.BI iperf_port " iperfport"
The port number(s) that \fBIperf\fR receivers will use.
Currently, \fBbwctld\fR simply cycles through this range linearly.
\fIiperf_port\fR can be specified as a single valid port number or as
a range as \fIlow\fR-\fIhigh\fR. The range must be specified as two valid
port numbers with the '-' character separating them. Whitespace is
not allowed within the \fIiperf_port\fR. For example, \fB"5001-5004"\fR would
be valid, but \fB"5001 - 5004"\fR would be invalid.
.RS
.PP
This value should be set to a range because it can take a few minutes for a
port to become free after a test has run. If the port is not free when the next
test starts, the test will fail. If set to a range, the daemon will cycle
through them when starting tests, decreasing the chance that a port will still
be open when the test starts. For best results, ensure that this range is
different from that of nuttcp_port and thrulay_port.
.PP
.IP Default:
5001
.RE
.TP
.B log_location
Directs the \fBbwctld\fR process to report source code file and line
number information with error messages. This is a particularly useful
option to set when sending in messages as part of a bug report.
.RS
.IP Default:
unset
.RE
.TP
.BI nuttcp_cmd " nuttcpcmd"
The path to the \fBNuttcp\fR command on the system. If the \fInuttcp_cmd\fR
does not contain a '/' character, then the PATH of the \fBbwctl\fR
environment will be searched to find the \fBNuttcp\fR executable.
.RS
.IP Default:
nuttcp
.RE
.TP
.BI nuttcp_port " nuttcpport"
The port number(s) that \fBNuttcp\fR receivers will use.
Currently, \fBbwctld\fR simply cycles through this range linearly.
\fInuttcp_port\fR can be specified as a single valid port number or as
a range as \fIlow\fR-\fIhigh\fR. The range must be specified as two valid
port numbers with the '-' character separating them. Whitespace is
not allowed within the \fInuttcp_port\fR. For example, \fB"5001-5004"\fR would
be valid, but \fB"5001 - 5004"\fR would be invalid.
.RS
.PP
This value should be set to a range because it can take a few minutes for a
port to become free after a test has run. If the port is not free when the next
test starts, the test will fail. If set to a range, the daemon will cycle
through them when starting tests, decreasing the chance that a port will still
be open when the test starts. For best results, ensure that this range is
different from that of iperf_port and thrulay_port.
.PP
.IP Default:
5001
.RE
.TP
.BI peer_port " 0 | lowport-highport"
Specify the port range that will be used on the local host for peer
connections to other
.B bwctld
servers. These connections are used to verify clock timing between the
servers and to exchange test results. This is a required part of the
protocol used by
.B BWCTL
to run tests. However, this option allows system administrators
to limit these connections to a specific port range, which should allow
.B BWCTL
to work in a firewall environment. This option can be specified in two
ways. First, as a 0, which would indicate that
.B bwctld
should allow the system to pick the port (ephemeral). Second, as a range.
.I lowport
must be a smaller value than
.I highport
and both numbers must be valid port values. (16-bit unsigned integer values)
.RS
.IP Default:
0
.RE
.TP
.BI post_hook " /path/to/script"
Specifies a script to run after each bwctl session has finished. These hooks
can be used to save the results into a database, track usage or any number of
other tasks. You can specify as many hooks as you want by including multiple
post_hook entries.
.TP
.BI priority " priority"
Syslog \fIpriority\fR to log error messages.
.RS
.IP Default:
LOG_ERR
.RE
.TP
.B root_folly
Disables the checks that disable \fBbwctld\fR if it is run with \fIroot\fR
permissions. There are legitimate reasons to run \fBbwctld\fR as root, but
it is risky. Forcing this additional option will make it less likely root
permissions are accidently used.
.RS
.IP Default:
unset
.RE
.TP
.BI src_node " nodename:port"
Specify the address and port on which \fBbwctld\fR will listen for requests.
\fInodename\fR can be specified using a DNS name or using the textual
representation of the address. It is possible to set the source address
without setting the \fIport\fR by simply leaving off the ':' and \fIport\fR
specification. If an IPv6 address is specified, note that the accepted format
contains \fInodename\fR in square brackets as: [fe80::fe9f:62d8]. This
ensures the port number is distinct from the address specification.
.RS
.IP Default:
\fInodename\fR is wildcarded as any currently available address
.br
\fIport\fR is 4823
.RE
.TP
.BI sync_fuzz " syncfuzz"
This value is added to the NTP error estimates to increase the tolerance
of \fBbwctld\fR to incomplete NTP configurations, or if the NTP system calls
are not available. If NTP is unavailable to \fBbwctld\fR it assumes the
clock is accurate to within one second plus the value of \fIsync_fuzz\fR.
This option is specified as a floating point number
in seconds. For example, to indicate that the system is synchronized within
one second, you could specify this option as 1.0.
.RS
.PP
Practically, this option is used to determine the size of the time window
buffer before and after each throughput test.
.IP Default:
0.0
.RE
.TP
.BI thrulay_port " thrulayport"
The port number(s) that \fBThrulay\fR receivers will use.
Currently, \fBbwctld\fR simply cycles through this range linearly.
\fIthrulay_port\fR can be specified as a single valid port number or as
a range as \fIlow\fR-\fIhigh\fR. The range must be specified as two valid
port numbers with the '-' character separating them. Whitespace is
not allowed within the \fIthrulay_port\fR. For example, \fB"5001-5004"\fR would
be valid, but \fB"5001 - 5004"\fR would be invalid.
.RS
.PP
This value should be set to a range because it can take a few minutes for a
port to become free after a test has run. If the port is not free when the next
test starts, the test will fail. If set to a range, the daemon will cycle
through them when starting tests, decreasing the chance that a port will still
be open when the test starts. For best results, ensure that this range is
different from that of iperf_port and nuttcp_port.
.PP
.IP Default:
5003
.RE
.TP
.BI user " user"
Specifies the uid the \fBbwctld\fR process should run as. \fIuser\fR
can be specified using a valid user name on the system or by using -uid.
This option is only used if \fBbwctld\fR is started as root. If the
given \fIuser\fR has \fIroot\fR permissions, the \fIroot_folly\fR option
must also be specified.
.RS
.IP Default:
unset
.RE
.TP
.BI var_dir " vardir"
Directory path where the bwctld.pid file will be placed.
.RS
.IP Default:
Current directory
.RE
