/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.Hashtable;
import java.util.Vector;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.expr.visitor.ExprScreener;
import jd.xml.xslt.format.Sort;
import jd.xml.xslt.parser.XsltParseContext;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.TemplateScreener;
import jd.xml.xslt.template.Variable;

class VariableSorter {
    private XsltParseContext context_;
    private Variable[] variables_;
    private Variable[] result_;
    private Entry screenedEntry_;
    private Entry[] entries_;
    private Hashtable nameMap_;
    private int firstUnClassified_;

    VariableSorter() {
    }

    public synchronized void sort(XsltParseContext xsltParseContext, Variable[] variableArray) throws XsltParseException {
        this.firstUnClassified_ = variableArray.length;
        int n = this.firstUnClassified_;
        if (n < 2) {
            this.result_ = variableArray;
            return;
        }
        this.context_ = xsltParseContext;
        this.variables_ = variableArray;
        this.init();
        this.screen();
        this.sort();
    }

    public Variable[] getSortedVariables() {
        return this.result_;
    }

    public int firstUnClassifiedGlobalVar() {
        return this.firstUnClassified_;
    }

    private void init() {
        int n = this.variables_.length;
        this.entries_ = new Entry[n];
        this.nameMap_ = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            Entry entry = this.entries_[i] = new Entry();
            entry.variable = this.variables_[i];
            this.nameMap_.put(this.variables_[i].getVariableName(), entry);
        }
    }

    private void screen() {
        VarTemplateScreener varTemplateScreener = new VarTemplateScreener(new VarExprScreener());
        for (int i = 0; i < this.variables_.length; ++i) {
            this.screenedEntry_ = this.entries_[i];
            varTemplateScreener.visit(this.variables_[i]);
        }
    }

    private void sort() throws XsltParseException {
        int n = this.variables_.length;
        this.result_ = new Variable[n];
        int n2 = 0;
        while (n2 < n) {
            Entry entry;
            int n3;
            int n4 = n2;
            for (n3 = 0; n3 < n; ++n3) {
                entry = this.entries_[n3];
                if (entry.variable == null || entry.dependsOn != null || !entry.dependeciesKnown) continue;
                this.result_[n2++] = this.removeDependency(entry);
            }
            if (n2 != n4) continue;
            for (n3 = 0; n3 < n; ++n3) {
                entry = this.entries_[n3];
                if (entry.variable == null || entry.dependeciesKnown) continue;
                this.firstUnClassified_ = Math.min(n2, this.firstUnClassified_);
                this.result_[n2++] = this.removeDependency(entry);
            }
            if (n2 != n4) continue;
            this.reportCircularDependency();
        }
    }

    private Variable removeDependency(Entry entry) {
        for (int i = 0; i < this.entries_.length; ++i) {
            Entry entry2 = this.entries_[i];
            if (entry2.dependsOn == null) continue;
            while (entry2.dependsOn.removeElement(entry)) {
            }
            if (entry2.dependsOn.size() != 0) continue;
            entry2.dependsOn = null;
        }
        Variable variable = entry.variable;
        entry.variable = null;
        return variable;
    }

    private void reportCircularDependency() throws XsltParseException {
        for (int i = 0; i < this.entries_.length; ++i) {
            Entry entry = this.entries_[i];
            if (entry.variable == null) continue;
            String string = entry.variable.getVariableName().getName();
            String string2 = entry.variable.isParameter() ? "parameter" : "variable";
            String string3 = string2 + " '" + string + "' has a circular dependency on other variables";
            throw new XsltParseException(string3, this.context_.getDocumentBaseUri(), null);
        }
    }

    private class VarExprScreener
    extends ExprScreener {
        private VarExprScreener() {
        }

        public void variableReference(Expression expression, VariableName variableName) {
            Entry entry = (Entry)VariableSorter.this.nameMap_.get(variableName);
            if (entry != null) {
                if (((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn == null) {
                    ((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn = new Vector();
                }
                ((VariableSorter)VariableSorter.this).screenedEntry_.dependsOn.addElement(entry);
            }
        }
    }

    private class VarTemplateScreener
    extends TemplateScreener {
        public VarTemplateScreener(ExpressionVisitor expressionVisitor) {
            super(expressionVisitor);
        }

        public void applyImports(TemplateRuleList templateRuleList, Variable[] variableArray, int n) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }

        public void applyTemplates(TemplateRuleList templateRuleList, Expression expression, Sort sort, Variable[] variableArray) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }

        public void callTemplate(TemplateRule templateRule, Variable[] variableArray, int n, boolean bl) {
            ((VariableSorter)VariableSorter.this).screenedEntry_.dependeciesKnown = false;
        }
    }

    private static class Entry {
        Variable variable;
        Vector dependsOn;
        boolean dependeciesKnown = true;

        private Entry() {
        }
    }
}

