/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jd.xml.util.DefaultUriResolver;
import jd.xml.util.UriResolver;
import jd.xml.util.Utf8Escaping;
import jd.xml.util.XmlSource;

public abstract class UriUtil {
    public static boolean isAbsoluteUri(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        return n != -1 && n2 != -1 && n < n2;
    }

    public static boolean isAbsolutePath(String string) {
        return string.startsWith("/") || new File(string).isAbsolute();
    }

    public static String getUri(String string, String string2) {
        boolean bl;
        if (UriUtil.isAbsoluteUri(string) || string2 == null) {
            return string;
        }
        if (string.length() == 0) {
            return string2;
        }
        if (string.startsWith("#")) {
            return string2 + string;
        }
        boolean bl2 = bl = !string2.startsWith("file:") && string2.indexOf("://") >= 0;
        if (bl) {
            try {
                URL uRL = new URL(new URL(string2), string);
                return uRL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (UriUtil.isAbsolutePath(string)) {
            if (bl) {
                int n = string2.indexOf(47, string2.indexOf("://") + 3);
                return n == -1 ? string2 + string : string2.substring(0, n) + string;
            }
            return string;
        }
        int n = string2.lastIndexOf(47);
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 > n) {
            return string2.substring(0, n2) + File.separator + string;
        }
        if (n != -1) {
            return string2.substring(0, n) + '/' + string;
        }
        return string;
    }

    public static XmlSource resolveUri(String string, String string2, UriResolver uriResolver) throws IOException {
        XmlSource xmlSource = null;
        if (uriResolver != null) {
            xmlSource = uriResolver.resolveUri(string, string2);
        }
        if (xmlSource == null) {
            xmlSource = DefaultUriResolver.INSTANCE.resolveUri(string, string2);
        }
        return xmlSource;
    }

    public static File getFile(String string) {
        File file;
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        if ((file = new File(string)).exists()) {
            return file;
        }
        try {
            file = new File(file.getCanonicalPath());
            if (file.exists()) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String encodeIUri(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        Utf8Escaping utf8Escaping = null;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    bl = true;
                    break;
                }
                default: {
                    boolean bl2 = bl = c >= '\u007f' || c <= '\u001f';
                }
            }
            if (bl) {
                if (utf8Escaping == null) {
                    utf8Escaping = new Utf8Escaping();
                }
                try {
                    int n2 = utf8Escaping.escape(c);
                    for (int j = 0; j < n2; ++j) {
                        stringBuffer.append(utf8Escaping.getResult(j));
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

