/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AppendExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.xpath.XPathException;

public final class CardinalityChecker
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredCardinality = -1;
    private RoleLocator role;

    public CardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        this.sequence = expression;
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.computeStaticProperties();
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (this.requiredCardinality == 1792) {
            return this.sequence;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.sequence.getCardinality())) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        ObjectValue objectValue = null;
        if (!Cardinality.allowsZero(this.requiredCardinality)) {
            objectValue = new ObjectValue(this);
            sequenceIterator = new AppendExpression.AppendIterator(sequenceIterator, objectValue, xPathContext);
        }
        return new MappingIterator(sequenceIterator, this, null, sequenceIterator);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        int n = ((SequenceIterator)object).position();
        if (item instanceof ObjectValue && ((ObjectValue)item).getObject() == this) {
            if (n == 1) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage());
            }
            return null;
        }
        if (n == 2 && !Cardinality.allowsMany(this.requiredCardinality)) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            return null;
        }
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        Item item2 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item2 != null) {
                this.typeError("An sequence of more than one item is not allowed as the " + this.role.getMessage());
                return null;
            }
            item2 = item;
        }
        if (item2 == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage());
            return null;
        }
        return item2;
    }

    public ItemType getItemType() {
        return this.sequence.getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.sequence.getSpecialProperties();
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ")");
        this.sequence.display(n + 1, namePool);
    }
}

