/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.sourceforge.cobertura.util.IOUtil;

public class ConfigurationUtil {
    public static final String RESOURCE = "/cobertura.properties";
    private Properties props;

    public ConfigurationUtil() {
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        this.props = new Properties();
        URL url = this.getClass().getResource(RESOURCE);
        if (url == null) {
            this.DEBUG("Unable to find configuration resource in classpath of name /cobertura.properties, using empty configuration.");
            return;
        }
        InputStream is = null;
        try {
            try {
                is = url.openStream();
                this.props.load(is);
            }
            catch (IOException e) {
                System.err.println("ERROR: Unable to load configuration resource /cobertura.properties - " + e.getMessage());
                Object var5_4 = null;
                IOUtil.closeInputStream(is);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtil.closeInputStream(is);
            throw throwable;
        }
        IOUtil.closeInputStream(is);
    }

    public String getProperty(String key, String defvalue) {
        String value = System.getProperty(key);
        if (value != null) {
            this.DEBUG("Using system property value [" + value + "] for key [" + key + "]");
            return value;
        }
        value = this.props.getProperty(key);
        if (value != null) {
            this.DEBUG("Using cobertura.properties value [" + value + "] for key [" + key + "]");
            return value;
        }
        this.DEBUG("Using default value [" + defvalue + "] for key [" + key + "]");
        return defvalue;
    }

    public String getDatafile() {
        return this.getProperty("net.sourceforge.cobertura.datafile", "cobertura.ser");
    }

    private void DEBUG(String msg) {
    }
}

