/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.disassembler;

import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ExceptionHandler;
import com.claritysys.jvm.classfile.JVM;
import com.claritysys.jvm.classfile.LineNumber;
import com.claritysys.jvm.classfile.LocalVariable;
import com.claritysys.jvm.disassembler.Disassembler;
import com.claritysys.jvm.disassembler.OpcodeInfo;
import com.claritysys.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class CodeIterator {
    private Disassembler dis;
    private CfMethod method;
    private int methodParameterCount;
    private byte[] bytes;
    private int pc;
    private int argPtr;
    private int nextPc;
    private int opcount;
    private boolean isWide;
    private int nextMarkerIndex;
    private ArrayList markers = new ArrayList();

    public CodeIterator(Disassembler dis, CfMethod method, int parameterCount) {
        this.dis = dis;
        this.setMethod(method, parameterCount);
    }

    public void setMethod(CfMethod method, int parameterCount) {
        this.method = method;
        this.bytes = method.getCode();
        this.methodParameterCount = parameterCount;
        this.reset();
    }

    public void extractMarkers() {
        this.markers.clear();
        this.createLocals();
        this.createLabels();
        this.createLineNumbers();
        this.reset();
        Collections.sort(this.markers, new LineMarker());
    }

    public void reset() {
        this.pc = 0;
        this.nextPc = 0;
        this.isWide = false;
        this.nextMarkerIndex = 0;
    }

    public boolean hasNext() {
        return this.nextPc < this.bytes.length;
    }

    public int nextOp() {
        if (!this.hasNext()) {
            return -1;
        }
        this.pc = this.nextPc;
        this.argPtr = this.pc + 1;
        this.isWide = false;
        int opcode = 0xFF & this.bytes[this.pc];
        if (opcode == 196) {
            this.isWide = true;
            opcode = 0xFF & this.bytes[this.pc + 1];
            ++this.argPtr;
        }
        this.opcount = JVM.NO_OF_OPERANDS[opcode];
        if (this.opcount < 0) {
            if (opcode == 170) {
                int savePtr = this.argPtr;
                this.opcount = 4 - this.argPtr % 4;
                this.argPtr += this.opcount;
                this.opcount += 12;
                this.argPtr += 4;
                int lowRange = this.nextI4();
                int highRange = this.nextI4();
                int offsets = highRange - lowRange + 1;
                this.opcount += offsets * 4;
                this.argPtr = savePtr;
            } else if (opcode == 171) {
                int savePtr = this.argPtr;
                this.opcount = 4 - this.argPtr % 4;
                this.argPtr += this.opcount;
                this.opcount += 4;
                this.argPtr += 4;
                int pairs = this.nextI4();
                this.opcount += pairs * 8;
                this.argPtr = savePtr;
            } else {
                throw new IllegalStateException("Undefined opcount for opcode: " + opcode);
            }
        }
        this.nextPc = this.pc + this.opcount + 1;
        if (this.isWide) {
            this.nextPc += 2;
            if (opcode == 132) {
                ++this.nextPc;
            }
        }
        return opcode;
    }

    public int getArgPtr() {
        return this.argPtr;
    }

    public int getPc() {
        return this.pc;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOpCount() {
        return this.opcount;
    }

    public int nextU1() {
        return 0xFF & this.bytes[this.argPtr++];
    }

    public int nextU2() {
        int u2 = (this.bytes[this.argPtr + 0] & 0xFF) << 8 | this.bytes[this.argPtr + 1] & 0xFF;
        this.argPtr += 2;
        return u2;
    }

    public int nextI1() {
        return this.bytes[this.argPtr++];
    }

    public int nextI2() {
        int i2 = this.bytes[this.argPtr + 0] << 8 | this.bytes[this.argPtr + 1] & 0xFF;
        this.argPtr += 2;
        return i2;
    }

    public int nextI4() {
        int i4 = this.bytes[this.argPtr + 0] << 24 | (this.bytes[this.argPtr + 1] & 0xFF) << 16 | (this.bytes[this.argPtr + 2] & 0xFF) << 8 | this.bytes[this.argPtr + 3] & 0xFF;
        this.argPtr += 4;
        return i4;
    }

    public LineMarker getMarker() {
        if (this.nextMarkerIndex >= this.markers.size()) {
            return null;
        }
        LineMarker current = (LineMarker)this.markers.get(this.nextMarkerIndex);
        if (current.pc <= this.pc) {
            ++this.nextMarkerIndex;
            return current;
        }
        return null;
    }

    public LineMarker getNextMarker() {
        if (this.nextMarkerIndex >= this.markers.size()) {
            return null;
        }
        return (LineMarker)this.markers.get(this.nextMarkerIndex++);
    }

    public LineMarker getMarkerAtOffset(int offset) {
        return this.getMarkerAtPC(this.pc + offset);
    }

    public LineMarker getMarkerAtPC(int target) {
        for (int i = 0; i < this.markers.size(); ++i) {
            LineMarker l = (LineMarker)this.markers.get(i);
            if (l.pc != target || !l.isLabel) continue;
            return l;
        }
        return null;
    }

    private void createLocals() {
        for (LocalVariable lv = this.method.getLocals(); lv != null; lv = lv.getNext()) {
            if (lv.getIndex() < this.methodParameterCount) continue;
            String name = lv.getName().getString();
            String type = this.dis.getTypeSig(this.method.getConstantPool(), lv.getDescriptor().getIndex());
            LineMarker l = new LineMarker();
            l.pc = lv.getStartPc();
            l.marker = type + " " + name;
            this.markers.add(l);
        }
    }

    private void createLabels() {
        int[][] OPERAND_INTERPRETATION = OpcodeInfo.OPERAND_INTERPRETATION;
        short[] NO_OF_OPERANDS = JVM.NO_OF_OPERANDS;
        this.reset();
        while (this.hasNext()) {
            int offset;
            int defaultOffset;
            int skip;
            int opcode = this.nextOp();
            if (opcode == 171) {
                skip = 4 - this.getArgPtr() % 4;
                while (skip-- > 0) {
                    this.nextI1();
                }
                defaultOffset = this.nextI4();
                this.createOffsetMarker(defaultOffset);
                int pairs = this.nextI4();
                for (int i = 0; i < pairs; ++i) {
                    int value = this.nextI4();
                    offset = this.nextI4();
                    this.createOffsetMarker(offset);
                }
            } else if (opcode == 170) {
                skip = 4 - this.getArgPtr() % 4;
                while (skip-- > 0) {
                    this.nextI1();
                }
                defaultOffset = this.nextI4();
                this.createOffsetMarker(defaultOffset);
                int lowRange = this.nextI4();
                int highRange = this.nextI4();
                for (int i = lowRange; i <= highRange; ++i) {
                    offset = this.nextI4();
                    this.createOffsetMarker(offset);
                }
            }
            block9: for (int argNumber = 0; argNumber < OPERAND_INTERPRETATION[opcode].length; ++argNumber) {
                switch (OPERAND_INTERPRETATION[opcode][argNumber]) {
                    case 7: {
                        int target = this.pc + this.nextI2();
                        this.createPcMarker(target);
                        continue block9;
                    }
                    case 12: {
                        int target = this.pc + this.nextI4();
                        if (this.getMarkerAtPC(target) != null) continue block9;
                        LineMarker l = new LineMarker();
                        l.pc = target;
                        l.marker = "L" + Strings.leftFill((String)Integer.toHexString(l.pc), (int)4, (char)'0');
                        l.isLabel = true;
                        this.markers.add(l);
                        continue block9;
                    }
                }
            }
        }
        for (ExceptionHandler except = this.method.getHandlers(); except != null; except = except.getNext()) {
            int start = except.getStartPc();
            int end = except.getEndPc();
            int handler = except.getHandlerPc();
            int index = except.getExceptionClassIndex();
            String type = index == 0 ? "Exception" : this.dis.getAlias(this.method.getConstantPool(), index);
            LineMarker l = new LineMarker();
            l.pc = start;
            l.marker = "try";
            l.isLabel = true;
            this.markers.add(l);
            l = new LineMarker();
            l.pc = handler;
            l.marker = "catch(" + type + ")";
            l.isLabel = true;
            this.markers.add(l);
            if (this.getMarkerAtPC(end) != null) continue;
            l = new LineMarker();
            l.pc = end;
            l.marker = "end-try";
            l.isLabel = true;
            this.markers.add(l);
        }
    }

    private void createPcMarker(int target) {
        LineMarker marker = this.getMarkerAtPC(target);
        if (marker == null || !marker.isLabel) {
            LineMarker l = new LineMarker();
            l.pc = target;
            l.marker = "L" + Strings.leftFill((String)Integer.toHexString(l.pc), (int)4, (char)'0');
            l.isLabel = true;
            this.markers.add(l);
        }
    }

    private void createOffsetMarker(int offset) {
        LineMarker marker = this.getMarkerAtOffset(offset);
        if (marker == null || !marker.isLabel) {
            LineMarker l = new LineMarker();
            l.pc = this.pc + offset;
            l.marker = "L" + Strings.leftFill((String)Integer.toHexString(l.pc), (int)4, (char)'0');
            l.isLabel = true;
            this.markers.add(l);
        }
    }

    public static String getLocalName(CfMethod method, int localNumber) {
        LocalVariable lv = method.getLocal(localNumber);
        if (lv == null) {
            return "local_" + localNumber;
        }
        return lv.getName().getString();
    }

    private void createLineNumbers() {
        for (LineNumber line = this.method.getLines(); line != null; line = line.getNext()) {
            LineMarker l = new LineMarker();
            l.pc = line.getPc();
            l.marker = ".line " + line.getLine();
            l.isLabel = true;
            this.markers.add(l);
        }
    }

    public String getLocalName(int lnum) {
        return CodeIterator.getLocalName(this.method, lnum);
    }

    public static class LineMarker
    implements Comparator {
        public int pc;
        public String marker;
        public boolean isLabel;

        public int compare(Object o1, Object o2) {
            return ((LineMarker)o1).pc - ((LineMarker)o2).pc;
        }
    }
}

