/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.attribute.Annotation;

public abstract class AnnotationsAttr
extends Attribute {
    private List<Annotation> mAnnotations;

    public AnnotationsAttr(ConstantPool cp, String name) {
        super(cp, name);
        this.mAnnotations = new ArrayList<Annotation>(2);
    }

    public AnnotationsAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        this.mAnnotations = new ArrayList<Annotation>(size);
        for (int i = 0; i < size; ++i) {
            this.addAnnotation(new Annotation(cp, din));
        }
    }

    public Annotation[] getAnnotations() {
        return this.mAnnotations.toArray(new Annotation[this.mAnnotations.size()]);
    }

    public void addAnnotation(Annotation annotation) {
        this.mAnnotations.add(annotation);
    }

    public int getLength() {
        int length = 2;
        int i = this.mAnnotations.size();
        while (--i >= 0) {
            length += this.mAnnotations.get(i).getLength();
        }
        return length;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mAnnotations.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            this.mAnnotations.get(i).writeTo(dout);
        }
    }
}

