// ---------------------------------------------------------------------------
// - TlsSocket.hpp                                                           -
// - afnix:tls service - tls socket class definition                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_TLSSOCKET_HPP
#define  AFNIX_TLSSOCKET_HPP

#ifndef  AFNIX_TLSPROTO_HPP
#include "TlsProto.hpp"
#endif

#ifndef  AFNIX_TCPSOCKET_HPP
#include "TcpSocket.hpp"
#endif

namespace afnix {

  /// The TlsSocket class is the common socket class for the tls protocol.
  /// the class is designed to encapsulate the necessary information to
  /// encode and decode a stream. The tls socket class is the base class
  /// for implementing a tls client/server.
  /// @author amaury darsch

  class TlsSocket : public TcpSocket {
  protected:
    /// the tls state
    TlsState* p_tlss;
    /// the tls protocol
    TlsProto* p_tlsp;

  public:
    /// create a tls socket by tcp socket and state
    /// @param s   the tcp socket
    /// @param sta the tls state
    TlsSocket (TcpSocket* s, TlsState* sta);

    /// destroy this tls socket
    ~TlsSocket (void);

    /// @return the class name
    String repr (void) const;

    /// @return the tls state
    virtual TlsState* getstate (void) const;

    /// @return the tls protocol
    virtual TlsProto* getproto (void) const;

  private:
    // make the copy constructor private
    TlsSocket (const TlsSocket&);
    // make the assignment operator private
    TlsSocket& operator = (const TlsSocket&);

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
    
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;
    
    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
