find_package(PkgConfig REQUIRED)
pkg_search_module(ISL isl)
if (NOT ISL_FOUND EQUAL 1)
  message(FATAL_ERROR "No libisl found on this system. Consider setting PKG_CONFIG_PATH.")
endif()

add_library(ISL INTERFACE IMPORTED)
foreach (incl IN LISTS ISL_INCLUDE_DIRS)
  set_property(TARGET ISL APPEND PROPERTY INTERFACE_INCLUDE_DIRECTORIES ${incl})
endforeach()

foreach (libname IN LISTS ISL_LIBRARIES)
  if (ISL_LIBRARY_DIRS)
    foreach (dir IN LISTS ISL_LIBRARY_DIRS)
      list(APPEND hints  ${dir})
    endforeach()
  endif()
  find_library(lib NAMES ${libname} HINTS ${hints} NO_DEFAULT_PATH)
  set_property(TARGET ISL APPEND PROPERTY INTERFACE_LINK_LIBRARIES ${lib})
endforeach()

foreach (opt IN LISTS ISL_CFLAGS ISL_CFLAGS_OTHER)
  set_property(TARGET ISL APPEND PROPERTY INTERFACE_COMPILE_OPTIONS ${opt})
endforeach()
