// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-llvm %s -o - | FileCheck %s --check-prefix=IR

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -include-pch %t -emit-llvm %s -o - | FileCheck %s --check-prefix=IR-PCH

// expected-no-diagnostics

#ifndef HEADER
#define HEADER

#define N 64
int foo() {
  int x = 0;
  int result[N] = {0};

 #pragma omp parallel loop num_threads(N) allocate(x) private(x) collapse(2)
  for (int i = 0; i < N; i++)
    for (int j = 0; j < N; j++)
      result[i] = i + j + x;
  return 0;
}
#endif
// IR-LABEL: define {{[^@]+}}@_Z3foov
// IR-SAME: () #[[ATTR0:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[X:%.*]] = alloca i32, align 4
// IR-NEXT:    [[RESULT:%.*]] = alloca [64 x i32], align 16
// IR-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2:[0-9]+]])
// IR-NEXT:    store i32 0, ptr [[X]], align 4
// IR-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[RESULT]], i8 0, i64 256, i1 false)
// IR-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB2]], i32 [[TMP0]], i32 64)
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 1, ptr @_Z3foov.omp_outlined, ptr [[RESULT]])
// IR-NEXT:    ret i32 0
//
//
// IR-LABEL: define {{[^@]+}}@_Z3foov.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(256) [[RESULT:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[RESULT_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[RESULT]], ptr [[RESULT_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[RESULT_ADDR]], align 8
// IR-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 4095, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 4
// IR-NEXT:    [[DOTX__VOID_ADDR:%.*]] = call ptr @__kmpc_alloc(i32 [[TMP2]], i64 4, ptr null)
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 4095
// IR-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ 4095, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// IR-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// IR:       omp.inner.for.cond.cleanup:
// IR-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP8]], 64
// IR-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV]], 1
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[DIV3:%.*]] = sdiv i32 [[TMP10]], 64
// IR-NEXT:    [[MUL4:%.*]] = mul nsw i32 [[DIV3]], 64
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP9]], [[MUL4]]
// IR-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[SUB]], 1
// IR-NEXT:    [[ADD6:%.*]] = add nsw i32 0, [[MUL5]]
// IR-NEXT:    store i32 [[ADD6]], ptr [[J]], align 4
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], [[TMP12]]
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTX__VOID_ADDR]], align 4
// IR-NEXT:    [[ADD8:%.*]] = add nsw i32 [[ADD7]], [[TMP13]]
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[I]], align 4
// IR-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// IR-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64 x i32], ptr [[TMP0]], i64 0, i64 [[IDXPROM]]
// IR-NEXT:    store i32 [[ADD8]], ptr [[ARRAYIDX]], align 4
// IR-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR:       omp.body.continue:
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 1
// IR-NEXT:    store i32 [[ADD9]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP2]])
// IR-NEXT:    call void @__kmpc_free(i32 [[TMP2]], ptr [[DOTX__VOID_ADDR]], ptr null)
// IR-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@_Z3foov
// IR-PCH-SAME: () #[[ATTR0:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[X:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[RESULT:%.*]] = alloca [64 x i32], align 16
// IR-PCH-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB2:[0-9]+]])
// IR-PCH-NEXT:    store i32 0, ptr [[X]], align 4
// IR-PCH-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[RESULT]], i8 0, i64 256, i1 false)
// IR-PCH-NEXT:    call void @__kmpc_push_num_threads(ptr @[[GLOB2]], i32 [[TMP0]], i32 64)
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 1, ptr @_Z3foov.omp_outlined, ptr [[RESULT]])
// IR-PCH-NEXT:    ret i32 0
//
//
// IR-PCH-LABEL: define {{[^@]+}}@_Z3foov.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(256) [[RESULT:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[RESULT_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[RESULT]], ptr [[RESULT_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[RESULT_ADDR]], align 8
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 4095, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 4
// IR-PCH-NEXT:    [[DOTX__VOID_ADDR:%.*]] = call ptr @__kmpc_alloc(i32 [[TMP2]], i64 4, ptr null)
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 4095
// IR-PCH-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ 4095, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// IR-PCH-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// IR-PCH:       omp.inner.for.cond.cleanup:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP8]], 64
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[DIV3:%.*]] = sdiv i32 [[TMP10]], 64
// IR-PCH-NEXT:    [[MUL4:%.*]] = mul nsw i32 [[DIV3]], 64
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP9]], [[MUL4]]
// IR-PCH-NEXT:    [[MUL5:%.*]] = mul nsw i32 [[SUB]], 1
// IR-PCH-NEXT:    [[ADD6:%.*]] = add nsw i32 0, [[MUL5]]
// IR-PCH-NEXT:    store i32 [[ADD6]], ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], [[TMP12]]
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTX__VOID_ADDR]], align 4
// IR-PCH-NEXT:    [[ADD8:%.*]] = add nsw i32 [[ADD7]], [[TMP13]]
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[I]], align 4
// IR-PCH-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64 x i32], ptr [[TMP0]], i64 0, i64 [[IDXPROM]]
// IR-PCH-NEXT:    store i32 [[ADD8]], ptr [[ARRAYIDX]], align 4
// IR-PCH-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH:       omp.body.continue:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 1
// IR-PCH-NEXT:    store i32 [[ADD9]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP2]])
// IR-PCH-NEXT:    call void @__kmpc_free(i32 [[TMP2]], ptr [[DOTX__VOID_ADDR]], ptr null)
// IR-PCH-NEXT:    ret void
//
