/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class T800xProtocolDecoder
extends BaseProtocolDecoder {
    private short header = (short)8995;
    public static final short DEFAULT_HEADER = 8995;
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 2;
    public static final int MSG_HEARTBEAT = 3;
    public static final int MSG_ALARM = 4;
    public static final int MSG_NETWORK = 5;
    public static final int MSG_DRIVER_BEHAVIOR_1 = 5;
    public static final int MSG_DRIVER_BEHAVIOR_2 = 6;
    public static final int MSG_BLE = 16;
    public static final int MSG_NETWORK_2 = 17;
    public static final int MSG_GPS_2 = 19;
    public static final int MSG_ALARM_2 = 20;
    public static final int MSG_COMMAND = 129;

    public short getHeader() {
        return this.header;
    }

    public T800xProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, short header, int type, int index, ByteBuf imei, int alarm) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)(alarm > 0 ? 16 : 15));
            response.writeShort((int)header);
            response.writeByte(type);
            response.writeShort(response.capacity());
            response.writeShort(index);
            response.writeBytes(imei);
            if (alarm > 0) {
                response.writeByte(alarm);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm1(int value) {
        return switch (value) {
            case 1 -> "powerCut";
            case 2 -> "lowBattery";
            case 3 -> "sos";
            case 4 -> "overspeed";
            case 5 -> "geofenceEnter";
            case 6 -> "geofenceExit";
            case 7 -> "tow";
            case 8, 10 -> "vibration";
            case 21 -> "jamming";
            case 23 -> "powerRestored";
            case 24 -> "lowPower";
            default -> null;
        };
    }

    private String decodeAlarm2(int value) {
        return switch (value) {
            case 1, 4 -> "removing";
            case 2 -> "tampering";
            case 3 -> "sos";
            case 5 -> "fallDown";
            case 6 -> "lowBattery";
            case 14 -> "geofenceEnter";
            case 15 -> "geofenceExit";
            default -> null;
        };
    }

    private Date readDate(ByteBuf buf) {
        return new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2)).getDate();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        boolean positionType;
        ByteBuf buf = (ByteBuf)msg;
        this.header = buf.readShort();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        int index = buf.readUnsignedShort();
        ByteBuf imei = buf.readSlice(8);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)imei).substring(1));
        if (deviceSession == null) {
            return null;
        }
        boolean bl = positionType = type == 2 || type == 19 || type == 4 || type == 20;
        if (!positionType) {
            this.sendResponse(channel, this.header, type, this.header == 8995 ? 1 : index, imei, 0);
        }
        if (positionType) {
            return this.decodePosition(channel, deviceSession, buf, type, index, imei);
        }
        if (type == 5 && this.header == 10023 || type == 17) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, this.readDate(buf));
            position.set("operator", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.UTF_16LE).toString());
            position.set("networkTechnology", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            position.set("networkBand", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII);
            position.set("iccid", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
            return position;
        }
        if ((type == 5 || type == 6) && this.header == 9766) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            switch (buf.readUnsignedByte()) {
                case 0: 
                case 4: {
                    position.set("alarm", "hardBraking");
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    position.set("alarm", "hardAcceleration");
                    break;
                }
                case 2: {
                    if (type == 5) {
                        position.set("alarm", "hardBraking");
                        break;
                    }
                    position.set("alarm", "hardCornering");
                }
            }
            position.setTime(this.readDate(buf));
            if (type == 6) {
                short status = buf.readUnsignedByte();
                position.setValid(!BitUtil.check(status, 7));
                buf.skipBytes(5);
            } else {
                position.setValid(true);
            }
            position.setAltitude(buf.readFloatLE());
            position.setLongitude(buf.readFloatLE());
            position.setLatitude(buf.readFloatLE());
            position.setSpeed(UnitsConverter.knotsFromKph((double)BcdUtil.readInteger(buf, 4) * 0.1));
            position.setCourse(buf.readUnsignedShort());
            position.set("rpm", buf.readUnsignedShort());
            return position;
        }
        if (type == 16) {
            return this.decodeBle(channel, deviceSession, buf, type, index, imei);
        }
        if (type == 129) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            buf.readUnsignedByte();
            position.set("result", buf.toString(StandardCharsets.UTF_16LE));
            return position;
        }
        return null;
    }

    private double decodeBleTemp(ByteBuf buf) {
        int value = buf.readUnsignedShort();
        return (double)(BitUtil.check(value, 15) ? -BitUtil.to(value, 15) : BitUtil.to(value, 15)) * 0.01;
    }

    private Position decodeBle(Channel channel, DeviceSession deviceSession, ByteBuf buf, int type, int index, ByteBuf imei) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, this.readDate(buf));
        position.set("ignition", buf.readUnsignedByte() > 0);
        int i = 1;
        while (buf.isReadable()) {
            switch (buf.readUnsignedShort()) {
                case 1: {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)buf.readUnsignedByte() * 0.01 + 1.22);
                    position.set("tag" + i + "TirePressure", (double)buf.readUnsignedByte() * 1.527 * 2.0);
                    position.set("tag" + i + "TireTemp", buf.readUnsignedByte() - 55);
                    position.set("tag" + i + "TireStatus", buf.readUnsignedByte());
                    break;
                }
                case 2: {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)BcdUtil.readInteger(buf, 2) * 0.1);
                    switch (buf.readUnsignedByte()) {
                        case 0: {
                            position.set("alarm", "sos");
                            break;
                        }
                        case 1: {
                            position.set("alarm", "lowBattery");
                            break;
                        }
                    }
                    buf.readUnsignedByte();
                    buf.skipBytes(16);
                    break;
                }
                case 3: {
                    position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)BcdUtil.readInteger(buf, 2) * 0.1);
                    if (buf.readUnsignedByte() == 1) {
                        position.set("alarm", "lowBattery");
                    }
                    buf.readUnsignedByte();
                    buf.skipBytes(16);
                    break;
                }
                case 4: {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)buf.readUnsignedByte() * 0.01 + 2.0);
                    buf.readUnsignedByte();
                    position.set("tag" + i + "Temp", this.decodeBleTemp(buf));
                    position.set("tag" + i + "Humidity", (double)buf.readUnsignedShort() * 0.01);
                    position.set("tag" + i + "LightSensor", buf.readUnsignedShort());
                    position.set("tag" + i + "Rssi", buf.readUnsignedByte() - 128);
                    break;
                }
                case 5: {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)buf.readUnsignedByte() * 0.01 + 2.0);
                    buf.readUnsignedByte();
                    position.set("tag" + i + "Temp", this.decodeBleTemp(buf));
                    position.set("tag" + i + "Door", buf.readUnsignedByte() > 0);
                    position.set("tag" + i + "Rssi", buf.readUnsignedByte() - 128);
                    break;
                }
                case 6: {
                    position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                    position.set("tag" + i + "Battery", (double)buf.readUnsignedByte() * 0.01 + 2.0);
                    position.set("tag" + i + "Output", buf.readUnsignedByte() > 0);
                    position.set("tag" + i + "Rssi", buf.readUnsignedByte() - 128);
                }
            }
            ++i;
        }
        this.sendResponse(channel, this.header, type, index, imei, 0);
        return position;
    }

    private Position decodePosition(Channel channel, DeviceSession deviceSession, ByteBuf buf, int type, int index, ByteBuf imei) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", index);
        if (this.header != 10023) {
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            position.set("rssi", BitUtil.to(buf.readUnsignedShort(), 7));
        }
        short status = buf.readUnsignedByte();
        position.set("sat", BitUtil.to(status, 5));
        if (this.header != 10023) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            int io = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(io, 14));
            position.set("ac", BitUtil.check(io, 13));
            position.set("in3", BitUtil.check(io, 12));
            position.set("in4", BitUtil.check(io, 11));
            if (type == 19 || type == 20) {
                position.set("output", buf.readUnsignedByte());
                buf.readUnsignedByte();
            } else {
                position.set("out1", BitUtil.check(io, 7));
                position.set("out2", BitUtil.check(io, 8));
                position.set("out3", BitUtil.check(io, 9));
            }
            if (this.header != 9766) {
                int adcCount = type == 19 || type == 20 ? 5 : 2;
                for (int i = 1; i <= adcCount; ++i) {
                    String value = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(2));
                    if (value.equals("ffff")) continue;
                    position.set("adc" + i, (double)Integer.parseInt(value, 16) * 0.01);
                }
            }
        }
        short alarm = buf.readUnsignedByte();
        position.set("alarm", this.header != 10023 ? this.decodeAlarm1(alarm) : this.decodeAlarm2(alarm));
        position.set("alarmCode", Integer.valueOf(alarm));
        if (this.header != 10023) {
            buf.readUnsignedByte();
            position.set("odometer", buf.readUnsignedInt());
            int battery = BcdUtil.readInteger(buf, 2);
            position.set("batteryLevel", battery > 0 ? battery : 100);
        }
        if (BitUtil.check(status, 6)) {
            position.setValid(true);
            position.setTime(this.readDate(buf));
            position.setAltitude(buf.readFloatLE());
            position.setLongitude(buf.readFloatLE());
            position.setLatitude(buf.readFloatLE());
            position.setSpeed(UnitsConverter.knotsFromKph((double)BcdUtil.readInteger(buf, 4) * 0.1));
            position.setCourse(buf.readUnsignedShort());
        } else {
            this.getLastLocation(position, this.readDate(buf));
            int mcc = buf.readUnsignedShortLE();
            int mnc = buf.readUnsignedShortLE();
            if (mcc != 65535 && mnc != 65535) {
                Network network = new Network();
                for (int i = 0; i < 3; ++i) {
                    network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE()));
                }
                position.setNetwork(network);
            }
        }
        if (this.header == 10023) {
            byte[] accelerationBytes = new byte[5];
            buf.readBytes(accelerationBytes);
            long acceleration = new BigInteger(accelerationBytes).longValue();
            double accelerationZ = (double)BitUtil.between(acceleration, 8, 15) + (double)BitUtil.between(acceleration, 4, 8) * 0.1;
            if (!BitUtil.check(acceleration, 15)) {
                accelerationZ = -accelerationZ;
            }
            double accelerationY = (double)BitUtil.between(acceleration, 20, 27) + (double)BitUtil.between(acceleration, 16, 20) * 0.1;
            if (!BitUtil.check(acceleration, 27)) {
                accelerationY = -accelerationY;
            }
            double accelerationX = (double)BitUtil.between(acceleration, 28, 32) + (double)BitUtil.between(acceleration, 32, 39) * 0.1;
            if (!BitUtil.check(acceleration, 39)) {
                accelerationX = -accelerationX;
            }
            position.set("gSensor", "[" + accelerationX + "," + accelerationY + "," + accelerationZ + "]");
            int battery = BcdUtil.readInteger(buf, 2);
            position.set("batteryLevel", battery > 0 ? battery : 100);
            position.set("deviceTemp", Integer.valueOf(buf.readByte()));
            position.set("lightSensor", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("battery", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("solarPanel", (double)BcdUtil.readInteger(buf, 2) * 0.1);
            position.set("odometer", buf.readUnsignedInt());
            int inputStatus = buf.readUnsignedShort();
            position.set("ignition", BitUtil.check(inputStatus, 2));
            position.set("rssi", BitUtil.between(inputStatus, 4, 11));
            position.set("input", inputStatus);
            buf.readUnsignedShort();
            buf.readUnsignedInt();
            buf.readUnsignedByte();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
        } else {
            if (buf.readableBytes() >= 2) {
                position.set("power", (double)BcdUtil.readInteger(buf, 4) * 0.01);
            }
            if (buf.readableBytes() >= 19) {
                position.set("obdSpeed", (double)BcdUtil.readInteger(buf, 4) * 0.01);
                position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.001);
                position.set("fuelConsumption", (double)buf.readUnsignedInt() * 0.001);
                position.set("rpm", buf.readUnsignedShort());
                short value = buf.readUnsignedByte();
                if (value != 255) {
                    position.set("airInput", Integer.valueOf(value));
                }
                if (value != 255) {
                    position.set("airPressure", Integer.valueOf(value));
                }
                if (value != 255) {
                    position.set("coolantTemp", value - 40);
                }
                if (value != 255) {
                    position.set("airTemp", value - 40);
                }
                if (value != 255) {
                    position.set("engineLoad", Integer.valueOf(value));
                }
                if (value != 255) {
                    position.set("throttle", Integer.valueOf(value));
                }
                if (value != 255) {
                    position.set("fuel", Integer.valueOf(value));
                }
            }
        }
        boolean acknowledgement = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ACK.withPrefix(this.getProtocolName()), deviceSession.getDeviceId());
        if (acknowledgement || type == 4 || type == 20) {
            this.sendResponse(channel, this.header, type, this.header == 8995 ? 1 : index, imei, alarm);
        }
        return position;
    }
}

