/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class KhdProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 177;
    public static final int MSG_CONFIRMATION = 33;
    public static final int MSG_ON_DEMAND = 129;
    public static final int MSG_POSITION_UPLOAD = 128;
    public static final int MSG_POSITION_REUPLOAD = 142;
    public static final int MSG_ALARM = 130;
    public static final int MSG_ADMIN_NUMBER = 131;
    public static final int MSG_SEND_TEXT = 132;
    public static final int MSG_REPLY = 133;
    public static final int MSG_SMS_ALARM_SWITCH = 134;
    public static final int MSG_PERIPHERAL = 163;

    public KhdProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String[] readIdentifiers(ByteBuf buf) {
        String[] identifiers = new String[2];
        identifiers[0] = ByteBufUtil.hexDump((ByteBuf)buf, (int)buf.readerIndex(), (int)4);
        short b1 = buf.readUnsignedByte();
        int b2 = buf.readUnsignedByte() - 128;
        int b3 = buf.readUnsignedByte() - 128;
        short b4 = buf.readUnsignedByte();
        identifiers[1] = String.format("%02d%02d%02d%02d", b1, b2, b3, (int)b4);
        return identifiers;
    }

    private void decodeAlarmStatus(Position position, byte[] status) {
        if (BitUtil.check(status[0], 4)) {
            position.set("alarm", "lowPower");
        } else if (BitUtil.check(status[0], 6)) {
            position.set("alarm", "geofenceExit");
        } else if (BitUtil.check(status[0], 7)) {
            position.set("alarm", "geofenceEnter");
        } else if (BitUtil.check(status[1], 0)) {
            position.set("alarm", "sos");
        } else if (BitUtil.check(status[1], 1)) {
            position.set("alarm", "overspeed");
        } else if (BitUtil.check(status[1], 3)) {
            position.set("alarm", "powerCut");
        } else if (BitUtil.check(status[1], 6)) {
            position.set("alarm", "tow");
        } else if (BitUtil.check(status[1], 7)) {
            position.set("alarm", "door");
        } else if (BitUtil.check(status[2], 2)) {
            position.set("alarm", "temperature");
        } else if (BitUtil.check(status[2], 4)) {
            position.set("alarm", "tampering");
        } else if (BitUtil.check(status[2], 6)) {
            position.set("alarm", "fatigueDriving");
        } else if (BitUtil.check(status[2], 7)) {
            position.set("alarm", "idle");
        } else if (BitUtil.check(status[6], 3)) {
            position.set("alarm", "vibration");
        } else if (BitUtil.check(status[6], 4)) {
            position.set("alarm", "hardBraking");
        } else if (BitUtil.check(status[6], 5)) {
            position.set("alarm", "hardAcceleration");
        } else if (BitUtil.check(status[6], 6)) {
            position.set("alarm", "hardCornering");
        } else if (BitUtil.check(status[6], 7)) {
            position.set("alarm", "accident");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 177 || type == 131 || type == 132 || type == 134 || type == 142) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(41);
            response.writeByte(41);
            response.writeByte(33);
            response.writeShort(5);
            response.writeByte((int)buf.getByte(buf.writerIndex() - 2));
            response.writeByte((int)type);
            response.writeByte(buf.writerIndex() > 9 ? (int)buf.getByte(9) : 0);
            response.writeByte(Checksum.xor(response.nioBuffer()));
            response.writeByte(13);
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        }
        if (type != 129 && type != 128 && type != 142 && type != 130 && type != 133 && type != 163) return null;
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readIdentifiers(buf));
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        position.setTime(dateBuilder.getDate());
        position.setLatitude(BcdUtil.readCoordinate(buf));
        position.setLongitude(BcdUtil.readCoordinate(buf));
        position.setSpeed(UnitsConverter.knotsFromKph(BcdUtil.readInteger(buf, 4)));
        position.setCourse(BcdUtil.readInteger(buf, 4));
        position.setValid((buf.readUnsignedByte() & 0x80) != 0);
        if (type != 130) {
            int odometer = buf.readUnsignedMedium();
            if (BitUtil.to(odometer, 16) > 0) {
                position.set("odometer", odometer);
            } else if (odometer > 0) {
                position.set("fuel", BitUtil.from(odometer, 16));
            }
            long status = buf.readUnsignedInt();
            position.set("ignition", !BitUtil.check(status, 31));
            position.set("status", status);
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.set("result", String.valueOf(buf.readUnsignedByte()));
            if (type != 163) return position;
            buf.readUnsignedShort();
            short dataType = buf.readUnsignedByte();
            short dataLength = buf.readUnsignedByte();
            switch (dataType) {
                case 1: {
                    position.set("fuel", buf.readUnsignedByte() * 100 + buf.readUnsignedByte());
                    return position;
                }
                case 2: {
                    position.set("temp1", buf.readUnsignedByte() * 100 + buf.readUnsignedByte());
                    return position;
                }
                case 5: {
                    short sign = buf.readUnsignedByte();
                    switch (sign) {
                        case 1: {
                            position.set("sign", true);
                            break;
                        }
                        case 2: {
                            position.set("sign", false);
                            break;
                        }
                    }
                    position.set("driverUniqueId", BufferUtil.readString(buf, dataLength - 1));
                    return position;
                }
                case 24: {
                    for (int i = 1; i <= 4; ++i) {
                        double value = buf.readUnsignedShort();
                        if (!(value > 0.0) || !(value < 65535.0)) continue;
                        position.set("fuel" + i, value / 65534.0);
                    }
                    return position;
                }
                case 32: {
                    position.set("batteryLevel", buf.readUnsignedByte());
                    return position;
                }
                case 35: {
                    Network network = new Network();
                    int count = buf.readUnsignedByte();
                    for (int i = 0; i < count; ++i) {
                        network.addCellTower(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
                    }
                    if (count <= 0) return position;
                    position.setNetwork(network);
                }
            }
            return position;
        }
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        byte[] alarmStatus = new byte[8];
        buf.readBytes(alarmStatus);
        this.decodeAlarmStatus(position, alarmStatus);
        return position;
    }
}

