/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.LifecycleObject;
import org.traccar.MainModule;
import org.traccar.ServerManager;
import org.traccar.WindowsService;
import org.traccar.broadcast.BroadcastService;
import org.traccar.schedule.ScheduleManager;
import org.traccar.storage.DatabaseModule;
import org.traccar.web.WebModule;
import org.traccar.web.WebServer;

public final class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static Injector injector;

    public static Injector getInjector() {
        return injector;
    }

    private Main() {
    }

    public static void logSystemInfo() {
        try {
            OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
            LOGGER.info("Operating system name: {} version: {} architecture: {}", new Object[]{operatingSystemBean.getName(), operatingSystemBean.getVersion(), operatingSystemBean.getArch()});
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            LOGGER.info("Java runtime name: {} vendor: {} version: {}", new Object[]{runtimeBean.getVmName(), runtimeBean.getVmVendor(), runtimeBean.getVmVersion()});
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            LOGGER.info("Memory limit heap: {}mb non-heap: {}mb", (Object)(memoryBean.getHeapMemoryUsage().getMax() / 0x100000L), (Object)(memoryBean.getNonHeapMemoryUsage().getMax() / 0x100000L));
            LOGGER.info("Character encoding: {}", (Object)Charset.defaultCharset().displayName());
        }
        catch (Exception error) {
            LOGGER.warn("Failed to get system info");
        }
    }

    public static void main(String[] args) throws Exception {
        String configFile;
        Locale.setDefault(Locale.ENGLISH);
        if (args.length <= 0) {
            configFile = "./debug.xml";
            if (!new File(configFile).exists()) {
                throw new RuntimeException("Configuration file is not provided");
            }
        } else {
            configFile = args[args.length - 1];
        }
        if (args.length > 0 && args[0].startsWith("--")) {
            WindowsService windowsService = new WindowsService("traccar"){

                @Override
                public void run() {
                    Main.run(configFile);
                }
            };
            switch (args[0]) {
                case "--install": {
                    windowsService.install("traccar", null, null, null, null, configFile);
                    return;
                }
                case "--uninstall": {
                    windowsService.uninstall();
                    return;
                }
            }
            windowsService.init();
        } else {
            Main.run(configFile);
        }
    }

    public static void run(String configFile) {
        try {
            injector = Guice.createInjector((Module[])new Module[]{new MainModule(configFile), new DatabaseModule(), new WebModule()});
            Main.logSystemInfo();
            LOGGER.info("Version: {}", (Object)Main.class.getPackage().getImplementationVersion());
            LOGGER.info("Starting server...");
            ArrayList<LifecycleObject> services = new ArrayList<LifecycleObject>();
            for (Class<BroadcastService> clazz : List.of(ScheduleManager.class, ServerManager.class, WebServer.class, BroadcastService.class)) {
                LifecycleObject service = (LifecycleObject)injector.getInstance(clazz);
                if (service == null) continue;
                service.start();
                services.add(service);
            }
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOGGER.error("Thread exception", e));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.info("Stopping server...");
                for (LifecycleObject service : services) {
                    try {
                        service.stop();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
        }
        catch (Exception e2) {
            Throwable unwrapped = e2 instanceof ProvisionException ? e2.getCause() : e2;
            LOGGER.error("Main method error", unwrapped);
            System.exit(1);
        }
    }
}

