/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesHolder;

public class JRPropertiesMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 10200L;
    private Map propertiesMap;
    private List propertiesList;
    private JRPropertiesMap base;

    public JRPropertiesMap() {
    }

    public JRPropertiesMap(JRPropertiesMap propertiesMap) {
        this();
        this.base = propertiesMap.base;
        String[] propertyNames = propertiesMap.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.setProperty(propertyNames[i], propertiesMap.getProperty(propertyNames[i]));
            }
        }
    }

    protected synchronized void ensureInit() {
        if (this.propertiesMap == null) {
            this.init();
        }
    }

    private void init() {
        this.propertiesMap = new HashMap();
        this.propertiesList = new ArrayList();
    }

    public String[] getPropertyNames() {
        String[] names;
        if (this.hasOwnProperties()) {
            if (this.base == null) {
                names = this.propertiesList.toArray(new String[this.propertiesList.size()]);
            } else {
                LinkedHashSet namesSet = new LinkedHashSet();
                this.collectPropertyNames(namesSet);
                names = namesSet.toArray(new String[namesSet.size()]);
            }
        } else {
            names = this.base != null ? this.base.getPropertyNames() : new String[]{};
        }
        return names;
    }

    protected void collectPropertyNames(Collection names) {
        if (this.base != null) {
            this.base.collectPropertyNames(names);
        }
        if (this.propertiesList != null) {
            names.addAll(this.propertiesList);
        }
    }

    public String getProperty(String propName) {
        String val = this.hasOwnProperty(propName) ? this.getOwnProperty(propName) : (this.base != null ? this.base.getProperty(propName) : null);
        return val;
    }

    public boolean containsProperty(String propName) {
        return this.hasOwnProperty(propName) || this.base != null && this.base.containsProperty(propName);
    }

    protected boolean hasOwnProperty(String propName) {
        return this.propertiesMap != null && this.propertiesMap.containsKey(propName);
    }

    protected String getOwnProperty(String propName) {
        return this.propertiesMap != null ? (String)this.propertiesMap.get(propName) : null;
    }

    public void setProperty(String propName, String value) {
        this.ensureInit();
        if (!this.hasOwnProperty(propName)) {
            this.propertiesList.add(propName);
        }
        this.propertiesMap.put(propName, value);
    }

    public void removeProperty(String propName) {
        if (this.hasOwnProperty(propName)) {
            this.propertiesList.remove(propName);
            this.propertiesMap.remove(propName);
        }
    }

    public JRPropertiesMap cloneProperties() {
        return new JRPropertiesMap(this);
    }

    public Object clone() {
        return this.cloneProperties();
    }

    public String toString() {
        return this.propertiesMap == null ? "" : this.propertiesMap.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.propertiesList == null && this.propertiesMap != null) {
            this.propertiesList = new ArrayList(this.propertiesMap.keySet());
            this.propertiesMap = new HashMap(this.propertiesMap);
        }
    }

    public boolean hasProperties() {
        return this.hasOwnProperties() || this.base != null && this.base.hasProperties();
    }

    public boolean hasOwnProperties() {
        return this.propertiesList != null && !this.propertiesList.isEmpty();
    }

    public static JRPropertiesMap getPropertiesClone(JRPropertiesHolder propertiesHolder) {
        JRPropertiesMap clone = propertiesHolder.hasProperties() ? propertiesHolder.getPropertiesMap().cloneProperties() : null;
        return clone;
    }

    public JRPropertiesMap getBaseProperties() {
        return this.base;
    }

    public void setBaseProperties(JRPropertiesMap base) {
        this.base = base;
    }
}

