/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import dotty.tools.backend.jvm.CompilationUnitInPostProcess;
import dotty.tools.backend.jvm.GeneratedClass;
import dotty.tools.backend.jvm.GeneratedClassHandler$;
import dotty.tools.backend.jvm.GeneratedCompilationUnit;
import dotty.tools.backend.jvm.GeneratedTasty;
import dotty.tools.backend.jvm.PostProcessor;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.Message;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.control.NonFatal$;

public interface GeneratedClassHandler {
    public static GeneratedClassHandler apply(PostProcessor postProcessor, Contexts.Context context) {
        return GeneratedClassHandler$.MODULE$.apply(postProcessor, context);
    }

    public PostProcessor postProcessor();

    public void process(GeneratedCompilationUnit var1);

    public void complete();

    public static void close$(GeneratedClassHandler $this) {
        $this.close();
    }

    default public void close() {
    }

    public static final class AsyncWritingClassHandler
    extends WritingClassHandler
    implements GeneratedClassHandler {
        private final PostProcessor postProcessor;
        private final ThreadPoolExecutor javaExecutor;

        public AsyncWritingClassHandler(PostProcessor postProcessor, ThreadPoolExecutor javaExecutor) {
            this.postProcessor = postProcessor;
            this.javaExecutor = javaExecutor;
            super(javaExecutor);
        }

        @Override
        public PostProcessor postProcessor() {
            return this.postProcessor;
        }

        @Override
        public ThreadPoolExecutor javaExecutor() {
            return this.javaExecutor;
        }

        public String toString() {
            return new StringBuilder(33).append("AsyncWriting[additional threads:").append(this.javaExecutor().getMaximumPoolSize()).append("]").toString();
        }

        @Override
        public void close() {
            GeneratedClassHandler.close$(this);
            this.javaExecutor().shutdownNow();
        }

        @Override
        public Option<Runnable> tryStealing() {
            return Option$.MODULE$.apply(this.javaExecutor().getQueue().poll());
        }
    }

    public static final class SyncWritingClassHandler
    extends WritingClassHandler {
        private final PostProcessor postProcessor;

        public SyncWritingClassHandler(PostProcessor postProcessor) {
            this.postProcessor = postProcessor;
            super(GeneratedClassHandler$.MODULE$.dotty$tools$backend$jvm$GeneratedClassHandler$$$SyncWritingClassHandler$superArg$1(postProcessor));
        }

        @Override
        public PostProcessor postProcessor() {
            return this.postProcessor;
        }

        public String toString() {
            return "SyncWriting";
        }

        @Override
        public Option<Runnable> tryStealing() {
            return None$.MODULE$;
        }
    }

    public static abstract class WritingClassHandler
    implements GeneratedClassHandler {
        private final Executor javaExecutor;
        private final ListBuffer<CompilationUnitInPostProcess> processingUnits;
        private final ExecutionContextExecutor executionContext;

        public WritingClassHandler(Executor javaExecutor) {
            this.javaExecutor = javaExecutor;
            this.processingUnits = ListBuffer$.MODULE$.empty();
            this.executionContext = ExecutionContext$.MODULE$.fromExecutor(javaExecutor);
        }

        public Executor javaExecutor() {
            return this.javaExecutor;
        }

        public abstract Option<Runnable> tryStealing();

        @Override
        public void process(GeneratedCompilationUnit unit) {
            CompilationUnitInPostProcess unitInPostProcess = new CompilationUnitInPostProcess(unit.classes(), unit.tasty(), unit.sourceFile(), unit.ctx());
            this.postProcessUnit(unitInPostProcess);
            this.processingUnits.$plus$eq((Object)unitInPostProcess);
        }

        public ExecutionContextExecutor executionContext() {
            return this.executionContext;
        }

        public final void postProcessUnit(CompilationUnitInPostProcess unitInPostProcess) {
            unitInPostProcess.task_$eq((Future<BoxedUnit>)Future$.MODULE$.apply((Function0 & Serializable)() -> {
                this.postProcessUnit$$anonfun$1(unitInPostProcess);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.executionContext()));
        }

        public List<CompilationUnitInPostProcess> takeProcessingUnits() {
            List result = this.processingUnits.result();
            this.processingUnits.clear();
            return result;
        }

        @Override
        public final void complete() {
            this.takeProcessingUnits().foreach((Function1)(JProcedure1 & Serializable)unitInPostProcess -> {
                try {
                    this.stealWhileWaiting$1((CompilationUnitInPostProcess)unitInPostProcess);
                    unitInPostProcess.bufferedReporting().relayReports(this.postProcessor().bTypes().frontendAccess().directBackendReporting());
                    ((Try)unitInPostProcess.task().value().get()).get();
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    throw new InterruptedException();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = (Throwable)option.get();
                        t.printStackTrace();
                        this.postProcessor().bTypes().frontendAccess().backendReporting().error((Function1<Contexts.Context, Message>)((Function1 & Serializable)arg_0 -> GeneratedClassHandler$.dotty$tools$backend$jvm$GeneratedClassHandler$WritingClassHandler$$_$complete$$anonfun$1$$anonfun$1(unitInPostProcess, t, arg_0)));
                    }
                    throw throwable;
                }
            });
        }

        private final void postProcessUnit$$anonfun$1$$anonfun$1(CompilationUnitInPostProcess unitInPostProcess$2) {
            unitInPostProcess$2.takeClasses().foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.postProcessor().sendToDisk((GeneratedClass)_$1, unitInPostProcess$2.sourceFile()));
            unitInPostProcess$2.takeTasty().foreach((Function1)(JProcedure1 & Serializable)_$2 -> this.postProcessor().sendToDisk((GeneratedTasty)_$2, unitInPostProcess$2.sourceFile()));
        }

        private final void postProcessUnit$$anonfun$1(CompilationUnitInPostProcess unitInPostProcess$1) {
            this.postProcessor().bTypes().frontendAccess().withThreadLocalReporter(unitInPostProcess$1.bufferedReporting(), (Function0 & Serializable)() -> {
                this.postProcessUnit$$anonfun$1$$anonfun$1(unitInPostProcess$1);
                return BoxedUnit.UNIT;
            });
        }

        private final void stealWhileWaiting$1(CompilationUnitInPostProcess unitInPostProcess) {
            Future<BoxedUnit> task = unitInPostProcess.task();
            while (!task.isCompleted()) {
                Option<Runnable> option = this.tryStealing();
                if (option instanceof Some) {
                    Runnable r = (Runnable)((Some)option).value();
                    r.run();
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Await$.MODULE$.ready(task, (Duration)Duration$.MODULE$.Inf());
                    continue;
                }
                throw new MatchError(option);
            }
        }
    }
}

