/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public abstract class BasicResolver
extends AbstractResolver {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String workspaceName;
    private boolean envDependent = true;
    private List ivyattempts = new ArrayList();
    private Map artattempts = new HashMap();
    private boolean checkconsistency = true;
    private boolean allownomd = true;
    private boolean force = false;
    private String checksums = null;
    private URLRepository extartifactrep = new URLRepository();
    private final ArtifactResourceResolver artifactResourceResolver = new ArtifactResourceResolver(){

        @Override
        public ResolvedResource resolve(Artifact artifact) {
            artifact = BasicResolver.this.fromSystem(artifact);
            return BasicResolver.this.getArtifactRef(artifact, null);
        }
    };
    private final ResourceDownloader downloader = new ResourceDownloader(){

        @Override
        public void download(Artifact artifact, Resource resource, File file) throws IOException {
            if (file.exists()) {
                file.delete();
            }
            File file2 = new File(file.getAbsolutePath() + ".part");
            if (resource.getName().equals(String.valueOf(artifact.getUrl()))) {
                if (file2.getParentFile() != null) {
                    file2.getParentFile().mkdirs();
                }
                BasicResolver.this.extartifactrep.get(resource.getName(), file2);
            } else {
                BasicResolver.this.getAndCheck(resource, file2);
            }
            if (!file2.renameTo(file)) {
                throw new IOException("impossible to move part file to definitive one: " + file2 + " -> " + file);
            }
        }
    };

    public BasicResolver() {
        this.workspaceName = HostUtil.getLocalHostName();
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        Object object;
        Object object2 = IvyContext.pushNewCopyContext();
        try {
            Object object3;
            object = resolveData.getCurrentResolvedModuleRevision();
            if (object != null && this.shouldReturnResolvedModule(dependencyDescriptor, (ResolvedModuleRevision)object)) {
                return object;
            }
            if (this.isForce()) {
                DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
                dependencyDescriptor = dependencyDescriptor2.clone(ModuleRevisionId.newInstance(dependencyDescriptor2.getDependencyRevisionId(), "latest.integration"));
            }
            object = dependencyDescriptor;
            ExtendableItem extendableItem = this.fromSystem(dependencyDescriptor);
            ((IvyContext)object2).setDependencyDescriptor((DependencyDescriptor)object);
            ((IvyContext)object2).setResolveData(resolveData);
            this.clearIvyAttempts();
            this.clearArtifactAttempts();
            object2 = object.getDependencyRevisionId();
            Object object4 = extendableItem.getDependencyRevisionId();
            this.checkRevision((ModuleRevisionId)object2);
            boolean bl = this.getAndCheckIsDynamic((ModuleRevisionId)object2);
            ResolvedModuleRevision resolvedModuleRevision = this.findModuleInCache((DependencyDescriptor)object, resolveData);
            if (resolvedModuleRevision != null) {
                if (resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + object2 + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else if (this.isForce() && resolvedModuleRevision.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + object2 + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but we are in force mode, let's try to find one ourself");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + object2);
                    ResolvedModuleRevision resolvedModuleRevision2 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision), resolveData);
                    return resolvedModuleRevision2;
                }
            }
            if (resolveData.getOptions().isUseCacheOnly()) {
                throw new UnresolvedDependencyException("\t" + this.getName() + " (useCacheOnly) : no ivy file found for " + object2, false);
            }
            this.checkInterrupted();
            ResolvedResource resolvedResource = this.findIvyFileRef((DependencyDescriptor)extendableItem, resolveData);
            this.checkInterrupted();
            if (resolvedResource == null) {
                if (!this.isAllownomd()) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file found for " + object2, false);
                }
                DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)object4, extendableItem.getAllDependencyArtifacts());
                object3 = this.findFirstArtifactRef(defaultModuleDescriptor, (DependencyDescriptor)extendableItem, resolveData);
                this.checkInterrupted();
                if (object3 == null) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file nor artifact found for " + object2, false);
                }
                long l = ((ResolvedResource)object3).getLastModified();
                if (l != 0L && defaultModuleDescriptor instanceof DefaultModuleDescriptor) {
                    defaultModuleDescriptor.setLastModified(l);
                }
                Message.verbose("\t" + this.getName() + ": no ivy file found for " + object2 + ": using default data");
                if (bl) {
                    defaultModuleDescriptor.setResolvedModuleRevisionId(ModuleRevisionId.newInstance((ModuleRevisionId)object4, ((ResolvedResource)object3).getRevision()));
                }
                extendableItem = this.toSystem(defaultModuleDescriptor);
                object4 = new MetadataArtifactDownloadReport(extendableItem.getMetadataArtifact());
                ((ArtifactDownloadReport)object4).setDownloadStatus(DownloadStatus.NO);
                ((MetadataArtifactDownloadReport)object4).setSearched(true);
                BasicResolver basicResolver = this;
                resolvedModuleRevision = new ResolvedModuleRevision(basicResolver, basicResolver, (ModuleDescriptor)extendableItem, (MetadataArtifactDownloadReport)object4, this.isForce());
                this.getRepositoryCacheManager().cacheModuleDescriptor(this, (ResolvedResource)object3, this.toSystem(dependencyDescriptor), extendableItem.getAllArtifacts()[0], null, this.getCacheOptions(resolveData));
            } else {
                if (resolvedResource instanceof MDResolvedResource) {
                    resolvedModuleRevision = ((MDResolvedResource)resolvedResource).getResolvedModuleRevision();
                }
                if (resolvedModuleRevision == null && (resolvedModuleRevision = this.parse(resolvedResource, (DependencyDescriptor)object, resolveData)) == null) {
                    throw new UnresolvedDependencyException();
                }
                if (!resolvedModuleRevision.getReport().isDownloaded() && resolvedModuleRevision.getReport().getLocalFile() != null) {
                    ResolvedModuleRevision resolvedModuleRevision3 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision), resolveData);
                    return resolvedModuleRevision3;
                }
                ModuleDescriptor moduleDescriptor = resolvedModuleRevision.getDescriptor();
                extendableItem = this.toSystem(moduleDescriptor);
                if (this.isCheckconsistency()) {
                    this.checkDescriptorConsistency((ModuleRevisionId)object2, (ModuleDescriptor)extendableItem, resolvedResource);
                    this.checkDescriptorConsistency((ModuleRevisionId)object4, moduleDescriptor, resolvedResource);
                } else if (extendableItem instanceof DefaultModuleDescriptor) {
                    object3 = (DefaultModuleDescriptor)extendableItem;
                    ModuleRevisionId moduleRevisionId = this.getRevision(resolvedResource, (ModuleRevisionId)object2, (ModuleDescriptor)extendableItem);
                    ((DefaultModuleDescriptor)object3).setModuleRevisionId(moduleRevisionId);
                    ((DefaultModuleDescriptor)object3).setResolvedModuleRevisionId(moduleRevisionId);
                } else {
                    Message.warn("consistency disabled with instance of non DefaultModuleDescriptor... module info can't be updated, so consistency check will be done");
                    this.checkDescriptorConsistency((ModuleRevisionId)object4, moduleDescriptor, resolvedResource);
                    this.checkDescriptorConsistency((ModuleRevisionId)object2, (ModuleDescriptor)extendableItem, resolvedResource);
                }
                BasicResolver basicResolver = this;
                resolvedModuleRevision = new ResolvedModuleRevision(basicResolver, basicResolver, (ModuleDescriptor)extendableItem, this.toSystem(resolvedModuleRevision.getReport()), this.isForce());
            }
            this.resolveAndCheckRevision((ModuleDescriptor)extendableItem, (ModuleRevisionId)object2, resolvedResource, bl);
            this.resolveAndCheckPublicationDate((DependencyDescriptor)object, (ModuleDescriptor)extendableItem, (ModuleRevisionId)object2, resolveData);
            this.checkNotConvertedExclusionRule((ModuleDescriptor)extendableItem, resolvedResource, resolveData);
            if (resolvedResource == null || resolvedResource.getResource() != null) {
                this.cacheModuleDescriptor((ModuleDescriptor)extendableItem, (ModuleRevisionId)object2, resolvedResource, resolvedModuleRevision);
            }
            object3 = this.checkLatest((DependencyDescriptor)object, this.checkForcedResolvedModuleRevision(resolvedModuleRevision), resolveData);
            return object3;
        }
        catch (UnresolvedDependencyException unresolvedDependencyException) {
            object = unresolvedDependencyException;
            if (unresolvedDependencyException.getMessage().length() > 0) {
                if (((UnresolvedDependencyException)object).isError()) {
                    Message.error(((Throwable)object).getMessage());
                } else {
                    Message.verbose(((Throwable)object).getMessage());
                }
            }
            object = resolveData.getCurrentResolvedModuleRevision();
            return object;
        }
        finally {
            IvyContext.popContext();
        }
    }

    protected boolean shouldReturnResolvedModule(DependencyDescriptor extendableItem, ResolvedModuleRevision resolvedModuleRevision) {
        extendableItem = extendableItem.getDependencyRevisionId();
        boolean bl = this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)extendableItem);
        boolean bl2 = resolvedModuleRevision.isForce();
        bl2 |= !bl && !resolvedModuleRevision.getDescriptor().isDefault();
        return bl2 &= !this.isForce();
    }

    private ResolvedModuleRevision checkForcedResolvedModuleRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return null;
        }
        if (!this.isForce() || resolvedModuleRevision.isForce()) {
            return resolvedModuleRevision;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), resolvedModuleRevision.getArtifactResolver(), resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), true);
    }

    private void cacheModuleDescriptor(ModuleDescriptor extendableItem, ModuleRevisionId moduleRevisionId, ResolvedResource resolvedResource, ResolvedModuleRevision resolvedModuleRevision) {
        RepositoryCacheManager repositoryCacheManager = this.getRepositoryCacheManager();
        final ModuleDescriptorParser moduleDescriptorParser = extendableItem.getParser();
        extendableItem = resolvedResource == null ? extendableItem.getMetadataArtifact() : moduleDescriptorParser.getMetadataArtifact(ModuleRevisionId.newInstance(moduleRevisionId, resolvedResource.getRevision()), resolvedResource.getResource());
        repositoryCacheManager.originalToCachedModuleDescriptor(this, resolvedResource, (Artifact)extendableItem, resolvedModuleRevision, new ModuleDescriptorWriter(){

            @Override
            public void write(ResolvedResource resolvedResource, ModuleDescriptor moduleDescriptor, File file, File file2) throws IOException, ParseException {
                if (resolvedResource == null) {
                    XmlModuleDescriptorWriter.write(moduleDescriptor, file2);
                    return;
                }
                moduleDescriptorParser.toIvyFile(new FileInputStream(file), resolvedResource.getResource(), file2, moduleDescriptor);
                long l = resolvedResource.getLastModified();
                if (l > 0L) {
                    file2.setLastModified(l);
                }
            }
        });
    }

    private void checkNotConvertedExclusionRule(ModuleDescriptor moduleDescriptor, ResolvedResource resolvedResource, ResolveData resolveData) {
        if (!this.getNamespace().equals(Namespace.SYSTEM_NAMESPACE) && !moduleDescriptor.isDefault() && resolveData.getSettings().logNotConvertedExclusionRule() && moduleDescriptor instanceof DefaultModuleDescriptor && ((DefaultModuleDescriptor)(moduleDescriptor = (DefaultModuleDescriptor)moduleDescriptor)).isNamespaceUseful()) {
            Message.warn("the module descriptor " + resolvedResource.getResource() + " has information which can't be converted into the system namespace. It will require the availability of the namespace '" + this.getNamespace().getName() + "' to be fully usable.");
        }
    }

    private void resolveAndCheckPublicationDate(DependencyDescriptor dependencyDescriptor, ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ResolveData resolveData) {
        if (resolveData.getDate() != null) {
            long l = this.getPublicationDate(moduleDescriptor, dependencyDescriptor, resolveData);
            if (l > resolveData.getDate().getTime()) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(l) + " required=" + resolveData.getDate());
            }
            if (l == -1L) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + moduleRevisionId);
            }
            moduleDescriptor.setResolvedPublicationDate(new Date(l));
        }
    }

    protected void checkModuleDescriptorRevision(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId) {
        if (!this.getSettings().getVersionMatcher().accept(moduleRevisionId, moduleDescriptor)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable revision => was=" + moduleDescriptor.getResolvedModuleRevisionId().getRevision() + " required=" + moduleRevisionId.getRevision());
        }
    }

    private boolean getAndCheckIsDynamic(ModuleRevisionId moduleRevisionId) {
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        if (bl && !this.acceptLatest()) {
            throw new UnresolvedDependencyException("dynamic revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + moduleRevisionId);
        }
        return bl;
    }

    private void checkRevision(ModuleRevisionId moduleRevisionId) {
        int n = moduleRevisionId.getRevision().indexOf("@");
        if (n != -1 && !moduleRevisionId.getRevision().substring(n + 1).equals(this.workspaceName)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unhandled revision => " + moduleRevisionId.getRevision());
        }
    }

    private void resolveAndCheckRevision(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ResolvedResource resolvedResource, boolean bl) {
        ModuleRevisionId moduleRevisionId2 = moduleDescriptor.getResolvedModuleRevisionId();
        if (moduleRevisionId2.getRevision() == null || moduleRevisionId2.getRevision().length() == 0 || moduleRevisionId2.getRevision().startsWith("working@")) {
            moduleRevisionId2 = !bl ? ModuleRevisionId.newInstance(moduleRevisionId2, moduleRevisionId.getRevision()) : (resolvedResource == null ? moduleDescriptor.getMetadataArtifact().getModuleRevisionId() : (resolvedResource.getRevision() == null || resolvedResource.getRevision().length() == 0 ? ModuleRevisionId.newInstance(moduleRevisionId2, "working@" + this.getName()) : ModuleRevisionId.newInstance(moduleRevisionId2, resolvedResource.getRevision())));
        }
        if (bl) {
            Message.verbose("\t\t[" + this.toSystem(moduleRevisionId2).getRevision() + "] " + moduleRevisionId.getModuleId());
        }
        moduleDescriptor.setResolvedModuleRevisionId(moduleRevisionId2);
        this.checkModuleDescriptorRevision(moduleDescriptor, moduleRevisionId);
    }

    private ModuleRevisionId getRevision(ResolvedResource object, ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) throws ParseException {
        HashMap hashMap = new HashMap();
        hashMap.putAll(moduleDescriptor.getQualifiedExtraAttributes());
        hashMap.putAll(moduleRevisionId.getQualifiedExtraAttributes());
        object = ((ResolvedResource)object).getRevision();
        if (object == null) {
            Message.debug("no revision found in reference for " + moduleRevisionId);
            if (this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId)) {
                if (moduleDescriptor.getModuleRevisionId().getRevision() == null) {
                    object = "working@" + this.getName();
                } else {
                    Message.debug("using " + moduleRevisionId);
                    object = moduleRevisionId.getRevision();
                }
            } else {
                Message.debug("using " + moduleRevisionId);
                object = moduleRevisionId.getRevision();
            }
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), (String)object, hashMap);
    }

    public ResolvedModuleRevision parse(ResolvedResource resolvedResource, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        dependencyDescriptor = this.toSystem(dependencyDescriptor);
        Object object = dependencyDescriptor.getDependencyRevisionId();
        ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
        if (moduleDescriptorParser == null) {
            Message.warn("no module descriptor parser available for " + resolvedResource.getResource());
            return null;
        }
        Message.verbose("\t" + this.getName() + ": found md file for " + object);
        Message.verbose("\t\t=> " + resolvedResource);
        Message.debug("\tparser = " + moduleDescriptorParser);
        ModuleRevisionId moduleRevisionId = object;
        if (this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)object) && (object = resolveData.getNode(moduleRevisionId = ModuleRevisionId.newInstance((ModuleRevisionId)object, resolvedResource.getRevision()))) != null && ((IvyNode)object).getModuleRevision() != null) {
            if (((IvyNode)object).getDescriptor() != null && ((IvyNode)object).getDescriptor().isDefault()) {
                Message.verbose("\t" + this.getName() + ": found already resolved revision: " + moduleRevisionId + ": but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + moduleRevisionId);
                ((IvyNode)object).getModuleRevision().getReport().setSearched(true);
                return ((IvyNode)object).getModuleRevision();
            }
        }
        object = moduleDescriptorParser.getMetadataArtifact(moduleRevisionId, resolvedResource.getResource());
        return this.getRepositoryCacheManager().cacheModuleDescriptor(this, resolvedResource, dependencyDescriptor, (Artifact)object, this.downloader, this.getCacheOptions(resolveData));
    }

    protected ResourceMDParser getRMDParser(final DependencyDescriptor dependencyDescriptor, final ResolveData resolveData) {
        return new ResourceMDParser(){

            @Override
            public MDResolvedResource parse(Resource resource, String string) {
                try {
                    ResolvedModuleRevision resolvedModuleRevision = BasicResolver.this.parse(new ResolvedResource(resource, string), dependencyDescriptor, resolveData);
                    if (resolvedModuleRevision == null) {
                        return null;
                    }
                    return new MDResolvedResource(resource, string, resolvedModuleRevision);
                }
                catch (ParseException parseException) {
                    Message.warn("Failed to parse the file '" + resource + "': " + parseException.getMessage());
                    return null;
                }
            }
        };
    }

    protected ResourceMDParser getDefaultRMDParser(final ModuleId moduleId) {
        return new ResourceMDParser(){

            @Override
            public MDResolvedResource parse(Resource resource, String string) {
                DefaultModuleDescriptor defaultModuleDescriptor = DefaultModuleDescriptor.newDefaultInstance(new ModuleRevisionId(moduleId, string));
                MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(defaultModuleDescriptor.getMetadataArtifact());
                metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                metadataArtifactDownloadReport.setSearched(true);
                return new MDResolvedResource(resource, string, new ResolvedModuleRevision(BasicResolver.this, BasicResolver.this, defaultModuleDescriptor, metadataArtifactDownloadReport, BasicResolver.this.isForce()));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void checkDescriptorConsistency(ModuleRevisionId object2, ModuleDescriptor moduleDescriptor, ResolvedResource resolvedResource) throws ParseException {
        void var3_7;
        void var2_6;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (!((ModuleRevisionId)object2).getOrganisation().equals(var2_6.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + var3_7.getResource() + ": expected='" + ((ModuleRevisionId)object2).getOrganisation() + "' found='" + var2_6.getModuleRevisionId().getOrganisation() + "'");
            stringBuffer.append("bad organisation: expected='" + ((ModuleRevisionId)object2).getOrganisation() + "' found='" + var2_6.getModuleRevisionId().getOrganisation() + "'; ");
            bl = false;
        }
        if (!((ModuleRevisionId)object2).getName().equals(var2_6.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + var3_7.getResource() + ": expected='" + ((ModuleRevisionId)object2).getName() + " found='" + var2_6.getModuleRevisionId().getName() + "'");
            stringBuffer.append("bad module name: expected='" + ((ModuleRevisionId)object2).getName() + "' found='" + var2_6.getModuleRevisionId().getName() + "'; ");
            bl = false;
        }
        if (((ModuleRevisionId)object2).getBranch() != null && !((ModuleRevisionId)object2).getBranch().equals(var2_6.getModuleRevisionId().getBranch())) {
            Message.error("\t" + this.getName() + ": bad branch name found in " + var3_7.getResource() + ": expected='" + ((ModuleRevisionId)object2).getBranch() + " found='" + var2_6.getModuleRevisionId().getBranch() + "'");
            stringBuffer.append("bad branch name: expected='" + ((ModuleRevisionId)object2).getBranch() + "' found='" + var2_6.getModuleRevisionId().getBranch() + "'; ");
            bl = false;
        }
        if (var3_7.getRevision() != null && !var3_7.getRevision().startsWith("working@")) {
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance((ModuleRevisionId)object2, var3_7.getRevision());
            if (!this.getSettings().getVersionMatcher().accept(moduleRevisionId, (ModuleDescriptor)var2_6)) {
                Message.error("\t" + this.getName() + ": bad revision found in " + var3_7.getResource() + ": expected='" + var3_7.getRevision() + " found='" + var2_6.getModuleRevisionId().getRevision() + "'");
                stringBuffer.append("bad revision: expected='" + var3_7.getRevision() + "' found='" + var2_6.getModuleRevisionId().getRevision() + "'; ");
                bl = false;
            }
        }
        if (!this.getSettings().getStatusManager().isStatus(var2_6.getStatus())) {
            Message.error("\t" + this.getName() + ": bad status found in " + var3_7.getResource() + ": '" + var2_6.getStatus() + "'");
            stringBuffer.append("bad status: '" + var2_6.getStatus() + "'; ");
            bl = false;
        }
        for (Map.Entry entry : ((UnmodifiableExtendableItem)object2).getExtraAttributes().entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(var2_6.getExtraAttribute((String)entry.getKey()))) continue;
            String string = "bad " + entry.getKey() + " found in " + var3_7.getResource() + ": expected='" + entry.getValue() + "' found='" + var2_6.getExtraAttribute((String)entry.getKey()) + "'";
            Message.error("\t" + this.getName() + ": " + string);
            stringBuffer.append(string + ";");
            bl = false;
        }
        if (!bl) {
            throw new ParseException("inconsistent module descriptor file found in '" + var3_7.getResource() + "': " + stringBuffer, 0);
        }
    }

    public ResolvedResource findResource(ResolvedResource[] object, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        Object object2;
        Object object3;
        String string = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        Object object4 = null;
        object = this.getLatestStrategy().sort((ArtifactInfo[])object);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        IvyContext ivyContext = IvyContext.getContext();
        Object object5 = object;
        object = object5.listIterator(object5.size());
        while (object.hasPrevious()) {
            object3 = (ResolvedResource)object.previous();
            if (this.filterNames(new ArrayList<String>(Collections.singleton(((ResolvedResource)object3).getRevision()))).isEmpty()) {
                Message.debug("\t" + string + ": filtered by name: " + object3);
                continue;
            }
            object2 = ModuleRevisionId.newInstance(moduleRevisionId, ((ResolvedResource)object3).getRevision());
            Object object6 = ivyContext.getResolveData();
            if (object6 != null && ((ResolveData)object6).getReport() != null) {
                ResolveData resolveData = object6;
                if (resolveData.isBlacklisted(resolveData.getReport().getConfiguration(), (ModuleRevisionId)object2)) {
                    Message.debug("\t" + string + ": blacklisted: " + object3);
                    arrayList.add(((ResolvedResource)object3).getRevision() + " (blacklisted)");
                    arrayList2.add(object2);
                    continue;
                }
            }
            if (!versionMatcher.accept(moduleRevisionId, (ModuleRevisionId)object2)) {
                Message.debug("\t" + string + ": rejected by version matcher: " + object3);
                arrayList.add(((ResolvedResource)object3).getRevision());
                continue;
            }
            if (((ResolvedResource)object3).getResource() != null && !((ResolvedResource)object3).getResource().exists()) {
                Message.debug("\t" + string + ": unreachable: " + object3 + "; res=" + ((ResolvedResource)object3).getResource());
                arrayList.add(((ResolvedResource)object3).getRevision() + " (unreachable)");
                continue;
            }
            if (date != null && ((ResolvedResource)object3).getLastModified() > date.getTime()) {
                Message.verbose("\t" + string + ": too young: " + object3);
                arrayList.add(((ResolvedResource)object3).getRevision() + " (" + ((ResolvedResource)object3).getLastModified() + ")");
                continue;
            }
            if (versionMatcher.needModuleDescriptor(moduleRevisionId, (ModuleRevisionId)object2)) {
                object2 = resourceMDParser.parse(((ResolvedResource)object3).getResource(), ((ResolvedResource)object3).getRevision());
                if (object2 == null) {
                    Message.debug("\t" + string + ": impossible to get module descriptor resource: " + object3);
                    arrayList.add(((ResolvedResource)object3).getRevision() + " (no or bad MD)");
                    continue;
                }
                object6 = ((MDResolvedResource)object2).getResolvedModuleRevision().getDescriptor();
                if (object6.isDefault()) {
                    Message.debug("\t" + string + ": default md rejected by version matcherrequiring module descriptor: " + object3);
                    arrayList.add(((ResolvedResource)object3).getRevision() + " (MD)");
                    continue;
                }
                if (!versionMatcher.accept(moduleRevisionId, (ModuleDescriptor)object6)) {
                    Message.debug("\t" + string + ": md rejected by version matcher: " + object3);
                    arrayList.add(((ResolvedResource)object3).getRevision() + " (MD)");
                    continue;
                }
                object4 = object2;
            } else {
                object4 = object3;
            }
            if (object4 == null) continue;
        }
        if (object4 == null && !arrayList.isEmpty()) {
            this.logAttempt(((Object)arrayList).toString());
        }
        if (object4 == null && !arrayList2.isEmpty()) {
            object = ivyContext.getDependencyDescriptor();
            object3 = ivyContext.getResolveData().getNode(object.getParentRevisionId());
            object2 = ((IvyNode)object3).getConflictManager(moduleRevisionId.getModuleId());
            object2.handleAllBlacklistedRevisions((DependencyDescriptor)object, arrayList2);
        }
        return object4;
    }

    protected Collection filterNames(Collection collection) {
        this.getSettings().filterIgnore(collection);
        return collection;
    }

    protected void clearIvyAttempts() {
        this.ivyattempts.clear();
        this.clearArtifactAttempts();
    }

    protected void logIvyAttempt(String string) {
        this.ivyattempts.add(string);
        Message.verbose("\t\ttried " + string);
    }

    protected void logArtifactAttempt(Artifact artifact, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.artattempts.get(artifact);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.artattempts.put(artifact, arrayList);
        }
        arrayList.add(string);
        Message.verbose("\t\ttried " + string);
    }

    protected void logAttempt(String string) {
        Artifact artifact = (Artifact)IvyContext.getContext().get(this.getName() + ".artifact");
        if (artifact != null) {
            this.logArtifactAttempt(artifact, string);
            return;
        }
        this.logIvyAttempt(string);
    }

    @Override
    public void reportFailure() {
        Message.warn("==== " + this.getName() + ": tried");
        Iterator<Object> iterator = this.ivyattempts.listIterator();
        while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            Message.warn("  " + (String)object);
        }
        for (Object object : this.artattempts.keySet()) {
            Object object2 = (List)this.artattempts.get(object);
            if (object2 == null) continue;
            Message.warn("  -- artifact " + object + ":");
            object = object2.listIterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                Message.warn("  " + (String)object2);
            }
        }
    }

    @Override
    public void reportFailure(Artifact listIterator) {
        Message.warn("==== " + this.getName() + ": tried");
        listIterator = (List)this.artattempts.get(listIterator);
        if (listIterator != null) {
            listIterator = listIterator.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Message.warn("  " + string);
            }
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        RepositoryCacheManager repositoryCacheManager = this.getRepositoryCacheManager();
        this.clearArtifactAttempts();
        DownloadReport downloadReport = new DownloadReport();
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = repositoryCacheManager.download(artifactArray[i], this.artifactResourceResolver, this.downloader, this.getCacheDownloadOptions(downloadOptions));
            if (DownloadStatus.FAILED == artifactDownloadReport.getDownloadStatus()) {
                if (!"missing artifact".equals(artifactDownloadReport.getDownloadDetails())) {
                    Message.warn("\t" + artifactDownloadReport);
                }
            } else if (DownloadStatus.NO == artifactDownloadReport.getDownloadStatus()) {
                Message.verbose("\t" + artifactDownloadReport);
            } else if ("quiet".equals(downloadOptions.getLog())) {
                Message.verbose("\t" + artifactDownloadReport);
            } else {
                Message.info("\t" + artifactDownloadReport);
            }
            downloadReport.addArtifactReport(artifactDownloadReport);
            this.checkInterrupted();
        }
        return downloadReport;
    }

    protected void clearArtifactAttempts() {
        this.artattempts.clear();
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        Object object = this.getRepositoryCacheManager().getSavedArtifactOrigin(this.toSystem(artifact));
        if (!ArtifactOrigin.isUnknown((ArtifactOrigin)object)) {
            return object;
        }
        object = this.getArtifactRef(artifact, null);
        if (object != null && ((ResolvedResource)object).getResource().exists()) {
            return new ArtifactOrigin(artifact, ((ResolvedResource)object).getResource().isLocal(), ((ResolvedResource)object).getResource().getName());
        }
        return null;
    }

    protected long getPublicationDate(ModuleDescriptor artifactInfo, DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        if (artifactInfo.getPublicationDate() != null) {
            return artifactInfo.getPublicationDate().getTime();
        }
        if ((artifactInfo = this.findFirstArtifactRef((ModuleDescriptor)artifactInfo, dependencyDescriptor, resolveData)) != null) {
            return ((ResolvedResource)artifactInfo).getLastModified();
        }
        return -1L;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    protected ResolvedResource findFirstArtifactRef(ModuleDescriptor moduleDescriptor, DependencyDescriptor object, ResolveData resolveData) {
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(stringArray[i]);
            for (int j = 0; j < artifactArray.length; ++j) {
                object = this.getArtifactRef(artifactArray[j], resolveData.getDate());
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    protected long getAndCheck(Resource resource, File file) throws IOException {
        long l = this.get(resource, file);
        String[] stringArray = this.getChecksumAlgorithms();
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            bl = this.check(resource, file, stringArray[i]);
        }
        return l;
    }

    private boolean check(Resource resource, File file, String string) throws IOException {
        if (!ChecksumHelper.isKnownAlgorithm(string)) {
            throw new IllegalArgumentException("Unknown checksum algorithm: " + string);
        }
        Resource resource2 = resource.clone(resource.getName() + "." + string);
        if (resource2.exists()) {
            Message.debug(string + " file found for " + resource + ": checking...");
            File file2 = File.createTempFile("ivytmp", string);
            try {
                this.get(resource2, file2);
                try {
                    ChecksumHelper.check(file, file2, string);
                    Message.verbose(string + " OK for " + resource);
                    return true;
                }
                catch (IOException iOException) {
                    file.delete();
                    throw iOException;
                }
            }
            finally {
                file2.delete();
            }
        }
        return false;
    }

    protected ResolvedResource getArtifactRef(Artifact artifact, Date object) {
        IvyContext.getContext().set(this.getName() + ".artifact", artifact);
        try {
            object = this.findArtifactRef(artifact, (Date)object);
            if (object == null && artifact.getUrl() != null) {
                object = artifact.getUrl();
                Message.verbose("\tusing url for " + artifact + ": " + object);
                this.logArtifactAttempt(artifact, ((URL)object).toExternalForm());
                object = "file".equals(((URL)object).getProtocol()) ? new FileResource(new FileRepository(), new File(((URL)object).getPath())) : new URLResource((URL)object);
                object = new ResolvedResource((Resource)object, artifact.getModuleRevisionId().getRevision());
            }
            return object;
        }
        finally {
            IvyContext.getContext().set(this.getName() + ".artifact", null);
        }
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2) throws IOException;

    public boolean isCheckconsistency() {
        return this.checkconsistency;
    }

    public void setCheckconsistency(boolean bl) {
        this.checkconsistency = bl;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }

    public void setDescriptor(String string) {
        if ("required".equals(string)) {
            this.allownomd = false;
            return;
        }
        if ("optional".equals(string)) {
            this.allownomd = true;
            return;
        }
        throw new IllegalArgumentException("unknown descriptor rule '" + string + "'. Allowed rules are: " + Arrays.asList("required", "optional"));
    }

    public String[] getChecksumAlgorithms() {
        Object object = this.checksums == null ? this.getSettings().getVariable("ivy.checksums") : this.checksums;
        if (object == null) {
            return new String[0];
        }
        object = object.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < ((String[])object).length; ++i) {
            String string = object[i].trim();
            if ("".equals(string) || "none".equals(string)) continue;
            arrayList.add(string);
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static class UnresolvedDependencyException
    extends RuntimeException {
        private boolean error;

        public UnresolvedDependencyException() {
            this("", false);
        }

        public UnresolvedDependencyException(String string) {
            this(string, true);
        }

        public UnresolvedDependencyException(String string, boolean bl) {
            super(string);
            this.error = bl;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

