/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.FileEditorCompositeModel;
import com.jetbrains.rd.ide.model.FileEditorIdAndModel;
import com.jetbrains.rd.ide.model.FileEditorManagerEventModel;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.FileEditorsModel;
import com.jetbrains.rd.ide.model.FileEditorsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.OpenWithFocusRequest;
import com.jetbrains.rd.ide.model.OriginKind;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdate;
import com.jetbrains.rd.platform.util.RdCoroutinesUtilKt;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.UtilsKt;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rdclient.vfs.FrontendVirtualFileManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0004>?@AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J(\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020(H\u0002J0\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u00020 2\u0006\u00106\u001a\u00020 H\u0002J(\u00107\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00108\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020+2\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020=H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "bottomComponentsStorage", "", "", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "compositeToId", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "fileEditorsModel", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "getFileEditorsModel", "()Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "selectionChange", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "topComponentsStorage", "addComponent", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "composite", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "componentId", "beControl", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "isTop", "", "bindComposite", "compositeId", "compositeModel", "Lcom/jetbrains/rd/ide/model/FileEditorCompositeModel;", "bindFileEditor", "editorLifetime", "model", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "closeFileWithCopies", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorId", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "editorModel", "openComposite", "compositeModelLifetime", "requestFocus", "selectAsCurrent", "removeComponent", "requestCompositeFromBackendSync", "project", "Lcom/intellij/openapi/project/Project;", "sendSelection", "eventModel", "Lcom/jetbrains/rd/ide/model/FileEditorManagerEventModel;", "Companion", "ComponentInfo", "MyFileEditorManagerListener", "MyProtocolListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n1747#2,3:262\n1549#2:273\n1620#2,2:274\n1622#2:280\n53#3,4:265\n53#3,4:269\n53#3,4:276\n53#3,4:281\n11#3:285\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n*L\n115#1:262,3\n121#1:273\n121#1:274,2\n121#1:280\n117#1:265,4\n120#1:269,4\n122#1:276,4\n126#1:281,4\n56#1:285\n*E\n"})
public final class FrontendFileEditorHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final ConcurrentMap<EditorComposite, RdFileEditorCompositeId> compositeToId;
    @NotNull
    private final Map<String, ComponentInfo> topComponentsStorage;
    @NotNull
    private final Map<String, ComponentInfo> bottomComponentsStorage;
    @NotNull
    private final UpdateFlag selectionChange;
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, RdFileEditorId> fileEditorId$delegate = UserDataHolderKt.userData((String)"frontendModelId");
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakIdentityMap(...)");
        this.compositeToId = concurrentMap;
        this.topComponentsStorage = new LinkedHashMap();
        this.bottomComponentsStorage = new LinkedHashMap();
        this.selectionChange = new UpdateFlag();
    }

    private final FileEditorsModel getFileEditorsModel() {
        return FileEditorsModel_GeneratedKt.getFileEditorsModel((Solution)FrontendSessionsUtilKt.getProtocolModel(this.session));
    }

    private final void closeFileWithCopies(RdFileId fileId) {
        VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile(fileId);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.session.getProject());
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        manager.closeFile(file, true, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void openComposite(Lifetime compositeModelLifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, boolean requestFocus, boolean selectAsCurrent) {
        boolean existingEditor2;
        FrontendFileEditorManager fileEditorManager;
        VirtualFile file;
        block10: {
            VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile(compositeId.getFileId());
            Intrinsics.checkNotNull((Object)virtualFile);
            file = virtualFile;
            Project project = this.session.getProject();
            fileEditorManager = FrontendFileEditorManager.Companion.getInstance(project);
            Iterable $this$any$iv = fileEditorManager.getAllComposites(file);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorComposite it = (EditorComposite)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(this.compositeToId.get(it), (Object)compositeId)) continue;
                    v1 = true;
                    break block10;
                }
                v1 = existingEditor2 = false;
            }
        }
        if (existingEditor2) {
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] openComposite: opening existing editor. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
            }
            fileEditorManager.openFile(file, requestFocus);
        } else {
            void $this$mapTo$iv$iv;
            Object object;
            Object element$iv;
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                object.trace("[file] openComposite: collect `editorsWithProviders` for " + compositeModel.getEditors().size() + " editors. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
            }
            Iterable $this$map$iv = compositeModel.getEditors();
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileEditorIdAndModel fileEditorIdAndModel = (FileEditorIdAndModel)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("[file] openComposite$map: call createEditorWithProvider(id=" + UtilKt.toDebugString((RdFileEditorId)it.getId()) + "))");
                }
                object.add(this.createEditorWithProvider(file, compositeModelLifetime, it.getId(), it.getModel()));
            }
            List editorsWithProviders = (List)destination$iv$iv;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                object.trace("[file] openComposite: call openFileFromBackend for collected `editorsWithProviders`");
            }
            fileEditorManager.openFileFromBackend$intellij_rd_client(file, editorsWithProviders, requestFocus, selectAsCurrent, (Function1<? super EditorComposite, Unit>)((Function1)new Function1<EditorComposite, Unit>(this, compositeModelLifetime, compositeId, compositeModel){
                final /* synthetic */ FrontendFileEditorHost this$0;
                final /* synthetic */ Lifetime $compositeModelLifetime;
                final /* synthetic */ RdFileEditorCompositeId $compositeId;
                final /* synthetic */ FileEditorCompositeModel $compositeModel;
                {
                    this.this$0 = $receiver;
                    this.$compositeModelLifetime = $compositeModelLifetime;
                    this.$compositeId = $compositeId;
                    this.$compositeModel = $compositeModel;
                    super(1);
                }

                public final void invoke(@NotNull EditorComposite it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Logger $this$trace$iv = FrontendFileEditorHost.access$getLOG$cp();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("[file] openComposite$openFileFromBackend: call bindComposite(...)");
                    }
                    FrontendFileEditorHost.access$bindComposite(this.this$0, this.$compositeModelLifetime, this.$compositeId, this.$compositeModel, it);
                }
            }));
        }
    }

    private final void bindComposite(Lifetime lifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, EditorComposite composite) {
        this.compositeToId.put(composite, compositeId);
        lifetime.onTermination((Function0)new Function0<Unit>(this, composite){
            final /* synthetic */ FrontendFileEditorHost this$0;
            final /* synthetic */ EditorComposite $composite;
            {
                this.this$0 = $receiver;
                this.$composite = $composite;
                super(0);
            }

            public final void invoke() {
                FrontendFileEditorHost.access$getCompositeToId$p(this.this$0).remove(this.$composite);
                if (!Disposer.isDisposed((Disposable)((Disposable)this.$composite))) {
                    FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(FrontendFileEditorHost.access$getSession$p(this.this$0).getAppSession());
                    ReenterabilityKt.noReenter((Object)textControlHost.getEditorIsReleasingLock(), (Function0)((Function0)new Function0<Unit>(this.this$0, this.$composite){
                        final /* synthetic */ FrontendFileEditorHost this$0;
                        final /* synthetic */ EditorComposite $composite;
                        {
                            this.this$0 = $receiver;
                            this.$composite = $composite;
                            super(0);
                        }

                        public final void invoke() {
                            FrontendFileEditorManager.Companion.getInstance(FrontendFileEditorHost.access$getSession$p(this.this$0).getProject()).closeFile$intellij_rd_client(this.$composite);
                        }
                    }));
                }
            }
        });
        Disposer.register((Disposable)((Disposable)composite), () -> FrontendFileEditorHost.bindComposite$lambda$6(this, compositeId));
        for (Pair pair : CollectionsKt.zip((Iterable)composite.getAllEditors(), (Iterable)compositeModel.getEditors())) {
            FileEditor editor2 = (FileEditor)pair.component1();
            FileEditorIdAndModel editorModel = (FileEditorIdAndModel)pair.component2();
            this.bindFileEditor(lifetime, composite, editor2, editorModel.getModel());
        }
        compositeModel.getDynamicallyAddedEditors().getChange().advise(lifetime, (Function1)new Function1<IViewableList.Event<? extends FileEditorIdAndModel>, Unit>(this, composite, lifetime){
            final /* synthetic */ FrontendFileEditorHost this$0;
            final /* synthetic */ EditorComposite $composite;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.this$0 = $receiver;
                this.$composite = $composite;
                this.$lifetime = $lifetime;
                super(1);
            }

            public final void invoke(@NotNull IViewableList.Event<FileEditorIdAndModel> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (!(event instanceof IViewableList.Event.Add)) {
                    return;
                }
                RdFileEditorId editorId = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getId();
                FileEditorModel editorModel = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getModel();
                FileEditorWithProvider editorWithProvider = FrontendFileEditorHost.access$createEditorWithProvider(this.this$0, this.$composite.getFile(), this.$lifetime, editorId, editorModel);
                FileEditor fileEditor = editorWithProvider.getFileEditor();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"getFileEditor(...)");
                FileEditor editor2 = fileEditor;
                FileEditorProvider fileEditorProvider = editorWithProvider.getProvider();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorProvider, (String)"getProvider(...)");
                FileEditorProvider provider2 = fileEditorProvider;
                this.$composite.addEditor(editor2, provider2);
                FrontendFileEditorHost.access$bindFileEditor(this.this$0, this.$lifetime, this.$composite, editor2, editorModel);
            }
        });
        UtilsKt.showingProperty((Component)composite.getComponent()).advise(lifetime, (Function1)new Function1<Boolean, Unit>(compositeModel){
            final /* synthetic */ FileEditorCompositeModel $compositeModel;
            {
                this.$compositeModel = $compositeModel;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$compositeModel.getVisible().set((Object)it);
            }
        });
    }

    private final FileEditorWithProvider createEditorWithProvider(VirtualFile file, Lifetime editorLifetime, RdFileEditorId editorId, FileEditorModel editorModel) {
        Object object = FrontendFileEditorModelHandler.Companion.getEP().findFirstSafe(arg_0 -> FrontendFileEditorHost.createEditorWithProvider$lambda$7((Function1)new Function1<FrontendFileEditorModelHandler, Boolean>(this, file, editorModel){
            final /* synthetic */ FrontendFileEditorHost this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ FileEditorModel $editorModel;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$editorModel = $editorModel;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FrontendFileEditorModelHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.accept(FrontendFileEditorHost.access$getSession$p(this.this$0).getProject(), this.$file, this.$editorModel);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)object);
        FrontendFileEditorModelHandler handler2 = (FrontendFileEditorModelHandler)object;
        FileEditorWithProvider editorWithProvider = handler2.createEditorWithProvider(this.session.getProject(), editorLifetime, file, editorModel);
        FileEditor fileEditor = editorWithProvider.getFileEditor();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"getFileEditor(...)");
        FrontendFileEditorHost.Companion.setFileEditorId(fileEditor, editorId);
        editorLifetime.onTermination((Function0)new Function0<Unit>(editorWithProvider){
            final /* synthetic */ FileEditorWithProvider $editorWithProvider;
            {
                this.$editorWithProvider = $editorWithProvider;
                super(0);
            }

            public final void invoke() {
                FileEditor fileEditor = this.$editorWithProvider.getFileEditor();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"getFileEditor(...)");
                com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost$Companion.access$setFileEditorId(FrontendFileEditorHost.Companion, fileEditor, null);
            }
        });
        return editorWithProvider;
    }

    private final void bindFileEditor(Lifetime editorLifetime, EditorComposite composite, FileEditor editor2, FileEditorModel model) {
        FileEditorModel fileEditorModel;
        FileEditorModel $this$bindFileEditor_u24lambda_u248 = fileEditorModel = model;
        boolean bl = false;
        $this$bindFileEditor_u24lambda_u248.getName().getChange().advise(editorLifetime, (Function1)new Function1<String, Unit>(composite, editor2){
            final /* synthetic */ EditorComposite $composite;
            final /* synthetic */ FileEditor $editor;
            {
                this.$composite = $composite;
                this.$editor = $editor;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$composite.setDisplayName(this.$editor, it);
            }
        });
        Function1 processUpdate2 = (Function1)new Function1<TopBottomComponentUpdate, Object>(this, composite, editor2, editorLifetime){
            final /* synthetic */ FrontendFileEditorHost this$0;
            final /* synthetic */ EditorComposite $composite;
            final /* synthetic */ FileEditor $editor;
            final /* synthetic */ Lifetime $editorLifetime;
            {
                this.this$0 = $receiver;
                this.$composite = $composite;
                this.$editor = $editor;
                this.$editorLifetime = $editorLifetime;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull TopBottomComponentUpdate update2) {
                Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                return switch (bindFileEditor.1.processUpdate.WhenMappings.$EnumSwitchMapping$0[update2.getUpdateType().ordinal()]) {
                    case 1 -> {
                        BeControl v0 = update2.getBeControl();
                        if (v0 != null) {
                            BeControl var2_2 = v0;
                            FrontendFileEditorHost var3_3 = this.this$0;
                            Lifetime var4_4 = this.$editorLifetime;
                            EditorComposite var5_5 = this.$composite;
                            FileEditor var6_6 = this.$editor;
                            BeControl beControl = var2_2;
                            boolean $i$a$-also-FrontendFileEditorHost$bindFileEditor$1$processUpdate$1$1 = false;
                            FrontendFileEditorHost.access$addComponent(var3_3, var4_4, var5_5, var6_6, update2.getComponentId(), beControl, update2.isTop());
                            yield var2_2;
                        }
                        yield null;
                    }
                    case 2 -> {
                        FrontendFileEditorHost.access$removeComponent(this.this$0, this.$composite, this.$editor, update2.getComponentId(), update2.isTop());
                        yield Unit.INSTANCE;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        };
        $this$bindFileEditor_u24lambda_u248.getTopBottomComponentsUpdates().view(editorLifetime, (Function2)new Function2<Lifetime, TopBottomComponentUpdate[], Unit>((Function1<? super TopBottomComponentUpdate, ? extends Object>)processUpdate2){
            final /* synthetic */ Function1<TopBottomComponentUpdate, Object> $processUpdate;
            {
                this.$processUpdate = $processUpdate;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Lifetime lifetime, @NotNull TopBottomComponentUpdate[] updates) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
                TopBottomComponentUpdate[] topBottomComponentUpdateArray = updates;
                Function1<TopBottomComponentUpdate, Object> function1 = this.$processUpdate;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    function1.invoke((Object)it);
                }
            }
        });
    }

    private final void addComponent(Lifetime lifetime, EditorComposite composite, FileEditor editor2, String componentId, BeControl beControl, boolean isTop) {
        LifetimeDefinition componentLifetime = lifetime.createNested();
        JComponent panel2 = ViewRegistryKt.getView((BeControl)beControl, (Lifetime)((Lifetime)componentLifetime));
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        storage.put(componentId, new ComponentInfo(panel2, componentLifetime));
        EditorComposite $this$addComponent_u24lambda_u249 = composite;
        boolean bl = false;
        if (isTop) {
            $this$addComponent_u24lambda_u249.addTopComponent(editor2, panel2);
        } else {
            $this$addComponent_u24lambda_u249.addBottomComponent(editor2, panel2);
        }
    }

    private final void removeComponent(EditorComposite composite, FileEditor editor2, String componentId, boolean isTop) {
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        ComponentInfo componentInfo = storage.remove(componentId);
        if (componentInfo == null) {
            return;
        }
        ComponentInfo componentInfo2 = componentInfo;
        JComponent panel2 = componentInfo2.component1();
        LifetimeDefinition lifetime = componentInfo2.component2();
        EditorComposite $this$removeComponent_u24lambda_u2410 = composite;
        boolean bl = false;
        if (isTop) {
            $this$removeComponent_u24lambda_u2410.removeTopComponent(editor2, panel2);
        } else {
            $this$removeComponent_u24lambda_u2410.removeBottomComponent(editor2, panel2);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetime, (boolean)false, (int)1, null);
    }

    private final void sendSelection(FileEditorManagerEventModel eventModel) {
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)this.selectionChange, (Function0)((Function0)new Function0<Unit>(this, eventModel){
            final /* synthetic */ FrontendFileEditorHost this$0;
            final /* synthetic */ FileEditorManagerEventModel $eventModel;
            {
                this.this$0 = $receiver;
                this.$eventModel = $eventModel;
                super(0);
            }

            public final void invoke() {
                FrontendFileEditorHost.access$getFileEditorsModel(this.this$0).getSelectionChanged().fire((Object)this.$eventModel);
            }
        }));
    }

    @Nullable
    public final RdFileEditorCompositeId requestCompositeFromBackendSync(@NotNull RdFileId fileId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IProtocol protocol = IdeBackend.Companion.getInstance(project).getProtocol();
        return (RdFileEditorCompositeId)ExtensionsKt.callSynchronously$default((IRdCall)this.getFileEditorsModel().getRequestComposite(), fileId, protocol, null, RpcTimeouts.Companion.getDefault(), null, 20, null);
    }

    private static final void bindComposite$lambda$6(FrontendFileEditorHost this$0, RdFileEditorCompositeId $compositeId) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$compositeId, (String)"$compositeId");
        this$0.getFileEditorsModel().getComposites().remove((Object)$compositeId);
    }

    private static final boolean createEditorWithProvider$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$openComposite(FrontendFileEditorHost $this, Lifetime compositeModelLifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, boolean requestFocus, boolean selectAsCurrent) {
        $this.openComposite(compositeModelLifetime, compositeId, compositeModel, requestFocus, selectAsCurrent);
    }

    public static final /* synthetic */ void access$closeFileWithCopies(FrontendFileEditorHost $this, RdFileId fileId) {
        $this.closeFileWithCopies(fileId);
    }

    public static final /* synthetic */ void access$bindComposite(FrontendFileEditorHost $this, Lifetime lifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, EditorComposite composite) {
        $this.bindComposite(lifetime, compositeId, compositeModel, composite);
    }

    public static final /* synthetic */ ConcurrentMap access$getCompositeToId$p(FrontendFileEditorHost $this) {
        return $this.compositeToId;
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(FrontendFileEditorHost $this) {
        return $this.session;
    }

    public static final /* synthetic */ FileEditorWithProvider access$createEditorWithProvider(FrontendFileEditorHost $this, VirtualFile file, Lifetime editorLifetime, RdFileEditorId editorId, FileEditorModel editorModel) {
        return $this.createEditorWithProvider(file, editorLifetime, editorId, editorModel);
    }

    public static final /* synthetic */ void access$bindFileEditor(FrontendFileEditorHost $this, Lifetime editorLifetime, EditorComposite composite, FileEditor editor2, FileEditorModel model) {
        $this.bindFileEditor(editorLifetime, composite, editor2, model);
    }

    public static final /* synthetic */ FileEditorsModel access$getFileEditorsModel(FrontendFileEditorHost $this) {
        return $this.getFileEditorsModel();
    }

    public static final /* synthetic */ void access$removeComponent(FrontendFileEditorHost $this, EditorComposite composite, FileEditor editor2, String componentId, boolean isTop) {
        $this.removeComponent(composite, editor2, componentId, isTop);
    }

    public static final /* synthetic */ void access$addComponent(FrontendFileEditorHost $this, Lifetime lifetime, EditorComposite composite, FileEditor editor2, String componentId, BeControl beControl, boolean isTop) {
        $this.addComponent(lifetime, composite, editor2, componentId, beControl, isTop);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileEditorHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "<set-?>", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "fileEditorId", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "setFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/jetbrains/rd/ide/model/RdFileEditorId;)V", "fileEditorId$delegate", "Lkotlin/properties/ReadWriteProperty;", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "getEditor", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n31#2,2:262\n1#3:264\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n*L\n47#1:262,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendFileEditorHost> serviceClass$iv = FrontendFileEditorHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendFileEditorHost)((Object)object);
        }

        @Nullable
        public final RdFileEditorId getFileEditorId(@NotNull FileEditor $this$fileEditorId) {
            Intrinsics.checkNotNullParameter((Object)$this$fileEditorId, (String)"<this>");
            return (RdFileEditorId)fileEditorId$delegate.getValue((Object)$this$fileEditorId, $$delegatedProperties[0]);
        }

        private final void setFileEditorId(FileEditor $this$fileEditorId, RdFileEditorId rdFileEditorId) {
            fileEditorId$delegate.setValue((Object)$this$fileEditorId, $$delegatedProperties[0], (Object)rdFileEditorId);
        }

        private final FileEditor getEditor(EditorComposite $this$getEditor, RdFileEditorId fileEditorId) {
            Object v0;
            block1: {
                Iterable iterable = $this$getEditor.getAllEditors();
                for (Object t : iterable) {
                    FileEditor it = (FileEditor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)Companion.getFileEditorId(it), (Object)fileEditorId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "fileEditorId", "getFileEditorId(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "", "component", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getComponent", "()Ljavax/swing/JComponent;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rd.client"})
    private static final class ComponentInfo {
        @NotNull
        private final JComponent component;
        @NotNull
        private final LifetimeDefinition lifetime;

        public ComponentInfo(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.component = component;
            this.lifetime = lifetime;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetime;
        }

        @NotNull
        public final ComponentInfo copy(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return new ComponentInfo(component, lifetime);
        }

        public static /* synthetic */ ComponentInfo copy$default(ComponentInfo componentInfo, JComponent jComponent, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = componentInfo.component;
            }
            if ((n & 2) != 0) {
                lifetimeDefinition = componentInfo.lifetime;
            }
            return componentInfo.copy(jComponent, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "ComponentInfo(component=" + this.component + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = result2 * 31 + this.lifetime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo componentInfo = (ComponentInfo)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)componentInfo.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetime, (Object)componentInfo.lifetime);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.rd.client"})
    public static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FileEditor fileEditor = event.getOldEditor();
            RdFileEditorId oldEditorId = fileEditor != null ? Companion.getFileEditorId(fileEditor) : null;
            FileEditor fileEditor2 = event.getNewEditor();
            RdFileEditorId newEditorId = fileEditor2 != null ? Companion.getFileEditorId(fileEditor2) : null;
            FileEditorManagerEventModel eventModel = new FileEditorManagerEventModel(OriginKind.Frontend, oldEditorId, newEditorId);
            Project project = event.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project)).sendSelection(eventModel);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n53#2,4:262\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n*L\n68#1:262,4\n*E\n"})
    public static final class MyProtocolListener
    implements SolutionExtListener<FileEditorsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FileEditorsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: before launchOnEdtAndStartImmediatelyIfEdt");
            }
            RdCoroutinesUtilKt.launchOnEdtAndStartImmediatelyIfEdt((Lifetime)lifetime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, model, lifetime, null){
                int label;
                final /* synthetic */ ClientProjectSession $session;
                final /* synthetic */ FileEditorsModel $model;
                final /* synthetic */ Lifetime $lifetime;
                {
                    this.$session = $session;
                    this.$model = $model;
                    this.$lifetime = $lifetime;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$trace$iv = FrontendFileEditorHost.access$getLOG$cp();
                            $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                var5_5 = $this$trace$iv;
                                $i$a$-trace-FrontendFileEditorHost$MyProtocolListener$extensionCreated$2$1 = false;
                                var5_5.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: await necessary subscriptions");
                            }
                            this.label = 1;
                            v0 = FrontendDocumentHost.Companion.getInstance(this.$session.getAppSession()).awaitProtocolSubscriptionsReady((Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            $this$trace$iv = FrontendFileEditorHost.access$getLOG$cp();
                            $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                var5_5 = $this$trace$iv;
                                $i$a$-trace-FrontendFileEditorHost$MyProtocolListener$extensionCreated$2$2 = false;
                                var5_5.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.composites` model");
                            }
                            this.$model.getComposites().view(this.$lifetime, (Function2)new Function2<Lifetime, Map.Entry<? extends RdFileEditorCompositeId, ? extends FileEditorCompositeModel>, Unit>(this.$session){
                                final /* synthetic */ ClientProjectSession $session;
                                {
                                    this.$session = $session;
                                    super(2);
                                }

                                public final void invoke(@NotNull Lifetime compositeLifetime, @NotNull Map.Entry<RdFileEditorCompositeId, FileEditorCompositeModel> entry) {
                                    Intrinsics.checkNotNullParameter((Object)compositeLifetime, (String)"compositeLifetime");
                                    Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 1>");
                                    RdFileEditorCompositeId compositeId = entry.getKey();
                                    FileEditorCompositeModel compositeModel = entry.getValue();
                                    Logger $this$trace$iv = FrontendFileEditorHost.access$getLOG$cp();
                                    boolean $i$f$trace = false;
                                    if ($this$trace$iv.isTraceEnabled()) {
                                        Logger logger = $this$trace$iv;
                                        boolean bl = false;
                                        logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `compositeModel.openWithFocus` signal");
                                    }
                                    compositeModel.getOpenWithFocus().advise(compositeLifetime, (Function1)new Function1<OpenWithFocusRequest, Unit>(this.$session, compositeLifetime, compositeId, compositeModel){
                                        final /* synthetic */ ClientProjectSession $session;
                                        final /* synthetic */ Lifetime $compositeLifetime;
                                        final /* synthetic */ RdFileEditorCompositeId $compositeId;
                                        final /* synthetic */ FileEditorCompositeModel $compositeModel;
                                        {
                                            this.$session = $session;
                                            this.$compositeLifetime = $compositeLifetime;
                                            this.$compositeId = $compositeId;
                                            this.$compositeModel = $compositeModel;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull OpenWithFocusRequest it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            FrontendFileEditorHost.access$openComposite(FrontendFileEditorHost.Companion.getInstance(this.$session), this.$compositeLifetime, this.$compositeId, this.$compositeModel, it.getRequestFocus(), it.getSelectAsCurrent());
                                        }
                                    });
                                }
                            });
                            $this$trace$iv = FrontendFileEditorHost.access$getLOG$cp();
                            $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                var5_5 = $this$trace$iv;
                                $i$a$-trace-FrontendFileEditorHost$MyProtocolListener$extensionCreated$2$4 = false;
                                var5_5.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.closeFileWithCopies` model");
                            }
                            this.$model.getCloseFileWithCopies().advise(this.$lifetime, (Function1)new Function1<RdFileId, Unit>(this.$session){
                                final /* synthetic */ ClientProjectSession $session;
                                {
                                    this.$session = $session;
                                    super(1);
                                }

                                public final void invoke(@NotNull RdFileId fileId) {
                                    Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
                                    FrontendFileEditorHost.access$closeFileWithCopies(FrontendFileEditorHost.Companion.getInstance(this.$session), fileId);
                                }
                            });
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }
}

