/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfo;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemKt;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0016\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "addFoldRegion", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "h", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/DocRenderInfo;", "addFoldings", "", "newHighlighters", "", "afterBulkAdd", "highlighters", "", "afterUpdated", "highlighter", "beforeBulkRemove", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocRenderModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocRenderModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n766#2:70\n857#2,2:71\n766#2:73\n857#2,2:74\n11#3:76\n*S KotlinDebug\n*F\n+ 1 FrontendDocRenderModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter\n*L\n23#1:70\n23#1:71,2\n46#1:73\n46#1:74,2\n17#1:76\n*E\n"})
public final class FrontendDocRenderModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final FoldingModelImpl foldingModel;
    @NotNull
    private static final Logger logger;

    public FrontendDocRenderModelAdapter(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable $this$filter$iv = highlighters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
            boolean bl = false;
            if (!(DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renderedDocs = (List)destination$iv$iv;
        if (renderedDocs.isEmpty()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperation(() -> FrontendDocRenderModelAdapter.afterBulkAdd$lambda$1(this, renderedDocs));
    }

    @Override
    public void afterUpdated(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        DocRenderInfo docRenderInfo = DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)highlighter2);
        if (docRenderInfo == null) {
            return;
        }
        DocRenderInfo info2 = docRenderInfo;
        CustomFoldRegion customFoldRegion = info2.getRegion();
        if (customFoldRegion == null) {
            return;
        }
        CustomFoldRegion region = customFoldRegion;
        GutterIconRenderer gutterIconRenderer = info2.getGutterRenderer();
        if (gutterIconRenderer != null) {
            FrontendDocRenderItemKt.setVisible(gutterIconRenderer, false);
        }
        CustomFoldRegionRenderer customFoldRegionRenderer = region.getRenderer();
        Intrinsics.checkNotNull((Object)customFoldRegionRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.documentation.render.DocRenderer");
        DocRenderItem docRenderItem = ((DocRenderer)customFoldRegionRenderer).getItem();
        Intrinsics.checkNotNull((Object)docRenderItem, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem");
        ((FrontendDocRenderItem)docRenderItem).setRenderer(info2.getGutterRenderer());
        region.update();
    }

    private final void addFoldings(Collection<? extends RangeHighlighterEx> newHighlighters) {
        for (RangeHighlighterEx rangeHighlighterEx : newHighlighters) {
            DocRenderInfo info2;
            if (DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)rangeHighlighterEx) == null) continue;
            CustomFoldRegion customFoldRegion = this.addFoldRegion(rangeHighlighterEx, info2);
            if (customFoldRegion == null) continue;
            info2.setRegion(customFoldRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable $this$filter$iv = highlighters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
            boolean bl = false;
            if (!(DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renderedDocs = (List)destination$iv$iv;
        if (renderedDocs.isEmpty()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperation(() -> FrontendDocRenderModelAdapter.beforeBulkRemove$lambda$4(renderedDocs, this));
    }

    private final CustomFoldRegion addFoldRegion(RangeHighlighterEx h, DocRenderInfo info2) {
        DocRenderItemManager docRenderItemManager = DocRenderItemManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)docRenderItemManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager");
        FrontendDocRenderItemManager manager = (FrontendDocRenderItemManager)docRenderItemManager;
        CustomFoldRegion newRegion = manager.addFolding(this.editor, info2, h);
        if (newRegion == null) {
            logger.warn("Unable to insert (" + h + ".startOffset, " + h + ".endOffset) in the folding tree");
            return null;
        }
        return newRegion;
    }

    private static final void afterBulkAdd$lambda$1(FrontendDocRenderModelAdapter this$0, List $renderedDocs) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$renderedDocs, (String)"$renderedDocs");
        this$0.addFoldings($renderedDocs);
    }

    private static final void beforeBulkRemove$lambda$4(List $renderedDocs, FrontendDocRenderModelAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)$renderedDocs, (String)"$renderedDocs");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (RangeHighlighterEx h : $renderedDocs) {
            FrontendDocRenderItem it;
            DocRenderInfo info2;
            if (DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)h) == null) continue;
            CustomFoldRegion customFoldRegion = info2.getRegion();
            if (customFoldRegion == null) continue;
            this$0.foldingModel.removeFoldRegion((FoldRegion)customFoldRegion);
            DocRenderItemManager docRenderItemManager = DocRenderItemManager.Companion.getInstance();
            Intrinsics.checkNotNull((Object)docRenderItemManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager");
            if (((FrontendDocRenderItemManager)docRenderItemManager).getItem(this$0.editor, info2.getId()) == null) continue;
            boolean bl = false;
            it.setFoldRegion(null);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendEditorFoldingModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDocRenderModelAdapter.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

