/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.MarkupListenerAggregator;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005J&\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002R\"\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerManager;", "", "()V", "_aggregators", "", "Lcom/intellij/openapi/project/Project;", "", "Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator;", "aggregatorsForAllProjects", "", "getAggregatorsForAllProjects", "()Ljava/util/List;", "attachAggregator", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "aggregator", "attachListener", "editor", "Lcom/intellij/openapi/editor/Editor;", "listener", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "getAggregators", "project", "performWhenLoaded", "action", "Lkotlin/Function0;", "Companion", "intellij.rd.client"})
public final class MarkupListenerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Project, List<MarkupListenerAggregator>> _aggregators = new LinkedHashMap();

    @NotNull
    public final List<MarkupListenerAggregator> getAggregators(@Nullable Project project) {
        List list = this._aggregators.get(project);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<MarkupListenerAggregator> getAggregatorsForAllProjects() {
        return CollectionsKt.flatten((Iterable)this._aggregators.values());
    }

    public final void attachAggregator(@NotNull Lifetime lifetime, @NotNull MarkupListenerAggregator aggregator) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        List list = this._aggregators.get(aggregator.getProject());
        if (list == null) {
            boolean bl = false;
            Project project = aggregator.getProject();
            if (project == null || (project = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project))) == null) {
                project = Lifetime.Companion.getEternal();
            }
            Project projectLifetime = project;
            list = (List)CollectionExKt.addUnique(this._aggregators, (Lifetime)projectLifetime, (Object)aggregator.getProject(), (Object)new ArrayList());
        }
        List aggregators = list;
        CollectionExKt.addUnique((Collection)aggregators, (Lifetime)lifetime, (Object)aggregator);
        ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null)).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(aggregator, this){
            final /* synthetic */ MarkupListenerAggregator $aggregator;
            final /* synthetic */ MarkupListenerManager this$0;
            {
                this.$aggregator = $aggregator;
                this.this$0 = $receiver;
            }

            public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (!Intrinsics.areEqual((Object)editor2.getDocument(), (Object)this.$aggregator.getDocument())) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)this.$aggregator.getProject())) {
                    return;
                }
                if (!this.$aggregator.canHandleEditor((EditorImpl)editor2)) {
                    return;
                }
                MarkupListenerManager.access$performWhenLoaded(this.this$0, lifetime, editor2, (Function0)new Function0<Unit>(this.$aggregator, editor2, lifetime){
                    final /* synthetic */ MarkupListenerAggregator $aggregator;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Lifetime $lifetime;
                    {
                        this.$aggregator = $aggregator;
                        this.$editor = $editor;
                        this.$lifetime = $lifetime;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.$aggregator.canHandleEditor((EditorImpl)this.$editor)) {
                            return;
                        }
                        this.$aggregator.handleEditor(this.$lifetime, (EditorImpl)this.$editor);
                    }
                });
            }
        });
    }

    public final void attachListener(@NotNull Lifetime lifetime, @NotNull Editor editor2, @NotNull FrontendMarkupAdapterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.performWhenLoaded(lifetime, editor2, (Function0<Unit>)((Function0)new Function0<Unit>(editor2, listener2, lifetime){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ FrontendMarkupAdapterListener $listener;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.$editor = $editor;
                this.$listener = $listener;
                this.$lifetime = $lifetime;
                super(0);
            }

            public final void invoke() {
                FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.$editor);
                Intrinsics.checkNotNull((Object)frontendMarkupContributor);
                FrontendMarkupAdapter markupAdapter = frontendMarkupContributor.getMarkupAdapter();
                this.$listener.afterBulkAdd(ArraysKt.toList((Object[])markupAdapter.getAllHighlighters()));
                markupAdapter.addListener(this.$lifetime, this.$listener);
            }
        }));
    }

    private final void performWhenLoaded(Lifetime lifetime, Editor editor2, Function0<Unit> action2) {
        ApplicationManager.getApplication().invokeLater(() -> MarkupListenerManager.performWhenLoaded$lambda$2(editor2, lifetime, action2));
    }

    private static final void performWhenLoaded$lambda$2$lambda$1(Editor $editor, Lifetime $lifetime, Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        if ($editor.isDisposed() || RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
            return;
        }
        $action.invoke();
    }

    private static final void performWhenLoaded$lambda$2(Editor $editor, Lifetime $lifetime, Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        AsyncEditorLoader.Companion.performWhenLoaded($editor, () -> MarkupListenerManager.performWhenLoaded$lambda$2$lambda$1($editor, $lifetime, $action));
    }

    public static final /* synthetic */ void access$performWhenLoaded(MarkupListenerManager $this, Lifetime lifetime, Editor editor2, Function0 action2) {
        $this.performWhenLoaded(lifetime, editor2, (Function0<Unit>)action2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerManager$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerManager;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nMarkupListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupListenerManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,94:1\n42#2,3:95\n*S KotlinDebug\n*F\n+ 1 MarkupListenerManager.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerManager$Companion\n*L\n29#1:95,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkupListenerManager getInstance() {
            boolean $i$f$service = false;
            Class<MarkupListenerManager> serviceClass$iv = MarkupListenerManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (MarkupListenerManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

