/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.swagger;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.swagger.OpenApiPluginSuggestion;
import org.jetbrains.yaml.swagger.OpenApiSuggestionProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/yaml/swagger/OpenApiSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.yaml"})
public final class OpenApiSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML)) {
            return null;
        }
        if (OpenApiSuggestionProviderKt.access$isPluginSuggestionDismissed() || PluginAdvertiserServiceKt.tryUltimateIsDisabled()) {
            return null;
        }
        PluginId pluginId = PluginId.getId((String)"com.intellij.swagger");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId requiredPluginId = pluginId;
        if (PluginManager.isPluginInstalled((PluginId)requiredPluginId)) {
            return null;
        }
        String string = ApplicationInfoImpl.getShadowInstanceImpl().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String thisProductCode = string;
        boolean isOpenApiFile = OpenApiSuggestionProviderKt.access$detectOpenApiSpecification(project, file);
        if (!isOpenApiFile) {
            return null;
        }
        return new OpenApiPluginSuggestion(project, thisProductCode);
    }
}

