/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean myStartFailed;
    private final int myExitCode;
    private final boolean myAuthenticationFailed;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    @Nullable
    @Nls
    protected final String myRootName;

    public GitCommandResult(boolean startFailed, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(0);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(1);
        }
        this(startFailed, exitCode, errorOutput, output, null);
    }

    public GitCommandResult(boolean startFailed, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable @Nls String rootName) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(2);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(3);
        }
        this(startFailed, exitCode, false, errorOutput, output, rootName);
    }

    private GitCommandResult(boolean startFailed, int exitCode, boolean authenticationFailed, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable @Nls String rootName) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(4);
        }
        if (output == null) {
            GitCommandResult.$$$reportNull$$$0(5);
        }
        this.myExitCode = exitCode;
        this.myStartFailed = startFailed;
        this.myAuthenticationFailed = authenticationFailed;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myRootName = rootName;
    }

    @NotNull
    static GitCommandResult withAuthentication(@NotNull GitCommandResult result2, boolean authenticationFailed) {
        if (result2 == null) {
            GitCommandResult.$$$reportNull$$$0(6);
        }
        return new GitCommandResult(result2.myStartFailed, result2.myExitCode, authenticationFailed, result2.myErrorOutput, result2.myOutput, result2.myRootName);
    }

    public boolean success() {
        return this.success(new int[0]);
    }

    public boolean success(int ... ignoredErrorCodes) {
        return !this.myStartFailed && (Arrays.stream(ignoredErrorCodes).anyMatch(i -> i == this.myExitCode) || this.myExitCode == 0);
    }

    @NotNull
    public List<String> getOutput() {
        List<String> list2 = Collections.unmodifiableList(this.myOutput);
        if (list2 == null) {
            GitCommandResult.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public boolean isAuthenticationFailed() {
        return this.myAuthenticationFailed;
    }

    @NotNull
    public List<String> getErrorOutput() {
        List<String> list2 = Collections.unmodifiableList(this.myErrorOutput);
        if (list2 == null) {
            GitCommandResult.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    @NlsSafe
    @NlsContexts.NotificationContent
    public String getErrorOutputAsHtmlString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), XmlStringUtil::escapeString, (String)"<br/>");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getErrorOutputAsJoinedString() {
        String string = StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private List<String> getErrorOrStdOutput() {
        if (!this.myErrorOutput.isEmpty()) {
            List<String> list2 = this.myErrorOutput;
            if (list2 == null) {
                GitCommandResult.$$$reportNull$$$0(11);
            }
            return list2;
        }
        if (this.success()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                GitCommandResult.$$$reportNull$$$0(12);
            }
            return list3;
        }
        if (!this.myOutput.isEmpty()) {
            List<String> list4 = this.myOutput;
            if (list4 == null) {
                GitCommandResult.$$$reportNull$$$0(13);
            }
            return list4;
        }
        List<String> list5 = Collections.singletonList(GitBundle.message("git.error.exit", this.myExitCode));
        if (list5 == null) {
            GitCommandResult.$$$reportNull$$$0(14);
        }
        return list5;
    }

    @NotNull
    @NlsSafe
    public String getOutputAsJoinedString() {
        String string = StringUtil.join(this.myOutput, (String)"\n");
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getOutputOrThrow(int ... ignoredErrorCodes) throws VcsException {
        this.throwOnError(ignoredErrorCodes);
        String string = this.getOutputAsJoinedString();
        if (string == null) {
            GitCommandResult.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void throwOnError(int ... ignoredErrorCodes) throws VcsException {
        if (this.success(ignoredErrorCodes)) {
            return;
        }
        Object errorMessage = this.getErrorOutputAsJoinedString();
        if (this.myRootName != null) {
            errorMessage = "[" + this.myRootName + "] " + (String)errorMessage;
        }
        throw new VcsException((String)errorMessage);
    }

    @NotNull
    static GitCommandResult startError(@NotNull @Nls String error) {
        if (error == null) {
            GitCommandResult.$$$reportNull$$$0(17);
        }
        return new GitCommandResult(true, -1, Collections.singletonList(error), Collections.emptyList(), null);
    }

    @NotNull
    public static GitCommandResult error(@NotNull @Nls String error) {
        if (error == null) {
            GitCommandResult.$$$reportNull$$$0(18);
        }
        return new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList(), null);
    }

    @Deprecated
    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        if (errorOutput == null) {
            GitCommandResult.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.map(errorOutput, errorMessage -> GitUtil.cleanupErrorPrefixes(errorMessage));
        if (list2 == null) {
            GitCommandResult.$$$reportNull$$$0(20);
        }
        return list2;
    }

    protected boolean hasStartFailed() {
        return this.myStartFailed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorOutput";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitCommandResult";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutput";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsHtmlString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOutputAsJoinedString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorOrStdOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputAsJoinedString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputOrThrow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withAuthentication";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startError";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 20 -> new IllegalStateException(string);
        };
    }
}

